/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtUngrabKeyboard()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#ifdef XTESTEXTENSION
#include <X11/extensions/XTest.h>
#endif

XtAppContext app_ctext, app_context;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Widget click_pass, click_fail;

#ifdef XTESTEXTENSION
/*
** procedure XtTMO_Proc
*/
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
XEvent event;
	tet_infoline("ERROR: Timed out waiting for input");
	tet_result(TET_UNRESOLVED);
	exit(0);
}

static void analyse_events(TestWidget)
Widget TestWidget;
{
	Display *display;
	XEvent loop_event;
	Window window;
	Position rootx, rooty;
	 long event_mask;
	/* Event mask that will be set for all windows as they are exposed */
	/* Need key/button press/release plus whatever it takes to make the */
	/* widget work */
	event_mask = KeyPressMask | KeyReleaseMask |
			ButtonPressMask | ButtonReleaseMask |
			EnterWindowMask | LeaveWindowMask |
			ExposureMask | VisibilityChangeMask |
			VisibilityChangeMask;
				
	app_context = XtWidgetToApplicationContext(TestWidget);
	display = XtDisplay(TestWidget);
	window = XtWindow(TestWidget);
	/*
	** Poll events
	*/
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XtDispatchEvent(&loop_event);
	 if (loop_event.type == KeyPress) { 
		avs_set_event(1,1);
		if (loop_event.xkey.window == window) {
			avs_set_event(2,1);
		}
	 }
	 if (loop_event.type == KeyRelease) {
		avs_set_event(3,1);
		if (loop_event.xkey.window == window) {
			avs_set_event(4,1);
	 }
	tet_result(TET_PASS);
	exit(0);
	}
	if (loop_event.type == Expose) {
		if (loop_event.xexpose.window == window) {
			tet_infoline("TEST: Grab and ungrab keyboard");
			XtGrabKeyboard(TestWidget, FALSE, GrabModeAsync, GrabModeAsync, CurrentTime);
			XtUngrabKeyboard(TestWidget, CurrentTime);
			tet_infoline("PREP: Simulate user input");
			XtTranslateCoords(TestWidget, 0,0,&rootx, &rooty);
			XTestFakeMotionEvent(XtDisplay(TestWidget), -1, rootx-100, rooty, CurrentTime);
			XTestFakeKeyEvent(XtDisplay(TestWidget), XKeysymToKeycode(XtDisplay(TestWidget), 32), True, CurrentTime);
			XTestFakeKeyEvent(XtDisplay(TestWidget), XKeysymToKeycode(XtDisplay(TestWidget), 32), False, CurrentTime);
		}
		/* Make sure all windows get interesting events */
		XSelectInput(display, loop_event.xexpose.window, event_mask);
		}
	} /* end for */
}
#endif


#define T_XtUngrabKeyboard	1
char    *TestName = "XtUngrabKeyboard";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char label[80];
int status;
Widget labelw_msg;
char *msg = "This is the grab window\n";
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtUngrabKeyboard-1.(A)");
	report_assertion("A successful call to void XtUngrabKeyboard(widget, time)");
	report_assertion("shall cancel the active keyboard grab for the widget widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#ifdef XTESTEXTENSION
	FORK(pid2);
	xt_tomultiple=3;
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tunkybord1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Set up widget tree of depth eight (8) return panedw widget");
	panedw = (Widget) avs_xt_tree(topLevel);
	tet_infoline("PREP: Create boxw1 widget in panedw widget");
	boxw1 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Get the label widget name");
	strcpy(label, (char *)title("XtUngrabKeyboard") );
	sprintf(ebuf, "PREP: Create label: %s in boxw1 widget", label);
	tet_infoline(ebuf);
	labelw = (Widget) CreateLabelWidget(label, boxw1);
	tet_infoline("PREP: Create boxw2 widget in panedw widget");
	boxw2 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XSelectInput(XtDisplay(topLevel), XtWindow(topLevel), KeyPressMask|KeyReleaseMask);
	XtAppAddTimeOut(app_ctext, (unsigned long)5000, XtTMO_Proc, topLevel);
	analyse_events(labelw_msg);
	LKROF(pid2, (AVSXTTIMEOUT-2)*xt_tomultiple);
	tet_infoline("TEST: Events were not grabbed");
	status = avs_get_event(1);
	check_dec(1, status, "key press outside window count");
	status = avs_get_event(2);
	check_dec(0, status, "key press inside window count");
	status = avs_get_event(3);
	check_dec(1, status, "key release outside window count");
	status = avs_get_event(4);
	check_dec(0, status, "key release inside window count");
#else
	tet_infoline("INFO: XTEST extension not configured");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11431 */
/* End of included file Mdefcode.tmc.11431 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
