.\" Copyright 2009 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.ds xL Xlib \- C Language X Interface
.TH Compose __filemansuffix__ __vendorversion__
.SH NAME
Compose \- X client mappings for multi-key input sequences
.SH DESCRIPTION
The X library, libX11, provides a simple input method for characters
beyond those represented on typical keyboards using sequences of key
strokes that are combined to enter a single character.
.PP
The compose file is searched for in  the following order:
.IP -
If the environment variable
.B $XCOMPOSEFILE
is set, its value is used as the name of the Compose file.
.IP -
If the user's home directory has a file named
.IR .XCompose ,
it is used as the Compose file.
.IP -
The system provided compose file is used by mapping the locale to a compose
file from the list in
.IR __xlocaledir__/compose.dir .
.PP
Compose files can use an
.RB \*q include \*q
instruction.  This allows local modifications to be made to existing compose
files without including all of the content directly.  For example, the
system's iso8859-1 compose file can be included with a line like this:
.RS 4
.BI "include \*q" %S/iso8859-1/Compose \*q
.RE
.PP
There are several substitutions that can be made in the file name of the
include instruction:
.TP 4
.I %H
expands to the user's home directory (the
.B $HOME
environment variable)
.TP 4
.I %L
expands to the name of the locale specific Compose file (i.e.,
.RI \*q __xlocaledir__/<localename>/Compose \*q)
.TP 4
.I %S
expands to the name of the system directory for Compose files (i.e.,
.RI \*q __xlocaledir__ \*q)
.PP
For example, you can include in your compose file the default Compose file
by using:
.RS
.B "include \*q%L\*q"
.RE
and then rewrite only the few rules that you need to change.  New
compose rules can be added, and previous ones replaced.
.SH FILE FORMAT
.\" Based on grammar description in modules/im/ximcp/imLcPrs.c
Compose files are plain text files, with a separate line for each compose
sequence.   Comments begin with \fB#\fP characters.   Each compose sequence
specifies one or more events and a resulting input sequence, with an optional
comment at the end of the line:
.RS
\fIEVENT\fP [\fIEVENT\fP...] \fB:\fP \fIRESULT\fP [\fB#\fP \fICOMMENT\fP]
.RE
.PP
Each event consists of a specified input keysym, and optional modifier states:
.RS
[\fIMODIFIER_LIST\fP] \fB<\fP\fIkeysym\fP\fB>\fP
.RE
.PP
Each modifier consists of a specified modifier and a state:
.RS
(\fB!\fP \fIMODIFIER\fP ) | \fBNone\fP
.RE
Modifiers may be preceded by a
.RB \*q "~" \*q
character to indicate that the modifier must not be present.
.PP
The result specifies a string, keysym, or both, that the X client receives
as input when the sequence of events is input:
.RS
\fB\*q\fP\fISTRING\fP\fB\*q\fP | \fIkeysym\fP | \fB\*q\fP\fISTRING\fP\fB\*q\fP \fIkeysym\fP
.RE
.PP
Keysyms are specified without the \fBXK_\fP prefix.
.PP
Strings may be direct text encoded in the locale for which the compose file is
to be used, or an escaped octal or hexadecimal character code.   Octal codes
are specified as \fB\*q\\123\*q\fP and hexadecimal codes as
\fB\*q\\0x123a\*q\fP.
It is not necessary to specify in the right part of a rule a locale encoded
string in addition to the keysym name.  If the string is omitted, Xlib
figures it out from the keysym according to the current locale.
I.e., if a rule looks like:
.RS
\fB<dead_grave> <A> : \*q\\300\*q Agrave\fP
.RE
the result of the composition is always the letter with the "\\300"
code.  But if the rule is:
.RS
\fB<dead_grave> <A> : Agrave\fP
.RE
the result depends on how Agrave is mapped in the current locale.
.SH ENVIRONMENT
.TP
.B XCOMPOSEFILE
File to use for compose sequences.
.TP
.B XCOMPOSECACHE
Directory to use for caching compiled compose files.
.SH FILES
.TP
.I $HOME/.XCompose
User default compose file if XCOMPOSEFILE is not set.
.TP
.I __xlocaledir__/compose.dir
File listing the compose file path to use for each locale.
.TP
.I __xlocaledir__/<localemapping>/Compose
System default compose file for the locale, mapped via compose.dir.
.TP
.I /var/cache/libx11/compose/
System-wide cache directory for compiled compose files.
.TP
.I $HOME/.compose-cache/
Per-user cache directory for compiled compose files.
.SH SEE ALSO
.BR XLookupString (__libmansuffix__),
.BR XmbLookupString (__libmansuffix__),
.BR XwcLookupString (__libmansuffix__),
.BR Xutf8LookupString (__libmansuffix__),
.BR mkcomposecache (__appmansuffix__),
.BR locale (__miscmansuffix__).
.br
\fI\*(xL\fP
