.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbTranslateKeyCode __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbTranslateKeyCode \-  Translate a keycode to a key symbol and modifiers
.SH SYNOPSIS
.HP
.B Bool XkbTranslateKeyCode
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "KeyCode " "key" "\^,"
.BI "unsigned int " "mods" "\^,"
.BI "unsigned int *" "mods_rtrn" "\^,"
.BI "KeySym *" "keysym_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description to use for translation
.TP
.I \- key
keycode to translate
.TP
.I \- mods
modifiers to apply when translating key
.TP
.I \- mods_rtrn
backfilled with unconsumed modifiers
.TP
.I \- keysym_rtrn
keysym resulting from translation
.SH DESCRIPTION
.LP
.I mods_rtrn 
is backfilled with the modifiers consumed by the translation process. 
.I mods 
is a bitwise inclusive OR of the legal modifier masks: ShiftMask, LockMask, 
ControlMask, Mod1Mask, Mod2Mask, Mod3Mask, Mod4Mask, Mod5Mask.The 
AlwaysConsumeShiftAndLock library control (see below), if enabled, causes
.I XkbTranslateKeyCode 
to consume shift and lock. 
.I XkbTranslateKeyCode 
returns True if the translation resulted in a keysym, and False if it resulted 
in NoSymbol.

The AlwaysConsumeShiftAndLock control, if enabled, forces 
.I XLookupString 
to consume the Shift and Lock modifiers when processing all keys, even if the 
definition for the key type does not specify these modifiers. The 
AlwaysConsumeShiftAndLock control is unset by default. 
.SH "SEE ALSO"
.BR XLookupString (__libmansuffix__)
