.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAddSymInterpret __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAddSymInterpret \- Add a symbol interpretation to the list of symbol 
interpretations in an XkbCompatRec
.SH SYNOPSIS
.HP
.B XkbSymInterpretPtr XkbAddSymInterpret
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "XkbSymInterpretPtr " "si" "\^,"
.BI "Bool " "updateMap" "\^,"
.BI "XkbChangesPtr " "changes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description to be updated 
.TP
.I \- si
symbol interpretation to be added
.TP
.I \- updateMap
True=>apply compatibility map to keys
.TP
.I \- changes
changes are put here 
.SH DESCRIPTION
.LP
.I XkbAddSymInterpret 
adds 
.I si 
to the list of symbol interpretations in 
.I xkb. 
If 
.I updateMap 
is True, it (re)applies the compatibility map to all of the keys on the 
keyboard. If 
.I changes 
is non-NULL, it reports the parts of the keyboard that were affected (unless
.I updateMap 
is True, not much changes). 
.I XkbAddSymInterpret 
returns a pointer to the actual new symbol interpretation in the list or NULL if 
it failed.
