'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\"
.\" $XFree86: xc/doc/man/X11/XTLTTProp.man,v 1.6 2003/04/28 22:17:57 herrb Exp $
.\" $XdotOrg: lib/X11/man/XmbTextListToTextProperty.man,v 1.2 2004-04-23 18:42:09 eich Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" t
.TH XmbTextListToTextProperty __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XmbTextListToTextProperty, XwcTextListToTextProperty, Xutf8TextListToTextProperty, XmbTextPropertyToTextList, XwcTextPropertyToTextList, Xutf8TextPropertyToTextList, XwcFreeStringList, XDefaultString \- convert text lists and text property structures
.SH SYNTAX
.HP
int XmbTextListToTextProperty\^(\^Display *\fIdisplay\fP\^, char
**\fIlist\fP\^, int \fIcount\fP\^, XICCEncodingStyle \fIstyle\fP\^,
XTextProperty *\fItext_prop_return\fP\^); 
.HP
int XwcTextListToTextProperty\^(\^Display *\fIdisplay\fP\^, wchar_t
**\fIlist\fP\^, int \fIcount\fP\^, XICCEncodingStyle \fIstyle\fP\^,
XTextProperty *\fItext_prop_return\fP\^); 
.HP
int Xutf8TextListToTextProperty\^(\^Display *\fIdisplay\fP\^, char
**\fIlist\fP\^, int \fIcount\fP\^, XICCEncodingStyle \fIstyle\fP\^,
XTextProperty *\fItext_prop_return\fP\^); 
.HP
int XmbTextPropertyToTextList\^(\^Display *\fIdisplay\fP\^, XTextProperty
*\fItext_prop\fP\^, char ***\fIlist_return\fP\^, int *\fIcount_return\fP\^); 
.HP
int XwcTextPropertyToTextList\^(\^Display *\fIdisplay\fP\^, XTextProperty
*\fItext_prop\fP\^, wchar_t ***\fIlist_return\fP\^, int
*\fIcount_return\fP\^); 
.HP
int Xutf8TextPropertyToTextList\^(\^Display *\fIdisplay\fP\^, XTextProperty
*\fItext_prop\fP\^, char ***\fIlist_return\fP\^, int *\fIcount_return\fP\^); 
.HP
void XwcFreeStringList\^(\^wchar_t **\fIlist\fP\^); 
.HP
char *XDefaultString\^(void)
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIlist\fP 1i
Specifies a list of null-terminated character strings.
.IP \fIcount\fP 1i
Specifies the number of strings specified.
.IP \fIstyle\fP 1i
Specifies the manner in which the property is encoded.
.IP \fItext_prop_return\fP 1i
Returns the
.ZN XTextProperty
structure.
.IP \fItext_prop\fP 1i
Specifies the
.ZN XTextProperty
structure to be used.
.IP \fIlist_return\fP 1i
Returns a list of null-terminated character strings.
.ds Cn strings
.IP \fIcount_return\fP 1i
Returns the number of \*(Cn.
.IP \fIlist\fP 1i
Specifies the list of strings to be freed.
.SH DESCRIPTION
The
.ZN XmbTextListToTextProperty ,
.ZN XwcTextListToTextProperty
and
.ZN Xutf8TextListToTextProperty
functions set the specified 
.ZN XTextProperty
value to a set of null-separated elements representing the concatenation
of the specified list of null-terminated text strings. The input text
strings must be given in the current locale encoding (for
.ZN XmbTextListToTextProperty
and
.ZN XwcTextListToTextProperty ),
or in UTF-8 encoding (for
.ZN Xutf8TextListToTextProperty ).
.LP
The functions set the encoding field of text_prop_return to an
.ZN Atom 
for the specified display 
naming the encoding determined by the specified style
and convert the specified text list to this encoding for storage in
the text_prop_return value field.
If the style 
.ZN XStringStyle
or 
.ZN XCompoundTextStyle
is specified,
this encoding is ``STRING'' or ``COMPOUND_TEXT'', respectively.
If the style
.ZN XUTF8StringStyle
is specified,
this encoding is ``UTF8_STRING''. 
(This is an extension introduced by The XFree86 Project, Inc. in their 4.0.2
release. Its presence is indicated by the macro
.ZN X_HAVE_UTF8_STRING .)
If the style 
.ZN XTextStyle
is specified,
this encoding is the encoding of the current locale.
If the style 
.ZN XStdICCTextStyle
is specified,
this encoding is ``STRING'' if the text is fully convertible to STRING,
else ``COMPOUND_TEXT''.
A final terminating null byte is stored at the end of the value field 
of text_prop_return but is not included in the nitems member.
.LP
If insufficient memory is available for the new value string,
the functions return 
.ZN XNoMemory .
If the current locale is not supported,
the functions return 
.ZN XLocaleNotSupported .
In both of these error cases,
the functions do not set text_prop_return.
.LP
To determine if the functions are guaranteed not to return
.ZN XLocaleNotSupported ,
use
.ZN XSupportsLocale .
.LP
If the supplied text is not fully convertible to the specified encoding,
the functions return the number of unconvertible characters.
Each unconvertible character is converted to an implementation-defined and
encoding-specific default string.
Otherwise, the functions return 
.ZN Success .
Note that full convertibility to all styles except 
.ZN XStringStyle
is guaranteed.
.LP
To free the storage for the value field, use
.ZN XFree .
.LP
The 
.ZN XmbTextPropertyToTextList ,
.ZN XwcTextPropertyToTextList
and 
.ZN Xutf8TextPropertyToTextList
functions return a list of text strings representing the
null-separated elements of the specified
.ZN XTextProperty
structure. The returned strings are encoded using the current locale encoding
(for
.ZN XmbTextPropertyToTextList
and
.ZN XwcTextPropertyToTextList )
or in UTF-8 (for
.ZN Xutf8TextPropertyToTextList ).
The data in text_prop must be format 8.
.LP
Multiple elements of the property (for example, the strings in a disjoint
text selection) are separated by a null byte.
The contents of the property are not required to be null-terminated;
any terminating null should not be included in text_prop.nitems.
.LP
If insufficient memory is available for the list and its elements,
.ZN XmbTextPropertyToTextList ,
.ZN XwcTextPropertyToTextList
and
.ZN Xutf8TextPropertyToTextList
return 
.ZN XNoMemory .
If the current locale is not supported,
the functions return
.ZN XLocaleNotSupported .
Otherwise, if the encoding field of text_prop is not convertible 
to the encoding of the current locale,
the functions return
.ZN XConverterNotFound .
For supported locales,
existence of a converter from COMPOUND_TEXT, STRING, UTF8_STRING
or the encoding of the current locale is guaranteed if
.ZN XSupportsLocale 
returns 
.ZN True
for the current locale (but the actual text
may contain unconvertible characters).
Conversion of other encodings is implementation-dependent.
In all of these error cases,
the functions do not set any return values.
.LP
Otherwise, 
.ZN XmbTextPropertyToTextList ,
.ZN XwcTextPropertyToTextList
and
.ZN Xutf8TextPropertyToTextList
return the list of null-terminated text strings to list_return
and the number of text strings to count_return.
.LP
If the value field of text_prop is not fully convertible to the
encoding of the current locale,
the functions return the number of unconvertible characters.
Each unconvertible character is converted to a string in the
current locale that is specific to the current locale.
To obtain the value of this string, 
use
.ZN XDefaultString .
Otherwise,
.ZN XmbTextPropertyToTextList ,
.ZN XwcTextPropertyToTextList
and
.ZN Xutf8TextPropertyToTextList
return 
.ZN Success .
.LP
To free the storage for the list and its contents returned by
.ZN XmbTextPropertyToTextList
or
.ZN Xutf8TextPropertyToTextList ,
use
.ZN XFreeStringList .
To free the storage for the list and its contents returned by
.ZN XwcTextPropertyToTextList ,
use
.ZN XwcFreeStringList .
.LP
The
.ZN XwcFreeStringList
function frees memory allocated by
.ZN XwcTextPropertyToTextList .
.LP
The
.ZN XDefaultString
function returns the default string used by Xlib for text conversion
(for example, in 
.ZN XmbTextPropertyToTextList ).
The default string is the string in the current locale that is output 
when an unconvertible character is found during text conversion.
If the string returned by
.ZN XDefaultString
is the empty string ("\^"),
no character is output in the converted text.
.ZN XDefaultString
does not return NULL.
.LP
The string returned by 
.ZN XDefaultString
is independent of the default string for text drawing;
see 
.ZN XCreateFontSet
to obtain the default string for an
.ZN XFontSet .
.LP
The behavior when an invalid codepoint is supplied to any Xlib function is
undefined.
.LP
The returned string is null-terminated.
It is owned by Xlib and should not be modified or freed by the client.
It may be freed after the current locale is changed.
Until freed, it will not be modified by Xlib.
.LP
The functions
.ZN Xutf8TextListToTextProperty
and
.ZN Xutf8TextPropertyToTextList
are extensions introduced by The XFree86 Project, Inc. in their 4.0.2
release. Their presence is
indicated by the macro
.ZN X_HAVE_UTF8_STRING .
.SH STRUCTURES
The
.ZN XTextProperty
structure contains:
.LP
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	unsigned char *value;	/\&* property data */
	Atom encoding;	/\&* type of property */
	int format;	/\&* 8, 16, or 32 */
	unsigned long nitems;	/\&* number of items in value */
} XTextProperty;
.De
.LP
The
.ZN XICCEncodingStyle
structure contains:
.LP
.TS
lw(.5i) lw(2i) lw(2.5i).
T{
\&#define
T}	T{
.ZN XNoMemory
T}	T{
\-1
T}
T{
\&#define
T}	T{
.ZN XLocaleNotSupported
T}	T{
\-2
T}
T{
\&#define
T}	T{
.ZN XConverterNotFound
T}	T{
\-3
T}
.TE
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef enum {
	XStringStyle,		/\&* STRING */
	XCompoundTextStyle,	/\&* COMPOUND_TEXT */
	XTextStyle,		/\&* text in owner's encoding (current locale) */
	XStdICCTextStyle,	/\&* STRING, else COMPOUND_TEXT */
	XUTF8StringStyle	/\&* UTF8_STRING */
} XICCEncodingStyle;
.De
.SH "SEE ALSO"
XSetTextProperty(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
