.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbVirtualModsToReal __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbVirtualModsToReal \- Determines the mapping of virtual modifiers to core X 
protocol modifiers
.SH SYNOPSIS
.HP
.B Bool XkbVirtualModsToReal
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "virtual_mask" "\^,"
.BI "unsigned int *" "mask_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description for input device
.TP
.I \- virtual_mask
virtual modifier mask to translate
.TP
.I \- mask_rtrn
backfilled with real modifiers
.SH DESCRIPTION
.LP
Xkb maintains a 
.I virtual modifier mapping, 
which lists the virtual modifiers associated with, or bound to, each key. The 
real modifiers bound to a virtual modifier always include all of the modifiers 
bound to any of the keys that specify that virtual modifier in their virtual 
modifier mapping. The 
.I server.vmodmap 
array indicates which virtual modifiers are bound to each key; each entry is a 
bitmask for the virtual modifier bits. The 
.I server.vmodmap 
array is indexed by keycode.

The 
.I vmodmap 
and 
.I vmods 
members of the server map are the "master" virtual modifier definitions. Xkb 
automatically propagates any changes to these fields to all other fields that 
use virtual modifier mappings.

For example, if Mod3 is bound to the Num_Lock key by the core protocol modifier 
mapping, and the NumLock virtual modifier is bound to they Num_Lock key by the 
virtual modifier mapping, Mod3 is added to the set of modifiers associated with 
NumLock.

The virtual modifier mapping is normally updated whenever actions are 
automatically applied to symbols and few applications should need to change the 
virtual modifier mapping explicitly.

Use 
.I XkbGetMap
to get the virtual modifiers from the server or use 
.I XkbGetVirtualMods 
to update a local copy of the virtual modifiers bindings from the server. To set 
the binding of a virtual modifier to a real modifier, use 
.I XkbGetVirtualMods

If the keyboard description defined by 
.I xkb 
includes bindings for virtual modifiers, 
.I XkbVirtualModsToReal 
uses those bindings to determine the set of real modifiers that correspond to 
the set of virtual modifiers specified in 
.I virtual_mask. 
The 
.I virtual_mask 
parameter is a mask specifying the virtual modifiers to translate; the i-th bit 
(0 relative) of the mask represents the i-th virtual modifier. If 
.I mask_rtrn 
is non-NULL, 
.I XkbVirtualModsToReal 
backfills it with the resulting real modifier mask. If the keyboard description 
in 
.I xkb 
does not include virtual modifier bindings, 
.I XkbVirtualModsToReal 
returns False; otherwise, it returns True.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbVirtualModsToReal 
function returns True if the keyboard description 
in 
.I xkb 
does include virtual modifier bindings.
.TP 15
False
The 
.I XkbVirtualModsToReal 
function returns False if the keyboard description 
in 
.I xkb 
does not include virtual modifier bindings.
.SH "SEE ALSO"
.BR XkbGetMap (__libmansuffix__),
.BR XkbGetVirtualMods (__libmansuffix__)
.SH NOTES
.LP
It is possible for a local (client-side) keyboard description (the 
.I xkb 
parameter) to not contain any virtual modifier information (simply because the 
client has not requested it) while the server's corresponding definition may 
contain virtual modifier information. 

