'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbGetKeyTypes __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetKeyTypes \- Obtain the list of available key types in the server's 
keyboard mapping
.SH SYNOPSIS
.HP
.B Status XkbGetKeyTypes
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "first" "\^,"
.BI "unsigned int " "num" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- first
index to first type to get, 0 => 1st type
.TP
.I \- num
number of key types to be returned
.TP
.I \- xkb
keyboard description containing client map to update
.SH DESCRIPTION
.LP
.I XkbGetKeyTypes 
queries the server for the desired types, waits for a reply, and returns the 
desired types in the 
.I xkb->map->types. 
If successful, it returns Success.

.I XkbGetKeyTypes 
returns BadAccess if the Xkb extension has not been properly initialized and 
BadValue if the combination of 
.I first 
and 
.I num 
results in numbers out of valid range.

.B NOTE: 
.I XkbGetKeyTypes 
is used to obtain descriptions of the key types themselves, not the key types 
bound to individual keys. To obtain the key types bound to an individual key, 
refer to the 
.I key_sym_map 
field of the client map.
.SH DIAGNOSTICS
.TP 15
.B BadAccess
The Xkb extension has not been properly initialized
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbKeyType (__libmansuffix__),
.BR XkbKeyTypeIndex (__libmansuffix__)

