'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbLockGroup __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbLockGroup \-  Locks the keysym group
.SH SYNOPSIS
.B Bool XkbLockGroup
(
.I display,
.I device_spec,
.I group
)
.br
      Display *\fIdisplay\fP\^;
.br
      unsigned int \fIdevice_spec\fP\^;
.br
      unsigned int \fIgroup\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server 
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I group
index of the keysym group to lock
.SH DESCRIPTION
.LP
.I XkbLockGroup 
sends a request to the server to lock the specified 
.I group 
and does not wait for a reply. It returns True if the request was sent and 
False otherwise.

Reference the keysym group indices with these symbolic constants:

.TS
c s
l l
l l.
Table 1 Symbolic Group Names
_
Symbolic Name	Value
_
XkbGroup1Index	0
XkbGroup2Index	1
XkbGroup3Index	2
XkbGroup4Index	3
.TE
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbLockGroup
function returns True when a request was sent to the server to lock the 
specified 
.I group
and does not wait for a reply.
.TP 15
False
The 
.I XkbLockGroup
function returns False if the request was not sent.

