.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XcmsSClr.man,v 1.2 2001/01/27 18:20:07 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XcmsStoreColor __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XcmsStoreColor, XcmsStoreColors \- set colors
.SH SYNTAX
.HP
Status XcmsStoreColor\^(\^Display *\fIdisplay\fP\^, Colormap \fIcolormap\fP\^,
XcmsColor *\fIcolor\fP\^); 
.HP
Status XcmsStoreColors\^(\^Display *\fIdisplay\fP\^, Colormap
\fIcolormap\fP\^, XcmsColor \fIcolors\fP\^[\^]\^, int \fIncolors\fP\^, Bool
\fIcompression_flags_return\fP\^[\^]\^); 
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcolor\fP 1i
Specifies the color cell and the color to store.
Values specified in this
.ZN XcmsColor
structure remain unchanged on return.
.IP \fIcolors\fP 1i
Specifies the color specification array of
.ZN XcmsColor
structures, each specifying a color cell and the color to store in that
cell.
Values specified in the array remain unchanged upon return.
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIcompression_flags_return\fP 1i
Returns an array of Boolean values indicating compression status.
If a non-NULL pointer is supplied,
each element of the array is set to
.ZN True
if the corresponding color was compressed and
.ZN False
otherwise.
Pass NULL if the compression status is not useful.
.IP \fIncolors\fP 1i
Specifies the number of 
.ZN XcmsColor
structures in the color-specification array.
.SH DESCRIPTION
The
.ZN XcmsStoreColor
function converts the color specified in the
.ZN XcmsColor
structure into RGB values.
It then uses this RGB specification in an
.ZN XColor
structure, whose three flags 
.Pn ( DoRed , 
.ZN DoGreen ,
and
.ZN DoBlue )
are set, in a call to
.ZN XStoreColor
to change the color cell specified by the pixel member of the
.ZN XcmsColor
structure.
This pixel value must be a valid index for the specified colormap,
and the color cell specified by the pixel value must be a read/write cell.
If the pixel value is not a valid index, a
.ZN BadValue
error results.
If the color cell is unallocated or is allocated read-only, a
.ZN BadAccess
error results.
If the colormap is an installed map for its screen, 
the changes are visible immediately.
.LP
Note that 
.ZN XStoreColor
has no return value; therefore, an
.ZN XcmsSuccess
return value from this function indicates that the conversion 
to RGB succeeded and the call to
.ZN XStoreColor
was made.
To obtain the actual color stored, use
.ZN XcmsQueryColor .
Because of the screen's hardware limitations or gamut compression,
the color stored in the colormap may not be identical
to the color specified.
.LP
.ZN XcmsStoreColor
can generate
.ZN BadAccess ,
.ZN BadColor ,
and
.ZN BadValue
errors.
.LP
The
.ZN XcmsStoreColors
function converts the colors specified in the array of
.ZN XcmsColor
structures into RGB values and then uses these RGB specifications in
.ZN XColor
structures, whose three flags 
.Pn ( DoRed , 
.ZN DoGreen ,
and
.ZN DoBlue )
are set, in a call to
.ZN XStoreColors
to change the color cells specified by the pixel member of the corresponding
.ZN XcmsColor
structure.
Each pixel value must be a valid index for the specified colormap,
and the color cell specified by each pixel value must be a read/write cell.
If a pixel value is not a valid index, a
.ZN BadValue
error results.
If a color cell is unallocated or is allocated read-only, a
.ZN BadAccess
error results.
If more than one pixel is in error,
the one that gets reported is arbitrary.
If the colormap is an installed map for its screen, 
the changes are visible immediately.
.LP
Note that 
.ZN XStoreColors
has no return value; therefore, an
.ZN XcmsSuccess
return value from this function indicates that conversions 
to RGB succeeded and the call to
.ZN XStoreColors
was made.
To obtain the actual colors stored, use
.ZN XcmsQueryColors .
Because of the screen's hardware limitations or gamut compression,
the colors stored in the colormap may not be identical
to the colors specified.
.LP
.LP
.ZN XcmsStoreColors
can generate
.ZN BadAccess ,
.ZN BadColor ,
and
.ZN BadValue
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAccess
A client attempted
to free a color map entry that it did not already allocate.
.TP 1i
.ZN BadAccess
A client attempted
to store into a read-only color map entry.
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XcmsAllocColor(3X11),
XcmsQueryColor(3X11)
.br
\fI\*(xL\fP
