.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH intel_panel_fitter __appmansuffix__ __xorgversion__
.SH NAME
intel_panel_fitter \- Change the panel fitter settings
.SH SYNOPSIS
.B intel_panel_fitter [options]
.SH DESCRIPTION
.B intel_panel_fitter
is a tool that allows you to change the panel fitter settings, so you can change
the size of the screen being displayed on your monitor without changing the real
pixel size of your desktop. The biggest use case for this tool is to work around
overscan done by TVs and some monitors in interlaced mode.
.SS Options
.TP
.B -p [pipe]
pipe to be used (A, B or C, but C is only present on Ivy Bridge and newer).
.TP
.B -x [value]
final screen width size in pixels (needs -p option).
.TP
.B -y [value]
final screen height size in pixels (needs -p option).
.TP
.B -d
disable panel fitter (needs -p option, ignores -x and -y options).
.TP
.B -l
list current state of each pipe.
.TP
.B -h
prints the help message.
.SS

.SH EXAMPLES
.TP
.B intel_panel_fitter -l
will list the current status of each pipe, so you can decide what to do.
.TP
.B intel_panel_fitter -p A -x 1850 -y 1040
will change the pipe A size to 1850x1040 pixels.
.TP
.B intel_panel_fitter -p A -d
will disable the panel fitter for pipe A.

.SH NOTES
In the future, there will be support for this feature inside the Linux Kernel.

Machines older than Ironlake are still not supported, but support may be
possible to implement.
