.TH CPICKER 1
.SH NAME
cpicker \- colormap editor for X/Motif
.SH SYNTAX
.B cpicker
[-id \fIid\fP] [-root] [-wname \fIname\fP] [-display \fIdisplay\fP] [-motif]
[-noMotif] [-multiple] [-noMultiple]
.SH OPTIONS
.PP
.TP 8
.B "-id \fIid\fP"
This option allows the user to specify a target  window  \fIid\fP  on  the
command  line rather than using the mouse to select the target window.
.PP
.TP 8
.B "-wname \fIname\fP"
This option allows the user to specify that the window named \fIname\fP
is the target window on the command line rather than using the mouse to
select the target window.
.PP
.TP 8
.B "-root"
This  option  specifies  that  X's root window is the target window.
.PP
.TP 8
.B -display \fIdisplay\fP
This option allows you to specify the server to connect to; see \fIX(1)\fP.
.PP
.TP 8
.B -motif
Enable Motif color matching.  When a colormap cell is modified, its
corresponding top and bottom shadow colormap cells (if any) are also
modified.  This is on by default.
.TP 8
.B -noMotif
Disable Motif color matching.
.TP 8
.B -multiple
Hardware supports multiple colormaps, change application's windows colormap
values.
.TP 8
.B -noMultiple
Assume that hardware supports only a single colormap, technicolor
effects will make changes to the installed colormap visible in
the application even though it uses a different colormap.
.SH DESCRIPTION
.I Cpicker
makes temporary changes to a copy of the installed colormap, allowing
the user to observe the effects.  It's useful for trying to pick that
perfect color or find the appropriate color combination for an
application.
.PP
When cpicker first starts, it either uses the colormap of the window
specified, or asks you to click on the window whose colormap you wish
to edit.  Then, it displays a grid of the color cells
in the installed colormap.  Click on the cell you wish to edit.  Then, in
the upper right there will be a box containing the current color along
with a label showing the current RGB values in X11 hex format.
.PP
To adjust the current color you can use one of the nine sliders, each
controlling one of the RGB, HSV, or CMY values for the current color.
Or you can click on a cell displayed in the palette to use its color.
The palette button underneath the hex label switches between the three
palettes: range, narrow, and wide.  You can also click on the hex label
to directly enter new RGB hex values.
.PP
If you click on the "match" button, the palette will change to the
colors in the file /usr/lib/X11/rgb.txt which are closest to the
current color.  As you select these colors, their names appear below
the bottom buttons.  Use the palette button to return the palette
to an ordinary selection.
.PP
The "select" button allows you to choose another cell to edit, the
"cancel" button restores the current color to its original value,
the "restore" button restores all the cells of the colormap to their
original value, and the "quit" button exits out of cpicker.
.SH "SEE ALSO"
pixedit(1)
.SH AUTHOR
Mike Yang, mikey@sgi.com, Silicon Graphics, Inc.
.SH BUGS
When clicking in a window to select its colormap, be sure to click
in the window contents.  Clicking in window manager real estate
may or may not result in the correct colormap.
.PP
Motif color matching uses a heuristic to find the top and shadow
color pixels.  There may be conflicts with unrelated colors, or there
may be other cells with the same RGB value.
.PP
If you terminate the program abnormally, then the colormap values for
the application's windows are not restored and become zero.  This prevents
subsequent runs of cpicker or pixedit on the application.  This bug
does not occur if the -noMultiple switch is used.

