.TH INTEL_FREQUENCY: "1" "January 2015" "intel_gpu_frequency" "User Commands"
.SH NAME
intel_gpu_frequency: \- manual page for intel_gpu_frequency
.SH SYNOPSIS
.B intel_gpu_frequency
[\fI\,-e\/\fR] [\fI\,--min | --max\/\fR] [\fI\,-g\/\fR] [\fI\,-s frequency_mhz\/\fR]
.SH DESCRIPTION
\&A program to manipulate Intel GPU frequencies. Intel GPUs
will automatically throttle the frequencies based on system demands, up when
needed, down when not. This tool should only be used for debugging performance
problems, or trying to get a stable frequency while benchmarking.

Intel GPUs only accept specific frequencies. The tool may, or may not attempt to
adjust requests to the proper frequency if they aren't correct. This may lead to
non-obvious failures when setting frequency. Multiples of 50MHz is usually a
safe bet.
.SH OPTIONS
.TP
\fB\-e\fR
Lock frequency to the most efficient frequency
.TP
\fB\-g\fR, \fB\-\-get\fR
Get all the current frequency settings
.TP
\fB\-s\fR, \fB\-\-set\fR
Lock frequency to an absolute value (MHz)
.TP
\fB\-c\fR, \fB\-\-custom\fR
Set a min, or max frequency "min=X | max=Y"
.TP
\fB\-m\fR  \fB\-\-max\fR
Lock frequency to max frequency
.TP
\fB\-i\fR  \fB\-\-min\fR
Lock frequency to min (never a good idea, DEBUG ONLY)
.TP
\fB\-d\fR  \fB\-\-defaults\fR
Return the system to hardware defaults
.TP
\fB\-h\fR  \fB\-\-help\fR
Returns this
.HP
\fB\-v\fR  \fB\-\-version\fR Version
.SH EXAMPLES
.TP
\fbintel_gpu_frequency \-gmin,cur\fR
Get the current and minimum frequency
.TP
\fbintel_gpu_frequency \-s 400\fR
Lock frequency to 400Mhz
.TP
\fbintel_gpu_frequency \-c max=750\fR
Set the max frequency to 750MHz
.PP
.SH "REPORTING BUGS"
Report bugs to https://bugs.freedesktop.org
.SH COPYRIGHT
Copyright (C) 2015 Intel Corporation
