.\"
.TH CONSTYPE __appmansuffix__ __xorgversion__
.SH NAME
constype \- print type of Sun console
.SH SYNOPSIS
.B "constype"
[
.B \-num
] [
.I device_name
]
.LP
.B "constype -help"
.LP
.B "constype -version"
.SH DESCRIPTION
.B constype
prints on the standard output the Sun code for the type of display
that the specified device is.
.LP
If the OS and device support the VIS_GETIDENTIFIER ioctl, the value
returned from the ioctl is the value printed by constype.   Sample types
output for these include:
.sp 2
.in +0.5i
.nf
SUNWffb        Sun Creator 3D (ffb) Graphics Accelerator
SUNWm64        Sun PGX8, PGX24 or PGX64 Frame Buffer
SUNWtext       Generic vgatext console for Solaris x86 graphics devices without specific kernel drivers
.fi
.in -0.5i
.sp 2
Otherwise, the older fbio identification methods are used, for which
the types output include these:
.sp 2
.in +0.5i
.nf
bw?	Black and White, where ? is 1-4. (eg) 3-50s are bw2
cg?	Colour Graphics display, where ? is 1-6, 8, 12
gp?	Optional Graphics Processor board, where ? is 1-2
ns?	Not Sun display \(em where ? is A-J
.fi
.in -0.5i
.sp 2
This is useful in determining startup values and defaults for window
systems.
.LP
The
.I device_name
argument, if given, is the device to examine.
If not given,
.I /dev/fb
is used.
.LP
The
.B \-num
option causes
.I constype
to follow the type keyword with the numeric value of that type,
as returned by the FBIOGATTR or FBIOGTYPE ioctl and defined in fbio.h.
This is useful if the type is not recognized by the program.
.LP
The
.B \-help
option causes
.I constype
to print a usage message and exit.
.LP
The
.B \-version
option causes
.I constype
to print its version and exit.
.SH "EXIT STATUS"
The program exits with status 0 if it identified a known console type,
1 if the type was unknown, and 2 if the device could not be opened or
another error occurred.
.SH BUGS
Not tested on all frame buffer types
.SH "SEE ALSO"
.BR visual_io (7I)
.SH COPYRIGHT
Copyright 1988, SRI
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of SRI not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior permission.  SRI makes no representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
.SH AUTHOR
Doug Moran <moran@ai.sri.com>
