.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
hypnowheel - draws overlapping, translucent spiral patterns
.SH SYNOPSIS
.B hypnowheel
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIint\fP]
[\-layers \fIint\fP]
[\-count \fIint\fP]
[\-twistiness \fIfloat\fP]
[\-speed \fIfloat\fP]
[\-wander\fP]
[\-symmetric\fP]
[\-fps]
.SH DESCRIPTION
Draws a series of overlapping, translucent spiral patterns.
The tightness of their spirals fluctuates in and out.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fIint\fP
Delay between frames, in microseconds.  Default 20000.
.TP 8
.B \-layers \fIint\fP
How many different spirals to draw at once.  Default 4.
.TP 8
.B \-count \fIint\fP
How many arms each spiral should have.  Default 11.
.TP 8
.B \-twistiness \fIfloat\fP
How tightly wound the spirals can become, measured in rotations.
Default 4.0 (four times around).
.TP 8
.B \-speed \fIratio\fP
Less than 1 for slower, greater than 1 for faster.  Default 1.
.TP 8
.B \-wander
If specified, then the centers of the spirals will wander around,
rather than them all having the same origin.
.TP 8
.B \-symmetric
If specified, then each pair of left-wrapping and right-wrapping
spirals will be mirror images of each other.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2008 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski.
