#include "command.ih"

void Command::determineAction()
{
    switch (int ch = d_arguments[0])     // Interpret the first character
    {
        case '0':               // from parent 0 or cwd
            d_action = FROM_CWD;
        break;

        case '/':           // explicitly from the root
            d_action = FROM_ROOT;
        break;              // breaks remove the 1st char from args

        // start from a parent
        case '1' ... '9':
            d_parent = ch - '0';
            d_action = FROM_PARENT;
        break;

        // other characters: 1st char. of directory or homedir char (~).
        default:
            if (ch == d_homedirChar)
            {
                d_action = FROM_HOME;
                break;
            }

            d_action =  FROM_CONFIG;
        return;
    }

    do
        d_arguments.erase(0, 1);      // remove the 1st (location) character
    while (d_arguments.front() == '/'); // and a possible initial / sep.

    imsg << "After removing the initial location/dir character(s): `" <<
                                            d_arguments << '\'' << endl;
}
