#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import sys

def print_version_info():
	from winswitch import __version__
	print("winswitch version %s" % __version__)
	try:
		from winswitch.build_info import BUILT_ON, BUILT_BY, BUILD_DATE, BUILD_CPU, BUILD_BIT, RELEASE_BUILD, REVISION, LOCAL_MODIFICATIONS
		if RELEASE_BUILD:
			print("Release Build")
		else:
			print("BETA Build")
		print("Built on %s by %s on the %s" % (BUILT_ON, BUILT_BY, BUILD_DATE))
		if sys.platform.startswith("darwin"):
			print("OSX Target CPU=%s, cpu bits=%s" % (BUILD_CPU, BUILD_BIT))
		print("SVN revision %s with %s local modifications" % (REVISION, LOCAL_MODIFICATIONS))
	except Exception, e:
		print("failed to retrieve build information: %s" % e)
