/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;

public class SimpleUnitCell {
    protected static final float toRadians = (float)Math.PI / 180;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected boolean isPrimitive;
    protected float[] notionalUnitcell;
    protected Matrix4f matrixCartesianToFractional;
    protected Matrix4f matrixFractionalToCartesian;
    protected boolean isPolymer;
    protected boolean isSlab;
    protected Data data;

    public boolean isPolymer() {
        return this.isPolymer;
    }

    public boolean isSlab() {
        return this.isSlab;
    }

    public SimpleUnitCell(float[] fArray) {
        this.setUnitCell(fArray);
    }

    public SimpleUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setUnitCell(new float[]{f, f2, f3, f4, f5, f6});
    }

    public final void toCartesian(Point3f point3f) {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixFractionalToCartesian.transform(point3f);
    }

    public final void toFractional(Point3f point3f) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(point3f);
    }

    public final float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public final float getInfo(int n) {
        switch (n) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.isPolymer ? 1 : (this.isSlab ? 2 : 3);
            }
        }
        return Float.NaN;
    }

    private void setUnitCell(float[] fArray) {
        if (fArray == null || fArray[0] == 0.0f) {
            return;
        }
        this.notionalUnitcell = fArray;
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        if (this.b == -1.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.isPolymer = true;
        } else if (this.c == -1.0f) {
            this.c = 1.0f;
            this.isSlab = true;
        }
        this.alpha = fArray[3];
        this.beta = fArray[4];
        this.gamma = fArray[5];
        this.constructFractionalMatrices();
    }

    private void constructFractionalMatrices() {
        if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[21])) {
            float[] fArray = new float[16];
            for (int i = 0; i < 16; ++i) {
                fArray[i] = this.notionalUnitcell[6 + i];
            }
            this.matrixCartesianToFractional = new Matrix4f(fArray);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invert(this.matrixCartesianToFractional);
        } else if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[14])) {
            this.isPrimitive = true;
            Matrix4f matrix4f = this.matrixFractionalToCartesian = new Matrix4f();
            float[] fArray = this.notionalUnitcell;
            if (this.data == null) {
                this.data = new Data();
            }
            matrix4f.setColumn(0, fArray[6], fArray[7], fArray[8], 0.0f);
            matrix4f.setColumn(1, fArray[9], fArray[10], fArray[11], 0.0f);
            matrix4f.setColumn(2, fArray[12], fArray[13], fArray[14], 0.0f);
            matrix4f.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        } else {
            Matrix4f matrix4f = this.matrixFractionalToCartesian = new Matrix4f();
            if (this.data == null) {
                this.data = new Data();
            }
            matrix4f.setColumn(0, this.a, 0.0f, 0.0f, 0.0f);
            matrix4f.setColumn(1, (float)((double)this.b * this.data.cosGamma), (float)((double)this.b * this.data.sinGamma), 0.0f, 0.0f);
            matrix4f.setColumn(2, (float)((double)this.c * this.data.cosBeta), (float)((double)this.c * (this.data.cosAlpha - this.data.cosBeta * this.data.cosGamma) / this.data.sinGamma), (float)(this.data.volume / ((double)(this.a * this.b) * this.data.sinGamma)), 0.0f);
            matrix4f.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        }
    }

    protected class Data {
        public double cosAlpha;
        public double sinAlpha;
        public double cosBeta;
        public double sinBeta;
        public double cosGamma;
        public double sinGamma;
        public double volume;
        public double cA_;
        public double cB_;
        public double a_;
        public double b_;
        public double c_;

        public Data() {
            this.cosAlpha = Math.cos((float)Math.PI / 180 * SimpleUnitCell.this.alpha);
            this.sinAlpha = Math.sin((float)Math.PI / 180 * SimpleUnitCell.this.alpha);
            this.cosBeta = Math.cos((float)Math.PI / 180 * SimpleUnitCell.this.beta);
            this.sinBeta = Math.sin((float)Math.PI / 180 * SimpleUnitCell.this.beta);
            this.cosGamma = Math.cos((float)Math.PI / 180 * SimpleUnitCell.this.gamma);
            this.sinGamma = Math.sin((float)Math.PI / 180 * SimpleUnitCell.this.gamma);
            double d = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
            this.volume = (double)(SimpleUnitCell.this.a * SimpleUnitCell.this.b * SimpleUnitCell.this.c) * d;
            this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
            this.cB_ = d / this.sinGamma;
            this.a_ = (double)(SimpleUnitCell.this.b * SimpleUnitCell.this.c) * this.sinAlpha / this.volume;
            this.b_ = (double)(SimpleUnitCell.this.a * SimpleUnitCell.this.c) * this.sinBeta / this.volume;
            this.c_ = (double)(SimpleUnitCell.this.a * SimpleUnitCell.this.b) * this.sinGamma / this.volume;
        }
    }
}

