ntkrpamp_types = {
  'LIST_ENTRY64' : [ 0x10, {
    'Flink' : [ 0x0, ['unsigned long long']],
    'Blink' : [ 0x8, ['unsigned long long']],
} ],
  'LIST_ENTRY32' : [ 0x8, {
    'Flink' : [ 0x0, ['unsigned long']],
    'Blink' : [ 0x4, ['unsigned long']],
} ],
  '_KUSER_SHARED_DATA' : [ 0x708, {
    'TickCountLowDeprecated' : [ 0x0, ['unsigned long']],
    'TickCountMultiplier' : [ 0x4, ['unsigned long']],
    'InterruptTime' : [ 0x8, ['_KSYSTEM_TIME']],
    'SystemTime' : [ 0x14, ['_KSYSTEM_TIME']],
    'TimeZoneBias' : [ 0x20, ['_KSYSTEM_TIME']],
    'ImageNumberLow' : [ 0x2c, ['unsigned short']],
    'ImageNumberHigh' : [ 0x2e, ['unsigned short']],
    'NtSystemRoot' : [ 0x30, ['array', 260, ['wchar']]],
    'MaxStackTraceDepth' : [ 0x238, ['unsigned long']],
    'CryptoExponent' : [ 0x23c, ['unsigned long']],
    'TimeZoneId' : [ 0x240, ['unsigned long']],
    'LargePageMinimum' : [ 0x244, ['unsigned long']],
    'AitSamplingValue' : [ 0x248, ['unsigned long']],
    'AppCompatFlag' : [ 0x24c, ['unsigned long']],
    'RNGSeedVersion' : [ 0x250, ['unsigned long long']],
    'GlobalValidationRunlevel' : [ 0x258, ['unsigned long']],
    'TimeZoneBiasStamp' : [ 0x25c, ['long']],
    'NtBuildNumber' : [ 0x260, ['unsigned long']],
    'NtProductType' : [ 0x264, ['Enumeration', dict(target = 'long', choices = {1: 'NtProductWinNt', 2: 'NtProductLanManNt', 3: 'NtProductServer'})]],
    'ProductTypeIsValid' : [ 0x268, ['unsigned char']],
    'Reserved0' : [ 0x269, ['array', 1, ['unsigned char']]],
    'NativeProcessorArchitecture' : [ 0x26a, ['unsigned short']],
    'NtMajorVersion' : [ 0x26c, ['unsigned long']],
    'NtMinorVersion' : [ 0x270, ['unsigned long']],
    'ProcessorFeatures' : [ 0x274, ['array', 64, ['unsigned char']]],
    'Reserved1' : [ 0x2b4, ['unsigned long']],
    'Reserved3' : [ 0x2b8, ['unsigned long']],
    'TimeSlip' : [ 0x2bc, ['unsigned long']],
    'AlternativeArchitecture' : [ 0x2c0, ['Enumeration', dict(target = 'long', choices = {0: 'StandardDesign', 1: 'NEC98x86', 2: 'EndAlternatives'})]],
    'BootId' : [ 0x2c4, ['unsigned long']],
    'SystemExpirationDate' : [ 0x2c8, ['_LARGE_INTEGER']],
    'SuiteMask' : [ 0x2d0, ['unsigned long']],
    'KdDebuggerEnabled' : [ 0x2d4, ['unsigned char']],
    'MitigationPolicies' : [ 0x2d5, ['unsigned char']],
    'NXSupportPolicy' : [ 0x2d5, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'SEHValidationPolicy' : [ 0x2d5, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned char')]],
    'CurDirDevicesSkippedForDlls' : [ 0x2d5, ['BitField', dict(start_bit = 4, end_bit = 6, native_type='unsigned char')]],
    'Reserved' : [ 0x2d5, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Reserved6' : [ 0x2d6, ['array', 2, ['unsigned char']]],
    'ActiveConsoleId' : [ 0x2d8, ['unsigned long']],
    'DismountCount' : [ 0x2dc, ['unsigned long']],
    'ComPlusPackage' : [ 0x2e0, ['unsigned long']],
    'LastSystemRITEventTickCount' : [ 0x2e4, ['unsigned long']],
    'NumberOfPhysicalPages' : [ 0x2e8, ['unsigned long']],
    'SafeBootMode' : [ 0x2ec, ['unsigned char']],
    'Reserved12' : [ 0x2ed, ['array', 3, ['unsigned char']]],
    'SharedDataFlags' : [ 0x2f0, ['unsigned long']],
    'DbgErrorPortPresent' : [ 0x2f0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DbgElevationEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DbgVirtEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DbgInstallerDetectEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DbgLkgEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DbgDynProcessorEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DbgConsoleBrokerEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DbgSecureBootEnabled' : [ 0x2f0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'DbgMultiSessionSku' : [ 0x2f0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SpareBits' : [ 0x2f0, ['BitField', dict(start_bit = 9, end_bit = 32, native_type='unsigned long')]],
    'DataFlagsPad' : [ 0x2f4, ['array', 1, ['unsigned long']]],
    'TestRetInstruction' : [ 0x2f8, ['unsigned long long']],
    'QpcFrequency' : [ 0x300, ['long long']],
    'SystemCall' : [ 0x308, ['unsigned long']],
    'SystemCallPad0' : [ 0x30c, ['unsigned long']],
    'SystemCallPad' : [ 0x310, ['array', 2, ['unsigned long long']]],
    'TickCount' : [ 0x320, ['_KSYSTEM_TIME']],
    'TickCountQuad' : [ 0x320, ['unsigned long long']],
    'ReservedTickCountOverlay' : [ 0x320, ['array', 3, ['unsigned long']]],
    'TickCountPad' : [ 0x32c, ['array', 1, ['unsigned long']]],
    'Cookie' : [ 0x330, ['unsigned long']],
    'CookiePad' : [ 0x334, ['array', 1, ['unsigned long']]],
    'ConsoleSessionForegroundProcessId' : [ 0x338, ['long long']],
    'TimeUpdateLock' : [ 0x340, ['unsigned long long']],
    'BaselineSystemTimeQpc' : [ 0x348, ['unsigned long long']],
    'BaselineInterruptTimeQpc' : [ 0x350, ['unsigned long long']],
    'QpcSystemTimeIncrement' : [ 0x358, ['unsigned long long']],
    'QpcInterruptTimeIncrement' : [ 0x360, ['unsigned long long']],
    'QpcSystemTimeIncrementShift' : [ 0x368, ['unsigned char']],
    'QpcInterruptTimeIncrementShift' : [ 0x369, ['unsigned char']],
    'UnparkedProcessorCount' : [ 0x36a, ['unsigned short']],
    'EnclaveFeatureMask' : [ 0x36c, ['array', 4, ['unsigned long']]],
    'Reserved8' : [ 0x37c, ['unsigned long']],
    'UserModeGlobalLogger' : [ 0x380, ['array', 16, ['unsigned short']]],
    'ImageFileExecutionOptions' : [ 0x3a0, ['unsigned long']],
    'LangGenerationCount' : [ 0x3a4, ['unsigned long']],
    'Reserved4' : [ 0x3a8, ['unsigned long long']],
    'InterruptTimeBias' : [ 0x3b0, ['unsigned long long']],
    'QpcBias' : [ 0x3b8, ['unsigned long long']],
    'ActiveProcessorCount' : [ 0x3c0, ['unsigned long']],
    'ActiveGroupCount' : [ 0x3c4, ['unsigned char']],
    'Reserved9' : [ 0x3c5, ['unsigned char']],
    'QpcData' : [ 0x3c6, ['unsigned short']],
    'QpcBypassEnabled' : [ 0x3c6, ['unsigned char']],
    'QpcShift' : [ 0x3c7, ['unsigned char']],
    'TimeZoneBiasEffectiveStart' : [ 0x3c8, ['_LARGE_INTEGER']],
    'TimeZoneBiasEffectiveEnd' : [ 0x3d0, ['_LARGE_INTEGER']],
    'XState' : [ 0x3d8, ['_XSTATE_CONFIGURATION']],
} ],
  '__unnamed_107d' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
} ],
  '_ULARGE_INTEGER' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
    'u' : [ 0x0, ['__unnamed_107d']],
    'QuadPart' : [ 0x0, ['unsigned long long']],
} ],
  '__unnamed_1081' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
} ],
  '_LARGE_INTEGER' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
    'u' : [ 0x0, ['__unnamed_1081']],
    'QuadPart' : [ 0x0, ['long long']],
} ],
  '__unnamed_109c' : [ 0x4, {
    'LongFunction' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Persistent' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Private' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_109e' : [ 0x4, {
    'Flags' : [ 0x0, ['unsigned long']],
    's' : [ 0x0, ['__unnamed_109c']],
} ],
  '_TP_CALLBACK_ENVIRON_V3' : [ 0x28, {
    'Version' : [ 0x0, ['unsigned long']],
    'Pool' : [ 0x4, ['pointer', ['_TP_POOL']]],
    'CleanupGroup' : [ 0x8, ['pointer', ['_TP_CLEANUP_GROUP']]],
    'CleanupGroupCancelCallback' : [ 0xc, ['pointer', ['void']]],
    'RaceDll' : [ 0x10, ['pointer', ['void']]],
    'ActivationContext' : [ 0x14, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'FinalizationCallback' : [ 0x18, ['pointer', ['void']]],
    'u' : [ 0x1c, ['__unnamed_109e']],
    'CallbackPriority' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'TP_CALLBACK_PRIORITY_HIGH', 1: 'TP_CALLBACK_PRIORITY_NORMAL', 2: 'TP_CALLBACK_PRIORITY_LOW', 3: 'TP_CALLBACK_PRIORITY_COUNT'})]],
    'Size' : [ 0x24, ['unsigned long']],
} ],
  '_TEB' : [ 0x1000, {
    'NtTib' : [ 0x0, ['_NT_TIB']],
    'EnvironmentPointer' : [ 0x1c, ['pointer', ['void']]],
    'ClientId' : [ 0x20, ['_CLIENT_ID']],
    'ActiveRpcHandle' : [ 0x28, ['pointer', ['void']]],
    'ThreadLocalStoragePointer' : [ 0x2c, ['pointer', ['void']]],
    'ProcessEnvironmentBlock' : [ 0x30, ['pointer', ['_PEB']]],
    'LastErrorValue' : [ 0x34, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x38, ['unsigned long']],
    'CsrClientThread' : [ 0x3c, ['pointer', ['void']]],
    'Win32ThreadInfo' : [ 0x40, ['pointer', ['void']]],
    'User32Reserved' : [ 0x44, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xac, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0xc0, ['pointer', ['void']]],
    'CurrentLocale' : [ 0xc4, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0xc8, ['unsigned long']],
    'ReservedForDebuggerInstrumentation' : [ 0xcc, ['array', 16, ['pointer', ['void']]]],
    'SystemReserved1' : [ 0x10c, ['array', 38, ['pointer', ['void']]]],
    'ExceptionCode' : [ 0x1a4, ['long']],
    'ActivationContextStackPointer' : [ 0x1a8, ['pointer', ['_ACTIVATION_CONTEXT_STACK']]],
    'InstrumentationCallbackSp' : [ 0x1ac, ['unsigned long']],
    'InstrumentationCallbackPreviousPc' : [ 0x1b0, ['unsigned long']],
    'InstrumentationCallbackPreviousSp' : [ 0x1b4, ['unsigned long']],
    'InstrumentationCallbackDisabled' : [ 0x1b8, ['unsigned char']],
    'SpareBytes' : [ 0x1b9, ['array', 23, ['unsigned char']]],
    'TxFsContext' : [ 0x1d0, ['unsigned long']],
    'GdiTebBatch' : [ 0x1d4, ['_GDI_TEB_BATCH']],
    'RealClientId' : [ 0x6b4, ['_CLIENT_ID']],
    'GdiCachedProcessHandle' : [ 0x6bc, ['pointer', ['void']]],
    'GdiClientPID' : [ 0x6c0, ['unsigned long']],
    'GdiClientTID' : [ 0x6c4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x6c8, ['pointer', ['void']]],
    'Win32ClientInfo' : [ 0x6cc, ['array', 62, ['unsigned long']]],
    'glDispatchTable' : [ 0x7c4, ['array', 233, ['pointer', ['void']]]],
    'glReserved1' : [ 0xb68, ['array', 29, ['unsigned long']]],
    'glReserved2' : [ 0xbdc, ['pointer', ['void']]],
    'glSectionInfo' : [ 0xbe0, ['pointer', ['void']]],
    'glSection' : [ 0xbe4, ['pointer', ['void']]],
    'glTable' : [ 0xbe8, ['pointer', ['void']]],
    'glCurrentRC' : [ 0xbec, ['pointer', ['void']]],
    'glContext' : [ 0xbf0, ['pointer', ['void']]],
    'LastStatusValue' : [ 0xbf4, ['unsigned long']],
    'StaticUnicodeString' : [ 0xbf8, ['_UNICODE_STRING']],
    'StaticUnicodeBuffer' : [ 0xc00, ['array', 261, ['wchar']]],
    'DeallocationStack' : [ 0xe0c, ['pointer', ['void']]],
    'TlsSlots' : [ 0xe10, ['array', 64, ['pointer', ['void']]]],
    'TlsLinks' : [ 0xf10, ['_LIST_ENTRY']],
    'Vdm' : [ 0xf18, ['pointer', ['void']]],
    'ReservedForNtRpc' : [ 0xf1c, ['pointer', ['void']]],
    'DbgSsReserved' : [ 0xf20, ['array', 2, ['pointer', ['void']]]],
    'HardErrorMode' : [ 0xf28, ['unsigned long']],
    'Instrumentation' : [ 0xf2c, ['array', 9, ['pointer', ['void']]]],
    'ActivityId' : [ 0xf50, ['_GUID']],
    'SubProcessTag' : [ 0xf60, ['pointer', ['void']]],
    'PerflibData' : [ 0xf64, ['pointer', ['void']]],
    'EtwTraceData' : [ 0xf68, ['pointer', ['void']]],
    'WinSockData' : [ 0xf6c, ['pointer', ['void']]],
    'GdiBatchCount' : [ 0xf70, ['unsigned long']],
    'CurrentIdealProcessor' : [ 0xf74, ['_PROCESSOR_NUMBER']],
    'IdealProcessorValue' : [ 0xf74, ['unsigned long']],
    'ReservedPad0' : [ 0xf74, ['unsigned char']],
    'ReservedPad1' : [ 0xf75, ['unsigned char']],
    'ReservedPad2' : [ 0xf76, ['unsigned char']],
    'IdealProcessor' : [ 0xf77, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0xf78, ['unsigned long']],
    'ReservedForPerf' : [ 0xf7c, ['pointer', ['void']]],
    'ReservedForOle' : [ 0xf80, ['pointer', ['void']]],
    'WaitingOnLoaderLock' : [ 0xf84, ['unsigned long']],
    'SavedPriorityState' : [ 0xf88, ['pointer', ['void']]],
    'ReservedForCodeCoverage' : [ 0xf8c, ['unsigned long']],
    'ThreadPoolData' : [ 0xf90, ['pointer', ['void']]],
    'TlsExpansionSlots' : [ 0xf94, ['pointer', ['pointer', ['void']]]],
    'MuiGeneration' : [ 0xf98, ['unsigned long']],
    'IsImpersonating' : [ 0xf9c, ['unsigned long']],
    'NlsCache' : [ 0xfa0, ['pointer', ['void']]],
    'pShimData' : [ 0xfa4, ['pointer', ['void']]],
    'HeapVirtualAffinity' : [ 0xfa8, ['unsigned short']],
    'LowFragHeapDataSlot' : [ 0xfaa, ['unsigned short']],
    'CurrentTransactionHandle' : [ 0xfac, ['pointer', ['void']]],
    'ActiveFrame' : [ 0xfb0, ['pointer', ['_TEB_ACTIVE_FRAME']]],
    'FlsData' : [ 0xfb4, ['pointer', ['void']]],
    'PreferredLanguages' : [ 0xfb8, ['pointer', ['void']]],
    'UserPrefLanguages' : [ 0xfbc, ['pointer', ['void']]],
    'MergedPrefLanguages' : [ 0xfc0, ['pointer', ['void']]],
    'MuiImpersonation' : [ 0xfc4, ['unsigned long']],
    'CrossTebFlags' : [ 0xfc8, ['unsigned short']],
    'SpareCrossTebBits' : [ 0xfc8, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0xfca, ['unsigned short']],
    'SafeThunkCall' : [ 0xfca, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'InDebugPrint' : [ 0xfca, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'HasFiberData' : [ 0xfca, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'SkipThreadAttach' : [ 0xfca, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'WerInShipAssertCode' : [ 0xfca, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'RanProcessInit' : [ 0xfca, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'ClonedThread' : [ 0xfca, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SuppressDebugMsg' : [ 0xfca, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DisableUserStackWalk' : [ 0xfca, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0xfca, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'InitialThread' : [ 0xfca, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'SessionAware' : [ 0xfca, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned short')]],
    'LoadOwner' : [ 0xfca, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'LoaderWorker' : [ 0xfca, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0xfca, ['BitField', dict(start_bit = 14, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0xfcc, ['pointer', ['void']]],
    'TxnScopeExitCallback' : [ 0xfd0, ['pointer', ['void']]],
    'TxnScopeContext' : [ 0xfd4, ['pointer', ['void']]],
    'LockCount' : [ 0xfd8, ['unsigned long']],
    'WowTebOffset' : [ 0xfdc, ['long']],
    'ResourceRetValue' : [ 0xfe0, ['pointer', ['void']]],
    'ReservedForWdf' : [ 0xfe4, ['pointer', ['void']]],
    'ReservedForCrt' : [ 0xfe8, ['unsigned long long']],
    'EffectiveContainerId' : [ 0xff0, ['_GUID']],
} ],
  '_LIST_ENTRY' : [ 0x8, {
    'Flink' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'Blink' : [ 0x4, ['pointer', ['_LIST_ENTRY']]],
} ],
  '_SINGLE_LIST_ENTRY' : [ 0x4, {
    'Next' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_RTL_SPLAY_LINKS' : [ 0xc, {
    'Parent' : [ 0x0, ['pointer', ['_RTL_SPLAY_LINKS']]],
    'LeftChild' : [ 0x4, ['pointer', ['_RTL_SPLAY_LINKS']]],
    'RightChild' : [ 0x8, ['pointer', ['_RTL_SPLAY_LINKS']]],
} ],
  '_RTL_DYNAMIC_HASH_TABLE_CONTEXT' : [ 0xc, {
    'ChainHead' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'PrevLinkage' : [ 0x4, ['pointer', ['_LIST_ENTRY']]],
    'Signature' : [ 0x8, ['unsigned long']],
} ],
  '_RTL_DYNAMIC_HASH_TABLE_ENUMERATOR' : [ 0x14, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'CurEntry' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'ChainHead' : [ 0xc, ['pointer', ['_LIST_ENTRY']]],
    'BucketIndex' : [ 0x10, ['unsigned long']],
} ],
  '_RTL_DYNAMIC_HASH_TABLE' : [ 0x24, {
    'Flags' : [ 0x0, ['unsigned long']],
    'Shift' : [ 0x4, ['unsigned long']],
    'TableSize' : [ 0x8, ['unsigned long']],
    'Pivot' : [ 0xc, ['unsigned long']],
    'DivisorMask' : [ 0x10, ['unsigned long']],
    'NumEntries' : [ 0x14, ['unsigned long']],
    'NonEmptyBuckets' : [ 0x18, ['unsigned long']],
    'NumEnumerators' : [ 0x1c, ['unsigned long']],
    'Directory' : [ 0x20, ['pointer', ['void']]],
} ],
  '_UNICODE_STRING' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x4, ['pointer', ['unsigned short']]],
} ],
  '_STRING' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x4, ['pointer', ['unsigned char']]],
} ],
  '_LUID' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['long']],
} ],
  '_IMAGE_NT_HEADERS' : [ 0xf8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'FileHeader' : [ 0x4, ['_IMAGE_FILE_HEADER']],
    'OptionalHeader' : [ 0x18, ['_IMAGE_OPTIONAL_HEADER']],
} ],
  '_IMAGE_DOS_HEADER' : [ 0x40, {
    'e_magic' : [ 0x0, ['unsigned short']],
    'e_cblp' : [ 0x2, ['unsigned short']],
    'e_cp' : [ 0x4, ['unsigned short']],
    'e_crlc' : [ 0x6, ['unsigned short']],
    'e_cparhdr' : [ 0x8, ['unsigned short']],
    'e_minalloc' : [ 0xa, ['unsigned short']],
    'e_maxalloc' : [ 0xc, ['unsigned short']],
    'e_ss' : [ 0xe, ['unsigned short']],
    'e_sp' : [ 0x10, ['unsigned short']],
    'e_csum' : [ 0x12, ['unsigned short']],
    'e_ip' : [ 0x14, ['unsigned short']],
    'e_cs' : [ 0x16, ['unsigned short']],
    'e_lfarlc' : [ 0x18, ['unsigned short']],
    'e_ovno' : [ 0x1a, ['unsigned short']],
    'e_res' : [ 0x1c, ['array', 4, ['unsigned short']]],
    'e_oemid' : [ 0x24, ['unsigned short']],
    'e_oeminfo' : [ 0x26, ['unsigned short']],
    'e_res2' : [ 0x28, ['array', 10, ['unsigned short']]],
    'e_lfanew' : [ 0x3c, ['long']],
} ],
  '_RTL_RB_TREE' : [ 0x8, {
    'Root' : [ 0x0, ['pointer', ['_RTL_BALANCED_NODE']]],
    'Min' : [ 0x4, ['pointer', ['_RTL_BALANCED_NODE']]],
} ],
  '_RTL_BALANCED_NODE' : [ 0xc, {
    'Children' : [ 0x0, ['array', 2, ['pointer', ['_RTL_BALANCED_NODE']]]],
    'Left' : [ 0x0, ['pointer', ['_RTL_BALANCED_NODE']]],
    'Right' : [ 0x4, ['pointer', ['_RTL_BALANCED_NODE']]],
    'Red' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Balance' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'ParentValue' : [ 0x8, ['unsigned long']],
} ],
  '_RTL_AVL_TREE' : [ 0x4, {
    'Root' : [ 0x0, ['pointer', ['_RTL_BALANCED_NODE']]],
} ],
  '_GUID' : [ 0x10, {
    'Data1' : [ 0x0, ['unsigned long']],
    'Data2' : [ 0x4, ['unsigned short']],
    'Data3' : [ 0x6, ['unsigned short']],
    'Data4' : [ 0x8, ['array', 8, ['unsigned char']]],
} ],
  '_KPCR' : [ 0x4a20, {
    'NtTib' : [ 0x0, ['_NT_TIB']],
    'Used_ExceptionList' : [ 0x0, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'Used_StackBase' : [ 0x4, ['pointer', ['void']]],
    'MxCsr' : [ 0x8, ['unsigned long']],
    'TssCopy' : [ 0xc, ['pointer', ['void']]],
    'ContextSwitches' : [ 0x10, ['unsigned long']],
    'SetMemberCopy' : [ 0x14, ['unsigned long']],
    'Used_Self' : [ 0x18, ['pointer', ['void']]],
    'SelfPcr' : [ 0x1c, ['pointer', ['_KPCR']]],
    'Prcb' : [ 0x20, ['pointer', ['_KPRCB']]],
    'Irql' : [ 0x24, ['unsigned char']],
    'IRR' : [ 0x28, ['unsigned long']],
    'IrrActive' : [ 0x2c, ['unsigned long']],
    'IDR' : [ 0x30, ['unsigned long']],
    'KdVersionBlock' : [ 0x34, ['pointer', ['void']]],
    'IDT' : [ 0x38, ['pointer', ['_KIDTENTRY']]],
    'GDT' : [ 0x3c, ['pointer', ['_KGDTENTRY']]],
    'TSS' : [ 0x40, ['pointer', ['_KTSS']]],
    'MajorVersion' : [ 0x44, ['unsigned short']],
    'MinorVersion' : [ 0x46, ['unsigned short']],
    'SetMember' : [ 0x48, ['unsigned long']],
    'StallScaleFactor' : [ 0x4c, ['unsigned long']],
    'SpareUnused' : [ 0x50, ['unsigned char']],
    'Number' : [ 0x51, ['unsigned char']],
    'Spare0' : [ 0x52, ['unsigned char']],
    'SecondLevelCacheAssociativity' : [ 0x53, ['unsigned char']],
    'VdmAlert' : [ 0x54, ['unsigned long']],
    'KernelReserved' : [ 0x58, ['array', 14, ['unsigned long']]],
    'SecondLevelCacheSize' : [ 0x90, ['unsigned long']],
    'HalReserved' : [ 0x94, ['array', 16, ['unsigned long']]],
    'InterruptMode' : [ 0xd4, ['unsigned long']],
    'Spare1' : [ 0xd8, ['unsigned char']],
    'KernelReserved2' : [ 0xdc, ['array', 17, ['unsigned long']]],
    'PrcbData' : [ 0x120, ['_KPRCB']],
} ],
  '_KPRCB' : [ 0x4900, {
    'MinorVersion' : [ 0x0, ['unsigned short']],
    'MajorVersion' : [ 0x2, ['unsigned short']],
    'CurrentThread' : [ 0x4, ['pointer', ['_KTHREAD']]],
    'NextThread' : [ 0x8, ['pointer', ['_KTHREAD']]],
    'IdleThread' : [ 0xc, ['pointer', ['_KTHREAD']]],
    'LegacyNumber' : [ 0x10, ['unsigned char']],
    'NestingLevel' : [ 0x11, ['unsigned char']],
    'BuildType' : [ 0x12, ['unsigned short']],
    'CpuType' : [ 0x14, ['unsigned char']],
    'CpuID' : [ 0x15, ['unsigned char']],
    'CpuStep' : [ 0x16, ['unsigned short']],
    'CpuStepping' : [ 0x16, ['unsigned char']],
    'CpuModel' : [ 0x17, ['unsigned char']],
    'ProcessorState' : [ 0x18, ['_KPROCESSOR_STATE']],
    'ParentNode' : [ 0x338, ['pointer', ['_KNODE']]],
    'PriorityState' : [ 0x33c, ['pointer', ['unsigned char']]],
    'KernelReserved' : [ 0x340, ['array', 14, ['unsigned long']]],
    'HalReserved' : [ 0x378, ['array', 16, ['unsigned long']]],
    'CFlushSize' : [ 0x3b8, ['unsigned long']],
    'CoresPerPhysicalProcessor' : [ 0x3bc, ['unsigned char']],
    'LogicalProcessorsPerCore' : [ 0x3bd, ['unsigned char']],
    'CpuVendor' : [ 0x3be, ['unsigned char']],
    'PrcbPad0' : [ 0x3bf, ['array', 1, ['unsigned char']]],
    'MHz' : [ 0x3c0, ['unsigned long']],
    'GroupIndex' : [ 0x3c4, ['unsigned char']],
    'Group' : [ 0x3c5, ['unsigned char']],
    'PrcbPad05' : [ 0x3c6, ['array', 2, ['unsigned char']]],
    'GroupSetMember' : [ 0x3c8, ['unsigned long']],
    'Number' : [ 0x3cc, ['unsigned long']],
    'ClockOwner' : [ 0x3d0, ['unsigned char']],
    'PendingTickFlags' : [ 0x3d1, ['unsigned char']],
    'PendingTick' : [ 0x3d1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'PendingBackupTick' : [ 0x3d1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'PrcbPad10' : [ 0x3d2, ['array', 70, ['unsigned char']]],
    'LockQueue' : [ 0x418, ['array', 17, ['_KSPIN_LOCK_QUEUE']]],
    'InterruptCount' : [ 0x4a0, ['unsigned long']],
    'KernelTime' : [ 0x4a4, ['unsigned long']],
    'UserTime' : [ 0x4a8, ['unsigned long']],
    'DpcTime' : [ 0x4ac, ['unsigned long']],
    'DpcTimeCount' : [ 0x4b0, ['unsigned long']],
    'InterruptTime' : [ 0x4b4, ['unsigned long']],
    'AdjustDpcThreshold' : [ 0x4b8, ['unsigned long']],
    'PageColor' : [ 0x4bc, ['unsigned long']],
    'DebuggerSavedIRQL' : [ 0x4c0, ['unsigned char']],
    'NodeColor' : [ 0x4c1, ['unsigned char']],
    'DeepSleep' : [ 0x4c2, ['unsigned char']],
    'PrcbPad20' : [ 0x4c3, ['array', 5, ['unsigned char']]],
    'NodeShiftedColor' : [ 0x4c8, ['unsigned long']],
    'SecondaryColorMask' : [ 0x4cc, ['unsigned long']],
    'DpcTimeLimit' : [ 0x4d0, ['unsigned long']],
    'PrcbPad21' : [ 0x4d4, ['array', 3, ['unsigned long']]],
    'CcFastReadNoWait' : [ 0x4e0, ['unsigned long']],
    'CcFastReadWait' : [ 0x4e4, ['unsigned long']],
    'CcFastReadNotPossible' : [ 0x4e8, ['unsigned long']],
    'CcCopyReadNoWait' : [ 0x4ec, ['unsigned long']],
    'CcCopyReadWait' : [ 0x4f0, ['unsigned long']],
    'CcCopyReadNoWaitMiss' : [ 0x4f4, ['unsigned long']],
    'MmSpinLockOrdering' : [ 0x4f8, ['long']],
    'IoReadOperationCount' : [ 0x4fc, ['long']],
    'IoWriteOperationCount' : [ 0x500, ['long']],
    'IoOtherOperationCount' : [ 0x504, ['long']],
    'IoReadTransferCount' : [ 0x508, ['_LARGE_INTEGER']],
    'IoWriteTransferCount' : [ 0x510, ['_LARGE_INTEGER']],
    'IoOtherTransferCount' : [ 0x518, ['_LARGE_INTEGER']],
    'CcFastMdlReadNoWait' : [ 0x520, ['unsigned long']],
    'CcFastMdlReadWait' : [ 0x524, ['unsigned long']],
    'CcFastMdlReadNotPossible' : [ 0x528, ['unsigned long']],
    'CcMapDataNoWait' : [ 0x52c, ['unsigned long']],
    'CcMapDataWait' : [ 0x530, ['unsigned long']],
    'CcPinMappedDataCount' : [ 0x534, ['unsigned long']],
    'CcPinReadNoWait' : [ 0x538, ['unsigned long']],
    'CcPinReadWait' : [ 0x53c, ['unsigned long']],
    'CcMdlReadNoWait' : [ 0x540, ['unsigned long']],
    'CcMdlReadWait' : [ 0x544, ['unsigned long']],
    'CcLazyWriteHotSpots' : [ 0x548, ['unsigned long']],
    'CcLazyWriteIos' : [ 0x54c, ['unsigned long']],
    'CcLazyWritePages' : [ 0x550, ['unsigned long']],
    'CcDataFlushes' : [ 0x554, ['unsigned long']],
    'CcDataPages' : [ 0x558, ['unsigned long']],
    'CcLostDelayedWrites' : [ 0x55c, ['unsigned long']],
    'CcFastReadResourceMiss' : [ 0x560, ['unsigned long']],
    'CcCopyReadWaitMiss' : [ 0x564, ['unsigned long']],
    'CcFastMdlReadResourceMiss' : [ 0x568, ['unsigned long']],
    'CcMapDataNoWaitMiss' : [ 0x56c, ['unsigned long']],
    'CcMapDataWaitMiss' : [ 0x570, ['unsigned long']],
    'CcPinReadNoWaitMiss' : [ 0x574, ['unsigned long']],
    'CcPinReadWaitMiss' : [ 0x578, ['unsigned long']],
    'CcMdlReadNoWaitMiss' : [ 0x57c, ['unsigned long']],
    'CcMdlReadWaitMiss' : [ 0x580, ['unsigned long']],
    'CcReadAheadIos' : [ 0x584, ['unsigned long']],
    'KeAlignmentFixupCount' : [ 0x588, ['unsigned long']],
    'KeExceptionDispatchCount' : [ 0x58c, ['unsigned long']],
    'KeSystemCalls' : [ 0x590, ['unsigned long']],
    'AvailableTime' : [ 0x594, ['unsigned long']],
    'PrcbPad22' : [ 0x598, ['array', 2, ['unsigned long']]],
    'PPLookasideList' : [ 0x5a0, ['array', 16, ['_PP_LOOKASIDE_LIST']]],
    'PPNxPagedLookasideList' : [ 0x620, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PPNPagedLookasideList' : [ 0xf20, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PPPagedLookasideList' : [ 0x1820, ['array', 32, ['_GENERAL_LOOKASIDE_POOL']]],
    'PacketBarrier' : [ 0x2120, ['long']],
    'ReverseStall' : [ 0x2124, ['long']],
    'IpiFrame' : [ 0x2128, ['pointer', ['void']]],
    'PrcbPad3' : [ 0x212c, ['array', 52, ['unsigned char']]],
    'CurrentPacket' : [ 0x2160, ['array', 3, ['pointer', ['void']]]],
    'TargetSet' : [ 0x216c, ['unsigned long']],
    'WorkerRoutine' : [ 0x2170, ['pointer', ['void']]],
    'IpiFrozen' : [ 0x2174, ['unsigned long']],
    'PrcbPad4' : [ 0x2178, ['array', 40, ['unsigned char']]],
    'RequestSummary' : [ 0x21a0, ['unsigned long']],
    'TargetCount' : [ 0x21a4, ['long']],
    'PrcbPad50' : [ 0x21a8, ['array', 40, ['unsigned char']]],
    'InterruptLastCount' : [ 0x21d0, ['unsigned long']],
    'InterruptRate' : [ 0x21d4, ['unsigned long']],
    'DeviceInterrupts' : [ 0x21d8, ['unsigned long']],
    'IsrDpcStats' : [ 0x21dc, ['pointer', ['void']]],
    'DpcData' : [ 0x21e0, ['array', 2, ['_KDPC_DATA']]],
    'DpcStack' : [ 0x2210, ['pointer', ['void']]],
    'MaximumDpcQueueDepth' : [ 0x2214, ['long']],
    'DpcRequestRate' : [ 0x2218, ['unsigned long']],
    'MinimumDpcRate' : [ 0x221c, ['unsigned long']],
    'DpcLastCount' : [ 0x2220, ['unsigned long']],
    'PrcbLock' : [ 0x2224, ['unsigned long']],
    'DpcGate' : [ 0x2228, ['_KGATE']],
    'IdleState' : [ 0x2238, ['unsigned char']],
    'QuantumEnd' : [ 0x2239, ['unsigned char']],
    'DpcRoutineActive' : [ 0x223a, ['unsigned char']],
    'IdleSchedule' : [ 0x223b, ['unsigned char']],
    'DpcRequestSummary' : [ 0x223c, ['long']],
    'DpcRequestSlot' : [ 0x223c, ['array', 2, ['short']]],
    'NormalDpcState' : [ 0x223c, ['short']],
    'ThreadDpcState' : [ 0x223e, ['short']],
    'DpcNormalProcessingActive' : [ 0x223c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DpcNormalProcessingRequested' : [ 0x223c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DpcNormalThreadSignal' : [ 0x223c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DpcNormalTimerExpiration' : [ 0x223c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DpcNormalDpcPresent' : [ 0x223c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DpcNormalLocalInterrupt' : [ 0x223c, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DpcNormalSpare' : [ 0x223c, ['BitField', dict(start_bit = 6, end_bit = 16, native_type='unsigned long')]],
    'DpcThreadActive' : [ 0x223c, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'DpcThreadRequested' : [ 0x223c, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'DpcThreadSpare' : [ 0x223c, ['BitField', dict(start_bit = 18, end_bit = 32, native_type='unsigned long')]],
    'LastTimerHand' : [ 0x2240, ['unsigned long']],
    'LastTick' : [ 0x2244, ['unsigned long']],
    'PeriodicCount' : [ 0x2248, ['unsigned long']],
    'PeriodicBias' : [ 0x224c, ['unsigned long']],
    'ClockInterrupts' : [ 0x2250, ['unsigned long']],
    'ReadyScanTick' : [ 0x2254, ['unsigned long']],
    'GroupSchedulingOverQuota' : [ 0x2258, ['unsigned char']],
    'ThreadDpcEnable' : [ 0x2259, ['unsigned char']],
    'PrcbPad41' : [ 0x225a, ['array', 2, ['unsigned char']]],
    'TimerTable' : [ 0x2260, ['_KTIMER_TABLE']],
    'CallDpc' : [ 0x3aa0, ['_KDPC']],
    'ClockKeepAlive' : [ 0x3ac0, ['long']],
    'PrcbPad6' : [ 0x3ac4, ['array', 4, ['unsigned char']]],
    'DpcWatchdogPeriod' : [ 0x3ac8, ['long']],
    'DpcWatchdogCount' : [ 0x3acc, ['long']],
    'KeSpinLockOrdering' : [ 0x3ad0, ['long']],
    'PrcbPad70' : [ 0x3ad4, ['array', 1, ['unsigned long']]],
    'QueueIndex' : [ 0x3ad8, ['unsigned long']],
    'DeferredReadyListHead' : [ 0x3adc, ['_SINGLE_LIST_ENTRY']],
    'ReadySummary' : [ 0x3ae0, ['unsigned long']],
    'AffinitizedSelectionMask' : [ 0x3ae4, ['long']],
    'WaitLock' : [ 0x3ae8, ['unsigned long']],
    'WaitListHead' : [ 0x3aec, ['_LIST_ENTRY']],
    'ScbOffset' : [ 0x3af4, ['unsigned long']],
    'StartCycles' : [ 0x3af8, ['unsigned long long']],
    'TaggedCyclesStart' : [ 0x3b00, ['unsigned long long']],
    'TaggedCycles' : [ 0x3b08, ['array', 2, ['unsigned long long']]],
    'GenerationTarget' : [ 0x3b18, ['unsigned long long']],
    'CycleTime' : [ 0x3b20, ['unsigned long long']],
    'AffinitizedCycles' : [ 0x3b28, ['unsigned long long']],
    'HighCycleTime' : [ 0x3b30, ['unsigned long']],
    'Cycles' : [ 0x3b38, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'PrcbPad71' : [ 0x3b78, ['array', 10, ['unsigned long']]],
    'DispatcherReadyListHead' : [ 0x3ba0, ['array', 32, ['_LIST_ENTRY']]],
    'ChainedInterruptList' : [ 0x3ca0, ['pointer', ['void']]],
    'LookasideIrpFloat' : [ 0x3ca4, ['long']],
    'ScbQueue' : [ 0x3ca8, ['_RTL_RB_TREE']],
    'ScbList' : [ 0x3cb0, ['_LIST_ENTRY']],
    'MmPageFaultCount' : [ 0x3cb8, ['long']],
    'MmCopyOnWriteCount' : [ 0x3cbc, ['long']],
    'MmTransitionCount' : [ 0x3cc0, ['long']],
    'MmCacheTransitionCount' : [ 0x3cc4, ['long']],
    'MmDemandZeroCount' : [ 0x3cc8, ['long']],
    'MmPageReadCount' : [ 0x3ccc, ['long']],
    'MmPageReadIoCount' : [ 0x3cd0, ['long']],
    'MmCacheReadCount' : [ 0x3cd4, ['long']],
    'MmCacheIoCount' : [ 0x3cd8, ['long']],
    'MmDirtyPagesWriteCount' : [ 0x3cdc, ['long']],
    'MmDirtyWriteIoCount' : [ 0x3ce0, ['long']],
    'MmMappedPagesWriteCount' : [ 0x3ce4, ['long']],
    'MmMappedWriteIoCount' : [ 0x3ce8, ['long']],
    'CachedCommit' : [ 0x3cec, ['unsigned long']],
    'CachedResidentAvailable' : [ 0x3cf0, ['unsigned long']],
    'HyperPte' : [ 0x3cf4, ['pointer', ['void']]],
    'PrcbPad8' : [ 0x3cf8, ['array', 4, ['unsigned char']]],
    'VendorString' : [ 0x3cfc, ['array', 13, ['unsigned char']]],
    'InitialApicId' : [ 0x3d09, ['unsigned char']],
    'LogicalProcessorsPerPhysicalProcessor' : [ 0x3d0a, ['unsigned char']],
    'PrcbPad9' : [ 0x3d0b, ['array', 1, ['unsigned char']]],
    'FeatureBits' : [ 0x3d10, ['unsigned long long']],
    'UpdateSignature' : [ 0x3d18, ['_LARGE_INTEGER']],
    'IsrTime' : [ 0x3d20, ['unsigned long long']],
    'PrcbPad90' : [ 0x3d28, ['array', 2, ['unsigned long']]],
    'PowerState' : [ 0x3d30, ['_PROCESSOR_POWER_STATE']],
    'PrcbPad91' : [ 0x3eb0, ['array', 17, ['unsigned long']]],
    'DpcWatchdogDpc' : [ 0x3ef4, ['_KDPC']],
    'DpcWatchdogTimer' : [ 0x3f18, ['_KTIMER']],
    'HypercallPageList' : [ 0x3f40, ['_SLIST_HEADER']],
    'HypercallCachedPages' : [ 0x3f48, ['pointer', ['void']]],
    'VirtualApicAssist' : [ 0x3f4c, ['pointer', ['void']]],
    'StatisticsPage' : [ 0x3f50, ['pointer', ['unsigned long long']]],
    'Cache' : [ 0x3f54, ['array', 5, ['_CACHE_DESCRIPTOR']]],
    'CacheCount' : [ 0x3f90, ['unsigned long']],
    'PackageProcessorSet' : [ 0x3f94, ['_KAFFINITY_EX']],
    'SharedReadyQueueMask' : [ 0x3fa0, ['unsigned long']],
    'SharedReadyQueue' : [ 0x3fa4, ['pointer', ['_KSHARED_READY_QUEUE']]],
    'SharedQueueScanOwner' : [ 0x3fa8, ['unsigned long']],
    'CoreProcessorSet' : [ 0x3fac, ['unsigned long']],
    'ScanSiblingMask' : [ 0x3fb0, ['unsigned long']],
    'LLCMask' : [ 0x3fb4, ['unsigned long']],
    'CacheProcessorMask' : [ 0x3fb8, ['array', 5, ['unsigned long']]],
    'ScanSiblingIndex' : [ 0x3fcc, ['unsigned long']],
    'WheaInfo' : [ 0x3fd0, ['pointer', ['void']]],
    'EtwSupport' : [ 0x3fd4, ['pointer', ['void']]],
    'InterruptObjectPool' : [ 0x3fd8, ['_SLIST_HEADER']],
    'PrcbPad92' : [ 0x3fe0, ['array', 3, ['unsigned long']]],
    'PteBitCache' : [ 0x3fec, ['unsigned long']],
    'PteBitOffset' : [ 0x3ff0, ['unsigned long']],
    'PrcbPad93' : [ 0x3ff4, ['unsigned long']],
    'ProcessorProfileControlArea' : [ 0x3ff8, ['pointer', ['_PROCESSOR_PROFILE_CONTROL_AREA']]],
    'ProfileEventIndexAddress' : [ 0x3ffc, ['pointer', ['void']]],
    'TimerExpirationDpc' : [ 0x4000, ['_KDPC']],
    'SynchCounters' : [ 0x4020, ['_SYNCH_COUNTERS']],
    'FsCounters' : [ 0x40d8, ['_FILESYSTEM_DISK_COUNTERS']],
    'Context' : [ 0x40e8, ['pointer', ['_CONTEXT']]],
    'ContextFlagsInit' : [ 0x40ec, ['unsigned long']],
    'ExtendedState' : [ 0x40f0, ['pointer', ['_XSAVE_AREA']]],
    'EntropyTimingState' : [ 0x40f4, ['_KENTROPY_TIMING_STATE']],
    'IsrStack' : [ 0x421c, ['pointer', ['void']]],
    'VectorToInterruptObject' : [ 0x4220, ['array', 208, ['pointer', ['_KINTERRUPT']]]],
    'AbSelfIoBoostsList' : [ 0x4560, ['_SINGLE_LIST_ENTRY']],
    'AbPropagateBoostsList' : [ 0x4564, ['_SINGLE_LIST_ENTRY']],
    'AbDpc' : [ 0x4568, ['_KDPC']],
    'IoIrpStackProfilerCurrent' : [ 0x4588, ['_IOP_IRP_STACK_PROFILER']],
    'IoIrpStackProfilerPrevious' : [ 0x45dc, ['_IOP_IRP_STACK_PROFILER']],
    'TimerExpirationTrace' : [ 0x4630, ['array', 16, ['_KTIMER_EXPIRATION_TRACE']]],
    'TimerExpirationTraceCount' : [ 0x4730, ['unsigned long']],
    'ExSaPageArray' : [ 0x4734, ['pointer', ['void']]],
    'PrcbPad100' : [ 0x4738, ['array', 10, ['unsigned long']]],
    'LocalSharedReadyQueue' : [ 0x4760, ['_KSHARED_READY_QUEUE']],
    'PrcbPad95' : [ 0x4894, ['array', 12, ['unsigned char']]],
    'Mailbox' : [ 0x48a0, ['pointer', ['_REQUEST_MAILBOX']]],
    'PrcbPad' : [ 0x48a4, ['array', 60, ['unsigned char']]],
    'RequestMailbox' : [ 0x48e0, ['array', 1, ['_REQUEST_MAILBOX']]],
} ],
  '_KAPC' : [ 0x30, {
    'Type' : [ 0x0, ['unsigned char']],
    'SpareByte0' : [ 0x1, ['unsigned char']],
    'Size' : [ 0x2, ['unsigned char']],
    'SpareByte1' : [ 0x3, ['unsigned char']],
    'SpareLong0' : [ 0x4, ['unsigned long']],
    'Thread' : [ 0x8, ['pointer', ['_KTHREAD']]],
    'ApcListEntry' : [ 0xc, ['_LIST_ENTRY']],
    'KernelRoutine' : [ 0x14, ['pointer', ['void']]],
    'RundownRoutine' : [ 0x18, ['pointer', ['void']]],
    'NormalRoutine' : [ 0x1c, ['pointer', ['void']]],
    'Reserved' : [ 0x14, ['array', 3, ['pointer', ['void']]]],
    'NormalContext' : [ 0x20, ['pointer', ['void']]],
    'SystemArgument1' : [ 0x24, ['pointer', ['void']]],
    'SystemArgument2' : [ 0x28, ['pointer', ['void']]],
    'ApcStateIndex' : [ 0x2c, ['unsigned char']],
    'ApcMode' : [ 0x2d, ['unsigned char']],
    'Inserted' : [ 0x2e, ['unsigned char']],
} ],
  '_CPU_INFO' : [ 0x10, {
    'AsUINT32' : [ 0x0, ['array', 4, ['unsigned long']]],
    'Eax' : [ 0x0, ['unsigned long']],
    'Ebx' : [ 0x4, ['unsigned long']],
    'Ecx' : [ 0x8, ['unsigned long']],
    'Edx' : [ 0xc, ['unsigned long']],
} ],
  '_EXT_SET_PARAMETERS_V0' : [ 0x10, {
    'Version' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'NoWakeTolerance' : [ 0x8, ['long long']],
} ],
  '_PS_TRUSTLET_CREATE_ATTRIBUTES' : [ 0x18, {
    'TrustletIdentity' : [ 0x0, ['unsigned long long']],
    'Attributes' : [ 0x8, ['array', 1, ['_PS_TRUSTLET_ATTRIBUTE_DATA']]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_DATA' : [ 0x10, {
    'Header' : [ 0x0, ['_PS_TRUSTLET_ATTRIBUTE_HEADER']],
    'Data' : [ 0x8, ['array', 1, ['unsigned long long']]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_HEADER' : [ 0x8, {
    'AttributeType' : [ 0x0, ['_PS_TRUSTLET_ATTRIBUTE_TYPE']],
    'InstanceNumber' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
} ],
  '_TRUSTLET_MAILBOX_KEY' : [ 0x10, {
    'SecretValue' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '_TRUSTLET_COLLABORATION_ID' : [ 0x10, {
    'Value' : [ 0x0, ['array', 2, ['unsigned long long']]],
} ],
  '_KPROCESS' : [ 0xa8, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'ProfileListHead' : [ 0x10, ['_LIST_ENTRY']],
    'DirectoryTableBase' : [ 0x18, ['unsigned long']],
    'LdtDescriptor' : [ 0x1c, ['_KGDTENTRY']],
    'Int21Descriptor' : [ 0x24, ['_KIDTENTRY']],
    'ThreadListHead' : [ 0x2c, ['_LIST_ENTRY']],
    'ProcessLock' : [ 0x34, ['unsigned long']],
    'DeepFreezeStartTime' : [ 0x38, ['unsigned long long']],
    'Affinity' : [ 0x40, ['_KAFFINITY_EX']],
    'ReadyListHead' : [ 0x4c, ['_LIST_ENTRY']],
    'SwapListEntry' : [ 0x54, ['_SINGLE_LIST_ENTRY']],
    'ActiveProcessors' : [ 0x58, ['_KAFFINITY_EX']],
    'AutoAlignment' : [ 0x64, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='long')]],
    'DisableBoost' : [ 0x64, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='long')]],
    'DisableQuantum' : [ 0x64, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='long')]],
    'DeepFreeze' : [ 0x64, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'TimerVirtualization' : [ 0x64, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'CheckStackExtents' : [ 0x64, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'SpareFlags0' : [ 0x64, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned long')]],
    'ActiveGroupsMask' : [ 0x64, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ReservedFlags' : [ 0x64, ['BitField', dict(start_bit = 9, end_bit = 32, native_type='long')]],
    'ProcessFlags' : [ 0x64, ['long']],
    'BasePriority' : [ 0x68, ['unsigned char']],
    'QuantumReset' : [ 0x69, ['unsigned char']],
    'Visited' : [ 0x6a, ['unsigned char']],
    'Flags' : [ 0x6b, ['_KEXECUTE_OPTIONS']],
    'ThreadSeed' : [ 0x6c, ['array', 1, ['unsigned long']]],
    'IdealNode' : [ 0x70, ['array', 1, ['unsigned short']]],
    'IdealGlobalNode' : [ 0x72, ['unsigned short']],
    'Spare1' : [ 0x74, ['unsigned short']],
    'IopmOffset' : [ 0x76, ['unsigned short']],
    'SchedulingGroup' : [ 0x78, ['pointer', ['_KSCHEDULING_GROUP']]],
    'StackCount' : [ 0x7c, ['_KSTACK_COUNT']],
    'ProcessListEntry' : [ 0x80, ['_LIST_ENTRY']],
    'CycleTime' : [ 0x88, ['unsigned long long']],
    'ContextSwitches' : [ 0x90, ['unsigned long long']],
    'FreezeCount' : [ 0x98, ['unsigned long']],
    'KernelTime' : [ 0x9c, ['unsigned long']],
    'UserTime' : [ 0xa0, ['unsigned long']],
    'VdmTrapcHandler' : [ 0xa4, ['pointer', ['void']]],
} ],
  '_KTHREAD' : [ 0x348, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'SListFaultAddress' : [ 0x10, ['pointer', ['void']]],
    'QuantumTarget' : [ 0x18, ['unsigned long long']],
    'InitialStack' : [ 0x20, ['pointer', ['void']]],
    'StackLimit' : [ 0x24, ['pointer', ['void']]],
    'StackBase' : [ 0x28, ['pointer', ['void']]],
    'ThreadLock' : [ 0x2c, ['unsigned long']],
    'CycleTime' : [ 0x30, ['unsigned long long']],
    'HighCycleTime' : [ 0x38, ['unsigned long']],
    'ServiceTable' : [ 0x3c, ['pointer', ['void']]],
    'CurrentRunTime' : [ 0x40, ['unsigned long']],
    'ExpectedRunTime' : [ 0x44, ['unsigned long']],
    'KernelStack' : [ 0x48, ['pointer', ['void']]],
    'StateSaveArea' : [ 0x4c, ['pointer', ['_XSAVE_FORMAT']]],
    'SchedulingGroup' : [ 0x50, ['pointer', ['_KSCHEDULING_GROUP']]],
    'WaitRegister' : [ 0x54, ['_KWAIT_STATUS_REGISTER']],
    'Running' : [ 0x55, ['unsigned char']],
    'Alerted' : [ 0x56, ['array', 2, ['unsigned char']]],
    'AutoBoostActive' : [ 0x58, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadyTransition' : [ 0x58, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'WaitNext' : [ 0x58, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SystemAffinityActive' : [ 0x58, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Alertable' : [ 0x58, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'UserStackWalkActive' : [ 0x58, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ApcInterruptRequest' : [ 0x58, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'QuantumEndMigrate' : [ 0x58, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'UmsDirectedSwitchEnable' : [ 0x58, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'TimerActive' : [ 0x58, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'SystemThread' : [ 0x58, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ProcessDetachActive' : [ 0x58, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'CalloutActive' : [ 0x58, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ScbReadyQueue' : [ 0x58, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ApcQueueable' : [ 0x58, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ReservedStackInUse' : [ 0x58, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UmsPerformingSyscall' : [ 0x58, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'TimerSuspended' : [ 0x58, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'SuspendedWaitMode' : [ 0x58, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'SuspendSchedulerApcWait' : [ 0x58, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'Reserved' : [ 0x58, ['BitField', dict(start_bit = 20, end_bit = 32, native_type='unsigned long')]],
    'MiscFlags' : [ 0x58, ['long']],
    'AutoAlignment' : [ 0x5c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DisableBoost' : [ 0x5c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ThreadFlagsSpare0' : [ 0x5c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'AlertedByThreadId' : [ 0x5c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'QuantumDonation' : [ 0x5c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'EnableStackSwap' : [ 0x5c, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'GuiThread' : [ 0x5c, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DisableQuantum' : [ 0x5c, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ChargeOnlySchedulingGroup' : [ 0x5c, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DeferPreemption' : [ 0x5c, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'QueueDeferPreemption' : [ 0x5c, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ForceDeferSchedule' : [ 0x5c, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'SharedReadyQueueAffinity' : [ 0x5c, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'FreezeCount' : [ 0x5c, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'TerminationApcRequest' : [ 0x5c, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'AutoBoostEntriesExhausted' : [ 0x5c, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'KernelStackResident' : [ 0x5c, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'CommitFailTerminateRequest' : [ 0x5c, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'ProcessStackCountDecremented' : [ 0x5c, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'ThreadFlagsSpare' : [ 0x5c, ['BitField', dict(start_bit = 19, end_bit = 24, native_type='unsigned long')]],
    'EtwStackTraceApcInserted' : [ 0x5c, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'ThreadFlags' : [ 0x5c, ['long']],
    'Tag' : [ 0x60, ['unsigned char']],
    'SystemHeteroCpuPolicy' : [ 0x61, ['unsigned char']],
    'UserHeteroCpuPolicy' : [ 0x62, ['BitField', dict(start_bit = 0, end_bit = 7, native_type='unsigned char')]],
    'ExplicitSystemHeteroCpuPolicy' : [ 0x62, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Spare0' : [ 0x63, ['unsigned char']],
    'SystemCallNumber' : [ 0x64, ['unsigned long']],
    'FirstArgument' : [ 0x68, ['pointer', ['void']]],
    'TrapFrame' : [ 0x6c, ['pointer', ['_KTRAP_FRAME']]],
    'ApcState' : [ 0x70, ['_KAPC_STATE']],
    'ApcStateFill' : [ 0x70, ['array', 23, ['unsigned char']]],
    'Priority' : [ 0x87, ['unsigned char']],
    'UserIdealProcessor' : [ 0x88, ['unsigned long']],
    'ContextSwitches' : [ 0x8c, ['unsigned long']],
    'State' : [ 0x90, ['unsigned char']],
    'Spare12' : [ 0x91, ['unsigned char']],
    'WaitIrql' : [ 0x92, ['unsigned char']],
    'WaitMode' : [ 0x93, ['unsigned char']],
    'WaitStatus' : [ 0x94, ['long']],
    'WaitBlockList' : [ 0x98, ['pointer', ['_KWAIT_BLOCK']]],
    'WaitListEntry' : [ 0x9c, ['_LIST_ENTRY']],
    'SwapListEntry' : [ 0x9c, ['_SINGLE_LIST_ENTRY']],
    'Queue' : [ 0xa4, ['pointer', ['_DISPATCHER_HEADER']]],
    'Teb' : [ 0xa8, ['pointer', ['void']]],
    'RelativeTimerBias' : [ 0xb0, ['unsigned long long']],
    'Timer' : [ 0xb8, ['_KTIMER']],
    'WaitBlock' : [ 0xe0, ['array', 4, ['_KWAIT_BLOCK']]],
    'WaitBlockFill8' : [ 0xe0, ['array', 20, ['unsigned char']]],
    'ThreadCounters' : [ 0xf4, ['pointer', ['_KTHREAD_COUNTERS']]],
    'WaitBlockFill9' : [ 0xe0, ['array', 44, ['unsigned char']]],
    'XStateSave' : [ 0x10c, ['pointer', ['_XSTATE_SAVE']]],
    'WaitBlockFill10' : [ 0xe0, ['array', 68, ['unsigned char']]],
    'Win32Thread' : [ 0x124, ['pointer', ['void']]],
    'WaitBlockFill11' : [ 0xe0, ['array', 88, ['unsigned char']]],
    'WaitTime' : [ 0x138, ['unsigned long']],
    'KernelApcDisable' : [ 0x13c, ['short']],
    'SpecialApcDisable' : [ 0x13e, ['short']],
    'CombinedApcDisable' : [ 0x13c, ['unsigned long']],
    'QueueListEntry' : [ 0x140, ['_LIST_ENTRY']],
    'NextProcessor' : [ 0x148, ['unsigned long']],
    'NextProcessorNumber' : [ 0x148, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'SharedReadyQueue' : [ 0x148, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'QueuePriority' : [ 0x14c, ['long']],
    'Process' : [ 0x150, ['pointer', ['_KPROCESS']]],
    'UserAffinity' : [ 0x154, ['_GROUP_AFFINITY']],
    'UserAffinityFill' : [ 0x154, ['array', 6, ['unsigned char']]],
    'PreviousMode' : [ 0x15a, ['unsigned char']],
    'BasePriority' : [ 0x15b, ['unsigned char']],
    'PriorityDecrement' : [ 0x15c, ['unsigned char']],
    'ForegroundBoost' : [ 0x15c, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'UnusualBoost' : [ 0x15c, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'Preempted' : [ 0x15d, ['unsigned char']],
    'AdjustReason' : [ 0x15e, ['unsigned char']],
    'AdjustIncrement' : [ 0x15f, ['unsigned char']],
    'AffinityVersion' : [ 0x160, ['unsigned long']],
    'Affinity' : [ 0x164, ['_GROUP_AFFINITY']],
    'AffinityFill' : [ 0x164, ['array', 6, ['unsigned char']]],
    'ApcStateIndex' : [ 0x16a, ['unsigned char']],
    'WaitBlockCount' : [ 0x16b, ['unsigned char']],
    'IdealProcessor' : [ 0x16c, ['unsigned long']],
    'Spare15' : [ 0x170, ['array', 1, ['unsigned long']]],
    'SavedApcState' : [ 0x174, ['_KAPC_STATE']],
    'SavedApcStateFill' : [ 0x174, ['array', 23, ['unsigned char']]],
    'WaitReason' : [ 0x18b, ['unsigned char']],
    'SuspendCount' : [ 0x18c, ['unsigned char']],
    'Saturation' : [ 0x18d, ['unsigned char']],
    'SListFaultCount' : [ 0x18e, ['unsigned short']],
    'SchedulerApc' : [ 0x190, ['_KAPC']],
    'SchedulerApcFill0' : [ 0x190, ['array', 1, ['unsigned char']]],
    'ResourceIndex' : [ 0x191, ['unsigned char']],
    'SchedulerApcFill1' : [ 0x190, ['array', 3, ['unsigned char']]],
    'QuantumReset' : [ 0x193, ['unsigned char']],
    'SchedulerApcFill2' : [ 0x190, ['array', 4, ['unsigned char']]],
    'KernelTime' : [ 0x194, ['unsigned long']],
    'SchedulerApcFill3' : [ 0x190, ['array', 36, ['unsigned char']]],
    'WaitPrcb' : [ 0x1b4, ['pointer', ['_KPRCB']]],
    'SchedulerApcFill4' : [ 0x190, ['array', 40, ['unsigned char']]],
    'LegoData' : [ 0x1b8, ['pointer', ['void']]],
    'SchedulerApcFill5' : [ 0x190, ['array', 47, ['unsigned char']]],
    'CallbackNestingLevel' : [ 0x1bf, ['unsigned char']],
    'UserTime' : [ 0x1c0, ['unsigned long']],
    'SuspendEvent' : [ 0x1c4, ['_KEVENT']],
    'ThreadListEntry' : [ 0x1d4, ['_LIST_ENTRY']],
    'MutantListHead' : [ 0x1dc, ['_LIST_ENTRY']],
    'AbEntrySummary' : [ 0x1e4, ['unsigned char']],
    'AbWaitEntryCount' : [ 0x1e5, ['unsigned char']],
    'Spare20' : [ 0x1e6, ['unsigned short']],
    'LockEntries' : [ 0x1e8, ['array', 6, ['_KLOCK_ENTRY']]],
    'PropagateBoostsEntry' : [ 0x308, ['_SINGLE_LIST_ENTRY']],
    'IoSelfBoostsEntry' : [ 0x30c, ['_SINGLE_LIST_ENTRY']],
    'PriorityFloorCounts' : [ 0x310, ['array', 16, ['unsigned char']]],
    'PriorityFloorSummary' : [ 0x320, ['unsigned long']],
    'AbCompletedIoBoostCount' : [ 0x324, ['long']],
    'KeReferenceCount' : [ 0x328, ['short']],
    'AbOrphanedEntrySummary' : [ 0x32a, ['unsigned char']],
    'AbOwnedEntryCount' : [ 0x32b, ['unsigned char']],
    'ForegroundLossTime' : [ 0x32c, ['unsigned long']],
    'GlobalForegroundListEntry' : [ 0x330, ['_LIST_ENTRY']],
    'ForegroundDpcStackListEntry' : [ 0x330, ['_SINGLE_LIST_ENTRY']],
    'InGlobalForegroundList' : [ 0x334, ['unsigned long']],
    'QueuedScb' : [ 0x338, ['pointer', ['_KSCB']]],
    'NpxState' : [ 0x340, ['unsigned long long']],
} ],
  '_KSTACK_CONTROL' : [ 0x20, {
    'StackBase' : [ 0x0, ['unsigned long']],
    'ActualLimit' : [ 0x4, ['unsigned long']],
    'StackExpansion' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousTrapFrame' : [ 0x8, ['pointer', ['_KTRAP_FRAME']]],
    'PreviousExceptionList' : [ 0xc, ['pointer', ['void']]],
    'Previous' : [ 0x10, ['_KERNEL_STACK_SEGMENT']],
} ],
  '_KSPIN_LOCK_QUEUE' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_KSPIN_LOCK_QUEUE']]],
    'Lock' : [ 0x4, ['pointer', ['unsigned long']]],
} ],
  '_FAST_MUTEX' : [ 0x20, {
    'Count' : [ 0x0, ['long']],
    'Owner' : [ 0x4, ['pointer', ['void']]],
    'Contention' : [ 0x8, ['unsigned long']],
    'Event' : [ 0xc, ['_KEVENT']],
    'OldIrql' : [ 0x1c, ['unsigned long']],
} ],
  '_KEVENT' : [ 0x10, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
} ],
  '_SLIST_HEADER' : [ 0x8, {
    'Alignment' : [ 0x0, ['unsigned long long']],
    'Next' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x4, ['unsigned short']],
    'CpuId' : [ 0x6, ['unsigned short']],
} ],
  '_LOOKASIDE_LIST_EX' : [ 0x48, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE_POOL']],
} ],
  '_NPAGED_LOOKASIDE_LIST' : [ 0xc0, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE']],
    'Lock__ObsoleteButDoNotDelete' : [ 0x80, ['unsigned long']],
} ],
  '_PAGED_LOOKASIDE_LIST' : [ 0xc0, {
    'L' : [ 0x0, ['_GENERAL_LOOKASIDE']],
    'Lock__ObsoleteButDoNotDelete' : [ 0x80, ['_FAST_MUTEX']],
} ],
  '_IO_STATUS_BLOCK' : [ 0x8, {
    'Status' : [ 0x0, ['long']],
    'Pointer' : [ 0x0, ['pointer', ['void']]],
    'Information' : [ 0x4, ['unsigned long']],
} ],
  '_QUAD' : [ 0x8, {
    'UseThisFieldToCopy' : [ 0x0, ['long long']],
    'DoNotUseThisField' : [ 0x0, ['double']],
} ],
  '_WORK_QUEUE_ITEM' : [ 0x10, {
    'List' : [ 0x0, ['_LIST_ENTRY']],
    'WorkerRoutine' : [ 0x8, ['pointer', ['void']]],
    'Parameter' : [ 0xc, ['pointer', ['void']]],
} ],
  '_EXT_DELETE_PARAMETERS' : [ 0x10, {
    'Version' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'DeleteCallback' : [ 0x8, ['pointer', ['void']]],
    'DeleteContext' : [ 0xc, ['pointer', ['void']]],
} ],
  '_EX_PUSH_LOCK' : [ 0x4, {
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Waiting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Waking' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'MultipleShared' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
    'Ptr' : [ 0x0, ['pointer', ['void']]],
} ],
  '_PP_LOOKASIDE_LIST' : [ 0x8, {
    'P' : [ 0x0, ['pointer', ['_GENERAL_LOOKASIDE']]],
    'L' : [ 0x4, ['pointer', ['_GENERAL_LOOKASIDE']]],
} ],
  '_GENERAL_LOOKASIDE' : [ 0x80, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'SingleListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x8, ['unsigned short']],
    'MaximumDepth' : [ 0xa, ['unsigned short']],
    'TotalAllocates' : [ 0xc, ['unsigned long']],
    'AllocateMisses' : [ 0x10, ['unsigned long']],
    'AllocateHits' : [ 0x10, ['unsigned long']],
    'TotalFrees' : [ 0x14, ['unsigned long']],
    'FreeMisses' : [ 0x18, ['unsigned long']],
    'FreeHits' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPoolBase', 1: 'PagedPool', 2: 'NonPagedPoolBaseMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolBaseCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolBaseCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 516: 'NonPagedPoolNxCacheAligned', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 512: 'NonPagedPoolNx', 544: 'NonPagedPoolSessionNx', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'Tag' : [ 0x20, ['unsigned long']],
    'Size' : [ 0x24, ['unsigned long']],
    'AllocateEx' : [ 0x28, ['pointer', ['void']]],
    'Allocate' : [ 0x28, ['pointer', ['void']]],
    'FreeEx' : [ 0x2c, ['pointer', ['void']]],
    'Free' : [ 0x2c, ['pointer', ['void']]],
    'ListEntry' : [ 0x30, ['_LIST_ENTRY']],
    'LastTotalAllocates' : [ 0x38, ['unsigned long']],
    'LastAllocateMisses' : [ 0x3c, ['unsigned long']],
    'LastAllocateHits' : [ 0x3c, ['unsigned long']],
    'Future' : [ 0x40, ['array', 2, ['unsigned long']]],
} ],
  '_KNODE' : [ 0x100, {
    'IdleNonParkedCpuSet' : [ 0x0, ['unsigned long']],
    'IdleSmtSet' : [ 0x4, ['unsigned long']],
    'IdleCpuSet' : [ 0x8, ['unsigned long']],
    'DeepIdleSet' : [ 0x40, ['unsigned long']],
    'IdleConstrainedSet' : [ 0x44, ['unsigned long']],
    'NonParkedSet' : [ 0x48, ['unsigned long']],
    'ParkLock' : [ 0x4c, ['long']],
    'Seed' : [ 0x50, ['unsigned long']],
    'SiblingMask' : [ 0x80, ['unsigned long']],
    'Affinity' : [ 0x84, ['_GROUP_AFFINITY']],
    'AffinityFill' : [ 0x84, ['array', 6, ['unsigned char']]],
    'NodeNumber' : [ 0x8a, ['unsigned short']],
    'PrimaryNodeNumber' : [ 0x8c, ['unsigned short']],
    'Stride' : [ 0x8e, ['unsigned char']],
    'Spare0' : [ 0x8f, ['unsigned char']],
    'SharedReadyQueueLeaders' : [ 0x90, ['unsigned long']],
    'ProximityId' : [ 0x94, ['unsigned long']],
    'Lowest' : [ 0x98, ['unsigned long']],
    'Highest' : [ 0x9c, ['unsigned long']],
    'MaximumProcessors' : [ 0xa0, ['unsigned char']],
    'Flags' : [ 0xa1, ['_flags']],
    'Spare10' : [ 0xa2, ['unsigned char']],
    'HeteroSets' : [ 0xa4, ['array', 5, ['_KHETERO_PROCESSOR_SET']]],
} ],
  '_ENODE' : [ 0x380, {
    'Ncb' : [ 0x0, ['_KNODE']],
    'ExWorkQueues' : [ 0x100, ['array', 8, ['pointer', ['_EX_WORK_QUEUE']]]],
    'ExWorkQueue' : [ 0x120, ['_EX_WORK_QUEUE']],
    'ExpThreadSetManagerEvent' : [ 0x2d8, ['_KEVENT']],
    'ExpDeadlockTimer' : [ 0x2e8, ['_KTIMER']],
    'ExpThreadReaperEvent' : [ 0x310, ['_KEVENT']],
    'WaitBlocks' : [ 0x320, ['array', 3, ['_KWAIT_BLOCK']]],
    'ExpWorkerThreadBalanceManagerPtr' : [ 0x368, ['pointer', ['_ETHREAD']]],
    'ExpWorkerSeed' : [ 0x36c, ['unsigned long']],
    'ExWorkerFullInit' : [ 0x370, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ExWorkerStructInit' : [ 0x370, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ExWorkerFlags' : [ 0x370, ['unsigned long']],
} ],
  '_HANDLE_TABLE' : [ 0x5c, {
    'NextHandleNeedingPool' : [ 0x0, ['unsigned long']],
    'ExtraInfoPages' : [ 0x4, ['long']],
    'TableCode' : [ 0x8, ['unsigned long']],
    'QuotaProcess' : [ 0xc, ['pointer', ['_EPROCESS']]],
    'HandleTableList' : [ 0x10, ['_LIST_ENTRY']],
    'UniqueProcessId' : [ 0x18, ['unsigned long']],
    'Flags' : [ 0x1c, ['unsigned long']],
    'StrictFIFO' : [ 0x1c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'EnableHandleExceptions' : [ 0x1c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Rundown' : [ 0x1c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Duplicated' : [ 0x1c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'RaiseUMExceptionOnInvalidHandleClose' : [ 0x1c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'HandleContentionEvent' : [ 0x20, ['_EX_PUSH_LOCK']],
    'HandleTableLock' : [ 0x24, ['_EX_PUSH_LOCK']],
    'FreeLists' : [ 0x28, ['array', 1, ['_HANDLE_TABLE_FREE_LIST']]],
    'ActualEntry' : [ 0x28, ['array', 20, ['unsigned char']]],
    'DebugInfo' : [ 0x3c, ['pointer', ['_HANDLE_TRACE_DEBUG_INFO']]],
} ],
  '_HANDLE_TABLE_ENTRY_INFO' : [ 0x4, {
    'AuditMask' : [ 0x0, ['unsigned long']],
} ],
  '_HANDLE_TABLE_ENTRY' : [ 0x8, {
    'VolatileLowValue' : [ 0x0, ['long']],
    'LowValue' : [ 0x0, ['long']],
    'InfoTable' : [ 0x0, ['pointer', ['_HANDLE_TABLE_ENTRY_INFO']]],
    'HighValue' : [ 0x4, ['long']],
    'NextFreeHandleEntry' : [ 0x4, ['pointer', ['_HANDLE_TABLE_ENTRY']]],
    'LeafHandleValue' : [ 0x4, ['_EXHANDLE']],
    'Unlocked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Attributes' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned long')]],
    'ObjectPointerBits' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'RefCountField' : [ 0x4, ['long']],
    'GrantedAccessBits' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 25, native_type='unsigned long')]],
    'ProtectFromClose' : [ 0x4, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'NoRightsUpgrade' : [ 0x4, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'RefCnt' : [ 0x4, ['BitField', dict(start_bit = 27, end_bit = 32, native_type='unsigned long')]],
} ],
  '_EX_FAST_REF' : [ 0x4, {
    'Object' : [ 0x0, ['pointer', ['void']]],
    'RefCnt' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1336' : [ 0x2c, {
    'InitialPrivilegeSet' : [ 0x0, ['_INITIAL_PRIVILEGE_SET']],
    'PrivilegeSet' : [ 0x0, ['_PRIVILEGE_SET']],
} ],
  '_ACCESS_STATE' : [ 0x74, {
    'OperationID' : [ 0x0, ['_LUID']],
    'SecurityEvaluated' : [ 0x8, ['unsigned char']],
    'GenerateAudit' : [ 0x9, ['unsigned char']],
    'GenerateOnClose' : [ 0xa, ['unsigned char']],
    'PrivilegesAllocated' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['unsigned long']],
    'RemainingDesiredAccess' : [ 0x10, ['unsigned long']],
    'PreviouslyGrantedAccess' : [ 0x14, ['unsigned long']],
    'OriginalDesiredAccess' : [ 0x18, ['unsigned long']],
    'SubjectSecurityContext' : [ 0x1c, ['_SECURITY_SUBJECT_CONTEXT']],
    'SecurityDescriptor' : [ 0x2c, ['pointer', ['void']]],
    'AuxData' : [ 0x30, ['pointer', ['void']]],
    'Privileges' : [ 0x34, ['__unnamed_1336']],
    'AuditPrivileges' : [ 0x60, ['unsigned char']],
    'ObjectName' : [ 0x64, ['_UNICODE_STRING']],
    'ObjectTypeName' : [ 0x6c, ['_UNICODE_STRING']],
} ],
  '_AUX_ACCESS_DATA' : [ 0xc4, {
    'PrivilegesUsed' : [ 0x0, ['pointer', ['_PRIVILEGE_SET']]],
    'GenericMapping' : [ 0x4, ['_GENERIC_MAPPING']],
    'AccessesToAudit' : [ 0x14, ['unsigned long']],
    'MaximumAuditMask' : [ 0x18, ['unsigned long']],
    'TransactionId' : [ 0x1c, ['_GUID']],
    'NewSecurityDescriptor' : [ 0x2c, ['pointer', ['void']]],
    'ExistingSecurityDescriptor' : [ 0x30, ['pointer', ['void']]],
    'ParentSecurityDescriptor' : [ 0x34, ['pointer', ['void']]],
    'DeRefSecurityDescriptor' : [ 0x38, ['pointer', ['void']]],
    'SDLock' : [ 0x3c, ['pointer', ['void']]],
    'AccessReasons' : [ 0x40, ['_ACCESS_REASONS']],
    'GenerateStagingEvents' : [ 0xc0, ['unsigned char']],
} ],
  '_OBJECT_HANDLE_INFORMATION' : [ 0x8, {
    'HandleAttributes' : [ 0x0, ['unsigned long']],
    'GrantedAccess' : [ 0x4, ['unsigned long']],
} ],
  '_ETHREAD' : [ 0x458, {
    'Tcb' : [ 0x0, ['_KTHREAD']],
    'CreateTime' : [ 0x348, ['_LARGE_INTEGER']],
    'ExitTime' : [ 0x350, ['_LARGE_INTEGER']],
    'KeyedWaitChain' : [ 0x350, ['_LIST_ENTRY']],
    'ChargeOnlySession' : [ 0x358, ['pointer', ['void']]],
    'PostBlockList' : [ 0x35c, ['_LIST_ENTRY']],
    'ForwardLinkShadow' : [ 0x35c, ['pointer', ['void']]],
    'StartAddress' : [ 0x360, ['pointer', ['void']]],
    'TerminationPort' : [ 0x364, ['pointer', ['_TERMINATION_PORT']]],
    'ReaperLink' : [ 0x364, ['pointer', ['_ETHREAD']]],
    'KeyedWaitValue' : [ 0x364, ['pointer', ['void']]],
    'ActiveTimerListLock' : [ 0x368, ['unsigned long']],
    'ActiveTimerListHead' : [ 0x36c, ['_LIST_ENTRY']],
    'Cid' : [ 0x374, ['_CLIENT_ID']],
    'KeyedWaitSemaphore' : [ 0x37c, ['_KSEMAPHORE']],
    'AlpcWaitSemaphore' : [ 0x37c, ['_KSEMAPHORE']],
    'ClientSecurity' : [ 0x390, ['_PS_CLIENT_SECURITY_CONTEXT']],
    'IrpList' : [ 0x394, ['_LIST_ENTRY']],
    'TopLevelIrp' : [ 0x39c, ['unsigned long']],
    'DeviceToVerify' : [ 0x3a0, ['pointer', ['_DEVICE_OBJECT']]],
    'Win32StartAddress' : [ 0x3a4, ['pointer', ['void']]],
    'LegacyPowerObject' : [ 0x3a8, ['pointer', ['void']]],
    'ThreadListEntry' : [ 0x3ac, ['_LIST_ENTRY']],
    'RundownProtect' : [ 0x3b4, ['_EX_RUNDOWN_REF']],
    'ThreadLock' : [ 0x3b8, ['_EX_PUSH_LOCK']],
    'ReadClusterSize' : [ 0x3bc, ['unsigned long']],
    'MmLockOrdering' : [ 0x3c0, ['long']],
    'CmLockOrdering' : [ 0x3c4, ['long']],
    'CrossThreadFlags' : [ 0x3c8, ['unsigned long']],
    'Terminated' : [ 0x3c8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ThreadInserted' : [ 0x3c8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HideFromDebugger' : [ 0x3c8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ActiveImpersonationInfo' : [ 0x3c8, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'HardErrorsAreDisabled' : [ 0x3c8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'BreakOnTermination' : [ 0x3c8, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'SkipCreationMsg' : [ 0x3c8, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SkipTerminationMsg' : [ 0x3c8, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'CopyTokenOnOpen' : [ 0x3c8, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ThreadIoPriority' : [ 0x3c8, ['BitField', dict(start_bit = 9, end_bit = 12, native_type='unsigned long')]],
    'ThreadPagePriority' : [ 0x3c8, ['BitField', dict(start_bit = 12, end_bit = 15, native_type='unsigned long')]],
    'RundownFail' : [ 0x3c8, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UmsForceQueueTermination' : [ 0x3c8, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'IndirectCpuSets' : [ 0x3c8, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'ReservedCrossThreadFlags' : [ 0x3c8, ['BitField', dict(start_bit = 18, end_bit = 32, native_type='unsigned long')]],
    'SameThreadPassiveFlags' : [ 0x3cc, ['unsigned long']],
    'ActiveExWorker' : [ 0x3cc, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MemoryMaker' : [ 0x3cc, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'StoreLockThread' : [ 0x3cc, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ClonedThread' : [ 0x3cc, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'KeyedEventInUse' : [ 0x3cc, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'SelfTerminate' : [ 0x3cc, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'RespectIoPriority' : [ 0x3cc, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'ReservedSameThreadPassiveFlags' : [ 0x3cc, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
    'SameThreadApcFlags' : [ 0x3d0, ['unsigned long']],
    'OwnsProcessAddressSpaceExclusive' : [ 0x3d0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'OwnsProcessAddressSpaceShared' : [ 0x3d0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'HardFaultBehavior' : [ 0x3d0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'StartAddressInvalid' : [ 0x3d0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'EtwCalloutActive' : [ 0x3d0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'SuppressSymbolLoad' : [ 0x3d0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Prefetching' : [ 0x3d0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'OwnsVadExclusive' : [ 0x3d0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'SystemPagePriorityActive' : [ 0x3d1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SystemPagePriority' : [ 0x3d1, ['BitField', dict(start_bit = 1, end_bit = 4, native_type='unsigned char')]],
    'CacheManagerActive' : [ 0x3d4, ['unsigned char']],
    'DisablePageFaultClustering' : [ 0x3d5, ['unsigned char']],
    'ActiveFaultCount' : [ 0x3d6, ['unsigned char']],
    'LockOrderState' : [ 0x3d7, ['unsigned char']],
    'AlpcMessageId' : [ 0x3d8, ['unsigned long']],
    'AlpcMessage' : [ 0x3dc, ['pointer', ['void']]],
    'AlpcReceiveAttributeSet' : [ 0x3dc, ['unsigned long']],
    'ExitStatus' : [ 0x3e0, ['long']],
    'AlpcWaitListEntry' : [ 0x3e4, ['_LIST_ENTRY']],
    'CacheManagerCount' : [ 0x3ec, ['unsigned long']],
    'IoBoostCount' : [ 0x3f0, ['unsigned long']],
    'BoostList' : [ 0x3f4, ['_LIST_ENTRY']],
    'DeboostList' : [ 0x3fc, ['_LIST_ENTRY']],
    'BoostListLock' : [ 0x404, ['unsigned long']],
    'IrpListLock' : [ 0x408, ['unsigned long']],
    'ReservedForSynchTracking' : [ 0x40c, ['pointer', ['void']]],
    'CmCallbackListHead' : [ 0x410, ['_SINGLE_LIST_ENTRY']],
    'ActivityId' : [ 0x414, ['pointer', ['_GUID']]],
    'SeLearningModeListHead' : [ 0x418, ['_SINGLE_LIST_ENTRY']],
    'VerifierContext' : [ 0x41c, ['pointer', ['void']]],
    'KernelStackReference' : [ 0x420, ['unsigned long']],
    'AdjustedClientToken' : [ 0x424, ['pointer', ['void']]],
    'WorkingOnBehalfClient' : [ 0x428, ['pointer', ['void']]],
    'PropertySet' : [ 0x42c, ['_PS_PROPERTY_SET']],
    'PicoContext' : [ 0x438, ['pointer', ['void']]],
    'UserFsBase' : [ 0x43c, ['unsigned long']],
    'UserGsBase' : [ 0x440, ['unsigned long']],
    'EnergyValues' : [ 0x444, ['pointer', ['_THREAD_ENERGY_VALUES']]],
    'CmCellReferences' : [ 0x448, ['unsigned long']],
    'SelectedCpuSets' : [ 0x44c, ['unsigned long']],
    'SelectedCpuSetsIndirect' : [ 0x44c, ['pointer', ['unsigned long']]],
    'Silo' : [ 0x450, ['pointer', ['_EJOB']]],
} ],
  '_EPROCESS' : [ 0x370, {
    'Pcb' : [ 0x0, ['_KPROCESS']],
    'ProcessLock' : [ 0xa8, ['_EX_PUSH_LOCK']],
    'RundownProtect' : [ 0xac, ['_EX_RUNDOWN_REF']],
    'VdmObjects' : [ 0xb0, ['pointer', ['void']]],
    'UniqueProcessId' : [ 0xb4, ['pointer', ['void']]],
    'ActiveProcessLinks' : [ 0xb8, ['_LIST_ENTRY']],
    'Flags2' : [ 0xc0, ['unsigned long']],
    'JobNotReallyActive' : [ 0xc0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AccountingFolded' : [ 0xc0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'NewProcessReported' : [ 0xc0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ExitProcessReported' : [ 0xc0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ReportCommitChanges' : [ 0xc0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'LastReportMemory' : [ 0xc0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ForceWakeCharge' : [ 0xc0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'CrossSessionCreate' : [ 0xc0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'NeedsHandleRundown' : [ 0xc0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'RefTraceEnabled' : [ 0xc0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DisableDynamicCode' : [ 0xc0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'EmptyJobEvaluated' : [ 0xc0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'DefaultPagePriority' : [ 0xc0, ['BitField', dict(start_bit = 12, end_bit = 15, native_type='unsigned long')]],
    'PrimaryTokenFrozen' : [ 0xc0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ProcessVerifierTarget' : [ 0xc0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'StackRandomizationDisabled' : [ 0xc0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'AffinityPermanent' : [ 0xc0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'AffinityUpdateEnable' : [ 0xc0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'PropagateNode' : [ 0xc0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'ExplicitAffinity' : [ 0xc0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'ProcessExecutionState' : [ 0xc0, ['BitField', dict(start_bit = 22, end_bit = 24, native_type='unsigned long')]],
    'DisallowStrippedImages' : [ 0xc0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'HighEntropyASLREnabled' : [ 0xc0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'ExtensionPointDisable' : [ 0xc0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'ForceRelocateImages' : [ 0xc0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'ProcessStateChangeRequest' : [ 0xc0, ['BitField', dict(start_bit = 28, end_bit = 30, native_type='unsigned long')]],
    'ProcessStateChangeInProgress' : [ 0xc0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'DisallowWin32kSystemCalls' : [ 0xc0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'Flags' : [ 0xc4, ['unsigned long']],
    'CreateReported' : [ 0xc4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'NoDebugInherit' : [ 0xc4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessExiting' : [ 0xc4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessDelete' : [ 0xc4, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ControlFlowGuardEnabled' : [ 0xc4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'VmDeleted' : [ 0xc4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'OutswapEnabled' : [ 0xc4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Outswapped' : [ 0xc4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'FailFastOnCommitFail' : [ 0xc4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Wow64VaSpace4Gb' : [ 0xc4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'AddressSpaceInitialized' : [ 0xc4, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'SetTimerResolution' : [ 0xc4, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'BreakOnTermination' : [ 0xc4, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'DeprioritizeViews' : [ 0xc4, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'WriteWatch' : [ 0xc4, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ProcessInSession' : [ 0xc4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'OverrideAddressSpace' : [ 0xc4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HasAddressSpace' : [ 0xc4, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'LaunchPrefetched' : [ 0xc4, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'Background' : [ 0xc4, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'VmTopDown' : [ 0xc4, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'ImageNotifyDone' : [ 0xc4, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'PdeUpdateNeeded' : [ 0xc4, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'VdmAllowed' : [ 0xc4, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'ProcessRundown' : [ 0xc4, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'ProcessInserted' : [ 0xc4, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'DefaultIoPriority' : [ 0xc4, ['BitField', dict(start_bit = 27, end_bit = 30, native_type='unsigned long')]],
    'ProcessSelfDelete' : [ 0xc4, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'SetTimerResolutionLink' : [ 0xc4, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'CreateTime' : [ 0xc8, ['_LARGE_INTEGER']],
    'ProcessQuotaUsage' : [ 0xd0, ['array', 2, ['unsigned long']]],
    'ProcessQuotaPeak' : [ 0xd8, ['array', 2, ['unsigned long']]],
    'PeakVirtualSize' : [ 0xe0, ['unsigned long']],
    'VirtualSize' : [ 0xe4, ['unsigned long']],
    'SessionProcessLinks' : [ 0xe8, ['_LIST_ENTRY']],
    'ExceptionPortData' : [ 0xf0, ['pointer', ['void']]],
    'ExceptionPortValue' : [ 0xf0, ['unsigned long']],
    'ExceptionPortState' : [ 0xf0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Token' : [ 0xf4, ['_EX_FAST_REF']],
    'WorkingSetPage' : [ 0xf8, ['unsigned long']],
    'AddressCreationLock' : [ 0xfc, ['_EX_PUSH_LOCK']],
    'PageTableCommitmentLock' : [ 0x100, ['_EX_PUSH_LOCK']],
    'RotateInProgress' : [ 0x104, ['pointer', ['_ETHREAD']]],
    'ForkInProgress' : [ 0x108, ['pointer', ['_ETHREAD']]],
    'CommitChargeJob' : [ 0x10c, ['pointer', ['_EJOB']]],
    'CloneRoot' : [ 0x110, ['_RTL_AVL_TREE']],
    'NumberOfPrivatePages' : [ 0x114, ['unsigned long']],
    'NumberOfLockedPages' : [ 0x118, ['unsigned long']],
    'Win32Process' : [ 0x11c, ['pointer', ['void']]],
    'Job' : [ 0x120, ['pointer', ['_EJOB']]],
    'SectionObject' : [ 0x124, ['pointer', ['void']]],
    'SectionBaseAddress' : [ 0x128, ['pointer', ['void']]],
    'Cookie' : [ 0x12c, ['unsigned long']],
    'WorkingSetWatch' : [ 0x130, ['pointer', ['_PAGEFAULT_HISTORY']]],
    'Win32WindowStation' : [ 0x134, ['pointer', ['void']]],
    'InheritedFromUniqueProcessId' : [ 0x138, ['pointer', ['void']]],
    'LdtInformation' : [ 0x13c, ['pointer', ['void']]],
    'OwnerProcessId' : [ 0x140, ['unsigned long']],
    'Peb' : [ 0x144, ['pointer', ['_PEB']]],
    'Session' : [ 0x148, ['pointer', ['void']]],
    'AweInfo' : [ 0x14c, ['pointer', ['void']]],
    'QuotaBlock' : [ 0x150, ['pointer', ['_EPROCESS_QUOTA_BLOCK']]],
    'ObjectTable' : [ 0x154, ['pointer', ['_HANDLE_TABLE']]],
    'DebugPort' : [ 0x158, ['pointer', ['void']]],
    'PaeTop' : [ 0x15c, ['pointer', ['void']]],
    'DeviceMap' : [ 0x160, ['pointer', ['void']]],
    'EtwDataSource' : [ 0x164, ['pointer', ['void']]],
    'PageDirectoryPte' : [ 0x168, ['unsigned long long']],
    'ImageFilePointer' : [ 0x170, ['pointer', ['_FILE_OBJECT']]],
    'ImageFileName' : [ 0x174, ['array', 15, ['unsigned char']]],
    'PriorityClass' : [ 0x183, ['unsigned char']],
    'SecurityPort' : [ 0x184, ['pointer', ['void']]],
    'SeAuditProcessCreationInfo' : [ 0x188, ['_SE_AUDIT_PROCESS_CREATION_INFO']],
    'JobLinks' : [ 0x18c, ['_LIST_ENTRY']],
    'HighestUserAddress' : [ 0x194, ['pointer', ['void']]],
    'ThreadListHead' : [ 0x198, ['_LIST_ENTRY']],
    'ActiveThreads' : [ 0x1a0, ['unsigned long']],
    'ImagePathHash' : [ 0x1a4, ['unsigned long']],
    'DefaultHardErrorProcessing' : [ 0x1a8, ['unsigned long']],
    'LastThreadExitStatus' : [ 0x1ac, ['long']],
    'PrefetchTrace' : [ 0x1b0, ['_EX_FAST_REF']],
    'LockedPagesList' : [ 0x1b4, ['pointer', ['void']]],
    'ReadOperationCount' : [ 0x1b8, ['_LARGE_INTEGER']],
    'WriteOperationCount' : [ 0x1c0, ['_LARGE_INTEGER']],
    'OtherOperationCount' : [ 0x1c8, ['_LARGE_INTEGER']],
    'ReadTransferCount' : [ 0x1d0, ['_LARGE_INTEGER']],
    'WriteTransferCount' : [ 0x1d8, ['_LARGE_INTEGER']],
    'OtherTransferCount' : [ 0x1e0, ['_LARGE_INTEGER']],
    'CommitChargeLimit' : [ 0x1e8, ['unsigned long']],
    'CommitCharge' : [ 0x1ec, ['unsigned long']],
    'CommitChargePeak' : [ 0x1f0, ['unsigned long']],
    'Vm' : [ 0x1f4, ['_MMSUPPORT']],
    'MmProcessLinks' : [ 0x274, ['_LIST_ENTRY']],
    'ModifiedPageCount' : [ 0x27c, ['unsigned long']],
    'ExitStatus' : [ 0x280, ['long']],
    'VadRoot' : [ 0x284, ['_RTL_AVL_TREE']],
    'VadHint' : [ 0x288, ['pointer', ['void']]],
    'VadCount' : [ 0x28c, ['unsigned long']],
    'VadPhysicalPages' : [ 0x290, ['unsigned long']],
    'VadPhysicalPagesLimit' : [ 0x294, ['unsigned long']],
    'AlpcContext' : [ 0x298, ['_ALPC_PROCESS_CONTEXT']],
    'TimerResolutionLink' : [ 0x2a8, ['_LIST_ENTRY']],
    'TimerResolutionStackRecord' : [ 0x2b0, ['pointer', ['_PO_DIAG_STACK_RECORD']]],
    'RequestedTimerResolution' : [ 0x2b4, ['unsigned long']],
    'SmallestTimerResolution' : [ 0x2b8, ['unsigned long']],
    'ExitTime' : [ 0x2c0, ['_LARGE_INTEGER']],
    'ActiveThreadsHighWatermark' : [ 0x2c8, ['unsigned long']],
    'LargePrivateVadCount' : [ 0x2cc, ['unsigned long']],
    'ThreadListLock' : [ 0x2d0, ['_EX_PUSH_LOCK']],
    'WnfContext' : [ 0x2d4, ['pointer', ['void']]],
    'Spare0' : [ 0x2d8, ['unsigned long']],
    'SignatureLevel' : [ 0x2dc, ['unsigned char']],
    'SectionSignatureLevel' : [ 0x2dd, ['unsigned char']],
    'Protection' : [ 0x2de, ['_PS_PROTECTION']],
    'HangCount' : [ 0x2df, ['unsigned char']],
    'Flags3' : [ 0x2e0, ['unsigned long']],
    'Minimal' : [ 0x2e0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReplacingPageRoot' : [ 0x2e0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DisableNonSystemFonts' : [ 0x2e0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'AuditNonSystemFontLoading' : [ 0x2e0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Crashed' : [ 0x2e0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'JobVadsAreTracked' : [ 0x2e0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'VadTrackingDisabled' : [ 0x2e0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'AuxiliaryProcess' : [ 0x2e0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'SubsystemProcess' : [ 0x2e0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'IndirectCpuSets' : [ 0x2e0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'InPrivate' : [ 0x2e0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ProhibitRemoteImageMap' : [ 0x2e0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'ProhibitLowILImageMap' : [ 0x2e0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'SignatureMitigationOptIn' : [ 0x2e0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'DeviceAsid' : [ 0x2e4, ['long']],
    'SvmData' : [ 0x2e8, ['pointer', ['void']]],
    'SvmProcessLock' : [ 0x2ec, ['_EX_PUSH_LOCK']],
    'SvmLock' : [ 0x2f0, ['unsigned long']],
    'SvmProcessDeviceListHead' : [ 0x2f4, ['_LIST_ENTRY']],
    'LastFreezeInterruptTime' : [ 0x300, ['unsigned long long']],
    'DiskCounters' : [ 0x308, ['pointer', ['_PROCESS_DISK_COUNTERS']]],
    'PicoContext' : [ 0x30c, ['pointer', ['void']]],
    'KeepAliveCounter' : [ 0x310, ['unsigned long']],
    'NoWakeKeepAliveCounter' : [ 0x314, ['unsigned long']],
    'HighPriorityFaultsAllowed' : [ 0x318, ['unsigned long']],
    'InstrumentationCallback' : [ 0x31c, ['pointer', ['void']]],
    'EnergyValues' : [ 0x320, ['pointer', ['_PROCESS_ENERGY_VALUES']]],
    'VmContext' : [ 0x324, ['pointer', ['void']]],
    'SequenceNumber' : [ 0x328, ['unsigned long long']],
    'CreateInterruptTime' : [ 0x330, ['unsigned long long']],
    'CreateUnbiasedInterruptTime' : [ 0x338, ['unsigned long long']],
    'TotalUnbiasedFrozenTime' : [ 0x340, ['unsigned long long']],
    'LastAppStateUpdateTime' : [ 0x348, ['unsigned long long']],
    'LastAppStateUptime' : [ 0x350, ['BitField', dict(start_bit = 0, end_bit = 61, native_type='unsigned long long')]],
    'LastAppState' : [ 0x350, ['BitField', dict(start_bit = 61, end_bit = 64, native_type='unsigned long long')]],
    'SharedCommitCharge' : [ 0x358, ['unsigned long']],
    'SharedCommitLock' : [ 0x35c, ['_EX_PUSH_LOCK']],
    'SharedCommitLinks' : [ 0x360, ['_LIST_ENTRY']],
    'AllowedCpuSets' : [ 0x368, ['unsigned long']],
    'DefaultCpuSets' : [ 0x36c, ['unsigned long']],
    'AllowedCpuSetsIndirect' : [ 0x368, ['pointer', ['unsigned long']]],
    'DefaultCpuSetsIndirect' : [ 0x36c, ['pointer', ['unsigned long']]],
} ],
  '__unnamed_1390' : [ 0x4, {
    'MasterIrp' : [ 0x0, ['pointer', ['_IRP']]],
    'IrpCount' : [ 0x0, ['long']],
    'SystemBuffer' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_1396' : [ 0x8, {
    'UserApcRoutine' : [ 0x0, ['pointer', ['void']]],
    'IssuingProcess' : [ 0x0, ['pointer', ['void']]],
    'UserApcContext' : [ 0x4, ['pointer', ['void']]],
} ],
  '__unnamed_1398' : [ 0x8, {
    'AsynchronousParameters' : [ 0x0, ['__unnamed_1396']],
    'AllocationSize' : [ 0x0, ['_LARGE_INTEGER']],
} ],
  '__unnamed_13a1' : [ 0x2c, {
    'DeviceQueueEntry' : [ 0x0, ['_KDEVICE_QUEUE_ENTRY']],
    'DriverContext' : [ 0x0, ['array', 4, ['pointer', ['void']]]],
    'Thread' : [ 0x10, ['pointer', ['_ETHREAD']]],
    'AuxiliaryBuffer' : [ 0x14, ['pointer', ['unsigned char']]],
    'ListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'CurrentStackLocation' : [ 0x20, ['pointer', ['_IO_STACK_LOCATION']]],
    'PacketType' : [ 0x20, ['unsigned long']],
    'OriginalFileObject' : [ 0x24, ['pointer', ['_FILE_OBJECT']]],
    'IrpExtension' : [ 0x28, ['pointer', ['void']]],
} ],
  '__unnamed_13a3' : [ 0x30, {
    'Overlay' : [ 0x0, ['__unnamed_13a1']],
    'Apc' : [ 0x0, ['_KAPC']],
    'CompletionKey' : [ 0x0, ['pointer', ['void']]],
} ],
  '_IRP' : [ 0x70, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'MdlAddress' : [ 0x4, ['pointer', ['_MDL']]],
    'Flags' : [ 0x8, ['unsigned long']],
    'AssociatedIrp' : [ 0xc, ['__unnamed_1390']],
    'ThreadListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'IoStatus' : [ 0x18, ['_IO_STATUS_BLOCK']],
    'RequestorMode' : [ 0x20, ['unsigned char']],
    'PendingReturned' : [ 0x21, ['unsigned char']],
    'StackCount' : [ 0x22, ['unsigned char']],
    'CurrentLocation' : [ 0x23, ['unsigned char']],
    'Cancel' : [ 0x24, ['unsigned char']],
    'CancelIrql' : [ 0x25, ['unsigned char']],
    'ApcEnvironment' : [ 0x26, ['unsigned char']],
    'AllocationFlags' : [ 0x27, ['unsigned char']],
    'UserIosb' : [ 0x28, ['pointer', ['_IO_STATUS_BLOCK']]],
    'UserEvent' : [ 0x2c, ['pointer', ['_KEVENT']]],
    'Overlay' : [ 0x30, ['__unnamed_1398']],
    'CancelRoutine' : [ 0x38, ['pointer', ['void']]],
    'UserBuffer' : [ 0x3c, ['pointer', ['void']]],
    'Tail' : [ 0x40, ['__unnamed_13a3']],
} ],
  '__unnamed_13aa' : [ 0x10, {
    'SecurityContext' : [ 0x0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x4, ['unsigned long']],
    'FileAttributes' : [ 0x8, ['unsigned short']],
    'ShareAccess' : [ 0xa, ['unsigned short']],
    'EaLength' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_13ae' : [ 0x10, {
    'SecurityContext' : [ 0x0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned short']],
    'ShareAccess' : [ 0xa, ['unsigned short']],
    'Parameters' : [ 0xc, ['pointer', ['_NAMED_PIPE_CREATE_PARAMETERS']]],
} ],
  '__unnamed_13b2' : [ 0x10, {
    'SecurityContext' : [ 0x0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned short']],
    'ShareAccess' : [ 0xa, ['unsigned short']],
    'Parameters' : [ 0xc, ['pointer', ['_MAILSLOT_CREATE_PARAMETERS']]],
} ],
  '__unnamed_13b4' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'Key' : [ 0x4, ['unsigned long']],
    'ByteOffset' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '__unnamed_13b8' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileName' : [ 0x4, ['pointer', ['_UNICODE_STRING']]],
    'FileInformationClass' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileIsRemoteDeviceInformation', 52: 'FileUnusedInformation', 53: 'FileNumaNodeInformation', 54: 'FileStandardLinkInformation', 55: 'FileRemoteProtocolInformation', 56: 'FileRenameInformationBypassAccessCheck', 57: 'FileLinkInformationBypassAccessCheck', 58: 'FileVolumeNameInformation', 59: 'FileIdInformation', 60: 'FileIdExtdDirectoryInformation', 61: 'FileReplaceCompletionInformation', 62: 'FileHardLinkFullIdInformation', 63: 'FileIdExtdBothDirectoryInformation', 64: 'FileMaximumInformation'})]],
    'FileIndex' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_13ba' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned long']],
    'CompletionFilter' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_13bc' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileInformationClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileIsRemoteDeviceInformation', 52: 'FileUnusedInformation', 53: 'FileNumaNodeInformation', 54: 'FileStandardLinkInformation', 55: 'FileRemoteProtocolInformation', 56: 'FileRenameInformationBypassAccessCheck', 57: 'FileLinkInformationBypassAccessCheck', 58: 'FileVolumeNameInformation', 59: 'FileIdInformation', 60: 'FileIdExtdDirectoryInformation', 61: 'FileReplaceCompletionInformation', 62: 'FileHardLinkFullIdInformation', 63: 'FileIdExtdBothDirectoryInformation', 64: 'FileMaximumInformation'})]],
} ],
  '__unnamed_13be' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'FileInformationClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileIsRemoteDeviceInformation', 52: 'FileUnusedInformation', 53: 'FileNumaNodeInformation', 54: 'FileStandardLinkInformation', 55: 'FileRemoteProtocolInformation', 56: 'FileRenameInformationBypassAccessCheck', 57: 'FileLinkInformationBypassAccessCheck', 58: 'FileVolumeNameInformation', 59: 'FileIdInformation', 60: 'FileIdExtdDirectoryInformation', 61: 'FileReplaceCompletionInformation', 62: 'FileHardLinkFullIdInformation', 63: 'FileIdExtdBothDirectoryInformation', 64: 'FileMaximumInformation'})]],
    'FileObject' : [ 0x8, ['pointer', ['_FILE_OBJECT']]],
    'ReplaceIfExists' : [ 0xc, ['unsigned char']],
    'AdvanceOnly' : [ 0xd, ['unsigned char']],
    'ClusterCount' : [ 0xc, ['unsigned long']],
    'DeleteHandle' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_13c0' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'EaList' : [ 0x4, ['pointer', ['void']]],
    'EaListLength' : [ 0x8, ['unsigned long']],
    'EaIndex' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_13c2' : [ 0x4, {
    'Length' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_13c6' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned long']],
    'FsInformationClass' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {1: 'FileFsVolumeInformation', 2: 'FileFsLabelInformation', 3: 'FileFsSizeInformation', 4: 'FileFsDeviceInformation', 5: 'FileFsAttributeInformation', 6: 'FileFsControlInformation', 7: 'FileFsFullSizeInformation', 8: 'FileFsObjectIdInformation', 9: 'FileFsDriverPathInformation', 10: 'FileFsVolumeFlagsInformation', 11: 'FileFsSectorSizeInformation', 12: 'FileFsDataCopyInformation', 13: 'FileFsMetadataSizeInformation', 14: 'FileFsMaximumInformation'})]],
} ],
  '__unnamed_13c8' : [ 0x10, {
    'OutputBufferLength' : [ 0x0, ['unsigned long']],
    'InputBufferLength' : [ 0x4, ['unsigned long']],
    'FsControlCode' : [ 0x8, ['unsigned long']],
    'Type3InputBuffer' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_13cb' : [ 0x10, {
    'Length' : [ 0x0, ['pointer', ['_LARGE_INTEGER']]],
    'Key' : [ 0x4, ['unsigned long']],
    'ByteOffset' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '__unnamed_13cd' : [ 0x10, {
    'OutputBufferLength' : [ 0x0, ['unsigned long']],
    'InputBufferLength' : [ 0x4, ['unsigned long']],
    'IoControlCode' : [ 0x8, ['unsigned long']],
    'Type3InputBuffer' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_13cf' : [ 0x8, {
    'SecurityInformation' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_13d1' : [ 0x8, {
    'SecurityInformation' : [ 0x0, ['unsigned long']],
    'SecurityDescriptor' : [ 0x4, ['pointer', ['void']]],
} ],
  '__unnamed_13d5' : [ 0x8, {
    'Vpb' : [ 0x0, ['pointer', ['_VPB']]],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '__unnamed_13d9' : [ 0x4, {
    'Srb' : [ 0x0, ['pointer', ['_SCSI_REQUEST_BLOCK']]],
} ],
  '__unnamed_13dd' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'StartSid' : [ 0x4, ['pointer', ['void']]],
    'SidList' : [ 0x8, ['pointer', ['_FILE_GET_QUOTA_INFORMATION']]],
    'SidListLength' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_13e1' : [ 0x4, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'BusRelations', 1: 'EjectionRelations', 2: 'PowerRelations', 3: 'RemovalRelations', 4: 'TargetDeviceRelation', 5: 'SingleBusRelations', 6: 'TransportRelations'})]],
} ],
  '__unnamed_13e5' : [ 0x10, {
    'InterfaceType' : [ 0x0, ['pointer', ['_GUID']]],
    'Size' : [ 0x4, ['unsigned short']],
    'Version' : [ 0x6, ['unsigned short']],
    'Interface' : [ 0x8, ['pointer', ['_INTERFACE']]],
    'InterfaceSpecificData' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_13e9' : [ 0x4, {
    'Capabilities' : [ 0x0, ['pointer', ['_DEVICE_CAPABILITIES']]],
} ],
  '__unnamed_13ed' : [ 0x4, {
    'IoResourceRequirementList' : [ 0x0, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
} ],
  '__unnamed_13ef' : [ 0x10, {
    'WhichSpace' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x4, ['pointer', ['void']]],
    'Offset' : [ 0x8, ['unsigned long']],
    'Length' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_13f1' : [ 0x1, {
    'Lock' : [ 0x0, ['unsigned char']],
} ],
  '__unnamed_13f5' : [ 0x4, {
    'IdType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'BusQueryDeviceID', 1: 'BusQueryHardwareIDs', 2: 'BusQueryCompatibleIDs', 3: 'BusQueryInstanceID', 4: 'BusQueryDeviceSerialNumber', 5: 'BusQueryContainerID'})]],
} ],
  '__unnamed_13f9' : [ 0x8, {
    'DeviceTextType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceTextDescription', 1: 'DeviceTextLocationInformation'})]],
    'LocaleId' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_13fd' : [ 0x8, {
    'InPath' : [ 0x0, ['unsigned char']],
    'Reserved' : [ 0x1, ['array', 3, ['unsigned char']]],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceUsageTypeUndefined', 1: 'DeviceUsageTypePaging', 2: 'DeviceUsageTypeHibernation', 3: 'DeviceUsageTypeDumpFile', 4: 'DeviceUsageTypeBoot', 5: 'DeviceUsageTypePostDisplay'})]],
} ],
  '__unnamed_1401' : [ 0x4, {
    'PowerState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
} ],
  '__unnamed_1405' : [ 0x4, {
    'PowerSequence' : [ 0x0, ['pointer', ['_POWER_SEQUENCE']]],
} ],
  '__unnamed_140d' : [ 0x10, {
    'SystemContext' : [ 0x0, ['unsigned long']],
    'SystemPowerStateContext' : [ 0x0, ['_SYSTEM_POWER_STATE_CONTEXT']],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'SystemPowerState', 1: 'DevicePowerState'})]],
    'State' : [ 0x8, ['_POWER_STATE']],
    'ShutdownType' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject', 8: 'PowerActionDisplayOff'})]],
} ],
  '__unnamed_1411' : [ 0x8, {
    'AllocatedResources' : [ 0x0, ['pointer', ['_CM_RESOURCE_LIST']]],
    'AllocatedResourcesTranslated' : [ 0x4, ['pointer', ['_CM_RESOURCE_LIST']]],
} ],
  '__unnamed_1413' : [ 0x10, {
    'ProviderId' : [ 0x0, ['unsigned long']],
    'DataPath' : [ 0x4, ['pointer', ['void']]],
    'BufferSize' : [ 0x8, ['unsigned long']],
    'Buffer' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1415' : [ 0x10, {
    'Argument1' : [ 0x0, ['pointer', ['void']]],
    'Argument2' : [ 0x4, ['pointer', ['void']]],
    'Argument3' : [ 0x8, ['pointer', ['void']]],
    'Argument4' : [ 0xc, ['pointer', ['void']]],
} ],
  '__unnamed_1417' : [ 0x10, {
    'Create' : [ 0x0, ['__unnamed_13aa']],
    'CreatePipe' : [ 0x0, ['__unnamed_13ae']],
    'CreateMailslot' : [ 0x0, ['__unnamed_13b2']],
    'Read' : [ 0x0, ['__unnamed_13b4']],
    'Write' : [ 0x0, ['__unnamed_13b4']],
    'QueryDirectory' : [ 0x0, ['__unnamed_13b8']],
    'NotifyDirectory' : [ 0x0, ['__unnamed_13ba']],
    'QueryFile' : [ 0x0, ['__unnamed_13bc']],
    'SetFile' : [ 0x0, ['__unnamed_13be']],
    'QueryEa' : [ 0x0, ['__unnamed_13c0']],
    'SetEa' : [ 0x0, ['__unnamed_13c2']],
    'QueryVolume' : [ 0x0, ['__unnamed_13c6']],
    'SetVolume' : [ 0x0, ['__unnamed_13c6']],
    'FileSystemControl' : [ 0x0, ['__unnamed_13c8']],
    'LockControl' : [ 0x0, ['__unnamed_13cb']],
    'DeviceIoControl' : [ 0x0, ['__unnamed_13cd']],
    'QuerySecurity' : [ 0x0, ['__unnamed_13cf']],
    'SetSecurity' : [ 0x0, ['__unnamed_13d1']],
    'MountVolume' : [ 0x0, ['__unnamed_13d5']],
    'VerifyVolume' : [ 0x0, ['__unnamed_13d5']],
    'Scsi' : [ 0x0, ['__unnamed_13d9']],
    'QueryQuota' : [ 0x0, ['__unnamed_13dd']],
    'SetQuota' : [ 0x0, ['__unnamed_13c2']],
    'QueryDeviceRelations' : [ 0x0, ['__unnamed_13e1']],
    'QueryInterface' : [ 0x0, ['__unnamed_13e5']],
    'DeviceCapabilities' : [ 0x0, ['__unnamed_13e9']],
    'FilterResourceRequirements' : [ 0x0, ['__unnamed_13ed']],
    'ReadWriteConfig' : [ 0x0, ['__unnamed_13ef']],
    'SetLock' : [ 0x0, ['__unnamed_13f1']],
    'QueryId' : [ 0x0, ['__unnamed_13f5']],
    'QueryDeviceText' : [ 0x0, ['__unnamed_13f9']],
    'UsageNotification' : [ 0x0, ['__unnamed_13fd']],
    'WaitWake' : [ 0x0, ['__unnamed_1401']],
    'PowerSequence' : [ 0x0, ['__unnamed_1405']],
    'Power' : [ 0x0, ['__unnamed_140d']],
    'StartDevice' : [ 0x0, ['__unnamed_1411']],
    'WMI' : [ 0x0, ['__unnamed_1413']],
    'Others' : [ 0x0, ['__unnamed_1415']],
} ],
  '_IO_STACK_LOCATION' : [ 0x24, {
    'MajorFunction' : [ 0x0, ['unsigned char']],
    'MinorFunction' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['unsigned char']],
    'Control' : [ 0x3, ['unsigned char']],
    'Parameters' : [ 0x4, ['__unnamed_1417']],
    'DeviceObject' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
    'FileObject' : [ 0x18, ['pointer', ['_FILE_OBJECT']]],
    'CompletionRoutine' : [ 0x1c, ['pointer', ['void']]],
    'Context' : [ 0x20, ['pointer', ['void']]],
} ],
  '__unnamed_142d' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Wcb' : [ 0x0, ['_WAIT_CONTEXT_BLOCK']],
} ],
  '_DEVICE_OBJECT' : [ 0xb8, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'ReferenceCount' : [ 0x4, ['long']],
    'DriverObject' : [ 0x8, ['pointer', ['_DRIVER_OBJECT']]],
    'NextDevice' : [ 0xc, ['pointer', ['_DEVICE_OBJECT']]],
    'AttachedDevice' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'CurrentIrp' : [ 0x14, ['pointer', ['_IRP']]],
    'Timer' : [ 0x18, ['pointer', ['_IO_TIMER']]],
    'Flags' : [ 0x1c, ['unsigned long']],
    'Characteristics' : [ 0x20, ['unsigned long']],
    'Vpb' : [ 0x24, ['pointer', ['_VPB']]],
    'DeviceExtension' : [ 0x28, ['pointer', ['void']]],
    'DeviceType' : [ 0x2c, ['unsigned long']],
    'StackSize' : [ 0x30, ['unsigned char']],
    'Queue' : [ 0x34, ['__unnamed_142d']],
    'AlignmentRequirement' : [ 0x5c, ['unsigned long']],
    'DeviceQueue' : [ 0x60, ['_KDEVICE_QUEUE']],
    'Dpc' : [ 0x74, ['_KDPC']],
    'ActiveThreadCount' : [ 0x94, ['unsigned long']],
    'SecurityDescriptor' : [ 0x98, ['pointer', ['void']]],
    'DeviceLock' : [ 0x9c, ['_KEVENT']],
    'SectorSize' : [ 0xac, ['unsigned short']],
    'Spare1' : [ 0xae, ['unsigned short']],
    'DeviceObjectExtension' : [ 0xb0, ['pointer', ['_DEVOBJ_EXTENSION']]],
    'Reserved' : [ 0xb4, ['pointer', ['void']]],
} ],
  '_KDPC' : [ 0x20, {
    'TargetInfoAsUlong' : [ 0x0, ['unsigned long']],
    'Type' : [ 0x0, ['unsigned char']],
    'Importance' : [ 0x1, ['unsigned char']],
    'Number' : [ 0x2, ['unsigned short']],
    'DpcListEntry' : [ 0x4, ['_SINGLE_LIST_ENTRY']],
    'ProcessorHistory' : [ 0x8, ['unsigned long']],
    'DeferredRoutine' : [ 0xc, ['pointer', ['void']]],
    'DeferredContext' : [ 0x10, ['pointer', ['void']]],
    'SystemArgument1' : [ 0x14, ['pointer', ['void']]],
    'SystemArgument2' : [ 0x18, ['pointer', ['void']]],
    'DpcData' : [ 0x1c, ['pointer', ['void']]],
} ],
  '_IO_DRIVER_CREATE_CONTEXT' : [ 0x14, {
    'Size' : [ 0x0, ['short']],
    'ExtraCreateParameter' : [ 0x4, ['pointer', ['_ECP_LIST']]],
    'DeviceObjectHint' : [ 0x8, ['pointer', ['void']]],
    'TxnParameters' : [ 0xc, ['pointer', ['_TXN_PARAMETER_BLOCK']]],
    'SiloContext' : [ 0x10, ['pointer', ['_EJOB']]],
} ],
  '_EJOB' : [ 0x2f8, {
    'Event' : [ 0x0, ['_KEVENT']],
    'JobLinks' : [ 0x10, ['_LIST_ENTRY']],
    'ProcessListHead' : [ 0x18, ['_LIST_ENTRY']],
    'JobLock' : [ 0x20, ['_ERESOURCE']],
    'TotalUserTime' : [ 0x58, ['_LARGE_INTEGER']],
    'TotalKernelTime' : [ 0x60, ['_LARGE_INTEGER']],
    'TotalCycleTime' : [ 0x68, ['_LARGE_INTEGER']],
    'ThisPeriodTotalUserTime' : [ 0x70, ['_LARGE_INTEGER']],
    'ThisPeriodTotalKernelTime' : [ 0x78, ['_LARGE_INTEGER']],
    'TotalContextSwitches' : [ 0x80, ['unsigned long long']],
    'TotalPageFaultCount' : [ 0x88, ['unsigned long']],
    'TotalProcesses' : [ 0x8c, ['unsigned long']],
    'ActiveProcesses' : [ 0x90, ['unsigned long']],
    'TotalTerminatedProcesses' : [ 0x94, ['unsigned long']],
    'PerProcessUserTimeLimit' : [ 0x98, ['_LARGE_INTEGER']],
    'PerJobUserTimeLimit' : [ 0xa0, ['_LARGE_INTEGER']],
    'MinimumWorkingSetSize' : [ 0xa8, ['unsigned long']],
    'MaximumWorkingSetSize' : [ 0xac, ['unsigned long']],
    'LimitFlags' : [ 0xb0, ['unsigned long']],
    'ActiveProcessLimit' : [ 0xb4, ['unsigned long']],
    'Affinity' : [ 0xb8, ['_KAFFINITY_EX']],
    'AccessState' : [ 0xc4, ['pointer', ['_JOB_ACCESS_STATE']]],
    'AccessStateQuotaReference' : [ 0xc8, ['pointer', ['void']]],
    'UIRestrictionsClass' : [ 0xcc, ['unsigned long']],
    'EndOfJobTimeAction' : [ 0xd0, ['unsigned long']],
    'CompletionPort' : [ 0xd4, ['pointer', ['void']]],
    'CompletionKey' : [ 0xd8, ['pointer', ['void']]],
    'CompletionCount' : [ 0xe0, ['unsigned long long']],
    'SessionId' : [ 0xe8, ['unsigned long']],
    'SchedulingClass' : [ 0xec, ['unsigned long']],
    'ReadOperationCount' : [ 0xf0, ['unsigned long long']],
    'WriteOperationCount' : [ 0xf8, ['unsigned long long']],
    'OtherOperationCount' : [ 0x100, ['unsigned long long']],
    'ReadTransferCount' : [ 0x108, ['unsigned long long']],
    'WriteTransferCount' : [ 0x110, ['unsigned long long']],
    'OtherTransferCount' : [ 0x118, ['unsigned long long']],
    'DiskIoInfo' : [ 0x120, ['_PROCESS_DISK_COUNTERS']],
    'ProcessMemoryLimit' : [ 0x148, ['unsigned long']],
    'JobMemoryLimit' : [ 0x14c, ['unsigned long']],
    'JobTotalMemoryLimit' : [ 0x150, ['unsigned long']],
    'PeakProcessMemoryUsed' : [ 0x154, ['unsigned long']],
    'PeakJobMemoryUsed' : [ 0x158, ['unsigned long']],
    'EffectiveAffinity' : [ 0x15c, ['_KAFFINITY_EX']],
    'EffectivePerProcessUserTimeLimit' : [ 0x168, ['_LARGE_INTEGER']],
    'EffectiveMinimumWorkingSetSize' : [ 0x170, ['unsigned long']],
    'EffectiveMaximumWorkingSetSize' : [ 0x174, ['unsigned long']],
    'EffectiveProcessMemoryLimit' : [ 0x178, ['unsigned long']],
    'EffectiveProcessMemoryLimitJob' : [ 0x17c, ['pointer', ['_EJOB']]],
    'EffectivePerProcessUserTimeLimitJob' : [ 0x180, ['pointer', ['_EJOB']]],
    'EffectiveDiskIoRateLimitJob' : [ 0x184, ['pointer', ['_EJOB']]],
    'EffectiveNetIoRateLimitJob' : [ 0x188, ['pointer', ['_EJOB']]],
    'EffectiveHeapAttributionJob' : [ 0x18c, ['pointer', ['_EJOB']]],
    'EffectiveLimitFlags' : [ 0x190, ['unsigned long']],
    'EffectiveSchedulingClass' : [ 0x194, ['unsigned long']],
    'EffectiveFreezeCount' : [ 0x198, ['unsigned long']],
    'EffectiveBackgroundCount' : [ 0x19c, ['unsigned long']],
    'EffectiveSwapCount' : [ 0x1a0, ['unsigned long']],
    'EffectiveNotificationLimitCount' : [ 0x1a4, ['unsigned long']],
    'EffectivePriorityClass' : [ 0x1a8, ['unsigned char']],
    'PriorityClass' : [ 0x1a9, ['unsigned char']],
    'NestingDepth' : [ 0x1aa, ['unsigned char']],
    'Reserved1' : [ 0x1ab, ['array', 1, ['unsigned char']]],
    'CompletionFilter' : [ 0x1ac, ['unsigned long']],
    'WakeChannel' : [ 0x1b0, ['_WNF_STATE_NAME']],
    'WakeInfo' : [ 0x1b0, ['_PS_WAKE_INFORMATION']],
    'WakeFilter' : [ 0x1e8, ['_JOBOBJECT_WAKE_FILTER']],
    'LowEdgeLatchFilter' : [ 0x1f0, ['unsigned long']],
    'OwnedHighEdgeFilters' : [ 0x1f4, ['unsigned long']],
    'NotificationLink' : [ 0x1f8, ['pointer', ['_EJOB']]],
    'CurrentJobMemoryUsed' : [ 0x200, ['unsigned long long']],
    'NotificationInfo' : [ 0x208, ['pointer', ['_JOB_NOTIFICATION_INFORMATION']]],
    'NotificationInfoQuotaReference' : [ 0x20c, ['pointer', ['void']]],
    'NotificationPacket' : [ 0x210, ['pointer', ['_IO_MINI_COMPLETION_PACKET_USER']]],
    'CpuRateControl' : [ 0x214, ['pointer', ['_JOB_CPU_RATE_CONTROL']]],
    'EffectiveSchedulingGroup' : [ 0x218, ['pointer', ['void']]],
    'ReadyTime' : [ 0x220, ['unsigned long long']],
    'MemoryLimitsLock' : [ 0x228, ['_EX_PUSH_LOCK']],
    'SiblingJobLinks' : [ 0x22c, ['_LIST_ENTRY']],
    'ChildJobListHead' : [ 0x234, ['_LIST_ENTRY']],
    'ParentJob' : [ 0x23c, ['pointer', ['_EJOB']]],
    'RootJob' : [ 0x240, ['pointer', ['_EJOB']]],
    'IteratorListHead' : [ 0x244, ['_LIST_ENTRY']],
    'AncestorCount' : [ 0x24c, ['unsigned long']],
    'Ancestors' : [ 0x250, ['pointer', ['pointer', ['_EJOB']]]],
    'SessionObject' : [ 0x250, ['pointer', ['void']]],
    'Accounting' : [ 0x258, ['_EPROCESS_VALUES']],
    'ShadowActiveProcessCount' : [ 0x2a8, ['unsigned long']],
    'ActiveAuxiliaryProcessCount' : [ 0x2ac, ['unsigned long']],
    'SequenceNumber' : [ 0x2b0, ['unsigned long']],
    'TimerListLock' : [ 0x2b4, ['unsigned long']],
    'TimerListHead' : [ 0x2b8, ['_LIST_ENTRY']],
    'ContainerId' : [ 0x2c0, ['_GUID']],
    'Container' : [ 0x2d0, ['pointer', ['_SILO_CONTEXT']]],
    'PropertySet' : [ 0x2d4, ['_PS_PROPERTY_SET']],
    'NetRateControl' : [ 0x2e0, ['pointer', ['_JOB_NET_RATE_CONTROL']]],
    'IoRateControl' : [ 0x2e4, ['pointer', ['_JOB_IO_RATE_CONTROL']]],
    'JobFlags' : [ 0x2e8, ['unsigned long']],
    'CloseDone' : [ 0x2e8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MultiGroup' : [ 0x2e8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'OutstandingNotification' : [ 0x2e8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NotificationInProgress' : [ 0x2e8, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'UILimits' : [ 0x2e8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'CpuRateControlActive' : [ 0x2e8, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'OwnCpuRateControl' : [ 0x2e8, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'Terminating' : [ 0x2e8, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'WorkingSetLock' : [ 0x2e8, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'JobFrozen' : [ 0x2e8, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Background' : [ 0x2e8, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'WakeNotificationAllocated' : [ 0x2e8, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'WakeNotificationEnabled' : [ 0x2e8, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'WakeNotificationPending' : [ 0x2e8, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'LimitNotificationRequired' : [ 0x2e8, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ZeroCountNotificationRequired' : [ 0x2e8, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'CycleTimeNotificationRequired' : [ 0x2e8, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'CycleTimeNotificationPending' : [ 0x2e8, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'TimersVirtualized' : [ 0x2e8, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'JobSwapped' : [ 0x2e8, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'ViolationDetected' : [ 0x2e8, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'EmptyJobNotified' : [ 0x2e8, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'NoSystemCharge' : [ 0x2e8, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'DropNoWakeCharges' : [ 0x2e8, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'NoWakeChargePolicyDecided' : [ 0x2e8, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'NetRateControlActive' : [ 0x2e8, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'OwnNetRateControl' : [ 0x2e8, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'IoRateControlActive' : [ 0x2e8, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'OwnIoRateControl' : [ 0x2e8, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'DisallowNewProcesses' : [ 0x2e8, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'SpareJobFlags' : [ 0x2e8, ['BitField', dict(start_bit = 30, end_bit = 32, native_type='unsigned long')]],
    'EffectiveHighEdgeFilters' : [ 0x2ec, ['unsigned long']],
    'EnergyValues' : [ 0x2f0, ['pointer', ['_PROCESS_ENERGY_VALUES']]],
    'SharedCommitCharge' : [ 0x2f4, ['unsigned long']],
} ],
  '_IO_PRIORITY_INFO' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned long']],
    'ThreadPriority' : [ 0x4, ['unsigned long']],
    'PagePriority' : [ 0x8, ['unsigned long']],
    'IoPriority' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'IoPriorityVeryLow', 1: 'IoPriorityLow', 2: 'IoPriorityNormal', 3: 'IoPriorityHigh', 4: 'IoPriorityCritical', 5: 'MaxIoPriorityTypes'})]],
} ],
  '_MDL' : [ 0x1c, {
    'Next' : [ 0x0, ['pointer', ['_MDL']]],
    'Size' : [ 0x4, ['short']],
    'MdlFlags' : [ 0x6, ['short']],
    'Process' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'MappedSystemVa' : [ 0xc, ['pointer', ['void']]],
    'StartVa' : [ 0x10, ['pointer', ['void']]],
    'ByteCount' : [ 0x14, ['unsigned long']],
    'ByteOffset' : [ 0x18, ['unsigned long']],
} ],
  '_EVENT_DATA_DESCRIPTOR' : [ 0x10, {
    'Ptr' : [ 0x0, ['unsigned long long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned char']],
    'Reserved1' : [ 0xd, ['unsigned char']],
    'Reserved2' : [ 0xe, ['unsigned short']],
} ],
  '_EVENT_DESCRIPTOR' : [ 0x10, {
    'Id' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned char']],
    'Channel' : [ 0x3, ['unsigned char']],
    'Level' : [ 0x4, ['unsigned char']],
    'Opcode' : [ 0x5, ['unsigned char']],
    'Task' : [ 0x6, ['unsigned short']],
    'Keyword' : [ 0x8, ['unsigned long long']],
} ],
  '_EVENT_RECORD' : [ 0x68, {
    'EventHeader' : [ 0x0, ['_EVENT_HEADER']],
    'BufferContext' : [ 0x50, ['_ETW_BUFFER_CONTEXT']],
    'ExtendedDataCount' : [ 0x54, ['unsigned short']],
    'UserDataLength' : [ 0x56, ['unsigned short']],
    'ExtendedData' : [ 0x58, ['pointer', ['_EVENT_HEADER_EXTENDED_DATA_ITEM']]],
    'UserData' : [ 0x5c, ['pointer', ['void']]],
    'UserContext' : [ 0x60, ['pointer', ['void']]],
} ],
  '_PERFINFO_GROUPMASK' : [ 0x20, {
    'Masks' : [ 0x0, ['array', 8, ['unsigned long']]],
} ],
  '_FILE_OBJECT' : [ 0x80, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'Vpb' : [ 0x8, ['pointer', ['_VPB']]],
    'FsContext' : [ 0xc, ['pointer', ['void']]],
    'FsContext2' : [ 0x10, ['pointer', ['void']]],
    'SectionObjectPointer' : [ 0x14, ['pointer', ['_SECTION_OBJECT_POINTERS']]],
    'PrivateCacheMap' : [ 0x18, ['pointer', ['void']]],
    'FinalStatus' : [ 0x1c, ['long']],
    'RelatedFileObject' : [ 0x20, ['pointer', ['_FILE_OBJECT']]],
    'LockOperation' : [ 0x24, ['unsigned char']],
    'DeletePending' : [ 0x25, ['unsigned char']],
    'ReadAccess' : [ 0x26, ['unsigned char']],
    'WriteAccess' : [ 0x27, ['unsigned char']],
    'DeleteAccess' : [ 0x28, ['unsigned char']],
    'SharedRead' : [ 0x29, ['unsigned char']],
    'SharedWrite' : [ 0x2a, ['unsigned char']],
    'SharedDelete' : [ 0x2b, ['unsigned char']],
    'Flags' : [ 0x2c, ['unsigned long']],
    'FileName' : [ 0x30, ['_UNICODE_STRING']],
    'CurrentByteOffset' : [ 0x38, ['_LARGE_INTEGER']],
    'Waiters' : [ 0x40, ['unsigned long']],
    'Busy' : [ 0x44, ['unsigned long']],
    'LastLock' : [ 0x48, ['pointer', ['void']]],
    'Lock' : [ 0x4c, ['_KEVENT']],
    'Event' : [ 0x5c, ['_KEVENT']],
    'CompletionContext' : [ 0x6c, ['pointer', ['_IO_COMPLETION_CONTEXT']]],
    'IrpListLock' : [ 0x70, ['unsigned long']],
    'IrpList' : [ 0x74, ['_LIST_ENTRY']],
    'FileObjectExtension' : [ 0x7c, ['pointer', ['void']]],
} ],
  '_EX_RUNDOWN_REF' : [ 0x4, {
    'Count' : [ 0x0, ['unsigned long']],
    'Ptr' : [ 0x0, ['pointer', ['void']]],
} ],
  '_MM_PAGE_ACCESS_INFO_HEADER' : [ 0x38, {
    'Link' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Type' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'MmPteAccessType', 1: 'MmCcReadAheadType', 2: 'MmPfnRepurposeType', 3: 'MmMaximumPageAccessType'})]],
    'EmptySequenceNumber' : [ 0x8, ['unsigned long']],
    'CurrentFileIndex' : [ 0x8, ['unsigned long']],
    'CreateTime' : [ 0x10, ['unsigned long long']],
    'EmptyTime' : [ 0x18, ['unsigned long long']],
    'TempEntry' : [ 0x18, ['pointer', ['_MM_PAGE_ACCESS_INFO']]],
    'PageEntry' : [ 0x20, ['pointer', ['_MM_PAGE_ACCESS_INFO']]],
    'FileEntry' : [ 0x24, ['pointer', ['unsigned long']]],
    'FirstFileEntry' : [ 0x28, ['pointer', ['unsigned long']]],
    'Process' : [ 0x2c, ['pointer', ['_EPROCESS']]],
    'SessionId' : [ 0x30, ['unsigned long']],
    'PageFrameEntry' : [ 0x20, ['pointer', ['unsigned long']]],
    'LastPageFrameEntry' : [ 0x24, ['pointer', ['unsigned long']]],
} ],
  '_WHEA_ERROR_PACKET_V2' : [ 0x50, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['_WHEA_ERROR_PACKET_FLAGS']],
    'ErrorType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrTypeProcessor', 1: 'WheaErrTypeMemory', 2: 'WheaErrTypePCIExpress', 3: 'WheaErrTypeNMI', 4: 'WheaErrTypePCIXBus', 5: 'WheaErrTypePCIXDevice', 6: 'WheaErrTypeGeneric'})]],
    'ErrorSeverity' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSevRecoverable', 1: 'WheaErrSevFatal', 2: 'WheaErrSevCorrected', 3: 'WheaErrSevInformational'})]],
    'ErrorSourceId' : [ 0x18, ['unsigned long']],
    'ErrorSourceType' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSrcTypeMCE', 1: 'WheaErrSrcTypeCMC', 2: 'WheaErrSrcTypeCPE', 3: 'WheaErrSrcTypeNMI', 4: 'WheaErrSrcTypePCIe', 5: 'WheaErrSrcTypeGeneric', 6: 'WheaErrSrcTypeINIT', 7: 'WheaErrSrcTypeBOOT', 8: 'WheaErrSrcTypeSCIGeneric', 9: 'WheaErrSrcTypeIPFMCA', 10: 'WheaErrSrcTypeIPFCMC', 11: 'WheaErrSrcTypeIPFCPE', 12: 'WheaErrSrcTypeMax'})]],
    'NotifyType' : [ 0x20, ['_GUID']],
    'Context' : [ 0x30, ['unsigned long long']],
    'DataFormat' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: 'WheaDataFormatIPFSalRecord', 1: 'WheaDataFormatXPFMCA', 2: 'WheaDataFormatMemory', 3: 'WheaDataFormatPCIExpress', 4: 'WheaDataFormatNMIPort', 5: 'WheaDataFormatPCIXBus', 6: 'WheaDataFormatPCIXDevice', 7: 'WheaDataFormatGeneric', 8: 'WheaDataFormatMax'})]],
    'Reserved1' : [ 0x3c, ['unsigned long']],
    'DataOffset' : [ 0x40, ['unsigned long']],
    'DataLength' : [ 0x44, ['unsigned long']],
    'PshedDataOffset' : [ 0x48, ['unsigned long']],
    'PshedDataLength' : [ 0x4c, ['unsigned long']],
} ],
  '_WHEA_ERROR_RECORD' : [ 0xc8, {
    'Header' : [ 0x0, ['_WHEA_ERROR_RECORD_HEADER']],
    'SectionDescriptor' : [ 0x80, ['array', 1, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR']]],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR' : [ 0x48, {
    'SectionOffset' : [ 0x0, ['unsigned long']],
    'SectionLength' : [ 0x4, ['unsigned long']],
    'Revision' : [ 0x8, ['_WHEA_REVISION']],
    'ValidBits' : [ 0xa, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS']],
    'Reserved' : [ 0xb, ['unsigned char']],
    'Flags' : [ 0xc, ['_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS']],
    'SectionType' : [ 0x10, ['_GUID']],
    'FRUId' : [ 0x20, ['_GUID']],
    'SectionSeverity' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSevRecoverable', 1: 'WheaErrSevFatal', 2: 'WheaErrSevCorrected', 3: 'WheaErrSevInformational'})]],
    'FRUText' : [ 0x34, ['array', 20, ['unsigned char']]],
} ],
  '_FSRTL_ADVANCED_FCB_HEADER' : [ 0x48, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'Flags' : [ 0x4, ['unsigned char']],
    'IsFastIoPossible' : [ 0x5, ['unsigned char']],
    'Flags2' : [ 0x6, ['unsigned char']],
    'Reserved' : [ 0x7, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned char')]],
    'Version' : [ 0x7, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'Resource' : [ 0x8, ['pointer', ['_ERESOURCE']]],
    'PagingIoResource' : [ 0xc, ['pointer', ['_ERESOURCE']]],
    'AllocationSize' : [ 0x10, ['_LARGE_INTEGER']],
    'FileSize' : [ 0x18, ['_LARGE_INTEGER']],
    'ValidDataLength' : [ 0x20, ['_LARGE_INTEGER']],
    'FastMutex' : [ 0x28, ['pointer', ['_FAST_MUTEX']]],
    'FilterContexts' : [ 0x2c, ['_LIST_ENTRY']],
    'PushLock' : [ 0x34, ['_EX_PUSH_LOCK']],
    'FileContextSupportPointer' : [ 0x38, ['pointer', ['pointer', ['void']]]],
    'Oplock' : [ 0x3c, ['pointer', ['void']]],
    'ReservedForRemote' : [ 0x3c, ['pointer', ['void']]],
    'ReservedContext' : [ 0x40, ['pointer', ['void']]],
} ],
  '_iobuf' : [ 0x20, {
    '_ptr' : [ 0x0, ['pointer', ['unsigned char']]],
    '_cnt' : [ 0x4, ['long']],
    '_base' : [ 0x8, ['pointer', ['unsigned char']]],
    '_flag' : [ 0xc, ['long']],
    '_file' : [ 0x10, ['long']],
    '_charbuf' : [ 0x14, ['long']],
    '_bufsiz' : [ 0x18, ['long']],
    '_tmpfname' : [ 0x1c, ['pointer', ['unsigned char']]],
} ],
  '_TlgProvider_t' : [ 0x30, {
    'LevelPlus1' : [ 0x0, ['unsigned long']],
    'ProviderMetadataPtr' : [ 0x4, ['pointer', ['unsigned short']]],
    'KeywordAny' : [ 0x8, ['unsigned long long']],
    'KeywordAll' : [ 0x10, ['unsigned long long']],
    'RegHandle' : [ 0x18, ['unsigned long long']],
    'EnableCallback' : [ 0x20, ['pointer', ['void']]],
    'CallbackContext' : [ 0x24, ['pointer', ['void']]],
    'AnnotationFunc' : [ 0x28, ['pointer', ['void']]],
} ],
  '_EVENT_FILTER_DESCRIPTOR' : [ 0x10, {
    'Ptr' : [ 0x0, ['unsigned long long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned long']],
} ],
  '_TlgProviderMetadata_t' : [ 0x13, {
    'Type' : [ 0x0, ['unsigned char']],
    'ProviderId' : [ 0x1, ['_GUID']],
    'RemainingSize' : [ 0x11, ['unsigned short']],
} ],
  '_SID' : [ 0xc, {
    'Revision' : [ 0x0, ['unsigned char']],
    'SubAuthorityCount' : [ 0x1, ['unsigned char']],
    'IdentifierAuthority' : [ 0x2, ['_SID_IDENTIFIER_AUTHORITY']],
    'SubAuthority' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '__unnamed_1618' : [ 0x8, {
    'Long' : [ 0x0, ['unsigned long long']],
    'VolatileLong' : [ 0x0, ['unsigned long long']],
    'HighLow' : [ 0x0, ['_MMPTE_HIGHLOW']],
    'Flush' : [ 0x0, ['_HARDWARE_PTE']],
    'Hard' : [ 0x0, ['_MMPTE_HARDWARE']],
    'Proto' : [ 0x0, ['_MMPTE_PROTOTYPE']],
    'Soft' : [ 0x0, ['_MMPTE_SOFTWARE']],
    'TimeStamp' : [ 0x0, ['_MMPTE_TIMESTAMP']],
    'Trans' : [ 0x0, ['_MMPTE_TRANSITION']],
    'Subsect' : [ 0x0, ['_MMPTE_SUBSECTION']],
    'List' : [ 0x0, ['_MMPTE_LIST']],
} ],
  '_MMPTE' : [ 0x8, {
    'u' : [ 0x0, ['__unnamed_1618']],
} ],
  '_EX_PUSH_LOCK_AUTO_EXPAND' : [ 0xc, {
    'LocalLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'State' : [ 0x4, ['_EX_PUSH_LOCK_AUTO_EXPAND_STATE']],
    'Stats' : [ 0x8, ['unsigned long']],
} ],
  '_ERESOURCE' : [ 0x38, {
    'SystemResourcesList' : [ 0x0, ['_LIST_ENTRY']],
    'OwnerTable' : [ 0x8, ['pointer', ['_OWNER_ENTRY']]],
    'ActiveCount' : [ 0xc, ['short']],
    'Flag' : [ 0xe, ['unsigned short']],
    'ReservedLowFlags' : [ 0xe, ['unsigned char']],
    'WaiterPriority' : [ 0xf, ['unsigned char']],
    'SharedWaiters' : [ 0x10, ['_KWAIT_CHAIN']],
    'ExclusiveWaiters' : [ 0x14, ['pointer', ['_KEVENT']]],
    'OwnerEntry' : [ 0x18, ['_OWNER_ENTRY']],
    'ActiveEntries' : [ 0x20, ['unsigned long']],
    'ContentionCount' : [ 0x24, ['unsigned long']],
    'NumberOfSharedWaiters' : [ 0x28, ['unsigned long']],
    'NumberOfExclusiveWaiters' : [ 0x2c, ['unsigned long']],
    'Address' : [ 0x30, ['pointer', ['void']]],
    'CreatorBackTraceIndex' : [ 0x30, ['unsigned long']],
    'SpinLock' : [ 0x34, ['unsigned long']],
} ],
  '_MI_CACHED_PTE' : [ 0x8, {
    'GlobalTimeStamp' : [ 0x0, ['unsigned long']],
    'PteIndex' : [ 0x4, ['unsigned long']],
    'Long' : [ 0x0, ['long long']],
} ],
  '_KLOCK_QUEUE_HANDLE' : [ 0xc, {
    'LockQueue' : [ 0x0, ['_KSPIN_LOCK_QUEUE']],
    'OldIrql' : [ 0x8, ['unsigned char']],
} ],
  '_MMPFNLIST' : [ 0x14, {
    'Total' : [ 0x0, ['unsigned long']],
    'ListName' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'ZeroedPageList', 1: 'FreePageList', 2: 'StandbyPageList', 3: 'ModifiedPageList', 4: 'ModifiedNoWritePageList', 5: 'BadPageList', 6: 'ActiveAndValid', 7: 'TransitionPage'})]],
    'Flink' : [ 0x8, ['unsigned long']],
    'Blink' : [ 0xc, ['unsigned long']],
    'Lock' : [ 0x10, ['unsigned long']],
} ],
  '__unnamed_1650' : [ 0x4, {
    'Flink' : [ 0x0, ['unsigned long']],
    'WsIndex' : [ 0x0, ['unsigned long']],
    'Event' : [ 0x0, ['pointer', ['_KEVENT']]],
    'Next' : [ 0x0, ['pointer', ['void']]],
    'VolatileNext' : [ 0x0, ['pointer', ['void']]],
    'KernelStackOwner' : [ 0x0, ['pointer', ['_KTHREAD']]],
    'NextStackPfn' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
} ],
  '__unnamed_1654' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
    'ShortFlags' : [ 0x2, ['unsigned short']],
    'VolatileShortFlags' : [ 0x2, ['unsigned short']],
} ],
  '__unnamed_1656' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned short']],
    'e1' : [ 0x2, ['_MMPFNENTRY']],
    'e2' : [ 0x0, ['__unnamed_1654']],
} ],
  '__unnamed_165b' : [ 0x4, {
    'PteFrame' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'PageIdentity' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 27, native_type='unsigned long')]],
    'PrototypePte' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'PageColor' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 32, native_type='unsigned long')]],
    'EntireField' : [ 0x0, ['unsigned long']],
} ],
  '_MMPFN' : [ 0x1c, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'TreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'u1' : [ 0x0, ['__unnamed_1650']],
    'PteAddress' : [ 0x4, ['pointer', ['_MMPTE']]],
    'VolatilePteAddress' : [ 0x4, ['pointer', ['void']]],
    'PteLong' : [ 0x4, ['unsigned long']],
    'OriginalPte' : [ 0x8, ['_MMPTE']],
    'u2' : [ 0x10, ['_MIPFNBLINK']],
    'u3' : [ 0x14, ['__unnamed_1656']],
    'u4' : [ 0x18, ['__unnamed_165b']],
} ],
  '_MI_SYSTEM_PTE_TYPE' : [ 0x34, {
    'Bitmap' : [ 0x0, ['_RTL_BITMAP']],
    'BasePte' : [ 0x8, ['pointer', ['_MMPTE']]],
    'Flags' : [ 0xc, ['unsigned long']],
    'VaType' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'MiVaUnused', 1: 'MiVaSessionSpace', 2: 'MiVaProcessSpace', 3: 'MiVaBootLoaded', 4: 'MiVaPfnDatabase', 5: 'MiVaNonPagedPool', 6: 'MiVaPagedPool', 7: 'MiVaSpecialPoolPaged', 8: 'MiVaSystemCache', 9: 'MiVaSystemPtes', 10: 'MiVaHal', 11: 'MiVaSessionGlobalSpace', 12: 'MiVaDriverImages', 13: 'MiVaSpecialPoolNonPaged', 14: 'MiVaPagedProtoPool', 15: 'MiVaMaximumType', 16: 'MiVaSystemPtesLarge'})]],
    'FailureCount' : [ 0x14, ['pointer', ['unsigned long']]],
    'PteFailures' : [ 0x18, ['unsigned long']],
    'SpinLock' : [ 0x1c, ['unsigned long']],
    'GlobalPushLock' : [ 0x1c, ['pointer', ['_EX_PUSH_LOCK']]],
    'Vm' : [ 0x20, ['pointer', ['_MMSUPPORT']]],
    'TotalSystemPtes' : [ 0x24, ['unsigned long']],
    'Hint' : [ 0x28, ['unsigned long']],
    'CachedPtes' : [ 0x2c, ['pointer', ['_MI_CACHED_PTES']]],
    'TotalFreeSystemPtes' : [ 0x30, ['unsigned long']],
} ],
  '_MMCLONE_DESCRIPTOR' : [ 0x30, {
    'CloneNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'Next' : [ 0x0, ['pointer', ['_MMCLONE_DESCRIPTOR']]],
    'StartingCloneBlock' : [ 0xc, ['pointer', ['_MMCLONE_BLOCK']]],
    'EndingCloneBlock' : [ 0x10, ['pointer', ['_MMCLONE_BLOCK']]],
    'NumberOfPtes' : [ 0x14, ['unsigned long']],
    'NumberOfReferences' : [ 0x18, ['unsigned long']],
    'CloneHeader' : [ 0x1c, ['pointer', ['_MMCLONE_HEADER']]],
    'NonPagedPoolQuotaCharge' : [ 0x20, ['unsigned long']],
    'NestingLevel' : [ 0x28, ['unsigned long long']],
} ],
  '__unnamed_168b' : [ 0x4, {
    'VirtualAddress' : [ 0x0, ['pointer', ['void']]],
    'Long' : [ 0x0, ['unsigned long']],
    'e1' : [ 0x0, ['_MMWSLENTRY']],
    'e2' : [ 0x0, ['_MMWSLE_FREE_ENTRY']],
} ],
  '_MMWSLE' : [ 0x4, {
    'u1' : [ 0x0, ['__unnamed_168b']],
} ],
  '_MMWSL' : [ 0xe48, {
    'FirstFree' : [ 0x0, ['unsigned long']],
    'FirstDynamic' : [ 0x4, ['unsigned long']],
    'LastEntry' : [ 0x8, ['unsigned long']],
    'NextSlot' : [ 0xc, ['unsigned long']],
    'LastInitializedWsle' : [ 0x10, ['unsigned long']],
    'NextAgingSlot' : [ 0x14, ['unsigned long']],
    'NextAccessClearingSlot' : [ 0x18, ['unsigned long']],
    'LastAccessClearingRemainder' : [ 0x1c, ['unsigned long']],
    'LastAgingRemainder' : [ 0x20, ['unsigned long']],
    'WsleSize' : [ 0x24, ['unsigned long']],
    'NonDirectCount' : [ 0x28, ['unsigned long']],
    'LowestPagableAddress' : [ 0x2c, ['pointer', ['void']]],
    'NonDirectHash' : [ 0x30, ['pointer', ['_MMWSLE_NONDIRECT_HASH']]],
    'HashTableStart' : [ 0x34, ['pointer', ['_MMWSLE_HASH']]],
    'HighestPermittedHashAddress' : [ 0x38, ['pointer', ['_MMWSLE_HASH']]],
    'ActiveWsleCounts' : [ 0x3c, ['array', 16, ['unsigned long']]],
    'ActiveWsles' : [ 0x7c, ['array', 16, ['_MI_ACTIVE_WSLE_LISTHEAD']]],
    'Wsle' : [ 0xfc, ['pointer', ['_MMWSLE']]],
    'UserVaInfo' : [ 0x100, ['_MI_USER_VA_INFO']],
} ],
  '_MMSUPPORT' : [ 0x80, {
    'WorkingSetLock' : [ 0x0, ['long']],
    'ExitOutswapGate' : [ 0x4, ['pointer', ['_KGATE']]],
    'AccessLog' : [ 0x8, ['pointer', ['void']]],
    'WorkingSetExpansionLinks' : [ 0xc, ['_LIST_ENTRY']],
    'AgeDistribution' : [ 0x14, ['array', 7, ['unsigned long']]],
    'MinimumWorkingSetSize' : [ 0x30, ['unsigned long']],
    'WorkingSetLeafSize' : [ 0x34, ['unsigned long']],
    'WorkingSetLeafPrivateSize' : [ 0x38, ['unsigned long']],
    'WorkingSetSize' : [ 0x3c, ['unsigned long']],
    'WorkingSetPrivateSize' : [ 0x40, ['unsigned long']],
    'MaximumWorkingSetSize' : [ 0x44, ['unsigned long']],
    'ChargedWslePages' : [ 0x48, ['unsigned long']],
    'ActualWslePages' : [ 0x4c, ['unsigned long']],
    'WorkingSetSizeOverhead' : [ 0x50, ['unsigned long']],
    'PeakWorkingSetSize' : [ 0x54, ['unsigned long']],
    'HardFaultCount' : [ 0x58, ['unsigned long']],
    'VmWorkingSetList' : [ 0x5c, ['pointer', ['_MMWSL']]],
    'NextPageColor' : [ 0x60, ['unsigned short']],
    'LastTrimStamp' : [ 0x62, ['unsigned short']],
    'PageFaultCount' : [ 0x64, ['unsigned long']],
    'TrimmedPageCount' : [ 0x68, ['unsigned long']],
    'Reserved0' : [ 0x6c, ['unsigned long']],
    'Flags' : [ 0x70, ['_MMSUPPORT_FLAGS']],
    'ReleasedCommitDebt' : [ 0x74, ['unsigned long']],
    'WsSwapSupport' : [ 0x78, ['pointer', ['void']]],
    'CommitReAcquireFailSupport' : [ 0x7c, ['pointer', ['void']]],
} ],
  '__unnamed_16a6' : [ 0x4, {
    'ImageCommitment' : [ 0x0, ['unsigned long']],
    'CreatingProcess' : [ 0x0, ['pointer', ['_EPROCESS']]],
} ],
  '__unnamed_16aa' : [ 0x4, {
    'ImageInformation' : [ 0x0, ['pointer', ['_MI_SECTION_IMAGE_INFORMATION']]],
    'FirstMappedVa' : [ 0x0, ['pointer', ['void']]],
} ],
  '_SEGMENT' : [ 0x30, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'TotalNumberOfPtes' : [ 0x4, ['unsigned long']],
    'SegmentFlags' : [ 0x8, ['_SEGMENT_FLAGS']],
    'NumberOfCommittedPages' : [ 0xc, ['unsigned long']],
    'SizeOfSegment' : [ 0x10, ['unsigned long long']],
    'ExtendInfo' : [ 0x18, ['pointer', ['_MMEXTEND_INFO']]],
    'BasedAddress' : [ 0x18, ['pointer', ['void']]],
    'SegmentLock' : [ 0x1c, ['_EX_PUSH_LOCK']],
    'u1' : [ 0x20, ['__unnamed_16a6']],
    'u2' : [ 0x24, ['__unnamed_16aa']],
    'PrototypePte' : [ 0x28, ['pointer', ['_MMPTE']]],
} ],
  '__unnamed_16af' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MMSECTION_FLAGS']],
} ],
  '__unnamed_16b9' : [ 0xc, {
    'NumberOfSystemCacheViews' : [ 0x0, ['unsigned long']],
    'ImageRelocationStartBit' : [ 0x0, ['unsigned long']],
    'WritableUserReferences' : [ 0x4, ['long']],
    'ImageRelocationSizeIn64k' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'Unused' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 25, native_type='unsigned long')]],
    'SystemImage' : [ 0x4, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'StrongCode' : [ 0x4, ['BitField', dict(start_bit = 26, end_bit = 28, native_type='unsigned long')]],
    'CantMove' : [ 0x4, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'BitMap' : [ 0x4, ['BitField', dict(start_bit = 29, end_bit = 31, native_type='unsigned long')]],
    'ImageActive' : [ 0x4, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'FlushInProgressCount' : [ 0x8, ['unsigned long']],
    'NumberOfSubsections' : [ 0x8, ['unsigned long']],
    'SeImageStub' : [ 0x8, ['pointer', ['_MI_IMAGE_SECURITY_REFERENCE']]],
} ],
  '__unnamed_16bb' : [ 0xc, {
    'e2' : [ 0x0, ['__unnamed_16b9']],
} ],
  '_CONTROL_AREA' : [ 0x50, {
    'Segment' : [ 0x0, ['pointer', ['_SEGMENT']]],
    'ListHead' : [ 0x4, ['_LIST_ENTRY']],
    'NumberOfSectionReferences' : [ 0xc, ['unsigned long']],
    'NumberOfPfnReferences' : [ 0x10, ['unsigned long']],
    'NumberOfMappedViews' : [ 0x14, ['unsigned long']],
    'NumberOfUserReferences' : [ 0x18, ['unsigned long']],
    'u' : [ 0x1c, ['__unnamed_16af']],
    'FilePointer' : [ 0x20, ['_EX_FAST_REF']],
    'ControlAreaLock' : [ 0x24, ['long']],
    'ModifiedWriteCount' : [ 0x28, ['unsigned long']],
    'WaitList' : [ 0x2c, ['pointer', ['_MI_CONTROL_AREA_WAIT_BLOCK']]],
    'u2' : [ 0x30, ['__unnamed_16bb']],
    'LockedPages' : [ 0x40, ['unsigned long long']],
    'FileObjectLock' : [ 0x48, ['_EX_PUSH_LOCK']],
} ],
  '__unnamed_16d0' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'VadFlags' : [ 0x0, ['_MMVAD_FLAGS']],
} ],
  '__unnamed_16d3' : [ 0x4, {
    'LongFlags1' : [ 0x0, ['unsigned long']],
    'VadFlags1' : [ 0x0, ['_MMVAD_FLAGS1']],
} ],
  '_MMVAD_SHORT' : [ 0x28, {
    'VadNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'NextVad' : [ 0x0, ['pointer', ['_MMVAD_SHORT']]],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'EndingVpn' : [ 0x10, ['unsigned long']],
    'ReferenceCount' : [ 0x14, ['long']],
    'PushLock' : [ 0x18, ['_EX_PUSH_LOCK']],
    'u' : [ 0x1c, ['__unnamed_16d0']],
    'u1' : [ 0x20, ['__unnamed_16d3']],
    'EventList' : [ 0x24, ['pointer', ['_MI_VAD_EVENT_BLOCK']]],
} ],
  '_MI_PARTITION' : [ 0x18c0, {
    'Core' : [ 0x0, ['_MI_PARTITION_CORE']],
    'Modwriter' : [ 0xb8, ['_MI_PARTITION_MODWRITES']],
    'Store' : [ 0x288, ['_MI_PARTITION_STORES']],
    'Segments' : [ 0x300, ['_MI_PARTITION_SEGMENTS']],
    'PageLists' : [ 0x400, ['_MI_PARTITION_PAGE_LISTS']],
    'Commit' : [ 0xb80, ['_MI_PARTITION_COMMIT']],
    'Zeroing' : [ 0xc00, ['_MI_PARTITION_ZEROING']],
    'PageCombine' : [ 0xc40, ['_MI_PAGE_COMBINING_SUPPORT']],
    'WorkingSetControl' : [ 0xd18, ['pointer', ['void']]],
    'WorkingSetExpansionHead' : [ 0xd1c, ['_MMWORKING_SET_EXPANSION_HEAD']],
    'Vp' : [ 0xd40, ['_MI_VISIBLE_PARTITION']],
} ],
  '_MM_STORE_KEY' : [ 0x4, {
    'KeyLow' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 28, native_type='unsigned long')]],
    'KeyHigh' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 32, native_type='unsigned long')]],
    'EntireKey' : [ 0x0, ['unsigned long']],
} ],
  '_MMPAGING_FILE' : [ 0xa8, {
    'Size' : [ 0x0, ['unsigned long']],
    'MaximumSize' : [ 0x4, ['unsigned long']],
    'MinimumSize' : [ 0x8, ['unsigned long']],
    'FreeSpace' : [ 0xc, ['unsigned long']],
    'PeakUsage' : [ 0x10, ['unsigned long']],
    'HighestPage' : [ 0x14, ['unsigned long']],
    'FreeReservationSpace' : [ 0x18, ['unsigned long']],
    'File' : [ 0x1c, ['pointer', ['_FILE_OBJECT']]],
    'Entry' : [ 0x20, ['array', 2, ['pointer', ['_MMMOD_WRITER_MDL_ENTRY']]]],
    'PfnsToFree' : [ 0x28, ['_SLIST_HEADER']],
    'PageFileName' : [ 0x30, ['_UNICODE_STRING']],
    'Bitmaps' : [ 0x38, ['pointer', ['_MI_PAGING_FILE_SPACE_BITMAPS']]],
    'AllocationBitmapHint' : [ 0x3c, ['unsigned long']],
    'LargestAllocationCluster' : [ 0x40, ['unsigned long']],
    'RefreshAllocationCluster' : [ 0x44, ['unsigned long']],
    'LastRefreshAllocationCluster' : [ 0x48, ['unsigned long']],
    'ReservedClusterSizeAggregate' : [ 0x4c, ['unsigned long']],
    'MaximumRunLengthInBitmaps' : [ 0x50, ['unsigned long']],
    'BitmapsCacheLengthTree' : [ 0x54, ['_RTL_RB_TREE']],
    'BitmapsCacheLocationTree' : [ 0x5c, ['_RTL_RB_TREE']],
    'BitmapsCacheFreeList' : [ 0x64, ['_LIST_ENTRY']],
    'BitmapsCacheEntries' : [ 0x6c, ['pointer', ['_MI_PAGEFILE_BITMAPS_CACHE_ENTRY']]],
    'ToBeEvictedCount' : [ 0x70, ['unsigned long']],
    'HybridPriority' : [ 0x70, ['unsigned long']],
    'PageFileNumber' : [ 0x74, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned short')]],
    'WsSwapPagefile' : [ 0x74, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'NoReservations' : [ 0x74, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'VirtualStorePagefile' : [ 0x74, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SwapSupported' : [ 0x74, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'NodeInserted' : [ 0x74, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'StackNotified' : [ 0x74, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'Spare0' : [ 0x74, ['BitField', dict(start_bit = 10, end_bit = 15, native_type='unsigned short')]],
    'AdriftMdls' : [ 0x76, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Spare1' : [ 0x76, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'IgnoreReservations' : [ 0x77, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Spare2' : [ 0x77, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'PageHashPages' : [ 0x78, ['unsigned long']],
    'PageHashPagesPeak' : [ 0x7c, ['unsigned long']],
    'PageHash' : [ 0x80, ['pointer', ['unsigned long']]],
    'FileHandle' : [ 0x84, ['pointer', ['void']]],
    'Lock' : [ 0x88, ['unsigned long']],
    'LockOwner' : [ 0x8c, ['pointer', ['_ETHREAD']]],
    'FlowThroughReadRoot' : [ 0x90, ['_RTL_AVL_TREE']],
    'Partition' : [ 0x94, ['pointer', ['_MI_PARTITION']]],
    'FileObjectNode' : [ 0x98, ['_RTL_BALANCED_NODE']],
} ],
  'tagSWITCH_CONTEXT' : [ 0x68, {
    'Attribute' : [ 0x0, ['tagSWITCH_CONTEXT_ATTRIBUTE']],
    'Data' : [ 0x18, ['tagSWITCH_CONTEXT_DATA']],
} ],
  '_CMP_SILO_CONTEXT' : [ 0x10, {
    'LockEntryHead' : [ 0x0, ['_LIST_ENTRY']],
    'LockListUnderCleanup' : [ 0x8, ['unsigned char']],
    'ContextLock' : [ 0xc, ['_EX_PUSH_LOCK']],
} ],
  '__unnamed_171e' : [ 0xc, {
    'Failure' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: '_None', 1: '_CmInitializeHive', 2: '_HvInitializeHive', 3: '_HvpBuildMap', 4: '_HvpBuildMapForLoaderHive', 5: '_HvpInitMap', 6: '_HvLoadHive', 7: '_HvpMapHiveImage', 8: '_HvpRecoverData', 9: '_CmpValidateHiveSecurityDescriptors', 10: '_HvpEnlistBinInMap', 11: '_CmCheckRegistry', 12: '_CmRegistryIO', 13: '_CmCheckRegistry2', 14: '_CmpCheckKey', 15: '_CmpCheckValueList', 16: '_HvCheckHive', 17: '_HvCheckBin', 18: '_HvpGetLogEntryDirtyVector', 19: '_HvpReadLogEntryHeader', 20: '_HvpReadLogEntry', 21: '_CmpMountPreloadedHives', 22: '_CmpLoadHiveThread'})]],
    'Status' : [ 0x4, ['long']],
    'Point' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_1721' : [ 0xc, {
    'Action' : [ 0x0, ['unsigned long']],
    'Handle' : [ 0x4, ['pointer', ['void']]],
    'Status' : [ 0x8, ['long']],
} ],
  '__unnamed_1723' : [ 0x4, {
    'CheckStack' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_1727' : [ 0x10, {
    'Cell' : [ 0x0, ['unsigned long']],
    'CellPoint' : [ 0x4, ['pointer', ['_CELL_DATA']]],
    'RootPoint' : [ 0x8, ['pointer', ['void']]],
    'Index' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_1729' : [ 0x10, {
    'List' : [ 0x0, ['pointer', ['_CELL_DATA']]],
    'Index' : [ 0x4, ['unsigned long']],
    'Cell' : [ 0x8, ['unsigned long']],
    'CellPoint' : [ 0xc, ['pointer', ['_CELL_DATA']]],
} ],
  '__unnamed_172d' : [ 0xc, {
    'Space' : [ 0x0, ['unsigned long']],
    'MapPoint' : [ 0x4, ['unsigned long']],
    'BinPoint' : [ 0x8, ['pointer', ['_HBIN']]],
} ],
  '__unnamed_1731' : [ 0x8, {
    'Bin' : [ 0x0, ['pointer', ['_HBIN']]],
    'CellPoint' : [ 0x4, ['pointer', ['_HCELL']]],
} ],
  '__unnamed_1733' : [ 0x4, {
    'FileOffset' : [ 0x0, ['unsigned long']],
} ],
  '_HIVE_LOAD_FAILURE' : [ 0x120, {
    'Hive' : [ 0x0, ['pointer', ['_HHIVE']]],
    'Index' : [ 0x4, ['unsigned long']],
    'RecoverableIndex' : [ 0x8, ['unsigned long']],
    'Locations' : [ 0xc, ['array', 8, ['__unnamed_171e']]],
    'RecoverableLocations' : [ 0x6c, ['array', 8, ['__unnamed_171e']]],
    'RegistryIO' : [ 0xcc, ['__unnamed_1721']],
    'CheckRegistry2' : [ 0xd8, ['__unnamed_1723']],
    'CheckKey' : [ 0xdc, ['__unnamed_1727']],
    'CheckValueList' : [ 0xec, ['__unnamed_1729']],
    'CheckHive' : [ 0xfc, ['__unnamed_172d']],
    'CheckHive1' : [ 0x108, ['__unnamed_172d']],
    'CheckBin' : [ 0x114, ['__unnamed_1731']],
    'RecoverData' : [ 0x11c, ['__unnamed_1733']],
} ],
  '_PCW_COUNTER_DESCRIPTOR' : [ 0x8, {
    'Id' : [ 0x0, ['unsigned short']],
    'StructIndex' : [ 0x2, ['unsigned short']],
    'Offset' : [ 0x4, ['unsigned short']],
    'Size' : [ 0x6, ['unsigned short']],
} ],
  '_PCW_REGISTRATION_INFORMATION' : [ 0x18, {
    'Version' : [ 0x0, ['unsigned long']],
    'Name' : [ 0x4, ['pointer', ['_UNICODE_STRING']]],
    'CounterCount' : [ 0x8, ['unsigned long']],
    'Counters' : [ 0xc, ['pointer', ['_PCW_COUNTER_DESCRIPTOR']]],
    'Callback' : [ 0x10, ['pointer', ['void']]],
    'CallbackContext' : [ 0x14, ['pointer', ['void']]],
} ],
  '_PCW_PROCESSOR_INFO' : [ 0xc0, {
    'IdleTime' : [ 0x0, ['unsigned long long']],
    'AvailableTime' : [ 0x8, ['unsigned long long']],
    'UserTime' : [ 0x10, ['unsigned long long']],
    'KernelTime' : [ 0x18, ['unsigned long long']],
    'Interrupts' : [ 0x20, ['unsigned long']],
    'DpcTime' : [ 0x28, ['unsigned long long']],
    'InterruptTime' : [ 0x30, ['unsigned long long']],
    'ClockInterrupts' : [ 0x38, ['unsigned long']],
    'DpcCount' : [ 0x3c, ['unsigned long']],
    'DpcRate' : [ 0x40, ['unsigned long']],
    'C1Time' : [ 0x48, ['unsigned long long']],
    'C2Time' : [ 0x50, ['unsigned long long']],
    'C3Time' : [ 0x58, ['unsigned long long']],
    'C1Transitions' : [ 0x60, ['unsigned long long']],
    'C2Transitions' : [ 0x68, ['unsigned long long']],
    'C3Transitions' : [ 0x70, ['unsigned long long']],
    'StallTime' : [ 0x78, ['unsigned long long']],
    'ParkingStatus' : [ 0x80, ['unsigned long']],
    'CurrentFrequency' : [ 0x84, ['unsigned long']],
    'PercentMaxFrequency' : [ 0x88, ['unsigned long']],
    'StateFlags' : [ 0x8c, ['unsigned long']],
    'NominalThroughput' : [ 0x90, ['unsigned long']],
    'ActiveThroughput' : [ 0x94, ['unsigned long']],
    'ScaledThroughput' : [ 0x98, ['unsigned long long']],
    'ScaledKernelThroughput' : [ 0xa0, ['unsigned long long']],
    'AverageIdleTime' : [ 0xa8, ['unsigned long long']],
    'IdleBreakEvents' : [ 0xb0, ['unsigned long long']],
    'PerformanceLimit' : [ 0xb8, ['unsigned long']],
    'PerformanceLimitFlags' : [ 0xbc, ['unsigned long']],
} ],
  '_PCW_DATA' : [ 0x8, {
    'Data' : [ 0x0, ['pointer', ['void']]],
    'Size' : [ 0x4, ['unsigned long']],
} ],
  '_SYNCH_COUNTERS' : [ 0xb8, {
    'SpinLockAcquireCount' : [ 0x0, ['unsigned long']],
    'SpinLockContentionCount' : [ 0x4, ['unsigned long']],
    'SpinLockSpinCount' : [ 0x8, ['unsigned long']],
    'IpiSendRequestBroadcastCount' : [ 0xc, ['unsigned long']],
    'IpiSendRequestRoutineCount' : [ 0x10, ['unsigned long']],
    'IpiSendSoftwareInterruptCount' : [ 0x14, ['unsigned long']],
    'ExInitializeResourceCount' : [ 0x18, ['unsigned long']],
    'ExReInitializeResourceCount' : [ 0x1c, ['unsigned long']],
    'ExDeleteResourceCount' : [ 0x20, ['unsigned long']],
    'ExecutiveResourceAcquiresCount' : [ 0x24, ['unsigned long']],
    'ExecutiveResourceContentionsCount' : [ 0x28, ['unsigned long']],
    'ExecutiveResourceReleaseExclusiveCount' : [ 0x2c, ['unsigned long']],
    'ExecutiveResourceReleaseSharedCount' : [ 0x30, ['unsigned long']],
    'ExecutiveResourceConvertsCount' : [ 0x34, ['unsigned long']],
    'ExAcqResExclusiveAttempts' : [ 0x38, ['unsigned long']],
    'ExAcqResExclusiveAcquiresExclusive' : [ 0x3c, ['unsigned long']],
    'ExAcqResExclusiveAcquiresExclusiveRecursive' : [ 0x40, ['unsigned long']],
    'ExAcqResExclusiveWaits' : [ 0x44, ['unsigned long']],
    'ExAcqResExclusiveNotAcquires' : [ 0x48, ['unsigned long']],
    'ExAcqResSharedAttempts' : [ 0x4c, ['unsigned long']],
    'ExAcqResSharedAcquiresExclusive' : [ 0x50, ['unsigned long']],
    'ExAcqResSharedAcquiresShared' : [ 0x54, ['unsigned long']],
    'ExAcqResSharedAcquiresSharedRecursive' : [ 0x58, ['unsigned long']],
    'ExAcqResSharedWaits' : [ 0x5c, ['unsigned long']],
    'ExAcqResSharedNotAcquires' : [ 0x60, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAttempts' : [ 0x64, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAcquiresExclusive' : [ 0x68, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAcquiresShared' : [ 0x6c, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveAcquiresSharedRecursive' : [ 0x70, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveWaits' : [ 0x74, ['unsigned long']],
    'ExAcqResSharedStarveExclusiveNotAcquires' : [ 0x78, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAttempts' : [ 0x7c, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAcquiresExclusive' : [ 0x80, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAcquiresShared' : [ 0x84, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveAcquiresSharedRecursive' : [ 0x88, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveWaits' : [ 0x8c, ['unsigned long']],
    'ExAcqResSharedWaitForExclusiveNotAcquires' : [ 0x90, ['unsigned long']],
    'ExSetResOwnerPointerExclusive' : [ 0x94, ['unsigned long']],
    'ExSetResOwnerPointerSharedNew' : [ 0x98, ['unsigned long']],
    'ExSetResOwnerPointerSharedOld' : [ 0x9c, ['unsigned long']],
    'ExTryToAcqExclusiveAttempts' : [ 0xa0, ['unsigned long']],
    'ExTryToAcqExclusiveAcquires' : [ 0xa4, ['unsigned long']],
    'ExBoostExclusiveOwner' : [ 0xa8, ['unsigned long']],
    'ExBoostSharedOwners' : [ 0xac, ['unsigned long']],
    'ExEtwSynchTrackingNotificationsCount' : [ 0xb0, ['unsigned long']],
    'ExEtwSynchTrackingNotificationsAccountedCount' : [ 0xb4, ['unsigned long']],
} ],
  '_ETW_PERF_COUNTERS' : [ 0x18, {
    'TotalActiveSessions' : [ 0x0, ['long']],
    'TotalBufferMemoryNonPagedPool' : [ 0x4, ['long']],
    'TotalBufferMemoryPagedPool' : [ 0x8, ['long']],
    'TotalGuidsEnabled' : [ 0xc, ['long']],
    'TotalGuidsNotEnabled' : [ 0x10, ['long']],
    'TotalGuidsPreEnabled' : [ 0x14, ['long']],
} ],
  '_ETW_SESSION_PERF_COUNTERS' : [ 0x18, {
    'BufferMemoryPagedPool' : [ 0x0, ['long']],
    'BufferMemoryNonPagedPool' : [ 0x4, ['long']],
    'EventsLoggedCount' : [ 0x8, ['unsigned long long']],
    'EventsLost' : [ 0x10, ['long']],
    'NumConsumers' : [ 0x14, ['long']],
} ],
  '_FILESYSTEM_DISK_COUNTERS' : [ 0x10, {
    'FsBytesRead' : [ 0x0, ['unsigned long long']],
    'FsBytesWritten' : [ 0x8, ['unsigned long long']],
} ],
  '_THERMAL_ZONE_COUNTERS' : [ 0xc, {
    'Temperature' : [ 0x0, ['unsigned long']],
    'ThrottleLimit' : [ 0x4, ['unsigned long']],
    'ThrottleReasons' : [ 0x8, ['unsigned long']],
} ],
  '_TEB32' : [ 0x1000, {
    'NtTib' : [ 0x0, ['_NT_TIB32']],
    'EnvironmentPointer' : [ 0x1c, ['unsigned long']],
    'ClientId' : [ 0x20, ['_CLIENT_ID32']],
    'ActiveRpcHandle' : [ 0x28, ['unsigned long']],
    'ThreadLocalStoragePointer' : [ 0x2c, ['unsigned long']],
    'ProcessEnvironmentBlock' : [ 0x30, ['unsigned long']],
    'LastErrorValue' : [ 0x34, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x38, ['unsigned long']],
    'CsrClientThread' : [ 0x3c, ['unsigned long']],
    'Win32ThreadInfo' : [ 0x40, ['unsigned long']],
    'User32Reserved' : [ 0x44, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xac, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0xc0, ['unsigned long']],
    'CurrentLocale' : [ 0xc4, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0xc8, ['unsigned long']],
    'ReservedForDebuggerInstrumentation' : [ 0xcc, ['array', 16, ['unsigned long']]],
    'SystemReserved1' : [ 0x10c, ['array', 38, ['unsigned long']]],
    'ExceptionCode' : [ 0x1a4, ['long']],
    'ActivationContextStackPointer' : [ 0x1a8, ['unsigned long']],
    'InstrumentationCallbackSp' : [ 0x1ac, ['unsigned long']],
    'InstrumentationCallbackPreviousPc' : [ 0x1b0, ['unsigned long']],
    'InstrumentationCallbackPreviousSp' : [ 0x1b4, ['unsigned long']],
    'InstrumentationCallbackDisabled' : [ 0x1b8, ['unsigned char']],
    'SpareBytes' : [ 0x1b9, ['array', 23, ['unsigned char']]],
    'TxFsContext' : [ 0x1d0, ['unsigned long']],
    'GdiTebBatch' : [ 0x1d4, ['_GDI_TEB_BATCH32']],
    'RealClientId' : [ 0x6b4, ['_CLIENT_ID32']],
    'GdiCachedProcessHandle' : [ 0x6bc, ['unsigned long']],
    'GdiClientPID' : [ 0x6c0, ['unsigned long']],
    'GdiClientTID' : [ 0x6c4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x6c8, ['unsigned long']],
    'Win32ClientInfo' : [ 0x6cc, ['array', 62, ['unsigned long']]],
    'glDispatchTable' : [ 0x7c4, ['array', 233, ['unsigned long']]],
    'glReserved1' : [ 0xb68, ['array', 29, ['unsigned long']]],
    'glReserved2' : [ 0xbdc, ['unsigned long']],
    'glSectionInfo' : [ 0xbe0, ['unsigned long']],
    'glSection' : [ 0xbe4, ['unsigned long']],
    'glTable' : [ 0xbe8, ['unsigned long']],
    'glCurrentRC' : [ 0xbec, ['unsigned long']],
    'glContext' : [ 0xbf0, ['unsigned long']],
    'LastStatusValue' : [ 0xbf4, ['unsigned long']],
    'StaticUnicodeString' : [ 0xbf8, ['_STRING32']],
    'StaticUnicodeBuffer' : [ 0xc00, ['array', 261, ['wchar']]],
    'DeallocationStack' : [ 0xe0c, ['unsigned long']],
    'TlsSlots' : [ 0xe10, ['array', 64, ['unsigned long']]],
    'TlsLinks' : [ 0xf10, ['LIST_ENTRY32']],
    'Vdm' : [ 0xf18, ['unsigned long']],
    'ReservedForNtRpc' : [ 0xf1c, ['unsigned long']],
    'DbgSsReserved' : [ 0xf20, ['array', 2, ['unsigned long']]],
    'HardErrorMode' : [ 0xf28, ['unsigned long']],
    'Instrumentation' : [ 0xf2c, ['array', 9, ['unsigned long']]],
    'ActivityId' : [ 0xf50, ['_GUID']],
    'SubProcessTag' : [ 0xf60, ['unsigned long']],
    'PerflibData' : [ 0xf64, ['unsigned long']],
    'EtwTraceData' : [ 0xf68, ['unsigned long']],
    'WinSockData' : [ 0xf6c, ['unsigned long']],
    'GdiBatchCount' : [ 0xf70, ['unsigned long']],
    'CurrentIdealProcessor' : [ 0xf74, ['_PROCESSOR_NUMBER']],
    'IdealProcessorValue' : [ 0xf74, ['unsigned long']],
    'ReservedPad0' : [ 0xf74, ['unsigned char']],
    'ReservedPad1' : [ 0xf75, ['unsigned char']],
    'ReservedPad2' : [ 0xf76, ['unsigned char']],
    'IdealProcessor' : [ 0xf77, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0xf78, ['unsigned long']],
    'ReservedForPerf' : [ 0xf7c, ['unsigned long']],
    'ReservedForOle' : [ 0xf80, ['unsigned long']],
    'WaitingOnLoaderLock' : [ 0xf84, ['unsigned long']],
    'SavedPriorityState' : [ 0xf88, ['unsigned long']],
    'ReservedForCodeCoverage' : [ 0xf8c, ['unsigned long']],
    'ThreadPoolData' : [ 0xf90, ['unsigned long']],
    'TlsExpansionSlots' : [ 0xf94, ['unsigned long']],
    'MuiGeneration' : [ 0xf98, ['unsigned long']],
    'IsImpersonating' : [ 0xf9c, ['unsigned long']],
    'NlsCache' : [ 0xfa0, ['unsigned long']],
    'pShimData' : [ 0xfa4, ['unsigned long']],
    'HeapVirtualAffinity' : [ 0xfa8, ['unsigned short']],
    'LowFragHeapDataSlot' : [ 0xfaa, ['unsigned short']],
    'CurrentTransactionHandle' : [ 0xfac, ['unsigned long']],
    'ActiveFrame' : [ 0xfb0, ['unsigned long']],
    'FlsData' : [ 0xfb4, ['unsigned long']],
    'PreferredLanguages' : [ 0xfb8, ['unsigned long']],
    'UserPrefLanguages' : [ 0xfbc, ['unsigned long']],
    'MergedPrefLanguages' : [ 0xfc0, ['unsigned long']],
    'MuiImpersonation' : [ 0xfc4, ['unsigned long']],
    'CrossTebFlags' : [ 0xfc8, ['unsigned short']],
    'SpareCrossTebBits' : [ 0xfc8, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0xfca, ['unsigned short']],
    'SafeThunkCall' : [ 0xfca, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'InDebugPrint' : [ 0xfca, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'HasFiberData' : [ 0xfca, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'SkipThreadAttach' : [ 0xfca, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'WerInShipAssertCode' : [ 0xfca, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'RanProcessInit' : [ 0xfca, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'ClonedThread' : [ 0xfca, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SuppressDebugMsg' : [ 0xfca, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DisableUserStackWalk' : [ 0xfca, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0xfca, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'InitialThread' : [ 0xfca, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'SessionAware' : [ 0xfca, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned short')]],
    'LoadOwner' : [ 0xfca, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'LoaderWorker' : [ 0xfca, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0xfca, ['BitField', dict(start_bit = 14, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0xfcc, ['unsigned long']],
    'TxnScopeExitCallback' : [ 0xfd0, ['unsigned long']],
    'TxnScopeContext' : [ 0xfd4, ['unsigned long']],
    'LockCount' : [ 0xfd8, ['unsigned long']],
    'WowTebOffset' : [ 0xfdc, ['long']],
    'ResourceRetValue' : [ 0xfe0, ['unsigned long']],
    'ReservedForWdf' : [ 0xfe4, ['unsigned long']],
    'ReservedForCrt' : [ 0xfe8, ['unsigned long long']],
    'EffectiveContainerId' : [ 0xff0, ['_GUID']],
} ],
  '_TEB64' : [ 0x1838, {
    'NtTib' : [ 0x0, ['_NT_TIB64']],
    'EnvironmentPointer' : [ 0x38, ['unsigned long long']],
    'ClientId' : [ 0x40, ['_CLIENT_ID64']],
    'ActiveRpcHandle' : [ 0x50, ['unsigned long long']],
    'ThreadLocalStoragePointer' : [ 0x58, ['unsigned long long']],
    'ProcessEnvironmentBlock' : [ 0x60, ['unsigned long long']],
    'LastErrorValue' : [ 0x68, ['unsigned long']],
    'CountOfOwnedCriticalSections' : [ 0x6c, ['unsigned long']],
    'CsrClientThread' : [ 0x70, ['unsigned long long']],
    'Win32ThreadInfo' : [ 0x78, ['unsigned long long']],
    'User32Reserved' : [ 0x80, ['array', 26, ['unsigned long']]],
    'UserReserved' : [ 0xe8, ['array', 5, ['unsigned long']]],
    'WOW32Reserved' : [ 0x100, ['unsigned long long']],
    'CurrentLocale' : [ 0x108, ['unsigned long']],
    'FpSoftwareStatusRegister' : [ 0x10c, ['unsigned long']],
    'ReservedForDebuggerInstrumentation' : [ 0x110, ['array', 16, ['unsigned long long']]],
    'SystemReserved1' : [ 0x190, ['array', 38, ['unsigned long long']]],
    'ExceptionCode' : [ 0x2c0, ['long']],
    'Padding0' : [ 0x2c4, ['array', 4, ['unsigned char']]],
    'ActivationContextStackPointer' : [ 0x2c8, ['unsigned long long']],
    'InstrumentationCallbackSp' : [ 0x2d0, ['unsigned long long']],
    'InstrumentationCallbackPreviousPc' : [ 0x2d8, ['unsigned long long']],
    'InstrumentationCallbackPreviousSp' : [ 0x2e0, ['unsigned long long']],
    'TxFsContext' : [ 0x2e8, ['unsigned long']],
    'InstrumentationCallbackDisabled' : [ 0x2ec, ['unsigned char']],
    'Padding1' : [ 0x2ed, ['array', 3, ['unsigned char']]],
    'GdiTebBatch' : [ 0x2f0, ['_GDI_TEB_BATCH64']],
    'RealClientId' : [ 0x7d8, ['_CLIENT_ID64']],
    'GdiCachedProcessHandle' : [ 0x7e8, ['unsigned long long']],
    'GdiClientPID' : [ 0x7f0, ['unsigned long']],
    'GdiClientTID' : [ 0x7f4, ['unsigned long']],
    'GdiThreadLocalInfo' : [ 0x7f8, ['unsigned long long']],
    'Win32ClientInfo' : [ 0x800, ['array', 62, ['unsigned long long']]],
    'glDispatchTable' : [ 0x9f0, ['array', 233, ['unsigned long long']]],
    'glReserved1' : [ 0x1138, ['array', 29, ['unsigned long long']]],
    'glReserved2' : [ 0x1220, ['unsigned long long']],
    'glSectionInfo' : [ 0x1228, ['unsigned long long']],
    'glSection' : [ 0x1230, ['unsigned long long']],
    'glTable' : [ 0x1238, ['unsigned long long']],
    'glCurrentRC' : [ 0x1240, ['unsigned long long']],
    'glContext' : [ 0x1248, ['unsigned long long']],
    'LastStatusValue' : [ 0x1250, ['unsigned long']],
    'Padding2' : [ 0x1254, ['array', 4, ['unsigned char']]],
    'StaticUnicodeString' : [ 0x1258, ['_STRING64']],
    'StaticUnicodeBuffer' : [ 0x1268, ['array', 261, ['wchar']]],
    'Padding3' : [ 0x1472, ['array', 6, ['unsigned char']]],
    'DeallocationStack' : [ 0x1478, ['unsigned long long']],
    'TlsSlots' : [ 0x1480, ['array', 64, ['unsigned long long']]],
    'TlsLinks' : [ 0x1680, ['LIST_ENTRY64']],
    'Vdm' : [ 0x1690, ['unsigned long long']],
    'ReservedForNtRpc' : [ 0x1698, ['unsigned long long']],
    'DbgSsReserved' : [ 0x16a0, ['array', 2, ['unsigned long long']]],
    'HardErrorMode' : [ 0x16b0, ['unsigned long']],
    'Padding4' : [ 0x16b4, ['array', 4, ['unsigned char']]],
    'Instrumentation' : [ 0x16b8, ['array', 11, ['unsigned long long']]],
    'ActivityId' : [ 0x1710, ['_GUID']],
    'SubProcessTag' : [ 0x1720, ['unsigned long long']],
    'PerflibData' : [ 0x1728, ['unsigned long long']],
    'EtwTraceData' : [ 0x1730, ['unsigned long long']],
    'WinSockData' : [ 0x1738, ['unsigned long long']],
    'GdiBatchCount' : [ 0x1740, ['unsigned long']],
    'CurrentIdealProcessor' : [ 0x1744, ['_PROCESSOR_NUMBER']],
    'IdealProcessorValue' : [ 0x1744, ['unsigned long']],
    'ReservedPad0' : [ 0x1744, ['unsigned char']],
    'ReservedPad1' : [ 0x1745, ['unsigned char']],
    'ReservedPad2' : [ 0x1746, ['unsigned char']],
    'IdealProcessor' : [ 0x1747, ['unsigned char']],
    'GuaranteedStackBytes' : [ 0x1748, ['unsigned long']],
    'Padding5' : [ 0x174c, ['array', 4, ['unsigned char']]],
    'ReservedForPerf' : [ 0x1750, ['unsigned long long']],
    'ReservedForOle' : [ 0x1758, ['unsigned long long']],
    'WaitingOnLoaderLock' : [ 0x1760, ['unsigned long']],
    'Padding6' : [ 0x1764, ['array', 4, ['unsigned char']]],
    'SavedPriorityState' : [ 0x1768, ['unsigned long long']],
    'ReservedForCodeCoverage' : [ 0x1770, ['unsigned long long']],
    'ThreadPoolData' : [ 0x1778, ['unsigned long long']],
    'TlsExpansionSlots' : [ 0x1780, ['unsigned long long']],
    'DeallocationBStore' : [ 0x1788, ['unsigned long long']],
    'BStoreLimit' : [ 0x1790, ['unsigned long long']],
    'MuiGeneration' : [ 0x1798, ['unsigned long']],
    'IsImpersonating' : [ 0x179c, ['unsigned long']],
    'NlsCache' : [ 0x17a0, ['unsigned long long']],
    'pShimData' : [ 0x17a8, ['unsigned long long']],
    'HeapVirtualAffinity' : [ 0x17b0, ['unsigned short']],
    'LowFragHeapDataSlot' : [ 0x17b2, ['unsigned short']],
    'Padding7' : [ 0x17b4, ['array', 4, ['unsigned char']]],
    'CurrentTransactionHandle' : [ 0x17b8, ['unsigned long long']],
    'ActiveFrame' : [ 0x17c0, ['unsigned long long']],
    'FlsData' : [ 0x17c8, ['unsigned long long']],
    'PreferredLanguages' : [ 0x17d0, ['unsigned long long']],
    'UserPrefLanguages' : [ 0x17d8, ['unsigned long long']],
    'MergedPrefLanguages' : [ 0x17e0, ['unsigned long long']],
    'MuiImpersonation' : [ 0x17e8, ['unsigned long']],
    'CrossTebFlags' : [ 0x17ec, ['unsigned short']],
    'SpareCrossTebBits' : [ 0x17ec, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned short')]],
    'SameTebFlags' : [ 0x17ee, ['unsigned short']],
    'SafeThunkCall' : [ 0x17ee, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'InDebugPrint' : [ 0x17ee, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'HasFiberData' : [ 0x17ee, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'SkipThreadAttach' : [ 0x17ee, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'WerInShipAssertCode' : [ 0x17ee, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'RanProcessInit' : [ 0x17ee, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'ClonedThread' : [ 0x17ee, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'SuppressDebugMsg' : [ 0x17ee, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'DisableUserStackWalk' : [ 0x17ee, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned short')]],
    'RtlExceptionAttached' : [ 0x17ee, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned short')]],
    'InitialThread' : [ 0x17ee, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned short')]],
    'SessionAware' : [ 0x17ee, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned short')]],
    'LoadOwner' : [ 0x17ee, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'LoaderWorker' : [ 0x17ee, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'SpareSameTebBits' : [ 0x17ee, ['BitField', dict(start_bit = 14, end_bit = 16, native_type='unsigned short')]],
    'TxnScopeEnterCallback' : [ 0x17f0, ['unsigned long long']],
    'TxnScopeExitCallback' : [ 0x17f8, ['unsigned long long']],
    'TxnScopeContext' : [ 0x1800, ['unsigned long long']],
    'LockCount' : [ 0x1808, ['unsigned long']],
    'WowTebOffset' : [ 0x180c, ['long']],
    'ResourceRetValue' : [ 0x1810, ['unsigned long long']],
    'ReservedForWdf' : [ 0x1818, ['unsigned long long']],
    'ReservedForCrt' : [ 0x1820, ['unsigned long long']],
    'EffectiveContainerId' : [ 0x1828, ['_GUID']],
} ],
  '_HV_X64_HYPERVISOR_FEATURES' : [ 0x10, {
    'PartitionPrivileges' : [ 0x0, ['_HV_PARTITION_PRIVILEGE_MASK']],
    'MaxSupportedCState' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long')]],
    'HpetNeededForC3PowerState_Deprecated' : [ 0x8, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Reserved' : [ 0x8, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
    'MwaitAvailable_Deprecated' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'GuestDebuggingAvailable' : [ 0xc, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PerformanceMonitorsAvailable' : [ 0xc, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'CpuDynamicPartitioningAvailable' : [ 0xc, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'XmmRegistersForFastHypercallAvailable' : [ 0xc, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'GuestIdleAvailable' : [ 0xc, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'HypervisorSleepStateSupportAvailable' : [ 0xc, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'NumaDistanceQueryAvailable' : [ 0xc, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'FrequencyRegsAvailable' : [ 0xc, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SyntheticMachineCheckAvailable' : [ 0xc, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'GuestCrashRegsAvailable' : [ 0xc, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'DebugRegsAvailable' : [ 0xc, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Npiep1Available' : [ 0xc, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'DisableHypervisorAvailable' : [ 0xc, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ExtendedGvaRangesForFlushVirtualAddressListAvailable' : [ 0xc, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'FastHypercallOutputAvailable' : [ 0xc, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'SvmFeaturesAvailable' : [ 0xc, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'SintPollingModeAvailable' : [ 0xc, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HypercallMsrLockAvailable' : [ 0xc, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'Reserved1' : [ 0xc, ['BitField', dict(start_bit = 19, end_bit = 32, native_type='unsigned long')]],
} ],
  '_HV_PARTITION_PRIVILEGE_MASK' : [ 0x8, {
    'AsUINT64' : [ 0x0, ['unsigned long long']],
    'AccessVpRunTimeReg' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'AccessPartitionReferenceCounter' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'AccessSynicRegs' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'AccessSyntheticTimerRegs' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'AccessIntrCtrlRegs' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'AccessHypercallMsrs' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'AccessVpIndex' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'AccessResetReg' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'AccessStatsReg' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'AccessPartitionReferenceTsc' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'AccessGuestIdleReg' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'AccessFrequencyRegs' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'AccessDebugRegs' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 32, native_type='unsigned long long')]],
    'CreatePartitions' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 33, native_type='unsigned long long')]],
    'AccessPartitionId' : [ 0x0, ['BitField', dict(start_bit = 33, end_bit = 34, native_type='unsigned long long')]],
    'AccessMemoryPool' : [ 0x0, ['BitField', dict(start_bit = 34, end_bit = 35, native_type='unsigned long long')]],
    'AdjustMessageBuffers' : [ 0x0, ['BitField', dict(start_bit = 35, end_bit = 36, native_type='unsigned long long')]],
    'PostMessages' : [ 0x0, ['BitField', dict(start_bit = 36, end_bit = 37, native_type='unsigned long long')]],
    'SignalEvents' : [ 0x0, ['BitField', dict(start_bit = 37, end_bit = 38, native_type='unsigned long long')]],
    'CreatePort' : [ 0x0, ['BitField', dict(start_bit = 38, end_bit = 39, native_type='unsigned long long')]],
    'ConnectPort' : [ 0x0, ['BitField', dict(start_bit = 39, end_bit = 40, native_type='unsigned long long')]],
    'AccessStats' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 41, native_type='unsigned long long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 41, end_bit = 43, native_type='unsigned long long')]],
    'Debugging' : [ 0x0, ['BitField', dict(start_bit = 43, end_bit = 44, native_type='unsigned long long')]],
    'CpuManagement' : [ 0x0, ['BitField', dict(start_bit = 44, end_bit = 45, native_type='unsigned long long')]],
    'ConfigureProfiler' : [ 0x0, ['BitField', dict(start_bit = 45, end_bit = 46, native_type='unsigned long long')]],
    'AccessVpExitTracing' : [ 0x0, ['BitField', dict(start_bit = 46, end_bit = 47, native_type='unsigned long long')]],
    'EnableExtendedGvaRangesForFlushVirtualAddressList' : [ 0x0, ['BitField', dict(start_bit = 47, end_bit = 48, native_type='unsigned long long')]],
    'AccessVsm' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 49, native_type='unsigned long long')]],
    'AccessVpRegisters' : [ 0x0, ['BitField', dict(start_bit = 49, end_bit = 50, native_type='unsigned long long')]],
    'UnusedBit' : [ 0x0, ['BitField', dict(start_bit = 50, end_bit = 51, native_type='unsigned long long')]],
    'FastHypercallOutput' : [ 0x0, ['BitField', dict(start_bit = 51, end_bit = 52, native_type='unsigned long long')]],
    'EnableExtendedHypercalls' : [ 0x0, ['BitField', dict(start_bit = 52, end_bit = 53, native_type='unsigned long long')]],
    'StartVirtualProcessor' : [ 0x0, ['BitField', dict(start_bit = 53, end_bit = 54, native_type='unsigned long long')]],
    'Reserved3' : [ 0x0, ['BitField', dict(start_bit = 54, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_KTIMER_TABLE' : [ 0x1840, {
    'TimerExpiry' : [ 0x0, ['array', 16, ['pointer', ['_KTIMER']]]],
    'TimerEntries' : [ 0x40, ['array', 256, ['_KTIMER_TABLE_ENTRY']]],
} ],
  '_KTIMER_TABLE_ENTRY' : [ 0x18, {
    'Lock' : [ 0x0, ['unsigned long']],
    'Entry' : [ 0x4, ['_LIST_ENTRY']],
    'Time' : [ 0x10, ['_ULARGE_INTEGER']],
} ],
  '_XSTATE_SAVE' : [ 0x20, {
    'Reserved1' : [ 0x0, ['long long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
    'Prev' : [ 0xc, ['pointer', ['_XSTATE_SAVE']]],
    'Reserved3' : [ 0x10, ['pointer', ['_XSAVE_AREA']]],
    'Thread' : [ 0x14, ['pointer', ['_KTHREAD']]],
    'Reserved4' : [ 0x18, ['pointer', ['void']]],
    'Level' : [ 0x1c, ['unsigned char']],
    'XStateContext' : [ 0x0, ['_XSTATE_CONTEXT']],
} ],
  '_XSAVE_AREA' : [ 0x240, {
    'LegacyState' : [ 0x0, ['_XSAVE_FORMAT']],
    'Header' : [ 0x200, ['_XSAVE_AREA_HEADER']],
} ],
  '_KSHARED_READY_QUEUE' : [ 0x134, {
    'Lock' : [ 0x0, ['unsigned long']],
    'ReadySummary' : [ 0x4, ['unsigned long']],
    'ReadyListHead' : [ 0x8, ['array', 32, ['_LIST_ENTRY']]],
    'RunningSummary' : [ 0x108, ['array', 32, ['unsigned char']]],
    'Span' : [ 0x128, ['unsigned char']],
    'LowProcIndex' : [ 0x129, ['unsigned char']],
    'QueueIndex' : [ 0x12a, ['unsigned char']],
    'ProcCount' : [ 0x12b, ['unsigned char']],
    'ScanOwner' : [ 0x12c, ['unsigned char']],
    'Spare' : [ 0x12d, ['array', 3, ['unsigned char']]],
    'Affinity' : [ 0x130, ['unsigned long']],
} ],
  '_KAFFINITY_EX' : [ 0xc, {
    'Count' : [ 0x0, ['unsigned short']],
    'Size' : [ 0x2, ['unsigned short']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'Bitmap' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_KAFFINITY_ENUMERATION_CONTEXT' : [ 0xc, {
    'Affinity' : [ 0x0, ['pointer', ['_KAFFINITY_EX']]],
    'CurrentMask' : [ 0x4, ['unsigned long']],
    'CurrentIndex' : [ 0x8, ['unsigned short']],
} ],
  '__unnamed_1841' : [ 0x4, {
    'LegacyDeviceNode' : [ 0x0, ['pointer', ['_DEVICE_NODE']]],
    'PendingDeviceRelations' : [ 0x0, ['pointer', ['_DEVICE_RELATIONS']]],
    'Information' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_1843' : [ 0x4, {
    'NextResourceDeviceNode' : [ 0x0, ['pointer', ['_DEVICE_NODE']]],
} ],
  '__unnamed_1847' : [ 0x10, {
    'DockStatus' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'DOCK_NOTDOCKDEVICE', 1: 'DOCK_QUIESCENT', 2: 'DOCK_ARRIVING', 3: 'DOCK_DEPARTING', 4: 'DOCK_EJECTIRP_COMPLETED'})]],
    'ListEntry' : [ 0x4, ['_LIST_ENTRY']],
    'SerialNumber' : [ 0xc, ['pointer', ['unsigned short']]],
} ],
  '_DEVICE_NODE' : [ 0x1cc, {
    'Sibling' : [ 0x0, ['pointer', ['_DEVICE_NODE']]],
    'Child' : [ 0x4, ['pointer', ['_DEVICE_NODE']]],
    'Parent' : [ 0x8, ['pointer', ['_DEVICE_NODE']]],
    'LastChild' : [ 0xc, ['pointer', ['_DEVICE_NODE']]],
    'PhysicalDeviceObject' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'InstancePath' : [ 0x14, ['_UNICODE_STRING']],
    'ServiceName' : [ 0x1c, ['_UNICODE_STRING']],
    'PendingIrp' : [ 0x24, ['pointer', ['_IRP']]],
    'FxDevice' : [ 0x28, ['pointer', ['_POP_FX_DEVICE']]],
    'FxDeviceLock' : [ 0x2c, ['long']],
    'FxRemoveEvent' : [ 0x30, ['_KEVENT']],
    'FxActivationCount' : [ 0x40, ['long']],
    'FxSleepCount' : [ 0x44, ['long']],
    'Plugin' : [ 0x48, ['pointer', ['_POP_FX_PLUGIN']]],
    'Level' : [ 0x4c, ['unsigned long']],
    'CurrentPowerState' : [ 0x50, ['_POWER_STATE']],
    'Notify' : [ 0x54, ['_PO_DEVICE_NOTIFY']],
    'PoIrpManager' : [ 0x90, ['_PO_IRP_MANAGER']],
    'UniqueId' : [ 0xa0, ['_UNICODE_STRING']],
    'PowerFlags' : [ 0xa8, ['unsigned long']],
    'State' : [ 0xac, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]],
    'PreviousState' : [ 0xb0, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]],
    'StateHistory' : [ 0xb4, ['array', -80, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]]],
    'StateHistoryEntry' : [ 0x104, ['unsigned long']],
    'CompletionStatus' : [ 0x108, ['long']],
    'Flags' : [ 0x10c, ['unsigned long']],
    'UserFlags' : [ 0x110, ['unsigned long']],
    'Problem' : [ 0x114, ['unsigned long']],
    'ProblemStatus' : [ 0x118, ['long']],
    'ResourceList' : [ 0x11c, ['pointer', ['_CM_RESOURCE_LIST']]],
    'ResourceListTranslated' : [ 0x120, ['pointer', ['_CM_RESOURCE_LIST']]],
    'DuplicatePDO' : [ 0x124, ['pointer', ['_DEVICE_OBJECT']]],
    'ResourceRequirements' : [ 0x128, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    'InterfaceType' : [ 0x12c, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'ACPIBus', 18: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x130, ['unsigned long']],
    'ChildInterfaceType' : [ 0x134, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'ACPIBus', 18: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'ChildBusNumber' : [ 0x138, ['unsigned long']],
    'ChildBusTypeIndex' : [ 0x13c, ['unsigned short']],
    'RemovalPolicy' : [ 0x13e, ['unsigned char']],
    'HardwareRemovalPolicy' : [ 0x13f, ['unsigned char']],
    'TargetDeviceNotify' : [ 0x140, ['_LIST_ENTRY']],
    'DeviceArbiterList' : [ 0x148, ['_LIST_ENTRY']],
    'DeviceTranslatorList' : [ 0x150, ['_LIST_ENTRY']],
    'NoTranslatorMask' : [ 0x158, ['unsigned short']],
    'QueryTranslatorMask' : [ 0x15a, ['unsigned short']],
    'NoArbiterMask' : [ 0x15c, ['unsigned short']],
    'QueryArbiterMask' : [ 0x15e, ['unsigned short']],
    'OverUsed1' : [ 0x160, ['__unnamed_1841']],
    'OverUsed2' : [ 0x164, ['__unnamed_1843']],
    'BootResources' : [ 0x168, ['pointer', ['_CM_RESOURCE_LIST']]],
    'BootResourcesTranslated' : [ 0x16c, ['pointer', ['_CM_RESOURCE_LIST']]],
    'CapabilityFlags' : [ 0x170, ['unsigned long']],
    'DockInfo' : [ 0x174, ['__unnamed_1847']],
    'DisableableDepends' : [ 0x184, ['unsigned long']],
    'PendedSetInterfaceState' : [ 0x188, ['_LIST_ENTRY']],
    'LegacyBusListEntry' : [ 0x190, ['_LIST_ENTRY']],
    'DriverUnloadRetryCount' : [ 0x198, ['unsigned long']],
    'PreviousParent' : [ 0x19c, ['pointer', ['_DEVICE_NODE']]],
    'DeletedChildren' : [ 0x1a0, ['long']],
    'NumaNodeIndex' : [ 0x1a4, ['unsigned long']],
    'ContainerID' : [ 0x1a8, ['_GUID']],
    'OverrideFlags' : [ 0x1b8, ['unsigned char']],
    'DeviceIdsHash' : [ 0x1bc, ['unsigned long']],
    'RequiresUnloadedDriver' : [ 0x1c0, ['unsigned char']],
    'PendingEjectRelations' : [ 0x1c4, ['pointer', ['_PENDING_RELATIONS_LIST_ENTRY']]],
    'StateFlags' : [ 0x1c8, ['unsigned long']],
} ],
  '_MCGEN_TRACE_CONTEXT' : [ 0x38, {
    'RegistrationHandle' : [ 0x0, ['unsigned long long']],
    'Logger' : [ 0x8, ['unsigned long long']],
    'MatchAnyKeyword' : [ 0x10, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x18, ['unsigned long long']],
    'Flags' : [ 0x20, ['unsigned long']],
    'IsEnabled' : [ 0x24, ['unsigned long']],
    'Level' : [ 0x28, ['unsigned char']],
    'Reserve' : [ 0x29, ['unsigned char']],
    'EnableBitsCount' : [ 0x2a, ['unsigned short']],
    'EnableBitMask' : [ 0x2c, ['pointer', ['unsigned long']]],
    'EnableKeyWords' : [ 0x30, ['pointer', ['unsigned long long']]],
    'EnableLevel' : [ 0x34, ['pointer', ['unsigned char']]],
} ],
  '_PNP_DEVICE_COMPLETION_QUEUE' : [ 0x2c, {
    'DispatchedList' : [ 0x0, ['_LIST_ENTRY']],
    'DispatchedCount' : [ 0x8, ['unsigned long']],
    'CompletedList' : [ 0xc, ['_LIST_ENTRY']],
    'CompletedSemaphore' : [ 0x14, ['_KSEMAPHORE']],
    'SpinLock' : [ 0x28, ['unsigned long']],
} ],
  '_KSEMAPHORE' : [ 0x14, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'Limit' : [ 0x10, ['long']],
} ],
  '_DEVOBJ_EXTENSION' : [ 0x38, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['unsigned short']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'PowerFlags' : [ 0x8, ['unsigned long']],
    'Dope' : [ 0xc, ['pointer', ['_DEVICE_OBJECT_POWER_EXTENSION']]],
    'ExtensionFlags' : [ 0x10, ['unsigned long']],
    'DeviceNode' : [ 0x14, ['pointer', ['void']]],
    'AttachedTo' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'StartIoCount' : [ 0x1c, ['long']],
    'StartIoKey' : [ 0x20, ['long']],
    'StartIoFlags' : [ 0x24, ['unsigned long']],
    'Vpb' : [ 0x28, ['pointer', ['_VPB']]],
    'DependencyNode' : [ 0x2c, ['pointer', ['void']]],
    'InterruptContext' : [ 0x30, ['pointer', ['void']]],
    'VerifierContext' : [ 0x34, ['pointer', ['void']]],
} ],
  '_GROUP_AFFINITY' : [ 0xc, {
    'Mask' : [ 0x0, ['unsigned long']],
    'Group' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['array', 3, ['unsigned short']]],
} ],
  '_PNP_ASSIGN_RESOURCES_CONTEXT' : [ 0xc, {
    'IncludeFailedDevices' : [ 0x0, ['unsigned long']],
    'DeviceCount' : [ 0x4, ['unsigned long']],
    'DeviceList' : [ 0x8, ['array', 1, ['pointer', ['_DEVICE_OBJECT']]]],
} ],
  '_PNP_RESOURCE_REQUEST' : [ 0x28, {
    'PhysicalDevice' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
    'Flags' : [ 0x4, ['unsigned long']],
    'AllocationType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'ArbiterRequestLegacyReported', 1: 'ArbiterRequestHalReported', 2: 'ArbiterRequestLegacyAssigned', 3: 'ArbiterRequestPnpDetected', 4: 'ArbiterRequestPnpEnumerated', -1: 'ArbiterRequestUndefined'})]],
    'Priority' : [ 0xc, ['unsigned long']],
    'Position' : [ 0x10, ['unsigned long']],
    'ResourceRequirements' : [ 0x14, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    'ReqList' : [ 0x18, ['pointer', ['void']]],
    'ResourceAssignment' : [ 0x1c, ['pointer', ['_CM_RESOURCE_LIST']]],
    'TranslatedResourceAssignment' : [ 0x20, ['pointer', ['_CM_RESOURCE_LIST']]],
    'Status' : [ 0x24, ['long']],
} ],
  '_IO_RESOURCE_REQUIREMENTS_LIST' : [ 0x48, {
    'ListSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'ACPIBus', 18: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'SlotNumber' : [ 0xc, ['unsigned long']],
    'Reserved' : [ 0x10, ['array', 3, ['unsigned long']]],
    'AlternativeLists' : [ 0x1c, ['unsigned long']],
    'List' : [ 0x20, ['array', 1, ['_IO_RESOURCE_LIST']]],
} ],
  '_EXCEPTION_RECORD64' : [ 0x98, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['unsigned long long']],
    'ExceptionAddress' : [ 0x10, ['unsigned long long']],
    'NumberParameters' : [ 0x18, ['unsigned long']],
    '__unusedAlignment' : [ 0x1c, ['unsigned long']],
    'ExceptionInformation' : [ 0x20, ['array', 15, ['unsigned long long']]],
} ],
  '_EXCEPTION_RECORD32' : [ 0x50, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['unsigned long']],
    'ExceptionAddress' : [ 0xc, ['unsigned long']],
    'NumberParameters' : [ 0x10, ['unsigned long']],
    'ExceptionInformation' : [ 0x14, ['array', 15, ['unsigned long']]],
} ],
  '_DBGKM_EXCEPTION64' : [ 0xa0, {
    'ExceptionRecord' : [ 0x0, ['_EXCEPTION_RECORD64']],
    'FirstChance' : [ 0x98, ['unsigned long']],
} ],
  '_DBGKM_EXCEPTION32' : [ 0x54, {
    'ExceptionRecord' : [ 0x0, ['_EXCEPTION_RECORD32']],
    'FirstChance' : [ 0x50, ['unsigned long']],
} ],
  '_X86_KTRAP_FRAME' : [ 0x8c, {
    'DbgEbp' : [ 0x0, ['unsigned long']],
    'DbgEip' : [ 0x4, ['unsigned long']],
    'DbgArgMark' : [ 0x8, ['unsigned long']],
    'DbgArgPointer' : [ 0xc, ['unsigned long']],
    'TempSegCs' : [ 0x10, ['unsigned long']],
    'TempEsp' : [ 0x14, ['unsigned long']],
    'Dr0' : [ 0x18, ['unsigned long']],
    'Dr1' : [ 0x1c, ['unsigned long']],
    'Dr2' : [ 0x20, ['unsigned long']],
    'Dr3' : [ 0x24, ['unsigned long']],
    'Dr6' : [ 0x28, ['unsigned long']],
    'Dr7' : [ 0x2c, ['unsigned long']],
    'SegGs' : [ 0x30, ['unsigned long']],
    'SegEs' : [ 0x34, ['unsigned long']],
    'SegDs' : [ 0x38, ['unsigned long']],
    'Edx' : [ 0x3c, ['unsigned long']],
    'Ecx' : [ 0x40, ['unsigned long']],
    'Eax' : [ 0x44, ['unsigned long']],
    'PreviousPreviousMode' : [ 0x48, ['unsigned char']],
    'EntropyQueueDpc' : [ 0x49, ['unsigned char']],
    'Reserved' : [ 0x4a, ['array', 2, ['unsigned char']]],
    'ExceptionList' : [ 0x4c, ['unsigned long']],
    'SegFs' : [ 0x50, ['unsigned long']],
    'Edi' : [ 0x54, ['unsigned long']],
    'Esi' : [ 0x58, ['unsigned long']],
    'Ebx' : [ 0x5c, ['unsigned long']],
    'Ebp' : [ 0x60, ['unsigned long']],
    'ErrCode' : [ 0x64, ['unsigned long']],
    'Eip' : [ 0x68, ['unsigned long']],
    'SegCs' : [ 0x6c, ['unsigned long']],
    'EFlags' : [ 0x70, ['unsigned long']],
    'HardwareEsp' : [ 0x74, ['unsigned long']],
    'HardwareSegSs' : [ 0x78, ['unsigned long']],
    'V86Es' : [ 0x7c, ['unsigned long']],
    'V86Ds' : [ 0x80, ['unsigned long']],
    'V86Fs' : [ 0x84, ['unsigned long']],
    'V86Gs' : [ 0x88, ['unsigned long']],
} ],
  '_X86_KTRAP_FRAME_BLUE' : [ 0x8c, {
    'DbgEbp' : [ 0x0, ['unsigned long']],
    'DbgEip' : [ 0x4, ['unsigned long']],
    'DbgArgMark' : [ 0x8, ['unsigned long']],
    'TempSegCs' : [ 0xc, ['unsigned short']],
    'Logging' : [ 0xe, ['unsigned char']],
    'FrameType' : [ 0xf, ['unsigned char']],
    'TempEsp' : [ 0x10, ['unsigned long']],
    'Dr0' : [ 0x14, ['unsigned long']],
    'Dr1' : [ 0x18, ['unsigned long']],
    'Dr2' : [ 0x1c, ['unsigned long']],
    'Dr3' : [ 0x20, ['unsigned long']],
    'Dr6' : [ 0x24, ['unsigned long']],
    'Dr7' : [ 0x28, ['unsigned long']],
    'SegGs' : [ 0x2c, ['unsigned long']],
    'SegEs' : [ 0x30, ['unsigned long']],
    'SegDs' : [ 0x34, ['unsigned long']],
    'Edx' : [ 0x38, ['unsigned long']],
    'Ecx' : [ 0x3c, ['unsigned long']],
    'Eax' : [ 0x40, ['unsigned long']],
    'PreviousPreviousMode' : [ 0x44, ['unsigned char']],
    'EntropyQueueDpc' : [ 0x45, ['unsigned char']],
    'Reserved' : [ 0x46, ['array', 2, ['unsigned char']]],
    'MxCsr' : [ 0x48, ['unsigned long']],
    'ExceptionList' : [ 0x4c, ['unsigned long']],
    'SegFs' : [ 0x50, ['unsigned long']],
    'Edi' : [ 0x54, ['unsigned long']],
    'Esi' : [ 0x58, ['unsigned long']],
    'Ebx' : [ 0x5c, ['unsigned long']],
    'Ebp' : [ 0x60, ['unsigned long']],
    'ErrCode' : [ 0x64, ['unsigned long']],
    'Eip' : [ 0x68, ['unsigned long']],
    'SegCs' : [ 0x6c, ['unsigned long']],
    'EFlags' : [ 0x70, ['unsigned long']],
    'HardwareEsp' : [ 0x74, ['unsigned long']],
    'HardwareSegSs' : [ 0x78, ['unsigned long']],
    'V86Es' : [ 0x7c, ['unsigned long']],
    'V86Ds' : [ 0x80, ['unsigned long']],
    'V86Fs' : [ 0x84, ['unsigned long']],
    'V86Gs' : [ 0x88, ['unsigned long']],
} ],
  '_DBGKD_LOAD_SYMBOLS64' : [ 0x28, {
    'PathNameLength' : [ 0x0, ['unsigned long']],
    'BaseOfDll' : [ 0x8, ['unsigned long long']],
    'ProcessId' : [ 0x10, ['unsigned long long']],
    'CheckSum' : [ 0x18, ['unsigned long']],
    'SizeOfImage' : [ 0x1c, ['unsigned long']],
    'UnloadSymbols' : [ 0x20, ['unsigned char']],
} ],
  '_DBGKD_LOAD_SYMBOLS32' : [ 0x18, {
    'PathNameLength' : [ 0x0, ['unsigned long']],
    'BaseOfDll' : [ 0x4, ['unsigned long']],
    'ProcessId' : [ 0x8, ['unsigned long']],
    'CheckSum' : [ 0xc, ['unsigned long']],
    'SizeOfImage' : [ 0x10, ['unsigned long']],
    'UnloadSymbols' : [ 0x14, ['unsigned char']],
} ],
  '_DBGKD_READ_MEMORY64' : [ 0x10, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long long']],
    'TransferCount' : [ 0x8, ['unsigned long']],
    'ActualBytesRead' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_READ_MEMORY32' : [ 0xc, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long']],
    'TransferCount' : [ 0x4, ['unsigned long']],
    'ActualBytesRead' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_MEMORY64' : [ 0x10, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long long']],
    'TransferCount' : [ 0x8, ['unsigned long']],
    'ActualBytesWritten' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_WRITE_MEMORY32' : [ 0xc, {
    'TargetBaseAddress' : [ 0x0, ['unsigned long']],
    'TransferCount' : [ 0x4, ['unsigned long']],
    'ActualBytesWritten' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_BREAKPOINT64' : [ 0x10, {
    'BreakPointAddress' : [ 0x0, ['unsigned long long']],
    'BreakPointHandle' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_BREAKPOINT32' : [ 0x8, {
    'BreakPointAddress' : [ 0x0, ['unsigned long']],
    'BreakPointHandle' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO64' : [ 0x10, {
    'IoAddress' : [ 0x0, ['unsigned long long']],
    'DataSize' : [ 0x8, ['unsigned long']],
    'DataValue' : [ 0xc, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO32' : [ 0xc, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'IoAddress' : [ 0x4, ['unsigned long']],
    'DataValue' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO_EXTENDED64' : [ 0x20, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['unsigned long']],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'AddressSpace' : [ 0xc, ['unsigned long']],
    'IoAddress' : [ 0x10, ['unsigned long long']],
    'DataValue' : [ 0x18, ['unsigned long']],
} ],
  '_DBGKD_READ_WRITE_IO_EXTENDED32' : [ 0x18, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'InterfaceType' : [ 0x4, ['unsigned long']],
    'BusNumber' : [ 0x8, ['unsigned long']],
    'AddressSpace' : [ 0xc, ['unsigned long']],
    'IoAddress' : [ 0x10, ['unsigned long']],
    'DataValue' : [ 0x14, ['unsigned long']],
} ],
  '_DBGKD_SET_SPECIAL_CALL32' : [ 0x4, {
    'SpecialCall' : [ 0x0, ['unsigned long']],
} ],
  '_DBGKD_SET_SPECIAL_CALL64' : [ 0x8, {
    'SpecialCall' : [ 0x0, ['unsigned long long']],
} ],
  '_DBGKD_SET_INTERNAL_BREAKPOINT32' : [ 0x8, {
    'BreakpointAddress' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_SET_INTERNAL_BREAKPOINT64' : [ 0x10, {
    'BreakpointAddress' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_GET_INTERNAL_BREAKPOINT64' : [ 0x20, {
    'BreakpointAddress' : [ 0x0, ['unsigned long long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'Calls' : [ 0xc, ['unsigned long']],
    'MaxCallsPerPeriod' : [ 0x10, ['unsigned long']],
    'MinInstructions' : [ 0x14, ['unsigned long']],
    'MaxInstructions' : [ 0x18, ['unsigned long']],
    'TotalInstructions' : [ 0x1c, ['unsigned long']],
} ],
  '_DBGKD_GET_INTERNAL_BREAKPOINT32' : [ 0x1c, {
    'BreakpointAddress' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
    'Calls' : [ 0x8, ['unsigned long']],
    'MaxCallsPerPeriod' : [ 0xc, ['unsigned long']],
    'MinInstructions' : [ 0x10, ['unsigned long']],
    'MaxInstructions' : [ 0x14, ['unsigned long']],
    'TotalInstructions' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_1941' : [ 0x28, {
    'ReadMemory' : [ 0x0, ['_DBGKD_READ_MEMORY64']],
    'WriteMemory' : [ 0x0, ['_DBGKD_WRITE_MEMORY64']],
    'GetContext' : [ 0x0, ['_DBGKD_GET_CONTEXT']],
    'SetContext' : [ 0x0, ['_DBGKD_SET_CONTEXT']],
    'WriteBreakPoint' : [ 0x0, ['_DBGKD_WRITE_BREAKPOINT64']],
    'RestoreBreakPoint' : [ 0x0, ['_DBGKD_RESTORE_BREAKPOINT']],
    'Continue' : [ 0x0, ['_DBGKD_CONTINUE']],
    'Continue2' : [ 0x0, ['_DBGKD_CONTINUE2']],
    'ReadWriteIo' : [ 0x0, ['_DBGKD_READ_WRITE_IO64']],
    'ReadWriteIoExtended' : [ 0x0, ['_DBGKD_READ_WRITE_IO_EXTENDED64']],
    'QuerySpecialCalls' : [ 0x0, ['_DBGKD_QUERY_SPECIAL_CALLS']],
    'SetSpecialCall' : [ 0x0, ['_DBGKD_SET_SPECIAL_CALL64']],
    'SetInternalBreakpoint' : [ 0x0, ['_DBGKD_SET_INTERNAL_BREAKPOINT64']],
    'GetInternalBreakpoint' : [ 0x0, ['_DBGKD_GET_INTERNAL_BREAKPOINT64']],
    'GetVersion64' : [ 0x0, ['_DBGKD_GET_VERSION64']],
    'BreakPointEx' : [ 0x0, ['_DBGKD_BREAKPOINTEX']],
    'ReadWriteMsr' : [ 0x0, ['_DBGKD_READ_WRITE_MSR']],
    'SearchMemory' : [ 0x0, ['_DBGKD_SEARCH_MEMORY']],
    'GetSetBusData' : [ 0x0, ['_DBGKD_GET_SET_BUS_DATA']],
    'FillMemory' : [ 0x0, ['_DBGKD_FILL_MEMORY']],
    'QueryMemory' : [ 0x0, ['_DBGKD_QUERY_MEMORY']],
    'SwitchPartition' : [ 0x0, ['_DBGKD_SWITCH_PARTITION']],
    'GetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
    'SetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
    'WriteCustomBreakPoint' : [ 0x0, ['_DBGKD_WRITE_CUSTOM_BREAKPOINT']],
} ],
  '_DBGKD_MANIPULATE_STATE64' : [ 0x38, {
    'ApiNumber' : [ 0x0, ['unsigned long']],
    'ProcessorLevel' : [ 0x4, ['unsigned short']],
    'Processor' : [ 0x6, ['unsigned short']],
    'ReturnStatus' : [ 0x8, ['long']],
    'u' : [ 0x10, ['__unnamed_1941']],
} ],
  '__unnamed_1948' : [ 0x28, {
    'ReadMemory' : [ 0x0, ['_DBGKD_READ_MEMORY32']],
    'WriteMemory' : [ 0x0, ['_DBGKD_WRITE_MEMORY32']],
    'ReadMemory64' : [ 0x0, ['_DBGKD_READ_MEMORY64']],
    'WriteMemory64' : [ 0x0, ['_DBGKD_WRITE_MEMORY64']],
    'GetContext' : [ 0x0, ['_DBGKD_GET_CONTEXT']],
    'SetContext' : [ 0x0, ['_DBGKD_SET_CONTEXT']],
    'WriteBreakPoint' : [ 0x0, ['_DBGKD_WRITE_BREAKPOINT32']],
    'RestoreBreakPoint' : [ 0x0, ['_DBGKD_RESTORE_BREAKPOINT']],
    'Continue' : [ 0x0, ['_DBGKD_CONTINUE']],
    'Continue2' : [ 0x0, ['_DBGKD_CONTINUE2']],
    'ReadWriteIo' : [ 0x0, ['_DBGKD_READ_WRITE_IO32']],
    'ReadWriteIoExtended' : [ 0x0, ['_DBGKD_READ_WRITE_IO_EXTENDED32']],
    'QuerySpecialCalls' : [ 0x0, ['_DBGKD_QUERY_SPECIAL_CALLS']],
    'SetSpecialCall' : [ 0x0, ['_DBGKD_SET_SPECIAL_CALL32']],
    'SetInternalBreakpoint' : [ 0x0, ['_DBGKD_SET_INTERNAL_BREAKPOINT32']],
    'GetInternalBreakpoint' : [ 0x0, ['_DBGKD_GET_INTERNAL_BREAKPOINT32']],
    'GetVersion32' : [ 0x0, ['_DBGKD_GET_VERSION32']],
    'BreakPointEx' : [ 0x0, ['_DBGKD_BREAKPOINTEX']],
    'ReadWriteMsr' : [ 0x0, ['_DBGKD_READ_WRITE_MSR']],
    'SearchMemory' : [ 0x0, ['_DBGKD_SEARCH_MEMORY']],
    'GetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
    'SetContextEx' : [ 0x0, ['_DBGKD_CONTEXT_EX']],
} ],
  '_DBGKD_MANIPULATE_STATE32' : [ 0x34, {
    'ApiNumber' : [ 0x0, ['unsigned long']],
    'ProcessorLevel' : [ 0x4, ['unsigned short']],
    'Processor' : [ 0x6, ['unsigned short']],
    'ReturnStatus' : [ 0x8, ['long']],
    'u' : [ 0xc, ['__unnamed_1948']],
} ],
  '_DBGKD_READ_WRITE_MSR' : [ 0xc, {
    'Msr' : [ 0x0, ['unsigned long']],
    'DataValueLow' : [ 0x4, ['unsigned long']],
    'DataValueHigh' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_BREAKPOINTEX' : [ 0x8, {
    'BreakPointCount' : [ 0x0, ['unsigned long']],
    'ContinueStatus' : [ 0x4, ['long']],
} ],
  '_DBGKD_SEARCH_MEMORY' : [ 0x18, {
    'SearchAddress' : [ 0x0, ['unsigned long long']],
    'FoundAddress' : [ 0x0, ['unsigned long long']],
    'SearchLength' : [ 0x8, ['unsigned long long']],
    'PatternLength' : [ 0x10, ['unsigned long']],
} ],
  '_DBGKD_RESTORE_BREAKPOINT' : [ 0x4, {
    'BreakPointHandle' : [ 0x0, ['unsigned long']],
} ],
  '_DBGKD_CONTINUE' : [ 0x4, {
    'ContinueStatus' : [ 0x0, ['long']],
} ],
  '_DBGKD_CONTINUE2' : [ 0x20, {
    'ContinueStatus' : [ 0x0, ['long']],
    'ControlSet' : [ 0x4, ['_X86_DBGKD_CONTROL_SET']],
    'AnyControlSet' : [ 0x4, ['_DBGKD_ANY_CONTROL_SET']],
} ],
  '_PEP_ACPI_RESOURCE' : [ 0x48, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PepAcpiMemory', 1: 'PepAcpiIoPort', 2: 'PepAcpiInterrupt', 3: 'PepAcpiGpioIo', 4: 'PepAcpiGpioInt', 5: 'PepAcpiSpbI2c', 6: 'PepAcpiSpbSpi', 7: 'PepAcpiSpbUart', 8: 'PepAcpiExtendedMemory', 9: 'PepAcpiExtendedIo'})]],
    'IoMemory' : [ 0x0, ['_PEP_ACPI_IO_MEMORY_RESOURCE']],
    'Interrupt' : [ 0x0, ['_PEP_ACPI_INTERRUPT_RESOURCE']],
    'Gpio' : [ 0x0, ['_PEP_ACPI_GPIO_RESOURCE']],
    'SpbI2c' : [ 0x0, ['_PEP_ACPI_SPB_I2C_RESOURCE']],
    'SpbSpi' : [ 0x0, ['_PEP_ACPI_SPB_SPI_RESOURCE']],
    'SpbUart' : [ 0x0, ['_PEP_ACPI_SPB_UART_RESOURCE']],
    'ExtendedAddress' : [ 0x0, ['_PEP_ACPI_EXTENDED_ADDRESS']],
} ],
  '_PEP_ACPI_IO_MEMORY_RESOURCE' : [ 0x20, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PepAcpiMemory', 1: 'PepAcpiIoPort', 2: 'PepAcpiInterrupt', 3: 'PepAcpiGpioIo', 4: 'PepAcpiGpioInt', 5: 'PepAcpiSpbI2c', 6: 'PepAcpiSpbSpi', 7: 'PepAcpiSpbUart', 8: 'PepAcpiExtendedMemory', 9: 'PepAcpiExtendedIo'})]],
    'Information' : [ 0x4, ['unsigned char']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'Alignment' : [ 0x18, ['unsigned long']],
    'Length' : [ 0x1c, ['unsigned long']],
} ],
  '_PEP_ACPI_INTERRUPT_RESOURCE' : [ 0x18, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PepAcpiMemory', 1: 'PepAcpiIoPort', 2: 'PepAcpiInterrupt', 3: 'PepAcpiGpioIo', 4: 'PepAcpiGpioInt', 5: 'PepAcpiSpbI2c', 6: 'PepAcpiSpbSpi', 7: 'PepAcpiSpbUart', 8: 'PepAcpiExtendedMemory', 9: 'PepAcpiExtendedIo'})]],
    'InterruptType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'LevelSensitive', 1: 'Latched'})]],
    'InterruptPolarity' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'InterruptPolarityUnknown', 1: 'InterruptRisingEdge', 2: 'InterruptFallingEdge', 3: 'InterruptActiveBothTriggerLow', 4: 'InterruptActiveBothTriggerHigh'})]],
    'Flags' : [ 0xc, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'Count' : [ 0x10, ['unsigned char']],
    'Pins' : [ 0x14, ['pointer', ['unsigned long']]],
} ],
  '_PEP_ACPI_GPIO_RESOURCE' : [ 0x30, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PepAcpiMemory', 1: 'PepAcpiIoPort', 2: 'PepAcpiInterrupt', 3: 'PepAcpiGpioIo', 4: 'PepAcpiGpioInt', 5: 'PepAcpiSpbI2c', 6: 'PepAcpiSpbSpi', 7: 'PepAcpiSpbUart', 8: 'PepAcpiExtendedMemory', 9: 'PepAcpiExtendedIo'})]],
    'Flags' : [ 0x4, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'InterruptType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'LevelSensitive', 1: 'Latched'})]],
    'InterruptPolarity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'InterruptPolarityUnknown', 1: 'InterruptRisingEdge', 2: 'InterruptFallingEdge', 3: 'InterruptActiveBothTriggerLow', 4: 'InterruptActiveBothTriggerHigh'})]],
    'PinConfig' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'PullDefault', 1: 'PullUp', 2: 'PullDown', 3: 'PullNone'})]],
    'IoRestrictionType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'IoRestrictionNone', 1: 'IoRestrictionInputOnly', 2: 'IoRestrictionOutputOnly', 3: 'IoRestrictionNoneAndPreserve'})]],
    'DriveStrength' : [ 0x18, ['unsigned short']],
    'DebounceTimeout' : [ 0x1a, ['unsigned short']],
    'PinTable' : [ 0x1c, ['pointer', ['unsigned short']]],
    'PinCount' : [ 0x20, ['unsigned short']],
    'ResourceSourceIndex' : [ 0x22, ['unsigned char']],
    'ResourceSourceName' : [ 0x24, ['pointer', ['_UNICODE_STRING']]],
    'VendorData' : [ 0x28, ['pointer', ['unsigned char']]],
    'VendorDataLength' : [ 0x2c, ['unsigned short']],
} ],
  '_PEP_ACPI_SPB_I2C_RESOURCE' : [ 0x20, {
    'SpbCommon' : [ 0x0, ['_PEP_ACPI_SPB_RESOURCE']],
    'ConnectionSpeed' : [ 0x18, ['unsigned long']],
    'SlaveAddress' : [ 0x1c, ['unsigned short']],
} ],
  '_PEP_ACPI_SPB_UART_RESOURCE' : [ 0x24, {
    'SpbCommon' : [ 0x0, ['_PEP_ACPI_SPB_RESOURCE']],
    'BaudRate' : [ 0x18, ['unsigned long']],
    'RxBufferSize' : [ 0x1c, ['unsigned short']],
    'TxBufferSize' : [ 0x1e, ['unsigned short']],
    'Parity' : [ 0x20, ['unsigned char']],
    'LinesInUse' : [ 0x21, ['unsigned char']],
} ],
  '_PEP_ACPI_SPB_SPI_RESOURCE' : [ 0x24, {
    'SpbCommon' : [ 0x0, ['_PEP_ACPI_SPB_RESOURCE']],
    'ConnectionSpeed' : [ 0x18, ['unsigned long']],
    'DataBitLength' : [ 0x1c, ['unsigned char']],
    'Phase' : [ 0x1d, ['unsigned char']],
    'Polarity' : [ 0x1e, ['unsigned char']],
    'DeviceSelection' : [ 0x20, ['unsigned short']],
} ],
  '_PEP_ACPI_EXTENDED_ADDRESS' : [ 0x48, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PepAcpiMemory', 1: 'PepAcpiIoPort', 2: 'PepAcpiInterrupt', 3: 'PepAcpiGpioIo', 4: 'PepAcpiGpioInt', 5: 'PepAcpiSpbI2c', 6: 'PepAcpiSpbSpi', 7: 'PepAcpiSpbUart', 8: 'PepAcpiExtendedMemory', 9: 'PepAcpiExtendedIo'})]],
    'Flags' : [ 0x4, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'ResourceFlags' : [ 0x8, ['unsigned char']],
    'GeneralFlags' : [ 0x9, ['unsigned char']],
    'TypeSpecificFlags' : [ 0xa, ['unsigned char']],
    'RevisionId' : [ 0xb, ['unsigned char']],
    'Reserved' : [ 0xc, ['unsigned char']],
    'Granularity' : [ 0x10, ['unsigned long long']],
    'MinimumAddress' : [ 0x18, ['unsigned long long']],
    'MaximumAddress' : [ 0x20, ['unsigned long long']],
    'TranslationAddress' : [ 0x28, ['unsigned long long']],
    'AddressLength' : [ 0x30, ['unsigned long long']],
    'TypeAttribute' : [ 0x38, ['unsigned long long']],
    'DescriptorName' : [ 0x40, ['pointer', ['_UNICODE_STRING']]],
} ],
  '_PPM_PLATFORM_STATES' : [ 0x100, {
    'StateCount' : [ 0x0, ['unsigned long']],
    'InterfaceVersion' : [ 0x4, ['unsigned long']],
    'ProcessorCount' : [ 0x8, ['unsigned long']],
    'CoordinatedInterface' : [ 0xc, ['unsigned char']],
    'IdleTest' : [ 0x10, ['pointer', ['void']]],
    'IdlePreExecute' : [ 0x14, ['pointer', ['void']]],
    'IdleComplete' : [ 0x18, ['pointer', ['void']]],
    'QueryPlatformStateResidency' : [ 0x1c, ['pointer', ['void']]],
    'Accounting' : [ 0x20, ['pointer', ['_PLATFORM_IDLE_ACCOUNTING']]],
    'State' : [ 0x40, ['array', 1, ['_PPM_PLATFORM_STATE']]],
} ],
  '_POP_CPU_INFO' : [ 0x10, {
    'Eax' : [ 0x0, ['unsigned long']],
    'Ebx' : [ 0x4, ['unsigned long']],
    'Ecx' : [ 0x8, ['unsigned long']],
    'Edx' : [ 0xc, ['unsigned long']],
} ],
  '_POP_PPM_PROFILE' : [ 0x1a8, {
    'Name' : [ 0x0, ['pointer', ['unsigned short']]],
    'Id' : [ 0x4, ['unsigned char']],
    'Guid' : [ 0x8, ['_GUID']],
    'Flags' : [ 0x18, ['unsigned long']],
    'Priority' : [ 0x1c, ['unsigned char']],
    'Settings' : [ 0x20, ['array', 2, ['_PPM_ENGINE_SETTINGS']]],
    'StartTime' : [ 0x180, ['unsigned long long']],
    'Count' : [ 0x188, ['unsigned long long']],
    'MaxDuration' : [ 0x190, ['unsigned long long']],
    'MinDuration' : [ 0x198, ['unsigned long long']],
    'TotalDuration' : [ 0x1a0, ['unsigned long long']],
} ],
  '_PPM_ENGINE_SETTINGS' : [ 0xb0, {
    'ExplicitSetting' : [ 0x0, ['array', 2, ['_PPM_POLICY_SETTINGS_MASK']]],
    'ThrottlingPolicy' : [ 0x10, ['unsigned char']],
    'PerfTimeCheck' : [ 0x14, ['unsigned long']],
    'PerfHistoryCount' : [ 0x18, ['array', 2, ['unsigned char']]],
    'PerfMinPolicy' : [ 0x1a, ['array', 2, ['unsigned char']]],
    'PerfMaxPolicy' : [ 0x1c, ['array', 2, ['unsigned char']]],
    'PerfDecreaseTime' : [ 0x1e, ['array', 2, ['unsigned char']]],
    'PerfIncreaseTime' : [ 0x20, ['array', 2, ['unsigned char']]],
    'PerfDecreasePolicy' : [ 0x22, ['array', 2, ['unsigned char']]],
    'PerfIncreasePolicy' : [ 0x24, ['array', 2, ['unsigned char']]],
    'PerfDecreaseThreshold' : [ 0x26, ['array', 2, ['unsigned char']]],
    'PerfIncreaseThreshold' : [ 0x28, ['array', 2, ['unsigned char']]],
    'PerfBoostPolicy' : [ 0x2c, ['unsigned long']],
    'PerfBoostMode' : [ 0x30, ['unsigned long']],
    'PerfReductionTolerance' : [ 0x34, ['unsigned long']],
    'EnergyPerfPreference' : [ 0x38, ['unsigned long']],
    'AutonomousActivityWindow' : [ 0x3c, ['unsigned long']],
    'AutonomousPreference' : [ 0x40, ['unsigned char']],
    'LatencyHintPerf' : [ 0x41, ['array', 2, ['unsigned char']]],
    'LatencyHintUnpark' : [ 0x43, ['array', 2, ['unsigned char']]],
    'DutyCycling' : [ 0x45, ['unsigned char']],
    'ParkingPerfState' : [ 0x46, ['array', 2, ['unsigned char']]],
    'DistributeUtility' : [ 0x48, ['unsigned char']],
    'CoreParkingOverUtilizationThreshold' : [ 0x49, ['unsigned char']],
    'CoreParkingConcurrencyThreshold' : [ 0x4a, ['unsigned char']],
    'CoreParkingHeadroomThreshold' : [ 0x4b, ['unsigned char']],
    'CoreParkingDistributionThreshold' : [ 0x4c, ['unsigned char']],
    'CoreParkingDecreasePolicy' : [ 0x4d, ['unsigned char']],
    'CoreParkingIncreasePolicy' : [ 0x4e, ['unsigned char']],
    'CoreParkingDecreaseTime' : [ 0x50, ['unsigned long']],
    'CoreParkingIncreaseTime' : [ 0x54, ['unsigned long']],
    'CoreParkingMinCores' : [ 0x58, ['array', 2, ['unsigned char']]],
    'CoreParkingMaxCores' : [ 0x5a, ['array', 2, ['unsigned char']]],
    'AllowScaling' : [ 0x5c, ['unsigned char']],
    'IdleDisabled' : [ 0x5d, ['unsigned char']],
    'IdleTimeCheck' : [ 0x60, ['unsigned long']],
    'IdleDemotePercent' : [ 0x64, ['unsigned char']],
    'IdlePromotePercent' : [ 0x65, ['unsigned char']],
    'HeteroDecreaseTime' : [ 0x66, ['unsigned char']],
    'HeteroIncreaseTime' : [ 0x67, ['unsigned char']],
    'HeteroDecreaseThreshold' : [ 0x68, ['array', 32, ['unsigned char']]],
    'HeteroIncreaseThreshold' : [ 0x88, ['array', 32, ['unsigned char']]],
    'Class0FloorPerformance' : [ 0xa8, ['unsigned char']],
    'Class1InitialPerformance' : [ 0xa9, ['unsigned char']],
} ],
  '_POP_FX_COMPONENT_FLAGS' : [ 0x8, {
    'Value' : [ 0x0, ['long']],
    'Value2' : [ 0x4, ['long']],
    'RefCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'Idling' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'Active' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'CriticalIdleOverride' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ResidentOverride' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POP_FX_PERF_FLAGS' : [ 0x4, {
    'Value' : [ 0x0, ['long']],
    'Progress' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 27, native_type='unsigned long')]],
    'Synchronicity' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 29, native_type='unsigned long')]],
    'RequestPepCompleted' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'RequestSucceeded' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'NestedCallback' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POP_FX_DEVICE_STATUS' : [ 0x4, {
    'Value' : [ 0x0, ['long']],
    'SystemTransition' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PepD0Notify' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IdleTimerOn' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'IgnoreIdleTimeout' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'IrpInUse' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'IrpPending' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DPNRDeviceNotified' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DPNRReceivedFromPep' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'IrpFirstPendingIndex' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'IrpLastPendingIndex' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 32, native_type='unsigned long')]],
} ],
  '_POP_RW_LOCK' : [ 0x8, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'Thread' : [ 0x4, ['pointer', ['_KTHREAD']]],
} ],
  '_VOLUME_CACHE_MAP' : [ 0x90, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteCode' : [ 0x2, ['short']],
    'UseCount' : [ 0x4, ['unsigned long']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'VolumeCacheMapLinks' : [ 0xc, ['_LIST_ENTRY']],
    'DirtyPages' : [ 0x14, ['unsigned long']],
    'LogHandleContext' : [ 0x18, ['_LOG_HANDLE_CONTEXT']],
    'Flags' : [ 0x80, ['unsigned long']],
    'PagesQueuedToDisk' : [ 0x84, ['unsigned long']],
    'LoggedPagesQueuedToDisk' : [ 0x88, ['unsigned long']],
} ],
  '_SHARED_CACHE_MAP' : [ 0x178, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'OpenCount' : [ 0x4, ['unsigned long']],
    'FileSize' : [ 0x8, ['_LARGE_INTEGER']],
    'BcbList' : [ 0x10, ['_LIST_ENTRY']],
    'SectionSize' : [ 0x18, ['_LARGE_INTEGER']],
    'ValidDataLength' : [ 0x20, ['_LARGE_INTEGER']],
    'ValidDataGoal' : [ 0x28, ['_LARGE_INTEGER']],
    'InitialVacbs' : [ 0x30, ['array', 4, ['pointer', ['_VACB']]]],
    'Vacbs' : [ 0x40, ['pointer', ['pointer', ['_VACB']]]],
    'FileObjectFastRef' : [ 0x44, ['_EX_FAST_REF']],
    'VacbLock' : [ 0x48, ['_EX_PUSH_LOCK']],
    'DirtyPages' : [ 0x4c, ['unsigned long']],
    'LoggedStreamLinks' : [ 0x50, ['_LIST_ENTRY']],
    'SharedCacheMapLinks' : [ 0x58, ['_LIST_ENTRY']],
    'Flags' : [ 0x60, ['unsigned long']],
    'Status' : [ 0x64, ['long']],
    'Mbcb' : [ 0x68, ['pointer', ['_MBCB']]],
    'Section' : [ 0x6c, ['pointer', ['void']]],
    'CreateEvent' : [ 0x70, ['pointer', ['_KEVENT']]],
    'WaitOnActiveCount' : [ 0x74, ['pointer', ['_KEVENT']]],
    'PagesToWrite' : [ 0x78, ['unsigned long']],
    'BeyondLastFlush' : [ 0x80, ['long long']],
    'Callbacks' : [ 0x88, ['pointer', ['_CACHE_MANAGER_CALLBACKS']]],
    'LazyWriteContext' : [ 0x8c, ['pointer', ['void']]],
    'PrivateList' : [ 0x90, ['_LIST_ENTRY']],
    'V1' : [ 0x98, ['_LOGGED_STREAM_CALLBACK_V1']],
    'V2' : [ 0x98, ['_LOGGED_STREAM_CALLBACK_V2']],
    'LargestLSN' : [ 0xa0, ['_LARGE_INTEGER']],
    'DirtyPageThreshold' : [ 0xa8, ['unsigned long']],
    'LazyWritePassCount' : [ 0xac, ['unsigned long']],
    'UninitializeEvent' : [ 0xb0, ['pointer', ['_CACHE_UNINITIALIZE_EVENT']]],
    'BcbLock' : [ 0xb4, ['_FAST_MUTEX']],
    'LastUnmapBehindOffset' : [ 0xd8, ['_LARGE_INTEGER']],
    'Event' : [ 0xe0, ['_KEVENT']],
    'HighWaterMappingOffset' : [ 0xf0, ['_LARGE_INTEGER']],
    'PrivateCacheMap' : [ 0xf8, ['_PRIVATE_CACHE_MAP']],
    'WriteBehindWorkQueueEntry' : [ 0x160, ['pointer', ['void']]],
    'VolumeCacheMap' : [ 0x164, ['pointer', ['_VOLUME_CACHE_MAP']]],
    'ProcImagePathHash' : [ 0x168, ['unsigned long']],
    'WritesInProgress' : [ 0x16c, ['unsigned long']],
    'AsyncReadRequestCount' : [ 0x170, ['unsigned long']],
} ],
  '__unnamed_1a2d' : [ 0x8, {
    'FileOffset' : [ 0x0, ['_LARGE_INTEGER']],
    'ActiveCount' : [ 0x0, ['unsigned short']],
    'Links' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_VACB' : [ 0x18, {
    'BaseAddress' : [ 0x0, ['pointer', ['void']]],
    'SharedCacheMap' : [ 0x4, ['pointer', ['_SHARED_CACHE_MAP']]],
    'Overlay' : [ 0x8, ['__unnamed_1a2d']],
    'ArrayHead' : [ 0x10, ['pointer', ['_VACB_ARRAY_HEADER']]],
} ],
  '__unnamed_1a52' : [ 0x4, {
    'FileObject' : [ 0x0, ['pointer', ['_FILE_OBJECT']]],
} ],
  '__unnamed_1a54' : [ 0x4, {
    'SharedCacheMap' : [ 0x0, ['pointer', ['_SHARED_CACHE_MAP']]],
} ],
  '__unnamed_1a56' : [ 0x4, {
    'Event' : [ 0x0, ['pointer', ['_KEVENT']]],
} ],
  '__unnamed_1a58' : [ 0x4, {
    'Reason' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1a5a' : [ 0x1c, {
    'SharedCacheMap' : [ 0x0, ['pointer', ['_SHARED_CACHE_MAP']]],
    'IoStatus' : [ 0x4, ['pointer', ['_IO_STATUS_BLOCK']]],
    'CallerWaitEvent' : [ 0x8, ['_KEVENT']],
    'IsLowPriWriteBehind' : [ 0x18, ['unsigned char']],
} ],
  '__unnamed_1a5e' : [ 0x38, {
    'SharedCacheMap' : [ 0x0, ['pointer', ['_SHARED_CACHE_MAP']]],
    'FileOffset' : [ 0x8, ['_LARGE_INTEGER']],
    'FileObject' : [ 0x10, ['pointer', ['_FILE_OBJECT']]],
    'Length' : [ 0x14, ['unsigned long']],
    'PrefetchList' : [ 0x18, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'PrefetchPagePriority' : [ 0x1c, ['unsigned long']],
    'Mdl' : [ 0x20, ['pointer', ['_MDL']]],
    'IoStatusBlock' : [ 0x24, ['pointer', ['_IO_STATUS_BLOCK']]],
    'CallbackContext' : [ 0x28, ['pointer', ['_CC_ASYNC_READ_CONTEXT']]],
    'OriginatingProcess' : [ 0x2c, ['pointer', ['_EPROCESS']]],
    'RequestorMode' : [ 0x30, ['unsigned char']],
    'NestingLevel' : [ 0x34, ['unsigned long']],
} ],
  '__unnamed_1a60' : [ 0x38, {
    'Read' : [ 0x0, ['__unnamed_1a52']],
    'Write' : [ 0x0, ['__unnamed_1a54']],
    'Event' : [ 0x0, ['__unnamed_1a56']],
    'Notification' : [ 0x0, ['__unnamed_1a58']],
    'LowPriWrite' : [ 0x0, ['__unnamed_1a5a']],
    'AsyncRead' : [ 0x0, ['__unnamed_1a5e']],
} ],
  '_WORK_QUEUE_ENTRY' : [ 0x48, {
    'WorkQueueLinks' : [ 0x0, ['_LIST_ENTRY']],
    'Parameters' : [ 0x8, ['__unnamed_1a60']],
    'Function' : [ 0x40, ['unsigned char']],
} ],
  '_CC_EXTERNAL_CACHE_INFO' : [ 0x18, {
    'Callback' : [ 0x0, ['pointer', ['void']]],
    'DirtyPageStatistics' : [ 0x4, ['_DIRTY_PAGE_STATISTICS']],
    'Links' : [ 0x10, ['_LIST_ENTRY']],
} ],
  '_LOG_HANDLE_CONTEXT' : [ 0x68, {
    'LogHandle' : [ 0x0, ['pointer', ['void']]],
    'FlushToLsnRoutine' : [ 0x4, ['pointer', ['void']]],
    'QueryLogHandleInfoRoutine' : [ 0x8, ['pointer', ['void']]],
    'DirtyPageStatistics' : [ 0xc, ['_DIRTY_PAGE_STATISTICS']],
    'DirtyPageThresholds' : [ 0x18, ['_DIRTY_PAGE_THRESHOLDS']],
    'AdditionalPagesToWrite' : [ 0x40, ['unsigned long']],
    'CcLWScanDPThreshold' : [ 0x44, ['unsigned long']],
    'LargestLsnForCurrentLWScan' : [ 0x48, ['_LARGE_INTEGER']],
    'RelatedFileObject' : [ 0x50, ['pointer', ['_FILE_OBJECT']]],
    'LargestLsnFileObjectKey' : [ 0x54, ['unsigned long']],
    'LastLWTimeStamp' : [ 0x58, ['_LARGE_INTEGER']],
    'Flags' : [ 0x60, ['unsigned long']],
} ],
  '_MBCB' : [ 0x88, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeIsInZone' : [ 0x2, ['short']],
    'PagesToWrite' : [ 0x4, ['unsigned long']],
    'DirtyPages' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
    'BitmapRanges' : [ 0x10, ['_LIST_ENTRY']],
    'ResumeWritePage' : [ 0x18, ['long long']],
    'MostRecentlyDirtiedPage' : [ 0x20, ['long long']],
    'BitmapRange1' : [ 0x28, ['_BITMAP_RANGE']],
    'BitmapRange2' : [ 0x48, ['_BITMAP_RANGE']],
    'BitmapRange3' : [ 0x68, ['_BITMAP_RANGE']],
} ],
  '_BITMAP_RANGE' : [ 0x20, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'BasePage' : [ 0x8, ['long long']],
    'FirstDirtyPage' : [ 0x10, ['unsigned long']],
    'LastDirtyPage' : [ 0x14, ['unsigned long']],
    'DirtyPages' : [ 0x18, ['unsigned long']],
    'Bitmap' : [ 0x1c, ['pointer', ['unsigned long']]],
} ],
  'VACB_LEVEL_ALLOCATION_LIST' : [ 0x10, {
    'VacbLevelList' : [ 0x0, ['_LIST_ENTRY']],
    'VacbLevelWithBcbListHeads' : [ 0x8, ['pointer', ['void']]],
    'VacbLevelsAllocated' : [ 0xc, ['unsigned long']],
} ],
  '_VACB_LEVEL_REFERENCE' : [ 0x8, {
    'Reference' : [ 0x0, ['long']],
    'SpecialReference' : [ 0x4, ['long']],
} ],
  '_CACHE_UNINITIALIZE_EVENT' : [ 0x14, {
    'Next' : [ 0x0, ['pointer', ['_CACHE_UNINITIALIZE_EVENT']]],
    'Event' : [ 0x4, ['_KEVENT']],
} ],
  '_HEAP_LIST_LOOKUP' : [ 0x24, {
    'ExtendedLookup' : [ 0x0, ['pointer', ['_HEAP_LIST_LOOKUP']]],
    'ArraySize' : [ 0x4, ['unsigned long']],
    'ExtraItem' : [ 0x8, ['unsigned long']],
    'ItemCount' : [ 0xc, ['unsigned long']],
    'OutOfRangeItems' : [ 0x10, ['unsigned long']],
    'BaseIndex' : [ 0x14, ['unsigned long']],
    'ListHead' : [ 0x18, ['pointer', ['_LIST_ENTRY']]],
    'ListsInUseUlong' : [ 0x1c, ['pointer', ['unsigned long']]],
    'ListHints' : [ 0x20, ['pointer', ['pointer', ['_LIST_ENTRY']]]],
} ],
  '_HEAP' : [ 0x248, {
    'Segment' : [ 0x0, ['_HEAP_SEGMENT']],
    'Entry' : [ 0x0, ['_HEAP_ENTRY']],
    'SegmentSignature' : [ 0x8, ['unsigned long']],
    'SegmentFlags' : [ 0xc, ['unsigned long']],
    'SegmentListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'Heap' : [ 0x18, ['pointer', ['_HEAP']]],
    'BaseAddress' : [ 0x1c, ['pointer', ['void']]],
    'NumberOfPages' : [ 0x20, ['unsigned long']],
    'FirstEntry' : [ 0x24, ['pointer', ['_HEAP_ENTRY']]],
    'LastValidEntry' : [ 0x28, ['pointer', ['_HEAP_ENTRY']]],
    'NumberOfUnCommittedPages' : [ 0x2c, ['unsigned long']],
    'NumberOfUnCommittedRanges' : [ 0x30, ['unsigned long']],
    'SegmentAllocatorBackTraceIndex' : [ 0x34, ['unsigned short']],
    'Reserved' : [ 0x36, ['unsigned short']],
    'UCRSegmentList' : [ 0x38, ['_LIST_ENTRY']],
    'Flags' : [ 0x40, ['unsigned long']],
    'ForceFlags' : [ 0x44, ['unsigned long']],
    'CompatibilityFlags' : [ 0x48, ['unsigned long']],
    'EncodeFlagMask' : [ 0x4c, ['unsigned long']],
    'Encoding' : [ 0x50, ['_HEAP_ENTRY']],
    'Interceptor' : [ 0x58, ['unsigned long']],
    'VirtualMemoryThreshold' : [ 0x5c, ['unsigned long']],
    'Signature' : [ 0x60, ['unsigned long']],
    'SegmentReserve' : [ 0x64, ['unsigned long']],
    'SegmentCommit' : [ 0x68, ['unsigned long']],
    'DeCommitFreeBlockThreshold' : [ 0x6c, ['unsigned long']],
    'DeCommitTotalFreeThreshold' : [ 0x70, ['unsigned long']],
    'TotalFreeSize' : [ 0x74, ['unsigned long']],
    'MaximumAllocationSize' : [ 0x78, ['unsigned long']],
    'ProcessHeapsListIndex' : [ 0x7c, ['unsigned short']],
    'HeaderValidateLength' : [ 0x7e, ['unsigned short']],
    'HeaderValidateCopy' : [ 0x80, ['pointer', ['void']]],
    'NextAvailableTagIndex' : [ 0x84, ['unsigned short']],
    'MaximumTagIndex' : [ 0x86, ['unsigned short']],
    'TagEntries' : [ 0x88, ['pointer', ['_HEAP_TAG_ENTRY']]],
    'UCRList' : [ 0x8c, ['_LIST_ENTRY']],
    'AlignRound' : [ 0x94, ['unsigned long']],
    'AlignMask' : [ 0x98, ['unsigned long']],
    'VirtualAllocdBlocks' : [ 0x9c, ['_LIST_ENTRY']],
    'SegmentList' : [ 0xa4, ['_LIST_ENTRY']],
    'AllocatorBackTraceIndex' : [ 0xac, ['unsigned short']],
    'NonDedicatedListLength' : [ 0xb0, ['unsigned long']],
    'BlocksIndex' : [ 0xb4, ['pointer', ['void']]],
    'UCRIndex' : [ 0xb8, ['pointer', ['void']]],
    'PseudoTagEntries' : [ 0xbc, ['pointer', ['_HEAP_PSEUDO_TAG_ENTRY']]],
    'FreeLists' : [ 0xc0, ['_LIST_ENTRY']],
    'LockVariable' : [ 0xc8, ['pointer', ['_HEAP_LOCK']]],
    'CommitRoutine' : [ 0xcc, ['pointer', ['void']]],
    'FrontEndHeap' : [ 0xd0, ['pointer', ['void']]],
    'FrontHeapLockCount' : [ 0xd4, ['unsigned short']],
    'FrontEndHeapType' : [ 0xd6, ['unsigned char']],
    'RequestedFrontEndHeapType' : [ 0xd7, ['unsigned char']],
    'FrontEndHeapUsageData' : [ 0xd8, ['pointer', ['unsigned short']]],
    'FrontEndHeapMaximumIndex' : [ 0xdc, ['unsigned short']],
    'FrontEndHeapStatusBitmap' : [ 0xde, ['array', 257, ['unsigned char']]],
    'Counters' : [ 0x1e0, ['_HEAP_COUNTERS']],
    'TuningParameters' : [ 0x23c, ['_HEAP_TUNING_PARAMETERS']],
} ],
  '__unnamed_1ace' : [ 0x38, {
    'CriticalSection' : [ 0x0, ['_RTL_CRITICAL_SECTION']],
    'Resource' : [ 0x0, ['_ERESOURCE']],
} ],
  '_HEAP_LOCK' : [ 0x38, {
    'Lock' : [ 0x0, ['__unnamed_1ace']],
} ],
  '_HEAP_ENTRY' : [ 0x8, {
    'UnpackedEntry' : [ 0x0, ['_HEAP_UNPACKED_ENTRY']],
    'Size' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned char']],
    'SmallTagIndex' : [ 0x3, ['unsigned char']],
    'SubSegmentCode' : [ 0x0, ['unsigned long']],
    'PreviousSize' : [ 0x4, ['unsigned short']],
    'SegmentOffset' : [ 0x6, ['unsigned char']],
    'LFHFlags' : [ 0x6, ['unsigned char']],
    'UnusedBytes' : [ 0x7, ['unsigned char']],
    'ExtendedEntry' : [ 0x0, ['_HEAP_EXTENDED_ENTRY']],
    'FunctionIndex' : [ 0x0, ['unsigned short']],
    'ContextValue' : [ 0x2, ['unsigned short']],
    'InterceptorValue' : [ 0x0, ['unsigned long']],
    'UnusedBytesLength' : [ 0x4, ['unsigned short']],
    'EntryOffset' : [ 0x6, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0x7, ['unsigned char']],
    'Code1' : [ 0x0, ['unsigned long']],
    'Code2' : [ 0x4, ['unsigned short']],
    'Code3' : [ 0x6, ['unsigned char']],
    'Code4' : [ 0x7, ['unsigned char']],
    'Code234' : [ 0x4, ['unsigned long']],
    'AgregateCode' : [ 0x0, ['unsigned long long']],
} ],
  '_HEAP_SEGMENT' : [ 0x40, {
    'Entry' : [ 0x0, ['_HEAP_ENTRY']],
    'SegmentSignature' : [ 0x8, ['unsigned long']],
    'SegmentFlags' : [ 0xc, ['unsigned long']],
    'SegmentListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'Heap' : [ 0x18, ['pointer', ['_HEAP']]],
    'BaseAddress' : [ 0x1c, ['pointer', ['void']]],
    'NumberOfPages' : [ 0x20, ['unsigned long']],
    'FirstEntry' : [ 0x24, ['pointer', ['_HEAP_ENTRY']]],
    'LastValidEntry' : [ 0x28, ['pointer', ['_HEAP_ENTRY']]],
    'NumberOfUnCommittedPages' : [ 0x2c, ['unsigned long']],
    'NumberOfUnCommittedRanges' : [ 0x30, ['unsigned long']],
    'SegmentAllocatorBackTraceIndex' : [ 0x34, ['unsigned short']],
    'Reserved' : [ 0x36, ['unsigned short']],
    'UCRSegmentList' : [ 0x38, ['_LIST_ENTRY']],
} ],
  '_HEAP_VIRTUAL_ALLOC_ENTRY' : [ 0x20, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'ExtraStuff' : [ 0x8, ['_HEAP_ENTRY_EXTRA']],
    'CommitSize' : [ 0x10, ['unsigned long']],
    'ReserveSize' : [ 0x14, ['unsigned long']],
    'BusyBlock' : [ 0x18, ['_HEAP_ENTRY']],
} ],
  '_HEAP_FREE_ENTRY' : [ 0x10, {
    'HeapEntry' : [ 0x0, ['_HEAP_ENTRY']],
    'UnpackedEntry' : [ 0x0, ['_HEAP_UNPACKED_ENTRY']],
    'Size' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned char']],
    'SmallTagIndex' : [ 0x3, ['unsigned char']],
    'SubSegmentCode' : [ 0x0, ['unsigned long']],
    'PreviousSize' : [ 0x4, ['unsigned short']],
    'SegmentOffset' : [ 0x6, ['unsigned char']],
    'LFHFlags' : [ 0x6, ['unsigned char']],
    'UnusedBytes' : [ 0x7, ['unsigned char']],
    'ExtendedEntry' : [ 0x0, ['_HEAP_EXTENDED_ENTRY']],
    'FunctionIndex' : [ 0x0, ['unsigned short']],
    'ContextValue' : [ 0x2, ['unsigned short']],
    'InterceptorValue' : [ 0x0, ['unsigned long']],
    'UnusedBytesLength' : [ 0x4, ['unsigned short']],
    'EntryOffset' : [ 0x6, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0x7, ['unsigned char']],
    'Code1' : [ 0x0, ['unsigned long']],
    'Code2' : [ 0x4, ['unsigned short']],
    'Code3' : [ 0x6, ['unsigned char']],
    'Code4' : [ 0x7, ['unsigned char']],
    'Code234' : [ 0x4, ['unsigned long']],
    'AgregateCode' : [ 0x0, ['unsigned long long']],
    'FreeList' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '__unnamed_1b21' : [ 0x4, {
    'DataLength' : [ 0x0, ['short']],
    'TotalLength' : [ 0x2, ['short']],
} ],
  '__unnamed_1b23' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1b21']],
    'Length' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_1b25' : [ 0x4, {
    'Type' : [ 0x0, ['short']],
    'DataInfoOffset' : [ 0x2, ['short']],
} ],
  '__unnamed_1b27' : [ 0x4, {
    's2' : [ 0x0, ['__unnamed_1b25']],
    'ZeroInit' : [ 0x0, ['unsigned long']],
} ],
  '_PORT_MESSAGE' : [ 0x18, {
    'u1' : [ 0x0, ['__unnamed_1b23']],
    'u2' : [ 0x4, ['__unnamed_1b27']],
    'ClientId' : [ 0x8, ['_CLIENT_ID']],
    'DoNotUseThisField' : [ 0x8, ['double']],
    'MessageId' : [ 0x10, ['unsigned long']],
    'ClientViewSize' : [ 0x14, ['unsigned long']],
    'CallbackId' : [ 0x14, ['unsigned long']],
} ],
  '_ALPC_MESSAGE_ATTRIBUTES' : [ 0x8, {
    'AllocatedAttributes' : [ 0x0, ['unsigned long']],
    'ValidAttributes' : [ 0x4, ['unsigned long']],
} ],
  '_ALPC_HANDLE_ENTRY' : [ 0x4, {
    'Object' : [ 0x0, ['pointer', ['void']]],
} ],
  '_BLOB_TYPE' : [ 0x20, {
    'ResourceId' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'BLOB_TYPE_UNKNOWN', 1: 'BLOB_TYPE_CONNECTION_INFO', 2: 'BLOB_TYPE_MESSAGE', 3: 'BLOB_TYPE_SECURITY_CONTEXT', 4: 'BLOB_TYPE_SECTION', 5: 'BLOB_TYPE_REGION', 6: 'BLOB_TYPE_VIEW', 7: 'BLOB_TYPE_RESERVE', 8: 'BLOB_TYPE_DIRECT_TRANSFER', 9: 'BLOB_TYPE_HANDLE_DATA', 10: 'BLOB_TYPE_MAX_ID'})]],
    'PoolTag' : [ 0x4, ['unsigned long']],
    'LookasideIndex' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['unsigned long']],
    'Counters' : [ 0x10, ['pointer', ['_BLOB_COUNTERS']]],
    'DeleteProcedure' : [ 0x14, ['pointer', ['void']]],
    'DestroyProcedure' : [ 0x18, ['pointer', ['void']]],
    'UsualSize' : [ 0x1c, ['unsigned long']],
} ],
  '__unnamed_1b44' : [ 0x1, {
    'ReferenceCache' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Lookaside' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Initializing' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Deleted' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
} ],
  '__unnamed_1b46' : [ 0x1, {
    's1' : [ 0x0, ['__unnamed_1b44']],
    'Flags' : [ 0x0, ['unsigned char']],
} ],
  '_BLOB' : [ 0x18, {
    'ResourceList' : [ 0x0, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'u1' : [ 0x8, ['__unnamed_1b46']],
    'ResourceId' : [ 0x9, ['unsigned char']],
    'CachedReferences' : [ 0xa, ['short']],
    'ReferenceCount' : [ 0xc, ['long']],
    'Pad' : [ 0x10, ['unsigned long']],
    'Lock' : [ 0x14, ['_EX_PUSH_LOCK']],
} ],
  '__unnamed_1b5a' : [ 0x4, {
    'Internal' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Secure' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '__unnamed_1b5c' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1b5a']],
} ],
  '_KALPC_SECTION' : [ 0x28, {
    'SectionObject' : [ 0x0, ['pointer', ['void']]],
    'Size' : [ 0x4, ['unsigned long']],
    'HandleTable' : [ 0x8, ['pointer', ['_ALPC_HANDLE_TABLE']]],
    'SectionHandle' : [ 0xc, ['pointer', ['void']]],
    'OwnerProcess' : [ 0x10, ['pointer', ['_EPROCESS']]],
    'OwnerPort' : [ 0x14, ['pointer', ['_ALPC_PORT']]],
    'u1' : [ 0x18, ['__unnamed_1b5c']],
    'NumberOfRegions' : [ 0x1c, ['unsigned long']],
    'RegionListHead' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '__unnamed_1b65' : [ 0x4, {
    'Secure' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
} ],
  '__unnamed_1b67' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1b65']],
} ],
  '_KALPC_REGION' : [ 0x30, {
    'RegionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Section' : [ 0x8, ['pointer', ['_KALPC_SECTION']]],
    'Offset' : [ 0xc, ['unsigned long']],
    'Size' : [ 0x10, ['unsigned long']],
    'ViewSize' : [ 0x14, ['unsigned long']],
    'u1' : [ 0x18, ['__unnamed_1b67']],
    'NumberOfViews' : [ 0x1c, ['unsigned long']],
    'ViewListHead' : [ 0x20, ['_LIST_ENTRY']],
    'ReadOnlyView' : [ 0x28, ['pointer', ['_KALPC_VIEW']]],
    'ReadWriteView' : [ 0x2c, ['pointer', ['_KALPC_VIEW']]],
} ],
  '__unnamed_1b6d' : [ 0x4, {
    'WriteAccess' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AutoRelease' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ForceUnlink' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
} ],
  '__unnamed_1b6f' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1b6d']],
} ],
  '_KALPC_VIEW' : [ 0x34, {
    'ViewListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Region' : [ 0x8, ['pointer', ['_KALPC_REGION']]],
    'OwnerPort' : [ 0xc, ['pointer', ['_ALPC_PORT']]],
    'OwnerProcess' : [ 0x10, ['pointer', ['_EPROCESS']]],
    'Address' : [ 0x14, ['pointer', ['void']]],
    'Size' : [ 0x18, ['unsigned long']],
    'SecureViewHandle' : [ 0x1c, ['pointer', ['void']]],
    'WriteAccessHandle' : [ 0x20, ['pointer', ['void']]],
    'u1' : [ 0x24, ['__unnamed_1b6f']],
    'NumberOfOwnerMessages' : [ 0x28, ['unsigned long']],
    'ProcessViewListEntry' : [ 0x2c, ['_LIST_ENTRY']],
} ],
  '_ALPC_COMMUNICATION_INFO' : [ 0x28, {
    'ConnectionPort' : [ 0x0, ['pointer', ['_ALPC_PORT']]],
    'ServerCommunicationPort' : [ 0x4, ['pointer', ['_ALPC_PORT']]],
    'ClientCommunicationPort' : [ 0x8, ['pointer', ['_ALPC_PORT']]],
    'CommunicationList' : [ 0xc, ['_LIST_ENTRY']],
    'HandleTable' : [ 0x14, ['_ALPC_HANDLE_TABLE']],
    'CloseMessage' : [ 0x24, ['pointer', ['_KALPC_MESSAGE']]],
} ],
  '__unnamed_1b8c' : [ 0x4, {
    'Initialized' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned long')]],
    'ConnectionPending' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ConnectionRefused' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Disconnected' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Closed' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'NoFlushOnClose' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ReturnExtendedInfo' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'Waitable' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DynamicSecurity' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Wow64CompletionList' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Lpc' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'LpcToLpc' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'HasCompletionList' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'HadCompletionList' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'EnableCompletionList' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
} ],
  '__unnamed_1b8e' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1b8c']],
    'State' : [ 0x0, ['unsigned long']],
} ],
  '_ALPC_PORT' : [ 0x11c, {
    'PortListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'CommunicationInfo' : [ 0x8, ['pointer', ['_ALPC_COMMUNICATION_INFO']]],
    'OwnerProcess' : [ 0xc, ['pointer', ['_EPROCESS']]],
    'CompletionPort' : [ 0x10, ['pointer', ['void']]],
    'CompletionKey' : [ 0x14, ['pointer', ['void']]],
    'CompletionPacketLookaside' : [ 0x18, ['pointer', ['_ALPC_COMPLETION_PACKET_LOOKASIDE']]],
    'PortContext' : [ 0x1c, ['pointer', ['void']]],
    'StaticSecurity' : [ 0x20, ['_SECURITY_CLIENT_CONTEXT']],
    'IncomingQueueLock' : [ 0x5c, ['_EX_PUSH_LOCK']],
    'MainQueue' : [ 0x60, ['_LIST_ENTRY']],
    'LargeMessageQueue' : [ 0x68, ['_LIST_ENTRY']],
    'PendingQueueLock' : [ 0x70, ['_EX_PUSH_LOCK']],
    'PendingQueue' : [ 0x74, ['_LIST_ENTRY']],
    'DirectQueueLock' : [ 0x7c, ['_EX_PUSH_LOCK']],
    'DirectQueue' : [ 0x80, ['_LIST_ENTRY']],
    'WaitQueueLock' : [ 0x88, ['_EX_PUSH_LOCK']],
    'WaitQueue' : [ 0x8c, ['_LIST_ENTRY']],
    'Semaphore' : [ 0x94, ['pointer', ['_KSEMAPHORE']]],
    'DummyEvent' : [ 0x94, ['pointer', ['_KEVENT']]],
    'PortAttributes' : [ 0x98, ['_ALPC_PORT_ATTRIBUTES']],
    'ResourceListLock' : [ 0xc4, ['_EX_PUSH_LOCK']],
    'ResourceListHead' : [ 0xc8, ['_LIST_ENTRY']],
    'PortObjectLock' : [ 0xd0, ['_EX_PUSH_LOCK']],
    'CompletionList' : [ 0xd4, ['pointer', ['_ALPC_COMPLETION_LIST']]],
    'CallbackObject' : [ 0xd8, ['pointer', ['_CALLBACK_OBJECT']]],
    'CallbackContext' : [ 0xdc, ['pointer', ['void']]],
    'CanceledQueue' : [ 0xe0, ['_LIST_ENTRY']],
    'SequenceNo' : [ 0xe8, ['long']],
    'ReferenceNo' : [ 0xec, ['long']],
    'ReferenceNoWait' : [ 0xf0, ['pointer', ['_PALPC_PORT_REFERENCE_WAIT_BLOCK']]],
    'u1' : [ 0xf4, ['__unnamed_1b8e']],
    'TargetQueuePort' : [ 0xf8, ['pointer', ['_ALPC_PORT']]],
    'TargetSequencePort' : [ 0xfc, ['pointer', ['_ALPC_PORT']]],
    'CachedMessage' : [ 0x100, ['pointer', ['_KALPC_MESSAGE']]],
    'MainQueueLength' : [ 0x104, ['unsigned long']],
    'LargeMessageQueueLength' : [ 0x108, ['unsigned long']],
    'PendingQueueLength' : [ 0x10c, ['unsigned long']],
    'DirectQueueLength' : [ 0x110, ['unsigned long']],
    'CanceledQueueLength' : [ 0x114, ['unsigned long']],
    'WaitQueueLength' : [ 0x118, ['unsigned long']],
} ],
  '_ALPC_COMPLETION_LIST' : [ 0x58, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'OwnerProcess' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'CompletionListLock' : [ 0xc, ['_EX_PUSH_LOCK']],
    'Mdl' : [ 0x10, ['pointer', ['_MDL']]],
    'UserVa' : [ 0x14, ['pointer', ['void']]],
    'UserLimit' : [ 0x18, ['pointer', ['void']]],
    'DataUserVa' : [ 0x1c, ['pointer', ['void']]],
    'SystemVa' : [ 0x20, ['pointer', ['void']]],
    'TotalSize' : [ 0x24, ['unsigned long']],
    'Header' : [ 0x28, ['pointer', ['_ALPC_COMPLETION_LIST_HEADER']]],
    'List' : [ 0x2c, ['pointer', ['void']]],
    'ListSize' : [ 0x30, ['unsigned long']],
    'Bitmap' : [ 0x34, ['pointer', ['void']]],
    'BitmapSize' : [ 0x38, ['unsigned long']],
    'Data' : [ 0x3c, ['pointer', ['void']]],
    'DataSize' : [ 0x40, ['unsigned long']],
    'BitmapLimit' : [ 0x44, ['unsigned long']],
    'BitmapNextHint' : [ 0x48, ['unsigned long']],
    'ConcurrencyCount' : [ 0x4c, ['unsigned long']],
    'AttributeFlags' : [ 0x50, ['unsigned long']],
    'AttributeSize' : [ 0x54, ['unsigned long']],
} ],
  '_OBJECT_ATTRIBUTES' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'RootDirectory' : [ 0x4, ['pointer', ['void']]],
    'ObjectName' : [ 0x8, ['pointer', ['_UNICODE_STRING']]],
    'Attributes' : [ 0xc, ['unsigned long']],
    'SecurityDescriptor' : [ 0x10, ['pointer', ['void']]],
    'SecurityQualityOfService' : [ 0x14, ['pointer', ['void']]],
} ],
  '_OBJECT_TYPE' : [ 0x90, {
    'TypeList' : [ 0x0, ['_LIST_ENTRY']],
    'Name' : [ 0x8, ['_UNICODE_STRING']],
    'DefaultObject' : [ 0x10, ['pointer', ['void']]],
    'Index' : [ 0x14, ['unsigned char']],
    'TotalNumberOfObjects' : [ 0x18, ['unsigned long']],
    'TotalNumberOfHandles' : [ 0x1c, ['unsigned long']],
    'HighWaterNumberOfObjects' : [ 0x20, ['unsigned long']],
    'HighWaterNumberOfHandles' : [ 0x24, ['unsigned long']],
    'TypeInfo' : [ 0x28, ['_OBJECT_TYPE_INITIALIZER']],
    'TypeLock' : [ 0x80, ['_EX_PUSH_LOCK']],
    'Key' : [ 0x84, ['unsigned long']],
    'CallbackList' : [ 0x88, ['_LIST_ENTRY']],
} ],
  '_PALPC_PORT_REFERENCE_WAIT_BLOCK' : [ 0x14, {
    'DesiredReferenceNoEvent' : [ 0x0, ['_KEVENT']],
    'DesiredReferenceNo' : [ 0x10, ['long']],
} ],
  '__unnamed_1bb1' : [ 0x4, {
    'QueueType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'QueuePortType' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 7, native_type='unsigned long')]],
    'Canceled' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Ready' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ReleaseMessage' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'SharedQuota' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'ReplyWaitReply' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'OwnerPortReference' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ReserveReference' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ReceiverReference' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ViewAttributeRetrieved' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'InDispatch' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
} ],
  '__unnamed_1bb3' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1bb1']],
    'State' : [ 0x0, ['unsigned long']],
} ],
  '_KALPC_MESSAGE' : [ 0x90, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'PortQueue' : [ 0x8, ['pointer', ['_ALPC_PORT']]],
    'OwnerPort' : [ 0xc, ['pointer', ['_ALPC_PORT']]],
    'WaitingThread' : [ 0x10, ['pointer', ['_ETHREAD']]],
    'u1' : [ 0x14, ['__unnamed_1bb3']],
    'SequenceNo' : [ 0x18, ['long']],
    'QuotaProcess' : [ 0x1c, ['pointer', ['_EPROCESS']]],
    'QuotaBlock' : [ 0x1c, ['pointer', ['void']]],
    'CancelSequencePort' : [ 0x20, ['pointer', ['_ALPC_PORT']]],
    'CancelQueuePort' : [ 0x24, ['pointer', ['_ALPC_PORT']]],
    'CancelSequenceNo' : [ 0x28, ['long']],
    'CancelListEntry' : [ 0x2c, ['_LIST_ENTRY']],
    'Reserve' : [ 0x34, ['pointer', ['_KALPC_RESERVE']]],
    'MessageAttributes' : [ 0x38, ['_KALPC_MESSAGE_ATTRIBUTES']],
    'DataUserVa' : [ 0x58, ['pointer', ['void']]],
    'CommunicationInfo' : [ 0x5c, ['pointer', ['_ALPC_COMMUNICATION_INFO']]],
    'ConnectionPort' : [ 0x60, ['pointer', ['_ALPC_PORT']]],
    'ServerThread' : [ 0x64, ['pointer', ['_ETHREAD']]],
    'WakeReference' : [ 0x68, ['pointer', ['void']]],
    'ExtensionBuffer' : [ 0x6c, ['pointer', ['void']]],
    'ExtensionBufferSize' : [ 0x70, ['unsigned long']],
    'PortMessage' : [ 0x78, ['_PORT_MESSAGE']],
} ],
  '_ALPC_DISPATCH_CONTEXT' : [ 0x24, {
    'PortObject' : [ 0x0, ['pointer', ['_ALPC_PORT']]],
    'Message' : [ 0x4, ['pointer', ['_KALPC_MESSAGE']]],
    'CommunicationInfo' : [ 0x8, ['pointer', ['_ALPC_COMMUNICATION_INFO']]],
    'TargetThread' : [ 0xc, ['pointer', ['_ETHREAD']]],
    'TargetPort' : [ 0x10, ['pointer', ['_ALPC_PORT']]],
    'DirectEvent' : [ 0x14, ['_KALPC_DIRECT_EVENT']],
    'Flags' : [ 0x18, ['unsigned long']],
    'TotalLength' : [ 0x1c, ['unsigned short']],
    'Type' : [ 0x1e, ['unsigned short']],
    'DataInfoOffset' : [ 0x20, ['unsigned short']],
    'SignalCompletion' : [ 0x22, ['unsigned char']],
    'PostedToCompletionList' : [ 0x23, ['unsigned char']],
} ],
  '_REMOTE_PORT_VIEW' : [ 0xc, {
    'Length' : [ 0x0, ['unsigned long']],
    'ViewSize' : [ 0x4, ['unsigned long']],
    'ViewBase' : [ 0x8, ['pointer', ['void']]],
} ],
  '_KALPC_RESERVE' : [ 0x14, {
    'OwnerPort' : [ 0x0, ['pointer', ['_ALPC_PORT']]],
    'HandleTable' : [ 0x4, ['pointer', ['_ALPC_HANDLE_TABLE']]],
    'Handle' : [ 0x8, ['pointer', ['void']]],
    'Message' : [ 0xc, ['pointer', ['_KALPC_MESSAGE']]],
    'Active' : [ 0x10, ['long']],
} ],
  '_KALPC_HANDLE_DATA' : [ 0x20, {
    'Flags' : [ 0x0, ['unsigned long']],
    'ObjectType' : [ 0x4, ['unsigned long']],
    'DuplicateContext' : [ 0x8, ['_OB_DUPLICATE_OBJECT_STATE']],
} ],
  '_KALPC_MESSAGE_ATTRIBUTES' : [ 0x20, {
    'ClientContext' : [ 0x0, ['pointer', ['void']]],
    'ServerContext' : [ 0x4, ['pointer', ['void']]],
    'PortContext' : [ 0x8, ['pointer', ['void']]],
    'CancelPortContext' : [ 0xc, ['pointer', ['void']]],
    'SecurityData' : [ 0x10, ['pointer', ['_KALPC_SECURITY_DATA']]],
    'View' : [ 0x14, ['pointer', ['_KALPC_VIEW']]],
    'HandleData' : [ 0x18, ['pointer', ['_KALPC_HANDLE_DATA']]],
    'DirectEvent' : [ 0x1c, ['_KALPC_DIRECT_EVENT']],
} ],
  '__unnamed_1bf6' : [ 0x4, {
    'Revoked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Impersonated' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '__unnamed_1bf8' : [ 0x4, {
    's1' : [ 0x0, ['__unnamed_1bf6']],
} ],
  '_KALPC_SECURITY_DATA' : [ 0x50, {
    'HandleTable' : [ 0x0, ['pointer', ['_ALPC_HANDLE_TABLE']]],
    'ContextHandle' : [ 0x4, ['pointer', ['void']]],
    'OwningProcess' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'OwnerPort' : [ 0xc, ['pointer', ['_ALPC_PORT']]],
    'DynamicSecurity' : [ 0x10, ['_SECURITY_CLIENT_CONTEXT']],
    'u1' : [ 0x4c, ['__unnamed_1bf8']],
} ],
  '_KALPC_DIRECT_EVENT' : [ 0x4, {
    'Event' : [ 0x0, ['unsigned long']],
    'Referenced' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '_IO_MINI_COMPLETION_PACKET_USER' : [ 0x28, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'PacketType' : [ 0x8, ['unsigned long']],
    'KeyContext' : [ 0xc, ['pointer', ['void']]],
    'ApcContext' : [ 0x10, ['pointer', ['void']]],
    'IoStatus' : [ 0x14, ['long']],
    'IoStatusInformation' : [ 0x18, ['unsigned long']],
    'MiniPacketCallback' : [ 0x1c, ['pointer', ['void']]],
    'Context' : [ 0x20, ['pointer', ['void']]],
    'Allocated' : [ 0x24, ['unsigned char']],
} ],
  '_IOP_IRP_EXTENSION' : [ 0x28, {
    'ExtensionFlags' : [ 0x0, ['unsigned short']],
    'Allocated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'PropagateId' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'SpareBits' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned short')]],
    'TypesAllocated' : [ 0x2, ['unsigned short']],
    'GenericExtension' : [ 0x4, ['array', 4, ['unsigned char']]],
    'VerifierContext' : [ 0x8, ['pointer', ['void']]],
    'ActivityId' : [ 0xc, ['_GUID']],
    'Timestamp' : [ 0x1c, ['_LARGE_INTEGER']],
    'ZeroingOffset' : [ 0x1c, ['unsigned long']],
    'FsTrackOffsetBlob' : [ 0x1c, ['pointer', ['_IO_IRP_EXT_TRACK_OFFSET_HEADER']]],
    'FsTrackedOffset' : [ 0x20, ['long long']],
} ],
  '_DRIVER_OBJECT' : [ 0xa8, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'Flags' : [ 0x8, ['unsigned long']],
    'DriverStart' : [ 0xc, ['pointer', ['void']]],
    'DriverSize' : [ 0x10, ['unsigned long']],
    'DriverSection' : [ 0x14, ['pointer', ['void']]],
    'DriverExtension' : [ 0x18, ['pointer', ['_DRIVER_EXTENSION']]],
    'DriverName' : [ 0x1c, ['_UNICODE_STRING']],
    'HardwareDatabase' : [ 0x24, ['pointer', ['_UNICODE_STRING']]],
    'FastIoDispatch' : [ 0x28, ['pointer', ['_FAST_IO_DISPATCH']]],
    'DriverInit' : [ 0x2c, ['pointer', ['void']]],
    'DriverStartIo' : [ 0x30, ['pointer', ['void']]],
    'DriverUnload' : [ 0x34, ['pointer', ['void']]],
    'MajorFunction' : [ 0x38, ['array', 28, ['pointer', ['void']]]],
} ],
  '_FILE_SEGMENT_ELEMENT' : [ 0x8, {
    'Buffer' : [ 0x0, ['pointer64', ['void']]],
    'Alignment' : [ 0x0, ['unsigned long long']],
} ],
  '_RELATIVE_SYMLINK_INFO' : [ 0x14, {
    'ExposedNamespaceLength' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'DeviceNameLength' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['unsigned short']],
    'InteriorMountPoint' : [ 0x8, ['pointer', ['_RELATIVE_SYMLINK_INFO']]],
    'OpenedName' : [ 0xc, ['_UNICODE_STRING']],
} ],
  '_ECP_LIST' : [ 0x10, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x4, ['unsigned long']],
    'EcpList' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_IOP_FILE_OBJECT_EXTENSION' : [ 0x28, {
    'FoExtFlags' : [ 0x0, ['unsigned long']],
    'FoExtPerTypeExtension' : [ 0x4, ['array', 8, ['pointer', ['void']]]],
    'FoIoPriorityHint' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'IopIoPriorityNotSet', 1: 'IopIoPriorityVeryLow', 2: 'IopIoPriorityLow', 3: 'IopIoPriorityNormal', 4: 'IopIoPriorityHigh', 5: 'IopIoPriorityCritical', 6: 'MaxIopIoPriorityTypes'})]],
} ],
  '_OPEN_PACKET' : [ 0x78, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'FileObject' : [ 0x4, ['pointer', ['_FILE_OBJECT']]],
    'FinalStatus' : [ 0x8, ['long']],
    'Information' : [ 0xc, ['unsigned long']],
    'ParseCheck' : [ 0x10, ['unsigned long']],
    'RelatedFileObject' : [ 0x14, ['pointer', ['_FILE_OBJECT']]],
    'ReferencedDeviceObject' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
    'OriginalAttributes' : [ 0x18, ['pointer', ['_OBJECT_ATTRIBUTES']]],
    'AllocationSize' : [ 0x20, ['_LARGE_INTEGER']],
    'CreateOptions' : [ 0x28, ['unsigned long']],
    'FileAttributes' : [ 0x2c, ['unsigned short']],
    'ShareAccess' : [ 0x2e, ['unsigned short']],
    'EaBuffer' : [ 0x30, ['pointer', ['void']]],
    'EaLength' : [ 0x34, ['unsigned long']],
    'Options' : [ 0x38, ['unsigned long']],
    'Disposition' : [ 0x3c, ['unsigned long']],
    'BasicInformation' : [ 0x40, ['pointer', ['_FILE_BASIC_INFORMATION']]],
    'NetworkInformation' : [ 0x44, ['pointer', ['_FILE_NETWORK_OPEN_INFORMATION']]],
    'CreateFileType' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: 'CreateFileTypeNone', 1: 'CreateFileTypeNamedPipe', 2: 'CreateFileTypeMailslot'})]],
    'MailslotOrPipeParameters' : [ 0x4c, ['pointer', ['void']]],
    'Override' : [ 0x50, ['unsigned char']],
    'QueryOnly' : [ 0x51, ['unsigned char']],
    'DeleteOnly' : [ 0x52, ['unsigned char']],
    'FullAttributes' : [ 0x53, ['unsigned char']],
    'LocalFileObject' : [ 0x54, ['pointer', ['_DUMMY_FILE_OBJECT']]],
    'InternalFlags' : [ 0x58, ['unsigned long']],
    'AccessMode' : [ 0x5c, ['unsigned char']],
    'DriverCreateContext' : [ 0x60, ['_IO_DRIVER_CREATE_CONTEXT']],
} ],
  '_ETW_SYSTEMTIME' : [ 0x10, {
    'Year' : [ 0x0, ['unsigned short']],
    'Month' : [ 0x2, ['unsigned short']],
    'DayOfWeek' : [ 0x4, ['unsigned short']],
    'Day' : [ 0x6, ['unsigned short']],
    'Hour' : [ 0x8, ['unsigned short']],
    'Minute' : [ 0xa, ['unsigned short']],
    'Second' : [ 0xc, ['unsigned short']],
    'Milliseconds' : [ 0xe, ['unsigned short']],
} ],
  '_TIME_FIELDS' : [ 0x10, {
    'Year' : [ 0x0, ['short']],
    'Month' : [ 0x2, ['short']],
    'Day' : [ 0x4, ['short']],
    'Hour' : [ 0x6, ['short']],
    'Minute' : [ 0x8, ['short']],
    'Second' : [ 0xa, ['short']],
    'Milliseconds' : [ 0xc, ['short']],
    'Weekday' : [ 0xe, ['short']],
} ],
  '__unnamed_1cc1' : [ 0x4, {
    'MajorVersion' : [ 0x0, ['unsigned char']],
    'MinorVersion' : [ 0x1, ['unsigned char']],
    'SubVersion' : [ 0x2, ['unsigned char']],
    'SubMinorVersion' : [ 0x3, ['unsigned char']],
} ],
  '_TRACE_LOGFILE_HEADER' : [ 0x110, {
    'BufferSize' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'VersionDetail' : [ 0x4, ['__unnamed_1cc1']],
    'ProviderVersion' : [ 0x8, ['unsigned long']],
    'NumberOfProcessors' : [ 0xc, ['unsigned long']],
    'EndTime' : [ 0x10, ['_LARGE_INTEGER']],
    'TimerResolution' : [ 0x18, ['unsigned long']],
    'MaximumFileSize' : [ 0x1c, ['unsigned long']],
    'LogFileMode' : [ 0x20, ['unsigned long']],
    'BuffersWritten' : [ 0x24, ['unsigned long']],
    'LogInstanceGuid' : [ 0x28, ['_GUID']],
    'StartBuffers' : [ 0x28, ['unsigned long']],
    'PointerSize' : [ 0x2c, ['unsigned long']],
    'EventsLost' : [ 0x30, ['unsigned long']],
    'CpuSpeedInMHz' : [ 0x34, ['unsigned long']],
    'LoggerName' : [ 0x38, ['pointer', ['unsigned short']]],
    'LogFileName' : [ 0x3c, ['pointer', ['unsigned short']]],
    'TimeZone' : [ 0x40, ['_RTL_TIME_ZONE_INFORMATION']],
    'BootTime' : [ 0xf0, ['_LARGE_INTEGER']],
    'PerfFreq' : [ 0xf8, ['_LARGE_INTEGER']],
    'StartTime' : [ 0x100, ['_LARGE_INTEGER']],
    'ReservedFlags' : [ 0x108, ['unsigned long']],
    'BuffersLost' : [ 0x10c, ['unsigned long']],
} ],
  '_WMI_LOGGER_CONTEXT' : [ 0x288, {
    'LoggerId' : [ 0x0, ['unsigned long']],
    'BufferSize' : [ 0x4, ['unsigned long']],
    'MaximumEventSize' : [ 0x8, ['unsigned long']],
    'LoggerMode' : [ 0xc, ['unsigned long']],
    'AcceptNewEvents' : [ 0x10, ['long']],
    'EventMarker' : [ 0x14, ['array', 1, ['unsigned long']]],
    'ErrorMarker' : [ 0x18, ['unsigned long']],
    'SizeMask' : [ 0x1c, ['unsigned long']],
    'GetCpuClock' : [ 0x20, ['pointer', ['void']]],
    'LoggerThread' : [ 0x24, ['pointer', ['_ETHREAD']]],
    'LoggerStatus' : [ 0x28, ['long']],
    'FailureReason' : [ 0x2c, ['unsigned long']],
    'BufferQueue' : [ 0x30, ['_ETW_BUFFER_QUEUE']],
    'OverflowQueue' : [ 0x3c, ['_ETW_BUFFER_QUEUE']],
    'GlobalList' : [ 0x48, ['_LIST_ENTRY']],
    'ProviderBinaryList' : [ 0x50, ['_LIST_ENTRY']],
    'BatchedBufferList' : [ 0x58, ['pointer', ['_WMI_BUFFER_HEADER']]],
    'CurrentBuffer' : [ 0x58, ['_EX_FAST_REF']],
    'LoggerName' : [ 0x5c, ['_UNICODE_STRING']],
    'LogFileName' : [ 0x64, ['_UNICODE_STRING']],
    'LogFilePattern' : [ 0x6c, ['_UNICODE_STRING']],
    'NewLogFileName' : [ 0x74, ['_UNICODE_STRING']],
    'ClockType' : [ 0x7c, ['unsigned long']],
    'LastFlushedBuffer' : [ 0x80, ['unsigned long']],
    'FlushTimer' : [ 0x84, ['unsigned long']],
    'FlushThreshold' : [ 0x88, ['unsigned long']],
    'ByteOffset' : [ 0x90, ['_LARGE_INTEGER']],
    'MinimumBuffers' : [ 0x98, ['unsigned long']],
    'BuffersAvailable' : [ 0x9c, ['long']],
    'NumberOfBuffers' : [ 0xa0, ['long']],
    'MaximumBuffers' : [ 0xa4, ['unsigned long']],
    'EventsLost' : [ 0xa8, ['unsigned long']],
    'PeakBuffersCount' : [ 0xac, ['long']],
    'BuffersWritten' : [ 0xb0, ['unsigned long']],
    'LogBuffersLost' : [ 0xb4, ['unsigned long']],
    'RealTimeBuffersDelivered' : [ 0xb8, ['unsigned long']],
    'RealTimeBuffersLost' : [ 0xbc, ['unsigned long']],
    'SequencePtr' : [ 0xc0, ['pointer', ['long']]],
    'LocalSequence' : [ 0xc4, ['unsigned long']],
    'InstanceGuid' : [ 0xc8, ['_GUID']],
    'MaximumFileSize' : [ 0xd8, ['unsigned long']],
    'FileCounter' : [ 0xdc, ['long']],
    'PoolType' : [ 0xe0, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPoolBase', 1: 'PagedPool', 2: 'NonPagedPoolBaseMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolBaseCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolBaseCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 516: 'NonPagedPoolNxCacheAligned', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 512: 'NonPagedPoolNx', 544: 'NonPagedPoolSessionNx', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'ReferenceTime' : [ 0xe8, ['_ETW_REF_CLOCK']],
    'CollectionOn' : [ 0xf8, ['long']],
    'ProviderInfoSize' : [ 0xfc, ['unsigned long']],
    'Consumers' : [ 0x100, ['_LIST_ENTRY']],
    'NumConsumers' : [ 0x108, ['unsigned long']],
    'TransitionConsumer' : [ 0x10c, ['pointer', ['_ETW_REALTIME_CONSUMER']]],
    'RealtimeLogfileHandle' : [ 0x110, ['pointer', ['void']]],
    'RealtimeLogfileName' : [ 0x114, ['_UNICODE_STRING']],
    'RealtimeWriteOffset' : [ 0x120, ['_LARGE_INTEGER']],
    'RealtimeReadOffset' : [ 0x128, ['_LARGE_INTEGER']],
    'RealtimeLogfileSize' : [ 0x130, ['_LARGE_INTEGER']],
    'RealtimeLogfileUsage' : [ 0x138, ['unsigned long long']],
    'RealtimeMaximumFileSize' : [ 0x140, ['unsigned long long']],
    'RealtimeBuffersSaved' : [ 0x148, ['unsigned long']],
    'RealtimeReferenceTime' : [ 0x150, ['_ETW_REF_CLOCK']],
    'NewRTEventsLost' : [ 0x160, ['Enumeration', dict(target = 'long', choices = {0: 'EtwRtEventNoLoss', 1: 'EtwRtEventLost', 2: 'EtwRtBufferLost', 3: 'EtwRtBackupLost', 4: 'EtwRtEventLossMax'})]],
    'LoggerEvent' : [ 0x164, ['_KEVENT']],
    'FlushEvent' : [ 0x174, ['_KEVENT']],
    'FlushTimeOutTimer' : [ 0x188, ['_KTIMER']],
    'LoggerDpc' : [ 0x1b0, ['_KDPC']],
    'LoggerMutex' : [ 0x1d0, ['_KMUTANT']],
    'LoggerLock' : [ 0x1f0, ['_EX_PUSH_LOCK']],
    'BufferListSpinLock' : [ 0x1f4, ['unsigned long']],
    'BufferListPushLock' : [ 0x1f4, ['_EX_PUSH_LOCK']],
    'ClientSecurityContext' : [ 0x1f8, ['_SECURITY_CLIENT_CONTEXT']],
    'TokenAccessInformation' : [ 0x234, ['pointer', ['_TOKEN_ACCESS_INFORMATION']]],
    'SecurityDescriptor' : [ 0x238, ['_EX_FAST_REF']],
    'StartTime' : [ 0x240, ['_LARGE_INTEGER']],
    'LogFileHandle' : [ 0x248, ['pointer', ['void']]],
    'BufferSequenceNumber' : [ 0x250, ['long long']],
    'Flags' : [ 0x258, ['unsigned long']],
    'Persistent' : [ 0x258, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'AutoLogger' : [ 0x258, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'FsReady' : [ 0x258, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'RealTime' : [ 0x258, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Wow' : [ 0x258, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'KernelTrace' : [ 0x258, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'NoMoreEnable' : [ 0x258, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'StackTracing' : [ 0x258, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ErrorLogged' : [ 0x258, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'RealtimeLoggerContextFreed' : [ 0x258, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PebsTracing' : [ 0x258, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'PmcCounters' : [ 0x258, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PageAlignBuffers' : [ 0x258, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'StackLookasideListAllocated' : [ 0x258, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'SecurityTrace' : [ 0x258, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'SpareFlags1' : [ 0x258, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'SystemLoggerIndex' : [ 0x258, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long')]],
    'StackCaching' : [ 0x258, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'SpareFlags2' : [ 0x258, ['BitField', dict(start_bit = 25, end_bit = 32, native_type='unsigned long')]],
    'RequestFlag' : [ 0x25c, ['unsigned long']],
    'DbgRequestNewFile' : [ 0x25c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DbgRequestUpdateFile' : [ 0x25c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'DbgRequestFlush' : [ 0x25c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DbgRequestDisableRealtime' : [ 0x25c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'DbgRequestDisconnectConsumer' : [ 0x25c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DbgRequestConnectConsumer' : [ 0x25c, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DbgRequestNotifyConsumer' : [ 0x25c, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'DbgRequestUpdateHeader' : [ 0x25c, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'DbgRequestDeferredFlush' : [ 0x25c, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DbgRequestDeferredFlushTimer' : [ 0x25c, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'DbgRequestFlushTimer' : [ 0x25c, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'DbgRequestUpdateDebugger' : [ 0x25c, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'DbgSpareRequestFlags' : [ 0x25c, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
    'HookIdMap' : [ 0x260, ['_RTL_BITMAP']],
    'StackCache' : [ 0x268, ['pointer', ['_ETW_STACK_CACHE']]],
    'PmcData' : [ 0x26c, ['pointer', ['_ETW_PMC_SUPPORT']]],
    'WinRtProviderBinaryList' : [ 0x270, ['_LIST_ENTRY']],
    'ScratchArray' : [ 0x278, ['pointer', ['pointer', ['_WMI_BUFFER_HEADER']]]],
    'DisallowedGuids' : [ 0x27c, ['_DISALLOWED_GUIDS']],
} ],
  '_ETW_PMC_SUPPORT' : [ 0x24, {
    'Source' : [ 0x0, ['array', -16, ['Enumeration', dict(target = 'long', choices = {0: 'ProfileTime', 1: 'ProfileAlignmentFixup', 2: 'ProfileTotalIssues', 3: 'ProfilePipelineDry', 4: 'ProfileLoadInstructions', 5: 'ProfilePipelineFrozen', 6: 'ProfileBranchInstructions', 7: 'ProfileTotalNonissues', 8: 'ProfileDcacheMisses', 9: 'ProfileIcacheMisses', 10: 'ProfileCacheMisses', 11: 'ProfileBranchMispredictions', 12: 'ProfileStoreInstructions', 13: 'ProfileFpInstructions', 14: 'ProfileIntegerInstructions', 15: 'Profile2Issue', 16: 'Profile3Issue', 17: 'Profile4Issue', 18: 'ProfileSpecialInstructions', 19: 'ProfileTotalCycles', 20: 'ProfileIcacheIssues', 21: 'ProfileDcacheAccesses', 22: 'ProfileMemoryBarrierCycles', 23: 'ProfileLoadLinkedIssues', 24: 'ProfileMaximum'})]]],
    'HookIdCount' : [ 0x10, ['unsigned long']],
    'HookId' : [ 0x14, ['array', 4, ['unsigned short']]],
    'CountersCount' : [ 0x1c, ['unsigned long']],
    'ProcessorCtrs' : [ 0x20, ['array', 1, ['pointer', ['_HAL_PMC_COUNTERS']]]],
} ],
  '_ETW_SILODRIVERSTATE' : [ 0xa80, {
    'EtwpSecurityProviderGuidEntry' : [ 0x0, ['_ETW_GUID_ENTRY']],
    'EtwpLoggerRundown' : [ 0x168, ['array', 64, ['pointer', ['_EX_RUNDOWN_REF_CACHE_AWARE']]]],
    'WmipLoggerContext' : [ 0x268, ['array', 64, ['pointer', ['_WMI_LOGGER_CONTEXT']]]],
    'EtwpGuidHashTable' : [ 0x368, ['array', 64, ['_ETW_HASH_BUCKET']]],
    'EtwpSecurityLoggers' : [ 0xa68, ['array', 8, ['unsigned short']]],
    'EtwpSecurityProviderEnableMask' : [ 0xa78, ['unsigned char']],
    'EtwpShutdownInProgress' : [ 0xa79, ['unsigned char']],
    'EtwpSecurityProviderPID' : [ 0xa7c, ['unsigned long']],
} ],
  '_EX_RUNDOWN_REF_CACHE_AWARE' : [ 0x10, {
    'RunRefs' : [ 0x0, ['pointer', ['_EX_RUNDOWN_REF']]],
    'PoolToFree' : [ 0x4, ['pointer', ['void']]],
    'RunRefSize' : [ 0x8, ['unsigned long']],
    'Number' : [ 0xc, ['unsigned long']],
} ],
  '_ETW_LOGGER_HANDLE' : [ 0x1, {
    'DereferenceAndLeave' : [ 0x0, ['unsigned char']],
} ],
  '_LUID_AND_ATTRIBUTES' : [ 0xc, {
    'Luid' : [ 0x0, ['_LUID']],
    'Attributes' : [ 0x8, ['unsigned long']],
} ],
  '_TOKEN' : [ 0x298, {
    'TokenSource' : [ 0x0, ['_TOKEN_SOURCE']],
    'TokenId' : [ 0x10, ['_LUID']],
    'AuthenticationId' : [ 0x18, ['_LUID']],
    'ParentTokenId' : [ 0x20, ['_LUID']],
    'ExpirationTime' : [ 0x28, ['_LARGE_INTEGER']],
    'TokenLock' : [ 0x30, ['pointer', ['_ERESOURCE']]],
    'ModifiedId' : [ 0x34, ['_LUID']],
    'Privileges' : [ 0x40, ['_SEP_TOKEN_PRIVILEGES']],
    'AuditPolicy' : [ 0x58, ['_SEP_AUDIT_POLICY']],
    'SessionId' : [ 0x78, ['unsigned long']],
    'UserAndGroupCount' : [ 0x7c, ['unsigned long']],
    'RestrictedSidCount' : [ 0x80, ['unsigned long']],
    'VariableLength' : [ 0x84, ['unsigned long']],
    'DynamicCharged' : [ 0x88, ['unsigned long']],
    'DynamicAvailable' : [ 0x8c, ['unsigned long']],
    'DefaultOwnerIndex' : [ 0x90, ['unsigned long']],
    'UserAndGroups' : [ 0x94, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'RestrictedSids' : [ 0x98, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'PrimaryGroup' : [ 0x9c, ['pointer', ['void']]],
    'DynamicPart' : [ 0xa0, ['pointer', ['unsigned long']]],
    'DefaultDacl' : [ 0xa4, ['pointer', ['_ACL']]],
    'TokenType' : [ 0xa8, ['Enumeration', dict(target = 'long', choices = {1: 'TokenPrimary', 2: 'TokenImpersonation'})]],
    'ImpersonationLevel' : [ 0xac, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'TokenFlags' : [ 0xb0, ['unsigned long']],
    'TokenInUse' : [ 0xb4, ['unsigned char']],
    'IntegrityLevelIndex' : [ 0xb8, ['unsigned long']],
    'MandatoryPolicy' : [ 0xbc, ['unsigned long']],
    'LogonSession' : [ 0xc0, ['pointer', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'OriginatingLogonSession' : [ 0xc4, ['_LUID']],
    'SidHash' : [ 0xcc, ['_SID_AND_ATTRIBUTES_HASH']],
    'RestrictedSidHash' : [ 0x154, ['_SID_AND_ATTRIBUTES_HASH']],
    'pSecurityAttributes' : [ 0x1dc, ['pointer', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'Package' : [ 0x1e0, ['pointer', ['void']]],
    'Capabilities' : [ 0x1e4, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'CapabilityCount' : [ 0x1e8, ['unsigned long']],
    'CapabilitiesHash' : [ 0x1ec, ['_SID_AND_ATTRIBUTES_HASH']],
    'LowboxNumberEntry' : [ 0x274, ['pointer', ['_SEP_LOWBOX_NUMBER_ENTRY']]],
    'LowboxHandlesEntry' : [ 0x278, ['pointer', ['_SEP_LOWBOX_HANDLES_ENTRY']]],
    'pClaimAttributes' : [ 0x27c, ['pointer', ['_AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION']]],
    'TrustLevelSid' : [ 0x280, ['pointer', ['void']]],
    'TrustLinkedToken' : [ 0x284, ['pointer', ['_TOKEN']]],
    'IntegrityLevelSidValue' : [ 0x288, ['pointer', ['void']]],
    'TokenSidValues' : [ 0x28c, ['pointer', ['_SEP_SID_VALUES_BLOCK']]],
    'IndexEntry' : [ 0x290, ['pointer', ['_SEP_LUID_TO_INDEX_MAP_ENTRY']]],
    'VariablePart' : [ 0x294, ['unsigned long']],
} ],
  '_SEP_LOGON_SESSION_REFERENCES' : [ 0x64, {
    'Next' : [ 0x0, ['pointer', ['_SEP_LOGON_SESSION_REFERENCES']]],
    'LogonId' : [ 0x4, ['_LUID']],
    'BuddyLogonId' : [ 0xc, ['_LUID']],
    'ReferenceCount' : [ 0x14, ['long']],
    'Flags' : [ 0x18, ['unsigned long']],
    'pDeviceMap' : [ 0x1c, ['pointer', ['_DEVICE_MAP']]],
    'Token' : [ 0x20, ['pointer', ['void']]],
    'AccountName' : [ 0x24, ['_UNICODE_STRING']],
    'AuthorityName' : [ 0x2c, ['_UNICODE_STRING']],
    'LowBoxHandlesTable' : [ 0x34, ['_SEP_LOWBOX_HANDLES_TABLE']],
    'SharedDataLock' : [ 0x3c, ['_EX_PUSH_LOCK']],
    'SharedClaimAttributes' : [ 0x40, ['pointer', ['_AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION']]],
    'SharedSidValues' : [ 0x44, ['pointer', ['_SEP_SID_VALUES_BLOCK']]],
    'RevocationBlock' : [ 0x48, ['_OB_HANDLE_REVOCATION_BLOCK']],
    'ServerSilo' : [ 0x58, ['pointer', ['_EJOB']]],
    'SiblingAuthId' : [ 0x5c, ['_LUID']],
} ],
  '_OBJECT_HEADER' : [ 0x20, {
    'PointerCount' : [ 0x0, ['long']],
    'HandleCount' : [ 0x4, ['long']],
    'NextToFree' : [ 0x4, ['pointer', ['void']]],
    'Lock' : [ 0x8, ['_EX_PUSH_LOCK']],
    'TypeIndex' : [ 0xc, ['unsigned char']],
    'TraceFlags' : [ 0xd, ['unsigned char']],
    'DbgRefTrace' : [ 0xd, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DbgTracePermanent' : [ 0xd, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'InfoMask' : [ 0xe, ['unsigned char']],
    'Flags' : [ 0xf, ['unsigned char']],
    'NewObject' : [ 0xf, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'KernelObject' : [ 0xf, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'KernelOnlyAccess' : [ 0xf, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ExclusiveObject' : [ 0xf, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PermanentObject' : [ 0xf, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'DefaultSecurityQuota' : [ 0xf, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SingleHandleEntry' : [ 0xf, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'DeletedInline' : [ 0xf, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'ObjectCreateInfo' : [ 0x10, ['pointer', ['_OBJECT_CREATE_INFORMATION']]],
    'QuotaBlockCharged' : [ 0x10, ['pointer', ['void']]],
    'SecurityDescriptor' : [ 0x14, ['pointer', ['void']]],
    'Body' : [ 0x18, ['_QUAD']],
} ],
  '_OBJECT_HEADER_QUOTA_INFO' : [ 0x10, {
    'PagedPoolCharge' : [ 0x0, ['unsigned long']],
    'NonPagedPoolCharge' : [ 0x4, ['unsigned long']],
    'SecurityDescriptorCharge' : [ 0x8, ['unsigned long']],
    'SecurityDescriptorQuotaBlock' : [ 0xc, ['pointer', ['void']]],
} ],
  '_OBJECT_HEADER_PROCESS_INFO' : [ 0x8, {
    'ExclusiveProcess' : [ 0x0, ['pointer', ['_EPROCESS']]],
    'Reserved' : [ 0x4, ['unsigned long']],
} ],
  '_OBJECT_HEADER_HANDLE_INFO' : [ 0x8, {
    'HandleCountDataBase' : [ 0x0, ['pointer', ['_OBJECT_HANDLE_COUNT_DATABASE']]],
    'SingleEntry' : [ 0x0, ['_OBJECT_HANDLE_COUNT_ENTRY']],
} ],
  '_OBJECT_HEADER_NAME_INFO' : [ 0x10, {
    'Directory' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY']]],
    'Name' : [ 0x4, ['_UNICODE_STRING']],
    'ReferenceCount' : [ 0xc, ['long']],
} ],
  '_OBJECT_HEADER_CREATOR_INFO' : [ 0x10, {
    'TypeList' : [ 0x0, ['_LIST_ENTRY']],
    'CreatorUniqueProcess' : [ 0x8, ['pointer', ['void']]],
    'CreatorBackTraceIndex' : [ 0xc, ['unsigned short']],
    'Reserved' : [ 0xe, ['unsigned short']],
} ],
  '_OBJECT_HEADER_AUDIT_INFO' : [ 0x8, {
    'SecurityDescriptor' : [ 0x0, ['pointer', ['void']]],
    'Reserved' : [ 0x4, ['unsigned long']],
} ],
  '_OBJECT_HEADER_HANDLE_REVOCATION_INFO' : [ 0x10, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'RevocationBlock' : [ 0x8, ['pointer', ['_OB_HANDLE_REVOCATION_BLOCK']]],
    'Padding1' : [ 0xc, ['array', 4, ['unsigned char']]],
} ],
  '_OBP_LOOKUP_CONTEXT' : [ 0x18, {
    'Directory' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY']]],
    'Object' : [ 0x4, ['pointer', ['void']]],
    'EntryLink' : [ 0x8, ['pointer', ['pointer', ['_OBJECT_DIRECTORY_ENTRY']]]],
    'HashValue' : [ 0xc, ['unsigned long']],
    'HashIndex' : [ 0x10, ['unsigned short']],
    'DirectoryLocked' : [ 0x12, ['unsigned char']],
    'LockedExclusive' : [ 0x13, ['unsigned char']],
    'LockStateSignature' : [ 0x14, ['unsigned long']],
} ],
  '_OBJECT_DIRECTORY' : [ 0xac, {
    'HashBuckets' : [ 0x0, ['array', 37, ['pointer', ['_OBJECT_DIRECTORY_ENTRY']]]],
    'Lock' : [ 0x94, ['_EX_PUSH_LOCK']],
    'DeviceMap' : [ 0x98, ['pointer', ['_DEVICE_MAP']]],
    'ShadowDirectory' : [ 0x9c, ['pointer', ['_OBJECT_DIRECTORY']]],
    'SessionId' : [ 0xa0, ['unsigned long']],
    'NamespaceEntry' : [ 0xa4, ['pointer', ['void']]],
    'Flags' : [ 0xa8, ['unsigned long']],
} ],
  '_OBP_SILODRIVERSTATE' : [ 0x1a4, {
    'SystemDeviceMap' : [ 0x0, ['pointer', ['_DEVICE_MAP']]],
    'SystemDosDeviceState' : [ 0x4, ['_OBP_SYSTEM_DOS_DEVICE_STATE']],
    'DeviceMapLock' : [ 0x70, ['_EX_PUSH_LOCK']],
    'PrivateNamespaceLookupTable' : [ 0x74, ['_OBJECT_NAMESPACE_LOOKUPTABLE']],
} ],
  '_DEVICE_MAP' : [ 0x34, {
    'DosDevicesDirectory' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY']]],
    'GlobalDosDevicesDirectory' : [ 0x4, ['pointer', ['_OBJECT_DIRECTORY']]],
    'DosDevicesDirectoryHandle' : [ 0x8, ['pointer', ['void']]],
    'ReferenceCount' : [ 0xc, ['long']],
    'DriveMap' : [ 0x10, ['unsigned long']],
    'DriveType' : [ 0x14, ['array', 32, ['unsigned char']]],
} ],
  '_WHEAP_INFO_BLOCK' : [ 0xc, {
    'ErrorSourceCount' : [ 0x0, ['unsigned long']],
    'ErrorSourceTable' : [ 0x4, ['pointer', ['_WHEAP_ERROR_SOURCE_TABLE']]],
    'WorkQueue' : [ 0x8, ['pointer', ['_WHEAP_WORK_QUEUE']]],
} ],
  '_WHEAP_ERROR_SOURCE' : [ 0x418, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'FailedAllocations' : [ 0x8, ['unsigned long']],
    'PlatformErrorSourceId' : [ 0xc, ['unsigned long']],
    'ErrorCount' : [ 0x10, ['long']],
    'RecordCount' : [ 0x14, ['unsigned long']],
    'RecordLength' : [ 0x18, ['unsigned long']],
    'PoolTag' : [ 0x1c, ['unsigned long']],
    'Type' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSrcTypeMCE', 1: 'WheaErrSrcTypeCMC', 2: 'WheaErrSrcTypeCPE', 3: 'WheaErrSrcTypeNMI', 4: 'WheaErrSrcTypePCIe', 5: 'WheaErrSrcTypeGeneric', 6: 'WheaErrSrcTypeINIT', 7: 'WheaErrSrcTypeBOOT', 8: 'WheaErrSrcTypeSCIGeneric', 9: 'WheaErrSrcTypeIPFMCA', 10: 'WheaErrSrcTypeIPFCMC', 11: 'WheaErrSrcTypeIPFCPE', 12: 'WheaErrSrcTypeMax'})]],
    'Records' : [ 0x24, ['pointer', ['_WHEAP_ERROR_RECORD_WRAPPER']]],
    'Context' : [ 0x28, ['pointer', ['void']]],
    'SectionCount' : [ 0x2c, ['unsigned long']],
    'SectionLength' : [ 0x30, ['unsigned long']],
    'TickCountAtLastError' : [ 0x38, ['_LARGE_INTEGER']],
    'AccumulatedErrors' : [ 0x40, ['unsigned long']],
    'TotalErrors' : [ 0x44, ['unsigned long']],
    'Deferred' : [ 0x48, ['unsigned char']],
    'Descriptor' : [ 0x49, ['_WHEA_ERROR_SOURCE_DESCRIPTOR']],
} ],
  '_WHEAP_ERROR_RECORD_WRAPPER' : [ 0xe4, {
    'WorkEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Length' : [ 0x8, ['unsigned long']],
    'ProcessorNumber' : [ 0xc, ['unsigned long']],
    'Flags' : [ 0x10, ['_WHEAP_ERROR_RECORD_WRAPPER_FLAGS']],
    'InUse' : [ 0x14, ['long']],
    'ErrorSource' : [ 0x18, ['pointer', ['_WHEAP_ERROR_SOURCE']]],
    'ErrorRecord' : [ 0x1c, ['_WHEA_ERROR_RECORD']],
} ],
  '_KSECONDARY_IDT_ENTRY' : [ 0x1c, {
    'SpinLock' : [ 0x0, ['unsigned long']],
    'ConnectLock' : [ 0x4, ['_KEVENT']],
    'LineMasked' : [ 0x14, ['unsigned char']],
    'InterruptList' : [ 0x18, ['pointer', ['_KINTERRUPT']]],
} ],
  '_WNF_STATE_NAME' : [ 0x8, {
    'Data' : [ 0x0, ['array', 2, ['unsigned long']]],
} ],
  '_PS_CLIENT_SECURITY_CONTEXT' : [ 0x4, {
    'ImpersonationData' : [ 0x0, ['unsigned long']],
    'ImpersonationToken' : [ 0x0, ['pointer', ['void']]],
    'ImpersonationLevel' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'EffectiveOnly' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
} ],
  '_DBGKD_ANY_CONTROL_SET' : [ 0x1c, {
    'X86ControlSet' : [ 0x0, ['_X86_DBGKD_CONTROL_SET']],
    'AlphaControlSet' : [ 0x0, ['unsigned long']],
    'IA64ControlSet' : [ 0x0, ['_IA64_DBGKD_CONTROL_SET']],
    'Amd64ControlSet' : [ 0x0, ['_AMD64_DBGKD_CONTROL_SET']],
    'ArmControlSet' : [ 0x0, ['_ARM_DBGKD_CONTROL_SET']],
    'Arm64ControlSet' : [ 0x0, ['_ARM64_DBGKD_CONTROL_SET']],
    'ArmCeControlSet' : [ 0x0, ['_ARMCE_DBGKD_CONTROL_SET']],
    'PpcControlSet' : [ 0x0, ['_PPC_DBGKD_CONTROL_SET']],
} ],
  '_MI_VERIFIER_POOL_HEADER' : [ 0x4, {
    'VerifierPoolEntry' : [ 0x0, ['pointer', ['_VI_POOL_ENTRY']]],
} ],
  '_POP_FX_PLUGIN' : [ 0x70, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Version' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0x10, ['unsigned long long']],
    'WorkQueue' : [ 0x18, ['_KQUEUE']],
    'AcceptDeviceNotification' : [ 0x40, ['pointer', ['void']]],
    'AcceptProcessorNotification' : [ 0x44, ['pointer', ['void']]],
    'AcceptAcpiNotification' : [ 0x48, ['pointer', ['void']]],
    'WorkOrderCount' : [ 0x4c, ['unsigned long']],
    'WorkOrders' : [ 0x50, ['array', 1, ['_POP_FX_WORK_ORDER']]],
} ],
  '_ARM_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_LPCP_MESSAGE' : [ 0x30, {
    'Entry' : [ 0x0, ['_LIST_ENTRY']],
    'FreeEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Reserved0' : [ 0x4, ['unsigned long']],
    'SenderPort' : [ 0x8, ['pointer', ['void']]],
    'RepliedToThread' : [ 0xc, ['pointer', ['_ETHREAD']]],
    'PortContext' : [ 0x10, ['pointer', ['void']]],
    'Request' : [ 0x18, ['_PORT_MESSAGE']],
} ],
  '_HARDWARE_PTE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Dirty' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'LargePage' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Global' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'reserved0' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 38, native_type='unsigned long long')]],
    'reserved1' : [ 0x0, ['BitField', dict(start_bit = 38, end_bit = 64, native_type='unsigned long long')]],
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
} ],
  '_ALPC_PORT_ATTRIBUTES' : [ 0x2c, {
    'Flags' : [ 0x0, ['unsigned long']],
    'SecurityQos' : [ 0x4, ['_SECURITY_QUALITY_OF_SERVICE']],
    'MaxMessageLength' : [ 0x10, ['unsigned long']],
    'MemoryBandwidth' : [ 0x14, ['unsigned long']],
    'MaxPoolUsage' : [ 0x18, ['unsigned long']],
    'MaxSectionSize' : [ 0x1c, ['unsigned long']],
    'MaxViewSize' : [ 0x20, ['unsigned long']],
    'MaxTotalSectionSize' : [ 0x24, ['unsigned long']],
    'DupObjectTypes' : [ 0x28, ['unsigned long']],
} ],
  '_MI_PARTITION_SEGMENTS' : [ 0x100, {
    'DeleteSubsectionCleanup' : [ 0x0, ['_KEVENT']],
    'UnusedSegmentCleanup' : [ 0x10, ['_KEVENT']],
    'SubsectionDeletePtes' : [ 0x20, ['unsigned long']],
    'DereferenceSegmentHeader' : [ 0x24, ['_MMDEREFERENCE_SEGMENT_HEADER']],
    'DeleteOnCloseList' : [ 0x40, ['_LIST_ENTRY']],
    'DeleteOnCloseTimer' : [ 0x48, ['_KTIMER']],
    'DeleteOnCloseTimerActive' : [ 0x70, ['unsigned char']],
    'DeleteOnCloseCount' : [ 0x74, ['unsigned long']],
    'UnusedSegmentList' : [ 0x78, ['_LIST_ENTRY']],
    'UnusedSubsectionList' : [ 0x80, ['_LIST_ENTRY']],
    'DeleteSubsectionList' : [ 0x88, ['_LIST_ENTRY']],
    'ControlAreaDeleteEvent' : [ 0x90, ['_KEVENT']],
    'ControlAreaDeleteList' : [ 0xa0, ['_SINGLE_LIST_ENTRY']],
    'SegmentListLock' : [ 0xc0, ['long']],
} ],
  '_KSTACK_COUNT' : [ 0x4, {
    'Value' : [ 0x0, ['long']],
    'State' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'StackCount' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_TYPE' : [ 0x4, {
    'Version' : [ 0x0, ['unsigned char']],
    'DataCount' : [ 0x1, ['unsigned char']],
    'SemanticType' : [ 0x2, ['unsigned char']],
    'AccessRights' : [ 0x3, ['_PS_TRUSTLET_ATTRIBUTE_ACCESSRIGHTS']],
    'AttributeType' : [ 0x0, ['unsigned long']],
} ],
  '_KENTROPY_TIMING_STATE' : [ 0x128, {
    'EntropyCount' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x4, ['array', 64, ['unsigned long']]],
    'Dpc' : [ 0x104, ['_KDPC']],
    'LastDeliveredBuffer' : [ 0x124, ['unsigned long']],
} ],
  '_HEAP_UNPACKED_ENTRY' : [ 0x8, {
    'Size' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned char']],
    'SmallTagIndex' : [ 0x3, ['unsigned char']],
    'SubSegmentCode' : [ 0x0, ['unsigned long']],
    'PreviousSize' : [ 0x4, ['unsigned short']],
    'SegmentOffset' : [ 0x6, ['unsigned char']],
    'LFHFlags' : [ 0x6, ['unsigned char']],
    'UnusedBytes' : [ 0x7, ['unsigned char']],
} ],
  '_PEP_ACPI_SPB_RESOURCE' : [ 0x18, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PepAcpiMemory', 1: 'PepAcpiIoPort', 2: 'PepAcpiInterrupt', 3: 'PepAcpiGpioIo', 4: 'PepAcpiGpioInt', 5: 'PepAcpiSpbI2c', 6: 'PepAcpiSpbSpi', 7: 'PepAcpiSpbUart', 8: 'PepAcpiExtendedMemory', 9: 'PepAcpiExtendedIo'})]],
    'Flags' : [ 0x4, ['_PEP_ACPI_RESOURCE_FLAGS']],
    'TypeSpecificFlags' : [ 0x8, ['unsigned short']],
    'ResourceSourceIndex' : [ 0xa, ['unsigned char']],
    'ResourceSourceName' : [ 0xc, ['pointer', ['_UNICODE_STRING']]],
    'VendorData' : [ 0x10, ['pointer', ['unsigned char']]],
    'VendorDataLength' : [ 0x14, ['unsigned short']],
} ],
  '_DISPATCHER_HEADER' : [ 0x10, {
    'Lock' : [ 0x0, ['long']],
    'LockNV' : [ 0x0, ['long']],
    'Type' : [ 0x0, ['unsigned char']],
    'Signalling' : [ 0x1, ['unsigned char']],
    'Size' : [ 0x2, ['unsigned char']],
    'Reserved1' : [ 0x3, ['unsigned char']],
    'TimerType' : [ 0x0, ['unsigned char']],
    'TimerControlFlags' : [ 0x1, ['unsigned char']],
    'Absolute' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Wake' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'EncodedTolerableDelay' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'Hand' : [ 0x2, ['unsigned char']],
    'TimerMiscFlags' : [ 0x3, ['unsigned char']],
    'Index' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Processor' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 6, native_type='unsigned char')]],
    'Inserted' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Expired' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Timer2Type' : [ 0x0, ['unsigned char']],
    'Timer2Flags' : [ 0x1, ['unsigned char']],
    'Timer2Inserted' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Timer2Expiring' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Timer2CancelPending' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Timer2SetPending' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Timer2Running' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Timer2Disabled' : [ 0x1, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Timer2ReservedFlags' : [ 0x1, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Timer2Reserved1' : [ 0x2, ['unsigned char']],
    'Timer2Reserved2' : [ 0x3, ['unsigned char']],
    'QueueType' : [ 0x0, ['unsigned char']],
    'QueueControlFlags' : [ 0x1, ['unsigned char']],
    'Abandoned' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DisableIncrement' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'QueueReservedControlFlags' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'QueueSize' : [ 0x2, ['unsigned char']],
    'QueueReserved' : [ 0x3, ['unsigned char']],
    'ThreadType' : [ 0x0, ['unsigned char']],
    'ThreadReserved' : [ 0x1, ['unsigned char']],
    'ThreadControlFlags' : [ 0x2, ['unsigned char']],
    'CycleProfiling' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'CounterProfiling' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'GroupScheduling' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'AffinitySet' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Tagged' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'EnergyProfiling' : [ 0x2, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Instrumented' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ThreadReservedControlFlags' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'DebugActive' : [ 0x3, ['unsigned char']],
    'MutantType' : [ 0x0, ['unsigned char']],
    'MutantSize' : [ 0x1, ['unsigned char']],
    'DpcActive' : [ 0x2, ['unsigned char']],
    'MutantReserved' : [ 0x3, ['unsigned char']],
    'SignalState' : [ 0x4, ['long']],
    'WaitListHead' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_ETW_GUID_ENTRY' : [ 0x168, {
    'GuidList' : [ 0x0, ['_LIST_ENTRY']],
    'RefCount' : [ 0x8, ['long']],
    'Guid' : [ 0xc, ['_GUID']],
    'RegListHead' : [ 0x1c, ['_LIST_ENTRY']],
    'SecurityDescriptor' : [ 0x24, ['pointer', ['void']]],
    'LastEnable' : [ 0x28, ['_ETW_LAST_ENABLE_INFO']],
    'MatchId' : [ 0x28, ['unsigned long long']],
    'ProviderEnableInfo' : [ 0x38, ['_TRACE_ENABLE_INFO']],
    'EnableInfo' : [ 0x58, ['array', 8, ['_TRACE_ENABLE_INFO']]],
    'FilterData' : [ 0x158, ['pointer', ['_ETW_FILTER_HEADER']]],
    'HostSilo' : [ 0x15c, ['unsigned char']],
    'Lock' : [ 0x160, ['_EX_PUSH_LOCK']],
    'LockOwner' : [ 0x164, ['pointer', ['_ETHREAD']]],
} ],
  '_VI_POOL_ENTRY' : [ 0x10, {
    'PageHeader' : [ 0x0, ['_VI_POOL_PAGE_HEADER']],
    'InUse' : [ 0x0, ['_VI_POOL_ENTRY_INUSE']],
    'NextFree' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_MM_PAGE_ACCESS_INFO' : [ 0x8, {
    'Flags' : [ 0x0, ['_MM_PAGE_ACCESS_INFO_FLAGS']],
    'FileOffset' : [ 0x0, ['unsigned long long']],
    'VirtualAddress' : [ 0x0, ['pointer', ['void']]],
    'DontUse0' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'PointerProtoPte' : [ 0x4, ['pointer', ['void']]],
} ],
  '_MI_CONTROL_AREA_WAIT_BLOCK' : [ 0x1c, {
    'Next' : [ 0x0, ['pointer', ['_MI_CONTROL_AREA_WAIT_BLOCK']]],
    'WaitReason' : [ 0x4, ['unsigned long']],
    'WaitResponse' : [ 0x8, ['unsigned long']],
    'Gate' : [ 0xc, ['_KGATE']],
} ],
  '_HEAP_COUNTERS' : [ 0x5c, {
    'TotalMemoryReserved' : [ 0x0, ['unsigned long']],
    'TotalMemoryCommitted' : [ 0x4, ['unsigned long']],
    'TotalMemoryLargeUCR' : [ 0x8, ['unsigned long']],
    'TotalSizeInVirtualBlocks' : [ 0xc, ['unsigned long']],
    'TotalSegments' : [ 0x10, ['unsigned long']],
    'TotalUCRs' : [ 0x14, ['unsigned long']],
    'CommittOps' : [ 0x18, ['unsigned long']],
    'DeCommitOps' : [ 0x1c, ['unsigned long']],
    'LockAcquires' : [ 0x20, ['unsigned long']],
    'LockCollisions' : [ 0x24, ['unsigned long']],
    'CommitRate' : [ 0x28, ['unsigned long']],
    'DecommittRate' : [ 0x2c, ['unsigned long']],
    'CommitFailures' : [ 0x30, ['unsigned long']],
    'InBlockCommitFailures' : [ 0x34, ['unsigned long']],
    'PollIntervalCounter' : [ 0x38, ['unsigned long']],
    'DecommitsSinceLastCheck' : [ 0x3c, ['unsigned long']],
    'HeapPollInterval' : [ 0x40, ['unsigned long']],
    'AllocAndFreeOps' : [ 0x44, ['unsigned long']],
    'AllocationIndicesActive' : [ 0x48, ['unsigned long']],
    'InBlockDeccommits' : [ 0x4c, ['unsigned long']],
    'InBlockDeccomitSize' : [ 0x50, ['unsigned long']],
    'HighWatermarkSize' : [ 0x54, ['unsigned long']],
    'LastPolledSize' : [ 0x58, ['unsigned long']],
} ],
  '_TraceLoggingMetadata_t' : [ 0x10, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned short']],
    'Version' : [ 0x6, ['unsigned char']],
    'Flags' : [ 0x7, ['unsigned char']],
    'Magic' : [ 0x8, ['unsigned long long']],
} ],
  '_MI_VISIBLE_PARTITION' : [ 0xb80, {
    'LowestPhysicalPage' : [ 0x0, ['unsigned long']],
    'HighestPhysicalPage' : [ 0x4, ['unsigned long']],
    'NumberOfPhysicalPages' : [ 0x8, ['unsigned long']],
    'NumberOfPagingFiles' : [ 0xc, ['unsigned long']],
    'PagingFile' : [ 0x10, ['array', 16, ['pointer', ['_MMPAGING_FILE']]]],
    'AvailablePages' : [ 0x80, ['unsigned long']],
    'ResidentAvailablePages' : [ 0xc0, ['unsigned long']],
    'TotalCommittedPages' : [ 0xc4, ['unsigned long']],
    'ModifiedPageListHead' : [ 0x100, ['_MMPFNLIST']],
    'ModifiedNoWritePageListHead' : [ 0x140, ['_MMPFNLIST']],
    'TotalCommitLimit' : [ 0x154, ['unsigned long']],
    'TotalPagesForPagingFile' : [ 0x158, ['unsigned long']],
    'VadPhysicalPages' : [ 0x15c, ['unsigned long']],
    'ProcessLockedFilePages' : [ 0x160, ['unsigned long']],
    'ChargeCommitmentFailures' : [ 0x164, ['array', 4, ['unsigned long']]],
    'PageFileTraceIndex' : [ 0x174, ['long']],
    'PageFileTraces' : [ 0x178, ['array', 32, ['_MI_PAGEFILE_TRACES']]],
} ],
  '_OB_HANDLE_REVOCATION_BLOCK' : [ 0x10, {
    'RevocationInfos' : [ 0x0, ['_LIST_ENTRY']],
    'Lock' : [ 0x8, ['_EX_PUSH_LOCK']],
    'Rundown' : [ 0xc, ['_EX_RUNDOWN_REF']],
} ],
  '_SYSPTES_HEADER' : [ 0x8c, {
    'ListHead' : [ 0x0, ['array', 16, ['_LIST_ENTRY']]],
    'Count' : [ 0x80, ['unsigned long']],
    'NumberOfEntries' : [ 0x84, ['unsigned long']],
    'NumberOfEntriesPeak' : [ 0x88, ['unsigned long']],
} ],
  '_EXCEPTION_RECORD' : [ 0x50, {
    'ExceptionCode' : [ 0x0, ['long']],
    'ExceptionFlags' : [ 0x4, ['unsigned long']],
    'ExceptionRecord' : [ 0x8, ['pointer', ['_EXCEPTION_RECORD']]],
    'ExceptionAddress' : [ 0xc, ['pointer', ['void']]],
    'NumberParameters' : [ 0x10, ['unsigned long']],
    'ExceptionInformation' : [ 0x14, ['array', 15, ['unsigned long']]],
} ],
  '_MI_ACTIVE_WSLE_LISTHEAD' : [ 0x8, {
    'Flink' : [ 0x0, ['unsigned long']],
    'Blink' : [ 0x4, ['unsigned long']],
} ],
  '_PENDING_RELATIONS_LIST_ENTRY' : [ 0x44, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'WorkItem' : [ 0x8, ['_WORK_QUEUE_ITEM']],
    'DeviceEvent' : [ 0x18, ['pointer', ['_PNP_DEVICE_EVENT_ENTRY']]],
    'DeviceObject' : [ 0x1c, ['pointer', ['_DEVICE_OBJECT']]],
    'RelationsList' : [ 0x20, ['pointer', ['_RELATION_LIST']]],
    'EjectIrp' : [ 0x24, ['pointer', ['_IRP']]],
    'Lock' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'IRPLOCK_CANCELABLE', 1: 'IRPLOCK_CANCEL_STARTED', 2: 'IRPLOCK_CANCEL_COMPLETE', 3: 'IRPLOCK_COMPLETED'})]],
    'Problem' : [ 0x2c, ['unsigned long']],
    'ProfileChangingEject' : [ 0x30, ['unsigned char']],
    'DisplaySafeRemovalDialog' : [ 0x31, ['unsigned char']],
    'LightestSleepState' : [ 0x34, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DockInterface' : [ 0x38, ['pointer', ['DOCK_INTERFACE']]],
    'DequeuePending' : [ 0x3c, ['unsigned char']],
    'DeleteType' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: 'QueryRemoveDevice', 1: 'CancelRemoveDevice', 2: 'RemoveDevice', 3: 'SurpriseRemoveDevice', 4: 'EjectDevice', 5: 'RemoveFailedDevice', 6: 'RemoveUnstartedFailedDevice', 7: 'MaxDeviceDeleteType'})]],
} ],
  '_PPM_PLATFORM_STATE' : [ 0xc0, {
    'Latency' : [ 0x0, ['unsigned long']],
    'BreakEvenDuration' : [ 0x4, ['unsigned long']],
    'VetoAccounting' : [ 0x8, ['_PPM_VETO_ACCOUNTING']],
    'TransitionDebugger' : [ 0x20, ['unsigned char']],
    'Platform' : [ 0x21, ['unsigned char']],
    'DependencyListCount' : [ 0x24, ['unsigned long']],
    'Processors' : [ 0x28, ['_KAFFINITY_EX']],
    'Name' : [ 0x34, ['_UNICODE_STRING']],
    'DependencyLists' : [ 0x3c, ['pointer', ['_PPM_SELECTION_DEPENDENCY']]],
    'Synchronization' : [ 0x40, ['_PPM_COORDINATED_SYNCHRONIZATION']],
    'EnterTime' : [ 0x48, ['unsigned long long']],
    'RefCount' : [ 0x80, ['long']],
    'CacheAlign0' : [ 0x80, ['array', 64, ['unsigned char']]],
} ],
  '_MI_SECTION_IMAGE_INFORMATION' : [ 0x38, {
    'ExportedImageInformation' : [ 0x0, ['_SECTION_IMAGE_INFORMATION']],
    'InternalImageInformation' : [ 0x30, ['_MI_EXTRA_IMAGE_INFORMATION']],
} ],
  '_TOKEN_ACCESS_INFORMATION' : [ 0x38, {
    'SidHash' : [ 0x0, ['pointer', ['_SID_AND_ATTRIBUTES_HASH']]],
    'RestrictedSidHash' : [ 0x4, ['pointer', ['_SID_AND_ATTRIBUTES_HASH']]],
    'Privileges' : [ 0x8, ['pointer', ['_TOKEN_PRIVILEGES']]],
    'AuthenticationId' : [ 0xc, ['_LUID']],
    'TokenType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {1: 'TokenPrimary', 2: 'TokenImpersonation'})]],
    'ImpersonationLevel' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'MandatoryPolicy' : [ 0x1c, ['_TOKEN_MANDATORY_POLICY']],
    'Flags' : [ 0x20, ['unsigned long']],
    'AppContainerNumber' : [ 0x24, ['unsigned long']],
    'PackageSid' : [ 0x28, ['pointer', ['void']]],
    'CapabilitiesHash' : [ 0x2c, ['pointer', ['_SID_AND_ATTRIBUTES_HASH']]],
    'TrustLevelSid' : [ 0x30, ['pointer', ['void']]],
    'SecurityAttributes' : [ 0x34, ['pointer', ['void']]],
} ],
  '_CELL_DATA' : [ 0x50, {
    'u' : [ 0x0, ['_u']],
} ],
  '_INITIAL_PRIVILEGE_SET' : [ 0x2c, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Control' : [ 0x4, ['unsigned long']],
    'Privilege' : [ 0x8, ['array', 3, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_HEAP_TUNING_PARAMETERS' : [ 0x8, {
    'CommittThresholdShift' : [ 0x0, ['unsigned long']],
    'MaxPreCommittThreshold' : [ 0x4, ['unsigned long']],
} ],
  '_MMWSLE_NONDIRECT_HASH' : [ 0x8, {
    'Key' : [ 0x0, ['pointer', ['void']]],
    'Index' : [ 0x4, ['unsigned long']],
} ],
  '_POP_FX_WORK_ORDER' : [ 0x1c, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'WorkCount' : [ 0x10, ['long']],
    'Context' : [ 0x14, ['pointer', ['void']]],
    'WatchdogTimerInfo' : [ 0x18, ['pointer', ['_POP_FX_WORK_ORDER_WATCHDOG_INFO']]],
} ],
  '_SEGMENT_FLAGS' : [ 0x4, {
    'TotalNumberOfPtes4132' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned short')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned short')]],
    'LargePages' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned short')]],
    'DebugSymbolsLoaded' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned short')]],
    'WriteCombined' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned short')]],
    'NoCache' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned short')]],
    'Short0' : [ 0x0, ['unsigned short']],
    'FloppyMedia' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DefaultProtectionMask' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 6, native_type='unsigned char')]],
    'Binary32' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ContainsDebug' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'UChar1' : [ 0x2, ['unsigned char']],
    'ForceCollision' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ImageSigningType' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 4, native_type='unsigned char')]],
    'ImageSigningLevel' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'UChar2' : [ 0x3, ['unsigned char']],
} ],
  '_KTIMER_EXPIRATION_TRACE' : [ 0x10, {
    'InterruptTime' : [ 0x0, ['unsigned long long']],
    'PerformanceCounter' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '_POOL_TRACKER_BIG_PAGES' : [ 0x10, {
    'Va' : [ 0x0, ['unsigned long']],
    'Key' : [ 0x4, ['unsigned long']],
    'Pattern' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'PoolType' : [ 0x8, ['BitField', dict(start_bit = 8, end_bit = 20, native_type='unsigned long')]],
    'SlushSize' : [ 0x8, ['BitField', dict(start_bit = 20, end_bit = 32, native_type='unsigned long')]],
    'NumberOfBytes' : [ 0xc, ['unsigned long']],
} ],
  'tagSWITCH_CONTEXT_DATA' : [ 0x50, {
    'ullOsMaxVersionTested' : [ 0x0, ['unsigned long long']],
    'ulTargetPlatform' : [ 0x8, ['unsigned long']],
    'ullContextMinimum' : [ 0x10, ['unsigned long long']],
    'guPlatform' : [ 0x18, ['_GUID']],
    'guMinPlatform' : [ 0x28, ['_GUID']],
    'ulContextSource' : [ 0x38, ['unsigned long']],
    'ulElementCount' : [ 0x3c, ['unsigned long']],
    'guElements' : [ 0x40, ['array', 1, ['_GUID']]],
} ],
  '_WHEAP_ERROR_SOURCE_TABLE' : [ 0x20, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Count' : [ 0x4, ['long']],
    'Items' : [ 0x8, ['_LIST_ENTRY']],
    'InsertLock' : [ 0x10, ['_KEVENT']],
} ],
  '_ETW_HASH_BUCKET' : [ 0x1c, {
    'ListHead' : [ 0x0, ['array', 3, ['_LIST_ENTRY']]],
    'BucketLock' : [ 0x18, ['_EX_PUSH_LOCK']],
} ],
  '_TEB_ACTIVE_FRAME' : [ 0xc, {
    'Flags' : [ 0x0, ['unsigned long']],
    'Previous' : [ 0x4, ['pointer', ['_TEB_ACTIVE_FRAME']]],
    'Context' : [ 0x8, ['pointer', ['_TEB_ACTIVE_FRAME_CONTEXT']]],
} ],
  '_FILE_GET_QUOTA_INFORMATION' : [ 0x14, {
    'NextEntryOffset' : [ 0x0, ['unsigned long']],
    'SidLength' : [ 0x4, ['unsigned long']],
    'Sid' : [ 0x8, ['_SID']],
} ],
  '_ACCESS_REASONS' : [ 0x80, {
    'Data' : [ 0x0, ['array', 32, ['unsigned long']]],
} ],
  '_CM_KEY_BODY' : [ 0x2c, {
    'Type' : [ 0x0, ['unsigned long']],
    'KeyControlBlock' : [ 0x4, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'NotifyBlock' : [ 0x8, ['pointer', ['_CM_NOTIFY_BLOCK']]],
    'ProcessID' : [ 0xc, ['pointer', ['void']]],
    'KeyBodyList' : [ 0x10, ['_LIST_ENTRY']],
    'Flags' : [ 0x18, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'HandleTags' : [ 0x18, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'KtmTrans' : [ 0x1c, ['pointer', ['void']]],
    'KtmUow' : [ 0x20, ['pointer', ['_GUID']]],
    'ContextListHead' : [ 0x24, ['_LIST_ENTRY']],
} ],
  '_KWAIT_BLOCK' : [ 0x18, {
    'WaitListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'WaitType' : [ 0x8, ['unsigned char']],
    'BlockState' : [ 0x9, ['unsigned char']],
    'WaitKey' : [ 0xa, ['unsigned short']],
    'Thread' : [ 0xc, ['pointer', ['_KTHREAD']]],
    'NotificationQueue' : [ 0xc, ['pointer', ['_KQUEUE']]],
    'Object' : [ 0x10, ['pointer', ['void']]],
    'SparePtr' : [ 0x14, ['pointer', ['void']]],
} ],
  '_ARM64_DBGKD_CONTROL_SET' : [ 0x18, {
    'Continue' : [ 0x0, ['unsigned long']],
    'TraceFlag' : [ 0x4, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x8, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0x10, ['unsigned long long']],
} ],
  '_MMPTE_PROTOTYPE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'DemandFillProto' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'HiberVerifyConverted' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Unused1' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned long long')]],
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'Combined' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 16, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long long')]],
    'ProtoAddress' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_WHEA_ERROR_PACKET_FLAGS' : [ 0x4, {
    'PreviousError' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HypervisorError' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Simulated' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'PlatformPfaControl' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PlatformDirectedOffline' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_THERMAL_INFORMATION_EX' : [ 0x58, {
    'ThermalStamp' : [ 0x0, ['unsigned long']],
    'ThermalConstant1' : [ 0x4, ['unsigned long']],
    'ThermalConstant2' : [ 0x8, ['unsigned long']],
    'SamplingPeriod' : [ 0xc, ['unsigned long']],
    'CurrentTemperature' : [ 0x10, ['unsigned long']],
    'PassiveTripPoint' : [ 0x14, ['unsigned long']],
    'ThermalStandbyTripPoint' : [ 0x18, ['unsigned long']],
    'CriticalTripPoint' : [ 0x1c, ['unsigned long']],
    'ActiveTripPointCount' : [ 0x20, ['unsigned char']],
    'ActiveTripPoint' : [ 0x24, ['array', 10, ['unsigned long']]],
    'S4TransitionTripPoint' : [ 0x4c, ['unsigned long']],
    'MinimumThrottle' : [ 0x50, ['unsigned long']],
    'OverThrottleThreshold' : [ 0x54, ['unsigned long']],
} ],
  '__unnamed_1ea3' : [ 0x4, {
    'FilePointerIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'HardFault' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Image' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
} ],
  '__unnamed_1ea5' : [ 0x4, {
    'FilePointerIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 9, native_type='unsigned long')]],
    'HardFault' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Spare1' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
} ],
  '_MM_PAGE_ACCESS_INFO_FLAGS' : [ 0x4, {
    'File' : [ 0x0, ['__unnamed_1ea3']],
    'Private' : [ 0x0, ['__unnamed_1ea5']],
} ],
  '_KTIMER2' : [ 0x58, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'RbNodes' : [ 0x10, ['array', 2, ['_RTL_BALANCED_NODE']]],
    'ListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'DueTime' : [ 0x28, ['array', 2, ['unsigned long long']]],
    'Period' : [ 0x38, ['long long']],
    'Callback' : [ 0x40, ['pointer', ['void']]],
    'CallbackContext' : [ 0x44, ['pointer', ['void']]],
    'DisableCallback' : [ 0x48, ['pointer', ['void']]],
    'DisableContext' : [ 0x4c, ['pointer', ['void']]],
    'AbsoluteSystemTime' : [ 0x50, ['unsigned char']],
    'TypeFlags' : [ 0x51, ['unsigned char']],
    'Unused' : [ 0x51, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IdleResilient' : [ 0x51, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'HighResolution' : [ 0x51, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'NoWake' : [ 0x51, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Unused1' : [ 0x51, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'CollectionIndex' : [ 0x52, ['array', 2, ['unsigned char']]],
} ],
  '_VI_VERIFIER_ISSUE' : [ 0x10, {
    'IssueType' : [ 0x0, ['unsigned long']],
    'Address' : [ 0x4, ['pointer', ['void']]],
    'Parameters' : [ 0x8, ['array', 2, ['unsigned long']]],
} ],
  '_MMSUBSECTION_FLAGS' : [ 0x4, {
    'SubsectionAccessed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 6, native_type='unsigned short')]],
    'StartingSector4132' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 16, native_type='unsigned short')]],
    'SubsectionStatic' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'GlobalMemory' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'SubsectionMappedDirect' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'OnDereferenceList' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'SectorEndOffset' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 16, native_type='unsigned short')]],
} ],
  '_EXCEPTION_POINTERS' : [ 0x8, {
    'ExceptionRecord' : [ 0x0, ['pointer', ['_EXCEPTION_RECORD']]],
    'ContextRecord' : [ 0x4, ['pointer', ['_CONTEXT']]],
} ],
  '_KMUTANT' : [ 0x20, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'MutantListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'OwnerThread' : [ 0x18, ['pointer', ['_KTHREAD']]],
    'Abandoned' : [ 0x1c, ['unsigned char']],
    'ApcDisable' : [ 0x1d, ['unsigned char']],
} ],
  '_OBJECT_REF_INFO' : [ 0x1c, {
    'ObjectHeader' : [ 0x0, ['pointer', ['_OBJECT_HEADER']]],
    'NextRef' : [ 0x4, ['pointer', ['void']]],
    'ImageFileName' : [ 0x8, ['array', 16, ['unsigned char']]],
    'NextPos' : [ 0x18, ['unsigned short']],
    'MaxStacks' : [ 0x1a, ['unsigned short']],
    'StackInfo' : [ 0x1c, ['array', 0, ['_OBJECT_REF_STACK_INFO']]],
} ],
  '_HBIN' : [ 0x20, {
    'Signature' : [ 0x0, ['unsigned long']],
    'FileOffset' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
    'Reserved1' : [ 0xc, ['array', 2, ['unsigned long']]],
    'TimeStamp' : [ 0x14, ['_LARGE_INTEGER']],
    'Spare' : [ 0x1c, ['unsigned long']],
} ],
  '_MI_IMAGE_SECURITY_REFERENCE' : [ 0xc, {
    'DynamicRelocations' : [ 0x0, ['pointer', ['void']]],
    'SecurityContext' : [ 0x4, ['_IMAGE_SECURITY_CONTEXT']],
    'StrongImageReference' : [ 0x8, ['unsigned long']],
} ],
  '_AUTHZBASEP_CLAIM_ATTRIBUTES_COLLECTION' : [ 0x130, {
    'DeviceGroupsCount' : [ 0x0, ['unsigned long']],
    'pDeviceGroups' : [ 0x4, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'RestrictedDeviceGroupsCount' : [ 0x8, ['unsigned long']],
    'pRestrictedDeviceGroups' : [ 0xc, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'DeviceGroupsHash' : [ 0x10, ['_SID_AND_ATTRIBUTES_HASH']],
    'RestrictedDeviceGroupsHash' : [ 0x98, ['_SID_AND_ATTRIBUTES_HASH']],
    'pUserSecurityAttributes' : [ 0x120, ['pointer', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'pDeviceSecurityAttributes' : [ 0x124, ['pointer', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'pRestrictedUserSecurityAttributes' : [ 0x128, ['pointer', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
    'pRestrictedDeviceSecurityAttributes' : [ 0x12c, ['pointer', ['_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION']]],
} ],
  '_HEAP_TAG_ENTRY' : [ 0x40, {
    'Allocs' : [ 0x0, ['unsigned long']],
    'Frees' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
    'TagIndex' : [ 0xc, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0xe, ['unsigned short']],
    'TagName' : [ 0x10, ['array', 24, ['wchar']]],
} ],
  '_MMPTE_HIGHLOW' : [ 0x8, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'HighPart' : [ 0x4, ['unsigned long']],
} ],
  '_SECURITY_QUALITY_OF_SERVICE' : [ 0xc, {
    'Length' : [ 0x0, ['unsigned long']],
    'ImpersonationLevel' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'ContextTrackingMode' : [ 0x8, ['unsigned char']],
    'EffectiveOnly' : [ 0x9, ['unsigned char']],
} ],
  '_MMWSLE_FREE_ENTRY' : [ 0x4, {
    'MustBeZero' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousFree' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 12, native_type='unsigned long')]],
    'NextFree' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  '_NT_TIB' : [ 0x1c, {
    'ExceptionList' : [ 0x0, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'StackBase' : [ 0x4, ['pointer', ['void']]],
    'StackLimit' : [ 0x8, ['pointer', ['void']]],
    'SubSystemTib' : [ 0xc, ['pointer', ['void']]],
    'FiberData' : [ 0x10, ['pointer', ['void']]],
    'Version' : [ 0x10, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x14, ['pointer', ['void']]],
    'Self' : [ 0x18, ['pointer', ['_NT_TIB']]],
} ],
  '_LEARNING_MODE_DATA' : [ 0x8, {
    'Settings' : [ 0x0, ['unsigned long']],
    'Enabled' : [ 0x4, ['unsigned char']],
    'PermissiveModeEnabled' : [ 0x5, ['unsigned char']],
} ],
  '_WHEA_REVISION' : [ 0x2, {
    'MinorRevision' : [ 0x0, ['unsigned char']],
    'MajorRevision' : [ 0x1, ['unsigned char']],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_PPM_IDLE_STATES' : [ 0x140, {
    'InterfaceVersion' : [ 0x0, ['unsigned char']],
    'ForceIdle' : [ 0x1, ['unsigned char']],
    'EstimateIdleDuration' : [ 0x2, ['unsigned char']],
    'ExitLatencyTraceEnabled' : [ 0x3, ['unsigned char']],
    'NonInterruptibleTransition' : [ 0x4, ['unsigned char']],
    'UnaccountedTransition' : [ 0x5, ['unsigned char']],
    'IdleDurationLimited' : [ 0x6, ['unsigned char']],
    'ExitLatencyCountdown' : [ 0x8, ['unsigned long']],
    'TargetState' : [ 0xc, ['unsigned long']],
    'ActualState' : [ 0x10, ['unsigned long']],
    'OldState' : [ 0x14, ['unsigned long']],
    'OverrideIndex' : [ 0x18, ['unsigned long']],
    'ProcessorIdleCount' : [ 0x1c, ['unsigned long']],
    'Type' : [ 0x20, ['unsigned long']],
    'ReasonFlags' : [ 0x24, ['unsigned short']],
    'InitiateWakeStamp' : [ 0x28, ['unsigned long long']],
    'PreviousStatus' : [ 0x30, ['long']],
    'PreviousCancelReason' : [ 0x34, ['unsigned long']],
    'PrimaryProcessorMask' : [ 0x38, ['_KAFFINITY_EX']],
    'SecondaryProcessorMask' : [ 0x44, ['_KAFFINITY_EX']],
    'IdlePrepare' : [ 0x50, ['pointer', ['void']]],
    'IdlePreExecute' : [ 0x54, ['pointer', ['void']]],
    'IdleExecute' : [ 0x58, ['pointer', ['void']]],
    'IdlePreselect' : [ 0x5c, ['pointer', ['void']]],
    'IdleTest' : [ 0x60, ['pointer', ['void']]],
    'IdleAvailabilityCheck' : [ 0x64, ['pointer', ['void']]],
    'IdleComplete' : [ 0x68, ['pointer', ['void']]],
    'IdleCancel' : [ 0x6c, ['pointer', ['void']]],
    'IdleIsHalted' : [ 0x70, ['pointer', ['void']]],
    'IdleInitiateWake' : [ 0x74, ['pointer', ['void']]],
    'PrepareInfo' : [ 0x78, ['_PROCESSOR_IDLE_PREPARE_INFO']],
    'DeepIdleSnapshot' : [ 0xc8, ['_KAFFINITY_EX']],
    'Tracing' : [ 0xd4, ['pointer', ['_PERFINFO_PPM_STATE_SELECTION']]],
    'CoordinatedTracing' : [ 0xd8, ['pointer', ['_PERFINFO_PPM_STATE_SELECTION']]],
    'ProcessorMenu' : [ 0xdc, ['_PPM_SELECTION_MENU']],
    'CoordinatedMenu' : [ 0xe4, ['_PPM_SELECTION_MENU']],
    'CoordinatedSelection' : [ 0xec, ['_PPM_COORDINATED_SELECTION']],
    'State' : [ 0xfc, ['array', 1, ['_PPM_IDLE_STATE']]],
} ],
  '_PPM_VETO_ACCOUNTING' : [ 0x18, {
    'VetoPresent' : [ 0x0, ['long']],
    'VetoListHead' : [ 0x4, ['_LIST_ENTRY']],
    'CsAccountingBlocks' : [ 0xc, ['unsigned char']],
    'BlocksDrips' : [ 0xd, ['unsigned char']],
    'PreallocatedVetoCount' : [ 0x10, ['unsigned long']],
    'PreallocatedVetoList' : [ 0x14, ['pointer', ['_PPM_VETO_ENTRY']]],
} ],
  '_PEB' : [ 0x460, {
    'InheritedAddressSpace' : [ 0x0, ['unsigned char']],
    'ReadImageFileExecOptions' : [ 0x1, ['unsigned char']],
    'BeingDebugged' : [ 0x2, ['unsigned char']],
    'BitField' : [ 0x3, ['unsigned char']],
    'ImageUsesLargePages' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IsProtectedProcess' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'IsImageDynamicallyRelocated' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SkipPatchingUser32Forwarders' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'IsPackagedProcess' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'IsAppContainer' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'IsProtectedProcessLight' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'SpareBits' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'Mutant' : [ 0x4, ['pointer', ['void']]],
    'ImageBaseAddress' : [ 0x8, ['pointer', ['void']]],
    'Ldr' : [ 0xc, ['pointer', ['_PEB_LDR_DATA']]],
    'ProcessParameters' : [ 0x10, ['pointer', ['_RTL_USER_PROCESS_PARAMETERS']]],
    'SubSystemData' : [ 0x14, ['pointer', ['void']]],
    'ProcessHeap' : [ 0x18, ['pointer', ['void']]],
    'FastPebLock' : [ 0x1c, ['pointer', ['_RTL_CRITICAL_SECTION']]],
    'AtlThunkSListPtr' : [ 0x20, ['pointer', ['void']]],
    'IFEOKey' : [ 0x24, ['pointer', ['void']]],
    'CrossProcessFlags' : [ 0x28, ['unsigned long']],
    'ProcessInJob' : [ 0x28, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ProcessInitializing' : [ 0x28, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ProcessUsingVEH' : [ 0x28, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ProcessUsingVCH' : [ 0x28, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ProcessUsingFTH' : [ 0x28, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ReservedBits0' : [ 0x28, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
    'KernelCallbackTable' : [ 0x2c, ['pointer', ['void']]],
    'UserSharedInfoPtr' : [ 0x2c, ['pointer', ['void']]],
    'SystemReserved' : [ 0x30, ['array', 1, ['unsigned long']]],
    'AtlThunkSListPtr32' : [ 0x34, ['unsigned long']],
    'ApiSetMap' : [ 0x38, ['pointer', ['void']]],
    'TlsExpansionCounter' : [ 0x3c, ['unsigned long']],
    'TlsBitmap' : [ 0x40, ['pointer', ['void']]],
    'TlsBitmapBits' : [ 0x44, ['array', 2, ['unsigned long']]],
    'ReadOnlySharedMemoryBase' : [ 0x4c, ['pointer', ['void']]],
    'SparePvoid0' : [ 0x50, ['pointer', ['void']]],
    'ReadOnlyStaticServerData' : [ 0x54, ['pointer', ['pointer', ['void']]]],
    'AnsiCodePageData' : [ 0x58, ['pointer', ['void']]],
    'OemCodePageData' : [ 0x5c, ['pointer', ['void']]],
    'UnicodeCaseTableData' : [ 0x60, ['pointer', ['void']]],
    'NumberOfProcessors' : [ 0x64, ['unsigned long']],
    'NtGlobalFlag' : [ 0x68, ['unsigned long']],
    'CriticalSectionTimeout' : [ 0x70, ['_LARGE_INTEGER']],
    'HeapSegmentReserve' : [ 0x78, ['unsigned long']],
    'HeapSegmentCommit' : [ 0x7c, ['unsigned long']],
    'HeapDeCommitTotalFreeThreshold' : [ 0x80, ['unsigned long']],
    'HeapDeCommitFreeBlockThreshold' : [ 0x84, ['unsigned long']],
    'NumberOfHeaps' : [ 0x88, ['unsigned long']],
    'MaximumNumberOfHeaps' : [ 0x8c, ['unsigned long']],
    'ProcessHeaps' : [ 0x90, ['pointer', ['pointer', ['void']]]],
    'GdiSharedHandleTable' : [ 0x94, ['pointer', ['void']]],
    'ProcessStarterHelper' : [ 0x98, ['pointer', ['void']]],
    'GdiDCAttributeList' : [ 0x9c, ['unsigned long']],
    'LoaderLock' : [ 0xa0, ['pointer', ['_RTL_CRITICAL_SECTION']]],
    'OSMajorVersion' : [ 0xa4, ['unsigned long']],
    'OSMinorVersion' : [ 0xa8, ['unsigned long']],
    'OSBuildNumber' : [ 0xac, ['unsigned short']],
    'OSCSDVersion' : [ 0xae, ['unsigned short']],
    'OSPlatformId' : [ 0xb0, ['unsigned long']],
    'ImageSubsystem' : [ 0xb4, ['unsigned long']],
    'ImageSubsystemMajorVersion' : [ 0xb8, ['unsigned long']],
    'ImageSubsystemMinorVersion' : [ 0xbc, ['unsigned long']],
    'ActiveProcessAffinityMask' : [ 0xc0, ['unsigned long']],
    'GdiHandleBuffer' : [ 0xc4, ['array', 34, ['unsigned long']]],
    'PostProcessInitRoutine' : [ 0x14c, ['pointer', ['void']]],
    'TlsExpansionBitmap' : [ 0x150, ['pointer', ['void']]],
    'TlsExpansionBitmapBits' : [ 0x154, ['array', 32, ['unsigned long']]],
    'SessionId' : [ 0x1d4, ['unsigned long']],
    'AppCompatFlags' : [ 0x1d8, ['_ULARGE_INTEGER']],
    'AppCompatFlagsUser' : [ 0x1e0, ['_ULARGE_INTEGER']],
    'pShimData' : [ 0x1e8, ['pointer', ['void']]],
    'AppCompatInfo' : [ 0x1ec, ['pointer', ['void']]],
    'CSDVersion' : [ 0x1f0, ['_UNICODE_STRING']],
    'ActivationContextData' : [ 0x1f8, ['pointer', ['_ACTIVATION_CONTEXT_DATA']]],
    'ProcessAssemblyStorageMap' : [ 0x1fc, ['pointer', ['_ASSEMBLY_STORAGE_MAP']]],
    'SystemDefaultActivationContextData' : [ 0x200, ['pointer', ['_ACTIVATION_CONTEXT_DATA']]],
    'SystemAssemblyStorageMap' : [ 0x204, ['pointer', ['_ASSEMBLY_STORAGE_MAP']]],
    'MinimumStackCommit' : [ 0x208, ['unsigned long']],
    'FlsCallback' : [ 0x20c, ['pointer', ['_FLS_CALLBACK_INFO']]],
    'FlsListHead' : [ 0x210, ['_LIST_ENTRY']],
    'FlsBitmap' : [ 0x218, ['pointer', ['void']]],
    'FlsBitmapBits' : [ 0x21c, ['array', 4, ['unsigned long']]],
    'FlsHighIndex' : [ 0x22c, ['unsigned long']],
    'WerRegistrationData' : [ 0x230, ['pointer', ['void']]],
    'WerShipAssertPtr' : [ 0x234, ['pointer', ['void']]],
    'pUnused' : [ 0x238, ['pointer', ['void']]],
    'pImageHeaderHash' : [ 0x23c, ['pointer', ['void']]],
    'TracingFlags' : [ 0x240, ['unsigned long']],
    'HeapTracingEnabled' : [ 0x240, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CritSecTracingEnabled' : [ 0x240, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LibLoaderTracingEnabled' : [ 0x240, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SpareTracingBits' : [ 0x240, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'CsrServerReadOnlySharedMemoryBase' : [ 0x248, ['unsigned long long']],
    'TppWorkerpListLock' : [ 0x250, ['unsigned long']],
    'TppWorkerpList' : [ 0x254, ['_LIST_ENTRY']],
    'WaitOnAddressHashTable' : [ 0x25c, ['array', 128, ['pointer', ['void']]]],
} ],
  '_HEAP_UCR_DESCRIPTOR' : [ 0x18, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SegmentEntry' : [ 0x8, ['_LIST_ENTRY']],
    'Address' : [ 0x10, ['pointer', ['void']]],
    'Size' : [ 0x14, ['unsigned long']],
} ],
  '_ETW_REALTIME_CONSUMER' : [ 0x54, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'ProcessHandle' : [ 0x8, ['pointer', ['void']]],
    'ProcessObject' : [ 0xc, ['pointer', ['_EPROCESS']]],
    'NextNotDelivered' : [ 0x10, ['pointer', ['void']]],
    'RealtimeConnectContext' : [ 0x14, ['pointer', ['void']]],
    'DisconnectEvent' : [ 0x18, ['pointer', ['_KEVENT']]],
    'DataAvailableEvent' : [ 0x1c, ['pointer', ['_KEVENT']]],
    'UserBufferCount' : [ 0x20, ['pointer', ['unsigned long']]],
    'UserBufferListHead' : [ 0x24, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'BuffersLost' : [ 0x28, ['unsigned long']],
    'EmptyBuffersCount' : [ 0x2c, ['unsigned long']],
    'LoggerId' : [ 0x30, ['unsigned short']],
    'Flags' : [ 0x32, ['unsigned char']],
    'ShutDownRequested' : [ 0x32, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'NewBuffersLost' : [ 0x32, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Disconnected' : [ 0x32, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Notified' : [ 0x32, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ReservedBufferSpaceBitMap' : [ 0x34, ['_RTL_BITMAP']],
    'ReservedBufferSpace' : [ 0x3c, ['pointer', ['unsigned char']]],
    'ReservedBufferSpaceSize' : [ 0x40, ['unsigned long']],
    'UserPagesAllocated' : [ 0x44, ['unsigned long']],
    'UserPagesReused' : [ 0x48, ['unsigned long']],
    'EventsLostCount' : [ 0x4c, ['pointer', ['unsigned long']]],
    'BuffersLostCount' : [ 0x50, ['pointer', ['unsigned long']]],
} ],
  '__unnamed_1f0b' : [ 0x4, {
    'BaseMid' : [ 0x0, ['unsigned char']],
    'Flags1' : [ 0x1, ['unsigned char']],
    'Flags2' : [ 0x2, ['unsigned char']],
    'BaseHi' : [ 0x3, ['unsigned char']],
} ],
  '__unnamed_1f10' : [ 0x4, {
    'BaseMid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 13, native_type='unsigned long')]],
    'Dpl' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 15, native_type='unsigned long')]],
    'Pres' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'LimitHi' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'Sys' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'Reserved_0' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'Default_Big' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'Granularity' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'BaseHi' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_1f12' : [ 0x4, {
    'Bytes' : [ 0x0, ['__unnamed_1f0b']],
    'Bits' : [ 0x0, ['__unnamed_1f10']],
} ],
  '_KGDTENTRY' : [ 0x8, {
    'LimitLow' : [ 0x0, ['unsigned short']],
    'BaseLow' : [ 0x2, ['unsigned short']],
    'HighWord' : [ 0x4, ['__unnamed_1f12']],
} ],
  '_POOL_DESCRIPTOR' : [ 0x1140, {
    'PoolType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPoolBase', 1: 'PagedPool', 2: 'NonPagedPoolBaseMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolBaseCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolBaseCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 516: 'NonPagedPoolNxCacheAligned', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 512: 'NonPagedPoolNx', 544: 'NonPagedPoolSessionNx', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'PagedLock' : [ 0x4, ['_FAST_MUTEX']],
    'NonPagedLock' : [ 0x4, ['unsigned long']],
    'RunningAllocs' : [ 0x40, ['long']],
    'RunningDeAllocs' : [ 0x44, ['long']],
    'TotalBigPages' : [ 0x48, ['long']],
    'ThreadsProcessingDeferrals' : [ 0x4c, ['long']],
    'TotalBytes' : [ 0x50, ['unsigned long']],
    'PoolIndex' : [ 0x80, ['unsigned long']],
    'TotalPages' : [ 0xc0, ['long']],
    'PendingFrees' : [ 0x100, ['_SINGLE_LIST_ENTRY']],
    'PendingFreeDepth' : [ 0x104, ['long']],
    'ListHeads' : [ 0x140, ['array', 512, ['_LIST_ENTRY']]],
} ],
  '_TOKEN_MANDATORY_POLICY' : [ 0x4, {
    'Policy' : [ 0x0, ['unsigned long']],
} ],
  '_BLOB_COUNTERS' : [ 0x8, {
    'CreatedObjects' : [ 0x0, ['unsigned long']],
    'DeletedObjects' : [ 0x4, ['unsigned long']],
} ],
  '_KGATE' : [ 0x10, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
} ],
  '_WHEA_ERROR_RECORD_HEADER' : [ 0x80, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Revision' : [ 0x4, ['_WHEA_REVISION']],
    'SignatureEnd' : [ 0x6, ['unsigned long']],
    'SectionCount' : [ 0xa, ['unsigned short']],
    'Severity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSevRecoverable', 1: 'WheaErrSevFatal', 2: 'WheaErrSevCorrected', 3: 'WheaErrSevInformational'})]],
    'ValidBits' : [ 0x10, ['_WHEA_ERROR_RECORD_HEADER_VALIDBITS']],
    'Length' : [ 0x14, ['unsigned long']],
    'Timestamp' : [ 0x18, ['_WHEA_TIMESTAMP']],
    'PlatformId' : [ 0x20, ['_GUID']],
    'PartitionId' : [ 0x30, ['_GUID']],
    'CreatorId' : [ 0x40, ['_GUID']],
    'NotifyType' : [ 0x50, ['_GUID']],
    'RecordId' : [ 0x60, ['unsigned long long']],
    'Flags' : [ 0x68, ['_WHEA_ERROR_RECORD_HEADER_FLAGS']],
    'PersistenceInfo' : [ 0x6c, ['_WHEA_PERSISTENCE_INFO']],
    'Reserved' : [ 0x74, ['array', 12, ['unsigned char']]],
} ],
  '_ALPC_PROCESS_CONTEXT' : [ 0x10, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'ViewListHead' : [ 0x4, ['_LIST_ENTRY']],
    'PagedPoolQuotaCache' : [ 0xc, ['unsigned long']],
} ],
  '_DRIVER_EXTENSION' : [ 0x28, {
    'DriverObject' : [ 0x0, ['pointer', ['_DRIVER_OBJECT']]],
    'AddDevice' : [ 0x4, ['pointer', ['void']]],
    'Count' : [ 0x8, ['unsigned long']],
    'ServiceKeyName' : [ 0xc, ['_UNICODE_STRING']],
    'ClientDriverExtension' : [ 0x14, ['pointer', ['_IO_CLIENT_EXTENSION']]],
    'FsFilterCallbacks' : [ 0x18, ['pointer', ['_FS_FILTER_CALLBACKS']]],
    'KseCallbacks' : [ 0x1c, ['pointer', ['void']]],
    'DvCallbacks' : [ 0x20, ['pointer', ['void']]],
    'VerifierContext' : [ 0x24, ['pointer', ['void']]],
} ],
  '_PRIVILEGE_SET' : [ 0x14, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Control' : [ 0x4, ['unsigned long']],
    'Privilege' : [ 0x8, ['array', 1, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_WHEAP_WORK_QUEUE' : [ 0x44, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'ListLock' : [ 0x8, ['unsigned long']],
    'ItemCount' : [ 0xc, ['long']],
    'Dpc' : [ 0x10, ['_KDPC']],
    'WorkItem' : [ 0x30, ['_WORK_QUEUE_ITEM']],
    'WorkRoutine' : [ 0x40, ['pointer', ['void']]],
} ],
  '_CM_NOTIFY_BLOCK' : [ 0x2c, {
    'HiveList' : [ 0x0, ['_LIST_ENTRY']],
    'PostList' : [ 0x8, ['_LIST_ENTRY']],
    'KeyControlBlock' : [ 0x10, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'KeyBody' : [ 0x14, ['pointer', ['_CM_KEY_BODY']]],
    'Filter' : [ 0x18, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'WatchTree' : [ 0x18, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'NotifyPending' : [ 0x18, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'SubjectContext' : [ 0x1c, ['_SECURITY_SUBJECT_CONTEXT']],
} ],
  '_MI_EXTRA_IMAGE_INFORMATION' : [ 0x8, {
    'SizeOfHeaders' : [ 0x0, ['unsigned long']],
    'SizeOfImage' : [ 0x4, ['unsigned long']],
} ],
  '_KINTERRUPT' : [ 0xb0, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'InterruptListEntry' : [ 0x4, ['_LIST_ENTRY']],
    'ServiceRoutine' : [ 0xc, ['pointer', ['void']]],
    'MessageServiceRoutine' : [ 0x10, ['pointer', ['void']]],
    'MessageIndex' : [ 0x14, ['unsigned long']],
    'ServiceContext' : [ 0x18, ['pointer', ['void']]],
    'SpinLock' : [ 0x1c, ['unsigned long']],
    'TickCount' : [ 0x20, ['unsigned long']],
    'ActualLock' : [ 0x24, ['pointer', ['unsigned long']]],
    'DispatchAddress' : [ 0x28, ['pointer', ['void']]],
    'Vector' : [ 0x2c, ['unsigned long']],
    'Irql' : [ 0x30, ['unsigned char']],
    'SynchronizeIrql' : [ 0x31, ['unsigned char']],
    'FloatingSave' : [ 0x32, ['unsigned char']],
    'Connected' : [ 0x33, ['unsigned char']],
    'Number' : [ 0x34, ['unsigned long']],
    'ShareVector' : [ 0x38, ['unsigned char']],
    'EmulateActiveBoth' : [ 0x39, ['unsigned char']],
    'ActiveCount' : [ 0x3a, ['unsigned short']],
    'InternalState' : [ 0x3c, ['long']],
    'Mode' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: 'LevelSensitive', 1: 'Latched'})]],
    'Polarity' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: 'InterruptPolarityUnknown', 1: 'InterruptRisingEdge', 2: 'InterruptFallingEdge', 3: 'InterruptActiveBothTriggerLow', 4: 'InterruptActiveBothTriggerHigh'})]],
    'ServiceCount' : [ 0x48, ['unsigned long']],
    'DispatchCount' : [ 0x4c, ['unsigned long']],
    'PassiveEvent' : [ 0x50, ['pointer', ['_KEVENT']]],
    'DisconnectData' : [ 0x54, ['pointer', ['void']]],
    'ServiceThread' : [ 0x58, ['pointer', ['_KTHREAD']]],
    'ConnectionData' : [ 0x5c, ['pointer', ['_INTERRUPT_CONNECTION_DATA']]],
    'IntTrackEntry' : [ 0x60, ['pointer', ['void']]],
    'IsrDpcStats' : [ 0x68, ['_ISRDPCSTATS']],
    'RedirectObject' : [ 0xa8, ['pointer', ['void']]],
} ],
  '_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION' : [ 0x18, {
    'SecurityAttributeCount' : [ 0x0, ['unsigned long']],
    'SecurityAttributesList' : [ 0x4, ['_LIST_ENTRY']],
    'WorkingSecurityAttributeCount' : [ 0xc, ['unsigned long']],
    'WorkingSecurityAttributesList' : [ 0x10, ['_LIST_ENTRY']],
} ],
  '_IMAGE_FILE_HEADER' : [ 0x14, {
    'Machine' : [ 0x0, ['unsigned short']],
    'NumberOfSections' : [ 0x2, ['unsigned short']],
    'TimeDateStamp' : [ 0x4, ['unsigned long']],
    'PointerToSymbolTable' : [ 0x8, ['unsigned long']],
    'NumberOfSymbols' : [ 0xc, ['unsigned long']],
    'SizeOfOptionalHeader' : [ 0x10, ['unsigned short']],
    'Characteristics' : [ 0x12, ['unsigned short']],
} ],
  '_MMEXTEND_INFO' : [ 0x10, {
    'CommittedSize' : [ 0x0, ['unsigned long long']],
    'ReferenceCount' : [ 0x8, ['unsigned long']],
} ],
  '_STRING64' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x8, ['unsigned long long']],
} ],
  '_HIVE_LIST_ENTRY' : [ 0x60, {
    'FileName' : [ 0x0, ['pointer', ['unsigned short']]],
    'BaseName' : [ 0x4, ['pointer', ['unsigned short']]],
    'RegRootName' : [ 0x8, ['pointer', ['unsigned short']]],
    'CmHive' : [ 0xc, ['pointer', ['_CMHIVE']]],
    'HHiveFlags' : [ 0x10, ['unsigned long']],
    'CmHiveFlags' : [ 0x14, ['unsigned long']],
    'CmKcbCacheSize' : [ 0x18, ['unsigned long']],
    'CmHive2' : [ 0x1c, ['pointer', ['_CMHIVE']]],
    'HiveMounted' : [ 0x20, ['unsigned char']],
    'ThreadFinished' : [ 0x21, ['unsigned char']],
    'ThreadStarted' : [ 0x22, ['unsigned char']],
    'Allocate' : [ 0x23, ['unsigned char']],
    'WinPERequired' : [ 0x24, ['unsigned char']],
    'StartEvent' : [ 0x28, ['_KEVENT']],
    'FinishedEvent' : [ 0x38, ['_KEVENT']],
    'MountLock' : [ 0x48, ['_KEVENT']],
    'FilePath' : [ 0x58, ['_UNICODE_STRING']],
} ],
  '_HMAP_DIRECTORY' : [ 0x1000, {
    'Directory' : [ 0x0, ['array', 1024, ['pointer', ['_HMAP_TABLE']]]],
} ],
  '_CONTEXT' : [ 0x2cc, {
    'ContextFlags' : [ 0x0, ['unsigned long']],
    'Dr0' : [ 0x4, ['unsigned long']],
    'Dr1' : [ 0x8, ['unsigned long']],
    'Dr2' : [ 0xc, ['unsigned long']],
    'Dr3' : [ 0x10, ['unsigned long']],
    'Dr6' : [ 0x14, ['unsigned long']],
    'Dr7' : [ 0x18, ['unsigned long']],
    'FloatSave' : [ 0x1c, ['_FLOATING_SAVE_AREA']],
    'SegGs' : [ 0x8c, ['unsigned long']],
    'SegFs' : [ 0x90, ['unsigned long']],
    'SegEs' : [ 0x94, ['unsigned long']],
    'SegDs' : [ 0x98, ['unsigned long']],
    'Edi' : [ 0x9c, ['unsigned long']],
    'Esi' : [ 0xa0, ['unsigned long']],
    'Ebx' : [ 0xa4, ['unsigned long']],
    'Edx' : [ 0xa8, ['unsigned long']],
    'Ecx' : [ 0xac, ['unsigned long']],
    'Eax' : [ 0xb0, ['unsigned long']],
    'Ebp' : [ 0xb4, ['unsigned long']],
    'Eip' : [ 0xb8, ['unsigned long']],
    'SegCs' : [ 0xbc, ['unsigned long']],
    'EFlags' : [ 0xc0, ['unsigned long']],
    'Esp' : [ 0xc4, ['unsigned long']],
    'SegSs' : [ 0xc8, ['unsigned long']],
    'ExtendedRegisters' : [ 0xcc, ['array', 512, ['unsigned char']]],
} ],
  '_ALPC_HANDLE_TABLE' : [ 0x10, {
    'Handles' : [ 0x0, ['pointer', ['_ALPC_HANDLE_ENTRY']]],
    'TotalHandles' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'Lock' : [ 0xc, ['_EX_PUSH_LOCK']],
} ],
  '__unnamed_1f74' : [ 0x3a4, {
    'XpfMceDescriptor' : [ 0x0, ['_WHEA_XPF_MCE_DESCRIPTOR']],
    'XpfCmcDescriptor' : [ 0x0, ['_WHEA_XPF_CMC_DESCRIPTOR']],
    'XpfNmiDescriptor' : [ 0x0, ['_WHEA_XPF_NMI_DESCRIPTOR']],
    'IpfMcaDescriptor' : [ 0x0, ['_WHEA_IPF_MCA_DESCRIPTOR']],
    'IpfCmcDescriptor' : [ 0x0, ['_WHEA_IPF_CMC_DESCRIPTOR']],
    'IpfCpeDescriptor' : [ 0x0, ['_WHEA_IPF_CPE_DESCRIPTOR']],
    'AerRootportDescriptor' : [ 0x0, ['_WHEA_AER_ROOTPORT_DESCRIPTOR']],
    'AerEndpointDescriptor' : [ 0x0, ['_WHEA_AER_ENDPOINT_DESCRIPTOR']],
    'AerBridgeDescriptor' : [ 0x0, ['_WHEA_AER_BRIDGE_DESCRIPTOR']],
    'GenErrDescriptor' : [ 0x0, ['_WHEA_GENERIC_ERROR_DESCRIPTOR']],
} ],
  '_WHEA_ERROR_SOURCE_DESCRIPTOR' : [ 0x3cc, {
    'Length' : [ 0x0, ['unsigned long']],
    'Version' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'WheaErrSrcTypeMCE', 1: 'WheaErrSrcTypeCMC', 2: 'WheaErrSrcTypeCPE', 3: 'WheaErrSrcTypeNMI', 4: 'WheaErrSrcTypePCIe', 5: 'WheaErrSrcTypeGeneric', 6: 'WheaErrSrcTypeINIT', 7: 'WheaErrSrcTypeBOOT', 8: 'WheaErrSrcTypeSCIGeneric', 9: 'WheaErrSrcTypeIPFMCA', 10: 'WheaErrSrcTypeIPFCMC', 11: 'WheaErrSrcTypeIPFCPE', 12: 'WheaErrSrcTypeMax'})]],
    'State' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {1: 'WheaErrSrcStateStopped', 2: 'WheaErrSrcStateStarted'})]],
    'MaxRawDataLength' : [ 0x10, ['unsigned long']],
    'NumRecordsToPreallocate' : [ 0x14, ['unsigned long']],
    'MaxSectionsPerRecord' : [ 0x18, ['unsigned long']],
    'ErrorSourceId' : [ 0x1c, ['unsigned long']],
    'PlatformErrorSourceId' : [ 0x20, ['unsigned long']],
    'Flags' : [ 0x24, ['unsigned long']],
    'Info' : [ 0x28, ['__unnamed_1f74']],
} ],
  '_MMPTE_HARDWARE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Dirty1' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Owner' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Accessed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Dirty' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'LargePage' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Global' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 38, native_type='unsigned long long')]],
    'reserved1' : [ 0x0, ['BitField', dict(start_bit = 38, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_IO_COMPLETION_CONTEXT' : [ 0x8, {
    'Port' : [ 0x0, ['pointer', ['void']]],
    'Key' : [ 0x4, ['pointer', ['void']]],
} ],
  '_EX_WORK_QUEUE' : [ 0x1b8, {
    'WorkPriQueue' : [ 0x0, ['_KPRIQUEUE']],
    'Node' : [ 0x19c, ['pointer', ['_ENODE']]],
    'WorkItemsProcessed' : [ 0x1a0, ['unsigned long']],
    'WorkItemsProcessedLastPass' : [ 0x1a4, ['unsigned long']],
    'ThreadCount' : [ 0x1a8, ['long']],
    'MinThreads' : [ 0x1ac, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='long')]],
    'TryFailed' : [ 0x1ac, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'MaxThreads' : [ 0x1b0, ['long']],
    'QueueIndex' : [ 0x1b4, ['Enumeration', dict(target = 'long', choices = {0: 'ExPoolUntrusted', 1: 'ExPoolTrusted', 8: 'ExPoolMax'})]],
} ],
  '_IOV_FORCED_PENDING_TRACE' : [ 0x100, {
    'Irp' : [ 0x0, ['pointer', ['_IRP']]],
    'Thread' : [ 0x4, ['pointer', ['_ETHREAD']]],
    'StackTrace' : [ 0x8, ['array', 62, ['pointer', ['void']]]],
} ],
  '_IOP_IRP_EXTENSION_STATUS' : [ 0xc, {
    'Flags' : [ 0x0, ['unsigned long']],
    'ActivityId' : [ 0x4, ['unsigned long']],
    'IoTracking' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_SET_CONTEXT' : [ 0x4, {
    'ContextFlags' : [ 0x0, ['unsigned long']],
} ],
  '_VI_POOL_ENTRY_INUSE' : [ 0x10, {
    'VirtualAddress' : [ 0x0, ['pointer', ['void']]],
    'CallingAddress' : [ 0x4, ['pointer', ['void']]],
    'NumberOfBytes' : [ 0x8, ['unsigned long']],
    'Tag' : [ 0xc, ['unsigned long']],
} ],
  '_INTERFACE' : [ 0x10, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'InterfaceReference' : [ 0x8, ['pointer', ['void']]],
    'InterfaceDereference' : [ 0xc, ['pointer', ['void']]],
} ],
  '_ACL' : [ 0x8, {
    'AclRevision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'AclSize' : [ 0x2, ['unsigned short']],
    'AceCount' : [ 0x4, ['unsigned short']],
    'Sbz2' : [ 0x6, ['unsigned short']],
} ],
  '_PS_PROPERTY_SET' : [ 0xc, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Lock' : [ 0x8, ['unsigned long']],
} ],
  '_LAZY_WRITER' : [ 0x50, {
    'ScanDpc' : [ 0x0, ['_KDPC']],
    'ScanTimer' : [ 0x20, ['_KTIMER']],
    'ScanActive' : [ 0x48, ['unsigned char']],
    'OtherWork' : [ 0x49, ['unsigned char']],
    'PendingTeardownScan' : [ 0x4a, ['unsigned char']],
    'PendingPeriodicScan' : [ 0x4b, ['unsigned char']],
    'PendingLowMemoryScan' : [ 0x4c, ['unsigned char']],
    'PendingPowerScan' : [ 0x4d, ['unsigned char']],
    'PendingCoalescingFlushScan' : [ 0x4e, ['unsigned char']],
} ],
  '_PI_BUS_EXTENSION' : [ 0x44, {
    'Flags' : [ 0x0, ['unsigned long']],
    'NumberCSNs' : [ 0x4, ['unsigned char']],
    'ReadDataPort' : [ 0x8, ['pointer', ['unsigned char']]],
    'DataPortMapped' : [ 0xc, ['unsigned char']],
    'AddressPort' : [ 0x10, ['pointer', ['unsigned char']]],
    'AddrPortMapped' : [ 0x14, ['unsigned char']],
    'CommandPort' : [ 0x18, ['pointer', ['unsigned char']]],
    'CmdPortMapped' : [ 0x1c, ['unsigned char']],
    'NextSlotNumber' : [ 0x20, ['unsigned long']],
    'DeviceList' : [ 0x24, ['_SINGLE_LIST_ENTRY']],
    'CardList' : [ 0x28, ['_SINGLE_LIST_ENTRY']],
    'PhysicalBusDevice' : [ 0x2c, ['pointer', ['_DEVICE_OBJECT']]],
    'FunctionalBusDevice' : [ 0x30, ['pointer', ['_DEVICE_OBJECT']]],
    'AttachedDevice' : [ 0x34, ['pointer', ['_DEVICE_OBJECT']]],
    'BusNumber' : [ 0x38, ['unsigned long']],
    'SystemPowerState' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DevicePowerState' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
} ],
  '_DEVICE_DESCRIPTION' : [ 0x40, {
    'Version' : [ 0x0, ['unsigned long']],
    'Master' : [ 0x4, ['unsigned char']],
    'ScatterGather' : [ 0x5, ['unsigned char']],
    'DemandMode' : [ 0x6, ['unsigned char']],
    'AutoInitialize' : [ 0x7, ['unsigned char']],
    'Dma32BitAddresses' : [ 0x8, ['unsigned char']],
    'IgnoreCount' : [ 0x9, ['unsigned char']],
    'Reserved1' : [ 0xa, ['unsigned char']],
    'Dma64BitAddresses' : [ 0xb, ['unsigned char']],
    'BusNumber' : [ 0xc, ['unsigned long']],
    'DmaChannel' : [ 0x10, ['unsigned long']],
    'InterfaceType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'ACPIBus', 18: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'DmaWidth' : [ 0x18, ['Enumeration', dict(target = 'long', choices = {0: 'Width8Bits', 1: 'Width16Bits', 2: 'Width32Bits', 3: 'Width64Bits', 4: 'WidthNoWrap', 5: 'MaximumDmaWidth'})]],
    'DmaSpeed' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: 'Compatible', 1: 'TypeA', 2: 'TypeB', 3: 'TypeC', 4: 'TypeF', 5: 'MaximumDmaSpeed'})]],
    'MaximumLength' : [ 0x20, ['unsigned long']],
    'DmaPort' : [ 0x24, ['unsigned long']],
    'DmaAddressWidth' : [ 0x28, ['unsigned long']],
    'DmaControllerInstance' : [ 0x2c, ['unsigned long']],
    'DmaRequestLine' : [ 0x30, ['unsigned long']],
    'DeviceAddress' : [ 0x38, ['_LARGE_INTEGER']],
} ],
  '_PS_TRUSTLET_ATTRIBUTE_ACCESSRIGHTS' : [ 0x1, {
    'Trustlet' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Ntos' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'WriteHandle' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ReadHandle' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'AccessRights' : [ 0x0, ['unsigned char']],
} ],
  '_SID_AND_ATTRIBUTES' : [ 0x8, {
    'Sid' : [ 0x0, ['pointer', ['void']]],
    'Attributes' : [ 0x4, ['unsigned long']],
} ],
  '_SID_IDENTIFIER_AUTHORITY' : [ 0x6, {
    'Value' : [ 0x0, ['array', 6, ['unsigned char']]],
} ],
  '_PROCESS_DISK_COUNTERS' : [ 0x28, {
    'BytesRead' : [ 0x0, ['unsigned long long']],
    'BytesWritten' : [ 0x8, ['unsigned long long']],
    'ReadOperationCount' : [ 0x10, ['unsigned long long']],
    'WriteOperationCount' : [ 0x18, ['unsigned long long']],
    'FlushOperationCount' : [ 0x20, ['unsigned long long']],
} ],
  '_IO_WORKITEM' : [ 0x34, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'Routine' : [ 0x10, ['pointer', ['void']]],
    'IoObject' : [ 0x14, ['pointer', ['void']]],
    'Context' : [ 0x18, ['pointer', ['void']]],
    'WorkingOnBehalfClient' : [ 0x1c, ['pointer', ['void']]],
    'Type' : [ 0x20, ['unsigned long']],
    'ActivityId' : [ 0x24, ['_GUID']],
} ],
  '_MMVAD_FLAGS' : [ 0x4, {
    'VadType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned long')]],
    'PreferredNode' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 14, native_type='unsigned long')]],
    'NoChange' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'PrivateMemory' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'PrivateFixup' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'ManySubsections' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'Enclave' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'DeleteInProgress' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MMWSLE_HASH' : [ 0x4, {
    'Index' : [ 0x0, ['unsigned long']],
} ],
  '_JOBOBJECT_WAKE_FILTER' : [ 0x8, {
    'HighEdgeFilter' : [ 0x0, ['unsigned long']],
    'LowEdgeFilter' : [ 0x4, ['unsigned long']],
} ],
  '_STRING32' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'MaximumLength' : [ 0x2, ['unsigned short']],
    'Buffer' : [ 0x4, ['unsigned long']],
} ],
  '_POP_FX_WORK_ORDER_WATCHDOG_INFO' : [ 0x50, {
    'Timer' : [ 0x0, ['_KTIMER']],
    'Dpc' : [ 0x28, ['_KDPC']],
    'WorkOrder' : [ 0x48, ['pointer', ['_POP_FX_WORK_ORDER']]],
} ],
  '_MI_VAD_EVENT_BLOCK' : [ 0x24, {
    'Next' : [ 0x0, ['pointer', ['_MI_VAD_EVENT_BLOCK']]],
    'WaitReason' : [ 0x4, ['unsigned long']],
    'Gate' : [ 0x8, ['_KGATE']],
    'SecureInfo' : [ 0x8, ['_MMADDRESS_LIST']],
    'BitMap' : [ 0x8, ['_RTL_BITMAP']],
    'InPageSupport' : [ 0x8, ['pointer', ['_MMINPAGE_SUPPORT']]],
    'LargePage' : [ 0x8, ['pointer', ['_MI_LARGEPAGE_MEMORY_INFO']]],
    'CreatingThread' : [ 0x8, ['pointer', ['_ETHREAD']]],
    'PebTeb' : [ 0x8, ['_MI_SUB64K_FREE_RANGES']],
} ],
  '_DBGKD_FILL_MEMORY' : [ 0x10, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Flags' : [ 0xc, ['unsigned short']],
    'PatternLength' : [ 0xe, ['unsigned short']],
} ],
  '_HEAP_STOP_ON_VALUES' : [ 0x18, {
    'AllocAddress' : [ 0x0, ['unsigned long']],
    'AllocTag' : [ 0x4, ['_HEAP_STOP_ON_TAG']],
    'ReAllocAddress' : [ 0x8, ['unsigned long']],
    'ReAllocTag' : [ 0xc, ['_HEAP_STOP_ON_TAG']],
    'FreeAddress' : [ 0x10, ['unsigned long']],
    'FreeTag' : [ 0x14, ['_HEAP_STOP_ON_TAG']],
} ],
  '_HEAP_PSEUDO_TAG_ENTRY' : [ 0xc, {
    'Allocs' : [ 0x0, ['unsigned long']],
    'Frees' : [ 0x4, ['unsigned long']],
    'Size' : [ 0x8, ['unsigned long']],
} ],
  '_CALL_HASH_ENTRY' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'CallersAddress' : [ 0x8, ['pointer', ['void']]],
    'CallersCaller' : [ 0xc, ['pointer', ['void']]],
    'CallCount' : [ 0x10, ['unsigned long']],
} ],
  '_SEP_LUID_TO_INDEX_MAP_ENTRY' : [ 0x28, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'ReferenceCount' : [ 0xc, ['long']],
    'Luid' : [ 0x10, ['unsigned long long']],
    'IndexIntoGlobalSingletonTable' : [ 0x18, ['unsigned long long']],
    'MarkedForDeletion' : [ 0x20, ['unsigned char']],
} ],
  '_KTIMER2_COLLECTION' : [ 0x10, {
    'Tree' : [ 0x0, ['_RTL_RB_TREE']],
    'NextDueTime' : [ 0x8, ['unsigned long long']],
} ],
  '_MIPFNBLINK' : [ 0x4, {
    'Blink' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'TbFlushStamp' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 28, native_type='unsigned long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'PageBlinkDeleteBit' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'PageBlinkLockBit' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'ShareCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'PageShareCountDeleteBit' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'PageShareCountLockBit' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'EntireField' : [ 0x0, ['unsigned long']],
    'Lock' : [ 0x0, ['long']],
    'LockNotUsed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'DeleteBit' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'LockBit' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_VF_TRACKER_STAMP' : [ 0x8, {
    'Thread' : [ 0x0, ['pointer', ['void']]],
    'Flags' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'OldIrql' : [ 0x5, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'NewIrql' : [ 0x6, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Processor' : [ 0x7, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
} ],
  '_VI_TRACK_IRQL' : [ 0x20, {
    'Thread' : [ 0x0, ['pointer', ['void']]],
    'OldIrql' : [ 0x4, ['unsigned char']],
    'NewIrql' : [ 0x5, ['unsigned char']],
    'Processor' : [ 0x6, ['unsigned short']],
    'TickCount' : [ 0x8, ['unsigned long']],
    'StackTrace' : [ 0xc, ['array', 5, ['pointer', ['void']]]],
} ],
  '_MMCLONE_HEADER' : [ 0xc, {
    'NumberOfPtes' : [ 0x0, ['unsigned long']],
    'NumberOfProcessReferences' : [ 0x4, ['unsigned long']],
    'ClonePtes' : [ 0x8, ['pointer', ['_MMCLONE_BLOCK']]],
} ],
  '_SESSION_LOWBOX_MAP' : [ 0x20, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SessionId' : [ 0x8, ['unsigned long']],
    'LowboxMap' : [ 0xc, ['_SEP_LOWBOX_NUMBER_MAPPING']],
} ],
  '_PROCESSOR_PROFILE_CONTROL_AREA' : [ 0x60, {
    'PebsDsSaveArea' : [ 0x0, ['_PEBS_DS_SAVE_AREA']],
} ],
  '_PEB_LDR_DATA' : [ 0x30, {
    'Length' : [ 0x0, ['unsigned long']],
    'Initialized' : [ 0x4, ['unsigned char']],
    'SsHandle' : [ 0x8, ['pointer', ['void']]],
    'InLoadOrderModuleList' : [ 0xc, ['_LIST_ENTRY']],
    'InMemoryOrderModuleList' : [ 0x14, ['_LIST_ENTRY']],
    'InInitializationOrderModuleList' : [ 0x1c, ['_LIST_ENTRY']],
    'EntryInProgress' : [ 0x24, ['pointer', ['void']]],
    'ShutdownInProgress' : [ 0x28, ['unsigned char']],
    'ShutdownThreadId' : [ 0x2c, ['pointer', ['void']]],
} ],
  '_PNP_DEVICE_EVENT_ENTRY' : [ 0x88, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Argument' : [ 0x8, ['unsigned long']],
    'ArgumentStatus' : [ 0xc, ['long']],
    'CallerEvent' : [ 0x10, ['pointer', ['_KEVENT']]],
    'Callback' : [ 0x14, ['pointer', ['void']]],
    'Context' : [ 0x18, ['pointer', ['void']]],
    'VetoType' : [ 0x1c, ['pointer', ['Enumeration', dict(target = 'long', choices = {0: 'PNP_VetoTypeUnknown', 1: 'PNP_VetoLegacyDevice', 2: 'PNP_VetoPendingClose', 3: 'PNP_VetoWindowsApp', 4: 'PNP_VetoWindowsService', 5: 'PNP_VetoOutstandingOpen', 6: 'PNP_VetoDevice', 7: 'PNP_VetoDriver', 8: 'PNP_VetoIllegalDeviceRequest', 9: 'PNP_VetoInsufficientPower', 10: 'PNP_VetoNonDisableable', 11: 'PNP_VetoLegacyDriver', 12: 'PNP_VetoInsufficientRights'})]]],
    'VetoName' : [ 0x20, ['pointer', ['_UNICODE_STRING']]],
    'RefCount' : [ 0x24, ['unsigned long']],
    'Lock' : [ 0x28, ['unsigned long']],
    'Cancel' : [ 0x2c, ['unsigned char']],
    'Parent' : [ 0x30, ['pointer', ['_PNP_DEVICE_EVENT_ENTRY']]],
    'ActivityId' : [ 0x34, ['_GUID']],
    'Data' : [ 0x44, ['_PLUGPLAY_EVENT_BLOCK']],
} ],
  '_HEAP_STOP_ON_TAG' : [ 0x4, {
    'HeapAndTagIndex' : [ 0x0, ['unsigned long']],
    'TagIndex' : [ 0x0, ['unsigned short']],
    'HeapIndex' : [ 0x2, ['unsigned short']],
} ],
  '_PS_WAKE_INFORMATION' : [ 0x38, {
    'NotificationChannel' : [ 0x0, ['unsigned long long']],
    'WakeCounters' : [ 0x8, ['array', 5, ['unsigned long long']]],
    'NoWakeCounter' : [ 0x30, ['unsigned long long']],
} ],
  '_RH_OP_CONTEXT' : [ 0x24, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'OplockRequestIrp' : [ 0x8, ['pointer', ['_IRP']]],
    'OplockRequestFileObject' : [ 0xc, ['pointer', ['_FILE_OBJECT']]],
    'OplockRequestProcess' : [ 0x10, ['pointer', ['_EPROCESS']]],
    'OplockOwnerThread' : [ 0x14, ['pointer', ['_ETHREAD']]],
    'Flags' : [ 0x18, ['unsigned long']],
    'AtomicLinks' : [ 0x1c, ['_LIST_ENTRY']],
} ],
  '_DBGKD_GET_CONTEXT' : [ 0x4, {
    'Unused' : [ 0x0, ['unsigned long']],
} ],
  '_TEB_ACTIVE_FRAME_CONTEXT' : [ 0x8, {
    'Flags' : [ 0x0, ['unsigned long']],
    'FrameName' : [ 0x4, ['pointer', ['unsigned char']]],
} ],
  '_KWAIT_CHAIN' : [ 0x4, {
    'Head' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
} ],
  '_ISRDPCSTATS' : [ 0x40, {
    'IsrTime' : [ 0x0, ['unsigned long long']],
    'IsrTimeStart' : [ 0x8, ['unsigned long long']],
    'IsrCount' : [ 0x10, ['unsigned long long']],
    'DpcTime' : [ 0x18, ['unsigned long long']],
    'DpcTimeStart' : [ 0x20, ['unsigned long long']],
    'DpcCount' : [ 0x28, ['unsigned long long']],
    'IsrActive' : [ 0x30, ['unsigned char']],
    'Reserved' : [ 0x31, ['array', 15, ['unsigned char']]],
} ],
  '_MI_PARTITION_PAGE_LISTS' : [ 0x780, {
    'FreePagesByColor' : [ 0x0, ['array', 2, ['pointer', ['_MMPFNLIST']]]],
    'FreePageSlist' : [ 0x8, ['array', 2, ['pointer', ['_SLIST_HEADER']]]],
    'ZeroedPageListHead' : [ 0x40, ['_MMPFNLIST']],
    'FreePageListHead' : [ 0x80, ['_MMPFNLIST']],
    'StandbyPageListHead' : [ 0xc0, ['_MMPFNLIST']],
    'StandbyPageListByPriority' : [ 0x100, ['array', 8, ['_MMPFNLIST']]],
    'ModifiedPageListNoReservation' : [ 0x1c0, ['_MMPFNLIST']],
    'ModifiedPageListByReservation' : [ 0x200, ['array', 16, ['_MMPFNLIST']]],
    'MappedPageListHead' : [ 0x340, ['array', 16, ['_MMPFNLIST']]],
    'BadPageListHead' : [ 0x480, ['_MMPFNLIST']],
    'EnclavePageListHead' : [ 0x4c0, ['_MMPFNLIST']],
    'PageLocationList' : [ 0x4d4, ['array', 8, ['pointer', ['_MMPFNLIST']]]],
    'StandbyRepurposedByPriority' : [ 0x4f4, ['array', 8, ['unsigned long']]],
    'MappedPageListHeadEvent' : [ 0x514, ['array', 16, ['_KEVENT']]],
    'DecayClusterTimerHeads' : [ 0x614, ['array', 4, ['_MI_DECAY_TIMER_LINK']]],
    'DecayHand' : [ 0x624, ['unsigned long']],
    'LastDecayHandUpdateTime' : [ 0x628, ['unsigned long long']],
    'LastChanceLdwContext' : [ 0x630, ['_MI_LDW_WORK_CONTEXT']],
    'AvailableEventsLock' : [ 0x680, ['unsigned long']],
    'AvailablePageWaitStates' : [ 0x684, ['array', 3, ['_MI_AVAILABLE_PAGE_WAIT_STATES']]],
    'LowMemoryThreshold' : [ 0x6c0, ['unsigned long']],
    'HighMemoryThreshold' : [ 0x6c4, ['unsigned long']],
    'TransitionPrivatePages' : [ 0x700, ['unsigned long']],
    'StandbyListDiscard' : [ 0x704, ['unsigned long']],
    'FreeListDiscard' : [ 0x708, ['unsigned char']],
    'RebuildLargePagesInitialized' : [ 0x709, ['unsigned char']],
    'RebuildLargePagesItem' : [ 0x70c, ['_MI_REBUILD_LARGE_PAGES']],
    'AddMemoryNotifyList' : [ 0x740, ['_LIST_ENTRY']],
    'MirrorListLocks' : [ 0x748, ['pointer', ['void']]],
} ],
  '_XSTATE_CONFIGURATION' : [ 0x330, {
    'EnabledFeatures' : [ 0x0, ['unsigned long long']],
    'EnabledVolatileFeatures' : [ 0x8, ['unsigned long long']],
    'Size' : [ 0x10, ['unsigned long']],
    'OptimizedSave' : [ 0x14, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'CompactionEnabled' : [ 0x14, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Features' : [ 0x18, ['array', 64, ['_XSTATE_FEATURE']]],
    'EnabledSupervisorFeatures' : [ 0x218, ['unsigned long long']],
    'AlignedFeatures' : [ 0x220, ['unsigned long long']],
    'AllFeatureSize' : [ 0x228, ['unsigned long']],
    'AllFeatures' : [ 0x22c, ['array', 64, ['unsigned long']]],
} ],
  '_CM_KEY_CONTROL_BLOCK' : [ 0xa0, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'ExtFlags' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'PrivateAlloc' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'Delete' : [ 0x4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'HiveUnloaded' : [ 0x4, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'Decommissioned' : [ 0x4, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'LockTablePresent' : [ 0x4, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'TotalLevels' : [ 0x4, ['BitField', dict(start_bit = 21, end_bit = 31, native_type='unsigned long')]],
    'DelayedDeref' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DelayedClose' : [ 0x8, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Parking' : [ 0x8, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'KeyHash' : [ 0xc, ['_CM_KEY_HASH']],
    'ConvKey' : [ 0xc, ['unsigned long']],
    'NextHash' : [ 0x10, ['pointer', ['_CM_KEY_HASH']]],
    'KeyHive' : [ 0x14, ['pointer', ['_HHIVE']]],
    'KeyCell' : [ 0x18, ['unsigned long']],
    'KcbPushlock' : [ 0x1c, ['_EX_PUSH_LOCK']],
    'Owner' : [ 0x20, ['pointer', ['_KTHREAD']]],
    'SharedCount' : [ 0x20, ['long']],
    'SlotHint' : [ 0x24, ['unsigned long']],
    'ParentKcb' : [ 0x28, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'NameBlock' : [ 0x2c, ['pointer', ['_CM_NAME_CONTROL_BLOCK']]],
    'CachedSecurity' : [ 0x30, ['pointer', ['_CM_KEY_SECURITY_CACHE']]],
    'ValueCache' : [ 0x34, ['_CACHED_CHILD_LIST']],
    'IndexHint' : [ 0x3c, ['pointer', ['_CM_INDEX_HINT_BLOCK']]],
    'HashKey' : [ 0x3c, ['unsigned long']],
    'SubKeyCount' : [ 0x3c, ['unsigned long']],
    'KeyBodyListHead' : [ 0x40, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x40, ['_LIST_ENTRY']],
    'KeyBodyArray' : [ 0x48, ['array', 4, ['pointer', ['_CM_KEY_BODY']]]],
    'KcbLastWriteTime' : [ 0x58, ['_LARGE_INTEGER']],
    'KcbMaxNameLen' : [ 0x60, ['unsigned short']],
    'KcbMaxValueNameLen' : [ 0x62, ['unsigned short']],
    'KcbMaxValueDataLen' : [ 0x64, ['unsigned long']],
    'KcbUserFlags' : [ 0x68, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned long')]],
    'KcbVirtControlFlags' : [ 0x68, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned long')]],
    'KcbDebug' : [ 0x68, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long')]],
    'Flags' : [ 0x68, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'KCBUoWListHead' : [ 0x6c, ['_LIST_ENTRY']],
    'DelayQueueEntry' : [ 0x74, ['_LIST_ENTRY']],
    'Stolen' : [ 0x74, ['pointer', ['unsigned char']]],
    'TransKCBOwner' : [ 0x7c, ['pointer', ['_CM_TRANS']]],
    'KCBLock' : [ 0x80, ['_CM_INTENT_LOCK']],
    'KeyLock' : [ 0x88, ['_CM_INTENT_LOCK']],
    'TransValueCache' : [ 0x90, ['_CHILD_LIST']],
    'TransValueListOwner' : [ 0x98, ['pointer', ['_CM_TRANS']]],
    'FullKCBName' : [ 0x9c, ['pointer', ['_UNICODE_STRING']]],
} ],
  '_KLOCK_ENTRY' : [ 0x30, {
    'TreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'EntryFlags' : [ 0xc, ['unsigned long']],
    'EntryOffset' : [ 0xc, ['unsigned char']],
    'ThreadLocalFlags' : [ 0xd, ['unsigned char']],
    'WaitingBit' : [ 0xd, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'Spare0' : [ 0xd, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
    'AcquiredByte' : [ 0xe, ['unsigned char']],
    'AcquiredBit' : [ 0xe, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'CrossThreadFlags' : [ 0xf, ['unsigned char']],
    'HeadNodeBit' : [ 0xf, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IoPriorityBit' : [ 0xf, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Spare1' : [ 0xf, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'StaticState' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'AllFlags' : [ 0xc, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
    'LockState' : [ 0x10, ['_KLOCK_ENTRY_LOCK_STATE']],
    'LockUnsafe' : [ 0x10, ['pointer', ['void']]],
    'CrossThreadReleasableAndBusyByte' : [ 0x10, ['unsigned char']],
    'Reserved' : [ 0x11, ['array', 2, ['unsigned char']]],
    'InTreeByte' : [ 0x13, ['unsigned char']],
    'SessionState' : [ 0x14, ['pointer', ['void']]],
    'SessionId' : [ 0x14, ['unsigned long']],
    'OwnerTree' : [ 0x18, ['_RTL_RB_TREE']],
    'WaiterTree' : [ 0x20, ['_RTL_RB_TREE']],
    'CpuPriorityKey' : [ 0x18, ['unsigned char']],
    'EntryLock' : [ 0x28, ['unsigned long']],
    'AllBoosts' : [ 0x2c, ['unsigned short']],
    'IoBoost' : [ 0x2c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'CpuBoostsBitmap' : [ 0x2c, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'IoNormalPriorityWaiterCount' : [ 0x2e, ['unsigned short']],
} ],
  '_OBP_SYSTEM_DOS_DEVICE_STATE' : [ 0x6c, {
    'GlobalDeviceMap' : [ 0x0, ['unsigned long']],
    'LocalDeviceCount' : [ 0x4, ['array', 26, ['unsigned long']]],
} ],
  '_MMPTE_SOFTWARE' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PageFileLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFileReserved' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'PageFileAllocated' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 32, native_type='unsigned long long')]],
    'PageFileHigh' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '__unnamed_2041' : [ 0x8, {
    'IoStatus' : [ 0x0, ['_IO_STATUS_BLOCK']],
} ],
  '_MMMOD_WRITER_MDL_ENTRY' : [ 0xa0, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'u' : [ 0x8, ['__unnamed_2041']],
    'Irp' : [ 0x10, ['pointer', ['_IRP']]],
    'u1' : [ 0x14, ['_MODWRITER_FLAGS']],
    'StoreWriteRefCount' : [ 0x18, ['unsigned long']],
    'StoreWriteCompletionApc' : [ 0x1c, ['_KAPC']],
    'ByteCount' : [ 0x4c, ['unsigned long']],
    'ChargedPages' : [ 0x50, ['unsigned long']],
    'PagingFile' : [ 0x54, ['pointer', ['_MMPAGING_FILE']]],
    'File' : [ 0x58, ['pointer', ['_FILE_OBJECT']]],
    'ControlArea' : [ 0x5c, ['pointer', ['_CONTROL_AREA']]],
    'FileResource' : [ 0x60, ['pointer', ['_ERESOURCE']]],
    'WriteOffset' : [ 0x68, ['_LARGE_INTEGER']],
    'IssueTime' : [ 0x70, ['_LARGE_INTEGER']],
    'Partition' : [ 0x78, ['pointer', ['_MI_PARTITION']]],
    'PointerMdl' : [ 0x7c, ['pointer', ['_MDL']]],
    'Mdl' : [ 0x80, ['_MDL']],
    'Page' : [ 0x9c, ['array', 1, ['unsigned long']]],
} ],
  '_MI_PARTITION_COMMIT' : [ 0x80, {
    'PeakCommitment' : [ 0x0, ['unsigned long']],
    'TotalCommitLimitMaximum' : [ 0x4, ['unsigned long']],
    'Popups' : [ 0x8, ['array', 2, ['long']]],
    'LowCommitThreshold' : [ 0x10, ['unsigned long']],
    'HighCommitThreshold' : [ 0x14, ['unsigned long']],
    'EventLock' : [ 0x18, ['unsigned long']],
    'SystemCommitReserve' : [ 0x1c, ['unsigned long']],
    'OverCommit' : [ 0x40, ['unsigned long']],
} ],
  '_NT_TIB32' : [ 0x1c, {
    'ExceptionList' : [ 0x0, ['unsigned long']],
    'StackBase' : [ 0x4, ['unsigned long']],
    'StackLimit' : [ 0x8, ['unsigned long']],
    'SubSystemTib' : [ 0xc, ['unsigned long']],
    'FiberData' : [ 0x10, ['unsigned long']],
    'Version' : [ 0x10, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x14, ['unsigned long']],
    'Self' : [ 0x18, ['unsigned long']],
} ],
  '_CM_RESOURCE_LIST' : [ 0x24, {
    'Count' : [ 0x0, ['unsigned long']],
    'List' : [ 0x4, ['array', 1, ['_CM_FULL_RESOURCE_DESCRIPTOR']]],
} ],
  '_TOKEN_PRIVILEGES' : [ 0x10, {
    'PrivilegeCount' : [ 0x0, ['unsigned long']],
    'Privileges' : [ 0x4, ['array', 1, ['_LUID_AND_ATTRIBUTES']]],
} ],
  '_POOL_TRACKER_TABLE' : [ 0x1c, {
    'Key' : [ 0x0, ['long']],
    'NonPagedAllocs' : [ 0x4, ['unsigned long']],
    'NonPagedFrees' : [ 0x8, ['unsigned long']],
    'NonPagedBytes' : [ 0xc, ['unsigned long']],
    'PagedAllocs' : [ 0x10, ['unsigned long']],
    'PagedFrees' : [ 0x14, ['unsigned long']],
    'PagedBytes' : [ 0x18, ['unsigned long']],
} ],
  '_CM_FULL_RESOURCE_DESCRIPTOR' : [ 0x20, {
    'InterfaceType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'ACPIBus', 18: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'PartialResourceList' : [ 0x8, ['_CM_PARTIAL_RESOURCE_LIST']],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS' : [ 0x4, {
    'Primary' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ContainmentWarning' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reset' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'ThresholdExceeded' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'ResourceNotAvailable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'LatentError' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_WMI_BUFFER_HEADER' : [ 0x48, {
    'BufferSize' : [ 0x0, ['unsigned long']],
    'SavedOffset' : [ 0x4, ['unsigned long']],
    'CurrentOffset' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['long']],
    'TimeStamp' : [ 0x10, ['_LARGE_INTEGER']],
    'SequenceNumber' : [ 0x18, ['long long']],
    'ClockType' : [ 0x20, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long long')]],
    'Frequency' : [ 0x20, ['BitField', dict(start_bit = 3, end_bit = 64, native_type='unsigned long long')]],
    'SlistEntry' : [ 0x20, ['_SINGLE_LIST_ENTRY']],
    'NextBuffer' : [ 0x20, ['pointer', ['_WMI_BUFFER_HEADER']]],
    'ClientContext' : [ 0x28, ['_ETW_BUFFER_CONTEXT']],
    'State' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'EtwBufferStateFree', 1: 'EtwBufferStateGeneralLogging', 2: 'EtwBufferStateCSwitch', 3: 'EtwBufferStateFlush', 4: 'EtwBufferStateMaximum'})]],
    'Offset' : [ 0x30, ['unsigned long']],
    'BufferFlag' : [ 0x34, ['unsigned short']],
    'BufferType' : [ 0x36, ['unsigned short']],
    'Padding1' : [ 0x38, ['array', 4, ['unsigned long']]],
    'ReferenceTime' : [ 0x38, ['_ETW_REF_CLOCK']],
    'GlobalEntry' : [ 0x38, ['_LIST_ENTRY']],
    'Pointer0' : [ 0x38, ['pointer', ['void']]],
    'Pointer1' : [ 0x3c, ['pointer', ['void']]],
} ],
  '_NT_TIB64' : [ 0x38, {
    'ExceptionList' : [ 0x0, ['unsigned long long']],
    'StackBase' : [ 0x8, ['unsigned long long']],
    'StackLimit' : [ 0x10, ['unsigned long long']],
    'SubSystemTib' : [ 0x18, ['unsigned long long']],
    'FiberData' : [ 0x20, ['unsigned long long']],
    'Version' : [ 0x20, ['unsigned long']],
    'ArbitraryUserPointer' : [ 0x28, ['unsigned long long']],
    'Self' : [ 0x30, ['unsigned long long']],
} ],
  '_POWER_SEQUENCE' : [ 0xc, {
    'SequenceD1' : [ 0x0, ['unsigned long']],
    'SequenceD2' : [ 0x4, ['unsigned long']],
    'SequenceD3' : [ 0x8, ['unsigned long']],
} ],
  '_EPROCESS_VALUES' : [ 0x50, {
    'KernelTime' : [ 0x0, ['unsigned long long']],
    'UserTime' : [ 0x8, ['unsigned long long']],
    'CycleTime' : [ 0x10, ['unsigned long long']],
    'ContextSwitches' : [ 0x18, ['unsigned long long']],
    'ReadOperationCount' : [ 0x20, ['long long']],
    'WriteOperationCount' : [ 0x28, ['long long']],
    'OtherOperationCount' : [ 0x30, ['long long']],
    'ReadTransferCount' : [ 0x38, ['long long']],
    'WriteTransferCount' : [ 0x40, ['long long']],
    'OtherTransferCount' : [ 0x48, ['long long']],
} ],
  '_PROCESSOR_POWER_STATE' : [ 0x180, {
    'IdleStates' : [ 0x0, ['pointer', ['_PPM_IDLE_STATES']]],
    'IdleAccounting' : [ 0x4, ['pointer', ['_PROC_IDLE_ACCOUNTING']]],
    'IdleTimeLast' : [ 0x8, ['unsigned long long']],
    'IdleTimeTotal' : [ 0x10, ['unsigned long long']],
    'IdleTimeEntry' : [ 0x18, ['unsigned long long']],
    'IdleTimeExpiration' : [ 0x20, ['unsigned long long']],
    'NonInterruptibleTransition' : [ 0x28, ['unsigned char']],
    'PepWokenTransition' : [ 0x29, ['unsigned char']],
    'Class' : [ 0x2a, ['unsigned char']],
    'TargetIdleState' : [ 0x2c, ['unsigned long']],
    'IdlePolicy' : [ 0x30, ['_PROC_IDLE_POLICY']],
    'Synchronization' : [ 0x38, ['_PPM_IDLE_SYNCHRONIZATION_STATE']],
    'PerfFeedback' : [ 0x40, ['_PROC_FEEDBACK']],
    'Hypervisor' : [ 0xc8, ['Enumeration', dict(target = 'long', choices = {0: 'ProcHypervisorNone', 1: 'ProcHypervisorPresent', 2: 'ProcHypervisorPower', 3: 'ProcHypervisorHvCounters'})]],
    'LastSysTime' : [ 0xcc, ['unsigned long']],
    'WmiDispatchPtr' : [ 0xd0, ['unsigned long']],
    'WmiInterfaceEnabled' : [ 0xd4, ['long']],
    'FFHThrottleStateInfo' : [ 0xd8, ['_PPM_FFH_THROTTLE_STATE_INFO']],
    'PerfActionDpc' : [ 0xf8, ['_KDPC']],
    'PerfActionMask' : [ 0x118, ['long']],
    'HvIdleCheck' : [ 0x120, ['_PROC_IDLE_SNAP']],
    'PerfCheck' : [ 0x130, ['pointer', ['_PROC_PERF_CHECK']]],
    'Domain' : [ 0x134, ['pointer', ['_PROC_PERF_DOMAIN']]],
    'PerfConstraint' : [ 0x138, ['pointer', ['_PROC_PERF_CONSTRAINT']]],
    'Concurrency' : [ 0x13c, ['pointer', ['_PPM_CONCURRENCY_ACCOUNTING']]],
    'Load' : [ 0x140, ['pointer', ['_PROC_PERF_LOAD']]],
    'PerfHistory' : [ 0x144, ['pointer', ['_PROC_PERF_HISTORY']]],
    'GuaranteedPerformancePercent' : [ 0x148, ['unsigned char']],
    'HvTargetState' : [ 0x149, ['unsigned char']],
    'Parked' : [ 0x14a, ['unsigned char']],
    'LatestPerformancePercent' : [ 0x14c, ['unsigned long']],
    'AveragePerformancePercent' : [ 0x150, ['unsigned long']],
    'LatestAffinitizedPercent' : [ 0x154, ['unsigned long']],
    'RelativePerformance' : [ 0x158, ['unsigned long']],
    'Utility' : [ 0x15c, ['unsigned long']],
    'AffinitizedUtility' : [ 0x160, ['unsigned long']],
    'SnapTimeLast' : [ 0x168, ['unsigned long long']],
    'EnergyConsumed' : [ 0x168, ['unsigned long long']],
    'ActiveTime' : [ 0x170, ['unsigned long long']],
    'TotalTime' : [ 0x178, ['unsigned long long']],
} ],
  '_OBJECT_REF_STACK_INFO' : [ 0xc, {
    'Sequence' : [ 0x0, ['unsigned long']],
    'Index' : [ 0x4, ['unsigned short']],
    'NumTraces' : [ 0x6, ['unsigned short']],
    'Tag' : [ 0x8, ['unsigned long']],
} ],
  '_PPC_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_MMPFNENTRY' : [ 0x2, {
    'PageLocation' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'WriteInProgress' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Modified' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ReadInProgress' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'CacheAttribute' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'Priority' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'OnProtectedStandby' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'InPageError' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'SystemChargedPage' : [ 0x1, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'RemovalRequested' : [ 0x1, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'ParityError' : [ 0x1, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_THREAD_ENERGY_VALUES' : [ 0x40, {
    'Cycles' : [ 0x0, ['array', 4, ['array', 2, ['unsigned long long']]]],
} ],
  '_PCW_CALLBACK_INFORMATION' : [ 0x20, {
    'AddCounter' : [ 0x0, ['_PCW_COUNTER_INFORMATION']],
    'RemoveCounter' : [ 0x0, ['_PCW_COUNTER_INFORMATION']],
    'EnumerateInstances' : [ 0x0, ['_PCW_MASK_INFORMATION']],
    'CollectData' : [ 0x0, ['_PCW_MASK_INFORMATION']],
} ],
  '_CC_ASYNC_READ_CONTEXT' : [ 0x14, {
    'CompletionRoutine' : [ 0x0, ['pointer', ['void']]],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'Mdl' : [ 0x8, ['pointer', ['_MDL']]],
    'RequestorMode' : [ 0xc, ['unsigned char']],
    'NestingLevel' : [ 0x10, ['unsigned long']],
} ],
  '_KTSS' : [ 0x20ac, {
    'Backlink' : [ 0x0, ['unsigned short']],
    'Reserved0' : [ 0x2, ['unsigned short']],
    'Esp0' : [ 0x4, ['unsigned long']],
    'Ss0' : [ 0x8, ['unsigned short']],
    'Reserved1' : [ 0xa, ['unsigned short']],
    'NotUsed1' : [ 0xc, ['array', 4, ['unsigned long']]],
    'CR3' : [ 0x1c, ['unsigned long']],
    'Eip' : [ 0x20, ['unsigned long']],
    'EFlags' : [ 0x24, ['unsigned long']],
    'Eax' : [ 0x28, ['unsigned long']],
    'Ecx' : [ 0x2c, ['unsigned long']],
    'Edx' : [ 0x30, ['unsigned long']],
    'Ebx' : [ 0x34, ['unsigned long']],
    'Esp' : [ 0x38, ['unsigned long']],
    'Ebp' : [ 0x3c, ['unsigned long']],
    'Esi' : [ 0x40, ['unsigned long']],
    'Edi' : [ 0x44, ['unsigned long']],
    'Es' : [ 0x48, ['unsigned short']],
    'Reserved2' : [ 0x4a, ['unsigned short']],
    'Cs' : [ 0x4c, ['unsigned short']],
    'Reserved3' : [ 0x4e, ['unsigned short']],
    'Ss' : [ 0x50, ['unsigned short']],
    'Reserved4' : [ 0x52, ['unsigned short']],
    'Ds' : [ 0x54, ['unsigned short']],
    'Reserved5' : [ 0x56, ['unsigned short']],
    'Fs' : [ 0x58, ['unsigned short']],
    'Reserved6' : [ 0x5a, ['unsigned short']],
    'Gs' : [ 0x5c, ['unsigned short']],
    'Reserved7' : [ 0x5e, ['unsigned short']],
    'LDT' : [ 0x60, ['unsigned short']],
    'Reserved8' : [ 0x62, ['unsigned short']],
    'Flags' : [ 0x64, ['unsigned short']],
    'IoMapBase' : [ 0x66, ['unsigned short']],
    'IoMaps' : [ 0x68, ['array', 1, ['_KiIoAccessMap']]],
    'IntDirectionMap' : [ 0x208c, ['array', 32, ['unsigned char']]],
} ],
  '_TOKEN_SOURCE' : [ 0x10, {
    'SourceName' : [ 0x0, ['array', 8, ['unsigned char']]],
    'SourceIdentifier' : [ 0x8, ['_LUID']],
} ],
  '_CMHIVE' : [ 0xf20, {
    'Hive' : [ 0x0, ['_HHIVE']],
    'FileHandles' : [ 0x6f0, ['array', 6, ['pointer', ['void']]]],
    'NotifyList' : [ 0x708, ['_LIST_ENTRY']],
    'HiveList' : [ 0x710, ['_LIST_ENTRY']],
    'PreloadedHiveList' : [ 0x718, ['_LIST_ENTRY']],
    'FailedUnloadList' : [ 0x720, ['_LIST_ENTRY']],
    'HiveRundown' : [ 0x728, ['_EX_RUNDOWN_REF']],
    'ParseCacheEntries' : [ 0x72c, ['_LIST_ENTRY']],
    'KcbCacheTable' : [ 0x734, ['pointer', ['_CM_KEY_HASH_TABLE_ENTRY']]],
    'KcbCacheTableSize' : [ 0x738, ['unsigned long']],
    'DeletedKcbTable' : [ 0x73c, ['pointer', ['_CM_KEY_HASH_TABLE_ENTRY']]],
    'DeletedKcbTableSize' : [ 0x740, ['unsigned long']],
    'Identity' : [ 0x744, ['unsigned long']],
    'HiveLock' : [ 0x748, ['pointer', ['_FAST_MUTEX']]],
    'WriterLock' : [ 0x74c, ['pointer', ['_FAST_MUTEX']]],
    'FlusherLock' : [ 0x750, ['pointer', ['_ERESOURCE']]],
    'FlushDirtyVector' : [ 0x754, ['_RTL_BITMAP']],
    'FlushDirtyVectorSize' : [ 0x75c, ['unsigned long']],
    'FlushLogEntry' : [ 0x760, ['pointer', ['unsigned char']]],
    'FlushLogEntrySize' : [ 0x764, ['unsigned long']],
    'FlushHiveTruncated' : [ 0x768, ['unsigned long']],
    'FlushBaseBlockDirty' : [ 0x76c, ['unsigned char']],
    'CapturedUnreconciledVector' : [ 0x770, ['_RTL_BITMAP']],
    'CapturedUnreconciledVectorSize' : [ 0x778, ['unsigned long']],
    'UnreconciledOffsetArray' : [ 0x77c, ['pointer', ['CMP_OFFSET_ARRAY']]],
    'UnreconciledOffsetArrayCount' : [ 0x780, ['unsigned long']],
    'UnreconciledBaseBlock' : [ 0x784, ['pointer', ['_HBASE_BLOCK']]],
    'SecurityLock' : [ 0x788, ['_EX_PUSH_LOCK']],
    'UseCount' : [ 0x78c, ['unsigned long']],
    'LastShrinkHiveSize' : [ 0x790, ['unsigned long']],
    'ActualFileSize' : [ 0x798, ['_LARGE_INTEGER']],
    'LogFileSizes' : [ 0x7a0, ['array', 2, ['_LARGE_INTEGER']]],
    'FileFullPath' : [ 0x7b0, ['_UNICODE_STRING']],
    'FileUserName' : [ 0x7b8, ['_UNICODE_STRING']],
    'HiveRootPath' : [ 0x7c0, ['_UNICODE_STRING']],
    'SecurityCount' : [ 0x7c8, ['unsigned long']],
    'SecurityCacheSize' : [ 0x7cc, ['unsigned long']],
    'SecurityHitHint' : [ 0x7d0, ['long']],
    'SecurityCache' : [ 0x7d4, ['pointer', ['_CM_KEY_SECURITY_CACHE_ENTRY']]],
    'SecurityHash' : [ 0x7d8, ['array', 64, ['_LIST_ENTRY']]],
    'UnloadEventCount' : [ 0x9d8, ['unsigned long']],
    'UnloadEventArray' : [ 0x9dc, ['pointer', ['pointer', ['_KEVENT']]]],
    'RootKcb' : [ 0x9e0, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'Frozen' : [ 0x9e4, ['unsigned char']],
    'UnloadWorkItem' : [ 0x9e8, ['pointer', ['_CM_WORKITEM']]],
    'UnloadWorkItemHolder' : [ 0x9ec, ['_CM_WORKITEM']],
    'GrowOnlyMode' : [ 0xa00, ['unsigned char']],
    'GrowOffset' : [ 0xa04, ['unsigned long']],
    'KcbConvertListHead' : [ 0xa08, ['_LIST_ENTRY']],
    'CellRemapArray' : [ 0xa10, ['pointer', ['_CM_CELL_REMAP_BLOCK']]],
    'DirtyVectorLog' : [ 0xa14, ['_CM_DIRTY_VECTOR_LOG']],
    'Flags' : [ 0xc9c, ['unsigned long']],
    'TrustClassEntry' : [ 0xca0, ['_LIST_ENTRY']],
    'DirtyTime' : [ 0xca8, ['unsigned long long']],
    'UnreconciledTime' : [ 0xcb0, ['unsigned long long']],
    'CmRm' : [ 0xcb8, ['pointer', ['_CM_RM']]],
    'CmRmInitFailPoint' : [ 0xcbc, ['unsigned long']],
    'CmRmInitFailStatus' : [ 0xcc0, ['long']],
    'CreatorOwner' : [ 0xcc4, ['pointer', ['_KTHREAD']]],
    'RundownThread' : [ 0xcc8, ['pointer', ['_KTHREAD']]],
    'LastWriteTime' : [ 0xcd0, ['_LARGE_INTEGER']],
    'FlushQueue' : [ 0xcd8, ['_HIVE_WRITE_WAIT_QUEUE']],
    'ReconcileQueue' : [ 0xce4, ['_HIVE_WRITE_WAIT_QUEUE']],
    'FlushFlags' : [ 0xcf0, ['unsigned long']],
    'FlushActive' : [ 0xcf0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReconcileActive' : [ 0xcf0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PrimaryFilePurged' : [ 0xcf0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DiskFileBad' : [ 0xcf0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'PrimaryFileSizeBeforeLastFlush' : [ 0xcf4, ['unsigned long']],
    'ReferenceCount' : [ 0xcf8, ['long']],
    'UnloadHistoryIndex' : [ 0xcfc, ['long']],
    'UnloadHistory' : [ 0xd00, ['array', 128, ['unsigned long']]],
    'BootStart' : [ 0xf00, ['unsigned long']],
    'UnaccessedStart' : [ 0xf04, ['unsigned long']],
    'UnaccessedEnd' : [ 0xf08, ['unsigned long']],
    'LoadedKeyCount' : [ 0xf0c, ['unsigned long']],
    'HandleClosePending' : [ 0xf10, ['unsigned long']],
    'HandleClosePendingEvent' : [ 0xf14, ['_EX_PUSH_LOCK']],
    'FinalFlushSucceeded' : [ 0xf18, ['unsigned char']],
    'FailedUnload' : [ 0xf19, ['unsigned char']],
} ],
  '_DBGKD_QUERY_MEMORY' : [ 0x18, {
    'Address' : [ 0x0, ['unsigned long long']],
    'Reserved' : [ 0x8, ['unsigned long long']],
    'AddressSpace' : [ 0x10, ['unsigned long']],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_KIDTENTRY' : [ 0x8, {
    'Offset' : [ 0x0, ['unsigned short']],
    'Selector' : [ 0x2, ['unsigned short']],
    'Access' : [ 0x4, ['unsigned short']],
    'ExtendedOffset' : [ 0x6, ['unsigned short']],
} ],
  '_DIRTY_PAGE_THRESHOLDS' : [ 0x28, {
    'DirtyPageThreshold' : [ 0x0, ['unsigned long']],
    'DirtyPageThresholdTop' : [ 0x4, ['unsigned long']],
    'DirtyPageThresholdBottom' : [ 0x8, ['unsigned long']],
    'DirtyPageTarget' : [ 0xc, ['unsigned long']],
    'AggregateAvailablePages' : [ 0x10, ['unsigned long long']],
    'AggregateDirtyPages' : [ 0x18, ['unsigned long long']],
    'AvailableHistory' : [ 0x20, ['unsigned long']],
} ],
  'DOCK_INTERFACE' : [ 0x18, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'InterfaceReference' : [ 0x8, ['pointer', ['void']]],
    'InterfaceDereference' : [ 0xc, ['pointer', ['void']]],
    'ProfileDepartureSetMode' : [ 0x10, ['pointer', ['void']]],
    'ProfileDepartureUpdate' : [ 0x14, ['pointer', ['void']]],
} ],
  'CMP_OFFSET_ARRAY' : [ 0xc, {
    'FileOffset' : [ 0x0, ['unsigned long']],
    'DataBuffer' : [ 0x4, ['pointer', ['void']]],
    'DataLength' : [ 0x8, ['unsigned long']],
} ],
  '_MMSUPPORT_FLAGS' : [ 0x4, {
    'WorkingSetType' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Reserved0' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 6, native_type='unsigned char')]],
    'MaximumWorkingSetHard' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'MinimumWorkingSetHard' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'SessionMaster' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'TrimmerState' : [ 0x1, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned char')]],
    'Reserved' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PageStealers' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
    'MemoryPriority' : [ 0x2, ['unsigned char']],
    'WsleDeleted' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'VmExiting' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'ExpansionFailed' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SvmEnabled' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ForceAge' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'NewMaximum' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'CommitReleaseState' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
} ],
  '_PPM_VETO_ENTRY' : [ 0x38, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'VetoReason' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['unsigned long']],
    'HitCount' : [ 0x10, ['unsigned long long']],
    'LastActivationTime' : [ 0x18, ['unsigned long long']],
    'TotalActiveTime' : [ 0x20, ['unsigned long long']],
    'CsActivationTime' : [ 0x28, ['unsigned long long']],
    'CsActiveTime' : [ 0x30, ['unsigned long long']],
} ],
  '_IMAGE_OPTIONAL_HEADER' : [ 0xe0, {
    'Magic' : [ 0x0, ['unsigned short']],
    'MajorLinkerVersion' : [ 0x2, ['unsigned char']],
    'MinorLinkerVersion' : [ 0x3, ['unsigned char']],
    'SizeOfCode' : [ 0x4, ['unsigned long']],
    'SizeOfInitializedData' : [ 0x8, ['unsigned long']],
    'SizeOfUninitializedData' : [ 0xc, ['unsigned long']],
    'AddressOfEntryPoint' : [ 0x10, ['unsigned long']],
    'BaseOfCode' : [ 0x14, ['unsigned long']],
    'BaseOfData' : [ 0x18, ['unsigned long']],
    'ImageBase' : [ 0x1c, ['unsigned long']],
    'SectionAlignment' : [ 0x20, ['unsigned long']],
    'FileAlignment' : [ 0x24, ['unsigned long']],
    'MajorOperatingSystemVersion' : [ 0x28, ['unsigned short']],
    'MinorOperatingSystemVersion' : [ 0x2a, ['unsigned short']],
    'MajorImageVersion' : [ 0x2c, ['unsigned short']],
    'MinorImageVersion' : [ 0x2e, ['unsigned short']],
    'MajorSubsystemVersion' : [ 0x30, ['unsigned short']],
    'MinorSubsystemVersion' : [ 0x32, ['unsigned short']],
    'Win32VersionValue' : [ 0x34, ['unsigned long']],
    'SizeOfImage' : [ 0x38, ['unsigned long']],
    'SizeOfHeaders' : [ 0x3c, ['unsigned long']],
    'CheckSum' : [ 0x40, ['unsigned long']],
    'Subsystem' : [ 0x44, ['unsigned short']],
    'DllCharacteristics' : [ 0x46, ['unsigned short']],
    'SizeOfStackReserve' : [ 0x48, ['unsigned long']],
    'SizeOfStackCommit' : [ 0x4c, ['unsigned long']],
    'SizeOfHeapReserve' : [ 0x50, ['unsigned long']],
    'SizeOfHeapCommit' : [ 0x54, ['unsigned long']],
    'LoaderFlags' : [ 0x58, ['unsigned long']],
    'NumberOfRvaAndSizes' : [ 0x5c, ['unsigned long']],
    'DataDirectory' : [ 0x60, ['array', 16, ['_IMAGE_DATA_DIRECTORY']]],
} ],
  '_ALPC_COMPLETION_PACKET_LOOKASIDE' : [ 0x30, {
    'Lock' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
    'ActiveCount' : [ 0x8, ['unsigned long']],
    'PendingNullCount' : [ 0xc, ['unsigned long']],
    'PendingCheckCompletionListCount' : [ 0x10, ['unsigned long']],
    'PendingDelete' : [ 0x14, ['unsigned long']],
    'FreeListHead' : [ 0x18, ['_SINGLE_LIST_ENTRY']],
    'CompletionPort' : [ 0x1c, ['pointer', ['void']]],
    'CompletionKey' : [ 0x20, ['pointer', ['void']]],
    'Entry' : [ 0x24, ['array', 1, ['_ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY']]],
} ],
  '_KSYSTEM_TIME' : [ 0xc, {
    'LowPart' : [ 0x0, ['unsigned long']],
    'High1Time' : [ 0x4, ['long']],
    'High2Time' : [ 0x8, ['long']],
} ],
  '_TERMINATION_PORT' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_TERMINATION_PORT']]],
    'Port' : [ 0x4, ['pointer', ['void']]],
} ],
  '_MEMORY_ALLOCATION_DESCRIPTOR' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'MemoryType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'LoaderExceptionBlock', 1: 'LoaderSystemBlock', 2: 'LoaderFree', 3: 'LoaderBad', 4: 'LoaderLoadedProgram', 5: 'LoaderFirmwareTemporary', 6: 'LoaderFirmwarePermanent', 7: 'LoaderOsloaderHeap', 8: 'LoaderOsloaderStack', 9: 'LoaderSystemCode', 10: 'LoaderHalCode', 11: 'LoaderBootDriver', 12: 'LoaderConsoleInDriver', 13: 'LoaderConsoleOutDriver', 14: 'LoaderStartupDpcStack', 15: 'LoaderStartupKernelStack', 16: 'LoaderStartupPanicStack', 17: 'LoaderStartupPcrPage', 18: 'LoaderStartupPdrPage', 19: 'LoaderRegistryData', 20: 'LoaderMemoryData', 21: 'LoaderNlsData', 22: 'LoaderSpecialMemory', 23: 'LoaderBBTMemory', 24: 'LoaderZero', 25: 'LoaderXIPRom', 26: 'LoaderHALCachedMemory', 27: 'LoaderLargePageFiller', 28: 'LoaderErrorLogMemory', 29: 'LoaderVsmMemory', 30: 'LoaderFirmwareCode', 31: 'LoaderFirmwareData', 32: 'LoaderFirmwareReserved', 33: 'LoaderEnclaveMemory', 34: 'LoaderMaximum'})]],
    'BasePage' : [ 0xc, ['unsigned long']],
    'PageCount' : [ 0x10, ['unsigned long']],
} ],
  '_CM_INTENT_LOCK' : [ 0x8, {
    'OwnerCount' : [ 0x0, ['unsigned long']],
    'OwnerTable' : [ 0x4, ['pointer', ['pointer', ['_CM_KCB_UOW']]]],
} ],
  '_PROC_IDLE_ACCOUNTING' : [ 0x408, {
    'StateCount' : [ 0x0, ['unsigned long']],
    'TotalTransitions' : [ 0x4, ['unsigned long']],
    'ResetCount' : [ 0x8, ['unsigned long']],
    'AbortCount' : [ 0xc, ['unsigned long']],
    'StartTime' : [ 0x10, ['unsigned long long']],
    'PriorIdleTime' : [ 0x18, ['unsigned long long']],
    'TimeUnit' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'PpmIdleBucketTimeInQpc', 1: 'PpmIdleBucketTimeIn100ns', 2: 'PpmIdleBucketTimeMaximum'})]],
    'State' : [ 0x28, ['array', 1, ['_PROC_IDLE_STATE_ACCOUNTING']]],
} ],
  '_THERMAL_INFORMATION' : [ 0x4c, {
    'ThermalStamp' : [ 0x0, ['unsigned long']],
    'ThermalConstant1' : [ 0x4, ['unsigned long']],
    'ThermalConstant2' : [ 0x8, ['unsigned long']],
    'Processors' : [ 0xc, ['unsigned long']],
    'SamplingPeriod' : [ 0x10, ['unsigned long']],
    'CurrentTemperature' : [ 0x14, ['unsigned long']],
    'PassiveTripPoint' : [ 0x18, ['unsigned long']],
    'CriticalTripPoint' : [ 0x1c, ['unsigned long']],
    'ActiveTripPointCount' : [ 0x20, ['unsigned char']],
    'ActiveTripPoint' : [ 0x24, ['array', 10, ['unsigned long']]],
} ],
  '_SEP_LOWBOX_NUMBER_MAPPING' : [ 0x14, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'Bitmap' : [ 0x4, ['_RTL_BITMAP']],
    'HashTable' : [ 0xc, ['pointer', ['_RTL_DYNAMIC_HASH_TABLE']]],
    'Active' : [ 0x10, ['unsigned char']],
} ],
  '_MAPPED_FILE_SEGMENT' : [ 0x20, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'TotalNumberOfPtes' : [ 0x4, ['unsigned long']],
    'SegmentFlags' : [ 0x8, ['_SEGMENT_FLAGS']],
    'NumberOfCommittedPages' : [ 0xc, ['unsigned long']],
    'SizeOfSegment' : [ 0x10, ['unsigned long long']],
    'ExtendInfo' : [ 0x18, ['pointer', ['_MMEXTEND_INFO']]],
    'BasedAddress' : [ 0x18, ['pointer', ['void']]],
    'SegmentLock' : [ 0x1c, ['_EX_PUSH_LOCK']],
} ],
  '_GDI_TEB_BATCH' : [ 0x4e0, {
    'Offset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'HasRenderingCommand' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HDC' : [ 0x4, ['unsigned long']],
    'Buffer' : [ 0x8, ['array', 310, ['unsigned long']]],
} ],
  '_MM_DRIVER_VERIFIER_DATA' : [ 0x8c, {
    'Level' : [ 0x0, ['unsigned long']],
    'RaiseIrqls' : [ 0x4, ['unsigned long']],
    'AcquireSpinLocks' : [ 0x8, ['unsigned long']],
    'SynchronizeExecutions' : [ 0xc, ['unsigned long']],
    'AllocationsAttempted' : [ 0x10, ['unsigned long']],
    'AllocationsSucceeded' : [ 0x14, ['unsigned long']],
    'AllocationsSucceededSpecialPool' : [ 0x18, ['unsigned long']],
    'AllocationsWithNoTag' : [ 0x1c, ['unsigned long']],
    'TrimRequests' : [ 0x20, ['unsigned long']],
    'Trims' : [ 0x24, ['unsigned long']],
    'AllocationsFailed' : [ 0x28, ['unsigned long']],
    'AllocationsFailedDeliberately' : [ 0x2c, ['unsigned long']],
    'Loads' : [ 0x30, ['unsigned long']],
    'Unloads' : [ 0x34, ['unsigned long']],
    'UnTrackedPool' : [ 0x38, ['unsigned long']],
    'UserTrims' : [ 0x3c, ['unsigned long']],
    'CurrentPagedPoolAllocations' : [ 0x40, ['unsigned long']],
    'CurrentNonPagedPoolAllocations' : [ 0x44, ['unsigned long']],
    'PeakPagedPoolAllocations' : [ 0x48, ['unsigned long']],
    'PeakNonPagedPoolAllocations' : [ 0x4c, ['unsigned long']],
    'PagedBytes' : [ 0x50, ['unsigned long']],
    'NonPagedBytes' : [ 0x54, ['unsigned long']],
    'PeakPagedBytes' : [ 0x58, ['unsigned long']],
    'PeakNonPagedBytes' : [ 0x5c, ['unsigned long']],
    'BurstAllocationsFailedDeliberately' : [ 0x60, ['unsigned long']],
    'SessionTrims' : [ 0x64, ['unsigned long']],
    'OptionChanges' : [ 0x68, ['unsigned long']],
    'VerifyMode' : [ 0x6c, ['unsigned long']],
    'PreviousBucketName' : [ 0x70, ['_UNICODE_STRING']],
    'ExecutePoolTypes' : [ 0x78, ['unsigned long']],
    'ExecutePageProtections' : [ 0x7c, ['unsigned long']],
    'ExecutePageMappings' : [ 0x80, ['unsigned long']],
    'ExecuteWriteSections' : [ 0x84, ['unsigned long']],
    'SectionAlignmentFailures' : [ 0x88, ['unsigned long']],
} ],
  '_VF_DRIVER_IO_CALLBACKS' : [ 0x80, {
    'DriverInit' : [ 0x0, ['pointer', ['void']]],
    'DriverStartIo' : [ 0x4, ['pointer', ['void']]],
    'DriverUnload' : [ 0x8, ['pointer', ['void']]],
    'AddDevice' : [ 0xc, ['pointer', ['void']]],
    'MajorFunction' : [ 0x10, ['array', 28, ['pointer', ['void']]]],
} ],
  '_HIVE_WRITE_WAIT_QUEUE' : [ 0xc, {
    'ActiveThread' : [ 0x0, ['pointer', ['_ETHREAD']]],
    'WaitList' : [ 0x4, ['pointer', ['_HIVE_WAIT_PACKET']]],
    'OwnerBoosted' : [ 0x8, ['unsigned long']],
} ],
  '_VI_FAULT_TRACE' : [ 0x24, {
    'Thread' : [ 0x0, ['pointer', ['_ETHREAD']]],
    'StackTrace' : [ 0x4, ['array', 8, ['pointer', ['void']]]],
} ],
  '_TRIAGE_PNP_DEVICE_COMPLETION_QUEUE' : [ 0x8, {
    'DispatchedList' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_GENERIC_MAPPING' : [ 0x10, {
    'GenericRead' : [ 0x0, ['unsigned long']],
    'GenericWrite' : [ 0x4, ['unsigned long']],
    'GenericExecute' : [ 0x8, ['unsigned long']],
    'GenericAll' : [ 0xc, ['unsigned long']],
} ],
  '_OBJECT_HANDLE_COUNT_DATABASE' : [ 0xc, {
    'CountEntries' : [ 0x0, ['unsigned long']],
    'HandleCountEntries' : [ 0x4, ['array', 1, ['_OBJECT_HANDLE_COUNT_ENTRY']]],
} ],
  '_OWNER_ENTRY' : [ 0x8, {
    'OwnerThread' : [ 0x0, ['unsigned long']],
    'IoPriorityBoosted' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'OwnerReferenced' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'OwnerCount' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'TableSize' : [ 0x4, ['unsigned long']],
} ],
  '_ETIMER' : [ 0xb8, {
    'KeTimer' : [ 0x0, ['_KTIMER']],
    'Lock' : [ 0x28, ['unsigned long']],
    'TimerApc' : [ 0x2c, ['_KAPC']],
    'TimerDpc' : [ 0x5c, ['_KDPC']],
    'ActiveTimerListEntry' : [ 0x7c, ['_LIST_ENTRY']],
    'Period' : [ 0x84, ['unsigned long']],
    'TimerFlags' : [ 0x88, ['unsigned char']],
    'ApcAssociated' : [ 0x88, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'FlushDpcs' : [ 0x88, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Paused' : [ 0x88, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Spare1' : [ 0x88, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned char')]],
    'DueTimeType' : [ 0x89, ['unsigned char']],
    'Spare2' : [ 0x8a, ['unsigned short']],
    'WakeReason' : [ 0x8c, ['pointer', ['_DIAGNOSTIC_CONTEXT']]],
    'WakeTimerListEntry' : [ 0x90, ['_LIST_ENTRY']],
    'VirtualizedTimerCookie' : [ 0x98, ['pointer', ['void']]],
    'VirtualizedTimerLinks' : [ 0x9c, ['_LIST_ENTRY']],
    'DueTime' : [ 0xa8, ['unsigned long long']],
    'CoalescingWindow' : [ 0xb0, ['unsigned long']],
} ],
  '_OBJECT_DIRECTORY_ENTRY' : [ 0xc, {
    'ChainLink' : [ 0x0, ['pointer', ['_OBJECT_DIRECTORY_ENTRY']]],
    'Object' : [ 0x4, ['pointer', ['void']]],
    'HashValue' : [ 0x8, ['unsigned long']],
} ],
  '_LOCK_TRACKER' : [ 0x4c, {
    'LockTrackerNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'Mdl' : [ 0xc, ['pointer', ['_MDL']]],
    'StartVa' : [ 0x10, ['pointer', ['void']]],
    'Count' : [ 0x14, ['unsigned long']],
    'Offset' : [ 0x18, ['unsigned long']],
    'Length' : [ 0x1c, ['unsigned long']],
    'Page' : [ 0x20, ['unsigned long']],
    'StackTrace' : [ 0x24, ['array', 8, ['pointer', ['void']]]],
    'Who' : [ 0x44, ['unsigned long']],
    'Process' : [ 0x48, ['pointer', ['_EPROCESS']]],
} ],
  '_MI_CACHED_PTES' : [ 0x48, {
    'Bins' : [ 0x0, ['array', 8, ['_MI_CACHED_PTE']]],
    'CachedPteCount' : [ 0x40, ['long']],
} ],
  '_EXHANDLE' : [ 0x4, {
    'TagBits' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'Index' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'GenericHandleOverlay' : [ 0x0, ['pointer', ['void']]],
    'Value' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2119' : [ 0x4, {
    'Flags' : [ 0x0, ['_MMSECURE_FLAGS']],
    'FlagsLong' : [ 0x0, ['unsigned long']],
    'StartVa' : [ 0x0, ['pointer', ['void']]],
} ],
  '_MMADDRESS_LIST' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_2119']],
    'EndVa' : [ 0x4, ['pointer', ['void']]],
} ],
  '_EX_PUSH_LOCK_AUTO_EXPAND_STATE' : [ 0x4, {
    'Expanded' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Transitioning' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Pageable' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
} ],
  '_XSTATE_FEATURE' : [ 0x8, {
    'Offset' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
} ],
  '_DBGKD_CONTEXT_EX' : [ 0xc, {
    'Offset' : [ 0x0, ['unsigned long']],
    'ByteCount' : [ 0x4, ['unsigned long']],
    'BytesCopied' : [ 0x8, ['unsigned long']],
} ],
  '_CM_DIRTY_VECTOR_LOG' : [ 0x288, {
    'Next' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
    'Log' : [ 0x8, ['array', 16, ['_CM_DIRTY_VECTOR_LOG_ENTRY']]],
} ],
  '_ARBITER_INSTANCE' : [ 0xa8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'MutexEvent' : [ 0x4, ['pointer', ['_KEVENT']]],
    'Name' : [ 0x8, ['pointer', ['unsigned short']]],
    'OrderingName' : [ 0xc, ['pointer', ['unsigned short']]],
    'ResourceType' : [ 0x10, ['long']],
    'Allocation' : [ 0x14, ['pointer', ['_RTL_RANGE_LIST']]],
    'PossibleAllocation' : [ 0x18, ['pointer', ['_RTL_RANGE_LIST']]],
    'OrderingList' : [ 0x1c, ['_ARBITER_ORDERING_LIST']],
    'ReservedList' : [ 0x24, ['_ARBITER_ORDERING_LIST']],
    'ReferenceCount' : [ 0x2c, ['long']],
    'Interface' : [ 0x30, ['pointer', ['_ARBITER_INTERFACE']]],
    'AllocationStackMaxSize' : [ 0x34, ['unsigned long']],
    'AllocationStack' : [ 0x38, ['pointer', ['_ARBITER_ALLOCATION_STATE']]],
    'UnpackRequirement' : [ 0x3c, ['pointer', ['void']]],
    'PackResource' : [ 0x40, ['pointer', ['void']]],
    'UnpackResource' : [ 0x44, ['pointer', ['void']]],
    'ScoreRequirement' : [ 0x48, ['pointer', ['void']]],
    'TestAllocation' : [ 0x4c, ['pointer', ['void']]],
    'RetestAllocation' : [ 0x50, ['pointer', ['void']]],
    'CommitAllocation' : [ 0x54, ['pointer', ['void']]],
    'RollbackAllocation' : [ 0x58, ['pointer', ['void']]],
    'BootAllocation' : [ 0x5c, ['pointer', ['void']]],
    'QueryArbitrate' : [ 0x60, ['pointer', ['void']]],
    'QueryConflict' : [ 0x64, ['pointer', ['void']]],
    'AddReserved' : [ 0x68, ['pointer', ['void']]],
    'StartArbiter' : [ 0x6c, ['pointer', ['void']]],
    'PreprocessEntry' : [ 0x70, ['pointer', ['void']]],
    'AllocateEntry' : [ 0x74, ['pointer', ['void']]],
    'GetNextAllocationRange' : [ 0x78, ['pointer', ['void']]],
    'FindSuitableRange' : [ 0x7c, ['pointer', ['void']]],
    'AddAllocation' : [ 0x80, ['pointer', ['void']]],
    'BacktrackAllocation' : [ 0x84, ['pointer', ['void']]],
    'OverrideConflict' : [ 0x88, ['pointer', ['void']]],
    'InitializeRangeList' : [ 0x8c, ['pointer', ['void']]],
    'TransactionInProgress' : [ 0x90, ['unsigned char']],
    'TransactionEvent' : [ 0x94, ['pointer', ['_KEVENT']]],
    'Extension' : [ 0x98, ['pointer', ['void']]],
    'BusDeviceObject' : [ 0x9c, ['pointer', ['_DEVICE_OBJECT']]],
    'ConflictCallbackContext' : [ 0xa0, ['pointer', ['void']]],
    'ConflictCallback' : [ 0xa4, ['pointer', ['void']]],
} ],
  '_MMVAD_FLAGS1' : [ 0x4, {
    'CommitCharge' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'MemCommit' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_SYSTEM_INFORMATION' : [ 0x3cc0, {
    'Pools' : [ 0x0, ['_MI_POOL_STATE']],
    'Sections' : [ 0x500, ['_MI_SECTION_STATE']],
    'SystemImages' : [ 0x640, ['_MI_SYSTEM_IMAGE_STATE']],
    'Sessions' : [ 0x6ac, ['_MI_SESSION_STATE']],
    'Processes' : [ 0x16e8, ['_MI_PROCESS_STATE']],
    'Hardware' : [ 0x1758, ['_MI_HARDWARE_STATE']],
    'SystemVa' : [ 0x1800, ['_MI_SYSTEM_VA_STATE']],
    'PageCombines' : [ 0x2cc0, ['_MI_COMBINE_STATE']],
    'Partitions' : [ 0x2cd8, ['_MI_PARTITION_STATE']],
    'Shutdowns' : [ 0x2d10, ['_MI_SHUTDOWN_STATE']],
    'Errors' : [ 0x2d58, ['_MI_ERROR_STATE']],
    'AccessLog' : [ 0x2e00, ['_MI_ACCESS_LOG_STATE']],
    'Debugger' : [ 0x2e80, ['_MI_DEBUGGER_STATE']],
    'Standby' : [ 0x2f40, ['_MI_STANDBY_STATE']],
    'SystemPtes' : [ 0x2fc0, ['_MI_SYSTEM_PTE_STATE']],
    'IoPages' : [ 0x3140, ['_MI_IO_PAGE_STATE']],
    'PagingIo' : [ 0x3178, ['_MI_PAGING_IO_STATE']],
    'CommonPages' : [ 0x31b0, ['_MI_COMMON_PAGE_STATE']],
    'Trims' : [ 0x3200, ['_MI_SYSTEM_TRIM_STATE']],
    'ResTrack' : [ 0x3240, ['_MI_RESAVAIL_TRACKER']],
    'Cookie' : [ 0x3440, ['unsigned long']],
    'ZeroingDisabled' : [ 0x3444, ['long']],
    'BootRegistryRuns' : [ 0x3448, ['pointer', ['pointer', ['void']]]],
    'FullyInitialized' : [ 0x344c, ['unsigned char']],
    'SafeBooted' : [ 0x344d, ['unsigned char']],
    'LargePfnBitMap' : [ 0x3450, ['_RTL_BITMAP']],
    'PfnBitMap' : [ 0x3458, ['_RTL_BITMAP']],
    'TraceLogging' : [ 0x3460, ['pointer', ['_TlgProvider_t']]],
    'Vs' : [ 0x3480, ['_MI_VISIBLE_STATE']],
} ],
  '_KDEVICE_QUEUE_ENTRY' : [ 0x10, {
    'DeviceListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'SortKey' : [ 0x8, ['unsigned long']],
    'Inserted' : [ 0xc, ['unsigned char']],
} ],
  '_PPM_SELECTION_DEPENDENCY' : [ 0xc, {
    'Processor' : [ 0x0, ['unsigned long']],
    'Menu' : [ 0x4, ['_PPM_SELECTION_MENU']],
} ],
  '__unnamed_2193' : [ 0x4, {
    'UserData' : [ 0x0, ['unsigned long']],
    'Next' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2195' : [ 0x4, {
    'u' : [ 0x0, ['__unnamed_2193']],
} ],
  '__unnamed_2197' : [ 0x4, {
    'NewCell' : [ 0x0, ['__unnamed_2195']],
} ],
  '_HCELL' : [ 0x8, {
    'Size' : [ 0x0, ['long']],
    'u' : [ 0x4, ['__unnamed_2197']],
} ],
  '_MI_VISIBLE_STATE' : [ 0x840, {
    'SpecialPool' : [ 0x0, ['_MI_SPECIAL_POOL']],
    'SessionWsList' : [ 0x48, ['_LIST_ENTRY']],
    'SessionIdBitmap' : [ 0x50, ['pointer', ['_RTL_BITMAP']]],
    'PagedPoolInfo' : [ 0x54, ['_MM_PAGED_POOL_INFO']],
    'MaximumNonPagedPoolInPages' : [ 0x70, ['unsigned long']],
    'SizeOfPagedPoolInPages' : [ 0x74, ['unsigned long']],
    'SystemPteInfo' : [ 0x78, ['_MI_SYSTEM_PTE_TYPE']],
    'NonPagedPoolCommit' : [ 0xac, ['unsigned long']],
    'BootCommit' : [ 0xb0, ['unsigned long']],
    'MdlPagesAllocated' : [ 0xb4, ['unsigned long']],
    'SystemPageTableCommit' : [ 0xb8, ['unsigned long']],
    'SpecialPagesInUse' : [ 0xbc, ['unsigned long']],
    'WsOverheadPages' : [ 0xc0, ['unsigned long']],
    'VadBitmapPages' : [ 0xc4, ['unsigned long']],
    'ProcessCommit' : [ 0xc8, ['unsigned long']],
    'SharedCommit' : [ 0xcc, ['unsigned long']],
    'DriverCommit' : [ 0xd0, ['long']],
    'SystemWs' : [ 0x100, ['array', 3, ['_MMSUPPORT']]],
    'MapCacheFailures' : [ 0x280, ['unsigned long']],
    'PagefileHashPages' : [ 0x284, ['unsigned long']],
    'PteHeader' : [ 0x288, ['_SYSPTES_HEADER']],
    'SessionSpecialPool' : [ 0x314, ['pointer', ['_MI_SPECIAL_POOL']]],
    'SystemVaTypeCount' : [ 0x318, ['array', 15, ['unsigned long']]],
    'SystemVaType' : [ 0x354, ['array', 1024, ['unsigned char']]],
    'SystemVaTypeCountFailures' : [ 0x754, ['array', 15, ['unsigned long']]],
    'SystemVaTypeCountLimit' : [ 0x790, ['array', 15, ['unsigned long']]],
    'SystemVaTypeCountPeak' : [ 0x7cc, ['array', 15, ['unsigned long']]],
    'SystemAvailableVa' : [ 0x808, ['unsigned long']],
} ],
  '_WHEA_GENERIC_ERROR_DESCRIPTOR' : [ 0x34, {
    'Type' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned char']],
    'Enabled' : [ 0x3, ['unsigned char']],
    'ErrStatusBlockLength' : [ 0x4, ['unsigned long']],
    'RelatedErrorSourceId' : [ 0x8, ['unsigned long']],
    'ErrStatusAddressSpaceID' : [ 0xc, ['unsigned char']],
    'ErrStatusAddressBitWidth' : [ 0xd, ['unsigned char']],
    'ErrStatusAddressBitOffset' : [ 0xe, ['unsigned char']],
    'ErrStatusAddressAccessSize' : [ 0xf, ['unsigned char']],
    'ErrStatusAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'Notify' : [ 0x18, ['_WHEA_NOTIFICATION_DESCRIPTOR']],
} ],
  '_HMAP_TABLE' : [ 0x2800, {
    'Table' : [ 0x0, ['array', 512, ['_HMAP_ENTRY']]],
} ],
  '_SEP_LOWBOX_HANDLES_ENTRY' : [ 0x1c, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'ReferenceCount' : [ 0xc, ['long']],
    'PackageSid' : [ 0x10, ['pointer', ['void']]],
    'HandleCount' : [ 0x14, ['unsigned long']],
    'Handles' : [ 0x18, ['pointer', ['pointer', ['void']]]],
} ],
  '_PROC_PERF_CONSTRAINT' : [ 0x50, {
    'Prcb' : [ 0x0, ['pointer', ['_KPRCB']]],
    'PerfContext' : [ 0x4, ['unsigned long']],
    'ProcCap' : [ 0x8, ['unsigned long']],
    'ProcFloor' : [ 0xc, ['unsigned long']],
    'PlatformCap' : [ 0x10, ['unsigned long']],
    'ThermalCap' : [ 0x14, ['unsigned long']],
    'LimitReasons' : [ 0x18, ['unsigned long']],
    'PlatformCapStartTime' : [ 0x20, ['unsigned long long']],
    'TargetPercent' : [ 0x28, ['unsigned long']],
    'SelectedPercent' : [ 0x2c, ['unsigned long']],
    'SelectedFrequency' : [ 0x30, ['unsigned long']],
    'PreviousFrequency' : [ 0x34, ['unsigned long']],
    'PreviousPercent' : [ 0x38, ['unsigned long']],
    'LatestFrequencyPercent' : [ 0x3c, ['unsigned long']],
    'SelectedState' : [ 0x40, ['unsigned long long']],
    'Force' : [ 0x48, ['unsigned char']],
} ],
  '__unnamed_21b4' : [ 0x10, {
    'CallerCompletion' : [ 0x0, ['pointer', ['void']]],
    'CallerContext' : [ 0x4, ['pointer', ['void']]],
    'CallerDevice' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'SystemWake' : [ 0xc, ['unsigned char']],
} ],
  '__unnamed_21b7' : [ 0x8, {
    'NotifyDevice' : [ 0x0, ['pointer', ['_PO_DEVICE_NOTIFY']]],
    'FxDeviceActivated' : [ 0x4, ['unsigned char']],
} ],
  '_POP_IRP_DATA' : [ 0x90, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x8, ['pointer', ['_IRP']]],
    'Pdo' : [ 0xc, ['pointer', ['_DEVICE_OBJECT']]],
    'TargetDevice' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'CurrentDevice' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
    'WatchdogStart' : [ 0x18, ['unsigned long long']],
    'WatchdogTimer' : [ 0x20, ['_KTIMER']],
    'WatchdogDpc' : [ 0x48, ['_KDPC']],
    'MinorFunction' : [ 0x68, ['unsigned char']],
    'PowerStateType' : [ 0x6c, ['Enumeration', dict(target = 'long', choices = {0: 'SystemPowerState', 1: 'DevicePowerState'})]],
    'PowerState' : [ 0x70, ['_POWER_STATE']],
    'WatchdogEnabled' : [ 0x74, ['unsigned char']],
    'FxDevice' : [ 0x78, ['pointer', ['_POP_FX_DEVICE']]],
    'SystemTransition' : [ 0x7c, ['unsigned char']],
    'NotifyPEP' : [ 0x7d, ['unsigned char']],
    'Device' : [ 0x80, ['__unnamed_21b4']],
    'System' : [ 0x80, ['__unnamed_21b7']],
} ],
  '_MI_ERROR_STATE' : [ 0xa8, {
    'BadMemoryEventEntry' : [ 0x0, ['_MI_BAD_MEMORY_EVENT_ENTRY']],
    'ProbeRaises' : [ 0x28, ['_MI_PROBE_RAISE_TRACKER']],
    'ForcedCommits' : [ 0x68, ['_MI_FORCED_COMMITS']],
    'WsleFailures' : [ 0x70, ['array', 2, ['unsigned long']]],
    'WsLinear' : [ 0x78, ['unsigned long']],
    'PageHashErrors' : [ 0x7c, ['unsigned long']],
    'CheckZeroCount' : [ 0x80, ['unsigned long']],
    'ZeroedPageSingleBitErrorsDetected' : [ 0x84, ['long']],
    'BadPagesDetected' : [ 0x88, ['long']],
    'ScrubPasses' : [ 0x8c, ['long']],
    'ScrubBadPagesFound' : [ 0x90, ['long']],
    'UserViewFailures' : [ 0x94, ['unsigned long']],
    'UserViewCollisionFailures' : [ 0x98, ['unsigned long']],
    'ResavailFailures' : [ 0x9c, ['_MI_RESAVAIL_FAILURES']],
    'PendingBadPages' : [ 0xa4, ['unsigned char']],
    'InitFailure' : [ 0xa5, ['unsigned char']],
    'StopBadMaps' : [ 0xa6, ['unsigned char']],
} ],
  '_IMAGE_DATA_DIRECTORY' : [ 0x8, {
    'VirtualAddress' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
} ],
  '_DEVICE_CAPABILITIES' : [ 0x40, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'DeviceD1' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DeviceD2' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LockSupported' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'EjectSupported' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Removable' : [ 0x4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'DockDevice' : [ 0x4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'UniqueID' : [ 0x4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'SilentInstall' : [ 0x4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'RawDeviceOK' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'SurpriseRemovalOK' : [ 0x4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'WakeFromD0' : [ 0x4, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'WakeFromD1' : [ 0x4, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'WakeFromD2' : [ 0x4, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'WakeFromD3' : [ 0x4, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'HardwareDisabled' : [ 0x4, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'NonDynamic' : [ 0x4, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'WarmEjectSupported' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'NoDisplayInUI' : [ 0x4, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'Reserved1' : [ 0x4, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'WakeFromInterrupt' : [ 0x4, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'Reserved' : [ 0x4, ['BitField', dict(start_bit = 20, end_bit = 32, native_type='unsigned long')]],
    'Address' : [ 0x8, ['unsigned long']],
    'UINumber' : [ 0xc, ['unsigned long']],
    'DeviceState' : [ 0x10, ['array', -28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]]],
    'SystemWake' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DeviceWake' : [ 0x30, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
    'D1Latency' : [ 0x34, ['unsigned long']],
    'D2Latency' : [ 0x38, ['unsigned long']],
    'D3Latency' : [ 0x3c, ['unsigned long']],
} ],
  '_MI_USER_VA_INFO' : [ 0xd48, {
    'NumberOfCommittedPageTables' : [ 0x0, ['unsigned long']],
    'HighestTopDownAllocationAddress' : [ 0x4, ['pointer', ['void']]],
    'VadCell' : [ 0x8, ['array', 2, ['_MI_VAD_ALLOCATION_CELL']]],
    'VadBitMapCommitment' : [ 0x40, ['unsigned long']],
    'MaximumLastVadBit' : [ 0x44, ['unsigned long']],
    'VadsBeingDeleted' : [ 0x48, ['long']],
    'NumberOfDebugEnclaves' : [ 0x4c, ['long']],
    'PhysicalMappingCount' : [ 0x50, ['unsigned long']],
    'LastVadDeletionEvent' : [ 0x54, ['pointer', ['_KEVENT']]],
    'SubVadRanges' : [ 0x58, ['array', 1, ['_LIST_ENTRY']]],
    'NumaAware' : [ 0x60, ['unsigned char']],
    'CloneNestingLevel' : [ 0x68, ['unsigned long long']],
    'PrivateFixupVadCount' : [ 0x70, ['unsigned long']],
    'CfgBitMap' : [ 0x74, ['array', 1, ['_MI_CFG_BITMAP_INFO']]],
    'CommittedPageTableBufferForTopLevel' : [ 0x80, ['array', 48, ['unsigned long']]],
    'CommittedPageTableBitmaps' : [ 0x140, ['array', 1, ['_RTL_BITMAP']]],
    'UsedPageTableEntries' : [ 0x148, ['array', 1536, ['unsigned short']]],
} ],
  '_PROC_FEEDBACK' : [ 0x88, {
    'Lock' : [ 0x0, ['unsigned long']],
    'CyclesLast' : [ 0x8, ['unsigned long long']],
    'CyclesActive' : [ 0x10, ['unsigned long long']],
    'Counters' : [ 0x18, ['array', 2, ['pointer', ['_PROC_FEEDBACK_COUNTER']]]],
    'LastUpdateTime' : [ 0x20, ['unsigned long long']],
    'UnscaledTime' : [ 0x28, ['unsigned long long']],
    'UnaccountedTime' : [ 0x30, ['long long']],
    'ScaledTime' : [ 0x38, ['array', 2, ['unsigned long long']]],
    'UnaccountedKernelTime' : [ 0x48, ['unsigned long long']],
    'PerformanceScaledKernelTime' : [ 0x50, ['unsigned long long']],
    'UserTimeLast' : [ 0x58, ['unsigned long']],
    'KernelTimeLast' : [ 0x5c, ['unsigned long']],
    'IdleGenerationNumberLast' : [ 0x60, ['unsigned long long']],
    'HvActiveTimeLast' : [ 0x68, ['unsigned long long']],
    'StallCyclesLast' : [ 0x70, ['unsigned long long']],
    'StallTime' : [ 0x78, ['unsigned long long']],
    'KernelTimesIndex' : [ 0x80, ['unsigned char']],
} ],
  '_MI_PAGEFILE_BITMAPS_CACHE_ENTRY' : [ 0x20, {
    'LengthTreeNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'LocationTreeNode' : [ 0xc, ['_RTL_BALANCED_NODE']],
    'StartingIndex' : [ 0x18, ['unsigned long']],
    'Length' : [ 0x1c, ['unsigned long']],
} ],
  '__unnamed_21d7' : [ 0x18, {
    'Length' : [ 0x0, ['unsigned long']],
    'Alignment' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_21db' : [ 0x14, {
    'MinimumVector' : [ 0x0, ['unsigned long']],
    'MaximumVector' : [ 0x4, ['unsigned long']],
    'AffinityPolicy' : [ 0x8, ['unsigned short']],
    'Group' : [ 0xa, ['unsigned short']],
    'PriorityPolicy' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'IrqPriorityUndefined', 1: 'IrqPriorityLow', 2: 'IrqPriorityNormal', 3: 'IrqPriorityHigh'})]],
    'TargetedProcessors' : [ 0x10, ['unsigned long']],
} ],
  '__unnamed_21dd' : [ 0x8, {
    'MinimumChannel' : [ 0x0, ['unsigned long']],
    'MaximumChannel' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_21df' : [ 0x10, {
    'RequestLine' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'Channel' : [ 0x8, ['unsigned long']],
    'TransferWidth' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_21e1' : [ 0xc, {
    'Data' : [ 0x0, ['array', 3, ['unsigned long']]],
} ],
  '__unnamed_21e3' : [ 0x10, {
    'Length' : [ 0x0, ['unsigned long']],
    'MinBusNumber' : [ 0x4, ['unsigned long']],
    'MaxBusNumber' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_21e5' : [ 0xc, {
    'Priority' : [ 0x0, ['unsigned long']],
    'Reserved1' : [ 0x4, ['unsigned long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_21e7' : [ 0x18, {
    'Length40' : [ 0x0, ['unsigned long']],
    'Alignment40' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_21e9' : [ 0x18, {
    'Length48' : [ 0x0, ['unsigned long']],
    'Alignment48' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_21eb' : [ 0x18, {
    'Length64' : [ 0x0, ['unsigned long']],
    'Alignment64' : [ 0x4, ['unsigned long']],
    'MinimumAddress' : [ 0x8, ['_LARGE_INTEGER']],
    'MaximumAddress' : [ 0x10, ['_LARGE_INTEGER']],
} ],
  '__unnamed_21ed' : [ 0xc, {
    'Class' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x1, ['unsigned char']],
    'Reserved1' : [ 0x2, ['unsigned char']],
    'Reserved2' : [ 0x3, ['unsigned char']],
    'IdLowPart' : [ 0x4, ['unsigned long']],
    'IdHighPart' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_21ef' : [ 0x18, {
    'Port' : [ 0x0, ['__unnamed_21d7']],
    'Memory' : [ 0x0, ['__unnamed_21d7']],
    'Interrupt' : [ 0x0, ['__unnamed_21db']],
    'Dma' : [ 0x0, ['__unnamed_21dd']],
    'DmaV3' : [ 0x0, ['__unnamed_21df']],
    'Generic' : [ 0x0, ['__unnamed_21d7']],
    'DevicePrivate' : [ 0x0, ['__unnamed_21e1']],
    'BusNumber' : [ 0x0, ['__unnamed_21e3']],
    'ConfigData' : [ 0x0, ['__unnamed_21e5']],
    'Memory40' : [ 0x0, ['__unnamed_21e7']],
    'Memory48' : [ 0x0, ['__unnamed_21e9']],
    'Memory64' : [ 0x0, ['__unnamed_21eb']],
    'Connection' : [ 0x0, ['__unnamed_21ed']],
} ],
  '_IO_RESOURCE_DESCRIPTOR' : [ 0x20, {
    'Option' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x1, ['unsigned char']],
    'ShareDisposition' : [ 0x2, ['unsigned char']],
    'Spare1' : [ 0x3, ['unsigned char']],
    'Flags' : [ 0x4, ['unsigned short']],
    'Spare2' : [ 0x6, ['unsigned short']],
    'u' : [ 0x8, ['__unnamed_21ef']],
} ],
  '_POP_THERMAL_ZONE' : [ 0x2c0, {
    'PolicyDevice' : [ 0x0, ['_POP_POLICY_DEVICE']],
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'PolicyDeviceSystemButton', 1: 'PolicyDeviceThermalZone', 2: 'PolicyDeviceBattery', 3: 'PolicyDeviceMemory', 4: 'PolicyInitiatePowerActionAPI', 5: 'PolicySetPowerStateAPI', 6: 'PolicyImmediateDozeS4', 7: 'PolicySystemIdle', 8: 'PolicyDeviceWakeAlarm', 9: 'PolicyDeviceFan', 10: 'PolicyCsBatterySaver', 11: 'PolicyImmediateDozeS4Predicted', 12: 'PolicyImmediateDozeS4PredictedNoWake', 13: 'PolicyDeviceMax'})]],
    'Notification' : [ 0xc, ['pointer', ['void']]],
    'Name' : [ 0x10, ['_UNICODE_STRING']],
    'Device' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'Irp' : [ 0x1c, ['pointer', ['_IRP']]],
    'State' : [ 0x20, ['unsigned char']],
    'Flags' : [ 0x21, ['unsigned char']],
    'Removing' : [ 0x22, ['unsigned char']],
    'Mode' : [ 0x23, ['unsigned char']],
    'PendingMode' : [ 0x24, ['unsigned char']],
    'ActivePoint' : [ 0x25, ['unsigned char']],
    'PendingActivePoint' : [ 0x26, ['unsigned char']],
    'Critical' : [ 0x27, ['unsigned char']],
    'ThermalStandby' : [ 0x28, ['unsigned char']],
    'OverThrottled' : [ 0x29, ['unsigned char']],
    'HighPrecisionThrottle' : [ 0x2c, ['long']],
    'Throttle' : [ 0x30, ['long']],
    'PendingThrottle' : [ 0x34, ['long']],
    'ThrottleReasons' : [ 0x38, ['unsigned long']],
    'LastTime' : [ 0x40, ['unsigned long long']],
    'SampleRate' : [ 0x48, ['unsigned long']],
    'LastTemp' : [ 0x4c, ['unsigned long']],
    'PassiveTimer' : [ 0x50, ['_KTIMER']],
    'PassiveDpc' : [ 0x78, ['_KDPC']],
    'Info' : [ 0x98, ['_THERMAL_INFORMATION_EX']],
    'InfoLastUpdateTime' : [ 0xf0, ['_LARGE_INTEGER']],
    'Policy' : [ 0xf8, ['_THERMAL_POLICY']],
    'PolicyDriver' : [ 0x110, ['unsigned char']],
    'LastActiveStartTime' : [ 0x118, ['unsigned long long']],
    'LastPassiveStartTime' : [ 0x120, ['unsigned long long']],
    'WorkItem' : [ 0x128, ['_WORK_QUEUE_ITEM']],
    'Lock' : [ 0x138, ['_POP_RW_LOCK']],
    'ZoneStopped' : [ 0x140, ['_KEVENT']],
    'TemperatureUpdated' : [ 0x150, ['_KEVENT']],
    'InstanceId' : [ 0x160, ['unsigned long']],
    'TelemetryTracker' : [ 0x168, ['_POP_THERMAL_TELEMETRY_TRACKER']],
    'Description' : [ 0x2b8, ['_UNICODE_STRING']],
} ],
  '_MMPTE_LIST' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'OneEntry' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'filler0' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'filler1' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long long')]],
    'NextEntry' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_VI_POOL_PAGE_HEADER' : [ 0xc, {
    'NextPage' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'VerifierEntry' : [ 0x4, ['pointer', ['void']]],
    'Signature' : [ 0x8, ['unsigned long']],
} ],
  '_MI_REBUILD_LARGE_PAGES' : [ 0x34, {
    'Active' : [ 0x0, ['long']],
    'Timer' : [ 0x4, ['array', 16, ['array', 1, ['_MI_REBUILD_LARGE_PAGE_COUNTDOWN']]]],
    'WorkItem' : [ 0x24, ['_WORK_QUEUE_ITEM']],
} ],
  '_HANDLE_TRACE_DEBUG_INFO' : [ 0x80, {
    'RefCount' : [ 0x0, ['long']],
    'TableSize' : [ 0x4, ['unsigned long']],
    'BitMaskFlags' : [ 0x8, ['unsigned long']],
    'CloseCompactionLock' : [ 0xc, ['_FAST_MUTEX']],
    'CurrentStackIndex' : [ 0x2c, ['unsigned long']],
    'TraceDb' : [ 0x30, ['array', 1, ['_HANDLE_TRACE_DB_ENTRY']]],
} ],
  '_HHIVE' : [ 0x6f0, {
    'Signature' : [ 0x0, ['unsigned long']],
    'GetCellRoutine' : [ 0x4, ['pointer', ['void']]],
    'ReleaseCellRoutine' : [ 0x8, ['pointer', ['void']]],
    'Allocate' : [ 0xc, ['pointer', ['void']]],
    'Free' : [ 0x10, ['pointer', ['void']]],
    'FileWrite' : [ 0x14, ['pointer', ['void']]],
    'FileRead' : [ 0x18, ['pointer', ['void']]],
    'HiveLoadFailure' : [ 0x1c, ['pointer', ['void']]],
    'BaseBlock' : [ 0x20, ['pointer', ['_HBASE_BLOCK']]],
    'DirtyVector' : [ 0x24, ['_RTL_BITMAP']],
    'DirtyCount' : [ 0x2c, ['unsigned long']],
    'DirtyAlloc' : [ 0x30, ['unsigned long']],
    'UnreconciledVector' : [ 0x34, ['_RTL_BITMAP']],
    'UnreconciledCount' : [ 0x3c, ['unsigned long']],
    'BaseBlockAlloc' : [ 0x40, ['unsigned long']],
    'Cluster' : [ 0x44, ['unsigned long']],
    'Flat' : [ 0x48, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ReadOnly' : [ 0x48, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'SystemCacheBacked' : [ 0x48, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Reserved' : [ 0x48, ['BitField', dict(start_bit = 3, end_bit = 8, native_type='unsigned char')]],
    'DirtyFlag' : [ 0x49, ['unsigned char']],
    'HvBinHeadersUse' : [ 0x4c, ['unsigned long']],
    'HvFreeCellsUse' : [ 0x50, ['unsigned long']],
    'HvUsedCellsUse' : [ 0x54, ['unsigned long']],
    'CmUsedCellsUse' : [ 0x58, ['unsigned long']],
    'HiveFlags' : [ 0x5c, ['unsigned long']],
    'CurrentLog' : [ 0x60, ['unsigned long']],
    'CurrentLogSequence' : [ 0x64, ['unsigned long']],
    'CurrentLogMinimumSequence' : [ 0x68, ['unsigned long']],
    'CurrentLogOffset' : [ 0x6c, ['unsigned long']],
    'MinimumLogSequence' : [ 0x70, ['unsigned long']],
    'LogFileSizeCap' : [ 0x74, ['unsigned long']],
    'LogDataPresent' : [ 0x78, ['array', 2, ['unsigned char']]],
    'PrimaryFileValid' : [ 0x7a, ['unsigned char']],
    'BaseBlockDirty' : [ 0x7b, ['unsigned char']],
    'LastLogSwapTime' : [ 0x80, ['_LARGE_INTEGER']],
    'FirstLogFile' : [ 0x88, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned short')]],
    'SecondLogFile' : [ 0x88, ['BitField', dict(start_bit = 3, end_bit = 6, native_type='unsigned short')]],
    'HeaderRecovered' : [ 0x88, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'LegacyRecoveryIndicated' : [ 0x88, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned short')]],
    'RecoveryInformationReserved' : [ 0x88, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned short')]],
    'RecoveryInformation' : [ 0x88, ['unsigned short']],
    'LogEntriesRecovered' : [ 0x8a, ['array', 2, ['unsigned char']]],
    'RefreshCount' : [ 0x8c, ['unsigned long']],
    'StorageTypeCount' : [ 0x90, ['unsigned long']],
    'Version' : [ 0x94, ['unsigned long']],
    'ViewMap' : [ 0x98, ['_HVIEW_MAP']],
    'Storage' : [ 0x3b8, ['array', 2, ['_DUAL']]],
} ],
  '_WHEA_XPF_NMI_DESCRIPTOR' : [ 0x3, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
} ],
  '_ETW_FILTER_HEADER' : [ 0x24, {
    'FilterFlags' : [ 0x0, ['long']],
    'PidFilter' : [ 0x4, ['pointer', ['_ETW_FILTER_PID']]],
    'ExeFilter' : [ 0x8, ['pointer', ['_ETW_FILTER_STRING_TOKEN']]],
    'PkgIdFilter' : [ 0xc, ['pointer', ['_ETW_FILTER_STRING_TOKEN']]],
    'PkgAppIdFilter' : [ 0x10, ['pointer', ['_ETW_FILTER_STRING_TOKEN']]],
    'StackWalkFilter' : [ 0x14, ['pointer', ['_ETW_PERFECT_HASH_FUNCTION']]],
    'EventIdFilter' : [ 0x18, ['pointer', ['_ETW_PERFECT_HASH_FUNCTION']]],
    'PayloadFilter' : [ 0x1c, ['pointer', ['_ETW_PAYLOAD_FILTER']]],
    'ProviderSideFilter' : [ 0x20, ['pointer', ['_EVENT_FILTER_HEADER']]],
} ],
  '_CM_WORKITEM' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Private' : [ 0x8, ['unsigned long']],
    'WorkerRoutine' : [ 0xc, ['pointer', ['void']]],
    'Parameter' : [ 0x10, ['pointer', ['void']]],
} ],
  '_ETW_PAYLOAD_FILTER' : [ 0x58, {
    'RefCount' : [ 0x0, ['long']],
    'PayloadFilter' : [ 0x8, ['_AGGREGATED_PAYLOAD_FILTER']],
} ],
  '_CM_TRANS' : [ 0x68, {
    'TransactionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'KCBUoWListHead' : [ 0x8, ['_LIST_ENTRY']],
    'LazyCommitListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'KtmTrans' : [ 0x18, ['pointer', ['void']]],
    'CmRm' : [ 0x1c, ['pointer', ['_CM_RM']]],
    'KtmEnlistmentObject' : [ 0x20, ['pointer', ['_KENLISTMENT']]],
    'KtmEnlistmentHandle' : [ 0x24, ['pointer', ['void']]],
    'KtmUow' : [ 0x28, ['_GUID']],
    'StartLsn' : [ 0x38, ['unsigned long long']],
    'TransState' : [ 0x40, ['unsigned long']],
    'HiveCount' : [ 0x44, ['unsigned long']],
    'HiveArray' : [ 0x48, ['array', 7, ['pointer', ['_CMHIVE']]]],
} ],
  '_WHEA_ERROR_RECORD_HEADER_VALIDBITS' : [ 0x4, {
    'PlatformId' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Timestamp' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PartitionId' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_CM_PARTIAL_RESOURCE_LIST' : [ 0x18, {
    'Version' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'Count' : [ 0x4, ['unsigned long']],
    'PartialDescriptors' : [ 0x8, ['array', 1, ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_RTL_RANGE_LIST' : [ 0x14, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Flags' : [ 0x8, ['unsigned long']],
    'Count' : [ 0xc, ['unsigned long']],
    'Stamp' : [ 0x10, ['unsigned long']],
} ],
  '_RTL_TIME_ZONE_INFORMATION' : [ 0xac, {
    'Bias' : [ 0x0, ['long']],
    'StandardName' : [ 0x4, ['array', 32, ['wchar']]],
    'StandardStart' : [ 0x44, ['_TIME_FIELDS']],
    'StandardBias' : [ 0x54, ['long']],
    'DaylightName' : [ 0x58, ['array', 32, ['wchar']]],
    'DaylightStart' : [ 0x98, ['_TIME_FIELDS']],
    'DaylightBias' : [ 0xa8, ['long']],
} ],
  '_POP_THERMAL_TELEMETRY_TRACKER' : [ 0x150, {
    'AccountingDisabled' : [ 0x0, ['unsigned char']],
    'LastPassiveUpdateTime' : [ 0x8, ['unsigned long long']],
    'TotalPassiveTime' : [ 0x10, ['array', 20, ['unsigned long long']]],
    'PassiveTimeSnap' : [ 0xb0, ['array', 20, ['unsigned long long']]],
} ],
  '_OBJECT_CREATE_INFORMATION' : [ 0x2c, {
    'Attributes' : [ 0x0, ['unsigned long']],
    'RootDirectory' : [ 0x4, ['pointer', ['void']]],
    'ProbeMode' : [ 0x8, ['unsigned char']],
    'PagedPoolCharge' : [ 0xc, ['unsigned long']],
    'NonPagedPoolCharge' : [ 0x10, ['unsigned long']],
    'SecurityDescriptorCharge' : [ 0x14, ['unsigned long']],
    'SecurityDescriptor' : [ 0x18, ['pointer', ['void']]],
    'SecurityQos' : [ 0x1c, ['pointer', ['_SECURITY_QUALITY_OF_SERVICE']]],
    'SecurityQualityOfService' : [ 0x20, ['_SECURITY_QUALITY_OF_SERVICE']],
} ],
  '_HVIEW_MAP' : [ 0x320, {
    'MappedLength' : [ 0x0, ['unsigned long']],
    'Lock' : [ 0x4, ['_EX_PUSH_LOCK']],
    'FileObject' : [ 0x8, ['pointer', ['_FILE_OBJECT']]],
    'Directory' : [ 0xc, ['pointer', ['_HVIEW_MAP_DIRECTORY']]],
    'PagesCharged' : [ 0x10, ['unsigned long']],
    'PinLog' : [ 0x18, ['_HVIEW_MAP_PIN_LOG']],
} ],
  '_TRACE_ENABLE_INFO' : [ 0x20, {
    'IsEnabled' : [ 0x0, ['unsigned long']],
    'Level' : [ 0x4, ['unsigned char']],
    'Reserved1' : [ 0x5, ['unsigned char']],
    'LoggerId' : [ 0x6, ['unsigned short']],
    'EnableProperty' : [ 0x8, ['unsigned long']],
    'Reserved2' : [ 0xc, ['unsigned long']],
    'MatchAnyKeyword' : [ 0x10, ['unsigned long long']],
    'MatchAllKeyword' : [ 0x18, ['unsigned long long']],
} ],
  '_DISALLOWED_GUIDS' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned short']],
    'Guids' : [ 0x4, ['pointer', ['_GUID']]],
} ],
  '_HVIEW_MAP_DIRECTORY' : [ 0x200, {
    'Tables' : [ 0x0, ['array', 128, ['pointer', ['_HVIEW_MAP_TABLE']]]],
} ],
  '_PO_DIAG_STACK_RECORD' : [ 0x8, {
    'StackDepth' : [ 0x0, ['unsigned long']],
    'Stack' : [ 0x4, ['array', 1, ['pointer', ['void']]]],
} ],
  '_SECTION_OBJECT_POINTERS' : [ 0xc, {
    'DataSectionObject' : [ 0x0, ['pointer', ['void']]],
    'SharedCacheMap' : [ 0x4, ['pointer', ['void']]],
    'ImageSectionObject' : [ 0x8, ['pointer', ['void']]],
} ],
  '_VF_BTS_DATA_MANAGEMENT_AREA' : [ 0x34, {
    'BTSBufferBase' : [ 0x0, ['pointer', ['void']]],
    'BTSIndex' : [ 0x4, ['pointer', ['void']]],
    'BTSMax' : [ 0x8, ['pointer', ['void']]],
    'BTSInterruptThreshold' : [ 0xc, ['pointer', ['void']]],
    'PEBSBufferBase' : [ 0x10, ['pointer', ['void']]],
    'PEBSIndex' : [ 0x14, ['pointer', ['void']]],
    'PEBSMax' : [ 0x18, ['pointer', ['void']]],
    'PEBSInterruptThreshold' : [ 0x1c, ['pointer', ['void']]],
    'PEBSCounterReset' : [ 0x20, ['array', 2, ['pointer', ['void']]]],
    'Reserved' : [ 0x28, ['array', 12, ['unsigned char']]],
} ],
  '_FLOATING_SAVE_AREA' : [ 0x70, {
    'ControlWord' : [ 0x0, ['unsigned long']],
    'StatusWord' : [ 0x4, ['unsigned long']],
    'TagWord' : [ 0x8, ['unsigned long']],
    'ErrorOffset' : [ 0xc, ['unsigned long']],
    'ErrorSelector' : [ 0x10, ['unsigned long']],
    'DataOffset' : [ 0x14, ['unsigned long']],
    'DataSelector' : [ 0x18, ['unsigned long']],
    'RegisterArea' : [ 0x1c, ['array', 80, ['unsigned char']]],
    'Spare0' : [ 0x6c, ['unsigned long']],
} ],
  '_SEP_AUDIT_POLICY' : [ 0x1f, {
    'AdtTokenPolicy' : [ 0x0, ['_TOKEN_AUDIT_POLICY']],
    'PolicySetStatus' : [ 0x1e, ['unsigned char']],
} ],
  '__unnamed_226c' : [ 0x4, {
    'SnapSharedExportsFailed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_226e' : [ 0x10, {
    'AllSharedExportThunks' : [ 0x0, ['_VF_TARGET_ALL_SHARED_EXPORT_THUNKS']],
    'Flags' : [ 0x0, ['__unnamed_226c']],
} ],
  '_VF_TARGET_DRIVER' : [ 0x1c, {
    'TreeNode' : [ 0x0, ['_VF_AVL_TREE_NODE']],
    'u1' : [ 0x8, ['__unnamed_226e']],
    'VerifiedData' : [ 0x18, ['pointer', ['_VF_TARGET_VERIFIED_DRIVER_DATA']]],
} ],
  '_RTL_BITMAP' : [ 0x8, {
    'SizeOfBitMap' : [ 0x0, ['unsigned long']],
    'Buffer' : [ 0x4, ['pointer', ['unsigned long']]],
} ],
  '__unnamed_2279' : [ 0x14, {
    'ClassGuid' : [ 0x0, ['_GUID']],
    'SymbolicLinkName' : [ 0x10, ['array', 1, ['wchar']]],
} ],
  '__unnamed_227b' : [ 0x2, {
    'DeviceId' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_227d' : [ 0x8, {
    'NotificationStructure' : [ 0x0, ['pointer', ['void']]],
    'DeviceId' : [ 0x4, ['array', 1, ['wchar']]],
} ],
  '__unnamed_227f' : [ 0x4, {
    'Notification' : [ 0x0, ['pointer', ['void']]],
} ],
  '__unnamed_2281' : [ 0x8, {
    'NotificationCode' : [ 0x0, ['unsigned long']],
    'NotificationData' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2283' : [ 0x8, {
    'VetoType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PNP_VetoTypeUnknown', 1: 'PNP_VetoLegacyDevice', 2: 'PNP_VetoPendingClose', 3: 'PNP_VetoWindowsApp', 4: 'PNP_VetoWindowsService', 5: 'PNP_VetoOutstandingOpen', 6: 'PNP_VetoDevice', 7: 'PNP_VetoDriver', 8: 'PNP_VetoIllegalDeviceRequest', 9: 'PNP_VetoInsufficientPower', 10: 'PNP_VetoNonDisableable', 11: 'PNP_VetoLegacyDriver', 12: 'PNP_VetoInsufficientRights'})]],
    'DeviceIdVetoNameBuffer' : [ 0x4, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2285' : [ 0x10, {
    'BlockedDriverGuid' : [ 0x0, ['_GUID']],
} ],
  '__unnamed_2287' : [ 0x2, {
    'ParentId' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '__unnamed_2289' : [ 0x20, {
    'PowerSettingGuid' : [ 0x0, ['_GUID']],
    'Flags' : [ 0x10, ['unsigned long']],
    'SessionId' : [ 0x14, ['unsigned long']],
    'DataLength' : [ 0x18, ['unsigned long']],
    'Data' : [ 0x1c, ['array', 1, ['unsigned char']]],
} ],
  '__unnamed_228b' : [ 0x20, {
    'DeviceClass' : [ 0x0, ['__unnamed_2279']],
    'TargetDevice' : [ 0x0, ['__unnamed_227b']],
    'InstallDevice' : [ 0x0, ['__unnamed_227b']],
    'CustomNotification' : [ 0x0, ['__unnamed_227d']],
    'ProfileNotification' : [ 0x0, ['__unnamed_227f']],
    'PowerNotification' : [ 0x0, ['__unnamed_2281']],
    'VetoNotification' : [ 0x0, ['__unnamed_2283']],
    'BlockedDriverNotification' : [ 0x0, ['__unnamed_2285']],
    'InvalidIDNotification' : [ 0x0, ['__unnamed_2287']],
    'PowerSettingNotification' : [ 0x0, ['__unnamed_2289']],
    'PropertyChangeNotification' : [ 0x0, ['__unnamed_227b']],
    'DeviceInstanceNotification' : [ 0x0, ['__unnamed_227b']],
} ],
  '_PLUGPLAY_EVENT_BLOCK' : [ 0x44, {
    'EventGuid' : [ 0x0, ['_GUID']],
    'EventCategory' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'HardwareProfileChangeEvent', 1: 'TargetDeviceChangeEvent', 2: 'DeviceClassChangeEvent', 3: 'CustomDeviceEvent', 4: 'DeviceInstallEvent', 5: 'DeviceArrivalEvent', 6: 'VetoEvent', 7: 'BlockedDriverEvent', 8: 'InvalidIDEvent', 9: 'DevicePropertyChangeEvent', 10: 'DeviceInstanceRemovalEvent', 11: 'DeviceInstanceStartedEvent', 12: 'MaxPlugEventCategory'})]],
    'Result' : [ 0x14, ['pointer', ['unsigned long']]],
    'Flags' : [ 0x18, ['unsigned long']],
    'TotalSize' : [ 0x1c, ['unsigned long']],
    'DeviceObject' : [ 0x20, ['pointer', ['void']]],
    'u' : [ 0x24, ['__unnamed_228b']],
} ],
  '_VF_SUSPECT_DRIVER_ENTRY' : [ 0x18, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'Loads' : [ 0x8, ['unsigned long']],
    'Unloads' : [ 0xc, ['unsigned long']],
    'BaseName' : [ 0x10, ['_UNICODE_STRING']],
} ],
  '_MMPTE_TIMESTAMP' : [ 0x8, {
    'MustBeZero' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PageFileLow' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long long')]],
    'GlobalTimeStamp' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_SID_AND_ATTRIBUTES_HASH' : [ 0x88, {
    'SidCount' : [ 0x0, ['unsigned long']],
    'SidAttr' : [ 0x4, ['pointer', ['_SID_AND_ATTRIBUTES']]],
    'Hash' : [ 0x8, ['array', 32, ['unsigned long']]],
} ],
  '_XSTATE_CONTEXT' : [ 0x20, {
    'Mask' : [ 0x0, ['unsigned long long']],
    'Length' : [ 0x8, ['unsigned long']],
    'Reserved1' : [ 0xc, ['unsigned long']],
    'Area' : [ 0x10, ['pointer', ['_XSAVE_AREA']]],
    'Reserved2' : [ 0x14, ['unsigned long']],
    'Buffer' : [ 0x18, ['pointer', ['void']]],
    'Reserved3' : [ 0x1c, ['unsigned long']],
} ],
  '_PROCESSOR_IDLE_PREPARE_INFO' : [ 0x50, {
    'Context' : [ 0x0, ['pointer', ['void']]],
    'Constraints' : [ 0x8, ['_PROCESSOR_IDLE_CONSTRAINTS']],
    'DependencyCount' : [ 0x38, ['unsigned long']],
    'DependencyUsed' : [ 0x3c, ['unsigned long']],
    'DependencyArray' : [ 0x40, ['pointer', ['_PROCESSOR_IDLE_DEPENDENCY']]],
    'PlatformIdleStateIndex' : [ 0x44, ['unsigned long']],
    'ProcessorIdleStateIndex' : [ 0x48, ['unsigned long']],
    'IdleSelectFailureMask' : [ 0x4c, ['unsigned long']],
} ],
  '_XSAVE_FORMAT' : [ 0x200, {
    'ControlWord' : [ 0x0, ['unsigned short']],
    'StatusWord' : [ 0x2, ['unsigned short']],
    'TagWord' : [ 0x4, ['unsigned char']],
    'Reserved1' : [ 0x5, ['unsigned char']],
    'ErrorOpcode' : [ 0x6, ['unsigned short']],
    'ErrorOffset' : [ 0x8, ['unsigned long']],
    'ErrorSelector' : [ 0xc, ['unsigned short']],
    'Reserved2' : [ 0xe, ['unsigned short']],
    'DataOffset' : [ 0x10, ['unsigned long']],
    'DataSelector' : [ 0x14, ['unsigned short']],
    'Reserved3' : [ 0x16, ['unsigned short']],
    'MxCsr' : [ 0x18, ['unsigned long']],
    'MxCsr_Mask' : [ 0x1c, ['unsigned long']],
    'FloatRegisters' : [ 0x20, ['array', 8, ['_M128A']]],
    'XmmRegisters' : [ 0xa0, ['array', 8, ['_M128A']]],
    'Reserved4' : [ 0x120, ['array', 224, ['unsigned char']]],
} ],
  '__unnamed_22a7' : [ 0x1, {
    'AsUCHAR' : [ 0x0, ['unsigned char']],
    'NoDomainAccounting' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 3, native_type='unsigned char')]],
    'DecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 5, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
} ],
  'PROCESSOR_PERFSTATE_POLICY' : [ 0x1c, {
    'Revision' : [ 0x0, ['unsigned long']],
    'MaxThrottle' : [ 0x4, ['unsigned char']],
    'MinThrottle' : [ 0x5, ['unsigned char']],
    'BusyAdjThreshold' : [ 0x6, ['unsigned char']],
    'Spare' : [ 0x7, ['unsigned char']],
    'Flags' : [ 0x7, ['__unnamed_22a7']],
    'TimeCheck' : [ 0x8, ['unsigned long']],
    'IncreaseTime' : [ 0xc, ['unsigned long']],
    'DecreaseTime' : [ 0x10, ['unsigned long']],
    'IncreasePercent' : [ 0x14, ['unsigned long']],
    'DecreasePercent' : [ 0x18, ['unsigned long']],
} ],
  '_BUS_EXTENSION_LIST' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['void']]],
    'BusExtension' : [ 0x4, ['pointer', ['_PI_BUS_EXTENSION']]],
} ],
  '_CACHED_CHILD_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'ValueList' : [ 0x4, ['unsigned long']],
    'RealKcb' : [ 0x4, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
} ],
  '_KDEVICE_QUEUE' : [ 0x14, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'DeviceListHead' : [ 0x4, ['_LIST_ENTRY']],
    'Lock' : [ 0xc, ['unsigned long']],
    'Busy' : [ 0x10, ['unsigned char']],
} ],
  '_SYSTEM_POWER_STATE_CONTEXT' : [ 0x4, {
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long')]],
    'TargetSystemState' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 12, native_type='unsigned long')]],
    'EffectiveSystemState' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 16, native_type='unsigned long')]],
    'CurrentSystemState' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'IgnoreHibernationPath' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'PseudoTransition' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 32, native_type='unsigned long')]],
    'ContextAsUlong' : [ 0x0, ['unsigned long']],
} ],
  '_MI_HARDWARE_STATE' : [ 0x78, {
    'NodeMask' : [ 0x0, ['unsigned long']],
    'NodeGraph' : [ 0x4, ['pointer', ['unsigned short']]],
    'SystemNodeInformation' : [ 0x8, ['pointer', ['_MI_SYSTEM_NODE_INFORMATION']]],
    'NumaLastRangeIndex' : [ 0xc, ['unsigned long']],
    'NumaMemoryRanges' : [ 0x10, ['pointer', ['_HAL_NODE_RANGE']]],
    'NumaTableCaptured' : [ 0x14, ['unsigned char']],
    'NodeShift' : [ 0x15, ['unsigned char']],
    'ChannelMemoryRanges' : [ 0x18, ['pointer', ['_HAL_CHANNEL_MEMORY_RANGES']]],
    'ChannelShift' : [ 0x1c, ['unsigned char']],
    'SecondLevelCacheSize' : [ 0x20, ['unsigned long']],
    'FirstLevelCacheSize' : [ 0x24, ['unsigned long']],
    'PhysicalAddressBits' : [ 0x28, ['unsigned long']],
    'AllMainMemoryMustBeCached' : [ 0x2c, ['unsigned char']],
    'TotalPagesAllowed' : [ 0x30, ['unsigned long']],
    'SecondaryColorMask' : [ 0x34, ['unsigned long']],
    'SecondaryColors' : [ 0x38, ['unsigned long']],
    'FlushTbForAttributeChange' : [ 0x3c, ['unsigned long']],
    'FlushCacheForAttributeChange' : [ 0x40, ['unsigned long']],
    'FlushCacheForPageAttributeChange' : [ 0x44, ['unsigned long']],
    'CacheFlushPromoteThreshold' : [ 0x48, ['unsigned long']],
    'FlushTbThreshold' : [ 0x4c, ['unsigned long']],
    'ZeroCostCounts' : [ 0x50, ['array', 2, ['_MI_ZERO_COST_COUNTS']]],
    'HighestPossiblePhysicalPage' : [ 0x70, ['unsigned long']],
} ],
  '_PEBS_DS_SAVE_AREA' : [ 0x60, {
    'BtsBufferBase' : [ 0x0, ['unsigned long long']],
    'BtsIndex' : [ 0x8, ['unsigned long long']],
    'BtsAbsoluteMaximum' : [ 0x10, ['unsigned long long']],
    'BtsInterruptThreshold' : [ 0x18, ['unsigned long long']],
    'PebsBufferBase' : [ 0x20, ['unsigned long long']],
    'PebsIndex' : [ 0x28, ['unsigned long long']],
    'PebsAbsoluteMaximum' : [ 0x30, ['unsigned long long']],
    'PebsInterruptThreshold' : [ 0x38, ['unsigned long long']],
    'PebsCounterReset0' : [ 0x40, ['unsigned long long']],
    'PebsCounterReset1' : [ 0x48, ['unsigned long long']],
    'PebsCounterReset2' : [ 0x50, ['unsigned long long']],
    'PebsCounterReset3' : [ 0x58, ['unsigned long long']],
} ],
  '_OBJECT_TYPE_INITIALIZER' : [ 0x58, {
    'Length' : [ 0x0, ['unsigned short']],
    'ObjectTypeFlags' : [ 0x2, ['unsigned char']],
    'CaseInsensitive' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'UnnamedObjectsOnly' : [ 0x2, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'UseDefaultObject' : [ 0x2, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'SecurityRequired' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'MaintainHandleCount' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'MaintainTypeList' : [ 0x2, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'SupportsObjectCallbacks' : [ 0x2, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'CacheAligned' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'ObjectTypeCode' : [ 0x4, ['unsigned long']],
    'InvalidAttributes' : [ 0x8, ['unsigned long']],
    'GenericMapping' : [ 0xc, ['_GENERIC_MAPPING']],
    'ValidAccessMask' : [ 0x1c, ['unsigned long']],
    'RetainAccess' : [ 0x20, ['unsigned long']],
    'PoolType' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPoolBase', 1: 'PagedPool', 2: 'NonPagedPoolBaseMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolBaseCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolBaseCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 516: 'NonPagedPoolNxCacheAligned', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 512: 'NonPagedPoolNx', 544: 'NonPagedPoolSessionNx', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'DefaultPagedPoolCharge' : [ 0x28, ['unsigned long']],
    'DefaultNonPagedPoolCharge' : [ 0x2c, ['unsigned long']],
    'DumpProcedure' : [ 0x30, ['pointer', ['void']]],
    'OpenProcedure' : [ 0x34, ['pointer', ['void']]],
    'CloseProcedure' : [ 0x38, ['pointer', ['void']]],
    'DeleteProcedure' : [ 0x3c, ['pointer', ['void']]],
    'ParseProcedure' : [ 0x40, ['pointer', ['void']]],
    'SecurityProcedure' : [ 0x44, ['pointer', ['void']]],
    'QueryNameProcedure' : [ 0x48, ['pointer', ['void']]],
    'OkayToCloseProcedure' : [ 0x4c, ['pointer', ['void']]],
    'WaitObjectFlagMask' : [ 0x50, ['unsigned long']],
    'WaitObjectFlagOffset' : [ 0x54, ['unsigned short']],
    'WaitObjectPointerOffset' : [ 0x56, ['unsigned short']],
} ],
  '__unnamed_22e8' : [ 0x4, {
    'Long' : [ 0x0, ['unsigned long']],
    'e1' : [ 0x0, ['_MI_DECAY_TIMER_LINKAGE']],
} ],
  '_MI_DECAY_TIMER_LINK' : [ 0x4, {
    'u1' : [ 0x0, ['__unnamed_22e8']],
} ],
  '_TRIAGE_PNP_DEVICE_COMPLETION_REQUEST' : [ 0xc, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceNode' : [ 0x8, ['pointer', ['_TRIAGE_DEVICE_NODE']]],
} ],
  'tagSWITCH_CONTEXT_ATTRIBUTE' : [ 0x18, {
    'ulContextUpdateCounter' : [ 0x0, ['unsigned long long']],
    'fAllowContextUpdate' : [ 0x8, ['long']],
    'fEnableTrace' : [ 0xc, ['long']],
    'EtwHandle' : [ 0x10, ['unsigned long long']],
} ],
  '_IO_CLIENT_EXTENSION' : [ 0x8, {
    'NextExtension' : [ 0x0, ['pointer', ['_IO_CLIENT_EXTENSION']]],
    'ClientIdentificationAddress' : [ 0x4, ['pointer', ['void']]],
} ],
  '_ETW_BUFFER_CONTEXT' : [ 0x4, {
    'ProcessorNumber' : [ 0x0, ['unsigned char']],
    'Alignment' : [ 0x1, ['unsigned char']],
    'ProcessorIndex' : [ 0x0, ['unsigned short']],
    'LoggerId' : [ 0x2, ['unsigned short']],
} ],
  '_HEAP_EXTENDED_ENTRY' : [ 0x8, {
    'FunctionIndex' : [ 0x0, ['unsigned short']],
    'ContextValue' : [ 0x2, ['unsigned short']],
    'InterceptorValue' : [ 0x0, ['unsigned long']],
    'UnusedBytesLength' : [ 0x4, ['unsigned short']],
    'EntryOffset' : [ 0x6, ['unsigned char']],
    'ExtendedBlockSignature' : [ 0x7, ['unsigned char']],
} ],
  '_MI_SYSTEM_VA_STATE' : [ 0x14c0, {
    'SystemTablesLock' : [ 0x0, ['unsigned long']],
    'SystemVaBias' : [ 0x4, ['unsigned long']],
    'SystemAvailableVaLow' : [ 0x8, ['unsigned long']],
    'VirtualBias' : [ 0xc, ['unsigned long']],
    'HyperSpaceEnd' : [ 0x10, ['pointer', ['void']]],
    'HyperSpaceEndPte' : [ 0x14, ['pointer', ['_MMPTE']]],
    'SystemRangeStart' : [ 0x18, ['pointer', ['void']]],
    'SystemCachePdeCount' : [ 0x1c, ['array', 1024, ['unsigned char']]],
    'SystemCacheReverseMaps' : [ 0x41c, ['array', 1024, ['pointer', ['void']]]],
    'WorkingSetListHashStart' : [ 0x141c, ['pointer', ['_MMWSLE_HASH']]],
    'WorkingSetListHashEnd' : [ 0x1420, ['pointer', ['_MMWSLE_HASH']]],
    'WorkingSetListIndirectHashStart' : [ 0x1424, ['pointer', ['_MMWSLE_NONDIRECT_HASH']]],
    'FreeSystemCacheVa' : [ 0x1428, ['_KEVENT']],
    'SystemVaLock' : [ 0x1438, ['unsigned long']],
    'DeleteKvaLock' : [ 0x143c, ['long']],
    'FreeSystemCache' : [ 0x1440, ['_MI_PTE_CHAIN_HEAD']],
    'SystemCacheViewLock' : [ 0x1458, ['unsigned long']],
    'UnusableWsles' : [ 0x145c, ['array', 5, ['unsigned long']]],
    'PossibleWsles' : [ 0x1470, ['array', 5, ['unsigned long']]],
} ],
  '_DIRTY_PAGE_STATISTICS' : [ 0xc, {
    'DirtyPages' : [ 0x0, ['unsigned long']],
    'DirtyPagesLastScan' : [ 0x4, ['unsigned long']],
    'DirtyPagesScheduledLastScan' : [ 0x8, ['unsigned long']],
} ],
  '_DBGKD_WRITE_CUSTOM_BREAKPOINT' : [ 0x18, {
    'BreakPointAddress' : [ 0x0, ['unsigned long long']],
    'BreakPointInstruction' : [ 0x8, ['unsigned long long']],
    'BreakPointHandle' : [ 0x10, ['unsigned long']],
    'BreakPointInstructionSize' : [ 0x14, ['unsigned char']],
    'BreakPointInstructionAlignment' : [ 0x15, ['unsigned char']],
} ],
  '_PROC_IDLE_SNAP' : [ 0x10, {
    'Time' : [ 0x0, ['unsigned long long']],
    'Idle' : [ 0x8, ['unsigned long long']],
} ],
  '_KERNEL_STACK_SEGMENT' : [ 0x10, {
    'StackBase' : [ 0x0, ['unsigned long']],
    'StackLimit' : [ 0x4, ['unsigned long']],
    'KernelStack' : [ 0x8, ['unsigned long']],
    'InitialStack' : [ 0xc, ['unsigned long']],
} ],
  '_KEXECUTE_OPTIONS' : [ 0x1, {
    'ExecuteDisable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ExecuteEnable' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'DisableThunkEmulation' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'Permanent' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ExecuteDispatchEnable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ImageDispatchEnable' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'DisableExceptionChainValidation' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'ExecuteOptions' : [ 0x0, ['unsigned char']],
    'ExecuteOptionsNV' : [ 0x0, ['unsigned char']],
} ],
  '_SEP_TOKEN_PRIVILEGES' : [ 0x18, {
    'Present' : [ 0x0, ['unsigned long long']],
    'Enabled' : [ 0x8, ['unsigned long long']],
    'EnabledByDefault' : [ 0x10, ['unsigned long long']],
} ],
  '_WHEA_XPF_MCE_DESCRIPTOR' : [ 0x398, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'NumberOfBanks' : [ 0x3, ['unsigned char']],
    'Flags' : [ 0x4, ['_XPF_MCE_FLAGS']],
    'MCG_Capability' : [ 0x8, ['unsigned long long']],
    'MCG_GlobalControl' : [ 0x10, ['unsigned long long']],
    'Banks' : [ 0x18, ['array', 32, ['_WHEA_XPF_MC_BANK_DESCRIPTOR']]],
} ],
  '_MI_DEBUGGER_STATE' : [ 0x90, {
    'TransientWrite' : [ 0x0, ['unsigned char']],
    'CodePageEdited' : [ 0x1, ['unsigned char']],
    'DebugPte' : [ 0x4, ['pointer', ['_MMPTE']]],
    'PoisonedTb' : [ 0x8, ['unsigned long']],
    'InDebugger' : [ 0xc, ['long']],
    'Pfns' : [ 0x10, ['array', 32, ['pointer', ['void']]]],
} ],
  '_MI_PROCESS_STATE' : [ 0x70, {
    'ColorSeed' : [ 0x0, ['unsigned long']],
    'CloneDereferenceEvent' : [ 0x4, ['_KEVENT']],
    'CloneProtosSListHead' : [ 0x18, ['_SLIST_HEADER']],
    'SystemDllBase' : [ 0x20, ['pointer', ['void']]],
    'RotatingUniprocessorNumber' : [ 0x24, ['long']],
    'CriticalSectionTimeout' : [ 0x28, ['_LARGE_INTEGER']],
    'ProcessList' : [ 0x30, ['_LIST_ENTRY']],
    'SharedUserDataPte' : [ 0x38, ['pointer', ['_MMPTE']]],
    'FreePaeEntries' : [ 0x3c, ['unsigned long']],
    'FirstFreePae' : [ 0x40, ['_PAE_ENTRY']],
    'AllocatedPaePages' : [ 0x60, ['long']],
    'PaeLock' : [ 0x64, ['unsigned long']],
    'PaeEntrySList' : [ 0x68, ['_SLIST_HEADER']],
} ],
  '_ARBITER_ALLOCATION_STATE' : [ 0x38, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'CurrentMinimum' : [ 0x10, ['unsigned long long']],
    'CurrentMaximum' : [ 0x18, ['unsigned long long']],
    'Entry' : [ 0x20, ['pointer', ['_ARBITER_LIST_ENTRY']]],
    'CurrentAlternative' : [ 0x24, ['pointer', ['_ARBITER_ALTERNATIVE']]],
    'AlternativeCount' : [ 0x28, ['unsigned long']],
    'Alternatives' : [ 0x2c, ['pointer', ['_ARBITER_ALTERNATIVE']]],
    'Flags' : [ 0x30, ['unsigned short']],
    'RangeAttributes' : [ 0x32, ['unsigned char']],
    'RangeAvailableAttributes' : [ 0x33, ['unsigned char']],
    'WorkSpace' : [ 0x34, ['unsigned long']],
} ],
  '_VACB_ARRAY_HEADER' : [ 0x10, {
    'VacbArrayIndex' : [ 0x0, ['unsigned long']],
    'MappingCount' : [ 0x4, ['unsigned long']],
    'HighestMappedIndex' : [ 0x8, ['unsigned long']],
    'Reserved' : [ 0xc, ['unsigned long']],
} ],
  '_MMWSLENTRY' : [ 0x4, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Hashed' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Direct' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 9, native_type='unsigned long')]],
    'Age' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 12, native_type='unsigned long')]],
    'VirtualPageNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 32, native_type='unsigned long')]],
} ],
  'SYSTEM_POWER_CAPABILITIES' : [ 0x4c, {
    'PowerButtonPresent' : [ 0x0, ['unsigned char']],
    'SleepButtonPresent' : [ 0x1, ['unsigned char']],
    'LidPresent' : [ 0x2, ['unsigned char']],
    'SystemS1' : [ 0x3, ['unsigned char']],
    'SystemS2' : [ 0x4, ['unsigned char']],
    'SystemS3' : [ 0x5, ['unsigned char']],
    'SystemS4' : [ 0x6, ['unsigned char']],
    'SystemS5' : [ 0x7, ['unsigned char']],
    'HiberFilePresent' : [ 0x8, ['unsigned char']],
    'FullWake' : [ 0x9, ['unsigned char']],
    'VideoDimPresent' : [ 0xa, ['unsigned char']],
    'ApmPresent' : [ 0xb, ['unsigned char']],
    'UpsPresent' : [ 0xc, ['unsigned char']],
    'ThermalControl' : [ 0xd, ['unsigned char']],
    'ProcessorThrottle' : [ 0xe, ['unsigned char']],
    'ProcessorMinThrottle' : [ 0xf, ['unsigned char']],
    'ProcessorMaxThrottle' : [ 0x10, ['unsigned char']],
    'FastSystemS4' : [ 0x11, ['unsigned char']],
    'Hiberboot' : [ 0x12, ['unsigned char']],
    'WakeAlarmPresent' : [ 0x13, ['unsigned char']],
    'AoAc' : [ 0x14, ['unsigned char']],
    'DiskSpinDown' : [ 0x15, ['unsigned char']],
    'HiberFileType' : [ 0x16, ['unsigned char']],
    'AoAcConnectivitySupported' : [ 0x17, ['unsigned char']],
    'spare3' : [ 0x18, ['array', 6, ['unsigned char']]],
    'SystemBatteriesPresent' : [ 0x1e, ['unsigned char']],
    'BatteriesAreShortTerm' : [ 0x1f, ['unsigned char']],
    'BatteryScale' : [ 0x20, ['array', 3, ['BATTERY_REPORTING_SCALE']]],
    'AcOnLineWake' : [ 0x38, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'SoftLidWake' : [ 0x3c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'RtcWake' : [ 0x40, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'MinDeviceWakeState' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DefaultLowLatencyWake' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
} ],
  '_MI_REBUILD_LARGE_PAGE_COUNTDOWN' : [ 0x2, {
    'SecondsLeft' : [ 0x0, ['unsigned char']],
    'SecondsAssigned' : [ 0x1, ['unsigned char']],
} ],
  '_DBGKD_SWITCH_PARTITION' : [ 0x4, {
    'Partition' : [ 0x0, ['unsigned long']],
} ],
  '_REQUEST_MAILBOX' : [ 0x20, {
    'Next' : [ 0x0, ['pointer', ['_REQUEST_MAILBOX']]],
    'RequestSummary' : [ 0x4, ['unsigned long']],
    'RequestPacket' : [ 0x8, ['_KREQUEST_PACKET']],
    'NodeTargetCountAddr' : [ 0x18, ['pointer', ['long']]],
    'NodeTargetCount' : [ 0x1c, ['long']],
} ],
  '_DBGKD_GET_VERSION32' : [ 0x28, {
    'MajorVersion' : [ 0x0, ['unsigned short']],
    'MinorVersion' : [ 0x2, ['unsigned short']],
    'ProtocolVersion' : [ 0x4, ['unsigned short']],
    'Flags' : [ 0x6, ['unsigned short']],
    'KernBase' : [ 0x8, ['unsigned long']],
    'PsLoadedModuleList' : [ 0xc, ['unsigned long']],
    'MachineType' : [ 0x10, ['unsigned short']],
    'ThCallbackStack' : [ 0x12, ['unsigned short']],
    'NextCallback' : [ 0x14, ['unsigned short']],
    'FramePointer' : [ 0x16, ['unsigned short']],
    'KiCallUserMode' : [ 0x18, ['unsigned long']],
    'KeUserCallbackDispatcher' : [ 0x1c, ['unsigned long']],
    'BreakpointWithStatus' : [ 0x20, ['unsigned long']],
    'DebuggerDataList' : [ 0x24, ['unsigned long']],
} ],
  '_WHEA_XPF_CMC_DESCRIPTOR' : [ 0x3a4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'NumberOfBanks' : [ 0x3, ['unsigned char']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'Notify' : [ 0x8, ['_WHEA_NOTIFICATION_DESCRIPTOR']],
    'Banks' : [ 0x24, ['array', 32, ['_WHEA_XPF_MC_BANK_DESCRIPTOR']]],
} ],
  '_WHEA_TIMESTAMP' : [ 0x8, {
    'Seconds' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long long')]],
    'Minutes' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long long')]],
    'Hours' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long long')]],
    'Precise' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 32, native_type='unsigned long long')]],
    'Day' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 40, native_type='unsigned long long')]],
    'Month' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 48, native_type='unsigned long long')]],
    'Year' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 56, native_type='unsigned long long')]],
    'Century' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 64, native_type='unsigned long long')]],
    'AsLARGE_INTEGER' : [ 0x0, ['_LARGE_INTEGER']],
} ],
  '_IO_IRP_EXT_TRACK_OFFSET_HEADER' : [ 0x8, {
    'Validation' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'TrackedOffsetCallback' : [ 0x4, ['pointer', ['void']]],
} ],
  '_VPB' : [ 0x58, {
    'Type' : [ 0x0, ['short']],
    'Size' : [ 0x2, ['short']],
    'Flags' : [ 0x4, ['unsigned short']],
    'VolumeLabelLength' : [ 0x6, ['unsigned short']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'RealDevice' : [ 0xc, ['pointer', ['_DEVICE_OBJECT']]],
    'SerialNumber' : [ 0x10, ['unsigned long']],
    'ReferenceCount' : [ 0x14, ['unsigned long']],
    'VolumeLabel' : [ 0x18, ['array', 32, ['wchar']]],
} ],
  '_MI_SESSION_STATE' : [ 0x1038, {
    'SystemSession' : [ 0x0, ['_MMSESSION']],
    'CodePageEdited' : [ 0x14, ['unsigned char']],
    'VaReferenceCount' : [ 0x18, ['array', 1024, ['long']]],
    'DynamicPtesBitBuffer' : [ 0x1018, ['pointer', ['unsigned long']]],
    'IdLock' : [ 0x101c, ['_EX_PUSH_LOCK']],
    'DetachTimeStamp' : [ 0x1020, ['unsigned long']],
    'LeaderProcess' : [ 0x1024, ['pointer', ['_EPROCESS']]],
    'InitializeLock' : [ 0x1028, ['_EX_PUSH_LOCK']],
    'WorkingSetList' : [ 0x102c, ['pointer', ['_MMWSL']]],
    'WsHashStart' : [ 0x1030, ['pointer', ['_MMWSLE_HASH']]],
    'WsHashEnd' : [ 0x1034, ['pointer', ['_MMWSLE_HASH']]],
} ],
  '_CACHE_DESCRIPTOR' : [ 0xc, {
    'Level' : [ 0x0, ['unsigned char']],
    'Associativity' : [ 0x1, ['unsigned char']],
    'LineSize' : [ 0x2, ['unsigned short']],
    'Size' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'CacheUnified', 1: 'CacheInstruction', 2: 'CacheData', 3: 'CacheTrace'})]],
} ],
  '_MMSESSION' : [ 0x14, {
    'SystemSpaceViewLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'SystemSpaceViewLockPointer' : [ 0x4, ['pointer', ['_EX_PUSH_LOCK']]],
    'ViewRoot' : [ 0x8, ['_RTL_AVL_TREE']],
    'ViewCount' : [ 0xc, ['unsigned long']],
    'BitmapFailures' : [ 0x10, ['unsigned long']],
} ],
  '_IOP_IRP_STACK_PROFILER' : [ 0x54, {
    'Profile' : [ 0x0, ['array', 20, ['unsigned long']]],
    'TotalIrps' : [ 0x50, ['unsigned long']],
} ],
  '_FILE_BASIC_INFORMATION' : [ 0x28, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LastAccessTime' : [ 0x8, ['_LARGE_INTEGER']],
    'LastWriteTime' : [ 0x10, ['_LARGE_INTEGER']],
    'ChangeTime' : [ 0x18, ['_LARGE_INTEGER']],
    'FileAttributes' : [ 0x20, ['unsigned long']],
} ],
  '_OBJECT_NAMESPACE_LOOKUPTABLE' : [ 0x130, {
    'HashBuckets' : [ 0x0, ['array', 37, ['_LIST_ENTRY']]],
    'Lock' : [ 0x128, ['_EX_PUSH_LOCK']],
    'NumberOfPrivateSpaces' : [ 0x12c, ['unsigned long']],
} ],
  '_SECURITY_SUBJECT_CONTEXT' : [ 0x10, {
    'ClientToken' : [ 0x0, ['pointer', ['void']]],
    'ImpersonationLevel' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'SecurityAnonymous', 1: 'SecurityIdentification', 2: 'SecurityImpersonation', 3: 'SecurityDelegation'})]],
    'PrimaryToken' : [ 0x8, ['pointer', ['void']]],
    'ProcessAuditId' : [ 0xc, ['pointer', ['void']]],
} ],
  '_MI_DECAY_TIMER_LINKAGE' : [ 0x4, {
    'Spare0' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousDecayPfn' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned long')]],
    'Spare1' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'NextDecayPfn' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 32, native_type='unsigned long')]],
} ],
  '_EVENT_HEADER' : [ 0x50, {
    'Size' : [ 0x0, ['unsigned short']],
    'HeaderType' : [ 0x2, ['unsigned short']],
    'Flags' : [ 0x4, ['unsigned short']],
    'EventProperty' : [ 0x6, ['unsigned short']],
    'ThreadId' : [ 0x8, ['unsigned long']],
    'ProcessId' : [ 0xc, ['unsigned long']],
    'TimeStamp' : [ 0x10, ['_LARGE_INTEGER']],
    'ProviderId' : [ 0x18, ['_GUID']],
    'EventDescriptor' : [ 0x28, ['_EVENT_DESCRIPTOR']],
    'KernelTime' : [ 0x38, ['unsigned long']],
    'UserTime' : [ 0x3c, ['unsigned long']],
    'ProcessorTime' : [ 0x38, ['unsigned long long']],
    'ActivityId' : [ 0x40, ['_GUID']],
} ],
  '_KiIoAccessMap' : [ 0x2024, {
    'DirectionMap' : [ 0x0, ['array', 32, ['unsigned char']]],
    'IoMap' : [ 0x20, ['array', 8196, ['unsigned char']]],
} ],
  '_PF_KERNEL_GLOBALS' : [ 0x40, {
    'AccessBufferAgeThreshold' : [ 0x0, ['unsigned long long']],
    'AccessBufferRef' : [ 0x8, ['_EX_RUNDOWN_REF']],
    'AccessBufferExistsEvent' : [ 0xc, ['_KEVENT']],
    'AccessBufferMax' : [ 0x1c, ['unsigned long']],
    'AccessBufferList' : [ 0x20, ['_SLIST_HEADER']],
    'StreamSequenceNumber' : [ 0x28, ['long']],
    'Flags' : [ 0x2c, ['unsigned long']],
    'ScenarioPrefetchCount' : [ 0x30, ['long']],
} ],
  '_CM_KEY_HASH_TABLE_ENTRY' : [ 0xc, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'Owner' : [ 0x4, ['pointer', ['_KTHREAD']]],
    'Entry' : [ 0x8, ['pointer', ['_CM_KEY_HASH']]],
} ],
  '_ARBITER_QUERY_ARBITRATE_PARAMETERS' : [ 0x4, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
} ],
  '__unnamed_236d' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MI_PARTITION_FLAGS']],
} ],
  '_MI_PARTITION_CORE' : [ 0xb8, {
    'PartitionId' : [ 0x0, ['unsigned short']],
    'u' : [ 0x4, ['__unnamed_236d']],
    'ReferenceCount' : [ 0x8, ['unsigned long']],
    'ParentPartition' : [ 0xc, ['pointer', ['_MI_PARTITION']]],
    'ListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'NodeInformation' : [ 0x18, ['pointer', ['_MI_NODE_INFORMATION']]],
    'MdlPhysicalMemoryBlock' : [ 0x1c, ['pointer', ['_MDL']]],
    'MemoryNodeRuns' : [ 0x20, ['pointer', ['_PHYSICAL_MEMORY_DESCRIPTOR']]],
    'MemoryBlockReferences' : [ 0x24, ['unsigned long']],
    'PfnUnmapWorkItem' : [ 0x28, ['_WORK_QUEUE_ITEM']],
    'PfnUnmapActive' : [ 0x38, ['unsigned char']],
    'PfnUnmapCount' : [ 0x3c, ['unsigned long']],
    'PfnUnmapWaitList' : [ 0x40, ['pointer', ['void']]],
    'MemoryRuns' : [ 0x44, ['pointer', ['_PHYSICAL_MEMORY_DESCRIPTOR']]],
    'ExitEvent' : [ 0x48, ['_KEVENT']],
    'SystemThreadHandles' : [ 0x58, ['array', 5, ['pointer', ['void']]]],
    'PartitionObject' : [ 0x6c, ['pointer', ['void']]],
    'PartitionObjectHandle' : [ 0x70, ['pointer', ['void']]],
    'DynamicMemoryPushLock' : [ 0x74, ['_EX_PUSH_LOCK']],
    'DynamicMemoryLock' : [ 0x78, ['long']],
    'TemporaryMemoryEvent' : [ 0x7c, ['_KEVENT']],
    'MemoryEvents' : [ 0x8c, ['array', 11, ['pointer', ['_KEVENT']]]],
} ],
  '_MI_PARTITION_MODWRITES' : [ 0x1d0, {
    'AttemptForCantExtend' : [ 0x0, ['_MMPAGE_FILE_EXPANSION']],
    'PageFileContract' : [ 0x38, ['_MMPAGE_FILE_EXPANSION']],
    'NumberOfMappedMdls' : [ 0x70, ['unsigned long']],
    'NumberOfMappedMdlsInUse' : [ 0x74, ['long']],
    'NumberOfMappedMdlsInUsePeak' : [ 0x78, ['unsigned long']],
    'MappedFileHeader' : [ 0x7c, ['_MMMOD_WRITER_LISTHEAD']],
    'NeedMappedMdl' : [ 0x94, ['unsigned char']],
    'NeedPageFileMdl' : [ 0x95, ['unsigned char']],
    'TransitionInserted' : [ 0x96, ['unsigned char']],
    'LastModifiedWriteError' : [ 0x98, ['long']],
    'LastMappedWriteError' : [ 0x9c, ['long']],
    'MappedFileWriteSucceeded' : [ 0xa0, ['unsigned long']],
    'MappedWriteBurstCount' : [ 0xa4, ['unsigned long']],
    'LowPriorityModWritesOutstanding' : [ 0xa8, ['unsigned long']],
    'BoostModWriteIoPriorityEvent' : [ 0xac, ['_KEVENT']],
    'ModifiedWriterThreadPriority' : [ 0xbc, ['long']],
    'ModifiedPagesLowPriorityGoal' : [ 0xc0, ['unsigned long']],
    'ModifiedPageWriterEvent' : [ 0xc4, ['_KEVENT']],
    'ModifiedWriterExitedEvent' : [ 0xd4, ['_KEVENT']],
    'WriteAllPagefilePages' : [ 0xe4, ['long']],
    'WriteAllMappedPages' : [ 0xe8, ['long']],
    'MappedPageWriterEvent' : [ 0xec, ['_KEVENT']],
    'ModWriteData' : [ 0x100, ['_MI_MODWRITE_DATA']],
    'RescanPageFilesEvent' : [ 0x130, ['_KEVENT']],
    'PagingFileHeader' : [ 0x140, ['_MMMOD_WRITER_LISTHEAD']],
    'ModifiedPageWriterThread' : [ 0x158, ['pointer', ['_ETHREAD']]],
    'ModifiedPageWriterRundown' : [ 0x15c, ['_EX_RUNDOWN_REF']],
    'PagefileScanWorkItem' : [ 0x160, ['_WORK_QUEUE_ITEM']],
    'PagefileScanCount' : [ 0x170, ['unsigned long']],
    'ClusterWritesDisabled' : [ 0x174, ['array', 2, ['long']]],
    'NotifyStoreMemoryConditions' : [ 0x17c, ['_KEVENT']],
    'DelayMappedWrite' : [ 0x18c, ['unsigned char']],
    'PagefileReservationsEnabled' : [ 0x190, ['unsigned long']],
    'PageFileCreationLock' : [ 0x194, ['_EX_PUSH_LOCK']],
    'TrimPagefileWorkItem' : [ 0x198, ['_WORK_QUEUE_ITEM']],
    'LastTrimPagefileTime' : [ 0x1a8, ['unsigned long long']],
    'WsSwapPagefileContractWorkItem' : [ 0x1b0, ['_WORK_QUEUE_ITEM']],
    'WsSwapPageFileContractionInProgress' : [ 0x1c0, ['long']],
    'WorkingSetSwapLock' : [ 0x1c4, ['_EX_PUSH_LOCK']],
    'WorkingSetInswapLock' : [ 0x1c8, ['long']],
} ],
  '_ARBITER_BOOT_ALLOCATION_PARAMETERS' : [ 0x4, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
} ],
  '_KPRIQUEUE' : [ 0x19c, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'EntryListHead' : [ 0x10, ['array', 32, ['_LIST_ENTRY']]],
    'CurrentCount' : [ 0x110, ['array', 32, ['long']]],
    'MaximumCount' : [ 0x190, ['unsigned long']],
    'ThreadListHead' : [ 0x194, ['_LIST_ENTRY']],
} ],
  '__unnamed_2385' : [ 0x4, {
    'ChannelsHotCold' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_NODE_INFORMATION' : [ 0x68, {
    'LargePageFreeCount' : [ 0x0, ['array', 2, ['unsigned long']]],
    'LargePages' : [ 0x8, ['array', 2, ['array', 2, ['array', 1, ['_LIST_ENTRY']]]]],
    'LargePagesCount' : [ 0x28, ['array', 2, ['array', 2, ['array', 1, ['unsigned long']]]]],
    'FreeCount' : [ 0x38, ['array', 2, ['unsigned long']]],
    'TotalPages' : [ 0x40, ['array', 1, ['unsigned long']]],
    'TotalPagesEntireNode' : [ 0x44, ['unsigned long']],
    'MmShiftedColor' : [ 0x48, ['unsigned long']],
    'Color' : [ 0x4c, ['unsigned long']],
    'ChannelFreeCount' : [ 0x50, ['array', 1, ['array', 2, ['unsigned long']]]],
    'Flags' : [ 0x58, ['__unnamed_2385']],
    'NodeLock' : [ 0x5c, ['_EX_PUSH_LOCK']],
    'ChannelStatus' : [ 0x60, ['unsigned char']],
    'ChannelOrdering' : [ 0x61, ['array', 1, ['unsigned char']]],
    'LockedChannelOrdering' : [ 0x62, ['array', 1, ['unsigned char']]],
    'PowerAttribute' : [ 0x63, ['array', 1, ['unsigned char']]],
    'LargePageLock' : [ 0x64, ['unsigned long']],
} ],
  '_EXCEPTION_REGISTRATION_RECORD' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'Handler' : [ 0x4, ['pointer', ['void']]],
} ],
  '_WAITING_IRP' : [ 0x20, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x8, ['pointer', ['_IRP']]],
    'CompletionRoutine' : [ 0xc, ['pointer', ['void']]],
    'Context' : [ 0x10, ['pointer', ['void']]],
    'Event' : [ 0x14, ['pointer', ['_KEVENT']]],
    'Information' : [ 0x18, ['unsigned long']],
    'BreakAllRH' : [ 0x1c, ['unsigned char']],
} ],
  '_ETW_FILTER_PID' : [ 0x24, {
    'Count' : [ 0x0, ['unsigned long']],
    'Pids' : [ 0x4, ['array', 8, ['unsigned long']]],
} ],
  '_PPM_SELECTION_MENU' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'Entries' : [ 0x4, ['pointer', ['_PPM_SELECTION_MENU_ENTRY']]],
} ],
  '_VF_TARGET_ALL_SHARED_EXPORT_THUNKS' : [ 0x10, {
    'SharedExportThunks' : [ 0x0, ['pointer', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
    'PoolSharedExportThunks' : [ 0x4, ['pointer', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
    'OrderDependentSharedExportThunks' : [ 0x8, ['pointer', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
    'XdvSharedExportThunks' : [ 0xc, ['pointer', ['_VERIFIER_SHARED_EXPORT_THUNK']]],
} ],
  '_KSCHEDULING_GROUP' : [ 0x140, {
    'Policy' : [ 0x0, ['_KSCHEDULING_GROUP_POLICY']],
    'RelativeWeight' : [ 0x8, ['unsigned long']],
    'ChildMinRate' : [ 0xc, ['unsigned long']],
    'ChildMinWeight' : [ 0x10, ['unsigned long']],
    'ChildTotalWeight' : [ 0x14, ['unsigned long']],
    'QueryHistoryTimeStamp' : [ 0x18, ['unsigned long long']],
    'NotificationCycles' : [ 0x20, ['long long']],
    'SchedulingGroupList' : [ 0x28, ['_LIST_ENTRY']],
    'Sibling' : [ 0x28, ['_LIST_ENTRY']],
    'NotificationDpc' : [ 0x30, ['pointer', ['_KDPC']]],
    'ChildList' : [ 0x34, ['_LIST_ENTRY']],
    'Parent' : [ 0x3c, ['pointer', ['_KSCHEDULING_GROUP']]],
    'PerProcessor' : [ 0x40, ['array', 1, ['_KSCB']]],
} ],
  '_ETW_REF_CLOCK' : [ 0x10, {
    'StartTime' : [ 0x0, ['_LARGE_INTEGER']],
    'StartPerfClock' : [ 0x8, ['_LARGE_INTEGER']],
} ],
  '_OB_DUPLICATE_OBJECT_STATE' : [ 0x18, {
    'SourceProcess' : [ 0x0, ['pointer', ['_EPROCESS']]],
    'SourceHandle' : [ 0x4, ['pointer', ['void']]],
    'Object' : [ 0x8, ['pointer', ['void']]],
    'TargetAccess' : [ 0xc, ['unsigned long']],
    'ObjectInfo' : [ 0x10, ['_HANDLE_TABLE_ENTRY_INFO']],
    'HandleAttributes' : [ 0x14, ['unsigned long']],
} ],
  '_MMPTE_SUBSECTION' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Unused0' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Unused1' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long long')]],
    'SubsectionAddress' : [ 0x0, ['BitField', dict(start_bit = 32, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_POWER_STATE' : [ 0x4, {
    'SystemState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'DeviceState' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
} ],
  '_MMWORKING_SET_EXPANSION_HEAD' : [ 0x8, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_POP_IRP_WORKER_ENTRY' : [ 0x18, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Thread' : [ 0x8, ['pointer', ['_ETHREAD']]],
    'Irp' : [ 0xc, ['pointer', ['_IRP']]],
    'Device' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'Static' : [ 0x14, ['unsigned char']],
} ],
  '_POP_POLICY_DEVICE' : [ 0x20, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceType' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'PolicyDeviceSystemButton', 1: 'PolicyDeviceThermalZone', 2: 'PolicyDeviceBattery', 3: 'PolicyDeviceMemory', 4: 'PolicyInitiatePowerActionAPI', 5: 'PolicySetPowerStateAPI', 6: 'PolicyImmediateDozeS4', 7: 'PolicySystemIdle', 8: 'PolicyDeviceWakeAlarm', 9: 'PolicyDeviceFan', 10: 'PolicyCsBatterySaver', 11: 'PolicyImmediateDozeS4Predicted', 12: 'PolicyImmediateDozeS4PredictedNoWake', 13: 'PolicyDeviceMax'})]],
    'Notification' : [ 0xc, ['pointer', ['void']]],
    'Name' : [ 0x10, ['_UNICODE_STRING']],
    'Device' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'Irp' : [ 0x1c, ['pointer', ['_IRP']]],
} ],
  '__unnamed_23b6' : [ 0x4, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'FileObject' : [ 0x0, ['pointer', ['_FILE_OBJECT']]],
    'RemoteImageFileObject' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'RemoteDataFileObject' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
} ],
  '_SECTION' : [ 0x28, {
    'SectionNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'StartingVpn' : [ 0xc, ['unsigned long']],
    'EndingVpn' : [ 0x10, ['unsigned long']],
    'u1' : [ 0x14, ['__unnamed_23b6']],
    'SizeOfSection' : [ 0x18, ['unsigned long long']],
    'u' : [ 0x20, ['__unnamed_16af']],
    'InitialPageProtection' : [ 0x24, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long')]],
    'SessionId' : [ 0x24, ['BitField', dict(start_bit = 12, end_bit = 31, native_type='unsigned long')]],
    'NoValidationNeeded' : [ 0x24, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_SECTION_STATE' : [ 0x140, {
    'SectionObjectPointersLock' : [ 0x0, ['long']],
    'SectionExtendLock' : [ 0x4, ['_EX_PUSH_LOCK']],
    'SectionExtendSetLock' : [ 0x8, ['_EX_PUSH_LOCK']],
    'SectionBasedRoot' : [ 0xc, ['_RTL_AVL_TREE']],
    'SectionBasedLock' : [ 0x10, ['_EX_PUSH_LOCK']],
    'UnusedSubsectionPagedPool' : [ 0x14, ['unsigned long']],
    'UnusedSegmentForceFree' : [ 0x18, ['unsigned long']],
    'DataSectionProtectionMask' : [ 0x1c, ['unsigned long']],
    'HighSectionBase' : [ 0x20, ['pointer', ['void']]],
    'PhysicalSubsection' : [ 0x24, ['_MSUBSECTION']],
    'PhysicalControlArea' : [ 0x68, ['_CONTROL_AREA']],
    'DanglingExtentsPages' : [ 0xb8, ['pointer', ['_MMPFN']]],
    'DanglingExtentsLock' : [ 0xbc, ['long']],
    'DanglingExtentsWorkItem' : [ 0xc0, ['_WORK_QUEUE_ITEM']],
    'DanglingExtentsWorkerActive' : [ 0xd0, ['unsigned char']],
    'PageFileSectionHead' : [ 0xd4, ['_RTL_AVL_TREE']],
    'PageFileSectionListSpinLock' : [ 0xd8, ['long']],
    'ImageBias' : [ 0xdc, ['unsigned long']],
    'RelocateBitmapsLock' : [ 0xe0, ['_EX_PUSH_LOCK']],
    'ImageBitMap' : [ 0xe4, ['_RTL_BITMAP']],
    'ApiSetSection' : [ 0xec, ['pointer', ['void']]],
    'ApiSetSchema' : [ 0xf0, ['pointer', ['void']]],
    'ApiSetSchemaSize' : [ 0xf4, ['unsigned long']],
    'LostDataFiles' : [ 0xf8, ['unsigned long']],
    'LostDataPages' : [ 0xfc, ['unsigned long']],
    'ImageFailureReason' : [ 0x100, ['unsigned long']],
    'CfgBitMapSection32' : [ 0x104, ['pointer', ['_SECTION']]],
    'CfgBitMapControlArea32' : [ 0x108, ['pointer', ['_CONTROL_AREA']]],
    'ImageCfgFailure' : [ 0x10c, ['unsigned long']],
    'ImageValidationFailed' : [ 0x110, ['long']],
} ],
  '_MI_PARTITION_FLAGS' : [ 0x4, {
    'BeingDeleted' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ObjectInitialized' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PageListsInitialized' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'StoreReservedPagesCharged' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
} ],
  '__unnamed_23c2' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23c4' : [ 0xc, {
    'Level' : [ 0x0, ['unsigned short']],
    'Group' : [ 0x2, ['unsigned short']],
    'Vector' : [ 0x4, ['unsigned long']],
    'Affinity' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23c6' : [ 0xc, {
    'Group' : [ 0x0, ['unsigned short']],
    'MessageCount' : [ 0x2, ['unsigned short']],
    'Vector' : [ 0x4, ['unsigned long']],
    'Affinity' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23c8' : [ 0xc, {
    'Raw' : [ 0x0, ['__unnamed_23c6']],
    'Translated' : [ 0x0, ['__unnamed_23c4']],
} ],
  '__unnamed_23ca' : [ 0xc, {
    'Channel' : [ 0x0, ['unsigned long']],
    'Port' : [ 0x4, ['unsigned long']],
    'Reserved1' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23cc' : [ 0xc, {
    'Channel' : [ 0x0, ['unsigned long']],
    'RequestLine' : [ 0x4, ['unsigned long']],
    'TransferWidth' : [ 0x8, ['unsigned char']],
    'Reserved1' : [ 0x9, ['unsigned char']],
    'Reserved2' : [ 0xa, ['unsigned char']],
    'Reserved3' : [ 0xb, ['unsigned char']],
} ],
  '__unnamed_23ce' : [ 0xc, {
    'Start' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
    'Reserved' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23d0' : [ 0xc, {
    'DataSize' : [ 0x0, ['unsigned long']],
    'Reserved1' : [ 0x4, ['unsigned long']],
    'Reserved2' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23d2' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length40' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23d4' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length48' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23d6' : [ 0xc, {
    'Start' : [ 0x0, ['_LARGE_INTEGER']],
    'Length64' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_23d8' : [ 0xc, {
    'Generic' : [ 0x0, ['__unnamed_23c2']],
    'Port' : [ 0x0, ['__unnamed_23c2']],
    'Interrupt' : [ 0x0, ['__unnamed_23c4']],
    'MessageInterrupt' : [ 0x0, ['__unnamed_23c8']],
    'Memory' : [ 0x0, ['__unnamed_23c2']],
    'Dma' : [ 0x0, ['__unnamed_23ca']],
    'DmaV3' : [ 0x0, ['__unnamed_23cc']],
    'DevicePrivate' : [ 0x0, ['__unnamed_21e1']],
    'BusNumber' : [ 0x0, ['__unnamed_23ce']],
    'DeviceSpecificData' : [ 0x0, ['__unnamed_23d0']],
    'Memory40' : [ 0x0, ['__unnamed_23d2']],
    'Memory48' : [ 0x0, ['__unnamed_23d4']],
    'Memory64' : [ 0x0, ['__unnamed_23d6']],
    'Connection' : [ 0x0, ['__unnamed_21ed']],
} ],
  '_CM_PARTIAL_RESOURCE_DESCRIPTOR' : [ 0x10, {
    'Type' : [ 0x0, ['unsigned char']],
    'ShareDisposition' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['unsigned short']],
    'u' : [ 0x4, ['__unnamed_23d8']],
} ],
  '_OBJECT_HEADER_PADDING_INFO' : [ 0x4, {
    'PaddingAmount' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_23e0' : [ 0x4, {
    'PhysicalAddress' : [ 0x0, ['unsigned long']],
    'VirtualSize' : [ 0x0, ['unsigned long']],
} ],
  '_IMAGE_SECTION_HEADER' : [ 0x28, {
    'Name' : [ 0x0, ['array', 8, ['unsigned char']]],
    'Misc' : [ 0x8, ['__unnamed_23e0']],
    'VirtualAddress' : [ 0xc, ['unsigned long']],
    'SizeOfRawData' : [ 0x10, ['unsigned long']],
    'PointerToRawData' : [ 0x14, ['unsigned long']],
    'PointerToRelocations' : [ 0x18, ['unsigned long']],
    'PointerToLinenumbers' : [ 0x1c, ['unsigned long']],
    'NumberOfRelocations' : [ 0x20, ['unsigned short']],
    'NumberOfLinenumbers' : [ 0x22, ['unsigned short']],
    'Characteristics' : [ 0x24, ['unsigned long']],
} ],
  '_ARBITER_ADD_RESERVED_PARAMETERS' : [ 0x4, {
    'ReserveDevice' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '_MM_PAGED_POOL_INFO' : [ 0x1c, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'PagedPoolAllocationMap' : [ 0x4, ['_RTL_BITMAP']],
    'FirstPteForPagedPool' : [ 0xc, ['pointer', ['_MMPTE']]],
    'MaximumSize' : [ 0x10, ['unsigned long']],
    'PagedPoolHint' : [ 0x14, ['unsigned long']],
    'AllocatedPagedPool' : [ 0x18, ['unsigned long']],
} ],
  '__unnamed_23ec' : [ 0x50, {
    'CellData' : [ 0x0, ['_CELL_DATA']],
    'List' : [ 0x0, ['array', 1, ['unsigned long']]],
} ],
  '_CM_CACHED_VALUE_INDEX' : [ 0x54, {
    'CellIndex' : [ 0x0, ['unsigned long']],
    'Data' : [ 0x4, ['__unnamed_23ec']],
} ],
  '_PPM_COORDINATED_SELECTION' : [ 0x10, {
    'MaximumStates' : [ 0x0, ['unsigned long']],
    'SelectedStates' : [ 0x4, ['unsigned long']],
    'DefaultSelection' : [ 0x8, ['unsigned long']],
    'Selection' : [ 0xc, ['pointer', ['unsigned long']]],
} ],
  '_DBGKD_QUERY_SPECIAL_CALLS' : [ 0x4, {
    'NumberOfSpecialCalls' : [ 0x0, ['unsigned long']],
} ],
  '_PAE_ENTRY' : [ 0x20, {
    'PteEntry' : [ 0x0, ['array', 4, ['_MMPTE']]],
    'PaeEntry' : [ 0x0, ['_PAE_PAGEINFO']],
    'NextPae' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
} ],
  '_MI_PAGE_COMBINING_SUPPORT' : [ 0xd8, {
    'Partition' : [ 0x0, ['pointer', ['_MI_PARTITION']]],
    'ArbitraryPfnMapList' : [ 0x4, ['_LIST_ENTRY']],
    'FreeCombinePoolItem' : [ 0xc, ['_MI_COMBINE_WORKITEM']],
    'CombiningThreadCount' : [ 0x20, ['unsigned long']],
    'CombinePageFreeList' : [ 0x24, ['_LIST_ENTRY']],
    'CombineFreeListLock' : [ 0x2c, ['unsigned long']],
    'CombinePageListHeads' : [ 0x30, ['array', 16, ['_MI_COMBINE_PAGE_LISTHEAD']]],
    'PageCombineStats' : [ 0xb0, ['_MI_PAGE_COMBINE_STATISTICS']],
} ],
  '_VF_AVL_TREE_NODE' : [ 0x8, {
    'p' : [ 0x0, ['pointer', ['void']]],
    'RangeSize' : [ 0x4, ['unsigned long']],
} ],
  '_POP_FX_DEVICE' : [ 0x188, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x8, ['pointer', ['_IRP']]],
    'IrpData' : [ 0xc, ['pointer', ['_POP_IRP_DATA']]],
    'Status' : [ 0x10, ['_POP_FX_DEVICE_STATUS']],
    'PowerReqCall' : [ 0x14, ['long']],
    'PowerNotReqCall' : [ 0x18, ['long']],
    'DevNode' : [ 0x1c, ['pointer', ['_DEVICE_NODE']]],
    'DpmContext' : [ 0x20, ['pointer', ['PEPHANDLE__']]],
    'Plugin' : [ 0x24, ['pointer', ['_POP_FX_PLUGIN']]],
    'PluginHandle' : [ 0x28, ['pointer', ['PEPHANDLE__']]],
    'AcpiPlugin' : [ 0x2c, ['pointer', ['_POP_FX_PLUGIN']]],
    'AcpiPluginHandle' : [ 0x30, ['pointer', ['PEPHANDLE__']]],
    'DeviceObject' : [ 0x34, ['pointer', ['_DEVICE_OBJECT']]],
    'TargetDevice' : [ 0x38, ['pointer', ['_DEVICE_OBJECT']]],
    'Callbacks' : [ 0x3c, ['_POP_FX_DRIVER_CALLBACKS']],
    'DriverContext' : [ 0x58, ['pointer', ['void']]],
    'AcpiLink' : [ 0x5c, ['_LIST_ENTRY']],
    'DeviceId' : [ 0x64, ['_UNICODE_STRING']],
    'RemoveLock' : [ 0x6c, ['_IO_REMOVE_LOCK']],
    'AcpiRemoveLock' : [ 0x84, ['_IO_REMOVE_LOCK']],
    'WorkOrder' : [ 0x9c, ['_POP_FX_WORK_ORDER']],
    'IdleLock' : [ 0xb8, ['unsigned long']],
    'IdleTimer' : [ 0xc0, ['_KTIMER']],
    'IdleDpc' : [ 0xe8, ['_KDPC']],
    'IdleTimeout' : [ 0x108, ['unsigned long long']],
    'IdleStamp' : [ 0x110, ['unsigned long long']],
    'NextIrpDeviceObject' : [ 0x118, ['array', 2, ['pointer', ['_DEVICE_OBJECT']]]],
    'NextIrpPowerState' : [ 0x120, ['array', 2, ['_POWER_STATE']]],
    'NextIrpCallerCompletion' : [ 0x128, ['array', 2, ['pointer', ['void']]]],
    'NextIrpCallerContext' : [ 0x130, ['array', 2, ['pointer', ['void']]]],
    'IrpCompleteEvent' : [ 0x138, ['_KEVENT']],
    'PowerOnDumpDeviceCallback' : [ 0x148, ['pointer', ['void']]],
    'Accounting' : [ 0x150, ['_POP_FX_ACCOUNTING']],
    'Flags' : [ 0x178, ['unsigned long']],
    'ComponentCount' : [ 0x17c, ['unsigned long']],
    'Components' : [ 0x180, ['pointer', ['pointer', ['_POP_FX_COMPONENT']]]],
} ],
  '_PEP_ACPI_RESOURCE_FLAGS' : [ 0x4, {
    'AsULong' : [ 0x0, ['unsigned long']],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Wake' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ResourceUsage' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SlaveMode' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'AddressingMode' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'SharedMode' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_2418' : [ 0x8, {
    'IdleTime' : [ 0x0, ['unsigned long']],
    'NonIdleTime' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_241a' : [ 0x8, {
    'Disk' : [ 0x0, ['__unnamed_2418']],
} ],
  '_DEVICE_OBJECT_POWER_EXTENSION' : [ 0x44, {
    'IdleCount' : [ 0x0, ['unsigned long']],
    'BusyCount' : [ 0x4, ['unsigned long']],
    'BusyReference' : [ 0x8, ['unsigned long']],
    'TotalBusyCount' : [ 0xc, ['unsigned long']],
    'ConservationIdleTime' : [ 0x10, ['unsigned long']],
    'PerformanceIdleTime' : [ 0x14, ['unsigned long']],
    'DeviceObject' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'IdleList' : [ 0x1c, ['_LIST_ENTRY']],
    'IdleType' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceIdleNormal', 1: 'DeviceIdleDisk'})]],
    'IdleState' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
    'CurrentState' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'})]],
    'CoolingExtension' : [ 0x30, ['pointer', ['_POP_COOLING_EXTENSION']]],
    'Volume' : [ 0x34, ['_LIST_ENTRY']],
    'Specific' : [ 0x3c, ['__unnamed_241a']],
} ],
  '_ARBITER_RETEST_ALLOCATION_PARAMETERS' : [ 0xc, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'AllocateFromCount' : [ 0x4, ['unsigned long']],
    'AllocateFrom' : [ 0x8, ['pointer', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_PROCESSOR_NUMBER' : [ 0x4, {
    'Group' : [ 0x0, ['unsigned short']],
    'Number' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_MI_COMBINE_STATE' : [ 0x18, {
    'ActiveSpinLock' : [ 0x0, ['long']],
    'CombiningThreadCount' : [ 0x4, ['unsigned long']],
    'ActiveThreadTree' : [ 0x8, ['_RTL_AVL_TREE']],
    'ZeroPageHashValue' : [ 0x10, ['unsigned long long']],
} ],
  '_MMDEREFERENCE_SEGMENT_HEADER' : [ 0x1c, {
    'Semaphore' : [ 0x0, ['_KSEMAPHORE']],
    'ListHead' : [ 0x14, ['_LIST_ENTRY']],
} ],
  '_MI_TRIAGE_DUMP_DATA' : [ 0x38, {
    'BadPageCount' : [ 0x0, ['unsigned long']],
    'BadPagesDetected' : [ 0x4, ['long']],
    'ZeroedPageSingleBitErrorsDetected' : [ 0x8, ['long']],
    'ScrubPasses' : [ 0xc, ['long']],
    'ScrubBadPagesFound' : [ 0x10, ['long']],
    'PageHashErrors' : [ 0x14, ['unsigned long']],
    'FeatureBits' : [ 0x18, ['unsigned long long']],
    'TimeZoneId' : [ 0x20, ['unsigned long']],
    'Flags' : [ 0x24, ['_MI_FLAGS']],
    'VsmConnection' : [ 0x28, ['pointer', ['void']]],
    'ExceptionChainTerminator' : [ 0x2c, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'ExceptionChainTerminatorRecord' : [ 0x30, ['_EXCEPTION_REGISTRATION_RECORD']],
} ],
  '_WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS' : [ 0x1, {
    'FRUId' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'FRUText' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'AsUCHAR' : [ 0x0, ['unsigned char']],
} ],
  '_FS_FILTER_CALLBACKS' : [ 0x38, {
    'SizeOfFsFilterCallbacks' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'PreAcquireForSectionSynchronization' : [ 0x8, ['pointer', ['void']]],
    'PostAcquireForSectionSynchronization' : [ 0xc, ['pointer', ['void']]],
    'PreReleaseForSectionSynchronization' : [ 0x10, ['pointer', ['void']]],
    'PostReleaseForSectionSynchronization' : [ 0x14, ['pointer', ['void']]],
    'PreAcquireForCcFlush' : [ 0x18, ['pointer', ['void']]],
    'PostAcquireForCcFlush' : [ 0x1c, ['pointer', ['void']]],
    'PreReleaseForCcFlush' : [ 0x20, ['pointer', ['void']]],
    'PostReleaseForCcFlush' : [ 0x24, ['pointer', ['void']]],
    'PreAcquireForModifiedPageWriter' : [ 0x28, ['pointer', ['void']]],
    'PostAcquireForModifiedPageWriter' : [ 0x2c, ['pointer', ['void']]],
    'PreReleaseForModifiedPageWriter' : [ 0x30, ['pointer', ['void']]],
    'PostReleaseForModifiedPageWriter' : [ 0x34, ['pointer', ['void']]],
} ],
  '_KENLISTMENT' : [ 0x168, {
    'cookie' : [ 0x0, ['unsigned long']],
    'NamespaceLink' : [ 0x4, ['_KTMOBJECT_NAMESPACE_LINK']],
    'EnlistmentId' : [ 0x18, ['_GUID']],
    'Mutex' : [ 0x28, ['_KMUTANT']],
    'NextSameTx' : [ 0x48, ['_LIST_ENTRY']],
    'NextSameRm' : [ 0x50, ['_LIST_ENTRY']],
    'ResourceManager' : [ 0x58, ['pointer', ['_KRESOURCEMANAGER']]],
    'Transaction' : [ 0x5c, ['pointer', ['_KTRANSACTION']]],
    'State' : [ 0x60, ['Enumeration', dict(target = 'long', choices = {0: 'KEnlistmentUninitialized', 256: 'KEnlistmentActive', 258: 'KEnlistmentPrepared', 259: 'KEnlistmentInDoubt', 260: 'KEnlistmentCommitted', 261: 'KEnlistmentCommittedNotify', 262: 'KEnlistmentCommitRequested', 257: 'KEnlistmentPreparing', 264: 'KEnlistmentDelegated', 265: 'KEnlistmentDelegatedDisconnected', 266: 'KEnlistmentPrePreparing', 263: 'KEnlistmentAborted', 268: 'KEnlistmentRecovering', 269: 'KEnlistmentAborting', 270: 'KEnlistmentReadOnly', 271: 'KEnlistmentOutcomeUnavailable', 272: 'KEnlistmentOffline', 273: 'KEnlistmentPrePrepared', 274: 'KEnlistmentInitialized', 267: 'KEnlistmentForgotten'})]],
    'Flags' : [ 0x64, ['unsigned long']],
    'NotificationMask' : [ 0x68, ['unsigned long']],
    'Key' : [ 0x6c, ['pointer', ['void']]],
    'KeyRefCount' : [ 0x70, ['unsigned long']],
    'RecoveryInformation' : [ 0x74, ['pointer', ['void']]],
    'RecoveryInformationLength' : [ 0x78, ['unsigned long']],
    'DynamicNameInformation' : [ 0x7c, ['pointer', ['void']]],
    'DynamicNameInformationLength' : [ 0x80, ['unsigned long']],
    'FinalNotification' : [ 0x84, ['pointer', ['_KTMNOTIFICATION_PACKET']]],
    'SupSubEnlistment' : [ 0x88, ['pointer', ['_KENLISTMENT']]],
    'SupSubEnlHandle' : [ 0x8c, ['pointer', ['void']]],
    'SubordinateTxHandle' : [ 0x90, ['pointer', ['void']]],
    'CrmEnlistmentEnId' : [ 0x94, ['_GUID']],
    'CrmEnlistmentTmId' : [ 0xa4, ['_GUID']],
    'CrmEnlistmentRmId' : [ 0xb4, ['_GUID']],
    'NextHistory' : [ 0xc4, ['unsigned long']],
    'History' : [ 0xc8, ['array', 20, ['_KENLISTMENT_HISTORY']]],
} ],
  '_ARBITER_INTERFACE' : [ 0x18, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'InterfaceReference' : [ 0x8, ['pointer', ['void']]],
    'InterfaceDereference' : [ 0xc, ['pointer', ['void']]],
    'ArbiterHandler' : [ 0x10, ['pointer', ['void']]],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_DELAY_ACK_FO' : [ 0xc, {
    'Links' : [ 0x0, ['_LIST_ENTRY']],
    'OriginalFileObject' : [ 0x8, ['pointer', ['_FILE_OBJECT']]],
} ],
  '_IA64_DBGKD_CONTROL_SET' : [ 0x14, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0xc, ['unsigned long long']],
} ],
  '_DEVICE_RELATIONS' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'Objects' : [ 0x4, ['array', 1, ['pointer', ['_DEVICE_OBJECT']]]],
} ],
  '_IMAGE_ROM_OPTIONAL_HEADER' : [ 0x38, {
    'Magic' : [ 0x0, ['unsigned short']],
    'MajorLinkerVersion' : [ 0x2, ['unsigned char']],
    'MinorLinkerVersion' : [ 0x3, ['unsigned char']],
    'SizeOfCode' : [ 0x4, ['unsigned long']],
    'SizeOfInitializedData' : [ 0x8, ['unsigned long']],
    'SizeOfUninitializedData' : [ 0xc, ['unsigned long']],
    'AddressOfEntryPoint' : [ 0x10, ['unsigned long']],
    'BaseOfCode' : [ 0x14, ['unsigned long']],
    'BaseOfData' : [ 0x18, ['unsigned long']],
    'BaseOfBss' : [ 0x1c, ['unsigned long']],
    'GprMask' : [ 0x20, ['unsigned long']],
    'CprMask' : [ 0x24, ['array', 4, ['unsigned long']]],
    'GpValue' : [ 0x34, ['unsigned long']],
} ],
  '_MI_BAD_MEMORY_EVENT_ENTRY' : [ 0x28, {
    'BugCheckCode' : [ 0x0, ['unsigned long']],
    'Active' : [ 0x4, ['long']],
    'Data' : [ 0x8, ['unsigned long']],
    'PhysicalAddress' : [ 0x10, ['_LARGE_INTEGER']],
    'WorkItem' : [ 0x18, ['_WORK_QUEUE_ITEM']],
} ],
  '_ALPC_COMPLETION_LIST_HEADER' : [ 0x180, {
    'StartMagic' : [ 0x0, ['unsigned long long']],
    'TotalSize' : [ 0x8, ['unsigned long']],
    'ListOffset' : [ 0xc, ['unsigned long']],
    'ListSize' : [ 0x10, ['unsigned long']],
    'BitmapOffset' : [ 0x14, ['unsigned long']],
    'BitmapSize' : [ 0x18, ['unsigned long']],
    'DataOffset' : [ 0x1c, ['unsigned long']],
    'DataSize' : [ 0x20, ['unsigned long']],
    'AttributeFlags' : [ 0x24, ['unsigned long']],
    'AttributeSize' : [ 0x28, ['unsigned long']],
    'State' : [ 0x40, ['_ALPC_COMPLETION_LIST_STATE']],
    'LastMessageId' : [ 0x48, ['unsigned long']],
    'LastCallbackId' : [ 0x4c, ['unsigned long']],
    'PostCount' : [ 0x80, ['unsigned long']],
    'ReturnCount' : [ 0xc0, ['unsigned long']],
    'LogSequenceNumber' : [ 0x100, ['unsigned long']],
    'UserLock' : [ 0x140, ['_RTL_SRWLOCK']],
    'EndMagic' : [ 0x148, ['unsigned long long']],
} ],
  '_IMAGE_DEBUG_DIRECTORY' : [ 0x1c, {
    'Characteristics' : [ 0x0, ['unsigned long']],
    'TimeDateStamp' : [ 0x4, ['unsigned long']],
    'MajorVersion' : [ 0x8, ['unsigned short']],
    'MinorVersion' : [ 0xa, ['unsigned short']],
    'Type' : [ 0xc, ['unsigned long']],
    'SizeOfData' : [ 0x10, ['unsigned long']],
    'AddressOfRawData' : [ 0x14, ['unsigned long']],
    'PointerToRawData' : [ 0x18, ['unsigned long']],
} ],
  '_WHEA_AER_ENDPOINT_DESCRIPTOR' : [ 0x20, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'Slot' : [ 0x8, ['_WHEA_PCI_SLOT_NUMBER']],
    'DeviceControl' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['_AER_ENDPOINT_DESCRIPTOR_FLAGS']],
    'UncorrectableErrorMask' : [ 0x10, ['unsigned long']],
    'UncorrectableErrorSeverity' : [ 0x14, ['unsigned long']],
    'CorrectableErrorMask' : [ 0x18, ['unsigned long']],
    'AdvancedCapsAndControl' : [ 0x1c, ['unsigned long']],
} ],
  '_MI_SYSTEM_TRIM_STATE' : [ 0x40, {
    'ExpansionLock' : [ 0x0, ['unsigned long']],
    'TrimInProgressCount' : [ 0x4, ['long']],
    'PeriodicWorkingSetEvent' : [ 0x8, ['_KEVENT']],
    'TrimAllPageFaultCount' : [ 0x18, ['array', 3, ['unsigned long']]],
} ],
  '_ETW_WMITRACE_WORK' : [ 0xf0, {
    'LoggerId' : [ 0x0, ['unsigned long']],
    'SpareUlong' : [ 0x4, ['unsigned long']],
    'LoggerName' : [ 0x8, ['array', 65, ['unsigned char']]],
    'FileName' : [ 0x49, ['array', 129, ['unsigned char']]],
    'MaximumFileSize' : [ 0xcc, ['unsigned long']],
    'MinBuffers' : [ 0xd0, ['unsigned long']],
    'MaxBuffers' : [ 0xd4, ['unsigned long']],
    'BufferSize' : [ 0xd8, ['unsigned long']],
    'Mode' : [ 0xdc, ['unsigned long']],
    'FlushTimer' : [ 0xe0, ['unsigned long']],
    'MatchAny' : [ 0x8, ['unsigned long long']],
    'MatchAll' : [ 0x10, ['unsigned long long']],
    'EnableProperty' : [ 0x18, ['unsigned long']],
    'Guid' : [ 0x1c, ['_GUID']],
    'Level' : [ 0x2c, ['unsigned char']],
    'Status' : [ 0xe8, ['long']],
} ],
  '_MI_ZERO_COST_COUNTS' : [ 0x10, {
    'NativeSum' : [ 0x0, ['unsigned long long']],
    'CachedSum' : [ 0x8, ['unsigned long long']],
} ],
  '_CHILD_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'List' : [ 0x4, ['unsigned long']],
} ],
  '_IO_RESOURCE_LIST' : [ 0x28, {
    'Version' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'Count' : [ 0x4, ['unsigned long']],
    'Descriptors' : [ 0x8, ['array', 1, ['_IO_RESOURCE_DESCRIPTOR']]],
} ],
  '_ARMCE_DBGKD_CONTROL_SET' : [ 0xc, {
    'Continue' : [ 0x0, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x4, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0x8, ['unsigned long']],
} ],
  '_MI_RESAVAIL_TRACKER' : [ 0x200, {
    'AllocateKernelStack' : [ 0x0, ['unsigned long']],
    'AllocateGrowKernelStack' : [ 0x4, ['unsigned long']],
    'FreeKernelStack' : [ 0x8, ['unsigned long']],
    'FreeKernelStackError' : [ 0xc, ['unsigned long']],
    'FreeGrowKernelStackError' : [ 0x10, ['unsigned long']],
    'AllocateCreateProcess' : [ 0x14, ['unsigned long']],
    'FreeCreateProcessError' : [ 0x18, ['unsigned long']],
    'FreeDeleteProcess' : [ 0x1c, ['unsigned long']],
    'FreeCleanProcess' : [ 0x20, ['unsigned long']],
    'FreeCleanProcessError' : [ 0x24, ['unsigned long']],
    'AllocateAddProcessWsMetaPage' : [ 0x28, ['unsigned long']],
    'AllocateWsIncrease' : [ 0x2c, ['unsigned long']],
    'FreeWsIncreaseError' : [ 0x30, ['unsigned long']],
    'FreeWsIncreaseErrorMax' : [ 0x34, ['unsigned long']],
    'FreeWsDecrease' : [ 0x38, ['unsigned long']],
    'AllocateWorkingSetPage' : [ 0x3c, ['unsigned long']],
    'FreeWorkingSetPageError' : [ 0x40, ['unsigned long']],
    'FreeDeletePteRange' : [ 0x44, ['unsigned long']],
    'AllocatePageTablesForProcessMetadata' : [ 0x48, ['unsigned long']],
    'FreePageTablesForProcessMetadataError2' : [ 0x4c, ['unsigned long']],
    'AllocatePageTablesForSystem' : [ 0x50, ['unsigned long']],
    'FreePageTablesExcess' : [ 0x54, ['unsigned long']],
    'FreeSystemVaPageTables' : [ 0x58, ['unsigned long']],
    'FreeSessionVaPageTables' : [ 0x5c, ['unsigned long']],
    'AllocateCreateSession' : [ 0x60, ['unsigned long']],
    'FreeSessionWsDereference' : [ 0x64, ['unsigned long']],
    'FreeSessionDereference' : [ 0x68, ['unsigned long']],
    'AllocateLockedSessionImage' : [ 0x6c, ['unsigned long']],
    'FreeLockedSessionImage' : [ 0x70, ['unsigned long']],
    'FreeSessionImageConversion' : [ 0x74, ['unsigned long']],
    'AllocateWsAdjustPageTable' : [ 0x78, ['unsigned long']],
    'FreeWsAdjustPageTable' : [ 0x7c, ['unsigned long']],
    'FreeWsAdjustPageTableError' : [ 0x80, ['unsigned long']],
    'AllocateNoLowMemory' : [ 0x84, ['unsigned long']],
    'AllocatePagedPoolLockedDown' : [ 0x88, ['unsigned long']],
    'FreePagedPoolLockedDown' : [ 0x8c, ['unsigned long']],
    'AllocateSystemBitmaps' : [ 0x90, ['unsigned long']],
    'FreeSystemBitmapsError' : [ 0x94, ['unsigned long']],
    'AllocateForMdl' : [ 0x98, ['unsigned long']],
    'FreeFromMdl' : [ 0x9c, ['unsigned long']],
    'AllocateForMdlPartition' : [ 0xa0, ['unsigned long']],
    'FreeFromMdlPartition' : [ 0xa4, ['unsigned long']],
    'FreeMdlExcess' : [ 0xa8, ['unsigned long']],
    'AllocateExpansionNonPagedPool' : [ 0xac, ['unsigned long']],
    'FreeExpansionNonPagedPool' : [ 0xb0, ['unsigned long']],
    'AllocateVad' : [ 0xb4, ['unsigned long']],
    'RemoveVad' : [ 0xb8, ['unsigned long']],
    'FreeVad' : [ 0xbc, ['unsigned long']],
    'AllocateContiguous' : [ 0xc0, ['unsigned long']],
    'FreeContiguousPages' : [ 0xc4, ['unsigned long']],
    'FreeContiguousError' : [ 0xc8, ['unsigned long']],
    'FreeLargePageMemory' : [ 0xcc, ['unsigned long']],
    'AllocateSystemWsles' : [ 0xd0, ['unsigned long']],
    'FreeSystemWsles' : [ 0xd4, ['unsigned long']],
    'AllocateSystemInitWs' : [ 0xd8, ['unsigned long']],
    'AllocateSessionInitWs' : [ 0xdc, ['unsigned long']],
    'FreeSessionInitWsError' : [ 0xe0, ['unsigned long']],
    'AllocateSystemImage' : [ 0xe4, ['unsigned long']],
    'AllocateSystemImageLoad' : [ 0xe8, ['unsigned long']],
    'AllocateSessionSharedImage' : [ 0xec, ['unsigned long']],
    'FreeSystemImageInitCode' : [ 0xf0, ['unsigned long']],
    'FreeSystemImageLargePageConversion' : [ 0xf4, ['unsigned long']],
    'FreeSystemImageError' : [ 0xf8, ['unsigned long']],
    'FreeSystemImageLoadExcess' : [ 0xfc, ['unsigned long']],
    'FreeUnloadSystemImage' : [ 0x100, ['unsigned long']],
    'FreeReloadBootImageLarge' : [ 0x104, ['unsigned long']],
    'FreeIndependent' : [ 0x108, ['unsigned long']],
    'AllocateHotRemove' : [ 0x10c, ['unsigned long']],
    'FreeHotAdd' : [ 0x110, ['unsigned long']],
    'AllocateBoot' : [ 0x114, ['unsigned long']],
    'FreeLoaderBlock' : [ 0x118, ['unsigned long']],
    'AllocateNonPagedSpecialPool' : [ 0x11c, ['unsigned long']],
    'FreeNonPagedSpecialPoolError' : [ 0x120, ['unsigned long']],
    'FreeNonPagedSpecialPool' : [ 0x124, ['unsigned long']],
    'AllocateSharedSegmentPage' : [ 0x128, ['unsigned long']],
    'FreeSharedSegmentPage' : [ 0x12c, ['unsigned long']],
    'AllocateZeroPage' : [ 0x130, ['unsigned long']],
    'FreeZeroPage' : [ 0x134, ['unsigned long']],
    'AllocateForPo' : [ 0x138, ['unsigned long']],
    'AllocateForPoForce' : [ 0x13c, ['unsigned long']],
    'FreeForPo' : [ 0x140, ['unsigned long']],
    'AllocateThreadHardFaultBehavior' : [ 0x144, ['unsigned long']],
    'FreeThreadHardFaultBehavior' : [ 0x148, ['unsigned long']],
    'ObtainFaultCharges' : [ 0x14c, ['unsigned long']],
    'FreeFaultCharges' : [ 0x150, ['unsigned long']],
    'AllocateStoreCharges' : [ 0x154, ['unsigned long']],
    'FreeStoreCharges' : [ 0x158, ['unsigned long']],
    'ObtainLockedPageCharge' : [ 0x180, ['unsigned long']],
    'FreeLockedPageCharge' : [ 0x1c0, ['unsigned long']],
    'AllocateStore' : [ 0x1c4, ['unsigned long']],
    'FreeStore' : [ 0x1c8, ['unsigned long']],
    'AllocateSystemImageProtos' : [ 0x1cc, ['unsigned long']],
    'FreeSystemImageProtos' : [ 0x1d0, ['unsigned long']],
    'AllocateModWriterCharge' : [ 0x1d4, ['unsigned long']],
    'FreeModWriterCharge' : [ 0x1d8, ['unsigned long']],
    'AllocateMappedWriterCharge' : [ 0x1dc, ['unsigned long']],
    'FreeMappedWriterCharge' : [ 0x1e0, ['unsigned long']],
    'AllocateRegistryCharges' : [ 0x1e4, ['unsigned long']],
    'FreeRegistryCharges' : [ 0x1e8, ['unsigned long']],
} ],
  '_WHEA_ERROR_RECORD_HEADER_FLAGS' : [ 0x4, {
    'Recovered' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PreviousError' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Simulated' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_XSAVE_AREA_HEADER' : [ 0x40, {
    'Mask' : [ 0x0, ['unsigned long long']],
    'CompactionMask' : [ 0x8, ['unsigned long long']],
    'Reserved2' : [ 0x10, ['array', 6, ['unsigned long long']]],
} ],
  '_RTL_CRITICAL_SECTION' : [ 0x18, {
    'DebugInfo' : [ 0x0, ['pointer', ['_RTL_CRITICAL_SECTION_DEBUG']]],
    'LockCount' : [ 0x4, ['long']],
    'RecursionCount' : [ 0x8, ['long']],
    'OwningThread' : [ 0xc, ['pointer', ['void']]],
    'LockSemaphore' : [ 0x10, ['pointer', ['void']]],
    'SpinCount' : [ 0x14, ['unsigned long']],
} ],
  '_PNP_DEVICE_COMPLETION_REQUEST' : [ 0x24, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceNode' : [ 0x8, ['pointer', ['_DEVICE_NODE']]],
    'Context' : [ 0xc, ['pointer', ['void']]],
    'CompletionState' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {768: 'DeviceNodeUnspecified', 769: 'DeviceNodeUninitialized', 770: 'DeviceNodeInitialized', 771: 'DeviceNodeDriversAdded', 772: 'DeviceNodeResourcesAssigned', 773: 'DeviceNodeStartPending', 774: 'DeviceNodeStartCompletion', 775: 'DeviceNodeStartPostWork', 776: 'DeviceNodeStarted', 777: 'DeviceNodeQueryStopped', 778: 'DeviceNodeStopped', 779: 'DeviceNodeRestartCompletion', 780: 'DeviceNodeEnumeratePending', 781: 'DeviceNodeEnumerateCompletion', 782: 'DeviceNodeAwaitingQueuedDeletion', 783: 'DeviceNodeAwaitingQueuedRemoval', 784: 'DeviceNodeQueryRemoved', 785: 'DeviceNodeRemovePendingCloses', 786: 'DeviceNodeRemoved', 787: 'DeviceNodeDeletePendingCloses', 788: 'DeviceNodeDeleted', 789: 'MaxDeviceNodeState'})]],
    'IrpPended' : [ 0x14, ['unsigned long']],
    'Status' : [ 0x18, ['long']],
    'Information' : [ 0x1c, ['pointer', ['void']]],
    'ReferenceCount' : [ 0x20, ['long']],
} ],
  '_MI_COMBINE_PAGE_LISTHEAD' : [ 0x8, {
    'Table' : [ 0x0, ['_RTL_AVL_TREE']],
    'Lock' : [ 0x4, ['long']],
} ],
  '_PHYSICAL_MEMORY_DESCRIPTOR' : [ 0x10, {
    'NumberOfRuns' : [ 0x0, ['unsigned long']],
    'NumberOfPages' : [ 0x4, ['unsigned long']],
    'Run' : [ 0x8, ['array', 1, ['_PHYSICAL_MEMORY_RUN']]],
} ],
  '__unnamed_248d' : [ 0x8, {
    'Start' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_248f' : [ 0x8, {
    'RangeCount' : [ 0x0, ['unsigned long']],
    'SetBitCount' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2491' : [ 0x8, {
    'Context1' : [ 0x0, ['unsigned long']],
    'Context2' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2493' : [ 0x8, {
    'DirtyVectorModifiedContext' : [ 0x0, ['__unnamed_248d']],
    'DirtyDataCaptureContext' : [ 0x0, ['__unnamed_248f']],
    'Raw' : [ 0x0, ['__unnamed_2491']],
} ],
  '_CM_DIRTY_VECTOR_LOG_ENTRY' : [ 0x28, {
    'Thread' : [ 0x0, ['pointer', ['_ETHREAD']]],
    'Operation' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'DirtyVectorModified', 1: 'DirtyDataCaptureStart', 2: 'DirtyDataCaptureEnd'})]],
    'Data' : [ 0x8, ['__unnamed_2493']],
    'Stack' : [ 0x10, ['array', 6, ['pointer', ['void']]]],
} ],
  '_KTRAP_FRAME' : [ 0x8c, {
    'DbgEbp' : [ 0x0, ['unsigned long']],
    'DbgEip' : [ 0x4, ['unsigned long']],
    'DbgArgMark' : [ 0x8, ['unsigned long']],
    'TempSegCs' : [ 0xc, ['unsigned short']],
    'Logging' : [ 0xe, ['unsigned char']],
    'FrameType' : [ 0xf, ['unsigned char']],
    'TempEsp' : [ 0x10, ['unsigned long']],
    'Dr0' : [ 0x14, ['unsigned long']],
    'Dr1' : [ 0x18, ['unsigned long']],
    'Dr2' : [ 0x1c, ['unsigned long']],
    'Dr3' : [ 0x20, ['unsigned long']],
    'Dr6' : [ 0x24, ['unsigned long']],
    'Dr7' : [ 0x28, ['unsigned long']],
    'SegGs' : [ 0x2c, ['unsigned long']],
    'SegEs' : [ 0x30, ['unsigned long']],
    'SegDs' : [ 0x34, ['unsigned long']],
    'Edx' : [ 0x38, ['unsigned long']],
    'Ecx' : [ 0x3c, ['unsigned long']],
    'Eax' : [ 0x40, ['unsigned long']],
    'PreviousPreviousMode' : [ 0x44, ['unsigned char']],
    'EntropyQueueDpc' : [ 0x45, ['unsigned char']],
    'Reserved' : [ 0x46, ['array', 2, ['unsigned char']]],
    'MxCsr' : [ 0x48, ['unsigned long']],
    'ExceptionList' : [ 0x4c, ['pointer', ['_EXCEPTION_REGISTRATION_RECORD']]],
    'SegFs' : [ 0x50, ['unsigned long']],
    'Edi' : [ 0x54, ['unsigned long']],
    'Esi' : [ 0x58, ['unsigned long']],
    'Ebx' : [ 0x5c, ['unsigned long']],
    'Ebp' : [ 0x60, ['unsigned long']],
    'ErrCode' : [ 0x64, ['unsigned long']],
    'Eip' : [ 0x68, ['unsigned long']],
    'SegCs' : [ 0x6c, ['unsigned long']],
    'EFlags' : [ 0x70, ['unsigned long']],
    'HardwareEsp' : [ 0x74, ['unsigned long']],
    'HardwareSegSs' : [ 0x78, ['unsigned long']],
    'V86Es' : [ 0x7c, ['unsigned long']],
    'V86Ds' : [ 0x80, ['unsigned long']],
    'V86Fs' : [ 0x84, ['unsigned long']],
    'V86Gs' : [ 0x88, ['unsigned long']],
} ],
  '_MI_SYSTEM_NODE_INFORMATION' : [ 0xb0, {
    'PagedPoolSListHead' : [ 0x0, ['_SLIST_HEADER']],
    'NonPagedPoolSListHead' : [ 0x8, ['array', 3, ['_SLIST_HEADER']]],
    'NonPagedPoolSListHeadNx' : [ 0x20, ['array', 3, ['_SLIST_HEADER']]],
    'CachedKernelStacks' : [ 0x38, ['array', 2, ['_CACHED_KSTACK_LIST']]],
    'NonPagedPoolLowestPage' : [ 0x68, ['unsigned long']],
    'NonPagedPoolHighestPage' : [ 0x6c, ['unsigned long']],
    'AllocatedNonPagedPool' : [ 0x70, ['unsigned long']],
    'PartialLargePoolRegions' : [ 0x74, ['unsigned long']],
    'PagesInPartialLargePoolRegions' : [ 0x78, ['unsigned long']],
    'CachedNonPagedPoolCount' : [ 0x7c, ['unsigned long']],
    'NonPagedPoolSpinLock' : [ 0x80, ['unsigned long']],
    'CachedNonPagedPool' : [ 0x84, ['pointer', ['_MMPFN']]],
    'NonPagedPoolFirstVa' : [ 0x88, ['pointer', ['void']]],
    'NonPagedPoolLastVa' : [ 0x8c, ['pointer', ['void']]],
    'NonPagedBitMap' : [ 0x90, ['array', 3, ['_RTL_BITMAP']]],
    'NonPagedHint' : [ 0xa8, ['array', 2, ['unsigned long']]],
} ],
  '_KLOCK_ENTRY_LOCK_STATE' : [ 0x8, {
    'CrossThreadReleasable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Busy' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 31, native_type='unsigned long')]],
    'InTree' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'LockState' : [ 0x0, ['pointer', ['void']]],
    'SessionState' : [ 0x4, ['pointer', ['void']]],
    'SessionId' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_24a5' : [ 0x4, {
    'FlushCompleting' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='long')]],
    'FlushInProgress' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='long')]],
    'Long' : [ 0x0, ['long']],
} ],
  '_MI_PARTITION_STORES' : [ 0x50, {
    'WriteAllStoreHintedPages' : [ 0x0, ['__unnamed_24a5']],
    'VirtualPageFileNumber' : [ 0x4, ['unsigned long']],
    'Registered' : [ 0x8, ['unsigned long']],
    'ReadClusterSizeMax' : [ 0xc, ['unsigned long']],
    'EvictFlushRequestCount' : [ 0x10, ['unsigned long']],
    'ModifiedWriteDisableCount' : [ 0x14, ['unsigned long']],
    'WriteIssueFailures' : [ 0x18, ['unsigned long']],
    'EvictionThread' : [ 0x1c, ['pointer', ['_ETHREAD']]],
    'EvictEvent' : [ 0x20, ['_KEVENT']],
    'EvictFlushCompleteEvent' : [ 0x30, ['_KEVENT']],
    'WriteSupportSListHead' : [ 0x40, ['_SLIST_HEADER']],
    'EvictFlushLock' : [ 0x48, ['long']],
    'ModifiedWriteFailedBitmap' : [ 0x4c, ['pointer', ['_RTL_BITMAP']]],
} ],
  '_EVENT_FILTER_HEADER' : [ 0x18, {
    'Id' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['array', 5, ['unsigned char']]],
    'InstanceId' : [ 0x8, ['unsigned long long']],
    'Size' : [ 0x10, ['unsigned long']],
    'NextOffset' : [ 0x14, ['unsigned long']],
} ],
  '_WAIT_CONTEXT_BLOCK' : [ 0x28, {
    'WaitQueueEntry' : [ 0x0, ['_KDEVICE_QUEUE_ENTRY']],
    'DmaWaitEntry' : [ 0x0, ['_LIST_ENTRY']],
    'NumberOfChannels' : [ 0x8, ['unsigned long']],
    'SyncCallback' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DmaContext' : [ 0xc, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reserved' : [ 0xc, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'DeviceRoutine' : [ 0x10, ['pointer', ['void']]],
    'DeviceContext' : [ 0x14, ['pointer', ['void']]],
    'NumberOfMapRegisters' : [ 0x18, ['unsigned long']],
    'DeviceObject' : [ 0x1c, ['pointer', ['void']]],
    'CurrentIrp' : [ 0x20, ['pointer', ['void']]],
    'BufferChainingDpc' : [ 0x24, ['pointer', ['_KDPC']]],
} ],
  '_CM_NAME_CONTROL_BLOCK' : [ 0x10, {
    'Compressed' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'RefCount' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
    'NameHash' : [ 0x4, ['_CM_NAME_HASH']],
    'ConvKey' : [ 0x4, ['unsigned long']],
    'NextHash' : [ 0x8, ['pointer', ['_CM_KEY_HASH']]],
    'NameLength' : [ 0xc, ['unsigned short']],
    'Name' : [ 0xe, ['array', 1, ['wchar']]],
} ],
  '_u' : [ 0x50, {
    'KeyNode' : [ 0x0, ['_CM_KEY_NODE']],
    'KeyValue' : [ 0x0, ['_CM_KEY_VALUE']],
    'KeySecurity' : [ 0x0, ['_CM_KEY_SECURITY']],
    'KeyIndex' : [ 0x0, ['_CM_KEY_INDEX']],
    'ValueData' : [ 0x0, ['_CM_BIG_DATA']],
    'KeyList' : [ 0x0, ['array', 1, ['unsigned long']]],
    'KeyString' : [ 0x0, ['array', 1, ['wchar']]],
} ],
  '_HBASE_BLOCK' : [ 0x1000, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Sequence1' : [ 0x4, ['unsigned long']],
    'Sequence2' : [ 0x8, ['unsigned long']],
    'TimeStamp' : [ 0xc, ['_LARGE_INTEGER']],
    'Major' : [ 0x14, ['unsigned long']],
    'Minor' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['unsigned long']],
    'Format' : [ 0x20, ['unsigned long']],
    'RootCell' : [ 0x24, ['unsigned long']],
    'Length' : [ 0x28, ['unsigned long']],
    'Cluster' : [ 0x2c, ['unsigned long']],
    'FileName' : [ 0x30, ['array', 64, ['unsigned char']]],
    'RmId' : [ 0x70, ['_GUID']],
    'LogId' : [ 0x80, ['_GUID']],
    'Flags' : [ 0x90, ['unsigned long']],
    'TmId' : [ 0x94, ['_GUID']],
    'GuidSignature' : [ 0xa4, ['unsigned long']],
    'LastReorganizeTime' : [ 0xa8, ['unsigned long long']],
    'Reserved1' : [ 0xb0, ['array', 83, ['unsigned long']]],
    'CheckSum' : [ 0x1fc, ['unsigned long']],
    'Reserved2' : [ 0x200, ['array', 882, ['unsigned long']]],
    'ThawTmId' : [ 0xfc8, ['_GUID']],
    'ThawRmId' : [ 0xfd8, ['_GUID']],
    'ThawLogId' : [ 0xfe8, ['_GUID']],
    'BootType' : [ 0xff8, ['unsigned long']],
    'BootRecover' : [ 0xffc, ['unsigned long']],
} ],
  '_GENERAL_LOOKASIDE_POOL' : [ 0x48, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'SingleListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Depth' : [ 0x8, ['unsigned short']],
    'MaximumDepth' : [ 0xa, ['unsigned short']],
    'TotalAllocates' : [ 0xc, ['unsigned long']],
    'AllocateMisses' : [ 0x10, ['unsigned long']],
    'AllocateHits' : [ 0x10, ['unsigned long']],
    'TotalFrees' : [ 0x14, ['unsigned long']],
    'FreeMisses' : [ 0x18, ['unsigned long']],
    'FreeHits' : [ 0x18, ['unsigned long']],
    'Type' : [ 0x1c, ['Enumeration', dict(target = 'long', choices = {0: 'NonPagedPoolBase', 1: 'PagedPool', 2: 'NonPagedPoolBaseMustSucceed', 3: 'DontUseThisType', 4: 'NonPagedPoolBaseCacheAligned', 5: 'PagedPoolCacheAligned', 6: 'NonPagedPoolBaseCacheAlignedMustS', 7: 'MaxPoolType', 34: 'NonPagedPoolMustSucceedSession', 516: 'NonPagedPoolNxCacheAligned', 35: 'DontUseThisTypeSession', 32: 'NonPagedPoolSession', 512: 'NonPagedPoolNx', 544: 'NonPagedPoolSessionNx', 36: 'NonPagedPoolCacheAlignedSession', 33: 'PagedPoolSession', 38: 'NonPagedPoolCacheAlignedMustSSession', 37: 'PagedPoolCacheAlignedSession'})]],
    'Tag' : [ 0x20, ['unsigned long']],
    'Size' : [ 0x24, ['unsigned long']],
    'AllocateEx' : [ 0x28, ['pointer', ['void']]],
    'Allocate' : [ 0x28, ['pointer', ['void']]],
    'FreeEx' : [ 0x2c, ['pointer', ['void']]],
    'Free' : [ 0x2c, ['pointer', ['void']]],
    'ListEntry' : [ 0x30, ['_LIST_ENTRY']],
    'LastTotalAllocates' : [ 0x38, ['unsigned long']],
    'LastAllocateMisses' : [ 0x3c, ['unsigned long']],
    'LastAllocateHits' : [ 0x3c, ['unsigned long']],
    'Future' : [ 0x40, ['array', 2, ['unsigned long']]],
} ],
  '_RTL_DYNAMIC_HASH_TABLE_ENTRY' : [ 0xc, {
    'Linkage' : [ 0x0, ['_LIST_ENTRY']],
    'Signature' : [ 0x8, ['unsigned long']],
} ],
  '_MI_FLAGS' : [ 0x4, {
    'EntireFlags' : [ 0x0, ['long']],
    'VerifierEnabled' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'KernelVerifierEnabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'LargePageKernel' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'StopOn4d' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'InitializationPhase' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 6, native_type='unsigned long')]],
    'PageKernelStacks' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'CheckZeroPages' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ProcessorPrewalks' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'ProcessorPostwalks' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'CoverageBuild' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'AccessBitReplacementDisabled' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'CheckExecute' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ZeroNonCachedByConverting' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'ZeroWriteCombinedByConverting' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ProtectedPagesEnabled' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'StrongCodeGuarantees' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'HardCodeGuarantees' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'ExecutePagePrivilegeRequired' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'StrongPageIdentity' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'SecureRelocations' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
} ],
  '_MI_SUB64K_FREE_RANGES' : [ 0x1c, {
    'BitMap' : [ 0x0, ['_RTL_BITMAP']],
    'ListEntry' : [ 0x8, ['_LIST_ENTRY']],
    'Vad' : [ 0x10, ['pointer', ['_MMVAD_SHORT']]],
    'SubListIndex' : [ 0x14, ['unsigned short']],
    'Hint' : [ 0x16, ['unsigned short']],
    'SetBits' : [ 0x18, ['unsigned long']],
} ],
  '_ETW_LAST_ENABLE_INFO' : [ 0x10, {
    'EnableFlags' : [ 0x0, ['_LARGE_INTEGER']],
    'LoggerId' : [ 0x8, ['unsigned short']],
    'Level' : [ 0xa, ['unsigned char']],
    'Enabled' : [ 0xb, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'InternalFlag' : [ 0xb, ['BitField', dict(start_bit = 1, end_bit = 8, native_type='unsigned char')]],
} ],
  '_M128A' : [ 0x10, {
    'Low' : [ 0x0, ['unsigned long long']],
    'High' : [ 0x8, ['long long']],
} ],
  '_HEAP_LOOKASIDE' : [ 0x30, {
    'ListHead' : [ 0x0, ['_SLIST_HEADER']],
    'Depth' : [ 0x8, ['unsigned short']],
    'MaximumDepth' : [ 0xa, ['unsigned short']],
    'TotalAllocates' : [ 0xc, ['unsigned long']],
    'AllocateMisses' : [ 0x10, ['unsigned long']],
    'TotalFrees' : [ 0x14, ['unsigned long']],
    'FreeMisses' : [ 0x18, ['unsigned long']],
    'LastTotalAllocates' : [ 0x1c, ['unsigned long']],
    'LastAllocateMisses' : [ 0x20, ['unsigned long']],
    'Counters' : [ 0x24, ['array', 2, ['unsigned long']]],
} ],
  '_KTIMER' : [ 0x28, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'DueTime' : [ 0x10, ['_ULARGE_INTEGER']],
    'TimerListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'Dpc' : [ 0x20, ['pointer', ['_KDPC']]],
    'Period' : [ 0x24, ['unsigned long']],
} ],
  '_RTL_ATOM_TABLE' : [ 0x1c, {
    'Signature' : [ 0x0, ['unsigned long']],
    'ReferenceCount' : [ 0x4, ['long']],
    'PushLock' : [ 0x8, ['_EX_PUSH_LOCK']],
    'ExHandleTable' : [ 0xc, ['pointer', ['_HANDLE_TABLE']]],
    'Flags' : [ 0x10, ['unsigned long']],
    'NumberOfBuckets' : [ 0x14, ['unsigned long']],
    'Buckets' : [ 0x18, ['array', 1, ['pointer', ['_RTL_ATOM_TABLE_ENTRY']]]],
} ],
  '__unnamed_24e2' : [ 0x18, {
    'RequestedTime' : [ 0x0, ['unsigned long long']],
    'ProgrammedTime' : [ 0x8, ['unsigned long long']],
    'TimerInfo' : [ 0x10, ['pointer', ['_DIAGNOSTIC_BUFFER']]],
} ],
  '_POP_POWER_ACTION' : [ 0x108, {
    'Updates' : [ 0x0, ['unsigned char']],
    'State' : [ 0x1, ['unsigned char']],
    'Shutdown' : [ 0x2, ['unsigned char']],
    'Action' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject', 8: 'PowerActionDisplayOff'})]],
    'LightestState' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'Flags' : [ 0xc, ['unsigned long']],
    'Status' : [ 0x10, ['long']],
    'DeviceType' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'PolicyDeviceSystemButton', 1: 'PolicyDeviceThermalZone', 2: 'PolicyDeviceBattery', 3: 'PolicyDeviceMemory', 4: 'PolicyInitiatePowerActionAPI', 5: 'PolicySetPowerStateAPI', 6: 'PolicyImmediateDozeS4', 7: 'PolicySystemIdle', 8: 'PolicyDeviceWakeAlarm', 9: 'PolicyDeviceFan', 10: 'PolicyCsBatterySaver', 11: 'PolicyImmediateDozeS4Predicted', 12: 'PolicyImmediateDozeS4PredictedNoWake', 13: 'PolicyDeviceMax'})]],
    'DeviceTypeFlags' : [ 0x18, ['unsigned long']],
    'IrpMinor' : [ 0x1c, ['unsigned char']],
    'Waking' : [ 0x1d, ['unsigned char']],
    'SystemState' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'NextSystemState' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'EffectiveSystemState' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'CurrentSystemState' : [ 0x2c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'ShutdownBugCode' : [ 0x30, ['pointer', ['_POP_SHUTDOWN_BUG_CHECK']]],
    'DevState' : [ 0x34, ['pointer', ['_POP_DEVICE_SYS_STATE']]],
    'HiberContext' : [ 0x38, ['pointer', ['_POP_HIBER_CONTEXT']]],
    'WakeTime' : [ 0x40, ['unsigned long long']],
    'SleepTime' : [ 0x48, ['unsigned long long']],
    'WakeFirstUnattendedTime' : [ 0x50, ['unsigned long long']],
    'WakeAlarmSignaled' : [ 0x58, ['Enumeration', dict(target = 'long', choices = {0: 'PoAc', 1: 'PoDc', 2: 'PoHot', 3: 'PoConditionMaximum'})]],
    'WakeAlarm' : [ 0x60, ['array', 3, ['__unnamed_24e2']]],
    'WakeAlarmPaused' : [ 0xa8, ['unsigned char']],
    'WakeAlarmLastTime' : [ 0xb0, ['unsigned long long']],
    'FilteredCapabilities' : [ 0xb8, ['SYSTEM_POWER_CAPABILITIES']],
} ],
  '_CM_KEY_VALUE' : [ 0x18, {
    'Signature' : [ 0x0, ['unsigned short']],
    'NameLength' : [ 0x2, ['unsigned short']],
    'DataLength' : [ 0x4, ['unsigned long']],
    'Data' : [ 0x8, ['unsigned long']],
    'Type' : [ 0xc, ['unsigned long']],
    'Flags' : [ 0x10, ['unsigned short']],
    'Spare' : [ 0x12, ['unsigned short']],
    'Name' : [ 0x14, ['array', 1, ['wchar']]],
} ],
  '_CM_KEY_HASH' : [ 0x10, {
    'ConvKey' : [ 0x0, ['unsigned long']],
    'NextHash' : [ 0x4, ['pointer', ['_CM_KEY_HASH']]],
    'KeyHive' : [ 0x8, ['pointer', ['_HHIVE']]],
    'KeyCell' : [ 0xc, ['unsigned long']],
} ],
  '_WHEA_IPF_CMC_DESCRIPTOR' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_PROCESSOR_IDLE_DEPENDENCY' : [ 0x8, {
    'ProcessorIndex' : [ 0x0, ['unsigned long']],
    'ExpectedState' : [ 0x4, ['unsigned char']],
    'AllowDeeperStates' : [ 0x5, ['unsigned char']],
    'LooseDependency' : [ 0x6, ['unsigned char']],
} ],
  '_AMD64_DBGKD_CONTROL_SET' : [ 0x1c, {
    'TraceFlag' : [ 0x0, ['unsigned long']],
    'Dr7' : [ 0x4, ['unsigned long long']],
    'CurrentSymbolStart' : [ 0xc, ['unsigned long long']],
    'CurrentSymbolEnd' : [ 0x14, ['unsigned long long']],
} ],
  '_KAPC_STATE' : [ 0x18, {
    'ApcListHead' : [ 0x0, ['array', 2, ['_LIST_ENTRY']]],
    'Process' : [ 0x10, ['pointer', ['_KPROCESS']]],
    'InProgressFlags' : [ 0x14, ['unsigned char']],
    'KernelApcInProgress' : [ 0x14, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'SpecialApcInProgress' : [ 0x14, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'KernelApcPending' : [ 0x15, ['unsigned char']],
    'UserApcPending' : [ 0x16, ['unsigned char']],
} ],
  '_PO_DEVICE_NOTIFY' : [ 0x3c, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'PowerChildren' : [ 0x8, ['_LIST_ENTRY']],
    'PowerParents' : [ 0x10, ['_LIST_ENTRY']],
    'TargetDevice' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'OrderLevel' : [ 0x1c, ['unsigned char']],
    'DeviceObject' : [ 0x20, ['pointer', ['_DEVICE_OBJECT']]],
    'DeviceName' : [ 0x24, ['pointer', ['unsigned short']]],
    'DriverName' : [ 0x28, ['pointer', ['unsigned short']]],
    'ChildCount' : [ 0x2c, ['unsigned long']],
    'ActiveChild' : [ 0x30, ['unsigned long']],
    'ParentCount' : [ 0x34, ['unsigned long']],
    'ActiveParent' : [ 0x38, ['unsigned long']],
} ],
  '_CM_KEY_SECURITY_CACHE_ENTRY' : [ 0x8, {
    'Cell' : [ 0x0, ['unsigned long']],
    'CachedSecurity' : [ 0x4, ['pointer', ['_CM_KEY_SECURITY_CACHE']]],
} ],
  '_FS_FILTER_CALLBACK_DATA' : [ 0x24, {
    'SizeOfFsFilterCallbackData' : [ 0x0, ['unsigned long']],
    'Operation' : [ 0x4, ['unsigned char']],
    'Reserved' : [ 0x5, ['unsigned char']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'FileObject' : [ 0xc, ['pointer', ['_FILE_OBJECT']]],
    'Parameters' : [ 0x10, ['_FS_FILTER_PARAMETERS']],
} ],
  '_GDI_TEB_BATCH32' : [ 0x4e0, {
    'Offset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'HasRenderingCommand' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HDC' : [ 0x4, ['unsigned long']],
    'Buffer' : [ 0x8, ['array', 310, ['unsigned long']]],
} ],
  '_WHEA_AER_ROOTPORT_DESCRIPTOR' : [ 0x24, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'Slot' : [ 0x8, ['_WHEA_PCI_SLOT_NUMBER']],
    'DeviceControl' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['_AER_ROOTPORT_DESCRIPTOR_FLAGS']],
    'UncorrectableErrorMask' : [ 0x10, ['unsigned long']],
    'UncorrectableErrorSeverity' : [ 0x14, ['unsigned long']],
    'CorrectableErrorMask' : [ 0x18, ['unsigned long']],
    'AdvancedCapsAndControl' : [ 0x1c, ['unsigned long']],
    'RootErrorCommand' : [ 0x20, ['unsigned long']],
} ],
  '_PROC_IDLE_STATE_ACCOUNTING' : [ 0x3e0, {
    'TotalTime' : [ 0x0, ['unsigned long long']],
    'CancelCount' : [ 0x8, ['unsigned long']],
    'FailureCount' : [ 0xc, ['unsigned long']],
    'SuccessCount' : [ 0x10, ['unsigned long']],
    'InvalidBucketIndex' : [ 0x14, ['unsigned long']],
    'MinTime' : [ 0x18, ['unsigned long long']],
    'MaxTime' : [ 0x20, ['unsigned long long']],
    'SelectionStatistics' : [ 0x28, ['_PPM_SELECTION_STATISTICS']],
    'IdleTimeBuckets' : [ 0xa0, ['array', 26, ['_PROC_IDLE_STATE_BUCKET']]],
} ],
  '_IMAGE_SECURITY_CONTEXT' : [ 0x4, {
    'PageHashes' : [ 0x0, ['pointer', ['void']]],
    'Value' : [ 0x0, ['unsigned long']],
    'SecurityBeingCreated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'SecurityMandatory' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PageHashPointer' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KENLISTMENT_HISTORY' : [ 0x8, {
    'Notification' : [ 0x0, ['unsigned long']],
    'NewState' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'KEnlistmentUninitialized', 256: 'KEnlistmentActive', 258: 'KEnlistmentPrepared', 259: 'KEnlistmentInDoubt', 260: 'KEnlistmentCommitted', 261: 'KEnlistmentCommittedNotify', 262: 'KEnlistmentCommitRequested', 257: 'KEnlistmentPreparing', 264: 'KEnlistmentDelegated', 265: 'KEnlistmentDelegatedDisconnected', 266: 'KEnlistmentPrePreparing', 263: 'KEnlistmentAborted', 268: 'KEnlistmentRecovering', 269: 'KEnlistmentAborting', 270: 'KEnlistmentReadOnly', 271: 'KEnlistmentOutcomeUnavailable', 272: 'KEnlistmentOffline', 273: 'KEnlistmentPrePrepared', 274: 'KEnlistmentInitialized', 267: 'KEnlistmentForgotten'})]],
} ],
  '_FAST_IO_DISPATCH' : [ 0x70, {
    'SizeOfFastIoDispatch' : [ 0x0, ['unsigned long']],
    'FastIoCheckIfPossible' : [ 0x4, ['pointer', ['void']]],
    'FastIoRead' : [ 0x8, ['pointer', ['void']]],
    'FastIoWrite' : [ 0xc, ['pointer', ['void']]],
    'FastIoQueryBasicInfo' : [ 0x10, ['pointer', ['void']]],
    'FastIoQueryStandardInfo' : [ 0x14, ['pointer', ['void']]],
    'FastIoLock' : [ 0x18, ['pointer', ['void']]],
    'FastIoUnlockSingle' : [ 0x1c, ['pointer', ['void']]],
    'FastIoUnlockAll' : [ 0x20, ['pointer', ['void']]],
    'FastIoUnlockAllByKey' : [ 0x24, ['pointer', ['void']]],
    'FastIoDeviceControl' : [ 0x28, ['pointer', ['void']]],
    'AcquireFileForNtCreateSection' : [ 0x2c, ['pointer', ['void']]],
    'ReleaseFileForNtCreateSection' : [ 0x30, ['pointer', ['void']]],
    'FastIoDetachDevice' : [ 0x34, ['pointer', ['void']]],
    'FastIoQueryNetworkOpenInfo' : [ 0x38, ['pointer', ['void']]],
    'AcquireForModWrite' : [ 0x3c, ['pointer', ['void']]],
    'MdlRead' : [ 0x40, ['pointer', ['void']]],
    'MdlReadComplete' : [ 0x44, ['pointer', ['void']]],
    'PrepareMdlWrite' : [ 0x48, ['pointer', ['void']]],
    'MdlWriteComplete' : [ 0x4c, ['pointer', ['void']]],
    'FastIoReadCompressed' : [ 0x50, ['pointer', ['void']]],
    'FastIoWriteCompressed' : [ 0x54, ['pointer', ['void']]],
    'MdlReadCompleteCompressed' : [ 0x58, ['pointer', ['void']]],
    'MdlWriteCompleteCompressed' : [ 0x5c, ['pointer', ['void']]],
    'FastIoQueryOpen' : [ 0x60, ['pointer', ['void']]],
    'ReleaseForModWrite' : [ 0x64, ['pointer', ['void']]],
    'AcquireForCcFlush' : [ 0x68, ['pointer', ['void']]],
    'ReleaseForCcFlush' : [ 0x6c, ['pointer', ['void']]],
} ],
  '_PERFINFO_PPM_STATE_SELECTION' : [ 0xc, {
    'SelectedState' : [ 0x0, ['unsigned long']],
    'VetoedStates' : [ 0x4, ['unsigned long']],
    'VetoReason' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_CM_CELL_REMAP_BLOCK' : [ 0x8, {
    'OldCell' : [ 0x0, ['unsigned long']],
    'NewCell' : [ 0x4, ['unsigned long']],
} ],
  '_PI_RESOURCE_ARBITER_ENTRY' : [ 0x38, {
    'DeviceArbiterList' : [ 0x0, ['_LIST_ENTRY']],
    'ResourceType' : [ 0x8, ['unsigned char']],
    'ArbiterInterface' : [ 0xc, ['pointer', ['_ARBITER_INTERFACE']]],
    'DeviceNode' : [ 0x10, ['pointer', ['_DEVICE_NODE']]],
    'ResourceList' : [ 0x14, ['_LIST_ENTRY']],
    'BestResourceList' : [ 0x1c, ['_LIST_ENTRY']],
    'BestConfig' : [ 0x24, ['_LIST_ENTRY']],
    'ActiveArbiterList' : [ 0x2c, ['_LIST_ENTRY']],
    'State' : [ 0x34, ['unsigned char']],
    'ResourcesChanged' : [ 0x35, ['unsigned char']],
} ],
  '_SECURITY_DESCRIPTOR' : [ 0x14, {
    'Revision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'Control' : [ 0x2, ['unsigned short']],
    'Owner' : [ 0x4, ['pointer', ['void']]],
    'Group' : [ 0x8, ['pointer', ['void']]],
    'Sacl' : [ 0xc, ['pointer', ['_ACL']]],
    'Dacl' : [ 0x10, ['pointer', ['_ACL']]],
} ],
  '_MODWRITER_FLAGS' : [ 0x4, {
    'KeepForever' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Networked' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'IoPriority' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 5, native_type='unsigned long')]],
    'ModifiedStoreWrite' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
} ],
  '_MI_PTE_CHAIN_HEAD' : [ 0x18, {
    'Flink' : [ 0x0, ['_MMPTE']],
    'Blink' : [ 0x8, ['_MMPTE']],
    'PteBase' : [ 0x10, ['pointer', ['_MMPTE']]],
} ],
  '_PPM_SELECTION_MENU_ENTRY' : [ 0x10, {
    'StrictDependency' : [ 0x0, ['unsigned char']],
    'InitiatingState' : [ 0x1, ['unsigned char']],
    'DependentState' : [ 0x2, ['unsigned char']],
    'StateIndex' : [ 0x4, ['unsigned long']],
    'Dependencies' : [ 0x8, ['unsigned long']],
    'DependencyList' : [ 0xc, ['pointer', ['_PPM_SELECTION_DEPENDENCY']]],
} ],
  '_MI_PAGING_FILE_SPACE_BITMAPS' : [ 0x14, {
    'RefCount' : [ 0x0, ['unsigned long']],
    'Anchor' : [ 0x0, ['pointer', ['_MI_PAGING_FILE_SPACE_BITMAPS']]],
    'AllocationBitmap' : [ 0x4, ['_RTL_BITMAP']],
    'ReservationBitmap' : [ 0xc, ['_RTL_BITMAP']],
    'EvictedBitmap' : [ 0xc, ['_RTL_BITMAP']],
} ],
  '_KQUEUE' : [ 0x28, {
    'Header' : [ 0x0, ['_DISPATCHER_HEADER']],
    'EntryListHead' : [ 0x10, ['_LIST_ENTRY']],
    'CurrentCount' : [ 0x18, ['unsigned long']],
    'MaximumCount' : [ 0x1c, ['unsigned long']],
    'ThreadListHead' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '_MI_COMBINE_WORKITEM' : [ 0x14, {
    'NextEntry' : [ 0x0, ['pointer', ['void']]],
    'WorkItem' : [ 0x4, ['_WORK_QUEUE_ITEM']],
} ],
  '_RTL_USER_PROCESS_PARAMETERS' : [ 0x2a4, {
    'MaximumLength' : [ 0x0, ['unsigned long']],
    'Length' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'DebugFlags' : [ 0xc, ['unsigned long']],
    'ConsoleHandle' : [ 0x10, ['pointer', ['void']]],
    'ConsoleFlags' : [ 0x14, ['unsigned long']],
    'StandardInput' : [ 0x18, ['pointer', ['void']]],
    'StandardOutput' : [ 0x1c, ['pointer', ['void']]],
    'StandardError' : [ 0x20, ['pointer', ['void']]],
    'CurrentDirectory' : [ 0x24, ['_CURDIR']],
    'DllPath' : [ 0x30, ['_UNICODE_STRING']],
    'ImagePathName' : [ 0x38, ['_UNICODE_STRING']],
    'CommandLine' : [ 0x40, ['_UNICODE_STRING']],
    'Environment' : [ 0x48, ['pointer', ['void']]],
    'StartingX' : [ 0x4c, ['unsigned long']],
    'StartingY' : [ 0x50, ['unsigned long']],
    'CountX' : [ 0x54, ['unsigned long']],
    'CountY' : [ 0x58, ['unsigned long']],
    'CountCharsX' : [ 0x5c, ['unsigned long']],
    'CountCharsY' : [ 0x60, ['unsigned long']],
    'FillAttribute' : [ 0x64, ['unsigned long']],
    'WindowFlags' : [ 0x68, ['unsigned long']],
    'ShowWindowFlags' : [ 0x6c, ['unsigned long']],
    'WindowTitle' : [ 0x70, ['_UNICODE_STRING']],
    'DesktopInfo' : [ 0x78, ['_UNICODE_STRING']],
    'ShellInfo' : [ 0x80, ['_UNICODE_STRING']],
    'RuntimeData' : [ 0x88, ['_UNICODE_STRING']],
    'CurrentDirectores' : [ 0x90, ['array', 32, ['_RTL_DRIVE_LETTER_CURDIR']]],
    'EnvironmentSize' : [ 0x290, ['unsigned long']],
    'EnvironmentVersion' : [ 0x294, ['unsigned long']],
    'PackageDependencyData' : [ 0x298, ['pointer', ['void']]],
    'ProcessGroupId' : [ 0x29c, ['unsigned long']],
    'LoaderThreads' : [ 0x2a0, ['unsigned long']],
} ],
  '_PHYSICAL_MEMORY_RUN' : [ 0x8, {
    'BasePage' : [ 0x0, ['unsigned long']],
    'PageCount' : [ 0x4, ['unsigned long']],
} ],
  '_RTL_SRWLOCK' : [ 0x4, {
    'Locked' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Waiting' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Waking' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'MultipleShared' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Shared' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'Value' : [ 0x0, ['unsigned long']],
    'Ptr' : [ 0x0, ['pointer', ['void']]],
} ],
  '_KTMOBJECT_NAMESPACE_LINK' : [ 0x14, {
    'Links' : [ 0x0, ['_RTL_BALANCED_LINKS']],
    'Expired' : [ 0x10, ['unsigned char']],
} ],
  '_CACHE_MANAGER_CALLBACKS' : [ 0x10, {
    'AcquireForLazyWrite' : [ 0x0, ['pointer', ['void']]],
    'ReleaseFromLazyWrite' : [ 0x4, ['pointer', ['void']]],
    'AcquireForReadAhead' : [ 0x8, ['pointer', ['void']]],
    'ReleaseFromReadAhead' : [ 0xc, ['pointer', ['void']]],
} ],
  '_PROC_PERF_LOAD' : [ 0x2, {
    'BusyPercentage' : [ 0x0, ['unsigned char']],
    'FrequencyPercentage' : [ 0x1, ['unsigned char']],
} ],
  '_RTL_RANGE' : [ 0x20, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'UserData' : [ 0x10, ['pointer', ['void']]],
    'Owner' : [ 0x14, ['pointer', ['void']]],
    'Attributes' : [ 0x18, ['unsigned char']],
    'Flags' : [ 0x19, ['unsigned char']],
} ],
  '_LOCK_HEADER' : [ 0x10, {
    'LockTree' : [ 0x0, ['_RTL_AVL_TREE']],
    'Count' : [ 0x4, ['unsigned long']],
    'Lock' : [ 0x8, ['unsigned long']],
    'Valid' : [ 0xc, ['unsigned long']],
} ],
  '_WHEA_IPF_MCA_DESCRIPTOR' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_SYSTEM_POWER_POLICY' : [ 0xe8, {
    'Revision' : [ 0x0, ['unsigned long']],
    'PowerButton' : [ 0x4, ['POWER_ACTION_POLICY']],
    'SleepButton' : [ 0x10, ['POWER_ACTION_POLICY']],
    'LidClose' : [ 0x1c, ['POWER_ACTION_POLICY']],
    'LidOpenWake' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'Reserved' : [ 0x2c, ['unsigned long']],
    'Idle' : [ 0x30, ['POWER_ACTION_POLICY']],
    'IdleTimeout' : [ 0x3c, ['unsigned long']],
    'IdleSensitivity' : [ 0x40, ['unsigned char']],
    'DynamicThrottle' : [ 0x41, ['unsigned char']],
    'Spare2' : [ 0x42, ['array', 2, ['unsigned char']]],
    'MinSleep' : [ 0x44, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'MaxSleep' : [ 0x48, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'ReducedLatencySleep' : [ 0x4c, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'WinLogonFlags' : [ 0x50, ['unsigned long']],
    'Spare3' : [ 0x54, ['unsigned long']],
    'DozeS4Timeout' : [ 0x58, ['unsigned long']],
    'BroadcastCapacityResolution' : [ 0x5c, ['unsigned long']],
    'DischargePolicy' : [ 0x60, ['array', 4, ['SYSTEM_POWER_LEVEL']]],
    'VideoTimeout' : [ 0xc0, ['unsigned long']],
    'VideoDimDisplay' : [ 0xc4, ['unsigned char']],
    'VideoReserved' : [ 0xc8, ['array', 3, ['unsigned long']]],
    'SpindownTimeout' : [ 0xd4, ['unsigned long']],
    'OptimizeForPower' : [ 0xd8, ['unsigned char']],
    'FanThrottleTolerance' : [ 0xd9, ['unsigned char']],
    'ForcedThrottle' : [ 0xda, ['unsigned char']],
    'MinThrottle' : [ 0xdb, ['unsigned char']],
    'OverThrottled' : [ 0xdc, ['POWER_ACTION_POLICY']],
} ],
  '_PS_PROTECTION' : [ 0x1, {
    'Level' : [ 0x0, ['unsigned char']],
    'Type' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Audit' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Signer' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
} ],
  '_MSUBSECTION' : [ 0x44, {
    'Core' : [ 0x0, ['_SUBSECTION']],
    'SubsectionNode' : [ 0x28, ['_RTL_BALANCED_NODE']],
    'DereferenceList' : [ 0x34, ['_LIST_ENTRY']],
    'NumberOfMappedViews' : [ 0x3c, ['unsigned long']],
    'NumberOfPfnReferences' : [ 0x40, ['unsigned long']],
} ],
  '_SE_AUDIT_PROCESS_CREATION_INFO' : [ 0x4, {
    'ImageFileName' : [ 0x0, ['pointer', ['_OBJECT_NAME_INFORMATION']]],
} ],
  '_HEAP_ENTRY_EXTRA' : [ 0x8, {
    'AllocatorBackTraceIndex' : [ 0x0, ['unsigned short']],
    'TagIndex' : [ 0x2, ['unsigned short']],
    'Settable' : [ 0x4, ['unsigned long']],
    'ZeroInit' : [ 0x0, ['unsigned long long']],
} ],
  '_VF_POOL_TRACE' : [ 0x40, {
    'Address' : [ 0x0, ['pointer', ['void']]],
    'Size' : [ 0x4, ['unsigned long']],
    'Thread' : [ 0x8, ['pointer', ['_ETHREAD']]],
    'StackTrace' : [ 0xc, ['array', 13, ['pointer', ['void']]]],
} ],
  '__unnamed_259c' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'Flags' : [ 0x0, ['_MM_SESSION_SPACE_FLAGS']],
} ],
  '_MM_SESSION_SPACE' : [ 0x2000, {
    'ReferenceCount' : [ 0x0, ['long']],
    'u' : [ 0x4, ['__unnamed_259c']],
    'SessionId' : [ 0x8, ['unsigned long']],
    'ProcessReferenceToSession' : [ 0xc, ['long']],
    'ProcessList' : [ 0x10, ['_LIST_ENTRY']],
    'SessionPageDirectoryIndex' : [ 0x18, ['unsigned long']],
    'NonPagablePages' : [ 0x1c, ['unsigned long']],
    'CommittedPages' : [ 0x20, ['unsigned long']],
    'PagedPoolStart' : [ 0x24, ['pointer', ['void']]],
    'PagedPoolEnd' : [ 0x28, ['pointer', ['void']]],
    'SessionObject' : [ 0x2c, ['pointer', ['void']]],
    'SessionObjectHandle' : [ 0x30, ['pointer', ['void']]],
    'SessionPoolAllocationFailures' : [ 0x34, ['array', 4, ['unsigned long']]],
    'ImageTree' : [ 0x44, ['_RTL_AVL_TREE']],
    'LocaleId' : [ 0x48, ['unsigned long']],
    'AttachCount' : [ 0x4c, ['unsigned long']],
    'AttachGate' : [ 0x50, ['_KGATE']],
    'WsListEntry' : [ 0x60, ['_LIST_ENTRY']],
    'Lookaside' : [ 0x80, ['array', 24, ['_GENERAL_LOOKASIDE']]],
    'Session' : [ 0xc80, ['_MMSESSION']],
    'PagedPoolInfo' : [ 0xc94, ['_MM_PAGED_POOL_INFO']],
    'Vm' : [ 0xcb0, ['_MMSUPPORT']],
    'Wsle' : [ 0xd30, ['pointer', ['_MMWSLE']]],
    'DriverUnload' : [ 0xd34, ['_MI_SESSION_DRIVER_UNLOAD']],
    'PagedPool' : [ 0xd40, ['_POOL_DESCRIPTOR']],
    'PageTables' : [ 0x1e80, ['pointer', ['_MMPTE']]],
    'PagedPoolBitBuffer' : [ 0x1e84, ['array', 32, ['unsigned long']]],
    'SpecialPool' : [ 0x1f08, ['_MI_SPECIAL_POOL']],
    'SessionPteLock' : [ 0x1f50, ['_EX_PUSH_LOCK']],
    'PoolBigEntriesInUse' : [ 0x1f54, ['long']],
    'PagedPoolPdeCount' : [ 0x1f58, ['unsigned long']],
    'SpecialPoolPdeCount' : [ 0x1f5c, ['unsigned long']],
    'DynamicSessionPdeCount' : [ 0x1f60, ['unsigned long']],
    'SystemPteInfo' : [ 0x1f64, ['_MI_SYSTEM_PTE_TYPE']],
    'PoolTrackTableExpansion' : [ 0x1f98, ['pointer', ['void']]],
    'PoolTrackTableExpansionSize' : [ 0x1f9c, ['unsigned long']],
    'PoolTrackBigPages' : [ 0x1fa0, ['pointer', ['void']]],
    'PoolTrackBigPagesSize' : [ 0x1fa4, ['unsigned long']],
    'IoState' : [ 0x1fa8, ['Enumeration', dict(target = 'long', choices = {1: 'IoSessionStateCreated', 2: 'IoSessionStateInitialized', 3: 'IoSessionStateConnected', 4: 'IoSessionStateDisconnected', 5: 'IoSessionStateDisconnectedLoggedOn', 6: 'IoSessionStateLoggedOn', 7: 'IoSessionStateLoggedOff', 8: 'IoSessionStateTerminated', 9: 'IoSessionStateMax'})]],
    'IoStateSequence' : [ 0x1fac, ['unsigned long']],
    'IoNotificationEvent' : [ 0x1fb0, ['_KEVENT']],
    'ServerSilo' : [ 0x1fc0, ['pointer', ['_EJOB']]],
    'CreateTime' : [ 0x1fc8, ['unsigned long long']],
} ],
  '_MMPAGE_FILE_EXPANSION' : [ 0x38, {
    'Segment' : [ 0x0, ['pointer', ['_SEGMENT']]],
    'DereferenceList' : [ 0x4, ['_LIST_ENTRY']],
    'Partition' : [ 0xc, ['pointer', ['_MI_PARTITION']]],
    'RequestedExpansionSize' : [ 0x10, ['unsigned long']],
    'ActualExpansion' : [ 0x14, ['unsigned long']],
    'Event' : [ 0x18, ['_KEVENT']],
    'InProgress' : [ 0x28, ['long']],
    'u' : [ 0x2c, ['_MMPAGE_FILE_EXPANSION_FLAGS']],
    'ActiveEntry' : [ 0x30, ['pointer', ['pointer', ['void']]]],
    'AttemptForCantExtend' : [ 0x34, ['unsigned char']],
    'PageFileContract' : [ 0x35, ['unsigned char']],
} ],
  '_WHEA_XPF_MC_BANK_DESCRIPTOR' : [ 0x1c, {
    'BankNumber' : [ 0x0, ['unsigned char']],
    'ClearOnInitialization' : [ 0x1, ['unsigned char']],
    'StatusDataFormat' : [ 0x2, ['unsigned char']],
    'Flags' : [ 0x3, ['_XPF_MC_BANK_FLAGS']],
    'ControlMsr' : [ 0x4, ['unsigned long']],
    'StatusMsr' : [ 0x8, ['unsigned long']],
    'AddressMsr' : [ 0xc, ['unsigned long']],
    'MiscMsr' : [ 0x10, ['unsigned long']],
    'ControlData' : [ 0x14, ['unsigned long long']],
} ],
  '__unnamed_25ad' : [ 0x4, {
    'LongFlags2' : [ 0x0, ['unsigned long']],
    'VadFlags2' : [ 0x0, ['_MMVAD_FLAGS2']],
} ],
  '__unnamed_25b1' : [ 0x4, {
    'SequentialVa' : [ 0x0, ['_MI_VAD_SEQUENTIAL_INFO']],
    'ExtendedInfo' : [ 0x0, ['pointer', ['_MMEXTEND_INFO']]],
} ],
  '_MMVAD' : [ 0x4c, {
    'Core' : [ 0x0, ['_MMVAD_SHORT']],
    'u2' : [ 0x28, ['__unnamed_25ad']],
    'Subsection' : [ 0x2c, ['pointer', ['_SUBSECTION']]],
    'FirstPrototypePte' : [ 0x30, ['pointer', ['_MMPTE']]],
    'LastContiguousPte' : [ 0x34, ['pointer', ['_MMPTE']]],
    'ViewLinks' : [ 0x38, ['_LIST_ENTRY']],
    'VadsProcess' : [ 0x40, ['pointer', ['_EPROCESS']]],
    'u4' : [ 0x44, ['__unnamed_25b1']],
    'FileObject' : [ 0x48, ['pointer', ['_FILE_OBJECT']]],
} ],
  '_SEP_SID_VALUES_BLOCK' : [ 0x10, {
    'BlockLength' : [ 0x0, ['unsigned long']],
    'ReferenceCount' : [ 0x4, ['long']],
    'SidCount' : [ 0x8, ['unsigned long']],
    'SidValuesStart' : [ 0xc, ['unsigned long']],
} ],
  '_MI_PARTITION_STATE' : [ 0x38, {
    'PartitionLock' : [ 0x0, ['unsigned long']],
    'PartitionIdLock' : [ 0x4, ['_EX_PUSH_LOCK']],
    'InitialPartitionIdBits' : [ 0x8, ['unsigned long long']],
    'PartitionList' : [ 0x10, ['_LIST_ENTRY']],
    'PartitionIdBitmap' : [ 0x18, ['pointer', ['_RTL_BITMAP']]],
    'InitialPartitionIdBitmap' : [ 0x1c, ['_RTL_BITMAP']],
    'TempPartitionPointers' : [ 0x24, ['array', 1, ['pointer', ['_MI_PARTITION']]]],
    'Partition' : [ 0x28, ['pointer', ['pointer', ['_MI_PARTITION']]]],
    'TotalPagesInChildPartitions' : [ 0x2c, ['unsigned long']],
    'CrossPartitionDenials' : [ 0x30, ['unsigned long']],
} ],
  '_MMMOD_WRITER_LISTHEAD' : [ 0x18, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Gate' : [ 0x8, ['_KGATE']],
    'Event' : [ 0x8, ['_KEVENT']],
} ],
  '_CM_RM' : [ 0x58, {
    'RmListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'TransactionListHead' : [ 0x8, ['_LIST_ENTRY']],
    'TmHandle' : [ 0x10, ['pointer', ['void']]],
    'Tm' : [ 0x14, ['pointer', ['void']]],
    'RmHandle' : [ 0x18, ['pointer', ['void']]],
    'KtmRm' : [ 0x1c, ['pointer', ['void']]],
    'RefCount' : [ 0x20, ['unsigned long']],
    'ContainerNum' : [ 0x24, ['unsigned long']],
    'ContainerSize' : [ 0x28, ['unsigned long long']],
    'CmHive' : [ 0x30, ['pointer', ['_CMHIVE']]],
    'LogFileObject' : [ 0x34, ['pointer', ['void']]],
    'MarshallingContext' : [ 0x38, ['pointer', ['void']]],
    'RmFlags' : [ 0x3c, ['unsigned long']],
    'LogStartStatus1' : [ 0x40, ['long']],
    'LogStartStatus2' : [ 0x44, ['long']],
    'BaseLsn' : [ 0x48, ['unsigned long long']],
    'RmLock' : [ 0x50, ['pointer', ['_ERESOURCE']]],
} ],
  '_NONOPAQUE_OPLOCK' : [ 0x50, {
    'IrpExclusiveOplock' : [ 0x0, ['pointer', ['_IRP']]],
    'FileObject' : [ 0x4, ['pointer', ['_FILE_OBJECT']]],
    'ExclusiveOplockOwner' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'ExclusiveOplockOwnerThread' : [ 0xc, ['pointer', ['_ETHREAD']]],
    'WaiterPriority' : [ 0x10, ['unsigned char']],
    'IrpOplocksR' : [ 0x14, ['_LIST_ENTRY']],
    'IrpOplocksRH' : [ 0x1c, ['_LIST_ENTRY']],
    'RHBreakQueue' : [ 0x24, ['_LIST_ENTRY']],
    'WaitingIrps' : [ 0x2c, ['_LIST_ENTRY']],
    'DelayAckFileObjectQueue' : [ 0x34, ['_LIST_ENTRY']],
    'AtomicQueue' : [ 0x3c, ['_LIST_ENTRY']],
    'DeleterParentKey' : [ 0x44, ['pointer', ['_GUID']]],
    'OplockState' : [ 0x48, ['unsigned long']],
    'FastMutex' : [ 0x4c, ['pointer', ['_FAST_MUTEX']]],
} ],
  '_MI_LARGEPAGE_MEMORY_INFO' : [ 0x10, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'ColoredPageInfoBase' : [ 0x8, ['pointer', ['_COLORED_PAGE_INFO']]],
    'PagesNeedZeroing' : [ 0xc, ['unsigned long']],
} ],
  '_OBJECT_HANDLE_COUNT_ENTRY' : [ 0x8, {
    'Process' : [ 0x0, ['pointer', ['_EPROCESS']]],
    'HandleCount' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'LockCount' : [ 0x4, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PROCESS_ENERGY_VALUES' : [ 0x90, {
    'Cycles' : [ 0x0, ['array', 4, ['array', 2, ['unsigned long long']]]],
    'DiskEnergy' : [ 0x40, ['unsigned long long']],
    'NetworkTailEnergy' : [ 0x48, ['unsigned long long']],
    'MBBTailEnergy' : [ 0x50, ['unsigned long long']],
    'NetworkTxRxBytes' : [ 0x58, ['unsigned long long']],
    'MBBTxRxBytes' : [ 0x60, ['unsigned long long']],
    'Foreground' : [ 0x68, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'WindowInformation' : [ 0x68, ['unsigned long']],
    'PixelArea' : [ 0x6c, ['unsigned long']],
    'PixelReportTimestamp' : [ 0x70, ['long long']],
    'PixelTime' : [ 0x78, ['unsigned long long']],
    'ForegroundReportTimestamp' : [ 0x80, ['long long']],
    'ForegroundTime' : [ 0x88, ['unsigned long long']],
} ],
  '_CLIENT_ID' : [ 0x8, {
    'UniqueProcess' : [ 0x0, ['pointer', ['void']]],
    'UniqueThread' : [ 0x4, ['pointer', ['void']]],
} ],
  '_WHEA_MEMORY_ERROR_SECTION' : [ 0x49, {
    'ValidBits' : [ 0x0, ['_WHEA_MEMORY_ERROR_SECTION_VALIDBITS']],
    'ErrorStatus' : [ 0x8, ['_WHEA_ERROR_STATUS']],
    'PhysicalAddress' : [ 0x10, ['unsigned long long']],
    'PhysicalAddressMask' : [ 0x18, ['unsigned long long']],
    'Node' : [ 0x20, ['unsigned short']],
    'Card' : [ 0x22, ['unsigned short']],
    'Module' : [ 0x24, ['unsigned short']],
    'Bank' : [ 0x26, ['unsigned short']],
    'Device' : [ 0x28, ['unsigned short']],
    'Row' : [ 0x2a, ['unsigned short']],
    'Column' : [ 0x2c, ['unsigned short']],
    'BitPosition' : [ 0x2e, ['unsigned short']],
    'RequesterId' : [ 0x30, ['unsigned long long']],
    'ResponderId' : [ 0x38, ['unsigned long long']],
    'TargetId' : [ 0x40, ['unsigned long long']],
    'ErrorType' : [ 0x48, ['unsigned char']],
} ],
  '_MI_COMMON_PAGE_STATE' : [ 0x2c, {
    'PageOfOnesPfn' : [ 0x0, ['pointer', ['_MMPFN']]],
    'PageOfOnes' : [ 0x4, ['unsigned long']],
    'DummyPagePfn' : [ 0x8, ['pointer', ['_MMPFN']]],
    'DummyPage' : [ 0xc, ['unsigned long']],
    'PageOfZeroes' : [ 0x10, ['unsigned long']],
    'ZeroMapping' : [ 0x14, ['pointer', ['void']]],
    'OnesMapping' : [ 0x18, ['pointer', ['void']]],
    'BitmapGapFrames' : [ 0x1c, ['array', 2, ['unsigned long']]],
    'PfnGapFrames' : [ 0x24, ['array', 2, ['unsigned long']]],
} ],
  '_KWAIT_STATUS_REGISTER' : [ 0x1, {
    'Flags' : [ 0x0, ['unsigned char']],
    'State' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'Affinity' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Priority' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Apc' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'UserApc' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'Alert' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_VI_DEADLOCK_RESOURCE' : [ 0x80, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'VfDeadlockUnknown', 1: 'VfDeadlockMutex', 2: 'VfDeadlockMutexAbandoned', 3: 'VfDeadlockFastMutex', 4: 'VfDeadlockFastMutexUnsafe', 5: 'VfDeadlockSpinLock', 6: 'VfDeadlockInStackQueuedSpinLock', 7: 'VfDeadlockUnusedSpinLock', 8: 'VfDeadlockEresource', 9: 'VfDeadlockTypeMaximum'})]],
    'NodeCount' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'RecursionCount' : [ 0x4, ['BitField', dict(start_bit = 16, end_bit = 32, native_type='unsigned long')]],
    'ResourceAddress' : [ 0x8, ['pointer', ['void']]],
    'ThreadOwner' : [ 0xc, ['pointer', ['_VI_DEADLOCK_THREAD']]],
    'ResourceList' : [ 0x10, ['_LIST_ENTRY']],
    'HashChainList' : [ 0x18, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x18, ['_LIST_ENTRY']],
    'StackTrace' : [ 0x20, ['array', 8, ['pointer', ['void']]]],
    'LastAcquireTrace' : [ 0x40, ['array', 8, ['pointer', ['void']]]],
    'LastReleaseTrace' : [ 0x60, ['array', 8, ['pointer', ['void']]]],
} ],
  '_DBGKD_GET_SET_BUS_DATA' : [ 0x14, {
    'BusDataType' : [ 0x0, ['unsigned long']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'SlotNumber' : [ 0x8, ['unsigned long']],
    'Offset' : [ 0xc, ['unsigned long']],
    'Length' : [ 0x10, ['unsigned long']],
} ],
  '_MMSECTION_FLAGS' : [ 0x4, {
    'BeingDeleted' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'BeingCreated' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'BeingPurged' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NoModifiedWriting' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'FailAllIo' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Image' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Based' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'File' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'AttemptingDelete' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'PrefetchCreated' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PhysicalMemory' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'Reserve' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'Commit' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'NoChange' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'WasPurged' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'UserReference' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'GlobalMemory' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'DeleteOnClose' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'FilePointerNull' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'PreferredNode' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 26, native_type='unsigned long')]],
    'GlobalOnlyPerSession' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'UserWritable' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'SystemVaAllocated' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'PreferredFsCompressionBoundary' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'UsingFileExtents' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_SECURITY_CLIENT_CONTEXT' : [ 0x3c, {
    'SecurityQos' : [ 0x0, ['_SECURITY_QUALITY_OF_SERVICE']],
    'ClientToken' : [ 0xc, ['pointer', ['void']]],
    'DirectlyAccessClientToken' : [ 0x10, ['unsigned char']],
    'DirectAccessEffectiveOnly' : [ 0x11, ['unsigned char']],
    'ServerIsRemote' : [ 0x12, ['unsigned char']],
    'ClientTokenControl' : [ 0x14, ['_TOKEN_CONTROL']],
} ],
  '_MI_VAD_ALLOCATION_CELL' : [ 0x1c, {
    'AllocationBitMap' : [ 0x0, ['_RTL_BITMAP']],
    'BitMapHint' : [ 0x8, ['unsigned long']],
    'LastAllocationSize' : [ 0xc, ['unsigned long']],
    'LastAllocationSizeHint' : [ 0x10, ['unsigned long']],
    'LowestBottomUpVadBit' : [ 0x14, ['unsigned long']],
    'LowestBottomUpAllocationAddress' : [ 0x18, ['pointer', ['void']]],
} ],
  '_MI_REVERSE_VIEW_MAP' : [ 0x18, {
    'ViewLinks' : [ 0x0, ['_LIST_ENTRY']],
    'SystemCacheVa' : [ 0x8, ['pointer', ['void']]],
    'SessionViewVa' : [ 0x8, ['pointer', ['void']]],
    'VadsProcess' : [ 0x8, ['pointer', ['_EPROCESS']]],
    'Type' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned long')]],
    'Subsection' : [ 0xc, ['pointer', ['_SUBSECTION']]],
    'SubsectionType' : [ 0xc, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'SectionOffset' : [ 0x10, ['unsigned long long']],
} ],
  '_IO_SECURITY_CONTEXT' : [ 0x10, {
    'SecurityQos' : [ 0x0, ['pointer', ['_SECURITY_QUALITY_OF_SERVICE']]],
    'AccessState' : [ 0x4, ['pointer', ['_ACCESS_STATE']]],
    'DesiredAccess' : [ 0x8, ['unsigned long']],
    'FullCreateOptions' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_25f2' : [ 0x20, {
    'Mdl' : [ 0x0, ['_MDL']],
    'Page' : [ 0x1c, ['array', 1, ['unsigned long']]],
} ],
  '_MI_PAGEFILE_TRACES' : [ 0x50, {
    'Status' : [ 0x0, ['long']],
    'PartitionId' : [ 0x4, ['unsigned short']],
    'Priority' : [ 0x6, ['unsigned char']],
    'IrpPriority' : [ 0x7, ['unsigned char']],
    'ReservationWrite' : [ 0x8, ['unsigned char']],
    'CurrentTime' : [ 0x10, ['_LARGE_INTEGER']],
    'AvailablePages' : [ 0x18, ['unsigned long']],
    'ModifiedPagesTotal' : [ 0x1c, ['unsigned long']],
    'ModifiedPagefilePages' : [ 0x20, ['unsigned long']],
    'ModifiedNoWritePages' : [ 0x24, ['unsigned long']],
    'ModifiedPagefileNoReservationPages' : [ 0x28, ['unsigned long']],
    'MdlHack' : [ 0x2c, ['__unnamed_25f2']],
} ],
  '_PROC_PERF_DOMAIN' : [ 0xb8, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Master' : [ 0x8, ['pointer', ['_KPRCB']]],
    'Members' : [ 0xc, ['_KAFFINITY_EX']],
    'ProcessorCount' : [ 0x18, ['unsigned long']],
    'Class' : [ 0x1c, ['unsigned char']],
    'Spare' : [ 0x1d, ['array', 3, ['unsigned char']]],
    'Processors' : [ 0x20, ['pointer', ['_PROC_PERF_CONSTRAINT']]],
    'GetFFHThrottleState' : [ 0x24, ['pointer', ['void']]],
    'TimeWindowHandler' : [ 0x28, ['pointer', ['void']]],
    'BoostPolicyHandler' : [ 0x2c, ['pointer', ['void']]],
    'BoostModeHandler' : [ 0x30, ['pointer', ['void']]],
    'EnergyPerfPreferenceHandler' : [ 0x34, ['pointer', ['void']]],
    'AutonomousActivityWindowHandler' : [ 0x38, ['pointer', ['void']]],
    'AutonomousModeHandler' : [ 0x3c, ['pointer', ['void']]],
    'ReinitializeHandler' : [ 0x40, ['pointer', ['void']]],
    'PerfSelectionHandler' : [ 0x44, ['pointer', ['void']]],
    'PerfControlHandler' : [ 0x48, ['pointer', ['void']]],
    'MaxFrequency' : [ 0x4c, ['unsigned long']],
    'NominalFrequency' : [ 0x50, ['unsigned long']],
    'MaxPercent' : [ 0x54, ['unsigned long']],
    'MinPerfPercent' : [ 0x58, ['unsigned long']],
    'MinThrottlePercent' : [ 0x5c, ['unsigned long']],
    'MinimumRelativePerformance' : [ 0x60, ['unsigned long long']],
    'NominalRelativePerformance' : [ 0x68, ['unsigned long long']],
    'Coordination' : [ 0x70, ['unsigned char']],
    'HardPlatformCap' : [ 0x71, ['unsigned char']],
    'AffinitizeControl' : [ 0x72, ['unsigned char']],
    'EfficientThrottle' : [ 0x73, ['unsigned char']],
    'AutonomousMode' : [ 0x74, ['unsigned char']],
    'SelectedPercent' : [ 0x78, ['unsigned long']],
    'SelectedFrequency' : [ 0x7c, ['unsigned long']],
    'DesiredPercent' : [ 0x80, ['unsigned long']],
    'MaxPolicyPercent' : [ 0x84, ['unsigned long']],
    'MinPolicyPercent' : [ 0x88, ['unsigned long']],
    'ConstrainedMaxPercent' : [ 0x8c, ['unsigned long']],
    'ConstrainedMinPercent' : [ 0x90, ['unsigned long']],
    'GuaranteedPercent' : [ 0x94, ['unsigned long']],
    'TolerancePercent' : [ 0x98, ['unsigned long']],
    'SelectedState' : [ 0xa0, ['unsigned long long']],
    'PerfChangeTime' : [ 0xa8, ['unsigned long long']],
    'PerfChangeIntervalCount' : [ 0xb0, ['unsigned long']],
    'Force' : [ 0xb4, ['unsigned char']],
    'ProvideGuidance' : [ 0xb5, ['unsigned char']],
} ],
  '_X86_DBGKD_CONTROL_SET' : [ 0x10, {
    'TraceFlag' : [ 0x0, ['unsigned long']],
    'Dr7' : [ 0x4, ['unsigned long']],
    'CurrentSymbolStart' : [ 0x8, ['unsigned long']],
    'CurrentSymbolEnd' : [ 0xc, ['unsigned long']],
} ],
  '_HVIEW_MAP_TABLE' : [ 0x600, {
    'Entries' : [ 0x0, ['array', 64, ['_HVIEW_MAP_ENTRY']]],
} ],
  '_HANDLE_TRACE_DB_ENTRY' : [ 0x50, {
    'ClientId' : [ 0x0, ['_CLIENT_ID']],
    'Handle' : [ 0x8, ['pointer', ['void']]],
    'Type' : [ 0xc, ['unsigned long']],
    'StackTrace' : [ 0x10, ['array', 16, ['pointer', ['void']]]],
} ],
  '_WHEA_IPF_CPE_DESCRIPTOR' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
} ],
  '_DUMMY_FILE_OBJECT' : [ 0xa0, {
    'ObjectHeader' : [ 0x0, ['_OBJECT_HEADER']],
    'FileObjectBody' : [ 0x20, ['array', 128, ['unsigned char']]],
} ],
  '_TRIAGE_9F_PNP' : [ 0xc, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'CompletionQueue' : [ 0x4, ['pointer', ['_TRIAGE_PNP_DEVICE_COMPLETION_QUEUE']]],
    'DelayedWorkQueue' : [ 0x8, ['pointer', ['_TRIAGE_EX_WORK_QUEUE']]],
} ],
  '_RELATION_LIST' : [ 0x8, {
    'DeviceObjectList' : [ 0x0, ['pointer', ['_DEVICE_OBJECT_LIST']]],
    'Sorted' : [ 0x4, ['unsigned char']],
} ],
  '_IO_TIMER' : [ 0x18, {
    'Type' : [ 0x0, ['short']],
    'TimerFlag' : [ 0x2, ['short']],
    'TimerList' : [ 0x4, ['_LIST_ENTRY']],
    'TimerRoutine' : [ 0xc, ['pointer', ['void']]],
    'Context' : [ 0x10, ['pointer', ['void']]],
    'DeviceObject' : [ 0x14, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '_MI_STANDBY_STATE' : [ 0x80, {
    'TransitionSharedPages' : [ 0x0, ['unsigned long']],
    'TransitionSharedPagesPeak' : [ 0x4, ['array', 3, ['unsigned long']]],
    'FirstDecayPage' : [ 0x10, ['unsigned long']],
    'PfnDecayFreeSList' : [ 0x18, ['_SLIST_HEADER']],
    'PfnRepurposeLog' : [ 0x20, ['pointer', ['_MM_PAGE_ACCESS_INFO_HEADER']]],
    'AllocatePfnRepurposeDpc' : [ 0x24, ['_KDPC']],
} ],
  '_MI_ACCESS_LOG_STATE' : [ 0x80, {
    'CcAccessLog' : [ 0x0, ['pointer', ['_MM_PAGE_ACCESS_INFO_HEADER']]],
    'Enabled' : [ 0x4, ['unsigned long']],
    'DisableAccessLogging' : [ 0x8, ['_WORK_QUEUE_ITEM']],
    'MinLoggingPriority' : [ 0x18, ['unsigned long']],
    'AccessLoggingLock' : [ 0x40, ['unsigned long']],
} ],
  '_ETW_BUFFER_QUEUE' : [ 0xc, {
    'QueueHead' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'QueueTail' : [ 0x4, ['pointer', ['_SINGLE_LIST_ENTRY']]],
    'QueueEntry' : [ 0x8, ['_SINGLE_LIST_ENTRY']],
} ],
  '_ARBITER_TEST_ALLOCATION_PARAMETERS' : [ 0xc, {
    'ArbitrationList' : [ 0x0, ['pointer', ['_LIST_ENTRY']]],
    'AllocateFromCount' : [ 0x4, ['unsigned long']],
    'AllocateFrom' : [ 0x8, ['pointer', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
} ],
  '_MI_SPECIAL_POOL' : [ 0x48, {
    'Lock' : [ 0x0, ['unsigned long']],
    'Paged' : [ 0x8, ['_MI_PTE_CHAIN_HEAD']],
    'NonPaged' : [ 0x20, ['_MI_PTE_CHAIN_HEAD']],
    'PagesInUse' : [ 0x38, ['unsigned long']],
    'SpecialPoolPdes' : [ 0x3c, ['_RTL_BITMAP']],
} ],
  '_LOGGED_STREAM_CALLBACK_V2' : [ 0x4, {
    'LogHandleContext' : [ 0x0, ['pointer', ['_LOG_HANDLE_CONTEXT']]],
} ],
  '_ARBITER_QUERY_CONFLICT_PARAMETERS' : [ 0x10, {
    'PhysicalDeviceObject' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
    'ConflictingResource' : [ 0x4, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'ConflictCount' : [ 0x8, ['pointer', ['unsigned long']]],
    'Conflicts' : [ 0xc, ['pointer', ['pointer', ['_ARBITER_CONFLICT_INFO']]]],
} ],
  '_POP_CURRENT_BROADCAST' : [ 0x10, {
    'InProgress' : [ 0x0, ['unsigned char']],
    'SystemContext' : [ 0x4, ['_SYSTEM_POWER_STATE_CONTEXT']],
    'PowerAction' : [ 0x8, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject', 8: 'PowerActionDisplayOff'})]],
    'DeviceState' : [ 0xc, ['pointer', ['_POP_DEVICE_SYS_STATE']]],
} ],
  'PEPHANDLE__' : [ 0x4, {
    'unused' : [ 0x0, ['long']],
} ],
  '_PNP_DEVICE_EVENT_LIST' : [ 0x4c, {
    'Status' : [ 0x0, ['long']],
    'EventQueueMutex' : [ 0x4, ['_KMUTANT']],
    'Lock' : [ 0x24, ['_FAST_MUTEX']],
    'List' : [ 0x44, ['_LIST_ENTRY']],
} ],
  '_IOV_IRP_TRACE' : [ 0x40, {
    'Irp' : [ 0x0, ['pointer', ['_IRP']]],
    'Thread' : [ 0x4, ['pointer', ['_KTHREAD']]],
    'KernelApcDisable' : [ 0x8, ['short']],
    'SpecialApcDisable' : [ 0xa, ['short']],
    'CombinedApcDisable' : [ 0x8, ['unsigned long']],
    'Irql' : [ 0xc, ['unsigned char']],
    'StackTrace' : [ 0x10, ['array', 12, ['pointer', ['void']]]],
} ],
  '_MAILSLOT_CREATE_PARAMETERS' : [ 0x18, {
    'MailslotQuota' : [ 0x0, ['unsigned long']],
    'MaximumMessageSize' : [ 0x4, ['unsigned long']],
    'ReadTimeout' : [ 0x8, ['_LARGE_INTEGER']],
    'TimeoutSpecified' : [ 0x10, ['unsigned char']],
} ],
  '_PO_IRP_MANAGER' : [ 0x10, {
    'DeviceIrpQueue' : [ 0x0, ['_PO_IRP_QUEUE']],
    'SystemIrpQueue' : [ 0x8, ['_PO_IRP_QUEUE']],
} ],
  '_SEP_LOWBOX_HANDLES_TABLE' : [ 0x8, {
    'Lock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'HashTable' : [ 0x4, ['pointer', ['_RTL_DYNAMIC_HASH_TABLE']]],
} ],
  '_PPM_FFH_THROTTLE_STATE_INFO' : [ 0x20, {
    'EnableLogging' : [ 0x0, ['unsigned char']],
    'MismatchCount' : [ 0x4, ['unsigned long']],
    'Initialized' : [ 0x8, ['unsigned char']],
    'LastValue' : [ 0x10, ['unsigned long long']],
    'LastLogTickCount' : [ 0x18, ['_LARGE_INTEGER']],
} ],
  '_PROC_IDLE_POLICY' : [ 0x6, {
    'PromotePercent' : [ 0x0, ['unsigned char']],
    'DemotePercent' : [ 0x1, ['unsigned char']],
    'PromotePercentBase' : [ 0x2, ['unsigned char']],
    'DemotePercentBase' : [ 0x3, ['unsigned char']],
    'AllowScaling' : [ 0x4, ['unsigned char']],
    'ForceLightIdle' : [ 0x5, ['unsigned char']],
} ],
  '_CLIENT_ID64' : [ 0x10, {
    'UniqueProcess' : [ 0x0, ['unsigned long long']],
    'UniqueThread' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_2657' : [ 0x4, {
    'PercentLevel' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2659' : [ 0x4, {
    'Type' : [ 0x0, ['unsigned long']],
} ],
  '_POP_ACTION_TRIGGER' : [ 0x10, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PolicyDeviceSystemButton', 1: 'PolicyDeviceThermalZone', 2: 'PolicyDeviceBattery', 3: 'PolicyDeviceMemory', 4: 'PolicyInitiatePowerActionAPI', 5: 'PolicySetPowerStateAPI', 6: 'PolicyImmediateDozeS4', 7: 'PolicySystemIdle', 8: 'PolicyDeviceWakeAlarm', 9: 'PolicyDeviceFan', 10: 'PolicyCsBatterySaver', 11: 'PolicyImmediateDozeS4Predicted', 12: 'PolicyImmediateDozeS4PredictedNoWake', 13: 'PolicyDeviceMax'})]],
    'Flags' : [ 0x4, ['unsigned long']],
    'Wait' : [ 0x8, ['pointer', ['_POP_TRIGGER_WAIT']]],
    'Battery' : [ 0xc, ['__unnamed_2657']],
    'Button' : [ 0xc, ['__unnamed_2659']],
} ],
  '_KDPC_DATA' : [ 0x18, {
    'DpcList' : [ 0x0, ['_KDPC_LIST']],
    'DpcLock' : [ 0x8, ['unsigned long']],
    'DpcQueueDepth' : [ 0xc, ['long']],
    'DpcCount' : [ 0x10, ['unsigned long']],
    'ActiveDpc' : [ 0x14, ['pointer', ['_KDPC']]],
} ],
  '_NAMED_PIPE_CREATE_PARAMETERS' : [ 0x28, {
    'NamedPipeType' : [ 0x0, ['unsigned long']],
    'ReadMode' : [ 0x4, ['unsigned long']],
    'CompletionMode' : [ 0x8, ['unsigned long']],
    'MaximumInstances' : [ 0xc, ['unsigned long']],
    'InboundQuota' : [ 0x10, ['unsigned long']],
    'OutboundQuota' : [ 0x14, ['unsigned long']],
    'DefaultTimeout' : [ 0x18, ['_LARGE_INTEGER']],
    'TimeoutSpecified' : [ 0x20, ['unsigned char']],
} ],
  '_CM_BIG_DATA' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Count' : [ 0x2, ['unsigned short']],
    'List' : [ 0x4, ['unsigned long']],
} ],
  '_KSCB' : [ 0xf8, {
    'GenerationCycles' : [ 0x0, ['unsigned long long']],
    'MinQuotaCycleTarget' : [ 0x8, ['unsigned long long']],
    'MaxQuotaCycleTarget' : [ 0x10, ['unsigned long long']],
    'RankCycleTarget' : [ 0x18, ['unsigned long long']],
    'LongTermCycles' : [ 0x20, ['unsigned long long']],
    'LastReportedCycles' : [ 0x28, ['unsigned long long']],
    'OverQuotaHistory' : [ 0x30, ['unsigned long long']],
    'ReadyTime' : [ 0x38, ['unsigned long long']],
    'InsertTime' : [ 0x40, ['unsigned long long']],
    'PerProcessorList' : [ 0x48, ['_LIST_ENTRY']],
    'QueueNode' : [ 0x50, ['_RTL_BALANCED_NODE']],
    'Inserted' : [ 0x5c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'MaxOverQuota' : [ 0x5c, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'MinOverQuota' : [ 0x5c, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'RankBias' : [ 0x5c, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'SoftCap' : [ 0x5c, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'Spare1' : [ 0x5c, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned char')]],
    'Depth' : [ 0x5d, ['unsigned char']],
    'ReadySummary' : [ 0x5e, ['unsigned short']],
    'Rank' : [ 0x60, ['unsigned long']],
    'ReadyListHead' : [ 0x64, ['array', 16, ['_LIST_ENTRY']]],
    'ChildScbQueue' : [ 0xe4, ['_RTL_RB_TREE']],
    'Parent' : [ 0xec, ['pointer', ['_KSCB']]],
    'Root' : [ 0xf0, ['pointer', ['_KSCB']]],
} ],
  '__unnamed_2668' : [ 0x8, {
    'UserData' : [ 0x0, ['pointer', ['void']]],
    'Owner' : [ 0x4, ['pointer', ['void']]],
} ],
  '__unnamed_2669' : [ 0x8, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
} ],
  '_RTLP_RANGE_LIST_ENTRY' : [ 0x28, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
    'Allocated' : [ 0x10, ['__unnamed_2668']],
    'Merged' : [ 0x10, ['__unnamed_2669']],
    'Attributes' : [ 0x18, ['unsigned char']],
    'PublicFlags' : [ 0x19, ['unsigned char']],
    'PrivateFlags' : [ 0x1a, ['unsigned short']],
    'ListEntry' : [ 0x1c, ['_LIST_ENTRY']],
} ],
  '_ALPC_COMPLETION_PACKET_LOOKASIDE_ENTRY' : [ 0xc, {
    'ListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Packet' : [ 0x4, ['pointer', ['_IO_MINI_COMPLETION_PACKET_USER']]],
    'Lookaside' : [ 0x8, ['pointer', ['_ALPC_COMPLETION_PACKET_LOOKASIDE']]],
} ],
  '_PROC_PERF_HISTORY' : [ 0x24, {
    'Count' : [ 0x0, ['unsigned long']],
    'Slot' : [ 0x4, ['unsigned long']],
    'UtilityTotal' : [ 0x8, ['unsigned long']],
    'AffinitizedUtilityTotal' : [ 0xc, ['unsigned long']],
    'FrequencyTotal' : [ 0x10, ['unsigned long']],
    'TaggedPercentTotal' : [ 0x14, ['array', 2, ['unsigned long']]],
    'HistoryList' : [ 0x1c, ['array', 1, ['_PROC_PERF_HISTORY_ENTRY']]],
} ],
  '_MI_PARTITION_ZEROING' : [ 0x40, {
    'PageEvent' : [ 0x0, ['_KEVENT']],
    'ThreadActive' : [ 0x10, ['unsigned char']],
    'ZeroFreePageSlistMinimum' : [ 0x14, ['long']],
    'FirstReservedZeroingPte' : [ 0x18, ['pointer', ['_MMPTE']]],
    'RebalanceZeroFreeWorkItem' : [ 0x1c, ['_WORK_QUEUE_ITEM']],
    'ThreadCount' : [ 0x2c, ['long']],
    'Gate' : [ 0x30, ['_KGATE']],
} ],
  '__unnamed_2676' : [ 0x2, {
    'AsUSHORT' : [ 0x0, ['unsigned short']],
    'AllowScaling' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Disabled' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 16, native_type='unsigned short')]],
} ],
  'PROCESSOR_IDLESTATE_POLICY' : [ 0x20, {
    'Revision' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['__unnamed_2676']],
    'PolicyCount' : [ 0x4, ['unsigned long']],
    'Policy' : [ 0x8, ['array', 3, ['PROCESSOR_IDLESTATE_INFO']]],
} ],
  '_ACTIVATION_CONTEXT_STACK' : [ 0x18, {
    'ActiveFrame' : [ 0x0, ['pointer', ['_RTL_ACTIVATION_CONTEXT_STACK_FRAME']]],
    'FrameListCache' : [ 0x4, ['_LIST_ENTRY']],
    'Flags' : [ 0xc, ['unsigned long']],
    'NextCookieSequenceNumber' : [ 0x10, ['unsigned long']],
    'StackId' : [ 0x14, ['unsigned long']],
} ],
  '_RTL_DRIVE_LETTER_CURDIR' : [ 0x10, {
    'Flags' : [ 0x0, ['unsigned short']],
    'Length' : [ 0x2, ['unsigned short']],
    'TimeStamp' : [ 0x4, ['unsigned long']],
    'DosPath' : [ 0x8, ['_STRING']],
} ],
  '_PPM_IDLE_SYNCHRONIZATION_STATE' : [ 0x4, {
    'AsLong' : [ 0x0, ['long']],
    'RefCount' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='long')]],
    'State' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PPM_CONCURRENCY_ACCOUNTING' : [ 0x28, {
    'Lock' : [ 0x0, ['unsigned long']],
    'Processors' : [ 0x4, ['unsigned long']],
    'ActiveProcessors' : [ 0x8, ['unsigned long']],
    'LastUpdateTime' : [ 0x10, ['unsigned long long']],
    'TotalTime' : [ 0x18, ['unsigned long long']],
    'AccumulatedTime' : [ 0x20, ['array', 1, ['unsigned long long']]],
} ],
  '_DIAGNOSTIC_CONTEXT' : [ 0x10, {
    'CallerType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'KernelRequester', 1: 'UserProcessRequester', 2: 'UserSharedServiceRequester'})]],
    'Process' : [ 0x4, ['pointer', ['_EPROCESS']]],
    'ServiceTag' : [ 0x8, ['unsigned long']],
    'DeviceObject' : [ 0x4, ['pointer', ['_DEVICE_OBJECT']]],
    'ReasonSize' : [ 0xc, ['unsigned long']],
} ],
  '__unnamed_268e' : [ 0x4, {
    'MissedEtwRegistration' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_2690' : [ 0x4, {
    'Flags' : [ 0x0, ['__unnamed_268e']],
    'Whole' : [ 0x0, ['unsigned long']],
} ],
  '_VF_TARGET_VERIFIED_DRIVER_DATA' : [ 0xa8, {
    'SuspectDriverEntry' : [ 0x0, ['pointer', ['_VF_SUSPECT_DRIVER_ENTRY']]],
    'WMICallback' : [ 0x4, ['pointer', ['void']]],
    'EtwHandlesListHead' : [ 0x8, ['_LIST_ENTRY']],
    'u1' : [ 0x10, ['__unnamed_2690']],
    'Signature' : [ 0x14, ['unsigned long']],
    'PoolPageHeaders' : [ 0x18, ['_SLIST_HEADER']],
    'PoolTrackers' : [ 0x20, ['_SLIST_HEADER']],
    'CurrentPagedPoolAllocations' : [ 0x28, ['unsigned long']],
    'CurrentNonPagedPoolAllocations' : [ 0x2c, ['unsigned long']],
    'PeakPagedPoolAllocations' : [ 0x30, ['unsigned long']],
    'PeakNonPagedPoolAllocations' : [ 0x34, ['unsigned long']],
    'PagedBytes' : [ 0x38, ['unsigned long']],
    'NonPagedBytes' : [ 0x3c, ['unsigned long']],
    'PeakPagedBytes' : [ 0x40, ['unsigned long']],
    'PeakNonPagedBytes' : [ 0x44, ['unsigned long']],
    'RaiseIrqls' : [ 0x48, ['unsigned long']],
    'AcquireSpinLocks' : [ 0x4c, ['unsigned long']],
    'SynchronizeExecutions' : [ 0x50, ['unsigned long']],
    'AllocationsWithNoTag' : [ 0x54, ['unsigned long']],
    'AllocationsFailed' : [ 0x58, ['unsigned long']],
    'AllocationsFailedDeliberately' : [ 0x5c, ['unsigned long']],
    'LockedBytes' : [ 0x60, ['unsigned long']],
    'PeakLockedBytes' : [ 0x64, ['unsigned long']],
    'MappedLockedBytes' : [ 0x68, ['unsigned long']],
    'PeakMappedLockedBytes' : [ 0x6c, ['unsigned long']],
    'MappedIoSpaceBytes' : [ 0x70, ['unsigned long']],
    'PeakMappedIoSpaceBytes' : [ 0x74, ['unsigned long']],
    'PagesForMdlBytes' : [ 0x78, ['unsigned long']],
    'PeakPagesForMdlBytes' : [ 0x7c, ['unsigned long']],
    'ContiguousMemoryBytes' : [ 0x80, ['unsigned long']],
    'PeakContiguousMemoryBytes' : [ 0x84, ['unsigned long']],
    'ContiguousMemoryListHead' : [ 0x88, ['_LIST_ENTRY']],
    'ExecutePoolTypes' : [ 0x90, ['unsigned long']],
    'ExecutePageProtections' : [ 0x94, ['unsigned long']],
    'ExecutePageMappings' : [ 0x98, ['unsigned long']],
    'ExecuteWriteSections' : [ 0x9c, ['unsigned long']],
    'SectionAlignmentFailures' : [ 0xa0, ['unsigned long']],
} ],
  '_TRIAGE_DEVICE_NODE' : [ 0x2c, {
    'Sibling' : [ 0x0, ['pointer', ['_TRIAGE_DEVICE_NODE']]],
    'Child' : [ 0x4, ['pointer', ['_TRIAGE_DEVICE_NODE']]],
    'Parent' : [ 0x8, ['pointer', ['_TRIAGE_DEVICE_NODE']]],
    'LastChild' : [ 0xc, ['pointer', ['_TRIAGE_DEVICE_NODE']]],
    'PhysicalDeviceObject' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'InstancePath' : [ 0x14, ['_UNICODE_STRING']],
    'ServiceName' : [ 0x1c, ['_UNICODE_STRING']],
    'PendingIrp' : [ 0x24, ['pointer', ['_IRP']]],
    'FxDevice' : [ 0x28, ['pointer', ['_TRIAGE_POP_FX_DEVICE']]],
} ],
  '_PRIVATE_CACHE_MAP' : [ 0x68, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'Flags' : [ 0x0, ['_PRIVATE_CACHE_MAP_FLAGS']],
    'ReadAheadMask' : [ 0x4, ['unsigned long']],
    'FileObject' : [ 0x8, ['pointer', ['_FILE_OBJECT']]],
    'FileOffset1' : [ 0x10, ['_LARGE_INTEGER']],
    'BeyondLastByte1' : [ 0x18, ['_LARGE_INTEGER']],
    'FileOffset2' : [ 0x20, ['_LARGE_INTEGER']],
    'BeyondLastByte2' : [ 0x28, ['_LARGE_INTEGER']],
    'SequentialReadCount' : [ 0x30, ['unsigned long']],
    'ReadAheadLength' : [ 0x34, ['unsigned long']],
    'ReadAheadOffset' : [ 0x38, ['_LARGE_INTEGER']],
    'ReadAheadBeyondLastByte' : [ 0x40, ['_LARGE_INTEGER']],
    'PrevReadAheadBeyondLastByte' : [ 0x48, ['unsigned long long']],
    'ReadAheadSpinLock' : [ 0x50, ['unsigned long']],
    'PipelinedReadAheadRequestSize' : [ 0x54, ['unsigned long']],
    'ReadAheadGrowth' : [ 0x58, ['unsigned long']],
    'PrivateLinks' : [ 0x5c, ['_LIST_ENTRY']],
    'ReadAheadWorkItem' : [ 0x64, ['pointer', ['void']]],
} ],
  '_CM_KEY_NODE' : [ 0x50, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'LastWriteTime' : [ 0x4, ['_LARGE_INTEGER']],
    'AccessBits' : [ 0xc, ['unsigned long']],
    'Parent' : [ 0x10, ['unsigned long']],
    'SubKeyCounts' : [ 0x14, ['array', 2, ['unsigned long']]],
    'SubKeyLists' : [ 0x1c, ['array', 2, ['unsigned long']]],
    'ValueList' : [ 0x24, ['_CHILD_LIST']],
    'ChildHiveReference' : [ 0x1c, ['_CM_KEY_REFERENCE']],
    'Security' : [ 0x2c, ['unsigned long']],
    'Class' : [ 0x30, ['unsigned long']],
    'MaxNameLen' : [ 0x34, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'UserFlags' : [ 0x34, ['BitField', dict(start_bit = 16, end_bit = 20, native_type='unsigned long')]],
    'VirtControlFlags' : [ 0x34, ['BitField', dict(start_bit = 20, end_bit = 24, native_type='unsigned long')]],
    'Debug' : [ 0x34, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
    'MaxClassLen' : [ 0x38, ['unsigned long']],
    'MaxValueNameLen' : [ 0x3c, ['unsigned long']],
    'MaxValueDataLen' : [ 0x40, ['unsigned long']],
    'WorkVar' : [ 0x44, ['unsigned long']],
    'NameLength' : [ 0x48, ['unsigned short']],
    'ClassLength' : [ 0x4a, ['unsigned short']],
    'Name' : [ 0x4c, ['array', 1, ['wchar']]],
} ],
  '_AER_ROOTPORT_DESCRIPTOR_FLAGS' : [ 0x2, {
    'UncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'UncorrectableErrorSeverityRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'CorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'AdvancedCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'RootErrorCommandRW' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_MI_SYSTEM_IMAGE_STATE' : [ 0x6c, {
    'FixupLock' : [ 0x0, ['long']],
    'FixupList' : [ 0x4, ['_LIST_ENTRY']],
    'LoadLock' : [ 0xc, ['_KMUTANT']],
    'FirstLoadEver' : [ 0x2c, ['unsigned char']],
    'LargePageAll' : [ 0x2d, ['unsigned char']],
    'LastPage' : [ 0x30, ['unsigned long']],
    'LargePageList' : [ 0x34, ['_LIST_ENTRY']],
    'BeingDeleted' : [ 0x3c, ['pointer', ['_KLDR_DATA_TABLE_ENTRY']]],
    'MappingRangesPushLock' : [ 0x40, ['_EX_PUSH_LOCK']],
    'MappingRanges' : [ 0x44, ['array', 2, ['pointer', ['_MI_DRIVER_VA']]]],
    'PageCount' : [ 0x4c, ['unsigned long']],
    'PageCounts' : [ 0x50, ['_MM_SYSTEM_PAGE_COUNTS']],
    'CollidedLock' : [ 0x60, ['_EX_PUSH_LOCK']],
    'ErrataPte' : [ 0x64, ['pointer', ['_MMPTE']]],
    'ErrataPteMapped' : [ 0x68, ['unsigned long']],
} ],
  '_PTE_TRACKER' : [ 0x44, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Mdl' : [ 0x8, ['pointer', ['_MDL']]],
    'Count' : [ 0xc, ['unsigned long']],
    'SystemVa' : [ 0x10, ['pointer', ['void']]],
    'StartVa' : [ 0x14, ['pointer', ['void']]],
    'Offset' : [ 0x18, ['unsigned long']],
    'Length' : [ 0x1c, ['unsigned long']],
    'Page' : [ 0x20, ['unsigned long']],
    'IoMapping' : [ 0x24, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Matched' : [ 0x24, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'CacheAttribute' : [ 0x24, ['BitField', dict(start_bit = 2, end_bit = 4, native_type='unsigned long')]],
    'GuardPte' : [ 0x24, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Spare' : [ 0x24, ['BitField', dict(start_bit = 5, end_bit = 32, native_type='unsigned long')]],
    'StackTrace' : [ 0x28, ['array', 7, ['pointer', ['void']]]],
} ],
  '_HV_GET_CELL_CONTEXT' : [ 0x4, {
    'Cell' : [ 0x0, ['unsigned long']],
    'IsInTempBin' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '_KTHREAD_COUNTERS' : [ 0x1a8, {
    'WaitReasonBitMap' : [ 0x0, ['unsigned long long']],
    'UserData' : [ 0x8, ['pointer', ['_THREAD_PERFORMANCE_DATA']]],
    'Flags' : [ 0xc, ['unsigned long']],
    'ContextSwitches' : [ 0x10, ['unsigned long']],
    'CycleTimeBias' : [ 0x18, ['unsigned long long']],
    'HardwareCounters' : [ 0x20, ['unsigned long long']],
    'HwCounter' : [ 0x28, ['array', 16, ['_COUNTER_READING']]],
} ],
  '_SHARED_CACHE_MAP_LIST_CURSOR' : [ 0xc, {
    'SharedCacheMapLinks' : [ 0x0, ['_LIST_ENTRY']],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_26c2' : [ 0x2, {
    'SignatureLevel' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 4, native_type='unsigned short')]],
    'SignatureType' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 7, native_type='unsigned short')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 16, native_type='unsigned short')]],
    'EntireField' : [ 0x0, ['unsigned short']],
} ],
  '_KLDR_DATA_TABLE_ENTRY' : [ 0x5c, {
    'InLoadOrderLinks' : [ 0x0, ['_LIST_ENTRY']],
    'ExceptionTable' : [ 0x8, ['pointer', ['void']]],
    'ExceptionTableSize' : [ 0xc, ['unsigned long']],
    'GpValue' : [ 0x10, ['pointer', ['void']]],
    'NonPagedDebugInfo' : [ 0x14, ['pointer', ['_NON_PAGED_DEBUG_INFO']]],
    'DllBase' : [ 0x18, ['pointer', ['void']]],
    'EntryPoint' : [ 0x1c, ['pointer', ['void']]],
    'SizeOfImage' : [ 0x20, ['unsigned long']],
    'FullDllName' : [ 0x24, ['_UNICODE_STRING']],
    'BaseDllName' : [ 0x2c, ['_UNICODE_STRING']],
    'Flags' : [ 0x34, ['unsigned long']],
    'LoadCount' : [ 0x38, ['unsigned short']],
    'u1' : [ 0x3a, ['__unnamed_26c2']],
    'SectionPointer' : [ 0x3c, ['pointer', ['void']]],
    'CheckSum' : [ 0x40, ['unsigned long']],
    'CoverageSectionSize' : [ 0x44, ['unsigned long']],
    'CoverageSection' : [ 0x48, ['pointer', ['void']]],
    'LoadedImports' : [ 0x4c, ['pointer', ['void']]],
    'Spare' : [ 0x50, ['pointer', ['void']]],
    'SizeOfImageNotRounded' : [ 0x54, ['unsigned long']],
    'TimeDateStamp' : [ 0x58, ['unsigned long']],
} ],
  '_DBGKD_GET_VERSION64' : [ 0x28, {
    'MajorVersion' : [ 0x0, ['unsigned short']],
    'MinorVersion' : [ 0x2, ['unsigned short']],
    'ProtocolVersion' : [ 0x4, ['unsigned char']],
    'KdSecondaryVersion' : [ 0x5, ['unsigned char']],
    'Flags' : [ 0x6, ['unsigned short']],
    'MachineType' : [ 0x8, ['unsigned short']],
    'MaxPacketType' : [ 0xa, ['unsigned char']],
    'MaxStateChange' : [ 0xb, ['unsigned char']],
    'MaxManipulate' : [ 0xc, ['unsigned char']],
    'Simulation' : [ 0xd, ['unsigned char']],
    'Unused' : [ 0xe, ['array', 1, ['unsigned short']]],
    'KernBase' : [ 0x10, ['unsigned long long']],
    'PsLoadedModuleList' : [ 0x18, ['unsigned long long']],
    'DebuggerDataList' : [ 0x20, ['unsigned long long']],
} ],
  '_PROC_FEEDBACK_COUNTER' : [ 0x28, {
    'InstantaneousRead' : [ 0x0, ['pointer', ['void']]],
    'DifferentialRead' : [ 0x0, ['pointer', ['void']]],
    'LastActualCount' : [ 0x8, ['unsigned long long']],
    'LastReferenceCount' : [ 0x10, ['unsigned long long']],
    'CachedValue' : [ 0x18, ['unsigned long']],
    'Affinitized' : [ 0x20, ['unsigned char']],
    'Differential' : [ 0x21, ['unsigned char']],
    'Scaling' : [ 0x22, ['unsigned char']],
    'Context' : [ 0x24, ['unsigned long']],
} ],
  '_PPM_COORDINATED_SYNCHRONIZATION' : [ 0x4, {
    'AsLong' : [ 0x0, ['long']],
    'EnterProcessor' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned long')]],
    'ExitProcessor' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 24, native_type='unsigned long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 26, native_type='unsigned long')]],
    'Entered' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'EntryPriority' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 32, native_type='unsigned long')]],
} ],
  '_MI_PAGING_IO_STATE' : [ 0x38, {
    'PageFileHead' : [ 0x0, ['_RTL_AVL_TREE']],
    'PageFileHeadSpinLock' : [ 0x4, ['long']],
    'PrefetchSeekThreshold' : [ 0x8, ['long']],
    'InPageSupportSListHead' : [ 0x10, ['array', 2, ['_SLIST_HEADER']]],
    'InPageSupportSListMinimum' : [ 0x20, ['array', 2, ['unsigned char']]],
    'InPageSinglePages' : [ 0x24, ['unsigned long']],
    'DelayPageFaults' : [ 0x28, ['long']],
    'FileCompressionBoundary' : [ 0x2c, ['unsigned long']],
    'MdlsAdjusted' : [ 0x30, ['unsigned char']],
} ],
  '_PROCESSOR_PLATFORM_STATE_RESIDENCIES' : [ 0x18, {
    'Count' : [ 0x0, ['unsigned long']],
    'States' : [ 0x8, ['array', 1, ['_PROCESSOR_PLATFORM_STATE_RESIDENCY']]],
} ],
  '_MI_FORCED_COMMITS' : [ 0x8, {
    'Regular' : [ 0x0, ['unsigned long']],
    'Wrap' : [ 0x4, ['unsigned long']],
} ],
  '_HMAP_ENTRY' : [ 0x14, {
    'BlockOffset' : [ 0x0, ['unsigned long']],
    'PermanentBinAddress' : [ 0x4, ['unsigned long']],
    'TemporaryBinAddress' : [ 0x8, ['unsigned long']],
    'TemporaryBinRundown' : [ 0xc, ['_EX_RUNDOWN_REF']],
    'MemAlloc' : [ 0x10, ['unsigned long']],
} ],
  '_RTL_ATOM_TABLE_ENTRY' : [ 0x1c, {
    'HashLink' : [ 0x0, ['pointer', ['_RTL_ATOM_TABLE_ENTRY']]],
    'HandleIndex' : [ 0x4, ['unsigned short']],
    'Atom' : [ 0x6, ['unsigned short']],
    'Reference' : [ 0x8, ['_RTL_ATOM_TABLE_REFERENCE']],
    'NameLength' : [ 0x18, ['unsigned char']],
    'Name' : [ 0x1a, ['array', 1, ['wchar']]],
} ],
  '_PLATFORM_IDLE_ACCOUNTING' : [ 0x400, {
    'ResetCount' : [ 0x0, ['unsigned long']],
    'StateCount' : [ 0x4, ['unsigned long']],
    'DeepSleepCount' : [ 0x8, ['unsigned long']],
    'TimeUnit' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'PpmIdleBucketTimeInQpc', 1: 'PpmIdleBucketTimeIn100ns', 2: 'PpmIdleBucketTimeMaximum'})]],
    'StartTime' : [ 0x10, ['unsigned long long']],
    'State' : [ 0x18, ['array', 1, ['_PLATFORM_IDLE_STATE_ACCOUNTING']]],
} ],
  '_TXN_PARAMETER_BLOCK' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'TxFsContext' : [ 0x2, ['unsigned short']],
    'TransactionObject' : [ 0x4, ['pointer', ['void']]],
} ],
  '_DUAL' : [ 0x19c, {
    'Length' : [ 0x0, ['unsigned long']],
    'Map' : [ 0x4, ['pointer', ['_HMAP_DIRECTORY']]],
    'SmallDir' : [ 0x8, ['pointer', ['_HMAP_TABLE']]],
    'Guard' : [ 0xc, ['unsigned long']],
    'FreeDisplay' : [ 0x10, ['array', 24, ['_FREE_DISPLAY']]],
    'FreeBins' : [ 0x190, ['_LIST_ENTRY']],
    'FreeSummary' : [ 0x198, ['unsigned long']],
} ],
  '_MI_VAD_SEQUENTIAL_INFO' : [ 0x4, {
    'Length' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 11, native_type='unsigned long')]],
    'Vpn' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_26f1' : [ 0x4, {
    'ImagePteOffset' : [ 0x0, ['unsigned long']],
    'TossPage' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_26f4' : [ 0x4, {
    'e1' : [ 0x0, ['_MMINPAGE_FLAGS']],
    'LongFlags' : [ 0x0, ['unsigned long']],
} ],
  '_MMINPAGE_SUPPORT' : [ 0xf8, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'ListHead' : [ 0x8, ['_LIST_ENTRY']],
    'Event' : [ 0x10, ['_KEVENT']],
    'CollidedEvent' : [ 0x20, ['_KEVENT']],
    'IoStatus' : [ 0x30, ['_IO_STATUS_BLOCK']],
    'ReadOffset' : [ 0x38, ['_LARGE_INTEGER']],
    'ApcState' : [ 0x40, ['_KAPC_STATE']],
    'Thread' : [ 0x58, ['pointer', ['_ETHREAD']]],
    'LockedProtoPfn' : [ 0x5c, ['pointer', ['_MMPFN']]],
    'PteContents' : [ 0x60, ['_MMPTE']],
    'WaitCount' : [ 0x68, ['long']],
    'ByteCount' : [ 0x6c, ['unsigned long']],
    'u3' : [ 0x70, ['__unnamed_26f1']],
    'u1' : [ 0x74, ['__unnamed_26f4']],
    'FilePointer' : [ 0x78, ['pointer', ['_FILE_OBJECT']]],
    'ControlArea' : [ 0x7c, ['pointer', ['_CONTROL_AREA']]],
    'Subsection' : [ 0x7c, ['pointer', ['_SUBSECTION']]],
    'Autoboost' : [ 0x80, ['pointer', ['void']]],
    'FaultingAddress' : [ 0x84, ['pointer', ['void']]],
    'PointerPte' : [ 0x88, ['pointer', ['_MMPTE']]],
    'BasePte' : [ 0x8c, ['pointer', ['_MMPTE']]],
    'Pfn' : [ 0x90, ['pointer', ['_MMPFN']]],
    'PrefetchMdl' : [ 0x94, ['pointer', ['_MDL']]],
    'Mdl' : [ 0x98, ['_MDL']],
    'Page' : [ 0xb4, ['array', 16, ['unsigned long']]],
    'FlowThrough' : [ 0xb4, ['_MMINPAGE_SUPPORT_FLOW_THROUGH']],
} ],
  '_HAL_NODE_RANGE' : [ 0x8, {
    'PageFrameIndex' : [ 0x0, ['unsigned long']],
    'Node' : [ 0x4, ['unsigned long']],
} ],
  '_MMCLONE_BLOCK' : [ 0x10, {
    'ProtoPte' : [ 0x0, ['_MMPTE']],
    'CloneCommitCount' : [ 0x8, ['unsigned long']],
    'u1' : [ 0x8, ['_MI_CLONE_BLOCK_FLAGS']],
    'CloneRefCount' : [ 0xc, ['unsigned long']],
} ],
  '_PS_TRUSTLET_TKSESSION_ID' : [ 0x20, {
    'SessionId' : [ 0x0, ['array', 4, ['unsigned long long']]],
} ],
  '_PNP_DEVICE_ACTION_ENTRY' : [ 0x30, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DeviceObject' : [ 0x8, ['pointer', ['_DEVICE_OBJECT']]],
    'RequestType' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'AssignResources', 1: 'ClearDeviceProblem', 2: 'ClearProblem', 3: 'ClearEjectProblem', 4: 'HaltDevice', 5: 'QueryPowerRelations', 6: 'Rebalance', 7: 'ReenumerateBootDevices', 8: 'ReenumerateDeviceOnly', 9: 'ReenumerateDeviceTree', 10: 'ReenumerateRootDevices', 11: 'RequeryDeviceState', 12: 'ResetDevice', 13: 'ResourceRequirementsChanged', 14: 'RestartEnumeration', 15: 'SetDeviceProblem', 16: 'StartDevice', 17: 'StartSystemDevicesPass0', 18: 'StartSystemDevicesPass1', 19: 'NotifyTransportRelationsChange', 20: 'NotifyEjectionRelationsChange', 21: 'ConfigureDevice', 22: 'ConfigureDeviceClass', 23: 'ConfigureDeviceExtensions', 24: 'ConfigureDeviceReset'})]],
    'ReorderingBarrier' : [ 0x10, ['unsigned char']],
    'RequestArgument' : [ 0x14, ['unsigned long']],
    'CompletionEvent' : [ 0x18, ['pointer', ['_KEVENT']]],
    'CompletionStatus' : [ 0x1c, ['pointer', ['long']]],
    'ActivityId' : [ 0x20, ['_GUID']],
} ],
  '_SEP_LOWBOX_NUMBER_ENTRY' : [ 0x1c, {
    'HashEntry' : [ 0x0, ['_RTL_DYNAMIC_HASH_TABLE_ENTRY']],
    'ReferenceCount' : [ 0xc, ['long']],
    'PackageSid' : [ 0x10, ['pointer', ['void']]],
    'LowboxNumber' : [ 0x14, ['unsigned long']],
    'AtomTable' : [ 0x18, ['pointer', ['void']]],
} ],
  '_MI_LDW_WORK_CONTEXT' : [ 0x20, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'FileObject' : [ 0x10, ['pointer', ['_FILE_OBJECT']]],
    'ErrorStatus' : [ 0x14, ['long']],
    'Active' : [ 0x18, ['long']],
    'FreeWhenDone' : [ 0x1c, ['unsigned char']],
} ],
  '_MI_CFG_BITMAP_INFO' : [ 0xc, {
    'BaseAddress' : [ 0x0, ['pointer', ['void']]],
    'RegionSize' : [ 0x4, ['unsigned long']],
    'BitmapVad' : [ 0x8, ['pointer', ['_MMVAD']]],
} ],
  '_COUNTER_READING' : [ 0x18, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PMCCounter', 1: 'MaxHardwareCounterType'})]],
    'Index' : [ 0x4, ['unsigned long']],
    'Start' : [ 0x8, ['unsigned long long']],
    'Total' : [ 0x10, ['unsigned long long']],
} ],
  '_MI_SHUTDOWN_STATE' : [ 0x48, {
    'CrashDumpInitialized' : [ 0x0, ['unsigned char']],
    'ConnectedStandbyActive' : [ 0x1, ['unsigned char']],
    'SystemShutdown' : [ 0x4, ['unsigned long']],
    'ShutdownFlushInProgress' : [ 0x8, ['long']],
    'ResumeItem' : [ 0xc, ['_MI_RESUME_WORKITEM']],
    'MirrorHoldsPfn' : [ 0x2c, ['pointer', ['_ETHREAD']]],
    'MirroringActive' : [ 0x30, ['unsigned long']],
    'MirrorBitMaps' : [ 0x34, ['array', 2, ['_RTL_BITMAP']]],
    'CrashDumpPte' : [ 0x44, ['pointer', ['_MMPTE']]],
} ],
  '_SECTION_IMAGE_INFORMATION' : [ 0x30, {
    'TransferAddress' : [ 0x0, ['pointer', ['void']]],
    'ZeroBits' : [ 0x4, ['unsigned long']],
    'MaximumStackSize' : [ 0x8, ['unsigned long']],
    'CommittedStackSize' : [ 0xc, ['unsigned long']],
    'SubSystemType' : [ 0x10, ['unsigned long']],
    'SubSystemMinorVersion' : [ 0x14, ['unsigned short']],
    'SubSystemMajorVersion' : [ 0x16, ['unsigned short']],
    'SubSystemVersion' : [ 0x14, ['unsigned long']],
    'MajorOperatingSystemVersion' : [ 0x18, ['unsigned short']],
    'MinorOperatingSystemVersion' : [ 0x1a, ['unsigned short']],
    'OperatingSystemVersion' : [ 0x18, ['unsigned long']],
    'ImageCharacteristics' : [ 0x1c, ['unsigned short']],
    'DllCharacteristics' : [ 0x1e, ['unsigned short']],
    'Machine' : [ 0x20, ['unsigned short']],
    'ImageContainsCode' : [ 0x22, ['unsigned char']],
    'ImageFlags' : [ 0x23, ['unsigned char']],
    'ComPlusNativeReady' : [ 0x23, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ComPlusILOnly' : [ 0x23, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'ImageDynamicallyRelocated' : [ 0x23, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'ImageMappedFlat' : [ 0x23, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'BaseBelow4gb' : [ 0x23, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'ComPlusPrefer32bit' : [ 0x23, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'Reserved' : [ 0x23, ['BitField', dict(start_bit = 6, end_bit = 8, native_type='unsigned char')]],
    'LoaderFlags' : [ 0x24, ['unsigned long']],
    'ImageFileSize' : [ 0x28, ['unsigned long']],
    'CheckSum' : [ 0x2c, ['unsigned long']],
} ],
  '_ETW_REG_ENTRY' : [ 0x3c, {
    'RegList' : [ 0x0, ['_LIST_ENTRY']],
    'GroupRegList' : [ 0x8, ['_LIST_ENTRY']],
    'GuidEntry' : [ 0x10, ['pointer', ['_ETW_GUID_ENTRY']]],
    'GroupEntry' : [ 0x14, ['pointer', ['_ETW_GUID_ENTRY']]],
    'ReplyQueue' : [ 0x18, ['pointer', ['_ETW_REPLY_QUEUE']]],
    'ReplySlot' : [ 0x18, ['array', 4, ['pointer', ['_ETW_QUEUE_ENTRY']]]],
    'Caller' : [ 0x18, ['pointer', ['void']]],
    'SessionId' : [ 0x1c, ['unsigned long']],
    'Process' : [ 0x28, ['pointer', ['_EPROCESS']]],
    'CallbackContext' : [ 0x28, ['pointer', ['void']]],
    'Callback' : [ 0x2c, ['pointer', ['void']]],
    'Index' : [ 0x30, ['unsigned short']],
    'Flags' : [ 0x32, ['unsigned char']],
    'DbgKernelRegistration' : [ 0x32, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'DbgUserRegistration' : [ 0x32, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'DbgReplyRegistration' : [ 0x32, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'DbgClassicRegistration' : [ 0x32, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'DbgSessionSpaceRegistration' : [ 0x32, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'DbgModernRegistration' : [ 0x32, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'DbgClosed' : [ 0x32, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'DbgInserted' : [ 0x32, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'EnableMask' : [ 0x33, ['unsigned char']],
    'GroupEnableMask' : [ 0x34, ['unsigned char']],
    'UseDescriptorType' : [ 0x35, ['unsigned char']],
    'Traits' : [ 0x38, ['pointer', ['_ETW_PROVIDER_TRAITS']]],
} ],
  '_LPCP_PORT_OBJECT' : [ 0xa4, {
    'ConnectionPort' : [ 0x0, ['pointer', ['_LPCP_PORT_OBJECT']]],
    'ConnectedPort' : [ 0x4, ['pointer', ['_LPCP_PORT_OBJECT']]],
    'MsgQueue' : [ 0x8, ['_LPCP_PORT_QUEUE']],
    'Creator' : [ 0x18, ['_CLIENT_ID']],
    'ClientSectionBase' : [ 0x20, ['pointer', ['void']]],
    'ServerSectionBase' : [ 0x24, ['pointer', ['void']]],
    'PortContext' : [ 0x28, ['pointer', ['void']]],
    'ClientThread' : [ 0x2c, ['pointer', ['_ETHREAD']]],
    'SecurityQos' : [ 0x30, ['_SECURITY_QUALITY_OF_SERVICE']],
    'StaticSecurity' : [ 0x3c, ['_SECURITY_CLIENT_CONTEXT']],
    'LpcReplyChainHead' : [ 0x78, ['_LIST_ENTRY']],
    'LpcDataInfoChainHead' : [ 0x80, ['_LIST_ENTRY']],
    'ServerProcess' : [ 0x88, ['pointer', ['_EPROCESS']]],
    'MappingProcess' : [ 0x88, ['pointer', ['_EPROCESS']]],
    'MaxMessageLength' : [ 0x8c, ['unsigned short']],
    'MaxConnectionInfoLength' : [ 0x8e, ['unsigned short']],
    'Flags' : [ 0x90, ['unsigned long']],
    'WaitEvent' : [ 0x94, ['_KEVENT']],
} ],
  '_HVIEW_MAP_PIN_LOG' : [ 0x308, {
    'Next' : [ 0x0, ['unsigned long']],
    'Size' : [ 0x4, ['unsigned long']],
    'Entries' : [ 0x8, ['array', 16, ['_HVIEW_MAP_PIN_LOG_ENTRY']]],
} ],
  '_ARBITER_LIST_ENTRY' : [ 0x38, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'AlternativeCount' : [ 0x8, ['unsigned long']],
    'Alternatives' : [ 0xc, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'PhysicalDeviceObject' : [ 0x10, ['pointer', ['_DEVICE_OBJECT']]],
    'RequestSource' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'ArbiterRequestLegacyReported', 1: 'ArbiterRequestHalReported', 2: 'ArbiterRequestLegacyAssigned', 3: 'ArbiterRequestPnpDetected', 4: 'ArbiterRequestPnpEnumerated', -1: 'ArbiterRequestUndefined'})]],
    'Flags' : [ 0x18, ['unsigned long']],
    'WorkSpace' : [ 0x1c, ['long']],
    'InterfaceType' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'Internal', 1: 'Isa', 2: 'Eisa', 3: 'MicroChannel', 4: 'TurboChannel', 5: 'PCIBus', 6: 'VMEBus', 7: 'NuBus', 8: 'PCMCIABus', 9: 'CBus', 10: 'MPIBus', 11: 'MPSABus', 12: 'ProcessorInternal', 13: 'InternalPowerBus', 14: 'PNPISABus', 15: 'PNPBus', 16: 'Vmcs', 17: 'ACPIBus', 18: 'MaximumInterfaceType', -1: 'InterfaceTypeUndefined'})]],
    'SlotNumber' : [ 0x24, ['unsigned long']],
    'BusNumber' : [ 0x28, ['unsigned long']],
    'Assignment' : [ 0x2c, ['pointer', ['_CM_PARTIAL_RESOURCE_DESCRIPTOR']]],
    'SelectedAlternative' : [ 0x30, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'Result' : [ 0x34, ['Enumeration', dict(target = 'long', choices = {0: 'ArbiterResultSuccess', 1: 'ArbiterResultExternalConflict', 2: 'ArbiterResultNullRequest', -1: 'ArbiterResultUndefined'})]],
} ],
  '_MI_PROBE_RAISE_TRACKER' : [ 0x40, {
    'UserRangeInKernel' : [ 0x0, ['unsigned long']],
    'FaultFailed' : [ 0x4, ['unsigned long']],
    'WriteFaultFailed' : [ 0x8, ['unsigned long']],
    'LargePageFailed' : [ 0xc, ['unsigned long']],
    'UserAccessToKernelPte' : [ 0x10, ['unsigned long']],
    'BadPageLocation' : [ 0x14, ['unsigned long']],
    'InsufficientCharge' : [ 0x18, ['unsigned long']],
    'PageTableCharge' : [ 0x1c, ['unsigned long']],
    'NoPhysicalMapping' : [ 0x20, ['unsigned long']],
    'NoIoReference' : [ 0x24, ['unsigned long']],
    'ProbeFailed' : [ 0x28, ['unsigned long']],
    'PteIsZero' : [ 0x2c, ['unsigned long']],
    'StrongCodeWrite' : [ 0x30, ['unsigned long']],
    'ReducedCloneCommitChargeFailed' : [ 0x34, ['unsigned long']],
    'CopyOnWriteAtDispatchNoPages' : [ 0x38, ['unsigned long']],
    'EnclavePageFailed' : [ 0x3c, ['unsigned long']],
} ],
  '_ETW_PROVIDER_TRAITS' : [ 0x14, {
    'Node' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'ReferenceCount' : [ 0xc, ['unsigned long']],
    'Traits' : [ 0x10, ['array', 1, ['unsigned char']]],
} ],
  '_INTERRUPT_CONNECTION_DATA' : [ 0x58, {
    'Count' : [ 0x0, ['unsigned long']],
    'Vectors' : [ 0x8, ['array', 1, ['_INTERRUPT_VECTOR_DATA']]],
} ],
  '_MI_CLONE_BLOCK_FLAGS' : [ 0x4, {
    'ActualCloneCommit' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 27, native_type='unsigned long')]],
    'CloneProtection' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 32, native_type='unsigned long')]],
} ],
  '_LDR_DATA_TABLE_ENTRY' : [ 0xa0, {
    'InLoadOrderLinks' : [ 0x0, ['_LIST_ENTRY']],
    'InMemoryOrderLinks' : [ 0x8, ['_LIST_ENTRY']],
    'InInitializationOrderLinks' : [ 0x10, ['_LIST_ENTRY']],
    'DllBase' : [ 0x18, ['pointer', ['void']]],
    'EntryPoint' : [ 0x1c, ['pointer', ['void']]],
    'SizeOfImage' : [ 0x20, ['unsigned long']],
    'FullDllName' : [ 0x24, ['_UNICODE_STRING']],
    'BaseDllName' : [ 0x2c, ['_UNICODE_STRING']],
    'FlagGroup' : [ 0x34, ['array', 4, ['unsigned char']]],
    'Flags' : [ 0x34, ['unsigned long']],
    'PackagedBinary' : [ 0x34, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MarkedForRemoval' : [ 0x34, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ImageDll' : [ 0x34, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'LoadNotificationsSent' : [ 0x34, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'TelemetryEntryProcessed' : [ 0x34, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ProcessStaticImport' : [ 0x34, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'InLegacyLists' : [ 0x34, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'InIndexes' : [ 0x34, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'ShimDll' : [ 0x34, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'InExceptionTable' : [ 0x34, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'ReservedFlags1' : [ 0x34, ['BitField', dict(start_bit = 10, end_bit = 12, native_type='unsigned long')]],
    'LoadInProgress' : [ 0x34, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'LoadConfigProcessed' : [ 0x34, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'EntryProcessed' : [ 0x34, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'ProtectDelayLoad' : [ 0x34, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'ReservedFlags3' : [ 0x34, ['BitField', dict(start_bit = 16, end_bit = 18, native_type='unsigned long')]],
    'DontCallForThreads' : [ 0x34, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'ProcessAttachCalled' : [ 0x34, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'ProcessAttachFailed' : [ 0x34, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'CorDeferredValidate' : [ 0x34, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'CorImage' : [ 0x34, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'DontRelocate' : [ 0x34, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'CorILOnly' : [ 0x34, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'ReservedFlags5' : [ 0x34, ['BitField', dict(start_bit = 25, end_bit = 28, native_type='unsigned long')]],
    'Redirected' : [ 0x34, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'ReservedFlags6' : [ 0x34, ['BitField', dict(start_bit = 29, end_bit = 31, native_type='unsigned long')]],
    'CompatDatabaseProcessed' : [ 0x34, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'ObsoleteLoadCount' : [ 0x38, ['unsigned short']],
    'TlsIndex' : [ 0x3a, ['unsigned short']],
    'HashLinks' : [ 0x3c, ['_LIST_ENTRY']],
    'TimeDateStamp' : [ 0x44, ['unsigned long']],
    'EntryPointActivationContext' : [ 0x48, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'Lock' : [ 0x4c, ['pointer', ['void']]],
    'DdagNode' : [ 0x50, ['pointer', ['_LDR_DDAG_NODE']]],
    'NodeModuleLink' : [ 0x54, ['_LIST_ENTRY']],
    'LoadContext' : [ 0x5c, ['pointer', ['_LDRP_LOAD_CONTEXT']]],
    'ParentDllBase' : [ 0x60, ['pointer', ['void']]],
    'SwitchBackContext' : [ 0x64, ['pointer', ['void']]],
    'BaseAddressIndexNode' : [ 0x68, ['_RTL_BALANCED_NODE']],
    'MappingInfoIndexNode' : [ 0x74, ['_RTL_BALANCED_NODE']],
    'OriginalBase' : [ 0x80, ['unsigned long']],
    'LoadTime' : [ 0x88, ['_LARGE_INTEGER']],
    'BaseNameHashValue' : [ 0x90, ['unsigned long']],
    'LoadReason' : [ 0x94, ['Enumeration', dict(target = 'long', choices = {0: 'LoadReasonStaticDependency', 1: 'LoadReasonStaticForwarderDependency', 2: 'LoadReasonDynamicForwarderDependency', 3: 'LoadReasonDelayloadDependency', 4: 'LoadReasonDynamicLoad', 5: 'LoadReasonAsImageLoad', 6: 'LoadReasonAsDataLoad', -1: 'LoadReasonUnknown'})]],
    'ImplicitPathOptions' : [ 0x98, ['unsigned long']],
    'ReferenceCount' : [ 0x9c, ['unsigned long']],
} ],
  '_CACHED_KSTACK_LIST' : [ 0x18, {
    'SListHead' : [ 0x0, ['_SLIST_HEADER']],
    'MinimumFree' : [ 0x8, ['long']],
    'Misses' : [ 0xc, ['unsigned long']],
    'MissesLast' : [ 0x10, ['unsigned long']],
    'AllStacksInUse' : [ 0x14, ['unsigned long']],
} ],
  '_MMINPAGE_FLAGS' : [ 0x4, {
    'InjectRetry' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'GetExtents' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'CrossThreadPadding' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'PrefetchSystemVmType' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 2, native_type='unsigned char')]],
    'VaPrefetchReadBlock' : [ 0x1, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'CollidedFlowThrough' : [ 0x1, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ForceCollisions' : [ 0x1, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'InPageExpanded' : [ 0x1, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'IssuedAtLowPriority' : [ 0x1, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'FaultFromStore' : [ 0x1, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'PagePriority' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned char')]],
    'PerformRelocations' : [ 0x2, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'ClusteredPagePriority' : [ 0x2, ['BitField', dict(start_bit = 4, end_bit = 7, native_type='unsigned char')]],
    'MakeClusterValid' : [ 0x2, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
    'ZeroLastPage' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'UserFault' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'StandbyProtectionNeeded' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'PteChanged' : [ 0x3, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'PageFileFault' : [ 0x3, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned char')]],
    'PageFilePageHashActive' : [ 0x3, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned char')]],
    'CoalescedIo' : [ 0x3, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned char')]],
    'VmLockNotNeeded' : [ 0x3, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned char')]],
} ],
  '_MI_DRIVER_VA' : [ 0x14, {
    'Next' : [ 0x0, ['pointer', ['_MI_DRIVER_VA']]],
    'PointerPte' : [ 0x4, ['pointer', ['_MMPTE']]],
    'BitMap' : [ 0x8, ['_RTL_BITMAP']],
    'Hint' : [ 0x10, ['unsigned long']],
} ],
  '_LDR_DDAG_NODE' : [ 0x2c, {
    'Modules' : [ 0x0, ['_LIST_ENTRY']],
    'ServiceTagList' : [ 0x8, ['pointer', ['_LDR_SERVICE_TAG_RECORD']]],
    'LoadCount' : [ 0xc, ['unsigned long']],
    'LoadWhileUnloadingCount' : [ 0x10, ['unsigned long']],
    'LowestLink' : [ 0x14, ['unsigned long']],
    'Dependencies' : [ 0x18, ['_LDRP_CSLIST']],
    'IncomingDependencies' : [ 0x1c, ['_LDRP_CSLIST']],
    'State' : [ 0x20, ['Enumeration', dict(target = 'long', choices = {0: 'LdrModulesPlaceHolder', 1: 'LdrModulesMapping', 2: 'LdrModulesMapped', 3: 'LdrModulesWaitingForDependencies', 4: 'LdrModulesSnapping', 5: 'LdrModulesSnapped', 6: 'LdrModulesCondensed', 7: 'LdrModulesReadyToInit', 8: 'LdrModulesInitializing', 9: 'LdrModulesReadyToRun', '\xfb': 'LdrModulesMerged', '\xfd': 'LdrModulesSnapError', '\xfc': 'LdrModulesInitError', -1: 'LdrModulesUnloading', '\xfe': 'LdrModulesUnloaded'})]],
    'CondenseLink' : [ 0x24, ['_SINGLE_LIST_ENTRY']],
    'PreorderNumber' : [ 0x28, ['unsigned long']],
} ],
  '_POP_DEVICE_SYS_STATE' : [ 0x104, {
    'IrpMinor' : [ 0x0, ['unsigned char']],
    'SystemState' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
    'SpinLock' : [ 0x8, ['unsigned long']],
    'Thread' : [ 0xc, ['pointer', ['_KTHREAD']]],
    'AbortEvent' : [ 0x10, ['pointer', ['_KEVENT']]],
    'ReadySemaphore' : [ 0x14, ['pointer', ['_KSEMAPHORE']]],
    'FinishedSemaphore' : [ 0x18, ['pointer', ['_KSEMAPHORE']]],
    'Order' : [ 0x1c, ['_PO_DEVICE_NOTIFY_ORDER']],
    'Pending' : [ 0xec, ['_LIST_ENTRY']],
    'Status' : [ 0xf4, ['long']],
    'FailedDevice' : [ 0xf8, ['pointer', ['_DEVICE_OBJECT']]],
    'Waking' : [ 0xfc, ['unsigned char']],
    'Cancelled' : [ 0xfd, ['unsigned char']],
    'IgnoreErrors' : [ 0xfe, ['unsigned char']],
    'IgnoreNotImplemented' : [ 0xff, ['unsigned char']],
    'TimeRefreshLockAcquired' : [ 0x100, ['unsigned char']],
} ],
  '_KHETERO_PROCESSOR_SET' : [ 0x8, {
    'PreferredMask' : [ 0x0, ['unsigned long']],
    'AvailableMask' : [ 0x4, ['unsigned long']],
} ],
  '_VF_KE_CRITICAL_REGION_TRACE' : [ 0x20, {
    'Thread' : [ 0x0, ['pointer', ['_ETHREAD']]],
    'StackTrace' : [ 0x4, ['array', 7, ['pointer', ['void']]]],
} ],
  '_LOGGED_STREAM_CALLBACK_V1' : [ 0x8, {
    'LogHandle' : [ 0x0, ['pointer', ['void']]],
    'FlushToLsnRoutine' : [ 0x4, ['pointer', ['void']]],
} ],
  '_DIAGNOSTIC_BUFFER' : [ 0x18, {
    'Size' : [ 0x0, ['unsigned long']],
    'CallerType' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'KernelRequester', 1: 'UserProcessRequester', 2: 'UserSharedServiceRequester'})]],
    'ProcessImageNameOffset' : [ 0x8, ['unsigned long']],
    'ProcessId' : [ 0xc, ['unsigned long']],
    'ServiceTag' : [ 0x10, ['unsigned long']],
    'DeviceDescriptionOffset' : [ 0x8, ['unsigned long']],
    'DevicePathOffset' : [ 0xc, ['unsigned long']],
    'ReasonOffset' : [ 0x14, ['unsigned long']],
} ],
  '_KWAIT_CHAIN_ENTRY' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'Event' : [ 0x4, ['_KEVENT']],
} ],
  '__unnamed_276f' : [ 0x4, {
    'LongFlags' : [ 0x0, ['unsigned long']],
    'SubsectionFlags' : [ 0x0, ['_MMSUBSECTION_FLAGS']],
} ],
  '__unnamed_2771' : [ 0x4, {
    'NumberOfChildViews' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2773' : [ 0x4, {
    'AlignmentNoAccessPtes' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'DirtyPages' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '_SUBSECTION' : [ 0x28, {
    'ControlArea' : [ 0x0, ['pointer', ['_CONTROL_AREA']]],
    'SubsectionBase' : [ 0x4, ['pointer', ['_MMPTE']]],
    'NextSubsection' : [ 0x8, ['pointer', ['_SUBSECTION']]],
    'GlobalPerSessionHead' : [ 0xc, ['_RTL_AVL_TREE']],
    'CreationWaitList' : [ 0xc, ['pointer', ['_MI_SUBSECTION_WAIT_BLOCK']]],
    'SessionDriverProtos' : [ 0xc, ['pointer', ['_MI_PER_SESSION_PROTOS']]],
    'u' : [ 0x10, ['__unnamed_276f']],
    'StartingSector' : [ 0x14, ['unsigned long']],
    'NumberOfFullSectors' : [ 0x18, ['unsigned long']],
    'PtesInSubsection' : [ 0x1c, ['unsigned long']],
    'u1' : [ 0x20, ['__unnamed_2771']],
    'UnusedPtes' : [ 0x24, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'DirtyPages' : [ 0x24, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'u2' : [ 0x24, ['__unnamed_2773']],
} ],
  '_CLIENT_ID32' : [ 0x8, {
    'UniqueProcess' : [ 0x0, ['unsigned long']],
    'UniqueThread' : [ 0x4, ['unsigned long']],
} ],
  '_CM_KEY_INDEX' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Count' : [ 0x2, ['unsigned short']],
    'List' : [ 0x4, ['array', 1, ['unsigned long']]],
} ],
  '_VI_DEADLOCK_THREAD' : [ 0x20, {
    'Thread' : [ 0x0, ['pointer', ['_KTHREAD']]],
    'CurrentSpinNode' : [ 0x4, ['pointer', ['_VI_DEADLOCK_NODE']]],
    'CurrentOtherNode' : [ 0x8, ['pointer', ['_VI_DEADLOCK_NODE']]],
    'ListEntry' : [ 0xc, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0xc, ['_LIST_ENTRY']],
    'NodeCount' : [ 0x14, ['unsigned long']],
    'PagingCount' : [ 0x18, ['unsigned long']],
    'ThreadUsesEresources' : [ 0x1c, ['unsigned char']],
} ],
  '_PPM_IDLE_STATE' : [ 0x44, {
    'DomainMembers' : [ 0x0, ['_KAFFINITY_EX']],
    'Name' : [ 0xc, ['_UNICODE_STRING']],
    'Latency' : [ 0x14, ['unsigned long']],
    'BreakEvenDuration' : [ 0x18, ['unsigned long']],
    'Power' : [ 0x1c, ['unsigned long']],
    'StateFlags' : [ 0x20, ['unsigned long']],
    'VetoAccounting' : [ 0x24, ['_PPM_VETO_ACCOUNTING']],
    'StateType' : [ 0x3c, ['unsigned char']],
    'InterruptsEnabled' : [ 0x3d, ['unsigned char']],
    'Interruptible' : [ 0x3e, ['unsigned char']],
    'ContextRetained' : [ 0x3f, ['unsigned char']],
    'CacheCoherent' : [ 0x40, ['unsigned char']],
    'WakesSpuriously' : [ 0x41, ['unsigned char']],
    'PlatformOnly' : [ 0x42, ['unsigned char']],
    'NoCState' : [ 0x43, ['unsigned char']],
} ],
  '_KRESOURCEMANAGER' : [ 0x154, {
    'NotificationAvailable' : [ 0x0, ['_KEVENT']],
    'cookie' : [ 0x10, ['unsigned long']],
    'State' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'KResourceManagerUninitialized', 1: 'KResourceManagerOffline', 2: 'KResourceManagerOnline'})]],
    'Flags' : [ 0x18, ['unsigned long']],
    'Mutex' : [ 0x1c, ['_KMUTANT']],
    'NamespaceLink' : [ 0x3c, ['_KTMOBJECT_NAMESPACE_LINK']],
    'RmId' : [ 0x50, ['_GUID']],
    'NotificationQueue' : [ 0x60, ['_KQUEUE']],
    'NotificationMutex' : [ 0x88, ['_KMUTANT']],
    'EnlistmentHead' : [ 0xa8, ['_LIST_ENTRY']],
    'EnlistmentCount' : [ 0xb0, ['unsigned long']],
    'NotificationRoutine' : [ 0xb4, ['pointer', ['void']]],
    'Key' : [ 0xb8, ['pointer', ['void']]],
    'ProtocolListHead' : [ 0xbc, ['_LIST_ENTRY']],
    'PendingPropReqListHead' : [ 0xc4, ['_LIST_ENTRY']],
    'CRMListEntry' : [ 0xcc, ['_LIST_ENTRY']],
    'Tm' : [ 0xd4, ['pointer', ['_KTM']]],
    'Description' : [ 0xd8, ['_UNICODE_STRING']],
    'Enlistments' : [ 0xe0, ['_KTMOBJECT_NAMESPACE']],
    'CompletionBinding' : [ 0x140, ['_KRESOURCEMANAGER_COMPLETION_BINDING']],
} ],
  '_MI_SYSTEM_PTE_STATE' : [ 0x180, {
    'DeadPteTrackerSListHead' : [ 0x0, ['_SLIST_HEADER']],
    'PteTrackerLock' : [ 0x8, ['unsigned long']],
    'MdlTrackerLookaside' : [ 0x40, ['_NPAGED_LOOKASIDE_LIST']],
    'PteTrackingBitmap' : [ 0x100, ['_RTL_BITMAP']],
    'CachedPteHeads' : [ 0x108, ['pointer', ['_MI_CACHED_PTES']]],
    'SystemViewPteInfo' : [ 0x10c, ['_MI_SYSTEM_PTE_TYPE']],
    'KernelStackPages' : [ 0x140, ['unsigned char']],
    'QueuedStacks' : [ 0x148, ['_SLIST_HEADER']],
    'StackGrowthFailures' : [ 0x150, ['unsigned long']],
    'TrackPtesAborted' : [ 0x154, ['unsigned char']],
    'AdjustCounter' : [ 0x155, ['unsigned char']],
    'QueuedStacksWorkItem' : [ 0x158, ['_MI_QUEUED_DEADSTACK_WORKITEM']],
} ],
  '_HANDLE_TABLE_FREE_LIST' : [ 0x34, {
    'FreeListLock' : [ 0x0, ['_EX_PUSH_LOCK']],
    'FirstFreeHandleEntry' : [ 0x4, ['pointer', ['_HANDLE_TABLE_ENTRY']]],
    'LastFreeHandleEntry' : [ 0x8, ['pointer', ['_HANDLE_TABLE_ENTRY']]],
    'HandleCount' : [ 0xc, ['long']],
    'HighWaterMark' : [ 0x10, ['unsigned long']],
    'Reserved' : [ 0x14, ['array', 8, ['unsigned long']]],
} ],
  '_WHEAP_ERROR_RECORD_WRAPPER_FLAGS' : [ 0x4, {
    'Preallocated' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'FromPersistentStore' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PlatformPfaControl' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PlatformDirectedOffline' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_AGGREGATED_PAYLOAD_FILTER' : [ 0x50, {
    'MagicValue' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 12, native_type='unsigned short')]],
    'DescriptorVersion' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 16, native_type='unsigned short')]],
    'Size' : [ 0x2, ['unsigned short']],
    'PredicateCount' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['unsigned short']],
    'HashedEventIdBitmap' : [ 0x8, ['unsigned long long']],
    'ProviderGuid' : [ 0x10, ['_GUID']],
    'EachEventTableOffset' : [ 0x20, ['unsigned short']],
    'EachEventTableLength' : [ 0x22, ['unsigned short']],
    'PayloadDecoderTableOffset' : [ 0x24, ['unsigned short']],
    'PayloadDecoderTableLength' : [ 0x26, ['unsigned short']],
    'EventFilterTableOffset' : [ 0x28, ['unsigned short']],
    'EventFilterTableLength' : [ 0x2a, ['unsigned short']],
    'UNICODEStringTableOffset' : [ 0x2c, ['unsigned short']],
    'UNICODEStringTableLength' : [ 0x2e, ['unsigned short']],
    'ANSIStringTableOffset' : [ 0x30, ['unsigned short']],
    'ANSIStringTableLength' : [ 0x32, ['unsigned short']],
    'PredicateTable' : [ 0x38, ['array', 1, ['_EVENT_PAYLOAD_PREDICATE']]],
} ],
  '_GDI_TEB_BATCH64' : [ 0x4e8, {
    'Offset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 31, native_type='unsigned long')]],
    'HasRenderingCommand' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HDC' : [ 0x8, ['unsigned long long']],
    'Buffer' : [ 0x10, ['array', 310, ['unsigned long']]],
} ],
  '_PPM_POLICY_SETTINGS_MASK' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long long']],
    'PerfDecreaseTime' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'PerfIncreaseTime' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PerfDecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'PerfIncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'PerfDecreaseThreshold' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PerfIncreaseThreshold' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'PerfMinPolicy' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'PerfMaxPolicy' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'PerfTimeCheck' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'PerfBoostPolicy' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'PerfBoostMode' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long')]],
    'AllowThrottling' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long')]],
    'PerfHistoryCount' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long')]],
    'ParkingPerfState' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long')]],
    'LatencyHintPerf' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long')]],
    'LatencyHintUnpark' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 16, native_type='unsigned long')]],
    'CoreParkingMinCores' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'CoreParkingMaxCores' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'CoreParkingDecreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long')]],
    'CoreParkingIncreasePolicy' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long')]],
    'CoreParkingDecreaseTime' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long')]],
    'CoreParkingIncreaseTime' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'CoreParkingOverUtilizationThreshold' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long')]],
    'CoreParkingDistributeUtility' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 24, native_type='unsigned long')]],
    'CoreParkingConcurrencyThreshold' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'CoreParkingHeadroomThreshold' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'CoreParkingDistributionThreshold' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'IdleAllowScaling' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'IdleDisable' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'IdleTimeCheck' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'IdleDemoteThreshold' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'IdlePromoteThreshold' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'HeteroDecreaseTime' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'HeteroIncreaseTime' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'HeteroDecreaseThreshold' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'HeteroIncreaseThreshold' : [ 0x4, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'Class0FloorPerformance' : [ 0x4, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'Class1InitialPerformance' : [ 0x4, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'EnergyPerfPreference' : [ 0x4, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'AutonomousActivityWindow' : [ 0x4, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'AutonomousMode' : [ 0x4, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long')]],
    'DutyCycling' : [ 0x4, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long')]],
    'Spare' : [ 0x4, ['BitField', dict(start_bit = 10, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_27a3' : [ 0x4, {
    'NodeSize' : [ 0x0, ['unsigned long']],
    'UseLookaside' : [ 0x0, ['unsigned long']],
} ],
  '_VF_AVL_TREE' : [ 0x14, {
    'NodeRangeSize' : [ 0x0, ['unsigned long']],
    'NodeCount' : [ 0x4, ['unsigned long']],
    'Tables' : [ 0x8, ['pointer', ['_VF_AVL_TABLE']]],
    'TablesNo' : [ 0xc, ['unsigned long']],
    'u1' : [ 0x10, ['__unnamed_27a3']],
} ],
  '_FILE_NETWORK_OPEN_INFORMATION' : [ 0x38, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LastAccessTime' : [ 0x8, ['_LARGE_INTEGER']],
    'LastWriteTime' : [ 0x10, ['_LARGE_INTEGER']],
    'ChangeTime' : [ 0x18, ['_LARGE_INTEGER']],
    'AllocationSize' : [ 0x20, ['_LARGE_INTEGER']],
    'EndOfFile' : [ 0x28, ['_LARGE_INTEGER']],
    'FileAttributes' : [ 0x30, ['unsigned long']],
} ],
  '_POP_FX_ACCOUNTING' : [ 0x28, {
    'Lock' : [ 0x0, ['unsigned long']],
    'Active' : [ 0x4, ['unsigned char']],
    'DripsRequiredState' : [ 0x8, ['unsigned long']],
    'Level' : [ 0xc, ['long']],
    'ActiveStamp' : [ 0x10, ['long long']],
    'CsActiveTime' : [ 0x18, ['unsigned long long']],
    'CriticalActiveTime' : [ 0x20, ['long long']],
} ],
  '_MI_RESUME_WORKITEM' : [ 0x20, {
    'ResumeCompleteEvent' : [ 0x0, ['_KEVENT']],
    'WorkItem' : [ 0x10, ['_WORK_QUEUE_ITEM']],
} ],
  '_WHEA_MEMORY_ERROR_SECTION_VALIDBITS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'PhysicalAddress' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'PhysicalAddressMask' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'Node' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'Card' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Module' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long long')]],
    'Bank' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long long')]],
    'Device' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long long')]],
    'Row' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 9, native_type='unsigned long long')]],
    'Column' : [ 0x0, ['BitField', dict(start_bit = 9, end_bit = 10, native_type='unsigned long long')]],
    'BitPosition' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'RequesterId' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'ResponderId' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 13, native_type='unsigned long long')]],
    'TargetId' : [ 0x0, ['BitField', dict(start_bit = 13, end_bit = 14, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 14, end_bit = 15, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 15, end_bit = 64, native_type='unsigned long long')]],
    'ValidBits' : [ 0x0, ['unsigned long long']],
} ],
  '_POP_TRIGGER_WAIT' : [ 0x20, {
    'Event' : [ 0x0, ['_KEVENT']],
    'Status' : [ 0x10, ['long']],
    'Link' : [ 0x14, ['_LIST_ENTRY']],
    'Trigger' : [ 0x1c, ['pointer', ['_POP_ACTION_TRIGGER']]],
} ],
  '_AER_ENDPOINT_DESCRIPTOR_FLAGS' : [ 0x2, {
    'UncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'UncorrectableErrorSeverityRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'CorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'AdvancedCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_TRIAGE_EX_WORK_QUEUE' : [ 0x19c, {
    'WorkPriQueue' : [ 0x0, ['_KPRIQUEUE']],
} ],
  '_HEAP_FREE_ENTRY_EXTRA' : [ 0x4, {
    'TagIndex' : [ 0x0, ['unsigned short']],
    'FreeBackTraceIndex' : [ 0x2, ['unsigned short']],
} ],
  '_PROC_PERF_HISTORY_ENTRY' : [ 0x8, {
    'Utility' : [ 0x0, ['unsigned short']],
    'AffinitizedUtility' : [ 0x2, ['unsigned short']],
    'Frequency' : [ 0x4, ['unsigned char']],
    'TaggedPercent' : [ 0x5, ['array', 2, ['unsigned char']]],
} ],
  '_POP_FX_COMPONENT' : [ 0xc0, {
    'Id' : [ 0x0, ['_GUID']],
    'Index' : [ 0x10, ['unsigned long']],
    'WorkOrder' : [ 0x14, ['_POP_FX_WORK_ORDER']],
    'Device' : [ 0x30, ['pointer', ['_POP_FX_DEVICE']]],
    'Flags' : [ 0x34, ['_POP_FX_COMPONENT_FLAGS']],
    'Resident' : [ 0x3c, ['long']],
    'ActiveEvent' : [ 0x40, ['_KEVENT']],
    'IdleLock' : [ 0x50, ['unsigned long']],
    'IdleConditionComplete' : [ 0x54, ['long']],
    'IdleStateComplete' : [ 0x58, ['long']],
    'IdleStamp' : [ 0x60, ['unsigned long long']],
    'CurrentIdleState' : [ 0x68, ['unsigned long']],
    'IdleStateCount' : [ 0x6c, ['unsigned long']],
    'IdleStates' : [ 0x70, ['pointer', ['_POP_FX_IDLE_STATE']]],
    'DeepestWakeableIdleState' : [ 0x74, ['unsigned long']],
    'ProviderCount' : [ 0x78, ['unsigned long']],
    'Providers' : [ 0x7c, ['pointer', ['_POP_FX_PROVIDER']]],
    'IdleProviderCount' : [ 0x80, ['unsigned long']],
    'DependentCount' : [ 0x84, ['unsigned long']],
    'Dependents' : [ 0x88, ['pointer', ['_POP_FX_DEPENDENT']]],
    'Accounting' : [ 0x90, ['_POP_FX_ACCOUNTING']],
    'Performance' : [ 0xb8, ['pointer', ['_POP_FX_PERF_INFO']]],
} ],
  '_PEP_CRASHDUMP_INFORMATION' : [ 0x8, {
    'DeviceHandle' : [ 0x0, ['pointer', ['PEPHANDLE__']]],
    'DeviceContext' : [ 0x4, ['pointer', ['void']]],
} ],
  '_POP_FX_DRIVER_CALLBACKS' : [ 0x1c, {
    'ComponentActive' : [ 0x0, ['pointer', ['void']]],
    'ComponentIdle' : [ 0x4, ['pointer', ['void']]],
    'ComponentIdleState' : [ 0x8, ['pointer', ['void']]],
    'DevicePowerRequired' : [ 0xc, ['pointer', ['void']]],
    'DevicePowerNotRequired' : [ 0x10, ['pointer', ['void']]],
    'PowerControl' : [ 0x14, ['pointer', ['void']]],
    'ComponentCriticalTransition' : [ 0x18, ['pointer', ['void']]],
} ],
  '_PROVIDER_BINARY_ENTRY' : [ 0x2c, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'ConsumersNotified' : [ 0x8, ['unsigned char']],
    'Spare' : [ 0x9, ['array', 3, ['unsigned char']]],
    'DebugIdSize' : [ 0xc, ['unsigned long']],
    'DebugId' : [ 0x10, ['_CVDD']],
} ],
  '_VI_DEADLOCK_GLOBALS' : [ 0x40f0, {
    'TimeAcquire' : [ 0x0, ['long long']],
    'TimeRelease' : [ 0x8, ['long long']],
    'ResourceDatabase' : [ 0x10, ['pointer', ['_LIST_ENTRY']]],
    'ResourceDatabaseCount' : [ 0x14, ['unsigned long']],
    'ResourceAddressRange' : [ 0x18, ['array', 1023, ['_VF_ADDRESS_RANGE']]],
    'ThreadDatabase' : [ 0x2010, ['pointer', ['_LIST_ENTRY']]],
    'ThreadDatabaseCount' : [ 0x2014, ['unsigned long']],
    'ThreadAddressRange' : [ 0x2018, ['array', 1023, ['_VF_ADDRESS_RANGE']]],
    'AllocationFailures' : [ 0x4010, ['unsigned long']],
    'NodesTrimmedBasedOnAge' : [ 0x4014, ['unsigned long']],
    'NodesTrimmedBasedOnCount' : [ 0x4018, ['unsigned long']],
    'NodesSearched' : [ 0x401c, ['unsigned long']],
    'MaxNodesSearched' : [ 0x4020, ['unsigned long']],
    'SequenceNumber' : [ 0x4024, ['unsigned long']],
    'RecursionDepthLimit' : [ 0x4028, ['unsigned long']],
    'SearchedNodesLimit' : [ 0x402c, ['unsigned long']],
    'DepthLimitHits' : [ 0x4030, ['unsigned long']],
    'SearchLimitHits' : [ 0x4034, ['unsigned long']],
    'StackLimitHits' : [ 0x4038, ['unsigned long']],
    'ABC_ACB_Skipped' : [ 0x403c, ['unsigned long']],
    'OutOfOrderReleases' : [ 0x4040, ['unsigned long']],
    'NodesReleasedOutOfOrder' : [ 0x4044, ['unsigned long']],
    'TotalReleases' : [ 0x4048, ['unsigned long']],
    'RootNodesDeleted' : [ 0x404c, ['unsigned long']],
    'ForgetHistoryCounter' : [ 0x4050, ['unsigned long']],
    'Instigator' : [ 0x4054, ['pointer', ['void']]],
    'NumberOfParticipants' : [ 0x4058, ['unsigned long']],
    'Participant' : [ 0x405c, ['array', 32, ['pointer', ['_VI_DEADLOCK_NODE']]]],
    'ChildrenCountWatermark' : [ 0x40dc, ['long']],
    'StackType' : [ 0x40e0, ['Enumeration', dict(target = 'long', choices = {0: 'BugcheckStackLimits', 1: 'DPCStackLimits', 2: 'ExpandedStackLimits', 3: 'NormalStackLimits', 4: 'Win32kStackLimits', 5: 'SwapBusyStackLimits', 6: 'IsrStackLimits', 7: 'MaximumStackLimits'})]],
    'StackLowLimit' : [ 0x40e4, ['unsigned long']],
    'StackHighLimit' : [ 0x40e8, ['unsigned long']],
} ],
  '_KTM' : [ 0x238, {
    'cookie' : [ 0x0, ['unsigned long']],
    'Mutex' : [ 0x4, ['_KMUTANT']],
    'State' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'KKtmUninitialized', 1: 'KKtmInitialized', 2: 'KKtmRecovering', 3: 'KKtmOnline', 4: 'KKtmRecoveryFailed', 5: 'KKtmOffline'})]],
    'NamespaceLink' : [ 0x28, ['_KTMOBJECT_NAMESPACE_LINK']],
    'TmIdentity' : [ 0x3c, ['_GUID']],
    'Flags' : [ 0x4c, ['unsigned long']],
    'VolatileFlags' : [ 0x50, ['unsigned long']],
    'LogFileName' : [ 0x54, ['_UNICODE_STRING']],
    'LogFileObject' : [ 0x5c, ['pointer', ['_FILE_OBJECT']]],
    'MarshallingContext' : [ 0x60, ['pointer', ['void']]],
    'LogManagementContext' : [ 0x64, ['pointer', ['void']]],
    'Transactions' : [ 0x68, ['_KTMOBJECT_NAMESPACE']],
    'ResourceManagers' : [ 0xc8, ['_KTMOBJECT_NAMESPACE']],
    'LsnOrderedMutex' : [ 0x128, ['_KMUTANT']],
    'LsnOrderedList' : [ 0x148, ['_LIST_ENTRY']],
    'CommitVirtualClock' : [ 0x150, ['_LARGE_INTEGER']],
    'CommitVirtualClockMutex' : [ 0x158, ['_FAST_MUTEX']],
    'BaseLsn' : [ 0x178, ['_CLS_LSN']],
    'CurrentReadLsn' : [ 0x180, ['_CLS_LSN']],
    'LastRecoveredLsn' : [ 0x188, ['_CLS_LSN']],
    'TmRmHandle' : [ 0x190, ['pointer', ['void']]],
    'TmRm' : [ 0x194, ['pointer', ['_KRESOURCEMANAGER']]],
    'LogFullNotifyEvent' : [ 0x198, ['_KEVENT']],
    'CheckpointWorkItem' : [ 0x1a8, ['_WORK_QUEUE_ITEM']],
    'CheckpointTargetLsn' : [ 0x1b8, ['_CLS_LSN']],
    'LogFullCompletedWorkItem' : [ 0x1c0, ['_WORK_QUEUE_ITEM']],
    'LogWriteResource' : [ 0x1d0, ['_ERESOURCE']],
    'LogFlags' : [ 0x208, ['unsigned long']],
    'LogFullStatus' : [ 0x20c, ['long']],
    'RecoveryStatus' : [ 0x210, ['long']],
    'LastCheckBaseLsn' : [ 0x218, ['_CLS_LSN']],
    'RestartOrderedList' : [ 0x220, ['_LIST_ENTRY']],
    'OfflineWorkItem' : [ 0x228, ['_WORK_QUEUE_ITEM']],
} ],
  '_MM_SYSTEM_PAGE_COUNTS' : [ 0x10, {
    'SystemCodePage' : [ 0x0, ['unsigned long']],
    'SystemDriverPage' : [ 0x4, ['unsigned long']],
    'TotalSystemCodePages' : [ 0x8, ['long']],
    'TotalSystemDriverPages' : [ 0xc, ['long']],
} ],
  '_MI_MODWRITE_DATA' : [ 0x30, {
    'PagesLoad' : [ 0x0, ['long']],
    'PagesAverage' : [ 0x4, ['unsigned long']],
    'AverageAvailablePages' : [ 0x8, ['unsigned long']],
    'PagesWritten' : [ 0xc, ['unsigned long']],
    'WritesIssued' : [ 0x10, ['unsigned long']],
    'IgnoredReservationsCount' : [ 0x14, ['unsigned long']],
    'FreedReservationsCount' : [ 0x18, ['unsigned long']],
    'WriteBurstCount' : [ 0x1c, ['unsigned long']],
    'IgnoreReservationsStartTime' : [ 0x20, ['unsigned long long']],
    'ReservationClusterInfo' : [ 0x28, ['_MI_RESERVATION_CLUSTER_INFO']],
    'IgnoreReservations' : [ 0x2c, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Spare' : [ 0x2c, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'Spare1' : [ 0x2e, ['unsigned short']],
} ],
  '_VF_BTS_RECORD' : [ 0xc, {
    'JumpedFrom' : [ 0x0, ['pointer', ['void']]],
    'JumpedTo' : [ 0x4, ['pointer', ['void']]],
    'Unused1' : [ 0x8, ['BitField', dict(start_bit = 0, end_bit = 3, native_type='unsigned long')]],
    'Predicted' : [ 0x8, ['BitField', dict(start_bit = 3, end_bit = 7, native_type='unsigned long')]],
    'Unused2' : [ 0x8, ['BitField', dict(start_bit = 7, end_bit = 32, native_type='unsigned long')]],
} ],
  '_PLATFORM_IDLE_STATE_ACCOUNTING' : [ 0x3e8, {
    'CancelCount' : [ 0x0, ['unsigned long']],
    'FailureCount' : [ 0x4, ['unsigned long']],
    'SuccessCount' : [ 0x8, ['unsigned long']],
    'MaxTime' : [ 0x10, ['unsigned long long']],
    'MinTime' : [ 0x18, ['unsigned long long']],
    'TotalTime' : [ 0x20, ['unsigned long long']],
    'InvalidBucketIndex' : [ 0x28, ['unsigned long']],
    'SelectionStatistics' : [ 0x30, ['_PPM_SELECTION_STATISTICS']],
    'IdleTimeBuckets' : [ 0xa8, ['array', 26, ['_PROC_IDLE_STATE_BUCKET']]],
} ],
  '_KTRANSACTION' : [ 0x1e0, {
    'OutcomeEvent' : [ 0x0, ['_KEVENT']],
    'cookie' : [ 0x10, ['unsigned long']],
    'Mutex' : [ 0x14, ['_KMUTANT']],
    'TreeTx' : [ 0x34, ['pointer', ['_KTRANSACTION']]],
    'GlobalNamespaceLink' : [ 0x38, ['_KTMOBJECT_NAMESPACE_LINK']],
    'TmNamespaceLink' : [ 0x4c, ['_KTMOBJECT_NAMESPACE_LINK']],
    'UOW' : [ 0x60, ['_GUID']],
    'State' : [ 0x70, ['Enumeration', dict(target = 'long', choices = {0: 'KTransactionUninitialized', 1: 'KTransactionActive', 2: 'KTransactionPreparing', 3: 'KTransactionPrepared', 4: 'KTransactionInDoubt', 5: 'KTransactionCommitted', 6: 'KTransactionAborted', 7: 'KTransactionDelegated', 8: 'KTransactionPrePreparing', 9: 'KTransactionForgotten', 10: 'KTransactionRecovering', 11: 'KTransactionPrePrepared'})]],
    'Flags' : [ 0x74, ['unsigned long']],
    'EnlistmentHead' : [ 0x78, ['_LIST_ENTRY']],
    'EnlistmentCount' : [ 0x80, ['unsigned long']],
    'RecoverableEnlistmentCount' : [ 0x84, ['unsigned long']],
    'PrePrepareRequiredEnlistmentCount' : [ 0x88, ['unsigned long']],
    'PrepareRequiredEnlistmentCount' : [ 0x8c, ['unsigned long']],
    'OutcomeRequiredEnlistmentCount' : [ 0x90, ['unsigned long']],
    'PendingResponses' : [ 0x94, ['unsigned long']],
    'SuperiorEnlistment' : [ 0x98, ['pointer', ['_KENLISTMENT']]],
    'LastLsn' : [ 0xa0, ['_CLS_LSN']],
    'PromotedEntry' : [ 0xa8, ['_LIST_ENTRY']],
    'PromoterTransaction' : [ 0xb0, ['pointer', ['_KTRANSACTION']]],
    'PromotePropagation' : [ 0xb4, ['pointer', ['void']]],
    'IsolationLevel' : [ 0xb8, ['unsigned long']],
    'IsolationFlags' : [ 0xbc, ['unsigned long']],
    'Timeout' : [ 0xc0, ['_LARGE_INTEGER']],
    'Description' : [ 0xc8, ['_UNICODE_STRING']],
    'RollbackThread' : [ 0xd0, ['pointer', ['_KTHREAD']]],
    'RollbackWorkItem' : [ 0xd4, ['_WORK_QUEUE_ITEM']],
    'RollbackDpc' : [ 0xe4, ['_KDPC']],
    'RollbackTimer' : [ 0x108, ['_KTIMER']],
    'LsnOrderedEntry' : [ 0x130, ['_LIST_ENTRY']],
    'Outcome' : [ 0x138, ['Enumeration', dict(target = 'long', choices = {0: 'KTxOutcomeUninitialized', 1: 'KTxOutcomeUndetermined', 2: 'KTxOutcomeCommitted', 3: 'KTxOutcomeAborted', 4: 'KTxOutcomeUnavailable'})]],
    'Tm' : [ 0x13c, ['pointer', ['_KTM']]],
    'CommitReservation' : [ 0x140, ['long long']],
    'TransactionHistory' : [ 0x148, ['array', 10, ['_KTRANSACTION_HISTORY']]],
    'TransactionHistoryCount' : [ 0x198, ['unsigned long']],
    'DTCPrivateInformation' : [ 0x19c, ['pointer', ['void']]],
    'DTCPrivateInformationLength' : [ 0x1a0, ['unsigned long']],
    'DTCPrivateInformationMutex' : [ 0x1a4, ['_KMUTANT']],
    'PromotedTxSelfHandle' : [ 0x1c4, ['pointer', ['void']]],
    'PendingPromotionCount' : [ 0x1c8, ['unsigned long']],
    'PromotionCompletedEvent' : [ 0x1cc, ['_KEVENT']],
} ],
  '_PRIVATE_CACHE_MAP_FLAGS' : [ 0x4, {
    'DontUse' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long')]],
    'ReadAheadActive' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long')]],
    'ReadAheadEnabled' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long')]],
    'PagePriority' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 21, native_type='unsigned long')]],
    'PipelineReadAheads' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long')]],
    'Available' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 32, native_type='unsigned long')]],
} ],
  '_CM_KCB_UOW' : [ 0x38, {
    'TransactionListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'KCBLock' : [ 0x8, ['pointer', ['_CM_INTENT_LOCK']]],
    'KeyLock' : [ 0xc, ['pointer', ['_CM_INTENT_LOCK']]],
    'KCBListEntry' : [ 0x10, ['_LIST_ENTRY']],
    'KeyControlBlock' : [ 0x18, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'Transaction' : [ 0x1c, ['pointer', ['_CM_TRANS']]],
    'UoWState' : [ 0x20, ['unsigned long']],
    'ActionType' : [ 0x24, ['Enumeration', dict(target = 'long', choices = {0: 'UoWAddThisKey', 1: 'UoWAddChildKey', 2: 'UoWDeleteThisKey', 3: 'UoWDeleteChildKey', 4: 'UoWSetValueNew', 5: 'UoWSetValueExisting', 6: 'UoWDeleteValue', 7: 'UoWSetKeyUserFlags', 8: 'UoWSetLastWriteTime', 9: 'UoWSetSecurityDescriptor', 10: 'UoWRenameSubKey', 11: 'UoWRenameOldSubKey', 12: 'UoWRenameNewSubKey', 13: 'UoWIsolation', 14: 'UoWInvalid'})]],
    'StorageType' : [ 0x28, ['Enumeration', dict(target = 'long', choices = {0: 'Stable', 1: 'Volatile', 2: 'InvalidStorage'})]],
    'ChildKCB' : [ 0x30, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'VolatileKeyCell' : [ 0x30, ['unsigned long']],
    'OldValueCell' : [ 0x30, ['unsigned long']],
    'NewValueCell' : [ 0x34, ['unsigned long']],
    'UserFlags' : [ 0x30, ['unsigned long']],
    'LastWriteTime' : [ 0x30, ['_LARGE_INTEGER']],
    'TxSecurityCell' : [ 0x30, ['unsigned long']],
    'OldChildKCB' : [ 0x30, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'NewChildKCB' : [ 0x34, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'OtherChildKCB' : [ 0x30, ['pointer', ['_CM_KEY_CONTROL_BLOCK']]],
    'ThisVolatileKeyCell' : [ 0x34, ['unsigned long']],
} ],
  '_KPROCESSOR_STATE' : [ 0x320, {
    'ContextFrame' : [ 0x0, ['_CONTEXT']],
    'SpecialRegisters' : [ 0x2cc, ['_KSPECIAL_REGISTERS']],
} ],
  '_MMPTE_TRANSITION' : [ 0x8, {
    'Valid' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long long')]],
    'Write' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long long')]],
    'WriteThrough' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long long')]],
    'CacheDisable' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long long')]],
    'Protection' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 10, native_type='unsigned long long')]],
    'Prototype' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 11, native_type='unsigned long long')]],
    'Transition' : [ 0x0, ['BitField', dict(start_bit = 11, end_bit = 12, native_type='unsigned long long')]],
    'PageFrameNumber' : [ 0x0, ['BitField', dict(start_bit = 12, end_bit = 38, native_type='unsigned long long')]],
    'Unused' : [ 0x0, ['BitField', dict(start_bit = 38, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_PROCESSOR_IDLE_CONSTRAINTS' : [ 0x30, {
    'TotalTime' : [ 0x0, ['unsigned long long']],
    'IdleTime' : [ 0x8, ['unsigned long long']],
    'ExpectedIdleDuration' : [ 0x10, ['unsigned long long']],
    'MaxIdleDuration' : [ 0x18, ['unsigned long long']],
    'OverrideState' : [ 0x20, ['unsigned long']],
    'TimeCheck' : [ 0x24, ['unsigned long']],
    'PromotePercent' : [ 0x28, ['unsigned char']],
    'DemotePercent' : [ 0x29, ['unsigned char']],
    'Parked' : [ 0x2a, ['unsigned char']],
    'Interruptible' : [ 0x2b, ['unsigned char']],
    'PlatformIdle' : [ 0x2c, ['unsigned char']],
    'ExpectedWakeReason' : [ 0x2d, ['unsigned char']],
} ],
  '_KREQUEST_PACKET' : [ 0x10, {
    'CurrentPacket' : [ 0x0, ['array', 3, ['pointer', ['void']]]],
    'WorkerRoutine' : [ 0xc, ['pointer', ['void']]],
} ],
  '_VF_WATCHDOG_IRP' : [ 0x14, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x8, ['pointer', ['_IRP']]],
    'DueTickCount' : [ 0xc, ['unsigned long']],
    'Inserted' : [ 0x10, ['unsigned char']],
    'TrackedStackLocation' : [ 0x11, ['unsigned char']],
    'CancelTimeoutTicks' : [ 0x12, ['unsigned short']],
} ],
  '_MMVAD_FLAGS2' : [ 0x4, {
    'FileOffset' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'Large' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 25, native_type='unsigned long')]],
    'TrimBehind' : [ 0x0, ['BitField', dict(start_bit = 25, end_bit = 26, native_type='unsigned long')]],
    'Inherit' : [ 0x0, ['BitField', dict(start_bit = 26, end_bit = 27, native_type='unsigned long')]],
    'CopyOnWrite' : [ 0x0, ['BitField', dict(start_bit = 27, end_bit = 28, native_type='unsigned long')]],
    'NoValidationNeeded' : [ 0x0, ['BitField', dict(start_bit = 28, end_bit = 29, native_type='unsigned long')]],
    'PrivateDemandZero' : [ 0x0, ['BitField', dict(start_bit = 29, end_bit = 30, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 32, native_type='unsigned long')]],
} ],
  '_flags' : [ 0x1, {
    'Removable' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'GroupAssigned' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'GroupCommitted' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned char')]],
    'GroupAssignmentFixed' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned char')]],
    'Fill' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 8, native_type='unsigned char')]],
} ],
  '__unnamed_281d' : [ 0x8, {
    'Head' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long long')]],
    'Tail' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 48, native_type='unsigned long long')]],
    'ActiveThreadCount' : [ 0x0, ['BitField', dict(start_bit = 48, end_bit = 64, native_type='unsigned long long')]],
} ],
  '__unnamed_281f' : [ 0x8, {
    's1' : [ 0x0, ['__unnamed_281d']],
    'Value' : [ 0x0, ['long long']],
} ],
  '_ALPC_COMPLETION_LIST_STATE' : [ 0x8, {
    'u1' : [ 0x0, ['__unnamed_281f']],
} ],
  '_CM_KEY_SECURITY_CACHE' : [ 0x2c, {
    'Cell' : [ 0x0, ['unsigned long']],
    'ConvKey' : [ 0x4, ['unsigned long']],
    'List' : [ 0x8, ['_LIST_ENTRY']],
    'DescriptorLength' : [ 0x10, ['unsigned long']],
    'RealRefCount' : [ 0x14, ['unsigned long']],
    'Descriptor' : [ 0x18, ['_SECURITY_DESCRIPTOR_RELATIVE']],
} ],
  '_CM_NAME_HASH' : [ 0xc, {
    'ConvKey' : [ 0x0, ['unsigned long']],
    'NextHash' : [ 0x4, ['pointer', ['_CM_NAME_HASH']]],
    'NameLength' : [ 0x8, ['unsigned short']],
    'Name' : [ 0xa, ['array', 1, ['wchar']]],
} ],
  '_PROC_IDLE_STATE_BUCKET' : [ 0x20, {
    'TotalTime' : [ 0x0, ['unsigned long long']],
    'MinTime' : [ 0x8, ['unsigned long long']],
    'MaxTime' : [ 0x10, ['unsigned long long']],
    'Count' : [ 0x18, ['unsigned long']],
} ],
  '_PO_IRP_QUEUE' : [ 0x8, {
    'CurrentIrp' : [ 0x0, ['pointer', ['_IRP']]],
    'PendingIrpList' : [ 0x4, ['pointer', ['_IRP']]],
} ],
  '_MMSECURE_FLAGS' : [ 0x4, {
    'ReadOnly' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReadWrite' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'SecNoChange' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'NoDelete' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'RequiresPteReversal' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'ExclusiveSecure' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'Spare' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 12, native_type='unsigned long')]],
} ],
  '__unnamed_2834' : [ 0x4, {
    'Active' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'OnlyTryAcquireUsed' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'ReleasedOutOfOrder' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'SequenceNumber' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 32, native_type='unsigned long')]],
    'Whole' : [ 0x0, ['unsigned long']],
} ],
  '_VI_DEADLOCK_NODE' : [ 0x6c, {
    'Parent' : [ 0x0, ['pointer', ['_VI_DEADLOCK_NODE']]],
    'ChildrenList' : [ 0x4, ['_LIST_ENTRY']],
    'SiblingsList' : [ 0xc, ['_LIST_ENTRY']],
    'ResourceList' : [ 0x14, ['_LIST_ENTRY']],
    'FreeListEntry' : [ 0x14, ['_LIST_ENTRY']],
    'Root' : [ 0x1c, ['pointer', ['_VI_DEADLOCK_RESOURCE']]],
    'ThreadEntry' : [ 0x20, ['pointer', ['_VI_DEADLOCK_THREAD']]],
    'u1' : [ 0x24, ['__unnamed_2834']],
    'ChildrenCount' : [ 0x28, ['long']],
    'StackTrace' : [ 0x2c, ['array', 8, ['pointer', ['void']]]],
    'ParentStackTrace' : [ 0x4c, ['array', 8, ['pointer', ['void']]]],
} ],
  'PROCESSOR_IDLESTATE_INFO' : [ 0x8, {
    'TimeCheck' : [ 0x0, ['unsigned long']],
    'DemotePercent' : [ 0x4, ['unsigned char']],
    'PromotePercent' : [ 0x5, ['unsigned char']],
    'Spare' : [ 0x6, ['array', 2, ['unsigned char']]],
} ],
  '_KTMOBJECT_NAMESPACE' : [ 0x60, {
    'Table' : [ 0x0, ['_RTL_AVL_TABLE']],
    'Mutex' : [ 0x38, ['_KMUTANT']],
    'LinksOffset' : [ 0x58, ['unsigned short']],
    'GuidOffset' : [ 0x5a, ['unsigned short']],
    'Expired' : [ 0x5c, ['unsigned char']],
} ],
  '_LPCP_PORT_QUEUE' : [ 0x10, {
    'NonPagedPortQueue' : [ 0x0, ['pointer', ['_LPCP_NONPAGED_PORT_QUEUE']]],
    'Semaphore' : [ 0x4, ['pointer', ['_KSEMAPHORE']]],
    'ReceiveHead' : [ 0x8, ['_LIST_ENTRY']],
} ],
  '_CM_KEY_REFERENCE' : [ 0x8, {
    'KeyCell' : [ 0x0, ['unsigned long']],
    'KeyHive' : [ 0x4, ['pointer', ['_HHIVE']]],
} ],
  'SYSTEM_POWER_LEVEL' : [ 0x18, {
    'Enable' : [ 0x0, ['unsigned char']],
    'Spare' : [ 0x1, ['array', 3, ['unsigned char']]],
    'BatteryLevel' : [ 0x4, ['unsigned long']],
    'PowerPolicy' : [ 0x8, ['POWER_ACTION_POLICY']],
    'MinSystemState' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'})]],
} ],
  '_HVIEW_MAP_ENTRY' : [ 0x18, {
    'ViewStart' : [ 0x0, ['pointer', ['void']]],
    'IsPinned' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Bcb' : [ 0x4, ['pointer', ['void']]],
    'PinnedPages' : [ 0x8, ['unsigned long long']],
    'Size' : [ 0x10, ['unsigned long']],
} ],
  '_OBJECT_DUMP_CONTROL' : [ 0x8, {
    'Stream' : [ 0x0, ['pointer', ['void']]],
    'Detail' : [ 0x4, ['unsigned long']],
} ],
  '_POP_COOLING_EXTENSION' : [ 0x48, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'RequestListHead' : [ 0x8, ['_LIST_ENTRY']],
    'Lock' : [ 0x10, ['_POP_RW_LOCK']],
    'DeviceObject' : [ 0x18, ['pointer', ['_DEVICE_OBJECT']]],
    'NotificationEntry' : [ 0x1c, ['pointer', ['void']]],
    'Enabled' : [ 0x20, ['unsigned char']],
    'ActiveEngaged' : [ 0x21, ['unsigned char']],
    'ThrottleLimit' : [ 0x22, ['unsigned char']],
    'UpdatingToCurrent' : [ 0x23, ['unsigned char']],
    'RemovalFlushEvent' : [ 0x24, ['pointer', ['_KEVENT']]],
    'PnpFlushEvent' : [ 0x28, ['pointer', ['_KEVENT']]],
    'Interface' : [ 0x2c, ['_THERMAL_COOLING_INTERFACE']],
} ],
  '_EVENT_PAYLOAD_PREDICATE' : [ 0x18, {
    'FieldIndex' : [ 0x0, ['unsigned short']],
    'CompareOp' : [ 0x2, ['unsigned short']],
    'Value' : [ 0x8, ['array', 2, ['unsigned long long']]],
} ],
  '_EVENT_HEADER_EXTENDED_DATA_ITEM' : [ 0x10, {
    'Reserved1' : [ 0x0, ['unsigned short']],
    'ExtType' : [ 0x2, ['unsigned short']],
    'Linkage' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'Reserved2' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 16, native_type='unsigned short')]],
    'DataSize' : [ 0x6, ['unsigned short']],
    'DataPtr' : [ 0x8, ['unsigned long long']],
} ],
  '_CM_INDEX' : [ 0x8, {
    'Cell' : [ 0x0, ['unsigned long']],
    'NameHint' : [ 0x4, ['array', 4, ['unsigned char']]],
    'HashKey' : [ 0x4, ['unsigned long']],
} ],
  '_VF_ADDRESS_RANGE' : [ 0x8, {
    'Start' : [ 0x0, ['pointer', ['unsigned char']]],
    'End' : [ 0x4, ['pointer', ['unsigned char']]],
} ],
  '_OBJECT_SYMBOLIC_LINK' : [ 0x18, {
    'CreationTime' : [ 0x0, ['_LARGE_INTEGER']],
    'LinkTarget' : [ 0x8, ['_UNICODE_STRING']],
    'DosDeviceDriveIndex' : [ 0x10, ['unsigned long']],
    'Flags' : [ 0x14, ['unsigned long']],
} ],
  '_LPCP_NONPAGED_PORT_QUEUE' : [ 0x18, {
    'Semaphore' : [ 0x0, ['_KSEMAPHORE']],
    'BackPointer' : [ 0x14, ['pointer', ['_LPCP_PORT_OBJECT']]],
} ],
  '_THERMAL_POLICY' : [ 0x18, {
    'Version' : [ 0x0, ['unsigned long']],
    'WaitForUpdate' : [ 0x4, ['unsigned char']],
    'Hibernate' : [ 0x5, ['unsigned char']],
    'Critical' : [ 0x6, ['unsigned char']],
    'ThermalStandby' : [ 0x7, ['unsigned char']],
    'ActivationReasons' : [ 0x8, ['unsigned long']],
    'PassiveLimit' : [ 0xc, ['unsigned long']],
    'ActiveLevel' : [ 0x10, ['unsigned long']],
    'OverThrottled' : [ 0x14, ['unsigned char']],
} ],
  '_KRESOURCEMANAGER_COMPLETION_BINDING' : [ 0x14, {
    'NotificationListHead' : [ 0x0, ['_LIST_ENTRY']],
    'Port' : [ 0x8, ['pointer', ['void']]],
    'Key' : [ 0xc, ['unsigned long']],
    'BindingProcess' : [ 0x10, ['pointer', ['_EPROCESS']]],
} ],
  '_VF_TRACKER' : [ 0x10, {
    'TrackerFlags' : [ 0x0, ['unsigned long']],
    'TrackerSize' : [ 0x4, ['unsigned long']],
    'TrackerIndex' : [ 0x8, ['unsigned long']],
    'TraceDepth' : [ 0xc, ['unsigned long']],
} ],
  '_CALL_PERFORMANCE_DATA' : [ 0x204, {
    'SpinLock' : [ 0x0, ['unsigned long']],
    'HashTable' : [ 0x4, ['array', 64, ['_LIST_ENTRY']]],
} ],
  '_ARBITER_ALTERNATIVE' : [ 0x38, {
    'Minimum' : [ 0x0, ['unsigned long long']],
    'Maximum' : [ 0x8, ['unsigned long long']],
    'Length' : [ 0x10, ['unsigned long long']],
    'Alignment' : [ 0x18, ['unsigned long long']],
    'Priority' : [ 0x20, ['long']],
    'Flags' : [ 0x24, ['unsigned long']],
    'Descriptor' : [ 0x28, ['pointer', ['_IO_RESOURCE_DESCRIPTOR']]],
    'Reserved' : [ 0x2c, ['array', 3, ['unsigned long']]],
} ],
  '_MI_AVAILABLE_PAGE_WAIT_STATES' : [ 0x14, {
    'Event' : [ 0x0, ['_KEVENT']],
    'EventSets' : [ 0x10, ['unsigned long']],
} ],
  '_WHEA_ERROR_STATUS' : [ 0x8, {
    'ErrorStatus' : [ 0x0, ['unsigned long long']],
    'Reserved1' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned long long')]],
    'ErrorType' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long long')]],
    'Address' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 17, native_type='unsigned long long')]],
    'Control' : [ 0x0, ['BitField', dict(start_bit = 17, end_bit = 18, native_type='unsigned long long')]],
    'Data' : [ 0x0, ['BitField', dict(start_bit = 18, end_bit = 19, native_type='unsigned long long')]],
    'Responder' : [ 0x0, ['BitField', dict(start_bit = 19, end_bit = 20, native_type='unsigned long long')]],
    'Requester' : [ 0x0, ['BitField', dict(start_bit = 20, end_bit = 21, native_type='unsigned long long')]],
    'FirstError' : [ 0x0, ['BitField', dict(start_bit = 21, end_bit = 22, native_type='unsigned long long')]],
    'Overflow' : [ 0x0, ['BitField', dict(start_bit = 22, end_bit = 23, native_type='unsigned long long')]],
    'Reserved2' : [ 0x0, ['BitField', dict(start_bit = 23, end_bit = 64, native_type='unsigned long long')]],
} ],
  '_WHEA_PERSISTENCE_INFO' : [ 0x8, {
    'Signature' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 16, native_type='unsigned long long')]],
    'Length' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 40, native_type='unsigned long long')]],
    'Identifier' : [ 0x0, ['BitField', dict(start_bit = 40, end_bit = 56, native_type='unsigned long long')]],
    'Attributes' : [ 0x0, ['BitField', dict(start_bit = 56, end_bit = 58, native_type='unsigned long long')]],
    'DoNotLog' : [ 0x0, ['BitField', dict(start_bit = 58, end_bit = 59, native_type='unsigned long long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 59, end_bit = 64, native_type='unsigned long long')]],
    'AsULONGLONG' : [ 0x0, ['unsigned long long']],
} ],
  '_COLORED_PAGE_INFO' : [ 0x10, {
    'BeingZeroed' : [ 0x0, ['long']],
    'Processor' : [ 0x4, ['unsigned long']],
    'PagesQueued' : [ 0x8, ['unsigned long']],
    'PfnAllocation' : [ 0xc, ['pointer', ['_MMPFN']]],
} ],
  '_TRIAGE_9F_POWER' : [ 0x10, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Revision' : [ 0x2, ['unsigned short']],
    'IrpList' : [ 0x4, ['pointer', ['_LIST_ENTRY']]],
    'ThreadList' : [ 0x8, ['pointer', ['_LIST_ENTRY']]],
    'DelayedWorkQueue' : [ 0xc, ['pointer', ['_TRIAGE_EX_WORK_QUEUE']]],
} ],
  '_MI_POOL_STATE' : [ 0x4e8, {
    'MaximumNonPagedPoolThreshold' : [ 0x0, ['unsigned long']],
    'NonPagedPoolSListMaximum' : [ 0x4, ['array', 3, ['unsigned long']]],
    'AllocatedNonPagedPool' : [ 0x10, ['unsigned long']],
    'BadPoolHead' : [ 0x14, ['_SINGLE_LIST_ENTRY']],
    'HighEventSets' : [ 0x18, ['unsigned long']],
    'HighEventSetsValid' : [ 0x1c, ['unsigned char']],
    'PoolFailures' : [ 0x20, ['array', 3, ['array', 3, ['unsigned long']]]],
    'PoolFailureReasons' : [ 0x44, ['_MI_POOL_FAILURE_REASONS']],
    'LowPagedPoolThreshold' : [ 0x70, ['unsigned long']],
    'HighPagedPoolThreshold' : [ 0x74, ['unsigned long']],
    'SpecialPoolPdesMax' : [ 0x78, ['long']],
    'NonPagedPoolNodes' : [ 0x7c, ['array', 1024, ['unsigned char']]],
    'PagedProtoPoolInfo' : [ 0x47c, ['_MM_PAGED_POOL_INFO']],
    'PagedPoolSListMaximum' : [ 0x498, ['unsigned long']],
    'PreemptiveTrims' : [ 0x49c, ['array', 4, ['unsigned long']]],
    'SpecialPagesInUsePeak' : [ 0x4ac, ['unsigned long']],
    'SpecialPoolRejected' : [ 0x4b0, ['array', 9, ['unsigned long']]],
    'SpecialPagesNonPaged' : [ 0x4d4, ['unsigned long']],
    'SpecialPoolPdes' : [ 0x4d8, ['long']],
    'SessionSpecialPoolPdesMax' : [ 0x4dc, ['unsigned long']],
    'TotalPagedPoolQuota' : [ 0x4e0, ['unsigned long']],
    'TotalNonPagedPoolQuota' : [ 0x4e4, ['unsigned long']],
} ],
  '_STACK_TABLE' : [ 0x8040, {
    'NumStackTraces' : [ 0x0, ['unsigned short']],
    'TraceCapacity' : [ 0x2, ['unsigned short']],
    'StackTrace' : [ 0x4, ['array', 16, ['pointer', ['_OBJECT_REF_TRACE']]]],
    'StackTableHash' : [ 0x44, ['array', 16381, ['unsigned short']]],
} ],
  '_POP_POWER_SETTING_VALUES' : [ 0x13c, {
    'StructureSize' : [ 0x0, ['unsigned long']],
    'PopPolicy' : [ 0x4, ['_SYSTEM_POWER_POLICY']],
    'CurrentAcDcPowerState' : [ 0xec, ['Enumeration', dict(target = 'long', choices = {0: 'PoAc', 1: 'PoDc', 2: 'PoHot', 3: 'PoConditionMaximum'})]],
    'AwayModeEnabled' : [ 0xf0, ['unsigned char']],
    'AwayModeEngaged' : [ 0xf1, ['unsigned char']],
    'AwayModePolicyAllowed' : [ 0xf2, ['unsigned char']],
    'AwayModeIgnoreUserPresent' : [ 0xf4, ['long']],
    'AwayModeIgnoreAction' : [ 0xf8, ['long']],
    'DisableFastS4' : [ 0xfc, ['unsigned char']],
    'DisableStandbyStates' : [ 0xfd, ['unsigned char']],
    'UnattendSleepTimeout' : [ 0x100, ['unsigned long']],
    'DiskIgnoreTime' : [ 0x104, ['unsigned long']],
    'DeviceIdlePolicy' : [ 0x108, ['unsigned long']],
    'VideoDimTimeout' : [ 0x10c, ['unsigned long']],
    'VideoNormalBrightness' : [ 0x110, ['unsigned long']],
    'VideoDimBrightness' : [ 0x114, ['unsigned long']],
    'AlsOffset' : [ 0x118, ['unsigned long']],
    'AlsEnabled' : [ 0x11c, ['unsigned long']],
    'EsBrightness' : [ 0x120, ['unsigned long']],
    'SwitchShutdownForced' : [ 0x124, ['unsigned char']],
    'SystemCoolingPolicy' : [ 0x128, ['unsigned long']],
    'MediaBufferingEngaged' : [ 0x12c, ['unsigned char']],
    'OffloadedAudio' : [ 0x12d, ['unsigned char']],
    'NonOffloadedAudio' : [ 0x12e, ['unsigned char']],
    'FullscreenVideoPlayback' : [ 0x12f, ['unsigned char']],
    'EsBatteryThreshold' : [ 0x130, ['unsigned long']],
    'EsUserAwaySetting' : [ 0x134, ['unsigned char']],
    'WiFiInStandby' : [ 0x138, ['unsigned long']],
} ],
  '_CM_INDEX_HINT_BLOCK' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'HashKey' : [ 0x4, ['array', 1, ['unsigned long']]],
} ],
  '_TOKEN_CONTROL' : [ 0x28, {
    'TokenId' : [ 0x0, ['_LUID']],
    'AuthenticationId' : [ 0x8, ['_LUID']],
    'ModifiedId' : [ 0x10, ['_LUID']],
    'TokenSource' : [ 0x18, ['_TOKEN_SOURCE']],
} ],
  '_DEFERRED_WRITE' : [ 0x24, {
    'NodeTypeCode' : [ 0x0, ['short']],
    'NodeByteSize' : [ 0x2, ['short']],
    'FileObject' : [ 0x4, ['pointer', ['_FILE_OBJECT']]],
    'BytesToWrite' : [ 0x8, ['unsigned long']],
    'DeferredWriteLinks' : [ 0xc, ['_LIST_ENTRY']],
    'Event' : [ 0x14, ['pointer', ['_KEVENT']]],
    'PostRoutine' : [ 0x18, ['pointer', ['void']]],
    'Context1' : [ 0x1c, ['pointer', ['void']]],
    'Context2' : [ 0x20, ['pointer', ['void']]],
} ],
  '__unnamed_28a5' : [ 0x4, {
    'DeviceNumber' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 5, native_type='unsigned long')]],
    'FunctionNumber' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 8, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_28a7' : [ 0x4, {
    'bits' : [ 0x0, ['__unnamed_28a5']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_WHEA_PCI_SLOT_NUMBER' : [ 0x4, {
    'u' : [ 0x0, ['__unnamed_28a7']],
} ],
  '_MI_RESAVAIL_FAILURES' : [ 0x8, {
    'Wrap' : [ 0x0, ['unsigned long']],
    'NoCharge' : [ 0x4, ['unsigned long']],
} ],
  '_MI_IO_PAGE_STATE' : [ 0x34, {
    'IoPfnLock' : [ 0x0, ['unsigned long']],
    'IoPfnRoot' : [ 0x4, ['array', 3, ['_RTL_AVL_TREE']]],
    'UnusedCachedMaps' : [ 0x10, ['_LIST_ENTRY']],
    'OldestCacheFlushTimeStamp' : [ 0x18, ['unsigned long']],
    'IoCacheStats' : [ 0x1c, ['_MI_IO_CACHE_STATS']],
} ],
  '_ARBITER_ORDERING_LIST' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned short']],
    'Maximum' : [ 0x2, ['unsigned short']],
    'Orderings' : [ 0x4, ['pointer', ['_ARBITER_ORDERING']]],
} ],
  '_VF_AVL_TABLE' : [ 0x80, {
    'RtlTable' : [ 0x0, ['_RTL_AVL_TABLE']],
    'ReservedNode' : [ 0x38, ['pointer', ['_VF_AVL_TREE_NODE']]],
    'NodeToFree' : [ 0x3c, ['pointer', ['void']]],
    'Lock' : [ 0x40, ['long']],
} ],
  '_XPF_MC_BANK_FLAGS' : [ 0x1, {
    'ClearOnInitializationRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'ControlDataRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
    'AsUCHAR' : [ 0x0, ['unsigned char']],
} ],
  '_TOKEN_AUDIT_POLICY' : [ 0x1e, {
    'PerUserPolicy' : [ 0x0, ['array', 30, ['unsigned char']]],
} ],
  '_TRIAGE_POP_FX_DEVICE' : [ 0x20, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x8, ['pointer', ['_IRP']]],
    'IrpData' : [ 0xc, ['pointer', ['_TRIAGE_POP_IRP_DATA']]],
    'Status' : [ 0x10, ['long']],
    'PowerReqCall' : [ 0x14, ['long']],
    'PowerNotReqCall' : [ 0x18, ['long']],
    'DeviceNode' : [ 0x1c, ['pointer', ['_TRIAGE_DEVICE_NODE']]],
} ],
  '__unnamed_28c3' : [ 0x8, {
    'EndingOffset' : [ 0x0, ['pointer', ['_LARGE_INTEGER']]],
    'ResourceToRelease' : [ 0x4, ['pointer', ['pointer', ['_ERESOURCE']]]],
} ],
  '__unnamed_28c5' : [ 0x4, {
    'ResourceToRelease' : [ 0x0, ['pointer', ['_ERESOURCE']]],
} ],
  '__unnamed_28cb' : [ 0xc, {
    'SyncType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'SyncTypeOther', 1: 'SyncTypeCreateSection'})]],
    'PageProtection' : [ 0x4, ['unsigned long']],
    'OutputInformation' : [ 0x8, ['pointer', ['_FS_FILTER_SECTION_SYNC_OUTPUT']]],
} ],
  '__unnamed_28cf' : [ 0x8, {
    'NotificationType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'NotifyTypeCreate', 1: 'NotifyTypeRetired'})]],
    'SafeToRecurse' : [ 0x4, ['unsigned char']],
} ],
  '__unnamed_28d1' : [ 0x14, {
    'Argument1' : [ 0x0, ['pointer', ['void']]],
    'Argument2' : [ 0x4, ['pointer', ['void']]],
    'Argument3' : [ 0x8, ['pointer', ['void']]],
    'Argument4' : [ 0xc, ['pointer', ['void']]],
    'Argument5' : [ 0x10, ['pointer', ['void']]],
} ],
  '_FS_FILTER_PARAMETERS' : [ 0x14, {
    'AcquireForModifiedPageWriter' : [ 0x0, ['__unnamed_28c3']],
    'ReleaseForModifiedPageWriter' : [ 0x0, ['__unnamed_28c5']],
    'AcquireForSectionSynchronization' : [ 0x0, ['__unnamed_28cb']],
    'NotifyStreamFileObject' : [ 0x0, ['__unnamed_28cf']],
    'Others' : [ 0x0, ['__unnamed_28d1']],
} ],
  '_MI_SESSION_DRIVER_UNLOAD' : [ 0x4, {
    'Function' : [ 0x0, ['pointer', ['void']]],
    'FunctionValue' : [ 0x0, ['unsigned long']],
} ],
  '_PPM_SELECTION_STATISTICS' : [ 0x78, {
    'SelectedCount' : [ 0x0, ['unsigned long long']],
    'VetoCount' : [ 0x8, ['unsigned long long']],
    'PreVetoCount' : [ 0x10, ['unsigned long long']],
    'WrongProcessorCount' : [ 0x18, ['unsigned long long']],
    'LatencyCount' : [ 0x20, ['unsigned long long']],
    'IdleDurationCount' : [ 0x28, ['unsigned long long']],
    'DeviceDependencyCount' : [ 0x30, ['unsigned long long']],
    'ProcessorDependencyCount' : [ 0x38, ['unsigned long long']],
    'PlatformOnlyCount' : [ 0x40, ['unsigned long long']],
    'InterruptibleCount' : [ 0x48, ['unsigned long long']],
    'LegacyOverrideCount' : [ 0x50, ['unsigned long long']],
    'CstateCheckCount' : [ 0x58, ['unsigned long long']],
    'NoCStateCount' : [ 0x60, ['unsigned long long']],
    'CoordinatedDependencyCount' : [ 0x68, ['unsigned long long']],
    'PreVetoAccounting' : [ 0x70, ['pointer', ['_PPM_VETO_ACCOUNTING']]],
} ],
  '_LDR_SERVICE_TAG_RECORD' : [ 0x8, {
    'Next' : [ 0x0, ['pointer', ['_LDR_SERVICE_TAG_RECORD']]],
    'ServiceTag' : [ 0x4, ['unsigned long']],
} ],
  '_COMPRESSED_DATA_INFO' : [ 0xc, {
    'CompressionFormatAndEngine' : [ 0x0, ['unsigned short']],
    'CompressionUnitShift' : [ 0x2, ['unsigned char']],
    'ChunkShift' : [ 0x3, ['unsigned char']],
    'ClusterShift' : [ 0x4, ['unsigned char']],
    'Reserved' : [ 0x5, ['unsigned char']],
    'NumberOfChunks' : [ 0x6, ['unsigned short']],
    'CompressedChunkSizes' : [ 0x8, ['array', 1, ['unsigned long']]],
} ],
  '_MI_PAGE_COMBINE_STATISTICS' : [ 0x28, {
    'PagesScannedActive' : [ 0x0, ['unsigned long long']],
    'PagesScannedStandby' : [ 0x8, ['unsigned long long']],
    'PagesCombined' : [ 0x10, ['unsigned long long']],
    'CombineScanCount' : [ 0x18, ['unsigned long']],
    'CombinedBlocksInUse' : [ 0x1c, ['long']],
    'SumCombinedBlocksReferenceCount' : [ 0x20, ['long']],
} ],
  '_THERMAL_COOLING_INTERFACE' : [ 0x1c, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'Context' : [ 0x4, ['pointer', ['void']]],
    'InterfaceReference' : [ 0x8, ['pointer', ['void']]],
    'InterfaceDereference' : [ 0xc, ['pointer', ['void']]],
    'Flags' : [ 0x10, ['unsigned long']],
    'ActiveCooling' : [ 0x14, ['pointer', ['void']]],
    'PassiveCooling' : [ 0x18, ['pointer', ['void']]],
} ],
  '_HIVE_WAIT_PACKET' : [ 0x18, {
    'WakeEvent' : [ 0x0, ['_KEVENT']],
    'Status' : [ 0x10, ['long']],
    'Next' : [ 0x14, ['pointer', ['_HIVE_WAIT_PACKET']]],
} ],
  '_PROC_PERF_CHECK' : [ 0xc0, {
    'LastActive' : [ 0x0, ['unsigned long long']],
    'LastTime' : [ 0x8, ['unsigned long long']],
    'LastStall' : [ 0x10, ['unsigned long long']],
    'Snap' : [ 0x18, ['_PROC_PERF_CHECK_SNAP']],
    'TempSnap' : [ 0x68, ['_PROC_PERF_CHECK_SNAP']],
    'TaggedThreadPercent' : [ 0xb8, ['array', 2, ['unsigned char']]],
    'Class0FloorPerfSelection' : [ 0xba, ['unsigned char']],
    'Class1MinimumPerfSelection' : [ 0xbb, ['unsigned char']],
} ],
  '__unnamed_28ea' : [ 0x4, {
    'PollInterval' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_28ec' : [ 0x18, {
    'PollInterval' : [ 0x0, ['unsigned long']],
    'Vector' : [ 0x4, ['unsigned long']],
    'SwitchToPollingThreshold' : [ 0x8, ['unsigned long']],
    'SwitchToPollingWindow' : [ 0xc, ['unsigned long']],
    'ErrorThreshold' : [ 0x10, ['unsigned long']],
    'ErrorThresholdWindow' : [ 0x14, ['unsigned long']],
} ],
  '__unnamed_28ee' : [ 0x18, {
    'Polled' : [ 0x0, ['__unnamed_28ea']],
    'Interrupt' : [ 0x0, ['__unnamed_28ec']],
    'LocalInterrupt' : [ 0x0, ['__unnamed_28ec']],
    'Sci' : [ 0x0, ['__unnamed_28ec']],
    'Nmi' : [ 0x0, ['__unnamed_28ec']],
} ],
  '_WHEA_NOTIFICATION_DESCRIPTOR' : [ 0x1c, {
    'Type' : [ 0x0, ['unsigned char']],
    'Length' : [ 0x1, ['unsigned char']],
    'Flags' : [ 0x2, ['_WHEA_NOTIFICATION_FLAGS']],
    'u' : [ 0x4, ['__unnamed_28ee']],
} ],
  '_POP_HIBER_CONTEXT' : [ 0x140, {
    'Reset' : [ 0x0, ['unsigned char']],
    'HiberFlags' : [ 0x1, ['unsigned char']],
    'WroteHiberFile' : [ 0x2, ['unsigned char']],
    'VerifyKernelPhaseOnResume' : [ 0x3, ['unsigned char']],
    'KernelPhaseVerificationActive' : [ 0x4, ['unsigned char']],
    'InitializationFinished' : [ 0x5, ['unsigned char']],
    'NextTableLockHeld' : [ 0x8, ['long']],
    'BootPhaseFinishedBarrier' : [ 0xc, ['long']],
    'KernelResumeFinishedBarrier' : [ 0x10, ['long']],
    'HvCaptureReadyBarrier' : [ 0x14, ['long']],
    'HvCaptureCompletedBarrier' : [ 0x18, ['long']],
    'MapFrozen' : [ 0x1c, ['unsigned char']],
    'DiscardMap' : [ 0x20, ['_RTL_BITMAP']],
    'KernelPhaseMap' : [ 0x20, ['_RTL_BITMAP']],
    'BootPhaseMap' : [ 0x28, ['_RTL_BITMAP']],
    'ClonedRanges' : [ 0x30, ['_LIST_ENTRY']],
    'ClonedRangeCount' : [ 0x38, ['unsigned long']],
    'ClonedPageCount' : [ 0x40, ['unsigned long long']],
    'CurrentMap' : [ 0x48, ['pointer', ['_RTL_BITMAP']]],
    'NextCloneRange' : [ 0x4c, ['pointer', ['_LIST_ENTRY']]],
    'NextPreserve' : [ 0x50, ['unsigned long']],
    'LoaderMdl' : [ 0x54, ['pointer', ['_MDL']]],
    'AllocatedMdl' : [ 0x58, ['pointer', ['_MDL']]],
    'PagesOut' : [ 0x60, ['unsigned long long']],
    'IoPages' : [ 0x68, ['pointer', ['void']]],
    'IoPagesCount' : [ 0x6c, ['unsigned long']],
    'CurrentMcb' : [ 0x70, ['pointer', ['void']]],
    'DumpStack' : [ 0x74, ['pointer', ['_DUMP_STACK_CONTEXT']]],
    'WakeState' : [ 0x78, ['pointer', ['_KPROCESSOR_STATE']]],
    'IoProgress' : [ 0x7c, ['unsigned long']],
    'Status' : [ 0x80, ['long']],
    'GraphicsProc' : [ 0x84, ['unsigned long']],
    'MemoryImage' : [ 0x88, ['pointer', ['PO_MEMORY_IMAGE']]],
    'PerformanceStats' : [ 0x8c, ['pointer', ['unsigned long']]],
    'BootLoaderLogMdl' : [ 0x90, ['pointer', ['_MDL']]],
    'SiLogOffset' : [ 0x94, ['unsigned long']],
    'FirmwareRuntimeInformationMdl' : [ 0x98, ['pointer', ['_MDL']]],
    'FirmwareRuntimeInformationVa' : [ 0x9c, ['pointer', ['void']]],
    'ResumeContext' : [ 0xa0, ['pointer', ['void']]],
    'ResumeContextPages' : [ 0xa4, ['unsigned long']],
    'ProcessorCount' : [ 0xa8, ['unsigned long']],
    'ProcessorContext' : [ 0xac, ['pointer', ['_POP_PER_PROCESSOR_CONTEXT']]],
    'ProdConsBuffer' : [ 0xb0, ['pointer', ['unsigned char']]],
    'ProdConsSize' : [ 0xb4, ['unsigned long']],
    'MaxDataPages' : [ 0xb8, ['unsigned long']],
    'ExtraBuffer' : [ 0xbc, ['pointer', ['void']]],
    'ExtraBufferSize' : [ 0xc0, ['unsigned long']],
    'ExtraMapVa' : [ 0xc4, ['pointer', ['void']]],
    'BitlockerKeyPFN' : [ 0xc8, ['unsigned long']],
    'IoInfo' : [ 0xd0, ['_POP_IO_INFO']],
    'IoChecksums' : [ 0x130, ['pointer', ['unsigned short']]],
    'IoChecksumsSize' : [ 0x134, ['unsigned long']],
    'HardwareConfigurationSignature' : [ 0x138, ['unsigned long']],
} ],
  '_OBJECT_REF_TRACE' : [ 0x40, {
    'StackTrace' : [ 0x0, ['array', 16, ['pointer', ['void']]]],
} ],
  '_CVDD' : [ 0x1c, {
    'Signature' : [ 0x0, ['unsigned long']],
    'NB10' : [ 0x0, ['_NB10']],
    'RsDs' : [ 0x0, ['_RSDS']],
} ],
  '_OBJECT_NAME_INFORMATION' : [ 0x8, {
    'Name' : [ 0x0, ['_UNICODE_STRING']],
} ],
  '_WHEA_AER_BRIDGE_DESCRIPTOR' : [ 0x2c, {
    'Type' : [ 0x0, ['unsigned short']],
    'Enabled' : [ 0x2, ['unsigned char']],
    'Reserved' : [ 0x3, ['unsigned char']],
    'BusNumber' : [ 0x4, ['unsigned long']],
    'Slot' : [ 0x8, ['_WHEA_PCI_SLOT_NUMBER']],
    'DeviceControl' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['_AER_BRIDGE_DESCRIPTOR_FLAGS']],
    'UncorrectableErrorMask' : [ 0x10, ['unsigned long']],
    'UncorrectableErrorSeverity' : [ 0x14, ['unsigned long']],
    'CorrectableErrorMask' : [ 0x18, ['unsigned long']],
    'AdvancedCapsAndControl' : [ 0x1c, ['unsigned long']],
    'SecondaryUncorrectableErrorMask' : [ 0x20, ['unsigned long']],
    'SecondaryUncorrectableErrorSev' : [ 0x24, ['unsigned long']],
    'SecondaryCapsAndControl' : [ 0x28, ['unsigned long']],
} ],
  '_POP_FX_PERF_INFO' : [ 0x60, {
    'Component' : [ 0x0, ['pointer', ['_POP_FX_COMPONENT']]],
    'CompletedEvent' : [ 0x4, ['_KEVENT']],
    'ComponentPerfState' : [ 0x14, ['pointer', ['void']]],
    'Flags' : [ 0x18, ['_POP_FX_PERF_FLAGS']],
    'LastChange' : [ 0x1c, ['pointer', ['_PO_FX_PERF_STATE_CHANGE']]],
    'LastChangeCount' : [ 0x20, ['unsigned long']],
    'LastChangeStamp' : [ 0x28, ['unsigned long long']],
    'LastChangeNominal' : [ 0x30, ['unsigned char']],
    'PepRegistered' : [ 0x31, ['unsigned char']],
    'QueryOnIdleStates' : [ 0x32, ['unsigned char']],
    'RequestDriverContext' : [ 0x34, ['pointer', ['void']]],
    'WorkOrder' : [ 0x38, ['_POP_FX_WORK_ORDER']],
    'SetsCount' : [ 0x54, ['unsigned long']],
    'Sets' : [ 0x58, ['pointer', ['_POP_FX_PERF_SET']]],
} ],
  '_HAL_CHANNEL_MEMORY_RANGES' : [ 0xc, {
    'PageFrameIndex' : [ 0x0, ['unsigned long']],
    'MpnId' : [ 0x4, ['unsigned short']],
    'Node' : [ 0x6, ['unsigned short']],
    'Channel' : [ 0x8, ['unsigned short']],
    'IsPowerManageable' : [ 0xa, ['unsigned char']],
    'DeepPowerState' : [ 0xb, ['unsigned char']],
} ],
  '_PCW_COUNTER_INFORMATION' : [ 0x10, {
    'CounterMask' : [ 0x0, ['unsigned long long']],
    'InstanceMask' : [ 0x8, ['pointer', ['_UNICODE_STRING']]],
} ],
  '_DUMP_STACK_CONTEXT' : [ 0x100, {
    'Init' : [ 0x0, ['_DUMP_INITIALIZATION_CONTEXT']],
    'PartitionOffset' : [ 0xc0, ['_LARGE_INTEGER']],
    'DumpPointers' : [ 0xc8, ['pointer', ['void']]],
    'PointersLength' : [ 0xcc, ['unsigned long']],
    'ModulePrefix' : [ 0xd0, ['pointer', ['unsigned short']]],
    'DriverList' : [ 0xd4, ['_LIST_ENTRY']],
    'InitMsg' : [ 0xdc, ['_STRING']],
    'ProgMsg' : [ 0xe4, ['_STRING']],
    'DoneMsg' : [ 0xec, ['_STRING']],
    'FileObject' : [ 0xf4, ['pointer', ['void']]],
    'UsageType' : [ 0xf8, ['Enumeration', dict(target = 'long', choices = {0: 'DeviceUsageTypeUndefined', 1: 'DeviceUsageTypePaging', 2: 'DeviceUsageTypeHibernation', 3: 'DeviceUsageTypeDumpFile', 4: 'DeviceUsageTypeBoot', 5: 'DeviceUsageTypePostDisplay'})]],
} ],
  '_PAE_PAGEINFO' : [ 0x10, {
    'ListHead' : [ 0x0, ['_LIST_ENTRY']],
    'PageFrameNumber' : [ 0x8, ['unsigned long']],
    'EntriesInUse' : [ 0xc, ['unsigned long']],
} ],
  '_FILE_STANDARD_INFORMATION' : [ 0x18, {
    'AllocationSize' : [ 0x0, ['_LARGE_INTEGER']],
    'EndOfFile' : [ 0x8, ['_LARGE_INTEGER']],
    'NumberOfLinks' : [ 0x10, ['unsigned long']],
    'DeletePending' : [ 0x14, ['unsigned char']],
    'Directory' : [ 0x15, ['unsigned char']],
} ],
  '_ETW_FILTER_STRING_TOKEN' : [ 0xc, {
    'Count' : [ 0x0, ['unsigned short']],
    'Tokens' : [ 0x4, ['array', 1, ['_ETW_FILTER_STRING_TOKEN_ELEMENT']]],
} ],
  '_POP_SHUTDOWN_BUG_CHECK' : [ 0x24, {
    'InitiatingThread' : [ 0x0, ['pointer', ['_ETHREAD']]],
    'InitiatingProcess' : [ 0x4, ['pointer', ['_EPROCESS']]],
    'ThreadId' : [ 0x8, ['pointer', ['void']]],
    'ProcessId' : [ 0xc, ['pointer', ['void']]],
    'Code' : [ 0x10, ['unsigned long']],
    'Parameter1' : [ 0x14, ['unsigned long']],
    'Parameter2' : [ 0x18, ['unsigned long']],
    'Parameter3' : [ 0x1c, ['unsigned long']],
    'Parameter4' : [ 0x20, ['unsigned long']],
} ],
  '_NB10' : [ 0x14, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Offset' : [ 0x4, ['unsigned long']],
    'TimeStamp' : [ 0x8, ['unsigned long']],
    'Age' : [ 0xc, ['unsigned long']],
    'PdbName' : [ 0x10, ['array', 1, ['unsigned char']]],
} ],
  '_PCW_MASK_INFORMATION' : [ 0x20, {
    'CounterMask' : [ 0x0, ['unsigned long long']],
    'InstanceMask' : [ 0x8, ['pointer', ['_UNICODE_STRING']]],
    'InstanceId' : [ 0xc, ['unsigned long']],
    'CollectMultiple' : [ 0x10, ['unsigned char']],
    'Buffer' : [ 0x14, ['pointer', ['_PCW_BUFFER']]],
    'CancelEvent' : [ 0x18, ['pointer', ['_KEVENT']]],
} ],
  '_SECURITY_DESCRIPTOR_RELATIVE' : [ 0x14, {
    'Revision' : [ 0x0, ['unsigned char']],
    'Sbz1' : [ 0x1, ['unsigned char']],
    'Control' : [ 0x2, ['unsigned short']],
    'Owner' : [ 0x4, ['unsigned long']],
    'Group' : [ 0x8, ['unsigned long']],
    'Sacl' : [ 0xc, ['unsigned long']],
    'Dacl' : [ 0x10, ['unsigned long']],
} ],
  '_FS_FILTER_SECTION_SYNC_OUTPUT' : [ 0x10, {
    'StructureSize' : [ 0x0, ['unsigned long']],
    'SizeReturned' : [ 0x4, ['unsigned long']],
    'Flags' : [ 0x8, ['unsigned long']],
    'DesiredReadAlignment' : [ 0xc, ['unsigned long']],
} ],
  '_HVIEW_MAP_PIN_LOG_ENTRY' : [ 0x30, {
    'ViewOffset' : [ 0x0, ['unsigned long']],
    'Pinned' : [ 0x4, ['unsigned char']],
    'PinMask' : [ 0x8, ['unsigned long long']],
    'Thread' : [ 0x10, ['pointer', ['_KTHREAD']]],
    'Stack' : [ 0x14, ['array', 6, ['pointer', ['void']]]],
} ],
  '__unnamed_292e' : [ 0x10, {
    'TestAllocation' : [ 0x0, ['_ARBITER_TEST_ALLOCATION_PARAMETERS']],
    'RetestAllocation' : [ 0x0, ['_ARBITER_RETEST_ALLOCATION_PARAMETERS']],
    'BootAllocation' : [ 0x0, ['_ARBITER_BOOT_ALLOCATION_PARAMETERS']],
    'QueryAllocatedResources' : [ 0x0, ['_ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS']],
    'QueryConflict' : [ 0x0, ['_ARBITER_QUERY_CONFLICT_PARAMETERS']],
    'QueryArbitrate' : [ 0x0, ['_ARBITER_QUERY_ARBITRATE_PARAMETERS']],
    'AddReserved' : [ 0x0, ['_ARBITER_ADD_RESERVED_PARAMETERS']],
} ],
  '_ARBITER_PARAMETERS' : [ 0x10, {
    'Parameters' : [ 0x0, ['__unnamed_292e']],
} ],
  '__unnamed_2932' : [ 0x8, {
    'idxRecord' : [ 0x0, ['unsigned long']],
    'cidContainer' : [ 0x4, ['unsigned long']],
} ],
  '_CLS_LSN' : [ 0x8, {
    'offset' : [ 0x0, ['__unnamed_2932']],
    'ullOffset' : [ 0x0, ['unsigned long long']],
} ],
  '_MI_SUBSECTION_WAIT_BLOCK' : [ 0x14, {
    'Next' : [ 0x0, ['pointer', ['_MI_SUBSECTION_WAIT_BLOCK']]],
    'Gate' : [ 0x4, ['_KGATE']],
} ],
  'POWER_ACTION_POLICY' : [ 0xc, {
    'Action' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject', 8: 'PowerActionDisplayOff'})]],
    'Flags' : [ 0x4, ['unsigned long']],
    'EventCode' : [ 0x8, ['unsigned long']],
} ],
  '_KSCHEDULING_GROUP_POLICY' : [ 0x8, {
    'Value' : [ 0x0, ['unsigned long']],
    'Weight' : [ 0x0, ['unsigned short']],
    'MinRate' : [ 0x0, ['unsigned short']],
    'MaxRate' : [ 0x2, ['unsigned short']],
    'AllFlags' : [ 0x4, ['unsigned long']],
    'Type' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Disabled' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Spare1' : [ 0x4, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
} ],
  '_RSDS' : [ 0x1c, {
    'Signature' : [ 0x0, ['unsigned long']],
    'Guid' : [ 0x4, ['_GUID']],
    'Age' : [ 0x14, ['unsigned long']],
    'PdbName' : [ 0x18, ['array', 1, ['unsigned char']]],
} ],
  'PO_MEMORY_IMAGE' : [ 0x310, {
    'Signature' : [ 0x0, ['unsigned long']],
    'ImageType' : [ 0x4, ['unsigned long']],
    'CheckSum' : [ 0x8, ['unsigned long']],
    'LengthSelf' : [ 0xc, ['unsigned long']],
    'PageSelf' : [ 0x10, ['unsigned long']],
    'PageSize' : [ 0x14, ['unsigned long']],
    'SystemTime' : [ 0x18, ['_LARGE_INTEGER']],
    'InterruptTime' : [ 0x20, ['unsigned long long']],
    'FeatureFlags' : [ 0x28, ['unsigned long long']],
    'HiberFlags' : [ 0x30, ['unsigned char']],
    'spare' : [ 0x31, ['array', 3, ['unsigned char']]],
    'NoHiberPtes' : [ 0x34, ['unsigned long']],
    'HiberVa' : [ 0x38, ['unsigned long']],
    'NoFreePages' : [ 0x3c, ['unsigned long']],
    'FreeMapCheck' : [ 0x40, ['unsigned long']],
    'WakeCheck' : [ 0x44, ['unsigned long']],
    'NumPagesForLoader' : [ 0x48, ['unsigned long long']],
    'FirstBootRestorePage' : [ 0x50, ['unsigned long']],
    'FirstKernelRestorePage' : [ 0x54, ['unsigned long']],
    'FirstChecksumRestorePage' : [ 0x58, ['unsigned long']],
    'NoChecksumEntries' : [ 0x60, ['unsigned long long']],
    'PerfInfo' : [ 0x68, ['_PO_HIBER_PERF']],
    'FirmwareRuntimeInformationPages' : [ 0x248, ['unsigned long']],
    'FirmwareRuntimeInformation' : [ 0x24c, ['array', 1, ['unsigned long']]],
    'SiLogOffset' : [ 0x250, ['unsigned long']],
    'NoBootLoaderLogPages' : [ 0x254, ['unsigned long']],
    'BootLoaderLogPages' : [ 0x258, ['array', 24, ['unsigned long']]],
    'NotUsed' : [ 0x2b8, ['unsigned long']],
    'ResumeContextCheck' : [ 0x2bc, ['unsigned long']],
    'ResumeContextPages' : [ 0x2c0, ['unsigned long']],
    'Hiberboot' : [ 0x2c4, ['unsigned char']],
    'HvCr3' : [ 0x2c8, ['unsigned long long']],
    'HvEntryPoint' : [ 0x2d0, ['unsigned long long']],
    'HvReservedTransitionAddress' : [ 0x2d8, ['unsigned long long']],
    'HvReservedTransitionAddressSize' : [ 0x2e0, ['unsigned long long']],
    'BootFlags' : [ 0x2e8, ['unsigned long long']],
    'HalEntryPointPhysical' : [ 0x2f0, ['unsigned long long']],
    'HighestPhysicalPage' : [ 0x2f8, ['unsigned long']],
    'BitlockerKeyPfns' : [ 0x2fc, ['array', 4, ['unsigned long']]],
    'HardwareSignature' : [ 0x30c, ['unsigned long']],
} ],
  'BATTERY_REPORTING_SCALE' : [ 0x8, {
    'Granularity' : [ 0x0, ['unsigned long']],
    'Capacity' : [ 0x4, ['unsigned long']],
} ],
  '_RTL_ATOM_TABLE_REFERENCE' : [ 0x10, {
    'LowBoxList' : [ 0x0, ['_LIST_ENTRY']],
    'LowBoxID' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['unsigned short']],
    'Flags' : [ 0xe, ['unsigned short']],
} ],
  '_CURDIR' : [ 0xc, {
    'DosPath' : [ 0x0, ['_UNICODE_STRING']],
    'Handle' : [ 0x8, ['pointer', ['void']]],
} ],
  '_PO_HIBER_PERF' : [ 0x1e0, {
    'HiberIoTicks' : [ 0x0, ['unsigned long long']],
    'HiberIoCpuTicks' : [ 0x8, ['unsigned long long']],
    'HiberInitTicks' : [ 0x10, ['unsigned long long']],
    'HiberHiberFileTicks' : [ 0x18, ['unsigned long long']],
    'HiberCompressTicks' : [ 0x20, ['unsigned long long']],
    'HiberSharedBufferTicks' : [ 0x28, ['unsigned long long']],
    'HiberChecksumTicks' : [ 0x30, ['unsigned long long']],
    'HiberChecksumIoTicks' : [ 0x38, ['unsigned long long']],
    'TotalHibernateTime' : [ 0x40, ['_LARGE_INTEGER']],
    'POSTTime' : [ 0x48, ['unsigned long']],
    'ResumeBootMgrTime' : [ 0x4c, ['unsigned long']],
    'BootmgrUserInputTime' : [ 0x50, ['unsigned long']],
    'ResumeAppTicks' : [ 0x58, ['unsigned long long']],
    'ResumeAppStartTimestamp' : [ 0x60, ['unsigned long long']],
    'ResumeLibraryInitTicks' : [ 0x68, ['unsigned long long']],
    'ResumeInitTicks' : [ 0x70, ['unsigned long long']],
    'ResumeRestoreImageStartTimestamp' : [ 0x78, ['unsigned long long']],
    'ResumeHiberFileTicks' : [ 0x80, ['unsigned long long']],
    'ResumeIoTicks' : [ 0x88, ['unsigned long long']],
    'ResumeDecompressTicks' : [ 0x90, ['unsigned long long']],
    'ResumeAllocateTicks' : [ 0x98, ['unsigned long long']],
    'ResumeUserInOutTicks' : [ 0xa0, ['unsigned long long']],
    'ResumeMapTicks' : [ 0xa8, ['unsigned long long']],
    'ResumeUnmapTicks' : [ 0xb0, ['unsigned long long']],
    'ResumeChecksumTicks' : [ 0xb8, ['unsigned long long']],
    'ResumeChecksumIoTicks' : [ 0xc0, ['unsigned long long']],
    'ResumeKernelSwitchTimestamp' : [ 0xc8, ['unsigned long long']],
    'WriteLogDataTimestamp' : [ 0xd0, ['unsigned long long']],
    'KernelReturnFromHandler' : [ 0xd8, ['unsigned long long']],
    'TimeStampCounterAtSwitchTime' : [ 0xe0, ['unsigned long long']],
    'HalTscOffset' : [ 0xe8, ['unsigned long long']],
    'HvlTscOffset' : [ 0xf0, ['unsigned long long']],
    'SleeperThreadEnd' : [ 0xf8, ['unsigned long long']],
    'KernelReturnSystemPowerStateTimestamp' : [ 0x100, ['unsigned long long']],
    'IoBoundedness' : [ 0x108, ['unsigned long long']],
    'KernelDecompressTicks' : [ 0x110, ['unsigned long long']],
    'KernelIoTicks' : [ 0x118, ['unsigned long long']],
    'KernelCopyTicks' : [ 0x120, ['unsigned long long']],
    'ReadCheckCount' : [ 0x128, ['unsigned long long']],
    'KernelInitTicks' : [ 0x130, ['unsigned long long']],
    'KernelResumeHiberFileTicks' : [ 0x138, ['unsigned long long']],
    'KernelIoCpuTicks' : [ 0x140, ['unsigned long long']],
    'KernelSharedBufferTicks' : [ 0x148, ['unsigned long long']],
    'KernelAnimationTicks' : [ 0x150, ['unsigned long long']],
    'KernelChecksumTicks' : [ 0x158, ['unsigned long long']],
    'KernelChecksumIoTicks' : [ 0x160, ['unsigned long long']],
    'AnimationStart' : [ 0x168, ['_LARGE_INTEGER']],
    'AnimationStop' : [ 0x170, ['_LARGE_INTEGER']],
    'DeviceResumeTime' : [ 0x178, ['unsigned long']],
    'SecurePagesProcessed' : [ 0x180, ['unsigned long long']],
    'BootPagesProcessed' : [ 0x188, ['unsigned long long']],
    'KernelPagesProcessed' : [ 0x190, ['unsigned long long']],
    'BootBytesWritten' : [ 0x198, ['unsigned long long']],
    'KernelBytesWritten' : [ 0x1a0, ['unsigned long long']],
    'BootPagesWritten' : [ 0x1a8, ['unsigned long long']],
    'KernelPagesWritten' : [ 0x1b0, ['unsigned long long']],
    'BytesWritten' : [ 0x1b8, ['unsigned long long']],
    'PagesWritten' : [ 0x1c0, ['unsigned long']],
    'FileRuns' : [ 0x1c4, ['unsigned long']],
    'NoMultiStageResumeReason' : [ 0x1c8, ['unsigned long']],
    'MaxHuffRatio' : [ 0x1cc, ['unsigned long']],
    'AdjustedTotalResumeTime' : [ 0x1d0, ['unsigned long long']],
    'ResumeCompleteTimestamp' : [ 0x1d8, ['unsigned long long']],
} ],
  '_MI_QUEUED_DEADSTACK_WORKITEM' : [ 0x14, {
    'WorkItem' : [ 0x0, ['_WORK_QUEUE_ITEM']],
    'Active' : [ 0x10, ['long']],
} ],
  '_POP_FX_PROVIDER' : [ 0x8, {
    'Index' : [ 0x0, ['unsigned long']],
    'Activating' : [ 0x4, ['unsigned char']],
} ],
  '_RTL_BALANCED_LINKS' : [ 0x10, {
    'Parent' : [ 0x0, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'LeftChild' : [ 0x4, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'RightChild' : [ 0x8, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'Balance' : [ 0xc, ['unsigned char']],
    'Reserved' : [ 0xd, ['array', 3, ['unsigned char']]],
} ],
  '_FREE_DISPLAY' : [ 0x10, {
    'RealVectorSize' : [ 0x0, ['unsigned long']],
    'Hint' : [ 0x4, ['unsigned long']],
    'Display' : [ 0x8, ['_RTL_BITMAP']],
} ],
  '_MMINPAGE_SUPPORT_FLOW_THROUGH' : [ 0x1c, {
    'Page' : [ 0x0, ['array', 1, ['unsigned long']]],
    'InitialInPageSupport' : [ 0x4, ['pointer', ['_MMINPAGE_SUPPORT']]],
    'PagingFile' : [ 0x8, ['pointer', ['_MMPAGING_FILE']]],
    'PageFileOffset' : [ 0xc, ['unsigned long']],
    'Node' : [ 0x10, ['_RTL_BALANCED_NODE']],
} ],
  '_POP_PER_PROCESSOR_CONTEXT' : [ 0x70, {
    'UncompressedData' : [ 0x0, ['pointer', ['unsigned char']]],
    'MappingVa' : [ 0x4, ['pointer', ['void']]],
    'XpressEncodeWorkspace' : [ 0x8, ['pointer', ['void']]],
    'CompressedDataBuffer' : [ 0xc, ['pointer', ['unsigned char']]],
    'CopyTicks' : [ 0x10, ['unsigned long long']],
    'CompressTicks' : [ 0x18, ['unsigned long long']],
    'BytesCopied' : [ 0x20, ['unsigned long long']],
    'PagesProcessed' : [ 0x28, ['unsigned long long']],
    'DecompressTicks' : [ 0x30, ['unsigned long long']],
    'ResumeCopyTicks' : [ 0x38, ['unsigned long long']],
    'SharedBufferTicks' : [ 0x40, ['unsigned long long']],
    'DecompressTicksByMethod' : [ 0x48, ['array', 2, ['unsigned long long']]],
    'DecompressSizeByMethod' : [ 0x58, ['array', 2, ['unsigned long long']]],
    'CompressCount' : [ 0x68, ['unsigned long']],
    'HuffCompressCount' : [ 0x6c, ['unsigned long']],
} ],
  '_IO_REMOVE_LOCK' : [ 0x18, {
    'Common' : [ 0x0, ['_IO_REMOVE_LOCK_COMMON_BLOCK']],
} ],
  '_POP_IO_INFO' : [ 0x60, {
    'DumpMdl' : [ 0x0, ['pointer', ['_MDL']]],
    'IoStatus' : [ 0x4, ['Enumeration', dict(target = 'long', choices = {0: 'IoReady', 1: 'IoPending', 2: 'IoDone'})]],
    'IoStartCount' : [ 0x8, ['unsigned long long']],
    'IoBytesCompleted' : [ 0x10, ['unsigned long long']],
    'IoBytesInProgress' : [ 0x18, ['unsigned long long']],
    'RequestSize' : [ 0x20, ['unsigned long long']],
    'IoLocation' : [ 0x28, ['_LARGE_INTEGER']],
    'FileOffset' : [ 0x30, ['unsigned long long']],
    'Buffer' : [ 0x38, ['pointer', ['void']]],
    'AsyncCapable' : [ 0x3c, ['unsigned char']],
    'BytesToRead' : [ 0x40, ['unsigned long long']],
    'Pages' : [ 0x48, ['unsigned long']],
    'HighestChecksumIndex' : [ 0x50, ['unsigned long long']],
    'PreviousChecksum' : [ 0x58, ['unsigned short']],
} ],
  '_LDRP_CSLIST' : [ 0x4, {
    'Tail' : [ 0x0, ['pointer', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_NON_PAGED_DEBUG_INFO' : [ 0x20, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Flags' : [ 0x2, ['unsigned short']],
    'Size' : [ 0x4, ['unsigned long']],
    'Machine' : [ 0x8, ['unsigned short']],
    'Characteristics' : [ 0xa, ['unsigned short']],
    'TimeDateStamp' : [ 0xc, ['unsigned long']],
    'CheckSum' : [ 0x10, ['unsigned long']],
    'SizeOfImage' : [ 0x14, ['unsigned long']],
    'ImageBase' : [ 0x18, ['unsigned long long']],
} ],
  '_POP_FX_PERF_SET' : [ 0x20, {
    'PerfSet' : [ 0x0, ['pointer', ['_PO_FX_COMPONENT_PERF_SET']]],
    'CurrentPerf' : [ 0x8, ['unsigned long long']],
    'CurrentPerfStamp' : [ 0x10, ['unsigned long long']],
    'CurrentPerfNominal' : [ 0x18, ['unsigned char']],
} ],
  '_AER_BRIDGE_DESCRIPTOR_FLAGS' : [ 0x2, {
    'UncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'UncorrectableErrorSeverityRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'CorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'AdvancedCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'SecondaryUncorrectableErrorMaskRW' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'SecondaryUncorrectableErrorSevRW' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned short')]],
    'SecondaryCapsAndControlRW' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_MM_SESSION_SPACE_FLAGS' : [ 0x4, {
    'Initialized' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'DeletePending' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'PoolInitialized' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned long')]],
    'DynamicVaInitialized' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned long')]],
    'WsInitialized' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned long')]],
    'PoolDestroyed' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'ObjectInitialized' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'LeakedPoolDeliberately' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Filler' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 32, native_type='unsigned long')]],
} ],
  '_RTL_CRITICAL_SECTION_DEBUG' : [ 0x20, {
    'Type' : [ 0x0, ['unsigned short']],
    'CreatorBackTraceIndex' : [ 0x2, ['unsigned short']],
    'CriticalSection' : [ 0x4, ['pointer', ['_RTL_CRITICAL_SECTION']]],
    'ProcessLocksList' : [ 0x8, ['_LIST_ENTRY']],
    'EntryCount' : [ 0x10, ['unsigned long']],
    'ContentionCount' : [ 0x14, ['unsigned long']],
    'Flags' : [ 0x18, ['unsigned long']],
    'CreatorBackTraceIndexHigh' : [ 0x1c, ['unsigned short']],
    'SpareUSHORT' : [ 0x1e, ['unsigned short']],
} ],
  '__unnamed_296f' : [ 0x8, {
    'Gsiv' : [ 0x0, ['unsigned long']],
    'WakeInterrupt' : [ 0x4, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'ReservedFlags' : [ 0x4, ['BitField', dict(start_bit = 1, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_2971' : [ 0x10, {
    'Address' : [ 0x0, ['_LARGE_INTEGER']],
    'DataPayload' : [ 0x8, ['unsigned long']],
} ],
  '__unnamed_2974' : [ 0x8, {
    'IntrInfo' : [ 0x0, ['_INTERRUPT_HT_INTR_INFO']],
} ],
  '__unnamed_2978' : [ 0x4, {
    'DestinationMode' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: 'ApicDestinationModePhysical', 2: 'ApicDestinationModeLogicalFlat', 3: 'ApicDestinationModeLogicalClustered', 4: 'ApicDestinationModeUnknown'})]],
} ],
  '_INTERRUPT_VECTOR_DATA' : [ 0x50, {
    'Type' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {0: 'InterruptTypeControllerInput', 1: 'InterruptTypeXapicMessage', 2: 'InterruptTypeHypertransport', 3: 'InterruptTypeMessageRequest'})]],
    'Vector' : [ 0x4, ['unsigned long']],
    'Irql' : [ 0x8, ['unsigned char']],
    'Polarity' : [ 0xc, ['Enumeration', dict(target = 'long', choices = {0: 'InterruptPolarityUnknown', 1: 'InterruptRisingEdge', 2: 'InterruptFallingEdge', 3: 'InterruptActiveBothTriggerLow', 4: 'InterruptActiveBothTriggerHigh'})]],
    'Mode' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'LevelSensitive', 1: 'Latched'})]],
    'TargetProcessors' : [ 0x14, ['_GROUP_AFFINITY']],
    'IntRemapInfo' : [ 0x20, ['_INTERRUPT_REMAPPING_INFO']],
    'ControllerInput' : [ 0x30, ['__unnamed_296f']],
    'HvDeviceId' : [ 0x38, ['unsigned long long']],
    'XapicMessage' : [ 0x40, ['__unnamed_2971']],
    'Hypertransport' : [ 0x40, ['__unnamed_2974']],
    'GenericMessage' : [ 0x40, ['__unnamed_2971']],
    'MessageRequest' : [ 0x40, ['__unnamed_2978']],
} ],
  '_MMPAGE_FILE_EXPANSION_FLAGS' : [ 0x4, {
    'PageFileNumber' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Spare1' : [ 0x1, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'Spare2' : [ 0x2, ['BitField', dict(start_bit = 0, end_bit = 8, native_type='unsigned char')]],
    'IgnoreCurrentCommit' : [ 0x3, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned char')]],
    'IncreaseMinimumSize' : [ 0x3, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned char')]],
    'Spare3' : [ 0x3, ['BitField', dict(start_bit = 2, end_bit = 8, native_type='unsigned char')]],
} ],
  '_POP_FX_DEPENDENT' : [ 0x8, {
    'Index' : [ 0x0, ['unsigned long']],
    'ProviderIndex' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_2986' : [ 0x8, {
    'Count' : [ 0x0, ['unsigned long']],
    'States' : [ 0x4, ['pointer', ['_PO_FX_PERF_STATE']]],
} ],
  '__unnamed_2988' : [ 0x10, {
    'Minimum' : [ 0x0, ['unsigned long long']],
    'Maximum' : [ 0x8, ['unsigned long long']],
} ],
  '_PO_FX_COMPONENT_PERF_SET' : [ 0x28, {
    'Name' : [ 0x0, ['_UNICODE_STRING']],
    'Flags' : [ 0x8, ['unsigned long long']],
    'Unit' : [ 0x10, ['Enumeration', dict(target = 'long', choices = {0: 'PoFxPerfStateUnitOther', 1: 'PoFxPerfStateUnitFrequency', 2: 'PoFxPerfStateUnitBandwidth', 3: 'PoFxPerfStateUnitMaximum'})]],
    'Type' : [ 0x14, ['Enumeration', dict(target = 'long', choices = {0: 'PoFxPerfStateTypeDiscrete', 1: 'PoFxPerfStateTypeRange', 2: 'PoFxPerfStateTypeMaximum'})]],
    'Discrete' : [ 0x18, ['__unnamed_2986']],
    'Range' : [ 0x18, ['__unnamed_2988']],
} ],
  '_XPF_MCE_FLAGS' : [ 0x4, {
    'MCG_CapabilityRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'MCG_GlobalControlRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 32, native_type='unsigned long')]],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_2999' : [ 0x8, {
    'Signature' : [ 0x0, ['unsigned long']],
    'CheckSum' : [ 0x4, ['unsigned long']],
} ],
  '__unnamed_299b' : [ 0x10, {
    'DiskId' : [ 0x0, ['_GUID']],
} ],
  '__unnamed_299d' : [ 0x10, {
    'Mbr' : [ 0x0, ['__unnamed_2999']],
    'Gpt' : [ 0x0, ['__unnamed_299b']],
} ],
  '_DUMP_INITIALIZATION_CONTEXT' : [ 0xc0, {
    'Length' : [ 0x0, ['unsigned long']],
    'Reserved' : [ 0x4, ['unsigned long']],
    'MemoryBlock' : [ 0x8, ['pointer', ['void']]],
    'CommonBuffer' : [ 0xc, ['array', 2, ['pointer', ['void']]]],
    'PhysicalAddress' : [ 0x18, ['array', 2, ['_LARGE_INTEGER']]],
    'StallRoutine' : [ 0x28, ['pointer', ['void']]],
    'OpenRoutine' : [ 0x2c, ['pointer', ['void']]],
    'WriteRoutine' : [ 0x30, ['pointer', ['void']]],
    'FinishRoutine' : [ 0x34, ['pointer', ['void']]],
    'AdapterObject' : [ 0x38, ['pointer', ['_ADAPTER_OBJECT']]],
    'MappedRegisterBase' : [ 0x3c, ['pointer', ['void']]],
    'PortConfiguration' : [ 0x40, ['pointer', ['void']]],
    'CrashDump' : [ 0x44, ['unsigned char']],
    'MarkMemoryOnly' : [ 0x45, ['unsigned char']],
    'HiberResume' : [ 0x46, ['unsigned char']],
    'Reserved1' : [ 0x47, ['unsigned char']],
    'MaximumTransferSize' : [ 0x48, ['unsigned long']],
    'CommonBufferSize' : [ 0x4c, ['unsigned long']],
    'TargetAddress' : [ 0x50, ['pointer', ['void']]],
    'WritePendingRoutine' : [ 0x54, ['pointer', ['void']]],
    'PartitionStyle' : [ 0x58, ['unsigned long']],
    'DiskInfo' : [ 0x5c, ['__unnamed_299d']],
    'ReadRoutine' : [ 0x6c, ['pointer', ['void']]],
    'GetDriveTelemetryRoutine' : [ 0x70, ['pointer', ['void']]],
    'LogSectionTruncateSize' : [ 0x74, ['unsigned long']],
    'Parameters' : [ 0x78, ['array', 16, ['unsigned long']]],
    'GetTransferSizesRoutine' : [ 0xb8, ['pointer', ['void']]],
    'DumpNotifyRoutine' : [ 0xbc, ['pointer', ['void']]],
} ],
  '_MI_IO_CACHE_STATS' : [ 0x18, {
    'UnusedBlocks' : [ 0x0, ['unsigned long']],
    'ActiveCacheMatch' : [ 0x4, ['unsigned long']],
    'ActiveCacheOverride' : [ 0x8, ['unsigned long']],
    'UnmappedCacheFlush' : [ 0xc, ['unsigned long']],
    'UnmappedCacheMatch' : [ 0x10, ['unsigned long']],
    'UnmappedCacheConflict' : [ 0x14, ['unsigned long']],
} ],
  '_PROCESSOR_PLATFORM_STATE_RESIDENCY' : [ 0x10, {
    'Residency' : [ 0x0, ['unsigned long long']],
    'TransitionCount' : [ 0x8, ['unsigned long long']],
} ],
  '_ETW_QUEUE_ENTRY' : [ 0x20, {
    'ListEntry' : [ 0x0, ['_LIST_ENTRY']],
    'DataBlock' : [ 0x8, ['pointer', ['_ETWP_NOTIFICATION_HEADER']]],
    'RegEntry' : [ 0xc, ['pointer', ['_ETW_REG_ENTRY']]],
    'ReplyObject' : [ 0x10, ['pointer', ['_ETW_REG_ENTRY']]],
    'WakeReference' : [ 0x14, ['pointer', ['void']]],
    'RegIndex' : [ 0x18, ['unsigned short']],
    'ReplyIndex' : [ 0x1a, ['unsigned short']],
    'Flags' : [ 0x1c, ['unsigned long']],
} ],
  '_MI_RESERVATION_CLUSTER_INFO' : [ 0x4, {
    'ClusterSize' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 10, native_type='unsigned long')]],
    'SequenceNumber' : [ 0x0, ['BitField', dict(start_bit = 10, end_bit = 32, native_type='unsigned long')]],
    'EntireInfo' : [ 0x0, ['long']],
} ],
  '_TRIAGE_POP_IRP_DATA' : [ 0x10, {
    'Link' : [ 0x0, ['_LIST_ENTRY']],
    'Irp' : [ 0x8, ['pointer', ['_IRP']]],
    'Pdo' : [ 0xc, ['pointer', ['_DEVICE_OBJECT']]],
} ],
  '_KDPC_LIST' : [ 0x8, {
    'ListHead' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'LastEntry' : [ 0x4, ['pointer', ['_SINGLE_LIST_ENTRY']]],
} ],
  '_CM_KEY_SECURITY' : [ 0x28, {
    'Signature' : [ 0x0, ['unsigned short']],
    'Reserved' : [ 0x2, ['unsigned short']],
    'Flink' : [ 0x4, ['unsigned long']],
    'Blink' : [ 0x8, ['unsigned long']],
    'ReferenceCount' : [ 0xc, ['unsigned long']],
    'DescriptorLength' : [ 0x10, ['unsigned long']],
    'Descriptor' : [ 0x14, ['_SECURITY_DESCRIPTOR_RELATIVE']],
} ],
  '_PO_DEVICE_NOTIFY_ORDER' : [ 0xd0, {
    'Locked' : [ 0x0, ['unsigned char']],
    'WarmEjectPdoPointer' : [ 0x4, ['pointer', ['pointer', ['_DEVICE_OBJECT']]]],
    'OrderLevel' : [ 0x8, ['array', 5, ['_PO_NOTIFY_ORDER_LEVEL']]],
} ],
  '_MI_POOL_FAILURE_REASONS' : [ 0x2c, {
    'NonPagedNoPtes' : [ 0x0, ['unsigned long']],
    'PriorityTooLow' : [ 0x4, ['unsigned long']],
    'NonPagedNoPagesAvailable' : [ 0x8, ['unsigned long']],
    'PagedNoPtes' : [ 0xc, ['unsigned long']],
    'SessionPagedNoPtes' : [ 0x10, ['unsigned long']],
    'PagedNoPagesAvailable' : [ 0x14, ['unsigned long']],
    'SessionPagedNoPagesAvailable' : [ 0x18, ['unsigned long']],
    'PagedNoCommit' : [ 0x1c, ['unsigned long']],
    'SessionPagedNoCommit' : [ 0x20, ['unsigned long']],
    'NonPagedNoResidentAvailable' : [ 0x24, ['unsigned long']],
    'NonPagedNoCommit' : [ 0x28, ['unsigned long']],
} ],
  '_IO_REMOVE_LOCK_COMMON_BLOCK' : [ 0x18, {
    'Removed' : [ 0x0, ['unsigned char']],
    'Reserved' : [ 0x1, ['array', 3, ['unsigned char']]],
    'IoCount' : [ 0x4, ['long']],
    'RemoveEvent' : [ 0x8, ['_KEVENT']],
} ],
  '_POP_FX_IDLE_STATE' : [ 0x18, {
    'TransitionLatency' : [ 0x0, ['unsigned long long']],
    'ResidencyRequirement' : [ 0x8, ['unsigned long long']],
    'NominalPower' : [ 0x10, ['unsigned long']],
} ],
  '_WHEA_NOTIFICATION_FLAGS' : [ 0x2, {
    'PollIntervalRW' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned short')]],
    'SwitchToPollingThresholdRW' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned short')]],
    'SwitchToPollingWindowRW' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 3, native_type='unsigned short')]],
    'ErrorThresholdRW' : [ 0x0, ['BitField', dict(start_bit = 3, end_bit = 4, native_type='unsigned short')]],
    'ErrorThresholdWindowRW' : [ 0x0, ['BitField', dict(start_bit = 4, end_bit = 5, native_type='unsigned short')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 16, native_type='unsigned short')]],
    'AsUSHORT' : [ 0x0, ['unsigned short']],
} ],
  '_ARBITER_CONFLICT_INFO' : [ 0x18, {
    'OwningObject' : [ 0x0, ['pointer', ['_DEVICE_OBJECT']]],
    'Start' : [ 0x8, ['unsigned long long']],
    'End' : [ 0x10, ['unsigned long long']],
} ],
  '_PO_NOTIFY_ORDER_LEVEL' : [ 0x28, {
    'DeviceCount' : [ 0x0, ['unsigned long']],
    'ActiveCount' : [ 0x4, ['unsigned long']],
    'WaitSleep' : [ 0x8, ['_LIST_ENTRY']],
    'ReadySleep' : [ 0x10, ['_LIST_ENTRY']],
    'ReadyS0' : [ 0x18, ['_LIST_ENTRY']],
    'WaitS0' : [ 0x20, ['_LIST_ENTRY']],
} ],
  '_ETWP_NOTIFICATION_HEADER' : [ 0x48, {
    'NotificationType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: 'EtwNotificationTypeNoReply', 2: 'EtwNotificationTypeLegacyEnable', 3: 'EtwNotificationTypeEnable', 4: 'EtwNotificationTypePrivateLogger', 5: 'EtwNotificationTypePerflib', 6: 'EtwNotificationTypeAudio', 7: 'EtwNotificationTypeSession', 8: 'EtwNotificationTypeReserved', 9: 'EtwNotificationTypeCredentialUI', 10: 'EtwNotificationTypeInProcSession', 11: 'EtwNotificationTypeMax'})]],
    'NotificationSize' : [ 0x4, ['unsigned long']],
    'RefCount' : [ 0x8, ['long']],
    'ReplyRequested' : [ 0xc, ['unsigned char']],
    'ReplyIndex' : [ 0x10, ['unsigned long']],
    'Timeout' : [ 0x10, ['unsigned long']],
    'ReplyCount' : [ 0x14, ['unsigned long']],
    'NotifyeeCount' : [ 0x14, ['unsigned long']],
    'ReplyHandle' : [ 0x18, ['unsigned long long']],
    'ReplyObject' : [ 0x18, ['pointer', ['void']]],
    'RegIndex' : [ 0x18, ['unsigned long']],
    'TargetPID' : [ 0x20, ['unsigned long']],
    'SourcePID' : [ 0x24, ['unsigned long']],
    'DestinationGuid' : [ 0x28, ['_GUID']],
    'SourceGuid' : [ 0x38, ['_GUID']],
} ],
  '__unnamed_29d2' : [ 0x4, {
    'Mask' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 1, native_type='unsigned long')]],
    'Polarity' : [ 0x0, ['BitField', dict(start_bit = 1, end_bit = 2, native_type='unsigned long')]],
    'MessageType' : [ 0x0, ['BitField', dict(start_bit = 2, end_bit = 5, native_type='unsigned long')]],
    'RequestEOI' : [ 0x0, ['BitField', dict(start_bit = 5, end_bit = 6, native_type='unsigned long')]],
    'DestinationMode' : [ 0x0, ['BitField', dict(start_bit = 6, end_bit = 7, native_type='unsigned long')]],
    'MessageType3' : [ 0x0, ['BitField', dict(start_bit = 7, end_bit = 8, native_type='unsigned long')]],
    'Destination' : [ 0x0, ['BitField', dict(start_bit = 8, end_bit = 16, native_type='unsigned long')]],
    'Vector' : [ 0x0, ['BitField', dict(start_bit = 16, end_bit = 24, native_type='unsigned long')]],
    'ExtendedAddress' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_29d4' : [ 0x4, {
    'bits' : [ 0x0, ['__unnamed_29d2']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '__unnamed_29d7' : [ 0x4, {
    'ExtendedDestination' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 24, native_type='unsigned long')]],
    'Reserved' : [ 0x0, ['BitField', dict(start_bit = 24, end_bit = 30, native_type='unsigned long')]],
    'PassPW' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'WaitingForEOI' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
} ],
  '__unnamed_29d9' : [ 0x4, {
    'bits' : [ 0x0, ['__unnamed_29d7']],
    'AsULONG' : [ 0x0, ['unsigned long']],
} ],
  '_INTERRUPT_HT_INTR_INFO' : [ 0x8, {
    'LowPart' : [ 0x0, ['__unnamed_29d4']],
    'HighPart' : [ 0x4, ['__unnamed_29d9']],
} ],
  '_THREAD_PERFORMANCE_DATA' : [ 0x1c0, {
    'Size' : [ 0x0, ['unsigned short']],
    'Version' : [ 0x2, ['unsigned short']],
    'ProcessorNumber' : [ 0x4, ['_PROCESSOR_NUMBER']],
    'ContextSwitches' : [ 0x8, ['unsigned long']],
    'HwCountersCount' : [ 0xc, ['unsigned long']],
    'UpdateCount' : [ 0x10, ['unsigned long long']],
    'WaitReasonBitMap' : [ 0x18, ['unsigned long long']],
    'HardwareCounters' : [ 0x20, ['unsigned long long']],
    'CycleTime' : [ 0x28, ['_COUNTER_READING']],
    'HwCounters' : [ 0x40, ['array', 16, ['_COUNTER_READING']]],
} ],
  '_ETW_REPLY_QUEUE' : [ 0x2c, {
    'Queue' : [ 0x0, ['_KQUEUE']],
    'EventsLost' : [ 0x28, ['long']],
} ],
  '_PROC_PERF_CHECK_SNAP' : [ 0x50, {
    'Time' : [ 0x0, ['unsigned long long']],
    'Active' : [ 0x8, ['unsigned long long']],
    'Stall' : [ 0x10, ['unsigned long long']],
    'FrequencyScaledActive' : [ 0x18, ['unsigned long long']],
    'PerformanceScaledActive' : [ 0x20, ['unsigned long long']],
    'PerformanceScaledKernelActive' : [ 0x28, ['unsigned long long']],
    'CyclesActive' : [ 0x30, ['unsigned long long']],
    'CyclesAffinitized' : [ 0x38, ['unsigned long long']],
    'TaggedThreadCycles' : [ 0x40, ['array', 2, ['unsigned long long']]],
} ],
  '_ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS' : [ 0x4, {
    'AllocatedResources' : [ 0x0, ['pointer', ['pointer', ['_CM_PARTIAL_RESOURCE_LIST']]]],
} ],
  '__unnamed_29e7' : [ 0x4, {
    'ReferenceCount' : [ 0x0, ['unsigned long']],
    'NumberOfPtesToFree' : [ 0x0, ['unsigned long']],
} ],
  '_MI_PER_SESSION_PROTOS' : [ 0x18, {
    'SessionProtoNode' : [ 0x0, ['_RTL_BALANCED_NODE']],
    'FreeList' : [ 0x0, ['_SINGLE_LIST_ENTRY']],
    'DriverAddress' : [ 0x0, ['pointer', ['void']]],
    'SessionId' : [ 0xc, ['unsigned long']],
    'Subsection' : [ 0xc, ['pointer', ['_SUBSECTION']]],
    'SubsectionBase' : [ 0x10, ['pointer', ['_MMPTE']]],
    'u2' : [ 0x14, ['__unnamed_29e7']],
} ],
  '_PO_FX_PERF_STATE_CHANGE' : [ 0x10, {
    'Set' : [ 0x0, ['unsigned long']],
    'StateIndex' : [ 0x8, ['unsigned long']],
    'StateValue' : [ 0x8, ['unsigned long long']],
} ],
  '__unnamed_29ed' : [ 0x8, {
    'MessageAddressLow' : [ 0x0, ['unsigned long']],
    'MessageData' : [ 0x4, ['unsigned short']],
    'Reserved' : [ 0x6, ['unsigned short']],
} ],
  '__unnamed_29ef' : [ 0x8, {
    'RemappedFormat' : [ 0x0, ['_ULARGE_INTEGER']],
    'Msi' : [ 0x0, ['__unnamed_29ed']],
} ],
  '_INTERRUPT_REMAPPING_INFO' : [ 0x10, {
    'IrtIndex' : [ 0x0, ['BitField', dict(start_bit = 0, end_bit = 30, native_type='unsigned long')]],
    'FlagHalInternal' : [ 0x0, ['BitField', dict(start_bit = 30, end_bit = 31, native_type='unsigned long')]],
    'FlagTranslated' : [ 0x0, ['BitField', dict(start_bit = 31, end_bit = 32, native_type='unsigned long')]],
    'u' : [ 0x8, ['__unnamed_29ef']],
} ],
  '_KSPECIAL_REGISTERS' : [ 0x54, {
    'Cr0' : [ 0x0, ['unsigned long']],
    'Cr2' : [ 0x4, ['unsigned long']],
    'Cr3' : [ 0x8, ['unsigned long']],
    'Cr4' : [ 0xc, ['unsigned long']],
    'KernelDr0' : [ 0x10, ['unsigned long']],
    'KernelDr1' : [ 0x14, ['unsigned long']],
    'KernelDr2' : [ 0x18, ['unsigned long']],
    'KernelDr3' : [ 0x1c, ['unsigned long']],
    'KernelDr6' : [ 0x20, ['unsigned long']],
    'KernelDr7' : [ 0x24, ['unsigned long']],
    'Gdtr' : [ 0x28, ['_DESCRIPTOR']],
    'Idtr' : [ 0x30, ['_DESCRIPTOR']],
    'Tr' : [ 0x38, ['unsigned short']],
    'Ldtr' : [ 0x3a, ['unsigned short']],
    'Xcr0' : [ 0x3c, ['unsigned long long']],
    'ExceptionList' : [ 0x44, ['unsigned long']],
    'Reserved' : [ 0x48, ['array', 3, ['unsigned long']]],
} ],
  '_RTL_ACTIVATION_CONTEXT_STACK_FRAME' : [ 0xc, {
    'Previous' : [ 0x0, ['pointer', ['_RTL_ACTIVATION_CONTEXT_STACK_FRAME']]],
    'ActivationContext' : [ 0x4, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'Flags' : [ 0x8, ['unsigned long']],
} ],
  '_ETW_FILTER_STRING_TOKEN_ELEMENT' : [ 0x8, {
    'Length' : [ 0x0, ['unsigned short']],
    'String' : [ 0x4, ['pointer', ['unsigned short']]],
} ],
  '_ARBITER_ORDERING' : [ 0x10, {
    'Start' : [ 0x0, ['unsigned long long']],
    'End' : [ 0x8, ['unsigned long long']],
} ],
  '_RTL_AVL_TABLE' : [ 0x38, {
    'BalancedRoot' : [ 0x0, ['_RTL_BALANCED_LINKS']],
    'OrderedPointer' : [ 0x10, ['pointer', ['void']]],
    'WhichOrderedElement' : [ 0x14, ['unsigned long']],
    'NumberGenericTableElements' : [ 0x18, ['unsigned long']],
    'DepthOfTree' : [ 0x1c, ['unsigned long']],
    'RestartKey' : [ 0x20, ['pointer', ['_RTL_BALANCED_LINKS']]],
    'DeleteCount' : [ 0x24, ['unsigned long']],
    'CompareRoutine' : [ 0x28, ['pointer', ['void']]],
    'AllocateRoutine' : [ 0x2c, ['pointer', ['void']]],
    'FreeRoutine' : [ 0x30, ['pointer', ['void']]],
    'TableContext' : [ 0x34, ['pointer', ['void']]],
} ],
  '_KTRANSACTION_HISTORY' : [ 0x8, {
    'RecordType' : [ 0x0, ['Enumeration', dict(target = 'long', choices = {1: 'KTMOH_CommitTransaction_Result', 2: 'KTMOH_RollbackTransaction_Result'})]],
    'Payload' : [ 0x4, ['unsigned long']],
} ],
  '_PO_FX_PERF_STATE' : [ 0x10, {
    'Value' : [ 0x0, ['unsigned long long']],
    'Context' : [ 0x8, ['pointer', ['void']]],
} ],
  '_DESCRIPTOR' : [ 0x8, {
    'Pad' : [ 0x0, ['unsigned short']],
    'Limit' : [ 0x2, ['unsigned short']],
    'Base' : [ 0x4, ['unsigned long']],
} ],
}
