// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(mov)                       \
  M(movs)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  ShiftType shift;
  Register rs;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {
    {{al, r11, r2, ASR, r10},
     false,
     al,
     "al r11 r2 ASR r10",
     "al_r11_r2_ASR_r10"},
    {{al, r7, r8, ASR, r12}, false, al, "al r7 r8 ASR r12", "al_r7_r8_ASR_r12"},
    {{al, r10, r8, ASR, r4}, false, al, "al r10 r8 ASR r4", "al_r10_r8_ASR_r4"},
    {{al, r12, r7, LSR, r12},
     false,
     al,
     "al r12 r7 LSR r12",
     "al_r12_r7_LSR_r12"},
    {{al, r13, r4, ASR, r5}, false, al, "al r13 r4 ASR r5", "al_r13_r4_ASR_r5"},
    {{al, r12, r3, ROR, r5}, false, al, "al r12 r3 ROR r5", "al_r12_r3_ROR_r5"},
    {{al, r6, r11, ASR, r8}, false, al, "al r6 r11 ASR r8", "al_r6_r11_ASR_r8"},
    {{al, r8, r4, ASR, r4}, false, al, "al r8 r4 ASR r4", "al_r8_r4_ASR_r4"},
    {{al, r10, r6, ASR, r7}, false, al, "al r10 r6 ASR r7", "al_r10_r6_ASR_r7"},
    {{al, r0, r2, ASR, r14}, false, al, "al r0 r2 ASR r14", "al_r0_r2_ASR_r14"},
    {{al, r5, r13, LSL, r14},
     false,
     al,
     "al r5 r13 LSL r14",
     "al_r5_r13_LSL_r14"},
    {{al, r2, r4, LSR, r9}, false, al, "al r2 r4 LSR r9", "al_r2_r4_LSR_r9"},
    {{al, r9, r10, ASR, r9}, false, al, "al r9 r10 ASR r9", "al_r9_r10_ASR_r9"},
    {{al, r5, r8, ASR, r4}, false, al, "al r5 r8 ASR r4", "al_r5_r8_ASR_r4"},
    {{al, r2, r5, ASR, r13}, false, al, "al r2 r5 ASR r13", "al_r2_r5_ASR_r13"},
    {{al, r7, r10, ASR, r1}, false, al, "al r7 r10 ASR r1", "al_r7_r10_ASR_r1"},
    {{al, r4, r7, ASR, r2}, false, al, "al r4 r7 ASR r2", "al_r4_r7_ASR_r2"},
    {{al, r14, r0, ASR, r4}, false, al, "al r14 r0 ASR r4", "al_r14_r0_ASR_r4"},
    {{al, r11, r0, ASR, r14},
     false,
     al,
     "al r11 r0 ASR r14",
     "al_r11_r0_ASR_r14"},
    {{al, r12, r11, ROR, r7},
     false,
     al,
     "al r12 r11 ROR r7",
     "al_r12_r11_ROR_r7"},
    {{al, r9, r13, LSR, r10},
     false,
     al,
     "al r9 r13 LSR r10",
     "al_r9_r13_LSR_r10"},
    {{al, r11, r7, ROR, r0}, false, al, "al r11 r7 ROR r0", "al_r11_r7_ROR_r0"},
    {{al, r6, r13, ROR, r2}, false, al, "al r6 r13 ROR r2", "al_r6_r13_ROR_r2"},
    {{al, r4, r6, LSL, r6}, false, al, "al r4 r6 LSL r6", "al_r4_r6_LSL_r6"},
    {{al, r13, r0, LSL, r2}, false, al, "al r13 r0 LSL r2", "al_r13_r0_LSL_r2"},
    {{al, r14, r0, ASR, r7}, false, al, "al r14 r0 ASR r7", "al_r14_r0_ASR_r7"},
    {{al, r7, r1, LSR, r7}, false, al, "al r7 r1 LSR r7", "al_r7_r1_LSR_r7"},
    {{al, r9, r12, LSR, r11},
     false,
     al,
     "al r9 r12 LSR r11",
     "al_r9_r12_LSR_r11"},
    {{al, r1, r12, LSL, r5}, false, al, "al r1 r12 LSL r5", "al_r1_r12_LSL_r5"},
    {{al, r4, r2, ROR, r3}, false, al, "al r4 r2 ROR r3", "al_r4_r2_ROR_r3"},
    {{al, r10, r6, ROR, r11},
     false,
     al,
     "al r10 r6 ROR r11",
     "al_r10_r6_ROR_r11"},
    {{al, r5, r8, ROR, r7}, false, al, "al r5 r8 ROR r7", "al_r5_r8_ROR_r7"},
    {{al, r6, r10, LSL, r14},
     false,
     al,
     "al r6 r10 LSL r14",
     "al_r6_r10_LSL_r14"},
    {{al, r14, r8, LSL, r8}, false, al, "al r14 r8 LSL r8", "al_r14_r8_LSL_r8"},
    {{al, r4, r1, ROR, r10}, false, al, "al r4 r1 ROR r10", "al_r4_r1_ROR_r10"},
    {{al, r6, r11, LSR, r1}, false, al, "al r6 r11 LSR r1", "al_r6_r11_LSR_r1"},
    {{al, r14, r2, ASR, r4}, false, al, "al r14 r2 ASR r4", "al_r14_r2_ASR_r4"},
    {{al, r0, r6, LSL, r1}, false, al, "al r0 r6 LSL r1", "al_r0_r6_LSL_r1"},
    {{al, r5, r2, ASR, r0}, false, al, "al r5 r2 ASR r0", "al_r5_r2_ASR_r0"},
    {{al, r2, r4, LSL, r1}, false, al, "al r2 r4 LSL r1", "al_r2_r4_LSL_r1"},
    {{al, r5, r3, LSR, r9}, false, al, "al r5 r3 LSR r9", "al_r5_r3_LSR_r9"},
    {{al, r5, r3, ASR, r12}, false, al, "al r5 r3 ASR r12", "al_r5_r3_ASR_r12"},
    {{al, r6, r14, ASR, r4}, false, al, "al r6 r14 ASR r4", "al_r6_r14_ASR_r4"},
    {{al, r7, r4, LSL, r5}, false, al, "al r7 r4 LSL r5", "al_r7_r4_LSL_r5"},
    {{al, r12, r0, LSL, r8}, false, al, "al r12 r0 LSL r8", "al_r12_r0_LSL_r8"},
    {{al, r8, r3, LSR, r2}, false, al, "al r8 r3 LSR r2", "al_r8_r3_LSR_r2"},
    {{al, r14, r14, LSL, r2},
     false,
     al,
     "al r14 r14 LSL r2",
     "al_r14_r14_LSL_r2"},
    {{al, r2, r2, ASR, r9}, false, al, "al r2 r2 ASR r9", "al_r2_r2_ASR_r9"},
    {{al, r2, r7, ASR, r3}, false, al, "al r2 r7 ASR r3", "al_r2_r7_ASR_r3"},
    {{al, r1, r9, LSR, r3}, false, al, "al r1 r9 LSR r3", "al_r1_r9_LSR_r3"},
    {{al, r10, r7, LSR, r12},
     false,
     al,
     "al r10 r7 LSR r12",
     "al_r10_r7_LSR_r12"},
    {{al, r12, r14, ASR, r9},
     false,
     al,
     "al r12 r14 ASR r9",
     "al_r12_r14_ASR_r9"},
    {{al, r5, r4, ASR, r8}, false, al, "al r5 r4 ASR r8", "al_r5_r4_ASR_r8"},
    {{al, r13, r12, LSR, r4},
     false,
     al,
     "al r13 r12 LSR r4",
     "al_r13_r12_LSR_r4"},
    {{al, r3, r3, ASR, r4}, false, al, "al r3 r3 ASR r4", "al_r3_r3_ASR_r4"},
    {{al, r0, r3, LSR, r4}, false, al, "al r0 r3 LSR r4", "al_r0_r3_LSR_r4"},
    {{al, r6, r8, LSL, r9}, false, al, "al r6 r8 LSL r9", "al_r6_r8_LSL_r9"},
    {{al, r7, r12, LSR, r7}, false, al, "al r7 r12 LSR r7", "al_r7_r12_LSR_r7"},
    {{al, r10, r11, ASR, r7},
     false,
     al,
     "al r10 r11 ASR r7",
     "al_r10_r11_ASR_r7"},
    {{al, r2, r9, ROR, r6}, false, al, "al r2 r9 ROR r6", "al_r2_r9_ROR_r6"},
    {{al, r1, r6, LSR, r12}, false, al, "al r1 r6 LSR r12", "al_r1_r6_LSR_r12"},
    {{al, r5, r2, LSL, r2}, false, al, "al r5 r2 LSL r2", "al_r5_r2_LSL_r2"},
    {{al, r10, r1, ASR, r3}, false, al, "al r10 r1 ASR r3", "al_r10_r1_ASR_r3"},
    {{al, r1, r7, ROR, r0}, false, al, "al r1 r7 ROR r0", "al_r1_r7_ROR_r0"},
    {{al, r13, r3, ASR, r0}, false, al, "al r13 r3 ASR r0", "al_r13_r3_ASR_r0"},
    {{al, r11, r13, LSR, r3},
     false,
     al,
     "al r11 r13 LSR r3",
     "al_r11_r13_LSR_r3"},
    {{al, r2, r7, ROR, r14}, false, al, "al r2 r7 ROR r14", "al_r2_r7_ROR_r14"},
    {{al, r2, r6, ASR, r5}, false, al, "al r2 r6 ASR r5", "al_r2_r6_ASR_r5"},
    {{al, r14, r14, LSL, r13},
     false,
     al,
     "al r14 r14 LSL r13",
     "al_r14_r14_LSL_r13"},
    {{al, r5, r4, ROR, r5}, false, al, "al r5 r4 ROR r5", "al_r5_r4_ROR_r5"},
    {{al, r1, r5, ROR, r1}, false, al, "al r1 r5 ROR r1", "al_r1_r5_ROR_r1"},
    {{al, r0, r12, LSR, r8}, false, al, "al r0 r12 LSR r8", "al_r0_r12_LSR_r8"},
    {{al, r4, r6, ASR, r4}, false, al, "al r4 r6 ASR r4", "al_r4_r6_ASR_r4"},
    {{al, r13, r7, LSL, r13},
     false,
     al,
     "al r13 r7 LSL r13",
     "al_r13_r7_LSL_r13"},
    {{al, r0, r6, ASR, r9}, false, al, "al r0 r6 ASR r9", "al_r0_r6_ASR_r9"},
    {{al, r10, r7, LSR, r9}, false, al, "al r10 r7 LSR r9", "al_r10_r7_LSR_r9"},
    {{al, r13, r5, ASR, r12},
     false,
     al,
     "al r13 r5 ASR r12",
     "al_r13_r5_ASR_r12"},
    {{al, r9, r13, LSL, r3}, false, al, "al r9 r13 LSL r3", "al_r9_r13_LSL_r3"},
    {{al, r11, r10, ASR, r4},
     false,
     al,
     "al r11 r10 ASR r4",
     "al_r11_r10_ASR_r4"},
    {{al, r14, r13, ASR, r11},
     false,
     al,
     "al r14 r13 ASR r11",
     "al_r14_r13_ASR_r11"},
    {{al, r2, r8, LSL, r2}, false, al, "al r2 r8 LSL r2", "al_r2_r8_LSL_r2"},
    {{al, r5, r10, LSR, r1}, false, al, "al r5 r10 LSR r1", "al_r5_r10_LSR_r1"},
    {{al, r1, r0, LSL, r2}, false, al, "al r1 r0 LSL r2", "al_r1_r0_LSL_r2"},
    {{al, r12, r3, ROR, r11},
     false,
     al,
     "al r12 r3 ROR r11",
     "al_r12_r3_ROR_r11"},
    {{al, r2, r6, ROR, r2}, false, al, "al r2 r6 ROR r2", "al_r2_r6_ROR_r2"},
    {{al, r14, r11, LSL, r13},
     false,
     al,
     "al r14 r11 LSL r13",
     "al_r14_r11_LSL_r13"},
    {{al, r10, r6, ASR, r13},
     false,
     al,
     "al r10 r6 ASR r13",
     "al_r10_r6_ASR_r13"},
    {{al, r5, r8, LSL, r4}, false, al, "al r5 r8 LSL r4", "al_r5_r8_LSL_r4"},
    {{al, r11, r3, ASR, r5}, false, al, "al r11 r3 ASR r5", "al_r11_r3_ASR_r5"},
    {{al, r6, r1, LSL, r4}, false, al, "al r6 r1 LSL r4", "al_r6_r1_LSL_r4"},
    {{al, r4, r12, ROR, r9}, false, al, "al r4 r12 ROR r9", "al_r4_r12_ROR_r9"},
    {{al, r9, r4, LSR, r6}, false, al, "al r9 r4 LSR r6", "al_r9_r4_LSR_r6"},
    {{al, r11, r6, LSL, r13},
     false,
     al,
     "al r11 r6 LSL r13",
     "al_r11_r6_LSL_r13"},
    {{al, r12, r10, ROR, r0},
     false,
     al,
     "al r12 r10 ROR r0",
     "al_r12_r10_ROR_r0"},
    {{al, r3, r9, ASR, r14}, false, al, "al r3 r9 ASR r14", "al_r3_r9_ASR_r14"},
    {{al, r7, r14, ASR, r5}, false, al, "al r7 r14 ASR r5", "al_r7_r14_ASR_r5"},
    {{al, r2, r3, ASR, r10}, false, al, "al r2 r3 ASR r10", "al_r2_r3_ASR_r10"},
    {{al, r9, r7, ASR, r14}, false, al, "al r9 r7 ASR r14", "al_r9_r7_ASR_r14"},
    {{al, r4, r14, ROR, r3}, false, al, "al r4 r14 ROR r3", "al_r4_r14_ROR_r3"},
    {{al, r4, r10, ROR, r6}, false, al, "al r4 r10 ROR r6", "al_r4_r10_ROR_r6"},
    {{al, r5, r6, ASR, r8}, false, al, "al r5 r6 ASR r8", "al_r5_r6_ASR_r8"},
    {{al, r5, r8, ASR, r10}, false, al, "al r5 r8 ASR r10", "al_r5_r8_ASR_r10"},
    {{al, r9, r14, LSR, r9}, false, al, "al r9 r14 LSR r9", "al_r9_r14_LSR_r9"},
    {{al, r14, r6, LSR, r4}, false, al, "al r14 r6 LSR r4", "al_r14_r6_LSR_r4"},
    {{al, r9, r10, ROR, r2}, false, al, "al r9 r10 ROR r2", "al_r9_r10_ROR_r2"},
    {{al, r0, r11, LSR, r11},
     false,
     al,
     "al r0 r11 LSR r11",
     "al_r0_r11_LSR_r11"},
    {{al, r9, r9, ROR, r13}, false, al, "al r9 r9 ROR r13", "al_r9_r9_ROR_r13"},
    {{al, r11, r9, ASR, r4}, false, al, "al r11 r9 ASR r4", "al_r11_r9_ASR_r4"},
    {{al, r8, r13, ASR, r11},
     false,
     al,
     "al r8 r13 ASR r11",
     "al_r8_r13_ASR_r11"},
    {{al, r2, r8, ASR, r13}, false, al, "al r2 r8 ASR r13", "al_r2_r8_ASR_r13"},
    {{al, r4, r1, ROR, r9}, false, al, "al r4 r1 ROR r9", "al_r4_r1_ROR_r9"},
    {{al, r7, r1, LSL, r2}, false, al, "al r7 r1 LSL r2", "al_r7_r1_LSL_r2"},
    {{al, r0, r14, ASR, r12},
     false,
     al,
     "al r0 r14 ASR r12",
     "al_r0_r14_ASR_r12"},
    {{al, r3, r13, ASR, r0}, false, al, "al r3 r13 ASR r0", "al_r3_r13_ASR_r0"},
    {{al, r10, r4, LSR, r0}, false, al, "al r10 r4 LSR r0", "al_r10_r4_LSR_r0"},
    {{al, r10, r14, ASR, r11},
     false,
     al,
     "al r10 r14 ASR r11",
     "al_r10_r14_ASR_r11"},
    {{al, r12, r3, ROR, r2}, false, al, "al r12 r3 ROR r2", "al_r12_r3_ROR_r2"},
    {{al, r14, r5, LSR, r8}, false, al, "al r14 r5 LSR r8", "al_r14_r5_LSR_r8"},
    {{al, r2, r12, ASR, r0}, false, al, "al r2 r12 ASR r0", "al_r2_r12_ASR_r0"},
    {{al, r4, r8, ROR, r3}, false, al, "al r4 r8 ROR r3", "al_r4_r8_ROR_r3"},
    {{al, r11, r6, ASR, r3}, false, al, "al r11 r6 ASR r3", "al_r11_r6_ASR_r3"},
    {{al, r12, r0, LSR, r1}, false, al, "al r12 r0 LSR r1", "al_r12_r0_LSR_r1"},
    {{al, r11, r3, ASR, r9}, false, al, "al r11 r3 ASR r9", "al_r11_r3_ASR_r9"},
    {{al, r12, r5, LSR, r5}, false, al, "al r12 r5 LSR r5", "al_r12_r5_LSR_r5"},
    {{al, r4, r14, LSL, r11},
     false,
     al,
     "al r4 r14 LSL r11",
     "al_r4_r14_LSL_r11"},
    {{al, r4, r1, LSR, r6}, false, al, "al r4 r1 LSR r6", "al_r4_r1_LSR_r6"},
    {{al, r14, r7, ROR, r5}, false, al, "al r14 r7 ROR r5", "al_r14_r7_ROR_r5"},
    {{al, r11, r2, LSR, r1}, false, al, "al r11 r2 LSR r1", "al_r11_r2_LSR_r1"},
    {{al, r4, r1, LSL, r13}, false, al, "al r4 r1 LSL r13", "al_r4_r1_LSL_r13"},
    {{al, r10, r7, ROR, r4}, false, al, "al r10 r7 ROR r4", "al_r10_r7_ROR_r4"},
    {{al, r1, r14, ROR, r4}, false, al, "al r1 r14 ROR r4", "al_r1_r14_ROR_r4"},
    {{al, r14, r10, LSR, r11},
     false,
     al,
     "al r14 r10 LSR r11",
     "al_r14_r10_LSR_r11"},
    {{al, r2, r9, LSR, r8}, false, al, "al r2 r9 LSR r8", "al_r2_r9_LSR_r8"},
    {{al, r3, r10, LSR, r1}, false, al, "al r3 r10 LSR r1", "al_r3_r10_LSR_r1"},
    {{al, r2, r6, LSL, r11}, false, al, "al r2 r6 LSL r11", "al_r2_r6_LSL_r11"},
    {{al, r14, r1, LSR, r9}, false, al, "al r14 r1 LSR r9", "al_r14_r1_LSR_r9"},
    {{al, r6, r1, LSR, r5}, false, al, "al r6 r1 LSR r5", "al_r6_r1_LSR_r5"},
    {{al, r13, r10, ASR, r3},
     false,
     al,
     "al r13 r10 ASR r3",
     "al_r13_r10_ASR_r3"},
    {{al, r11, r11, LSL, r2},
     false,
     al,
     "al r11 r11 LSL r2",
     "al_r11_r11_LSL_r2"},
    {{al, r13, r4, LSL, r11},
     false,
     al,
     "al r13 r4 LSL r11",
     "al_r13_r4_LSL_r11"},
    {{al, r9, r6, LSL, r9}, false, al, "al r9 r6 LSL r9", "al_r9_r6_LSL_r9"},
    {{al, r12, r1, LSR, r6}, false, al, "al r12 r1 LSR r6", "al_r12_r1_LSR_r6"},
    {{al, r5, r3, LSL, r7}, false, al, "al r5 r3 LSL r7", "al_r5_r3_LSL_r7"},
    {{al, r5, r13, LSL, r5}, false, al, "al r5 r13 LSL r5", "al_r5_r13_LSL_r5"},
    {{al, r11, r6, LSL, r7}, false, al, "al r11 r6 LSL r7", "al_r11_r6_LSL_r7"},
    {{al, r1, r11, LSR, r4}, false, al, "al r1 r11 LSR r4", "al_r1_r11_LSR_r4"},
    {{al, r12, r10, ROR, r10},
     false,
     al,
     "al r12 r10 ROR r10",
     "al_r12_r10_ROR_r10"},
    {{al, r9, r10, LSR, r2}, false, al, "al r9 r10 LSR r2", "al_r9_r10_LSR_r2"},
    {{al, r2, r4, LSL, r2}, false, al, "al r2 r4 LSL r2", "al_r2_r4_LSL_r2"},
    {{al, r5, r11, ROR, r3}, false, al, "al r5 r11 ROR r3", "al_r5_r11_ROR_r3"},
    {{al, r10, r5, ASR, r11},
     false,
     al,
     "al r10 r5 ASR r11",
     "al_r10_r5_ASR_r11"},
    {{al, r11, r9, LSL, r12},
     false,
     al,
     "al r11 r9 LSL r12",
     "al_r11_r9_LSL_r12"},
    {{al, r4, r13, LSR, r6}, false, al, "al r4 r13 LSR r6", "al_r4_r13_LSR_r6"},
    {{al, r2, r11, ROR, r8}, false, al, "al r2 r11 ROR r8", "al_r2_r11_ROR_r8"},
    {{al, r9, r1, LSR, r3}, false, al, "al r9 r1 LSR r3", "al_r9_r1_LSR_r3"},
    {{al, r5, r8, LSR, r2}, false, al, "al r5 r8 LSR r2", "al_r5_r8_LSR_r2"},
    {{al, r4, r14, ROR, r10},
     false,
     al,
     "al r4 r14 ROR r10",
     "al_r4_r14_ROR_r10"},
    {{al, r13, r0, ROR, r0}, false, al, "al r13 r0 ROR r0", "al_r13_r0_ROR_r0"},
    {{al, r2, r10, ROR, r7}, false, al, "al r2 r10 ROR r7", "al_r2_r10_ROR_r7"},
    {{al, r9, r11, LSR, r12},
     false,
     al,
     "al r9 r11 LSR r12",
     "al_r9_r11_LSR_r12"},
    {{al, r3, r4, ASR, r9}, false, al, "al r3 r4 ASR r9", "al_r3_r4_ASR_r9"},
    {{al, r14, r5, LSR, r13},
     false,
     al,
     "al r14 r5 LSR r13",
     "al_r14_r5_LSR_r13"},
    {{al, r14, r14, ASR, r5},
     false,
     al,
     "al r14 r14 ASR r5",
     "al_r14_r14_ASR_r5"},
    {{al, r0, r8, LSL, r8}, false, al, "al r0 r8 LSL r8", "al_r0_r8_LSL_r8"},
    {{al, r12, r6, ASR, r13},
     false,
     al,
     "al r12 r6 ASR r13",
     "al_r12_r6_ASR_r13"},
    {{al, r4, r2, ASR, r4}, false, al, "al r4 r2 ASR r4", "al_r4_r2_ASR_r4"},
    {{al, r6, r6, ASR, r7}, false, al, "al r6 r6 ASR r7", "al_r6_r6_ASR_r7"},
    {{al, r9, r7, LSR, r8}, false, al, "al r9 r7 LSR r8", "al_r9_r7_LSR_r8"},
    {{al, r5, r9, ASR, r8}, false, al, "al r5 r9 ASR r8", "al_r5_r9_ASR_r8"},
    {{al, r8, r10, ROR, r6}, false, al, "al r8 r10 ROR r6", "al_r8_r10_ROR_r6"},
    {{al, r13, r2, LSL, r9}, false, al, "al r13 r2 LSL r9", "al_r13_r2_LSL_r9"},
    {{al, r6, r3, ASR, r7}, false, al, "al r6 r3 ASR r7", "al_r6_r3_ASR_r7"},
    {{al, r12, r4, ROR, r6}, false, al, "al r12 r4 ROR r6", "al_r12_r4_ROR_r6"},
    {{al, r7, r2, ROR, r8}, false, al, "al r7 r2 ROR r8", "al_r7_r2_ROR_r8"},
    {{al, r4, r6, ASR, r2}, false, al, "al r4 r6 ASR r2", "al_r4_r6_ASR_r2"},
    {{al, r5, r6, LSL, r7}, false, al, "al r5 r6 LSL r7", "al_r5_r6_LSL_r7"},
    {{al, r13, r1, ROR, r12},
     false,
     al,
     "al r13 r1 ROR r12",
     "al_r13_r1_ROR_r12"},
    {{al, r12, r8, LSL, r0}, false, al, "al r12 r8 LSL r0", "al_r12_r8_LSL_r0"},
    {{al, r2, r13, ASR, r13},
     false,
     al,
     "al r2 r13 ASR r13",
     "al_r2_r13_ASR_r13"},
    {{al, r1, r6, ROR, r3}, false, al, "al r1 r6 ROR r3", "al_r1_r6_ROR_r3"},
    {{al, r14, r2, LSR, r9}, false, al, "al r14 r2 LSR r9", "al_r14_r2_LSR_r9"},
    {{al, r5, r7, ASR, r9}, false, al, "al r5 r7 ASR r9", "al_r5_r7_ASR_r9"},
    {{al, r11, r4, ROR, r5}, false, al, "al r11 r4 ROR r5", "al_r11_r4_ROR_r5"},
    {{al, r7, r9, LSR, r1}, false, al, "al r7 r9 LSR r1", "al_r7_r9_LSR_r1"},
    {{al, r4, r3, ROR, r4}, false, al, "al r4 r3 ROR r4", "al_r4_r3_ROR_r4"},
    {{al, r0, r4, ASR, r13}, false, al, "al r0 r4 ASR r13", "al_r0_r4_ASR_r13"},
    {{al, r10, r10, LSR, r14},
     false,
     al,
     "al r10 r10 LSR r14",
     "al_r10_r10_LSR_r14"},
    {{al, r0, r6, ASR, r7}, false, al, "al r0 r6 ASR r7", "al_r0_r6_ASR_r7"},
    {{al, r2, r4, ROR, r7}, false, al, "al r2 r4 ROR r7", "al_r2_r4_ROR_r7"},
    {{al, r14, r4, LSR, r13},
     false,
     al,
     "al r14 r4 LSR r13",
     "al_r14_r4_LSR_r13"},
    {{al, r9, r3, LSL, r2}, false, al, "al r9 r3 LSL r2", "al_r9_r3_LSL_r2"},
    {{al, r9, r3, LSL, r0}, false, al, "al r9 r3 LSL r0", "al_r9_r3_LSL_r0"},
    {{al, r3, r13, ASR, r3}, false, al, "al r3 r13 ASR r3", "al_r3_r13_ASR_r3"},
    {{al, r10, r12, ASR, r3},
     false,
     al,
     "al r10 r12 ASR r3",
     "al_r10_r12_ASR_r3"},
    {{al, r13, r7, LSR, r6}, false, al, "al r13 r7 LSR r6", "al_r13_r7_LSR_r6"},
    {{al, r6, r14, ASR, r11},
     false,
     al,
     "al r6 r14 ASR r11",
     "al_r6_r14_ASR_r11"},
    {{al, r10, r1, ASR, r14},
     false,
     al,
     "al r10 r1 ASR r14",
     "al_r10_r1_ASR_r14"},
    {{al, r7, r0, LSL, r3}, false, al, "al r7 r0 LSL r3", "al_r7_r0_LSL_r3"},
    {{al, r4, r8, LSL, r6}, false, al, "al r4 r8 LSL r6", "al_r4_r8_LSL_r6"},
    {{al, r3, r7, LSL, r2}, false, al, "al r3 r7 LSL r2", "al_r3_r7_LSL_r2"},
    {{al, r13, r10, LSR, r11},
     false,
     al,
     "al r13 r10 LSR r11",
     "al_r13_r10_LSR_r11"},
    {{al, r1, r13, ROR, r11},
     false,
     al,
     "al r1 r13 ROR r11",
     "al_r1_r13_ROR_r11"},
    {{al, r0, r10, LSR, r8}, false, al, "al r0 r10 LSR r8", "al_r0_r10_LSR_r8"},
    {{al, r10, r3, ASR, r4}, false, al, "al r10 r3 ASR r4", "al_r10_r3_ASR_r4"},
    {{al, r0, r2, LSR, r8}, false, al, "al r0 r2 LSR r8", "al_r0_r2_LSR_r8"},
    {{al, r8, r0, LSL, r4}, false, al, "al r8 r0 LSL r4", "al_r8_r0_LSL_r4"},
    {{al, r11, r8, ASR, r8}, false, al, "al r11 r8 ASR r8", "al_r11_r8_ASR_r8"},
    {{al, r11, r7, ASR, r10},
     false,
     al,
     "al r11 r7 ASR r10",
     "al_r11_r7_ASR_r10"},
    {{al, r10, r12, ROR, r0},
     false,
     al,
     "al r10 r12 ROR r0",
     "al_r10_r12_ROR_r0"},
    {{al, r8, r5, LSR, r9}, false, al, "al r8 r5 LSR r9", "al_r8_r5_LSR_r9"},
    {{al, r12, r3, ROR, r4}, false, al, "al r12 r3 ROR r4", "al_r12_r3_ROR_r4"},
    {{al, r11, r2, LSR, r13},
     false,
     al,
     "al r11 r2 LSR r13",
     "al_r11_r2_LSR_r13"},
    {{al, r13, r6, ROR, r2}, false, al, "al r13 r6 ROR r2", "al_r13_r6_ROR_r2"},
    {{al, r2, r1, ASR, r10}, false, al, "al r2 r1 ASR r10", "al_r2_r1_ASR_r10"},
    {{al, r9, r1, ROR, r3}, false, al, "al r9 r1 ROR r3", "al_r9_r1_ROR_r3"},
    {{al, r14, r9, ASR, r4}, false, al, "al r14 r9 ASR r4", "al_r14_r9_ASR_r4"},
    {{al, r14, r13, ASR, r9},
     false,
     al,
     "al r14 r13 ASR r9",
     "al_r14_r13_ASR_r9"},
    {{al, r10, r13, LSR, r7},
     false,
     al,
     "al r10 r13 LSR r7",
     "al_r10_r13_LSR_r7"},
    {{al, r5, r9, ROR, r10}, false, al, "al r5 r9 ROR r10", "al_r5_r9_ROR_r10"},
    {{al, r13, r3, ASR, r4}, false, al, "al r13 r3 ASR r4", "al_r13_r3_ASR_r4"},
    {{al, r11, r7, LSL, r10},
     false,
     al,
     "al r11 r7 LSL r10",
     "al_r11_r7_LSL_r10"},
    {{al, r2, r6, LSR, r14}, false, al, "al r2 r6 LSR r14", "al_r2_r6_LSR_r14"},
    {{al, r8, r4, LSR, r10}, false, al, "al r8 r4 LSR r10", "al_r8_r4_LSR_r10"},
    {{al, r5, r13, LSL, r11},
     false,
     al,
     "al r5 r13 LSL r11",
     "al_r5_r13_LSL_r11"},
    {{al, r7, r10, ASR, r8}, false, al, "al r7 r10 ASR r8", "al_r7_r10_ASR_r8"},
    {{al, r0, r4, LSR, r14}, false, al, "al r0 r4 LSR r14", "al_r0_r4_LSR_r14"},
    {{al, r0, r5, ASR, r8}, false, al, "al r0 r5 ASR r8", "al_r0_r5_ASR_r8"},
    {{al, r13, r13, ASR, r8},
     false,
     al,
     "al r13 r13 ASR r8",
     "al_r13_r13_ASR_r8"},
    {{al, r10, r8, LSR, r0}, false, al, "al r10 r8 LSR r0", "al_r10_r8_LSR_r0"},
    {{al, r8, r8, LSR, r8}, false, al, "al r8 r8 LSR r8", "al_r8_r8_LSR_r8"},
    {{al, r4, r12, LSL, r0}, false, al, "al r4 r12 LSL r0", "al_r4_r12_LSL_r0"},
    {{al, r3, r1, LSR, r11}, false, al, "al r3 r1 LSR r11", "al_r3_r1_LSR_r11"},
    {{al, r8, r8, ROR, r3}, false, al, "al r8 r8 ROR r3", "al_r8_r8_ROR_r3"},
    {{al, r10, r13, ASR, r14},
     false,
     al,
     "al r10 r13 ASR r14",
     "al_r10_r13_ASR_r14"},
    {{al, r3, r0, ROR, r4}, false, al, "al r3 r0 ROR r4", "al_r3_r0_ROR_r4"},
    {{al, r13, r0, LSL, r4}, false, al, "al r13 r0 LSL r4", "al_r13_r0_LSL_r4"},
    {{al, r12, r13, LSR, r4},
     false,
     al,
     "al r12 r13 LSR r4",
     "al_r12_r13_LSR_r4"},
    {{al, r7, r6, ASR, r13}, false, al, "al r7 r6 ASR r13", "al_r7_r6_ASR_r13"},
    {{al, r3, r11, LSR, r5}, false, al, "al r3 r11 LSR r5", "al_r3_r11_LSR_r5"},
    {{al, r1, r1, LSR, r1}, false, al, "al r1 r1 LSR r1", "al_r1_r1_LSR_r1"},
    {{al, r2, r14, ROR, r14},
     false,
     al,
     "al r2 r14 ROR r14",
     "al_r2_r14_ROR_r14"},
    {{al, r5, r10, LSL, r1}, false, al, "al r5 r10 LSL r1", "al_r5_r10_LSL_r1"},
    {{al, r14, r8, ROR, r4}, false, al, "al r14 r8 ROR r4", "al_r14_r8_ROR_r4"},
    {{al, r8, r3, LSL, r6}, false, al, "al r8 r3 LSL r6", "al_r8_r3_LSL_r6"},
    {{al, r9, r4, ROR, r1}, false, al, "al r9 r4 ROR r1", "al_r9_r4_ROR_r1"},
    {{al, r9, r13, ROR, r12},
     false,
     al,
     "al r9 r13 ROR r12",
     "al_r9_r13_ROR_r12"},
    {{al, r14, r9, ASR, r3}, false, al, "al r14 r9 ASR r3", "al_r14_r9_ASR_r3"},
    {{al, r1, r4, ASR, r4}, false, al, "al r1 r4 ASR r4", "al_r1_r4_ASR_r4"},
    {{al, r3, r9, ROR, r10}, false, al, "al r3 r9 ROR r10", "al_r3_r9_ROR_r10"},
    {{al, r7, r11, LSR, r14},
     false,
     al,
     "al r7 r11 LSR r14",
     "al_r7_r11_LSR_r14"},
    {{al, r11, r11, ASR, r7},
     false,
     al,
     "al r11 r11 ASR r7",
     "al_r11_r11_ASR_r7"},
    {{al, r1, r1, LSL, r9}, false, al, "al r1 r1 LSL r9", "al_r1_r1_LSL_r9"},
    {{al, r1, r6, LSL, r12}, false, al, "al r1 r6 LSL r12", "al_r1_r6_LSL_r12"},
    {{al, r14, r10, ROR, r8},
     false,
     al,
     "al r14 r10 ROR r8",
     "al_r14_r10_ROR_r8"},
    {{al, r5, r8, ASR, r2}, false, al, "al r5 r8 ASR r2", "al_r5_r8_ASR_r2"},
    {{al, r2, r6, LSL, r8}, false, al, "al r2 r6 LSL r8", "al_r2_r6_LSL_r8"},
    {{al, r11, r13, ROR, r1},
     false,
     al,
     "al r11 r13 ROR r1",
     "al_r11_r13_ROR_r1"},
    {{al, r11, r4, ASR, r3}, false, al, "al r11 r4 ASR r3", "al_r11_r4_ASR_r3"},
    {{al, r8, r0, LSR, r5}, false, al, "al r8 r0 LSR r5", "al_r8_r0_LSR_r5"},
    {{al, r7, r6, LSL, r7}, false, al, "al r7 r6 LSL r7", "al_r7_r6_LSL_r7"},
    {{al, r2, r6, LSR, r3}, false, al, "al r2 r6 LSR r3", "al_r2_r6_LSR_r3"},
    {{al, r5, r4, ASR, r0}, false, al, "al r5 r4 ASR r0", "al_r5_r4_ASR_r0"},
    {{al, r12, r4, ASR, r1}, false, al, "al r12 r4 ASR r1", "al_r12_r4_ASR_r1"},
    {{al, r5, r11, ASR, r12},
     false,
     al,
     "al r5 r11 ASR r12",
     "al_r5_r11_ASR_r12"},
    {{al, r2, r14, ASR, r2}, false, al, "al r2 r14 ASR r2", "al_r2_r14_ASR_r2"},
    {{al, r11, r0, ASR, r13},
     false,
     al,
     "al r11 r0 ASR r13",
     "al_r11_r0_ASR_r13"},
    {{al, r2, r11, LSR, r7}, false, al, "al r2 r11 LSR r7", "al_r2_r11_LSR_r7"},
    {{al, r3, r2, LSL, r10}, false, al, "al r3 r2 LSL r10", "al_r3_r2_LSL_r10"},
    {{al, r9, r12, ROR, r10},
     false,
     al,
     "al r9 r12 ROR r10",
     "al_r9_r12_ROR_r10"},
    {{al, r7, r14, ASR, r7}, false, al, "al r7 r14 ASR r7", "al_r7_r14_ASR_r7"},
    {{al, r2, r10, ROR, r4}, false, al, "al r2 r10 ROR r4", "al_r2_r10_ROR_r4"},
    {{al, r14, r6, LSL, r14},
     false,
     al,
     "al r14 r6 LSL r14",
     "al_r14_r6_LSL_r14"},
    {{al, r1, r10, LSL, r10},
     false,
     al,
     "al r1 r10 LSL r10",
     "al_r1_r10_LSL_r10"},
    {{al, r5, r8, LSR, r3}, false, al, "al r5 r8 LSR r3", "al_r5_r8_LSR_r3"},
    {{al, r11, r6, ASR, r1}, false, al, "al r11 r6 ASR r1", "al_r11_r6_ASR_r1"},
    {{al, r11, r1, ROR, r1}, false, al, "al r11 r1 ROR r1", "al_r11_r1_ROR_r1"},
    {{al, r5, r6, LSL, r9}, false, al, "al r5 r6 LSL r9", "al_r5_r6_LSL_r9"},
    {{al, r9, r0, LSL, r0}, false, al, "al r9 r0 LSL r0", "al_r9_r0_LSL_r0"},
    {{al, r1, r12, LSL, r4}, false, al, "al r1 r12 LSL r4", "al_r1_r12_LSL_r4"},
    {{al, r14, r4, LSR, r10},
     false,
     al,
     "al r14 r4 LSR r10",
     "al_r14_r4_LSR_r10"},
    {{al, r6, r2, LSL, r5}, false, al, "al r6 r2 LSL r5", "al_r6_r2_LSL_r5"},
    {{al, r7, r9, ROR, r6}, false, al, "al r7 r9 ROR r6", "al_r7_r9_ROR_r6"},
    {{al, r14, r8, ROR, r0}, false, al, "al r14 r8 ROR r0", "al_r14_r8_ROR_r0"},
    {{al, r10, r3, LSR, r4}, false, al, "al r10 r3 LSR r4", "al_r10_r3_LSR_r4"},
    {{al, r4, r0, ASR, r10}, false, al, "al r4 r0 ASR r10", "al_r4_r0_ASR_r10"},
    {{al, r10, r2, LSL, r0}, false, al, "al r10 r2 LSL r0", "al_r10_r2_LSL_r0"},
    {{al, r1, r14, LSR, r7}, false, al, "al r1 r14 LSR r7", "al_r1_r14_LSR_r7"},
    {{al, r7, r0, LSR, r3}, false, al, "al r7 r0 LSR r3", "al_r7_r0_LSR_r3"},
    {{al, r10, r11, LSR, r3},
     false,
     al,
     "al r10 r11 LSR r3",
     "al_r10_r11_LSR_r3"},
    {{al, r7, r8, ROR, r12}, false, al, "al r7 r8 ROR r12", "al_r7_r8_ROR_r12"},
    {{al, r10, r5, LSL, r5}, false, al, "al r10 r5 LSL r5", "al_r10_r5_LSL_r5"},
    {{al, r11, r11, ROR, r12},
     false,
     al,
     "al r11 r11 ROR r12",
     "al_r11_r11_ROR_r12"},
    {{al, r2, r7, ASR, r6}, false, al, "al r2 r7 ASR r6", "al_r2_r7_ASR_r6"},
    {{al, r8, r6, LSR, r14}, false, al, "al r8 r6 LSR r14", "al_r8_r6_LSR_r14"},
    {{al, r9, r13, ASR, r3}, false, al, "al r9 r13 ASR r3", "al_r9_r13_ASR_r3"},
    {{al, r11, r6, LSR, r5}, false, al, "al r11 r6 LSR r5", "al_r11_r6_LSR_r5"},
    {{al, r4, r11, ROR, r1}, false, al, "al r4 r11 ROR r1", "al_r4_r11_ROR_r1"},
    {{al, r2, r10, ROR, r5}, false, al, "al r2 r10 ROR r5", "al_r2_r10_ROR_r5"},
    {{al, r11, r10, LSL, r10},
     false,
     al,
     "al r11 r10 LSL r10",
     "al_r11_r10_LSL_r10"},
    {{al, r0, r2, ROR, r4}, false, al, "al r0 r2 ROR r4", "al_r0_r2_ROR_r4"},
    {{al, r0, r0, LSL, r7}, false, al, "al r0 r0 LSL r7", "al_r0_r0_LSL_r7"},
    {{al, r12, r2, ASR, r11},
     false,
     al,
     "al r12 r2 ASR r11",
     "al_r12_r2_ASR_r11"},
    {{al, r10, r2, ASR, r0}, false, al, "al r10 r2 ASR r0", "al_r10_r2_ASR_r0"},
    {{al, r14, r1, LSL, r0}, false, al, "al r14 r1 LSL r0", "al_r14_r1_LSL_r0"},
    {{al, r8, r3, LSL, r12}, false, al, "al r8 r3 LSL r12", "al_r8_r3_LSL_r12"},
    {{al, r6, r14, ROR, r10},
     false,
     al,
     "al r6 r14 ROR r10",
     "al_r6_r14_ROR_r10"},
    {{al, r13, r0, LSL, r3}, false, al, "al r13 r0 LSL r3", "al_r13_r0_LSL_r3"},
    {{al, r13, r6, ROR, r0}, false, al, "al r13 r6 ROR r0", "al_r13_r6_ROR_r0"},
    {{al, r3, r14, LSL, r11},
     false,
     al,
     "al r3 r14 LSL r11",
     "al_r3_r14_LSL_r11"},
    {{al, r1, r4, LSR, r1}, false, al, "al r1 r4 LSR r1", "al_r1_r4_LSR_r1"},
    {{al, r6, r1, LSR, r1}, false, al, "al r6 r1 LSR r1", "al_r6_r1_LSR_r1"},
    {{al, r14, r8, ASR, r14},
     false,
     al,
     "al r14 r8 ASR r14",
     "al_r14_r8_ASR_r14"},
    {{al, r3, r14, LSL, r12},
     false,
     al,
     "al r3 r14 LSL r12",
     "al_r3_r14_LSL_r12"},
    {{al, r8, r9, LSR, r7}, false, al, "al r8 r9 LSR r7", "al_r8_r9_LSR_r7"},
    {{al, r1, r6, LSL, r9}, false, al, "al r1 r6 LSL r9", "al_r1_r6_LSL_r9"},
    {{al, r11, r14, ROR, r6},
     false,
     al,
     "al r11 r14 ROR r6",
     "al_r11_r14_ROR_r6"},
    {{al, r2, r3, ROR, r2}, false, al, "al r2 r3 ROR r2", "al_r2_r3_ROR_r2"},
    {{al, r13, r12, ASR, r3},
     false,
     al,
     "al r13 r12 ASR r3",
     "al_r13_r12_ASR_r3"},
    {{al, r1, r14, ASR, r11},
     false,
     al,
     "al r1 r14 ASR r11",
     "al_r1_r14_ASR_r11"},
    {{al, r14, r6, LSR, r3}, false, al, "al r14 r6 LSR r3", "al_r14_r6_LSR_r3"},
    {{al, r11, r8, LSR, r11},
     false,
     al,
     "al r11 r8 LSR r11",
     "al_r11_r8_LSR_r11"},
    {{al, r0, r4, LSL, r10}, false, al, "al r0 r4 LSL r10", "al_r0_r4_LSL_r10"},
    {{al, r1, r4, LSL, r13}, false, al, "al r1 r4 LSL r13", "al_r1_r4_LSL_r13"},
    {{al, r4, r4, LSR, r6}, false, al, "al r4 r4 LSR r6", "al_r4_r4_LSR_r6"},
    {{al, r3, r5, LSR, r8}, false, al, "al r3 r5 LSR r8", "al_r3_r5_LSR_r8"},
    {{al, r7, r8, LSL, r11}, false, al, "al r7 r8 LSL r11", "al_r7_r8_LSL_r11"},
    {{al, r12, r6, ROR, r7}, false, al, "al r12 r6 ROR r7", "al_r12_r6_ROR_r7"},
    {{al, r14, r11, ASR, r14},
     false,
     al,
     "al r14 r11 ASR r14",
     "al_r14_r11_ASR_r14"},
    {{al, r3, r10, LSL, r5}, false, al, "al r3 r10 LSL r5", "al_r3_r10_LSL_r5"},
    {{al, r4, r7, ASR, r7}, false, al, "al r4 r7 ASR r7", "al_r4_r7_ASR_r7"},
    {{al, r8, r8, LSL, r14}, false, al, "al r8 r8 LSL r14", "al_r8_r8_LSL_r14"},
    {{al, r0, r5, LSL, r13}, false, al, "al r0 r5 LSL r13", "al_r0_r5_LSL_r13"},
    {{al, r7, r13, LSL, r14},
     false,
     al,
     "al r7 r13 LSL r14",
     "al_r7_r13_LSL_r14"},
    {{al, r13, r12, LSL, r5},
     false,
     al,
     "al r13 r12 LSL r5",
     "al_r13_r12_LSL_r5"},
    {{al, r7, r2, LSR, r13}, false, al, "al r7 r2 LSR r13", "al_r7_r2_LSR_r13"},
    {{al, r14, r1, LSR, r4}, false, al, "al r14 r1 LSR r4", "al_r14_r1_LSR_r4"},
    {{al, r5, r1, ROR, r2}, false, al, "al r5 r1 ROR r2", "al_r5_r1_ROR_r2"},
    {{al, r10, r6, LSL, r4}, false, al, "al r10 r6 LSL r4", "al_r10_r6_LSL_r4"},
    {{al, r6, r10, ROR, r10},
     false,
     al,
     "al r6 r10 ROR r10",
     "al_r6_r10_ROR_r10"},
    {{al, r5, r12, ROR, r3}, false, al, "al r5 r12 ROR r3", "al_r5_r12_ROR_r3"},
    {{al, r9, r5, ROR, r4}, false, al, "al r9 r5 ROR r4", "al_r9_r5_ROR_r4"},
    {{al, r10, r7, LSR, r11},
     false,
     al,
     "al r10 r7 LSR r11",
     "al_r10_r7_LSR_r11"},
    {{al, r14, r9, LSL, r6}, false, al, "al r14 r9 LSL r6", "al_r14_r9_LSL_r6"},
    {{al, r2, r3, ASR, r9}, false, al, "al r2 r3 ASR r9", "al_r2_r3_ASR_r9"},
    {{al, r1, r14, ROR, r9}, false, al, "al r1 r14 ROR r9", "al_r1_r14_ROR_r9"},
    {{al, r11, r2, LSR, r5}, false, al, "al r11 r2 LSR r5", "al_r11_r2_LSR_r5"},
    {{al, r3, r5, LSR, r2}, false, al, "al r3 r5 LSR r2", "al_r3_r5_LSR_r2"},
    {{al, r6, r5, ASR, r0}, false, al, "al r6 r5 ASR r0", "al_r6_r5_ASR_r0"},
    {{al, r9, r9, LSR, r0}, false, al, "al r9 r9 LSR r0", "al_r9_r9_LSR_r0"},
    {{al, r6, r5, LSR, r7}, false, al, "al r6 r5 LSR r7", "al_r6_r5_LSR_r7"},
    {{al, r5, r2, ROR, r10}, false, al, "al r5 r2 ROR r10", "al_r5_r2_ROR_r10"},
    {{al, r14, r0, ROR, r6}, false, al, "al r14 r0 ROR r6", "al_r14_r0_ROR_r6"},
    {{al, r14, r8, LSR, r12},
     false,
     al,
     "al r14 r8 LSR r12",
     "al_r14_r8_LSR_r12"},
    {{al, r8, r0, LSL, r2}, false, al, "al r8 r0 LSL r2", "al_r8_r0_LSL_r2"},
    {{al, r9, r11, LSL, r3}, false, al, "al r9 r11 LSL r3", "al_r9_r11_LSL_r3"},
    {{al, r6, r2, LSL, r12}, false, al, "al r6 r2 LSL r12", "al_r6_r2_LSL_r12"},
    {{al, r6, r3, LSL, r6}, false, al, "al r6 r3 LSL r6", "al_r6_r3_LSL_r6"},
    {{al, r3, r11, ROR, r7}, false, al, "al r3 r11 ROR r7", "al_r3_r11_ROR_r7"},
    {{al, r10, r1, LSL, r13},
     false,
     al,
     "al r10 r1 LSL r13",
     "al_r10_r1_LSL_r13"},
    {{al, r0, r8, ASR, r3}, false, al, "al r0 r8 ASR r3", "al_r0_r8_ASR_r3"},
    {{al, r8, r9, LSL, r10}, false, al, "al r8 r9 LSL r10", "al_r8_r9_LSL_r10"},
    {{al, r0, r11, ROR, r7}, false, al, "al r0 r11 ROR r7", "al_r0_r11_ROR_r7"},
    {{al, r12, r5, LSL, r13},
     false,
     al,
     "al r12 r5 LSL r13",
     "al_r12_r5_LSL_r13"},
    {{al, r6, r12, LSL, r13},
     false,
     al,
     "al r6 r12 LSL r13",
     "al_r6_r12_LSL_r13"},
    {{al, r5, r0, ROR, r1}, false, al, "al r5 r0 ROR r1", "al_r5_r0_ROR_r1"},
    {{al, r5, r6, ROR, r3}, false, al, "al r5 r6 ROR r3", "al_r5_r6_ROR_r3"},
    {{al, r13, r2, ASR, r12},
     false,
     al,
     "al r13 r2 ASR r12",
     "al_r13_r2_ASR_r12"},
    {{al, r14, r7, ROR, r4}, false, al, "al r14 r7 ROR r4", "al_r14_r7_ROR_r4"},
    {{al, r14, r2, ASR, r9}, false, al, "al r14 r2 ASR r9", "al_r14_r2_ASR_r9"},
    {{al, r11, r12, LSR, r6},
     false,
     al,
     "al r11 r12 LSR r6",
     "al_r11_r12_LSR_r6"},
    {{al, r11, r7, ROR, r5}, false, al, "al r11 r7 ROR r5", "al_r11_r7_ROR_r5"},
    {{al, r5, r6, LSR, r13}, false, al, "al r5 r6 LSR r13", "al_r5_r6_LSR_r13"},
    {{al, r4, r10, ASR, r11},
     false,
     al,
     "al r4 r10 ASR r11",
     "al_r4_r10_ASR_r11"},
    {{al, r8, r9, ROR, r2}, false, al, "al r8 r9 ROR r2", "al_r8_r9_ROR_r2"},
    {{al, r7, r2, LSL, r7}, false, al, "al r7 r2 LSL r7", "al_r7_r2_LSL_r7"},
    {{al, r6, r0, LSR, r1}, false, al, "al r6 r0 LSR r1", "al_r6_r0_LSR_r1"},
    {{al, r0, r3, ASR, r4}, false, al, "al r0 r3 ASR r4", "al_r0_r3_ASR_r4"},
    {{al, r2, r3, ASR, r12}, false, al, "al r2 r3 ASR r12", "al_r2_r3_ASR_r12"},
    {{al, r11, r6, LSL, r5}, false, al, "al r11 r6 LSL r5", "al_r11_r6_LSL_r5"},
    {{al, r9, r7, LSL, r11}, false, al, "al r9 r7 LSL r11", "al_r9_r7_LSL_r11"},
    {{al, r2, r1, LSR, r13}, false, al, "al r2 r1 LSR r13", "al_r2_r1_LSR_r13"},
    {{al, r3, r8, ROR, r2}, false, al, "al r3 r8 ROR r2", "al_r3_r8_ROR_r2"},
    {{al, r0, r6, LSR, r5}, false, al, "al r0 r6 LSR r5", "al_r0_r6_LSR_r5"},
    {{al, r6, r8, ASR, r4}, false, al, "al r6 r8 ASR r4", "al_r6_r8_ASR_r4"},
    {{al, r12, r3, LSL, r3}, false, al, "al r12 r3 LSL r3", "al_r12_r3_LSL_r3"},
    {{al, r2, r7, ASR, r5}, false, al, "al r2 r7 ASR r5", "al_r2_r7_ASR_r5"},
    {{al, r14, r10, LSL, r6},
     false,
     al,
     "al r14 r10 LSL r6",
     "al_r14_r10_LSL_r6"},
    {{al, r1, r3, LSR, r6}, false, al, "al r1 r3 LSR r6", "al_r1_r3_LSR_r6"},
    {{al, r8, r8, ROR, r14}, false, al, "al r8 r8 ROR r14", "al_r8_r8_ROR_r14"},
    {{al, r7, r6, LSL, r0}, false, al, "al r7 r6 LSL r0", "al_r7_r6_LSL_r0"},
    {{al, r11, r6, LSR, r14},
     false,
     al,
     "al r11 r6 LSR r14",
     "al_r11_r6_LSR_r14"},
    {{al, r8, r3, ROR, r3}, false, al, "al r8 r3 ROR r3", "al_r8_r3_ROR_r3"},
    {{al, r6, r0, LSR, r7}, false, al, "al r6 r0 LSR r7", "al_r6_r0_LSR_r7"},
    {{al, r2, r2, ASR, r0}, false, al, "al r2 r2 ASR r0", "al_r2_r2_ASR_r0"},
    {{al, r14, r8, LSL, r2}, false, al, "al r14 r8 LSL r2", "al_r14_r8_LSL_r2"},
    {{al, r14, r8, LSR, r1}, false, al, "al r14 r8 LSR r1", "al_r14_r8_LSR_r1"},
    {{al, r10, r2, ROR, r11},
     false,
     al,
     "al r10 r2 ROR r11",
     "al_r10_r2_ROR_r11"},
    {{al, r9, r9, ASR, r6}, false, al, "al r9 r9 ASR r6", "al_r9_r9_ASR_r6"},
    {{al, r8, r13, LSL, r10},
     false,
     al,
     "al r8 r13 LSL r10",
     "al_r8_r13_LSL_r10"},
    {{al, r14, r11, ROR, r3},
     false,
     al,
     "al r14 r11 ROR r3",
     "al_r14_r11_ROR_r3"},
    {{al, r4, r6, ROR, r10}, false, al, "al r4 r6 ROR r10", "al_r4_r6_ROR_r10"},
    {{al, r7, r1, LSR, r4}, false, al, "al r7 r1 LSR r4", "al_r7_r1_LSR_r4"},
    {{al, r12, r8, ROR, r10},
     false,
     al,
     "al r12 r8 ROR r10",
     "al_r12_r8_ROR_r10"},
    {{al, r3, r8, LSL, r12}, false, al, "al r3 r8 LSL r12", "al_r3_r8_LSL_r12"},
    {{al, r1, r1, LSR, r8}, false, al, "al r1 r1 LSR r8", "al_r1_r1_LSR_r8"},
    {{al, r0, r11, ASR, r0}, false, al, "al r0 r11 ASR r0", "al_r0_r11_ASR_r0"},
    {{al, r7, r6, ROR, r7}, false, al, "al r7 r6 ROR r7", "al_r7_r6_ROR_r7"},
    {{al, r8, r7, LSL, r2}, false, al, "al r8 r7 LSL r2", "al_r8_r7_LSL_r2"},
    {{al, r7, r1, ASR, r6}, false, al, "al r7 r1 ASR r6", "al_r7_r1_ASR_r6"},
    {{al, r5, r7, ROR, r12}, false, al, "al r5 r7 ROR r12", "al_r5_r7_ROR_r12"},
    {{al, r10, r13, LSR, r9},
     false,
     al,
     "al r10 r13 LSR r9",
     "al_r10_r13_LSR_r9"},
    {{al, r11, r4, ROR, r6}, false, al, "al r11 r4 ROR r6", "al_r11_r4_ROR_r6"},
    {{al, r6, r11, LSR, r4}, false, al, "al r6 r11 LSR r4", "al_r6_r11_LSR_r4"},
    {{al, r7, r2, ASR, r6}, false, al, "al r7 r2 ASR r6", "al_r7_r2_ASR_r6"},
    {{al, r3, r13, ROR, r9}, false, al, "al r3 r13 ROR r9", "al_r3_r13_ROR_r9"},
    {{al, r0, r1, ASR, r4}, false, al, "al r0 r1 ASR r4", "al_r0_r1_ASR_r4"},
    {{al, r6, r12, LSR, r9}, false, al, "al r6 r12 LSR r9", "al_r6_r12_LSR_r9"},
    {{al, r1, r9, ROR, r9}, false, al, "al r1 r9 ROR r9", "al_r1_r9_ROR_r9"},
    {{al, r9, r0, ROR, r12}, false, al, "al r9 r0 ROR r12", "al_r9_r0_ROR_r12"},
    {{al, r14, r9, ROR, r8}, false, al, "al r14 r9 ROR r8", "al_r14_r9_ROR_r8"},
    {{al, r13, r6, LSL, r4}, false, al, "al r13 r6 LSL r4", "al_r13_r6_LSL_r4"},
    {{al, r2, r5, ROR, r2}, false, al, "al r2 r5 ROR r2", "al_r2_r5_ROR_r2"},
    {{al, r3, r4, LSR, r6}, false, al, "al r3 r4 LSR r6", "al_r3_r4_LSR_r6"},
    {{al, r0, r14, ROR, r2}, false, al, "al r0 r14 ROR r2", "al_r0_r14_ROR_r2"},
    {{al, r8, r13, ASR, r9}, false, al, "al r8 r13 ASR r9", "al_r8_r13_ASR_r9"},
    {{al, r1, r11, ROR, r4}, false, al, "al r1 r11 ROR r4", "al_r1_r11_ROR_r4"},
    {{al, r1, r12, LSL, r2}, false, al, "al r1 r12 LSL r2", "al_r1_r12_LSL_r2"},
    {{al, r12, r9, ROR, r7}, false, al, "al r12 r9 ROR r7", "al_r12_r9_ROR_r7"},
    {{al, r1, r13, ROR, r3}, false, al, "al r1 r13 ROR r3", "al_r1_r13_ROR_r3"},
    {{al, r0, r14, ASR, r8}, false, al, "al r0 r14 ASR r8", "al_r0_r14_ASR_r8"},
    {{al, r13, r13, ASR, r13},
     false,
     al,
     "al r13 r13 ASR r13",
     "al_r13_r13_ASR_r13"},
    {{al, r3, r4, ASR, r1}, false, al, "al r3 r4 ASR r1", "al_r3_r4_ASR_r1"},
    {{al, r6, r0, ASR, r10}, false, al, "al r6 r0 ASR r10", "al_r6_r0_ASR_r10"},
    {{al, r12, r8, ROR, r4}, false, al, "al r12 r8 ROR r4", "al_r12_r8_ROR_r4"},
    {{al, r1, r12, ASR, r10},
     false,
     al,
     "al r1 r12 ASR r10",
     "al_r1_r12_ASR_r10"},
    {{al, r8, r11, ROR, r8}, false, al, "al r8 r11 ROR r8", "al_r8_r11_ROR_r8"},
    {{al, r3, r3, LSL, r13}, false, al, "al r3 r3 LSL r13", "al_r3_r3_LSL_r13"},
    {{al, r6, r6, ASR, r1}, false, al, "al r6 r6 ASR r1", "al_r6_r6_ASR_r1"},
    {{al, r4, r10, LSR, r12},
     false,
     al,
     "al r4 r10 LSR r12",
     "al_r4_r10_LSR_r12"},
    {{al, r7, r0, ASR, r11}, false, al, "al r7 r0 ASR r11", "al_r7_r0_ASR_r11"},
    {{al, r10, r11, LSR, r7},
     false,
     al,
     "al r10 r11 LSR r7",
     "al_r10_r11_LSR_r7"},
    {{al, r14, r3, ROR, r0}, false, al, "al r14 r3 ROR r0", "al_r14_r3_ROR_r0"},
    {{al, r8, r1, ASR, r2}, false, al, "al r8 r1 ASR r2", "al_r8_r1_ASR_r2"},
    {{al, r14, r3, ASR, r13},
     false,
     al,
     "al r14 r3 ASR r13",
     "al_r14_r3_ASR_r13"},
    {{al, r9, r1, ROR, r10}, false, al, "al r9 r1 ROR r10", "al_r9_r1_ROR_r10"},
    {{al, r1, r9, LSL, r1}, false, al, "al r1 r9 LSL r1", "al_r1_r9_LSL_r1"},
    {{al, r14, r2, ROR, r6}, false, al, "al r14 r2 ROR r6", "al_r14_r2_ROR_r6"},
    {{al, r8, r6, ASR, r5}, false, al, "al r8 r6 ASR r5", "al_r8_r6_ASR_r5"},
    {{al, r13, r10, ROR, r9},
     false,
     al,
     "al r13 r10 ROR r9",
     "al_r13_r10_ROR_r9"},
    {{al, r6, r10, ASR, r4}, false, al, "al r6 r10 ASR r4", "al_r6_r10_ASR_r4"},
    {{al, r7, r14, ASR, r11},
     false,
     al,
     "al r7 r14 ASR r11",
     "al_r7_r14_ASR_r11"},
    {{al, r4, r8, LSL, r7}, false, al, "al r4 r8 LSL r7", "al_r4_r8_LSL_r7"},
    {{al, r10, r6, ASR, r12},
     false,
     al,
     "al r10 r6 ASR r12",
     "al_r10_r6_ASR_r12"},
    {{al, r12, r6, ASR, r0}, false, al, "al r12 r6 ASR r0", "al_r12_r6_ASR_r0"},
    {{al, r3, r5, LSR, r4}, false, al, "al r3 r5 LSR r4", "al_r3_r5_LSR_r4"},
    {{al, r5, r11, ASR, r11},
     false,
     al,
     "al r5 r11 ASR r11",
     "al_r5_r11_ASR_r11"},
    {{al, r8, r7, LSL, r9}, false, al, "al r8 r7 LSL r9", "al_r8_r7_LSL_r9"},
    {{al, r13, r8, LSR, r10},
     false,
     al,
     "al r13 r8 LSR r10",
     "al_r13_r8_LSR_r10"},
    {{al, r13, r1, ROR, r7}, false, al, "al r13 r1 ROR r7", "al_r13_r1_ROR_r7"},
    {{al, r11, r6, LSL, r11},
     false,
     al,
     "al r11 r6 LSL r11",
     "al_r11_r6_LSL_r11"},
    {{al, r8, r4, ROR, r9}, false, al, "al r8 r4 ROR r9", "al_r8_r4_ROR_r9"},
    {{al, r6, r12, LSL, r0}, false, al, "al r6 r12 LSL r0", "al_r6_r12_LSL_r0"},
    {{al, r7, r4, LSR, r6}, false, al, "al r7 r4 LSR r6", "al_r7_r4_LSR_r6"},
    {{al, r3, r7, ROR, r8}, false, al, "al r3 r7 ROR r8", "al_r3_r7_ROR_r8"},
    {{al, r0, r10, ASR, r11},
     false,
     al,
     "al r0 r10 ASR r11",
     "al_r0_r10_ASR_r11"},
    {{al, r2, r8, ASR, r9}, false, al, "al r2 r8 ASR r9", "al_r2_r8_ASR_r9"},
    {{al, r10, r3, ASR, r9}, false, al, "al r10 r3 ASR r9", "al_r10_r3_ASR_r9"},
    {{al, r7, r5, ROR, r13}, false, al, "al r7 r5 ROR r13", "al_r7_r5_ROR_r13"},
    {{al, r11, r4, LSR, r11},
     false,
     al,
     "al r11 r4 LSR r11",
     "al_r11_r4_LSR_r11"},
    {{al, r1, r9, ASR, r13}, false, al, "al r1 r9 ASR r13", "al_r1_r9_ASR_r13"},
    {{al, r5, r9, LSL, r10}, false, al, "al r5 r9 LSL r10", "al_r5_r9_LSL_r10"},
    {{al, r3, r12, LSL, r5}, false, al, "al r3 r12 LSL r5", "al_r3_r12_LSL_r5"},
    {{al, r8, r2, LSR, r0}, false, al, "al r8 r2 LSR r0", "al_r8_r2_LSR_r0"},
    {{al, r2, r2, LSL, r7}, false, al, "al r2 r2 LSL r7", "al_r2_r2_LSL_r7"},
    {{al, r8, r11, LSL, r3}, false, al, "al r8 r11 LSL r3", "al_r8_r11_LSL_r3"},
    {{al, r0, r13, ASR, r13},
     false,
     al,
     "al r0 r13 ASR r13",
     "al_r0_r13_ASR_r13"},
    {{al, r14, r6, LSR, r2}, false, al, "al r14 r6 LSR r2", "al_r14_r6_LSR_r2"},
    {{al, r3, r5, ROR, r9}, false, al, "al r3 r5 ROR r9", "al_r3_r5_ROR_r9"},
    {{al, r13, r12, LSR, r10},
     false,
     al,
     "al r13 r12 LSR r10",
     "al_r13_r12_LSR_r10"},
    {{al, r1, r3, LSL, r10}, false, al, "al r1 r3 LSL r10", "al_r1_r3_LSL_r10"},
    {{al, r2, r7, LSL, r7}, false, al, "al r2 r7 LSL r7", "al_r2_r7_LSL_r7"},
    {{al, r10, r13, LSL, r10},
     false,
     al,
     "al r10 r13 LSL r10",
     "al_r10_r13_LSL_r10"},
    {{al, r2, r2, ROR, r1}, false, al, "al r2 r2 ROR r1", "al_r2_r2_ROR_r1"},
    {{al, r6, r3, ROR, r1}, false, al, "al r6 r3 ROR r1", "al_r6_r3_ROR_r1"},
    {{al, r12, r1, LSL, r4}, false, al, "al r12 r1 LSL r4", "al_r12_r1_LSL_r4"},
    {{al, r3, r13, LSR, r3}, false, al, "al r3 r13 LSR r3", "al_r3_r13_LSR_r3"},
    {{al, r10, r10, ROR, r10},
     false,
     al,
     "al r10 r10 ROR r10",
     "al_r10_r10_ROR_r10"},
    {{al, r0, r11, LSL, r5}, false, al, "al r0 r11 LSL r5", "al_r0_r11_LSL_r5"},
    {{al, r4, r9, ASR, r10}, false, al, "al r4 r9 ASR r10", "al_r4_r9_ASR_r10"},
    {{al, r2, r3, ASR, r5}, false, al, "al r2 r3 ASR r5", "al_r2_r3_ASR_r5"},
    {{al, r1, r1, LSR, r0}, false, al, "al r1 r1 LSR r0", "al_r1_r1_LSR_r0"},
    {{al, r8, r9, LSL, r4}, false, al, "al r8 r9 LSL r4", "al_r8_r9_LSL_r4"},
    {{al, r4, r13, ROR, r6}, false, al, "al r4 r13 ROR r6", "al_r4_r13_ROR_r6"},
    {{al, r3, r10, LSL, r8}, false, al, "al r3 r10 LSL r8", "al_r3_r10_LSL_r8"},
    {{al, r10, r11, LSL, r11},
     false,
     al,
     "al r10 r11 LSL r11",
     "al_r10_r11_LSL_r11"},
    {{al, r9, r2, ASR, r1}, false, al, "al r9 r2 ASR r1", "al_r9_r2_ASR_r1"},
    {{al, r9, r4, ROR, r6}, false, al, "al r9 r4 ROR r6", "al_r9_r4_ROR_r6"},
    {{al, r11, r2, ROR, r5}, false, al, "al r11 r2 ROR r5", "al_r11_r2_ROR_r5"},
    {{al, r13, r13, LSL, r13},
     false,
     al,
     "al r13 r13 LSL r13",
     "al_r13_r13_LSL_r13"},
    {{al, r12, r7, LSL, r7}, false, al, "al r12 r7 LSL r7", "al_r12_r7_LSL_r7"},
    {{al, r6, r1, LSL, r8}, false, al, "al r6 r1 LSL r8", "al_r6_r1_LSL_r8"},
    {{al, r14, r5, ASR, r3}, false, al, "al r14 r5 ASR r3", "al_r14_r5_ASR_r3"},
    {{al, r10, r2, ROR, r6}, false, al, "al r10 r2 ROR r6", "al_r10_r2_ROR_r6"},
    {{al, r9, r3, ASR, r3}, false, al, "al r9 r3 ASR r3", "al_r9_r3_ASR_r3"},
    {{al, r11, r11, LSL, r11},
     false,
     al,
     "al r11 r11 LSL r11",
     "al_r11_r11_LSL_r11"},
    {{al, r0, r10, ASR, r14},
     false,
     al,
     "al r0 r10 ASR r14",
     "al_r0_r10_ASR_r14"},
    {{al, r5, r6, ROR, r1}, false, al, "al r5 r6 ROR r1", "al_r5_r6_ROR_r1"},
    {{al, r11, r8, ASR, r9}, false, al, "al r11 r8 ASR r9", "al_r11_r8_ASR_r9"},
    {{al, r11, r7, ROR, r6}, false, al, "al r11 r7 ROR r6", "al_r11_r7_ROR_r6"},
    {{al, r2, r12, ASR, r10},
     false,
     al,
     "al r2 r12 ASR r10",
     "al_r2_r12_ASR_r10"},
    {{al, r12, r1, ASR, r12},
     false,
     al,
     "al r12 r1 ASR r12",
     "al_r12_r1_ASR_r12"},
    {{al, r8, r11, LSR, r6}, false, al, "al r8 r11 LSR r6", "al_r8_r11_LSR_r6"},
    {{al, r12, r14, LSR, r13},
     false,
     al,
     "al r12 r14 LSR r13",
     "al_r12_r14_LSR_r13"},
    {{al, r0, r2, ASR, r6}, false, al, "al r0 r2 ASR r6", "al_r0_r2_ASR_r6"},
    {{al, r1, r7, ASR, r4}, false, al, "al r1 r7 ASR r4", "al_r1_r7_ASR_r4"},
    {{al, r6, r8, LSR, r8}, false, al, "al r6 r8 LSR r8", "al_r6_r8_LSR_r8"},
    {{al, r2, r8, LSL, r3}, false, al, "al r2 r8 LSL r3", "al_r2_r8_LSL_r3"},
    {{al, r2, r7, LSR, r0}, false, al, "al r2 r7 LSR r0", "al_r2_r7_LSR_r0"},
    {{al, r2, r9, ASR, r4}, false, al, "al r2 r9 ASR r4", "al_r2_r9_ASR_r4"},
    {{al, r9, r9, ASR, r7}, false, al, "al r9 r9 ASR r7", "al_r9_r9_ASR_r7"},
    {{al, r12, r9, LSR, r8}, false, al, "al r12 r9 LSR r8", "al_r12_r9_LSR_r8"},
    {{al, r6, r2, LSL, r10}, false, al, "al r6 r2 LSL r10", "al_r6_r2_LSL_r10"},
    {{al, r0, r11, LSL, r11},
     false,
     al,
     "al r0 r11 LSL r11",
     "al_r0_r11_LSL_r11"},
    {{al, r5, r5, LSL, r14}, false, al, "al r5 r5 LSL r14", "al_r5_r5_LSL_r14"},
    {{al, r11, r14, ASR, r14},
     false,
     al,
     "al r11 r14 ASR r14",
     "al_r11_r14_ASR_r14"},
    {{al, r1, r14, ASR, r2}, false, al, "al r1 r14 ASR r2", "al_r1_r14_ASR_r2"},
    {{al, r4, r5, LSL, r0}, false, al, "al r4 r5 LSL r0", "al_r4_r5_LSL_r0"},
    {{al, r12, r5, ROR, r6}, false, al, "al r12 r5 ROR r6", "al_r12_r5_ROR_r6"},
    {{al, r4, r11, LSR, r4}, false, al, "al r4 r11 LSR r4", "al_r4_r11_LSR_r4"},
    {{al, r8, r13, LSL, r7}, false, al, "al r8 r13 LSL r7", "al_r8_r13_LSL_r7"},
    {{al, r2, r14, LSL, r7}, false, al, "al r2 r14 LSL r7", "al_r2_r14_LSL_r7"},
    {{al, r11, r9, ROR, r8}, false, al, "al r11 r9 ROR r8", "al_r11_r9_ROR_r8"},
    {{al, r8, r8, LSL, r2}, false, al, "al r8 r8 LSL r2", "al_r8_r8_LSL_r2"},
    {{al, r9, r10, LSR, r11},
     false,
     al,
     "al r9 r10 LSR r11",
     "al_r9_r10_LSR_r11"},
    {{al, r13, r7, LSL, r5}, false, al, "al r13 r7 LSL r5", "al_r13_r7_LSL_r5"},
    {{al, r11, r0, ROR, r13},
     false,
     al,
     "al r11 r0 ROR r13",
     "al_r11_r0_ROR_r13"},
    {{al, r13, r8, ASR, r1}, false, al, "al r13 r8 ASR r1", "al_r13_r8_ASR_r1"},
    {{al, r5, r9, ROR, r2}, false, al, "al r5 r9 ROR r2", "al_r5_r9_ROR_r2"},
    {{al, r9, r10, ROR, r5}, false, al, "al r9 r10 ROR r5", "al_r9_r10_ROR_r5"},
    {{al, r9, r2, LSL, r2}, false, al, "al r9 r2 LSL r2", "al_r9_r2_LSL_r2"},
    {{al, r1, r2, LSL, r4}, false, al, "al r1 r2 LSL r4", "al_r1_r2_LSL_r4"},
    {{al, r14, r5, LSL, r6}, false, al, "al r14 r5 LSL r6", "al_r14_r5_LSL_r6"},
    {{al, r7, r13, LSR, r1}, false, al, "al r7 r13 LSR r1", "al_r7_r13_LSR_r1"},
    {{al, r8, r2, ROR, r8}, false, al, "al r8 r2 ROR r8", "al_r8_r2_ROR_r8"},
    {{al, r11, r14, LSL, r10},
     false,
     al,
     "al r11 r14 LSL r10",
     "al_r11_r14_LSL_r10"},
    {{al, r8, r3, LSR, r1}, false, al, "al r8 r3 LSR r1", "al_r8_r3_LSR_r1"},
    {{al, r4, r14, ROR, r5}, false, al, "al r4 r14 ROR r5", "al_r4_r14_ROR_r5"},
    {{al, r6, r14, LSL, r0}, false, al, "al r6 r14 LSL r0", "al_r6_r14_LSL_r0"},
    {{al, r9, r12, ASR, r2}, false, al, "al r9 r12 ASR r2", "al_r9_r12_ASR_r2"},
    {{al, r3, r10, ROR, r6}, false, al, "al r3 r10 ROR r6", "al_r3_r10_ROR_r6"},
    {{al, r13, r6, ROR, r13},
     false,
     al,
     "al r13 r6 ROR r13",
     "al_r13_r6_ROR_r13"},
    {{al, r2, r6, ROR, r0}, false, al, "al r2 r6 ROR r0", "al_r2_r6_ROR_r0"},
    {{al, r0, r2, LSR, r13}, false, al, "al r0 r2 LSR r13", "al_r0_r2_LSR_r13"},
    {{al, r2, r8, ROR, r7}, false, al, "al r2 r8 ROR r7", "al_r2_r8_ROR_r7"},
    {{al, r0, r12, ROR, r7}, false, al, "al r0 r12 ROR r7", "al_r0_r12_ROR_r7"},
    {{al, r7, r12, ASR, r12},
     false,
     al,
     "al r7 r12 ASR r12",
     "al_r7_r12_ASR_r12"},
    {{al, r7, r8, ASR, r14}, false, al, "al r7 r8 ASR r14", "al_r7_r8_ASR_r14"},
    {{al, r6, r8, LSL, r10}, false, al, "al r6 r8 LSL r10", "al_r6_r8_LSL_r10"},
    {{al, r4, r3, LSL, r10}, false, al, "al r4 r3 LSL r10", "al_r4_r3_LSL_r10"},
    {{al, r9, r12, ASR, r12},
     false,
     al,
     "al r9 r12 ASR r12",
     "al_r9_r12_ASR_r12"},
    {{al, r14, r13, ASR, r8},
     false,
     al,
     "al r14 r13 ASR r8",
     "al_r14_r13_ASR_r8"},
    {{al, r12, r11, LSL, r5},
     false,
     al,
     "al r12 r11 LSL r5",
     "al_r12_r11_LSL_r5"},
    {{al, r8, r7, ASR, r11}, false, al, "al r8 r7 ASR r11", "al_r8_r7_ASR_r11"},
    {{al, r14, r2, ROR, r2}, false, al, "al r14 r2 ROR r2", "al_r14_r2_ROR_r2"},
    {{al, r12, r1, ROR, r3}, false, al, "al r12 r1 ROR r3", "al_r12_r1_ROR_r3"},
    {{al, r2, r8, LSR, r14}, false, al, "al r2 r8 LSR r14", "al_r2_r8_LSR_r14"},
    {{al, r10, r14, ASR, r14},
     false,
     al,
     "al r10 r14 ASR r14",
     "al_r10_r14_ASR_r14"},
    {{al, r4, r6, ASR, r8}, false, al, "al r4 r6 ASR r8", "al_r4_r6_ASR_r8"},
    {{al, r9, r0, ASR, r5}, false, al, "al r9 r0 ASR r5", "al_r9_r0_ASR_r5"},
    {{al, r5, r13, ASR, r3}, false, al, "al r5 r13 ASR r3", "al_r5_r13_ASR_r3"},
    {{al, r11, r6, LSR, r13},
     false,
     al,
     "al r11 r6 LSR r13",
     "al_r11_r6_LSR_r13"},
    {{al, r2, r8, ROR, r3}, false, al, "al r2 r8 ROR r3", "al_r2_r8_ROR_r3"},
    {{al, r12, r8, LSL, r2}, false, al, "al r12 r8 LSL r2", "al_r12_r8_LSL_r2"},
    {{al, r5, r1, ROR, r8}, false, al, "al r5 r1 ROR r8", "al_r5_r1_ROR_r8"},
    {{al, r10, r14, LSL, r10},
     false,
     al,
     "al r10 r14 LSL r10",
     "al_r10_r14_LSL_r10"},
    {{al, r10, r5, ASR, r5}, false, al, "al r10 r5 ASR r5", "al_r10_r5_ASR_r5"},
    {{al, r12, r13, LSR, r14},
     false,
     al,
     "al r12 r13 LSR r14",
     "al_r12_r13_LSR_r14"},
    {{al, r7, r0, ROR, r2}, false, al, "al r7 r0 ROR r2", "al_r7_r0_ROR_r2"},
    {{al, r3, r2, LSL, r6}, false, al, "al r3 r2 LSL r6", "al_r3_r2_LSL_r6"},
    {{al, r8, r12, LSL, r9}, false, al, "al r8 r12 LSL r9", "al_r8_r12_LSL_r9"},
    {{al, r7, r14, ROR, r2}, false, al, "al r7 r14 ROR r2", "al_r7_r14_ROR_r2"},
    {{al, r1, r0, ROR, r9}, false, al, "al r1 r0 ROR r9", "al_r1_r0_ROR_r9"},
    {{al, r11, r9, LSL, r11},
     false,
     al,
     "al r11 r9 LSL r11",
     "al_r11_r9_LSL_r11"},
    {{al, r2, r14, ROR, r2}, false, al, "al r2 r14 ROR r2", "al_r2_r14_ROR_r2"},
    {{al, r11, r2, LSL, r8}, false, al, "al r11 r2 LSL r8", "al_r11_r2_LSL_r8"},
    {{al, r12, r13, LSL, r9},
     false,
     al,
     "al r12 r13 LSL r9",
     "al_r12_r13_LSL_r9"},
    {{al, r8, r10, ROR, r9}, false, al, "al r8 r10 ROR r9", "al_r8_r10_ROR_r9"},
    {{al, r12, r4, ASR, r7}, false, al, "al r12 r4 ASR r7", "al_r12_r4_ASR_r7"},
    {{al, r7, r1, LSL, r6}, false, al, "al r7 r1 LSL r6", "al_r7_r1_LSL_r6"},
    {{al, r2, r2, LSL, r6}, false, al, "al r2 r2 LSL r6", "al_r2_r2_LSL_r6"},
    {{al, r14, r14, ASR, r13},
     false,
     al,
     "al r14 r14 ASR r13",
     "al_r14_r14_ASR_r13"},
    {{al, r14, r10, ROR, r4},
     false,
     al,
     "al r14 r10 ROR r4",
     "al_r14_r10_ROR_r4"},
    {{al, r2, r8, ROR, r6}, false, al, "al r2 r8 ROR r6", "al_r2_r8_ROR_r6"},
    {{al, r8, r6, ROR, r8}, false, al, "al r8 r6 ROR r8", "al_r8_r6_ROR_r8"},
    {{al, r13, r12, LSL, r11},
     false,
     al,
     "al r13 r12 LSL r11",
     "al_r13_r12_LSL_r11"},
    {{al, r11, r6, LSL, r10},
     false,
     al,
     "al r11 r6 LSL r10",
     "al_r11_r6_LSL_r10"},
    {{al, r11, r3, ASR, r12},
     false,
     al,
     "al r11 r3 ASR r12",
     "al_r11_r3_ASR_r12"},
    {{al, r13, r7, ROR, r3}, false, al, "al r13 r7 ROR r3", "al_r13_r7_ROR_r3"},
    {{al, r4, r7, LSR, r2}, false, al, "al r4 r7 LSR r2", "al_r4_r7_LSR_r2"},
    {{al, r3, r0, ROR, r7}, false, al, "al r3 r0 ROR r7", "al_r3_r0_ROR_r7"},
    {{al, r0, r6, LSL, r9}, false, al, "al r0 r6 LSL r9", "al_r0_r6_LSL_r9"},
    {{al, r13, r12, ASR, r4},
     false,
     al,
     "al r13 r12 ASR r4",
     "al_r13_r12_ASR_r4"},
    {{al, r1, r7, ROR, r9}, false, al, "al r1 r7 ROR r9", "al_r1_r7_ROR_r9"},
    {{al, r6, r9, ROR, r11}, false, al, "al r6 r9 ROR r11", "al_r6_r9_ROR_r11"},
    {{al, r9, r8, ROR, r0}, false, al, "al r9 r8 ROR r0", "al_r9_r8_ROR_r0"},
    {{al, r2, r11, LSR, r6}, false, al, "al r2 r11 LSR r6", "al_r2_r11_LSR_r6"},
    {{al, r10, r14, ASR, r1},
     false,
     al,
     "al r10 r14 ASR r1",
     "al_r10_r14_ASR_r1"},
    {{al, r7, r2, ROR, r0}, false, al, "al r7 r2 ROR r0", "al_r7_r2_ROR_r0"},
    {{al, r9, r4, ASR, r10}, false, al, "al r9 r4 ASR r10", "al_r9_r4_ASR_r10"},
    {{al, r11, r14, ROR, r13},
     false,
     al,
     "al r11 r14 ROR r13",
     "al_r11_r14_ROR_r13"},
    {{al, r9, r2, ASR, r8}, false, al, "al r9 r2 ASR r8", "al_r9_r2_ASR_r8"},
    {{al, r6, r8, LSR, r0}, false, al, "al r6 r8 LSR r0", "al_r6_r8_LSR_r0"},
    {{al, r4, r6, ASR, r1}, false, al, "al r4 r6 ASR r1", "al_r4_r6_ASR_r1"},
    {{al, r7, r12, LSR, r11},
     false,
     al,
     "al r7 r12 LSR r11",
     "al_r7_r12_LSR_r11"},
    {{al, r2, r2, LSL, r14}, false, al, "al r2 r2 LSL r14", "al_r2_r2_LSL_r14"},
    {{al, r10, r0, ASR, r3}, false, al, "al r10 r0 ASR r3", "al_r10_r0_ASR_r3"},
    {{al, r14, r13, LSL, r12},
     false,
     al,
     "al r14 r13 LSL r12",
     "al_r14_r13_LSL_r12"},
    {{al, r7, r1, ASR, r10}, false, al, "al r7 r1 ASR r10", "al_r7_r1_ASR_r10"},
    {{al, r9, r13, LSL, r4}, false, al, "al r9 r13 LSL r4", "al_r9_r13_LSL_r4"},
    {{al, r2, r9, ASR, r13}, false, al, "al r2 r9 ASR r13", "al_r2_r9_ASR_r13"},
    {{al, r9, r11, LSL, r0}, false, al, "al r9 r11 LSL r0", "al_r9_r11_LSL_r0"},
    {{al, r4, r12, LSR, r0}, false, al, "al r4 r12 LSR r0", "al_r4_r12_LSR_r0"},
    {{al, r8, r13, ROR, r14},
     false,
     al,
     "al r8 r13 ROR r14",
     "al_r8_r13_ROR_r14"},
    {{al, r0, r10, LSL, r14},
     false,
     al,
     "al r0 r10 LSL r14",
     "al_r0_r10_LSL_r14"},
    {{al, r0, r2, ASR, r9}, false, al, "al r0 r2 ASR r9", "al_r0_r2_ASR_r9"},
    {{al, r14, r11, ASR, r5},
     false,
     al,
     "al r14 r11 ASR r5",
     "al_r14_r11_ASR_r5"},
    {{al, r8, r9, ROR, r4}, false, al, "al r8 r9 ROR r4", "al_r8_r9_ROR_r4"},
    {{al, r8, r10, ASR, r8}, false, al, "al r8 r10 ASR r8", "al_r8_r10_ASR_r8"},
    {{al, r2, r8, ASR, r4}, false, al, "al r2 r8 ASR r4", "al_r2_r8_ASR_r4"},
    {{al, r2, r0, ROR, r6}, false, al, "al r2 r0 ROR r6", "al_r2_r0_ROR_r6"},
    {{al, r13, r10, LSL, r7},
     false,
     al,
     "al r13 r10 LSL r7",
     "al_r13_r10_LSL_r7"},
    {{al, r3, r9, ROR, r8}, false, al, "al r3 r9 ROR r8", "al_r3_r9_ROR_r8"},
    {{al, r13, r11, ASR, r10},
     false,
     al,
     "al r13 r11 ASR r10",
     "al_r13_r11_ASR_r10"},
    {{al, r1, r6, ASR, r7}, false, al, "al r1 r6 ASR r7", "al_r1_r6_ASR_r7"},
    {{al, r9, r13, ROR, r3}, false, al, "al r9 r13 ROR r3", "al_r9_r13_ROR_r3"},
    {{al, r14, r8, ASR, r10},
     false,
     al,
     "al r14 r8 ASR r10",
     "al_r14_r8_ASR_r10"},
    {{al, r1, r2, ASR, r12}, false, al, "al r1 r2 ASR r12", "al_r1_r2_ASR_r12"},
    {{al, r14, r0, LSR, r10},
     false,
     al,
     "al r14 r0 LSR r10",
     "al_r14_r0_LSR_r10"},
    {{al, r2, r11, ASR, r8}, false, al, "al r2 r11 ASR r8", "al_r2_r11_ASR_r8"},
    {{al, r0, r3, LSL, r2}, false, al, "al r0 r3 LSL r2", "al_r0_r3_LSL_r2"},
    {{al, r2, r13, LSL, r5}, false, al, "al r2 r13 LSL r5", "al_r2_r13_LSL_r5"},
    {{al, r4, r2, ASR, r6}, false, al, "al r4 r2 ASR r6", "al_r4_r2_ASR_r6"},
    {{al, r7, r7, ASR, r4}, false, al, "al r7 r7 ASR r4", "al_r7_r7_ASR_r4"},
    {{al, r11, r1, LSL, r2}, false, al, "al r11 r1 LSL r2", "al_r11_r1_LSL_r2"},
    {{al, r6, r13, LSL, r6}, false, al, "al r6 r13 LSL r6", "al_r6_r13_LSL_r6"},
    {{al, r13, r4, LSL, r9}, false, al, "al r13 r4 LSL r9", "al_r13_r4_LSL_r9"},
    {{al, r0, r7, ASR, r9}, false, al, "al r0 r7 ASR r9", "al_r0_r7_ASR_r9"},
    {{al, r13, r7, ASR, r9}, false, al, "al r13 r7 ASR r9", "al_r13_r7_ASR_r9"},
    {{al, r12, r10, ROR, r6},
     false,
     al,
     "al r12 r10 ROR r6",
     "al_r12_r10_ROR_r6"},
    {{al, r8, r9, LSL, r12}, false, al, "al r8 r9 LSL r12", "al_r8_r9_LSL_r12"},
    {{al, r12, r14, LSR, r1},
     false,
     al,
     "al r12 r14 LSR r1",
     "al_r12_r14_LSR_r1"},
    {{al, r1, r5, LSL, r1}, false, al, "al r1 r5 LSL r1", "al_r1_r5_LSL_r1"},
    {{al, r0, r14, ROR, r8}, false, al, "al r0 r14 ROR r8", "al_r0_r14_ROR_r8"},
    {{al, r8, r1, ASR, r3}, false, al, "al r8 r1 ASR r3", "al_r8_r1_ASR_r3"},
    {{al, r13, r8, LSL, r1}, false, al, "al r13 r8 LSL r1", "al_r13_r8_LSL_r1"},
    {{al, r7, r6, LSL, r2}, false, al, "al r7 r6 LSL r2", "al_r7_r6_LSL_r2"},
    {{al, r7, r7, ASR, r6}, false, al, "al r7 r7 ASR r6", "al_r7_r7_ASR_r6"},
    {{al, r5, r11, LSR, r10},
     false,
     al,
     "al r5 r11 LSR r10",
     "al_r5_r11_LSR_r10"},
    {{al, r7, r2, ASR, r7}, false, al, "al r7 r2 ASR r7", "al_r7_r2_ASR_r7"},
    {{al, r3, r4, LSL, r10}, false, al, "al r3 r4 LSL r10", "al_r3_r4_LSL_r10"},
    {{al, r12, r14, LSL, r5},
     false,
     al,
     "al r12 r14 LSL r5",
     "al_r12_r14_LSL_r5"},
    {{al, r2, r3, ROR, r8}, false, al, "al r2 r3 ROR r8", "al_r2_r3_ROR_r8"},
    {{al, r6, r7, LSL, r14}, false, al, "al r6 r7 LSL r14", "al_r6_r7_LSL_r14"},
    {{al, r14, r11, ASR, r10},
     false,
     al,
     "al r14 r11 ASR r10",
     "al_r14_r11_ASR_r10"},
    {{al, r9, r9, ASR, r3}, false, al, "al r9 r9 ASR r3", "al_r9_r9_ASR_r3"},
    {{al, r3, r1, ROR, r8}, false, al, "al r3 r1 ROR r8", "al_r3_r1_ROR_r8"},
    {{al, r0, r9, LSL, r0}, false, al, "al r0 r9 LSL r0", "al_r0_r9_LSL_r0"},
    {{al, r2, r0, ROR, r13}, false, al, "al r2 r0 ROR r13", "al_r2_r0_ROR_r13"},
    {{al, r8, r10, LSR, r13},
     false,
     al,
     "al r8 r10 LSR r13",
     "al_r8_r10_LSR_r13"},
    {{al, r13, r13, LSR, r13},
     false,
     al,
     "al r13 r13 LSR r13",
     "al_r13_r13_LSR_r13"},
    {{al, r0, r3, LSL, r4}, false, al, "al r0 r3 LSL r4", "al_r0_r3_LSL_r4"},
    {{al, r14, r4, LSL, r14},
     false,
     al,
     "al r14 r4 LSL r14",
     "al_r14_r4_LSL_r14"},
    {{al, r8, r4, ROR, r11}, false, al, "al r8 r4 ROR r11", "al_r8_r4_ROR_r11"},
    {{al, r6, r8, ROR, r7}, false, al, "al r6 r8 ROR r7", "al_r6_r8_ROR_r7"},
    {{al, r4, r14, ROR, r9}, false, al, "al r4 r14 ROR r9", "al_r4_r14_ROR_r9"},
    {{al, r8, r12, ASR, r9}, false, al, "al r8 r12 ASR r9", "al_r8_r12_ASR_r9"},
    {{al, r14, r12, ROR, r11},
     false,
     al,
     "al r14 r12 ROR r11",
     "al_r14_r12_ROR_r11"},
    {{al, r11, r10, ASR, r11},
     false,
     al,
     "al r11 r10 ASR r11",
     "al_r11_r10_ASR_r11"},
    {{al, r1, r11, ROR, r7}, false, al, "al r1 r11 ROR r7", "al_r1_r11_ROR_r7"},
    {{al, r9, r3, ROR, r8}, false, al, "al r9 r3 ROR r8", "al_r9_r3_ROR_r8"},
    {{al, r2, r12, LSL, r10},
     false,
     al,
     "al r2 r12 LSL r10",
     "al_r2_r12_LSL_r10"},
    {{al, r12, r14, LSL, r10},
     false,
     al,
     "al r12 r14 LSL r10",
     "al_r12_r14_LSL_r10"},
    {{al, r7, r11, LSL, r0}, false, al, "al r7 r11 LSL r0", "al_r7_r11_LSL_r0"},
    {{al, r14, r9, ROR, r13},
     false,
     al,
     "al r14 r9 ROR r13",
     "al_r14_r9_ROR_r13"},
    {{al, r5, r7, ROR, r13}, false, al, "al r5 r7 ROR r13", "al_r5_r7_ROR_r13"},
    {{al, r2, r14, ASR, r11},
     false,
     al,
     "al r2 r14 ASR r11",
     "al_r2_r14_ASR_r11"},
    {{al, r12, r0, ROR, r9}, false, al, "al r12 r0 ROR r9", "al_r12_r0_ROR_r9"},
    {{al, r5, r2, LSR, r6}, false, al, "al r5 r2 LSR r6", "al_r5_r2_LSR_r6"},
    {{al, r2, r14, LSL, r10},
     false,
     al,
     "al r2 r14 LSL r10",
     "al_r2_r14_LSL_r10"},
    {{al, r1, r9, LSL, r3}, false, al, "al r1 r9 LSL r3", "al_r1_r9_LSL_r3"},
    {{al, r2, r4, ROR, r12}, false, al, "al r2 r4 ROR r12", "al_r2_r4_ROR_r12"},
    {{al, r0, r1, ASR, r3}, false, al, "al r0 r1 ASR r3", "al_r0_r1_ASR_r3"},
    {{al, r5, r13, LSR, r10},
     false,
     al,
     "al r5 r13 LSR r10",
     "al_r5_r13_LSR_r10"},
    {{al, r9, r1, ASR, r3}, false, al, "al r9 r1 ASR r3", "al_r9_r1_ASR_r3"},
    {{al, r9, r2, ASR, r11}, false, al, "al r9 r2 ASR r11", "al_r9_r2_ASR_r11"},
    {{al, r4, r11, LSL, r12},
     false,
     al,
     "al r4 r11 LSL r12",
     "al_r4_r11_LSL_r12"},
    {{al, r12, r5, LSL, r10},
     false,
     al,
     "al r12 r5 LSL r10",
     "al_r12_r5_LSL_r10"},
    {{al, r10, r14, LSL, r0},
     false,
     al,
     "al r10 r14 LSL r0",
     "al_r10_r14_LSL_r0"},
    {{al, r12, r4, LSR, r10},
     false,
     al,
     "al r12 r4 LSR r10",
     "al_r12_r4_LSR_r10"},
    {{al, r8, r10, ROR, r13},
     false,
     al,
     "al r8 r10 ROR r13",
     "al_r8_r10_ROR_r13"},
    {{al, r8, r10, LSR, r4}, false, al, "al r8 r10 LSR r4", "al_r8_r10_LSR_r4"},
    {{al, r8, r1, ASR, r11}, false, al, "al r8 r1 ASR r11", "al_r8_r1_ASR_r11"},
    {{al, r2, r13, LSL, r1}, false, al, "al r2 r13 LSL r1", "al_r2_r13_LSL_r1"},
    {{al, r14, r0, LSR, r13},
     false,
     al,
     "al r14 r0 LSR r13",
     "al_r14_r0_LSR_r13"},
    {{al, r1, r8, LSL, r2}, false, al, "al r1 r8 LSL r2", "al_r1_r8_LSL_r2"},
    {{al, r0, r10, LSL, r3}, false, al, "al r0 r10 LSL r3", "al_r0_r10_LSL_r3"},
    {{al, r3, r13, ROR, r2}, false, al, "al r3 r13 ROR r2", "al_r3_r13_ROR_r2"},
    {{al, r14, r5, ASR, r6}, false, al, "al r14 r5 ASR r6", "al_r14_r5_ASR_r6"},
    {{al, r12, r6, ROR, r14},
     false,
     al,
     "al r12 r6 ROR r14",
     "al_r12_r6_ROR_r14"},
    {{al, r0, r9, LSR, r1}, false, al, "al r0 r9 LSR r1", "al_r0_r9_LSR_r1"},
    {{al, r1, r0, ROR, r2}, false, al, "al r1 r0 ROR r2", "al_r1_r0_ROR_r2"},
    {{al, r2, r3, LSL, r3}, false, al, "al r2 r3 LSL r3", "al_r2_r3_LSL_r3"},
    {{al, r7, r2, ROR, r1}, false, al, "al r7 r2 ROR r1", "al_r7_r2_ROR_r1"},
    {{al, r11, r13, ROR, r2},
     false,
     al,
     "al r11 r13 ROR r2",
     "al_r11_r13_ROR_r2"},
    {{al, r11, r9, ROR, r3}, false, al, "al r11 r9 ROR r3", "al_r11_r9_ROR_r3"},
    {{al, r0, r8, ROR, r7}, false, al, "al r0 r8 ROR r7", "al_r0_r8_ROR_r7"},
    {{al, r13, r13, ROR, r3},
     false,
     al,
     "al r13 r13 ROR r3",
     "al_r13_r13_ROR_r3"},
    {{al, r1, r12, LSR, r1}, false, al, "al r1 r12 LSR r1", "al_r1_r12_LSR_r1"},
    {{al, r10, r4, ROR, r5}, false, al, "al r10 r4 ROR r5", "al_r10_r4_ROR_r5"},
    {{al, r5, r2, ROR, r3}, false, al, "al r5 r2 ROR r3", "al_r5_r2_ROR_r3"},
    {{al, r11, r7, ASR, r12},
     false,
     al,
     "al r11 r7 ASR r12",
     "al_r11_r7_ASR_r12"},
    {{al, r3, r10, LSR, r14},
     false,
     al,
     "al r3 r10 LSR r14",
     "al_r3_r10_LSR_r14"},
    {{al, r8, r8, LSR, r6}, false, al, "al r8 r8 LSR r6", "al_r8_r8_LSR_r6"},
    {{al, r13, r4, ROR, r7}, false, al, "al r13 r4 ROR r7", "al_r13_r4_ROR_r7"},
    {{al, r3, r11, ASR, r10},
     false,
     al,
     "al r3 r11 ASR r10",
     "al_r3_r11_ASR_r10"},
    {{al, r10, r12, LSL, r14},
     false,
     al,
     "al r10 r12 LSL r14",
     "al_r10_r12_LSL_r14"},
    {{al, r5, r12, LSL, r12},
     false,
     al,
     "al r5 r12 LSL r12",
     "al_r5_r12_LSL_r12"},
    {{al, r3, r13, LSR, r8}, false, al, "al r3 r13 LSR r8", "al_r3_r13_LSR_r8"},
    {{al, r10, r3, LSR, r9}, false, al, "al r10 r3 LSR r9", "al_r10_r3_LSR_r9"},
    {{al, r1, r2, LSR, r12}, false, al, "al r1 r2 LSR r12", "al_r1_r2_LSR_r12"},
    {{al, r8, r12, LSL, r2}, false, al, "al r8 r12 LSL r2", "al_r8_r12_LSL_r2"},
    {{al, r3, r9, LSR, r14}, false, al, "al r3 r9 LSR r14", "al_r3_r9_LSR_r14"},
    {{al, r9, r8, LSL, r3}, false, al, "al r9 r8 LSL r3", "al_r9_r8_LSL_r3"},
    {{al, r12, r4, LSR, r4}, false, al, "al r12 r4 LSR r4", "al_r12_r4_LSR_r4"},
    {{al, r9, r13, LSL, r1}, false, al, "al r9 r13 LSL r1", "al_r9_r13_LSL_r1"},
    {{al, r11, r5, LSL, r1}, false, al, "al r11 r5 LSL r1", "al_r11_r5_LSL_r1"},
    {{al, r0, r8, ROR, r13}, false, al, "al r0 r8 ROR r13", "al_r0_r8_ROR_r13"},
    {{al, r0, r8, LSR, r13}, false, al, "al r0 r8 LSR r13", "al_r0_r8_LSR_r13"},
    {{al, r10, r13, LSL, r13},
     false,
     al,
     "al r10 r13 LSL r13",
     "al_r10_r13_LSL_r13"},
    {{al, r14, r8, ROR, r8}, false, al, "al r14 r8 ROR r8", "al_r14_r8_ROR_r8"},
    {{al, r5, r10, LSL, r8}, false, al, "al r5 r10 LSL r8", "al_r5_r10_LSL_r8"},
    {{al, r0, r9, LSR, r14}, false, al, "al r0 r9 LSR r14", "al_r0_r9_LSR_r14"},
    {{al, r3, r2, LSL, r12}, false, al, "al r3 r2 LSL r12", "al_r3_r2_LSL_r12"},
    {{al, r7, r8, ROR, r2}, false, al, "al r7 r8 ROR r2", "al_r7_r8_ROR_r2"},
    {{al, r8, r8, ASR, r12}, false, al, "al r8 r8 ASR r12", "al_r8_r8_ASR_r12"},
    {{al, r8, r2, ASR, r2}, false, al, "al r8 r2 ASR r2", "al_r8_r2_ASR_r2"},
    {{al, r5, r14, LSR, r12},
     false,
     al,
     "al r5 r14 LSR r12",
     "al_r5_r14_LSR_r12"},
    {{al, r5, r10, ASR, r9}, false, al, "al r5 r10 ASR r9", "al_r5_r10_ASR_r9"},
    {{al, r7, r1, LSR, r13}, false, al, "al r7 r1 LSR r13", "al_r7_r1_LSR_r13"},
    {{al, r5, r7, ROR, r14}, false, al, "al r5 r7 ROR r14", "al_r5_r7_ROR_r14"},
    {{al, r6, r0, ROR, r3}, false, al, "al r6 r0 ROR r3", "al_r6_r0_ROR_r3"},
    {{al, r5, r13, ASR, r11},
     false,
     al,
     "al r5 r13 ASR r11",
     "al_r5_r13_ASR_r11"},
    {{al, r8, r0, ROR, r8}, false, al, "al r8 r0 ROR r8", "al_r8_r0_ROR_r8"},
    {{al, r10, r11, LSR, r11},
     false,
     al,
     "al r10 r11 LSR r11",
     "al_r10_r11_LSR_r11"},
    {{al, r2, r8, LSL, r13}, false, al, "al r2 r8 LSL r13", "al_r2_r8_LSL_r13"},
    {{al, r14, r8, LSL, r4}, false, al, "al r14 r8 LSL r4", "al_r14_r8_LSL_r4"},
    {{al, r3, r1, ASR, r3}, false, al, "al r3 r1 ASR r3", "al_r3_r1_ASR_r3"},
    {{al, r13, r12, LSR, r14},
     false,
     al,
     "al r13 r12 LSR r14",
     "al_r13_r12_LSR_r14"},
    {{al, r4, r2, ROR, r7}, false, al, "al r4 r2 ROR r7", "al_r4_r2_ROR_r7"},
    {{al, r13, r2, ASR, r6}, false, al, "al r13 r2 ASR r6", "al_r13_r2_ASR_r6"},
    {{al, r9, r8, LSR, r3}, false, al, "al r9 r8 LSR r3", "al_r9_r8_LSR_r3"},
    {{al, r9, r2, LSL, r9}, false, al, "al r9 r2 LSL r9", "al_r9_r2_LSL_r9"},
    {{al, r8, r14, ASR, r5}, false, al, "al r8 r14 ASR r5", "al_r8_r14_ASR_r5"},
    {{al, r14, r11, LSR, r12},
     false,
     al,
     "al r14 r11 LSR r12",
     "al_r14_r11_LSR_r12"},
    {{al, r0, r3, LSL, r1}, false, al, "al r0 r3 LSL r1", "al_r0_r3_LSL_r1"},
    {{al, r8, r14, LSL, r8}, false, al, "al r8 r14 LSL r8", "al_r8_r14_LSL_r8"},
    {{al, r13, r14, LSR, r13},
     false,
     al,
     "al r13 r14 LSR r13",
     "al_r13_r14_LSR_r13"},
    {{al, r2, r13, ROR, r11},
     false,
     al,
     "al r2 r13 ROR r11",
     "al_r2_r13_ROR_r11"},
    {{al, r9, r12, ROR, r7}, false, al, "al r9 r12 ROR r7", "al_r9_r12_ROR_r7"},
    {{al, r7, r2, ROR, r11}, false, al, "al r7 r2 ROR r11", "al_r7_r2_ROR_r11"},
    {{al, r12, r1, ASR, r1}, false, al, "al r12 r1 ASR r1", "al_r12_r1_ASR_r1"},
    {{al, r8, r9, ASR, r2}, false, al, "al r8 r9 ASR r2", "al_r8_r9_ASR_r2"},
    {{al, r11, r1, LSR, r10},
     false,
     al,
     "al r11 r1 LSR r10",
     "al_r11_r1_LSR_r10"},
    {{al, r1, r8, LSR, r8}, false, al, "al r1 r8 LSR r8", "al_r1_r8_LSR_r8"},
    {{al, r10, r2, ROR, r4}, false, al, "al r10 r2 ROR r4", "al_r10_r2_ROR_r4"},
    {{al, r0, r10, LSL, r8}, false, al, "al r0 r10 LSL r8", "al_r0_r10_LSL_r8"},
    {{al, r1, r13, LSR, r8}, false, al, "al r1 r13 LSR r8", "al_r1_r13_LSR_r8"},
    {{al, r8, r5, ASR, r13}, false, al, "al r8 r5 ASR r13", "al_r8_r5_ASR_r13"},
    {{al, r7, r10, LSR, r6}, false, al, "al r7 r10 LSR r6", "al_r7_r10_LSR_r6"},
    {{al, r9, r6, ASR, r5}, false, al, "al r9 r6 ASR r5", "al_r9_r6_ASR_r5"},
    {{al, r8, r7, ASR, r8}, false, al, "al r8 r7 ASR r8", "al_r8_r7_ASR_r8"},
    {{al, r3, r12, ROR, r7}, false, al, "al r3 r12 ROR r7", "al_r3_r12_ROR_r7"},
    {{al, r8, r13, LSL, r1}, false, al, "al r8 r13 LSL r1", "al_r8_r13_LSL_r1"},
    {{al, r7, r7, ROR, r11}, false, al, "al r7 r7 ROR r11", "al_r7_r7_ROR_r11"},
    {{al, r12, r5, LSL, r4}, false, al, "al r12 r5 LSL r4", "al_r12_r5_LSL_r4"},
    {{al, r8, r5, LSL, r11}, false, al, "al r8 r5 LSL r11", "al_r8_r5_LSL_r11"},
    {{al, r4, r6, ASR, r10}, false, al, "al r4 r6 ASR r10", "al_r4_r6_ASR_r10"},
    {{al, r13, r5, ASR, r6}, false, al, "al r13 r5 ASR r6", "al_r13_r5_ASR_r6"},
    {{al, r5, r6, LSL, r12}, false, al, "al r5 r6 LSL r12", "al_r5_r6_LSL_r12"},
    {{al, r13, r1, ASR, r8}, false, al, "al r13 r1 ASR r8", "al_r13_r1_ASR_r8"},
    {{al, r7, r10, ROR, r1}, false, al, "al r7 r10 ROR r1", "al_r7_r10_ROR_r1"},
    {{al, r13, r4, ASR, r4}, false, al, "al r13 r4 ASR r4", "al_r13_r4_ASR_r4"},
    {{al, r6, r13, LSR, r8}, false, al, "al r6 r13 LSR r8", "al_r6_r13_LSR_r8"},
    {{al, r2, r13, ROR, r3}, false, al, "al r2 r13 ROR r3", "al_r2_r13_ROR_r3"},
    {{al, r0, r9, ASR, r0}, false, al, "al r0 r9 ASR r0", "al_r0_r9_ASR_r0"},
    {{al, r1, r4, LSR, r9}, false, al, "al r1 r4 LSR r9", "al_r1_r4_LSR_r9"},
    {{al, r6, r3, ROR, r7}, false, al, "al r6 r3 ROR r7", "al_r6_r3_ROR_r7"},
    {{al, r14, r4, LSR, r1}, false, al, "al r14 r4 LSR r1", "al_r14_r4_LSR_r1"},
    {{al, r13, r14, LSL, r2},
     false,
     al,
     "al r13 r14 LSL r2",
     "al_r13_r14_LSL_r2"},
    {{al, r14, r2, LSL, r6}, false, al, "al r14 r2 LSL r6", "al_r14_r2_LSL_r6"},
    {{al, r5, r4, ROR, r12}, false, al, "al r5 r4 ROR r12", "al_r5_r4_ROR_r12"},
    {{al, r11, r10, ROR, r7},
     false,
     al,
     "al r11 r10 ROR r7",
     "al_r11_r10_ROR_r7"},
    {{al, r5, r11, ROR, r1}, false, al, "al r5 r11 ROR r1", "al_r5_r11_ROR_r1"},
    {{al, r13, r11, LSL, r11},
     false,
     al,
     "al r13 r11 LSL r11",
     "al_r13_r11_LSL_r11"},
    {{al, r12, r1, ROR, r5}, false, al, "al r12 r1 ROR r5", "al_r12_r1_ROR_r5"},
    {{al, r3, r7, LSL, r7}, false, al, "al r3 r7 LSL r7", "al_r3_r7_LSL_r7"},
    {{al, r14, r0, ROR, r9}, false, al, "al r14 r0 ROR r9", "al_r14_r0_ROR_r9"},
    {{al, r3, r2, ASR, r7}, false, al, "al r3 r2 ASR r7", "al_r3_r2_ASR_r7"},
    {{al, r0, r6, ASR, r6}, false, al, "al r0 r6 ASR r6", "al_r0_r6_ASR_r6"},
    {{al, r11, r5, LSR, r4}, false, al, "al r11 r5 LSR r4", "al_r11_r5_LSR_r4"},
    {{al, r1, r12, ROR, r6}, false, al, "al r1 r12 ROR r6", "al_r1_r12_ROR_r6"},
    {{al, r1, r9, ROR, r2}, false, al, "al r1 r9 ROR r2", "al_r1_r9_ROR_r2"},
    {{al, r1, r13, ASR, r4}, false, al, "al r1 r13 ASR r4", "al_r1_r13_ASR_r4"},
    {{al, r10, r3, ROR, r5}, false, al, "al r10 r3 ROR r5", "al_r10_r3_ROR_r5"},
    {{al, r0, r4, LSL, r9}, false, al, "al r0 r4 LSL r9", "al_r0_r4_LSL_r9"},
    {{al, r1, r4, LSR, r10}, false, al, "al r1 r4 LSR r10", "al_r1_r4_LSR_r10"},
    {{al, r12, r11, LSR, r4},
     false,
     al,
     "al r12 r11 LSR r4",
     "al_r12_r11_LSR_r4"},
    {{al, r5, r11, LSL, r1}, false, al, "al r5 r11 LSL r1", "al_r5_r11_LSL_r1"},
    {{al, r8, r9, LSR, r8}, false, al, "al r8 r9 LSR r8", "al_r8_r9_LSR_r8"},
    {{al, r1, r12, ASR, r14},
     false,
     al,
     "al r1 r12 ASR r14",
     "al_r1_r12_ASR_r14"},
    {{al, r7, r9, ASR, r10}, false, al, "al r7 r9 ASR r10", "al_r7_r9_ASR_r10"},
    {{al, r9, r0, ROR, r7}, false, al, "al r9 r0 ROR r7", "al_r9_r0_ROR_r7"},
    {{al, r9, r5, ASR, r11}, false, al, "al r9 r5 ASR r11", "al_r9_r5_ASR_r11"},
    {{al, r11, r11, ROR, r2},
     false,
     al,
     "al r11 r11 ROR r2",
     "al_r11_r11_ROR_r2"},
    {{al, r3, r10, ASR, r2}, false, al, "al r3 r10 ASR r2", "al_r3_r10_ASR_r2"},
    {{al, r10, r11, LSL, r9},
     false,
     al,
     "al r10 r11 LSL r9",
     "al_r10_r11_LSL_r9"},
    {{al, r8, r1, ASR, r8}, false, al, "al r8 r1 ASR r8", "al_r8_r1_ASR_r8"},
    {{al, r13, r5, LSL, r13},
     false,
     al,
     "al r13 r5 LSL r13",
     "al_r13_r5_LSL_r13"},
    {{al, r11, r0, ROR, r11},
     false,
     al,
     "al r11 r0 ROR r11",
     "al_r11_r0_ROR_r11"},
    {{al, r4, r4, ROR, r14}, false, al, "al r4 r4 ROR r14", "al_r4_r4_ROR_r14"},
    {{al, r0, r7, ASR, r2}, false, al, "al r0 r7 ASR r2", "al_r0_r7_ASR_r2"},
    {{al, r11, r12, LSL, r5},
     false,
     al,
     "al r11 r12 LSL r5",
     "al_r11_r12_LSL_r5"},
    {{al, r10, r12, LSL, r4},
     false,
     al,
     "al r10 r12 LSL r4",
     "al_r10_r12_LSL_r4"},
    {{al, r0, r13, LSR, r4}, false, al, "al r0 r13 LSR r4", "al_r0_r13_LSR_r4"},
    {{al, r4, r9, ROR, r6}, false, al, "al r4 r9 ROR r6", "al_r4_r9_ROR_r6"},
    {{al, r1, r8, LSR, r4}, false, al, "al r1 r8 LSR r4", "al_r1_r8_LSR_r4"},
    {{al, r8, r8, ASR, r4}, false, al, "al r8 r8 ASR r4", "al_r8_r8_ASR_r4"},
    {{al, r12, r12, ROR, r6},
     false,
     al,
     "al r12 r12 ROR r6",
     "al_r12_r12_ROR_r6"},
    {{al, r4, r5, LSL, r2}, false, al, "al r4 r5 LSL r2", "al_r4_r5_LSL_r2"},
    {{al, r5, r1, LSR, r5}, false, al, "al r5 r1 LSR r5", "al_r5_r1_LSR_r5"},
    {{al, r14, r0, LSL, r0}, false, al, "al r14 r0 LSL r0", "al_r14_r0_LSL_r0"},
    {{al, r13, r7, ASR, r2}, false, al, "al r13 r7 ASR r2", "al_r13_r7_ASR_r2"},
    {{al, r6, r10, LSL, r10},
     false,
     al,
     "al r6 r10 LSL r10",
     "al_r6_r10_LSL_r10"},
    {{al, r1, r11, ASR, r0}, false, al, "al r1 r11 ASR r0", "al_r1_r11_ASR_r0"},
    {{al, r5, r10, LSL, r9}, false, al, "al r5 r10 LSL r9", "al_r5_r10_LSL_r9"},
    {{al, r6, r13, ASR, r10},
     false,
     al,
     "al r6 r13 ASR r10",
     "al_r6_r13_ASR_r10"},
    {{al, r2, r13, LSR, r3}, false, al, "al r2 r13 LSR r3", "al_r2_r13_LSR_r3"},
    {{al, r13, r8, LSR, r14},
     false,
     al,
     "al r13 r8 LSR r14",
     "al_r13_r8_LSR_r14"},
    {{al, r10, r10, LSL, r0},
     false,
     al,
     "al r10 r10 LSL r0",
     "al_r10_r10_LSL_r0"},
    {{al, r6, r14, ASR, r8}, false, al, "al r6 r14 ASR r8", "al_r6_r14_ASR_r8"},
    {{al, r1, r6, ROR, r4}, false, al, "al r1 r6 ROR r4", "al_r1_r6_ROR_r4"},
    {{al, r9, r4, ROR, r11}, false, al, "al r9 r4 ROR r11", "al_r9_r4_ROR_r11"},
    {{al, r2, r1, ROR, r0}, false, al, "al r2 r1 ROR r0", "al_r2_r1_ROR_r0"},
    {{al, r10, r1, LSL, r1}, false, al, "al r10 r1 LSL r1", "al_r10_r1_LSL_r1"},
    {{al, r3, r0, LSR, r9}, false, al, "al r3 r0 LSR r9", "al_r3_r0_LSR_r9"},
    {{al, r0, r13, ROR, r6}, false, al, "al r0 r13 ROR r6", "al_r0_r13_ROR_r6"},
    {{al, r2, r0, ASR, r9}, false, al, "al r2 r0 ASR r9", "al_r2_r0_ASR_r9"},
    {{al, r5, r4, ROR, r1}, false, al, "al r5 r4 ROR r1", "al_r5_r4_ROR_r1"},
    {{al, r0, r10, LSL, r9}, false, al, "al r0 r10 LSL r9", "al_r0_r10_LSL_r9"},
    {{al, r8, r13, ASR, r7}, false, al, "al r8 r13 ASR r7", "al_r8_r13_ASR_r7"},
    {{al, r5, r11, ROR, r6}, false, al, "al r5 r11 ROR r6", "al_r5_r11_ROR_r6"},
    {{al, r1, r3, ASR, r3}, false, al, "al r1 r3 ASR r3", "al_r1_r3_ASR_r3"},
    {{al, r6, r14, LSR, r0}, false, al, "al r6 r14 LSR r0", "al_r6_r14_LSR_r0"},
    {{al, r1, r0, ASR, r14}, false, al, "al r1 r0 ASR r14", "al_r1_r0_ASR_r14"},
    {{al, r12, r13, ASR, r12},
     false,
     al,
     "al r12 r13 ASR r12",
     "al_r12_r13_ASR_r12"},
    {{al, r9, r7, ROR, r9}, false, al, "al r9 r7 ROR r9", "al_r9_r7_ROR_r9"},
    {{al, r14, r10, LSR, r14},
     false,
     al,
     "al r14 r10 LSR r14",
     "al_r14_r10_LSR_r14"},
    {{al, r6, r14, ROR, r2}, false, al, "al r6 r14 ROR r2", "al_r6_r14_ROR_r2"},
    {{al, r6, r11, LSR, r6}, false, al, "al r6 r11 LSR r6", "al_r6_r11_LSR_r6"},
    {{al, r11, r10, LSR, r5},
     false,
     al,
     "al r11 r10 LSR r5",
     "al_r11_r10_LSR_r5"},
    {{al, r4, r11, LSR, r12},
     false,
     al,
     "al r4 r11 LSR r12",
     "al_r4_r11_LSR_r12"},
    {{al, r14, r14, ROR, r11},
     false,
     al,
     "al r14 r14 ROR r11",
     "al_r14_r14_ROR_r11"},
    {{al, r5, r3, ASR, r14}, false, al, "al r5 r3 ASR r14", "al_r5_r3_ASR_r14"},
    {{al, r2, r4, ASR, r12}, false, al, "al r2 r4 ASR r12", "al_r2_r4_ASR_r12"},
    {{al, r11, r3, LSL, r1}, false, al, "al r11 r3 LSL r1", "al_r11_r3_LSL_r1"},
    {{al, r4, r7, LSR, r13}, false, al, "al r4 r7 LSR r13", "al_r4_r7_LSR_r13"},
    {{al, r4, r9, ASR, r1}, false, al, "al r4 r9 ASR r1", "al_r4_r9_ASR_r1"},
    {{al, r13, r11, ROR, r13},
     false,
     al,
     "al r13 r11 ROR r13",
     "al_r13_r11_ROR_r13"},
    {{al, r9, r9, LSL, r12}, false, al, "al r9 r9 LSL r12", "al_r9_r9_LSL_r12"},
    {{al, r6, r11, ROR, r14},
     false,
     al,
     "al r6 r11 ROR r14",
     "al_r6_r11_ROR_r14"},
    {{al, r12, r2, ROR, r1}, false, al, "al r12 r2 ROR r1", "al_r12_r2_ROR_r1"},
    {{al, r7, r0, ROR, r3}, false, al, "al r7 r0 ROR r3", "al_r7_r0_ROR_r3"},
    {{al, r1, r0, LSL, r13}, false, al, "al r1 r0 LSL r13", "al_r1_r0_LSL_r13"},
    {{al, r14, r11, ROR, r7},
     false,
     al,
     "al r14 r11 ROR r7",
     "al_r14_r11_ROR_r7"},
    {{al, r6, r12, LSR, r10},
     false,
     al,
     "al r6 r12 LSR r10",
     "al_r6_r12_LSR_r10"},
    {{al, r8, r6, ROR, r2}, false, al, "al r8 r6 ROR r2", "al_r8_r6_ROR_r2"},
    {{al, r5, r0, LSR, r1}, false, al, "al r5 r0 LSR r1", "al_r5_r0_LSR_r1"},
    {{al, r8, r10, ASR, r3}, false, al, "al r8 r10 ASR r3", "al_r8_r10_ASR_r3"},
    {{al, r5, r1, ROR, r6}, false, al, "al r5 r1 ROR r6", "al_r5_r1_ROR_r6"},
    {{al, r6, r14, ASR, r1}, false, al, "al r6 r14 ASR r1", "al_r6_r14_ASR_r1"},
    {{al, r5, r13, ASR, r6}, false, al, "al r5 r13 ASR r6", "al_r5_r13_ASR_r6"},
    {{al, r1, r14, ASR, r10},
     false,
     al,
     "al r1 r14 ASR r10",
     "al_r1_r14_ASR_r10"},
    {{al, r9, r1, LSR, r11}, false, al, "al r9 r1 LSR r11", "al_r9_r1_LSR_r11"},
    {{al, r6, r0, LSR, r13}, false, al, "al r6 r0 LSR r13", "al_r6_r0_LSR_r13"},
    {{al, r2, r12, LSL, r12},
     false,
     al,
     "al r2 r12 LSL r12",
     "al_r2_r12_LSL_r12"},
    {{al, r0, r0, LSR, r7}, false, al, "al r0 r0 LSR r7", "al_r0_r0_LSR_r7"},
    {{al, r3, r10, LSR, r10},
     false,
     al,
     "al r3 r10 LSR r10",
     "al_r3_r10_LSR_r10"},
    {{al, r6, r6, ASR, r4}, false, al, "al r6 r6 ASR r4", "al_r6_r6_ASR_r4"},
    {{al, r2, r13, ASR, r1}, false, al, "al r2 r13 ASR r1", "al_r2_r13_ASR_r1"},
    {{al, r12, r8, LSR, r7}, false, al, "al r12 r8 LSR r7", "al_r12_r8_LSR_r7"},
    {{al, r11, r14, ROR, r14},
     false,
     al,
     "al r11 r14 ROR r14",
     "al_r11_r14_ROR_r14"},
    {{al, r13, r2, ROR, r13},
     false,
     al,
     "al r13 r2 ROR r13",
     "al_r13_r2_ROR_r13"},
    {{al, r12, r9, LSL, r4}, false, al, "al r12 r9 LSL r4", "al_r12_r9_LSL_r4"},
    {{al, r12, r11, LSL, r14},
     false,
     al,
     "al r12 r11 LSL r14",
     "al_r12_r11_LSL_r14"},
    {{al, r9, r10, LSR, r7}, false, al, "al r9 r10 LSR r7", "al_r9_r10_LSR_r7"},
    {{al, r7, r11, LSL, r4}, false, al, "al r7 r11 LSL r4", "al_r7_r11_LSL_r4"},
    {{al, r4, r7, LSL, r5}, false, al, "al r4 r7 LSL r5", "al_r4_r7_LSL_r5"},
    {{al, r0, r9, ROR, r12}, false, al, "al r0 r9 ROR r12", "al_r0_r9_ROR_r12"},
    {{al, r12, r0, LSL, r5}, false, al, "al r12 r0 LSL r5", "al_r12_r0_LSL_r5"},
    {{al, r0, r13, LSR, r1}, false, al, "al r0 r13 LSR r1", "al_r0_r13_LSR_r1"},
    {{al, r10, r11, LSR, r4},
     false,
     al,
     "al r10 r11 LSR r4",
     "al_r10_r11_LSR_r4"},
    {{al, r1, r2, LSR, r13}, false, al, "al r1 r2 LSR r13", "al_r1_r2_LSR_r13"},
    {{al, r0, r0, ROR, r3}, false, al, "al r0 r0 ROR r3", "al_r0_r0_ROR_r3"},
    {{al, r13, r7, LSL, r3}, false, al, "al r13 r7 LSL r3", "al_r13_r7_LSL_r3"},
    {{al, r9, r10, LSL, r7}, false, al, "al r9 r10 LSL r7", "al_r9_r10_LSL_r7"},
    {{al, r6, r11, LSL, r9}, false, al, "al r6 r11 LSL r9", "al_r6_r11_LSL_r9"},
    {{al, r12, r14, ASR, r0},
     false,
     al,
     "al r12 r14 ASR r0",
     "al_r12_r14_ASR_r0"},
    {{al, r2, r12, ROR, r13},
     false,
     al,
     "al r2 r12 ROR r13",
     "al_r2_r12_ROR_r13"},
    {{al, r1, r13, LSL, r9}, false, al, "al r1 r13 LSL r9", "al_r1_r13_LSL_r9"},
    {{al, r13, r12, LSR, r11},
     false,
     al,
     "al r13 r12 LSR r11",
     "al_r13_r12_LSR_r11"},
    {{al, r10, r2, ASR, r3}, false, al, "al r10 r2 ASR r3", "al_r10_r2_ASR_r3"},
    {{al, r2, r4, LSL, r14}, false, al, "al r2 r4 LSL r14", "al_r2_r4_LSL_r14"},
    {{al, r9, r9, LSL, r2}, false, al, "al r9 r9 LSL r2", "al_r9_r9_LSL_r2"},
    {{al, r6, r10, ASR, r12},
     false,
     al,
     "al r6 r10 ASR r12",
     "al_r6_r10_ASR_r12"},
    {{al, r2, r7, ROR, r0}, false, al, "al r2 r7 ROR r0", "al_r2_r7_ROR_r0"},
    {{al, r1, r12, ROR, r1}, false, al, "al r1 r12 ROR r1", "al_r1_r12_ROR_r1"},
    {{al, r5, r10, LSR, r6}, false, al, "al r5 r10 LSR r6", "al_r5_r10_LSR_r6"},
    {{al, r2, r7, ROR, r4}, false, al, "al r2 r7 ROR r4", "al_r2_r7_ROR_r4"},
    {{al, r8, r5, ROR, r7}, false, al, "al r8 r5 ROR r7", "al_r8_r5_ROR_r7"},
    {{al, r11, r9, LSR, r14},
     false,
     al,
     "al r11 r9 LSR r14",
     "al_r11_r9_LSR_r14"},
    {{al, r3, r1, ASR, r8}, false, al, "al r3 r1 ASR r8", "al_r3_r1_ASR_r8"},
    {{al, r4, r1, ROR, r14}, false, al, "al r4 r1 ROR r14", "al_r4_r1_ROR_r14"},
    {{al, r7, r12, ROR, r12},
     false,
     al,
     "al r7 r12 ROR r12",
     "al_r7_r12_ROR_r12"},
    {{al, r9, r1, LSR, r4}, false, al, "al r9 r1 LSR r4", "al_r9_r1_LSR_r4"},
    {{al, r4, r13, ROR, r11},
     false,
     al,
     "al r4 r13 ROR r11",
     "al_r4_r13_ROR_r11"},
    {{al, r3, r2, ROR, r10}, false, al, "al r3 r2 ROR r10", "al_r3_r2_ROR_r10"},
    {{al, r14, r4, ASR, r4}, false, al, "al r14 r4 ASR r4", "al_r14_r4_ASR_r4"},
    {{al, r10, r14, LSR, r1},
     false,
     al,
     "al r10 r14 LSR r1",
     "al_r10_r14_LSR_r1"},
    {{al, r0, r7, ROR, r8}, false, al, "al r0 r7 ROR r8", "al_r0_r7_ROR_r8"},
    {{al, r0, r0, LSL, r11}, false, al, "al r0 r0 LSL r11", "al_r0_r0_LSL_r11"},
    {{al, r1, r0, ROR, r3}, false, al, "al r1 r0 ROR r3", "al_r1_r0_ROR_r3"},
    {{al, r8, r0, ASR, r13}, false, al, "al r8 r0 ASR r13", "al_r8_r0_ASR_r13"},
    {{al, r1, r0, LSR, r1}, false, al, "al r1 r0 LSR r1", "al_r1_r0_LSR_r1"},
    {{al, r2, r10, LSR, r5}, false, al, "al r2 r10 LSR r5", "al_r2_r10_LSR_r5"},
    {{al, r14, r14, ASR, r1},
     false,
     al,
     "al r14 r14 ASR r1",
     "al_r14_r14_ASR_r1"},
    {{al, r9, r7, ASR, r0}, false, al, "al r9 r7 ASR r0", "al_r9_r7_ASR_r0"},
    {{al, r9, r2, LSL, r1}, false, al, "al r9 r2 LSL r1", "al_r9_r2_LSL_r1"},
    {{al, r12, r2, LSL, r13},
     false,
     al,
     "al r12 r2 LSL r13",
     "al_r12_r2_LSL_r13"},
    {{al, r12, r12, LSL, r3},
     false,
     al,
     "al r12 r12 LSL r3",
     "al_r12_r12_LSL_r3"},
    {{al, r12, r6, LSR, r14},
     false,
     al,
     "al r12 r6 LSR r14",
     "al_r12_r6_LSR_r14"},
    {{al, r2, r4, LSL, r4}, false, al, "al r2 r4 LSL r4", "al_r2_r4_LSL_r4"},
    {{al, r11, r9, LSR, r13},
     false,
     al,
     "al r11 r9 LSR r13",
     "al_r11_r9_LSR_r13"},
    {{al, r12, r0, ROR, r14},
     false,
     al,
     "al r12 r0 ROR r14",
     "al_r12_r0_ROR_r14"},
    {{al, r14, r8, LSL, r5}, false, al, "al r14 r8 LSL r5", "al_r14_r8_LSL_r5"},
    {{al, r6, r12, ASR, r12},
     false,
     al,
     "al r6 r12 ASR r12",
     "al_r6_r12_ASR_r12"},
    {{al, r5, r14, ROR, r3}, false, al, "al r5 r14 ROR r3", "al_r5_r14_ROR_r3"},
    {{al, r10, r7, LSR, r14},
     false,
     al,
     "al r10 r7 LSR r14",
     "al_r10_r7_LSR_r14"},
    {{al, r12, r5, LSL, r0}, false, al, "al r12 r5 LSL r0", "al_r12_r5_LSL_r0"},
    {{al, r6, r8, ASR, r14}, false, al, "al r6 r8 ASR r14", "al_r6_r8_ASR_r14"},
    {{al, r10, r7, ROR, r11},
     false,
     al,
     "al r10 r7 ROR r11",
     "al_r10_r7_ROR_r11"},
    {{al, r0, r0, LSL, r6}, false, al, "al r0 r0 LSL r6", "al_r0_r0_LSL_r6"},
    {{al, r1, r3, LSR, r13}, false, al, "al r1 r3 LSR r13", "al_r1_r3_LSR_r13"},
    {{al, r10, r9, ROR, r1}, false, al, "al r10 r9 ROR r1", "al_r10_r9_ROR_r1"},
    {{al, r2, r4, LSL, r6}, false, al, "al r2 r4 LSL r6", "al_r2_r4_LSL_r6"},
    {{al, r13, r11, ROR, r12},
     false,
     al,
     "al r13 r11 ROR r12",
     "al_r13_r11_ROR_r12"},
    {{al, r1, r1, LSL, r1}, false, al, "al r1 r1 LSL r1", "al_r1_r1_LSL_r1"},
    {{al, r0, r7, ASR, r0}, false, al, "al r0 r7 ASR r0", "al_r0_r7_ASR_r0"},
    {{al, r10, r9, LSL, r9}, false, al, "al r10 r9 LSL r9", "al_r10_r9_LSL_r9"},
    {{al, r8, r10, LSR, r12},
     false,
     al,
     "al r8 r10 LSR r12",
     "al_r8_r10_LSR_r12"},
    {{al, r1, r1, ROR, r0}, false, al, "al r1 r1 ROR r0", "al_r1_r1_ROR_r0"},
    {{al, r3, r6, LSR, r8}, false, al, "al r3 r6 LSR r8", "al_r3_r6_LSR_r8"},
    {{al, r4, r1, LSL, r10}, false, al, "al r4 r1 LSL r10", "al_r4_r1_LSL_r10"},
    {{al, r0, r9, ASR, r13}, false, al, "al r0 r9 ASR r13", "al_r0_r9_ASR_r13"},
    {{al, r5, r8, ROR, r13}, false, al, "al r5 r8 ROR r13", "al_r5_r8_ROR_r13"},
    {{al, r5, r0, ROR, r0}, false, al, "al r5 r0 ROR r0", "al_r5_r0_ROR_r0"},
    {{al, r2, r5, ASR, r6}, false, al, "al r2 r5 ASR r6", "al_r2_r5_ASR_r6"},
    {{al, r4, r10, ROR, r10},
     false,
     al,
     "al r4 r10 ROR r10",
     "al_r4_r10_ROR_r10"},
    {{al, r10, r2, LSL, r11},
     false,
     al,
     "al r10 r2 LSL r11",
     "al_r10_r2_LSL_r11"},
    {{al, r8, r13, LSR, r12},
     false,
     al,
     "al r8 r13 LSR r12",
     "al_r8_r13_LSR_r12"},
    {{al, r7, r7, ASR, r2}, false, al, "al r7 r7 ASR r2", "al_r7_r7_ASR_r2"},
    {{al, r11, r2, LSR, r11},
     false,
     al,
     "al r11 r2 LSR r11",
     "al_r11_r2_LSR_r11"},
    {{al, r11, r7, LSR, r5}, false, al, "al r11 r7 LSR r5", "al_r11_r7_LSR_r5"},
    {{al, r5, r10, LSL, r4}, false, al, "al r5 r10 LSL r4", "al_r5_r10_LSL_r4"},
    {{al, r10, r13, ROR, r13},
     false,
     al,
     "al r10 r13 ROR r13",
     "al_r10_r13_ROR_r13"},
    {{al, r10, r11, ROR, r11},
     false,
     al,
     "al r10 r11 ROR r11",
     "al_r10_r11_ROR_r11"},
    {{al, r12, r11, ASR, r13},
     false,
     al,
     "al r12 r11 ASR r13",
     "al_r12_r11_ASR_r13"},
    {{al, r9, r3, ASR, r0}, false, al, "al r9 r3 ASR r0", "al_r9_r3_ASR_r0"},
    {{al, r3, r8, ASR, r2}, false, al, "al r3 r8 ASR r2", "al_r3_r8_ASR_r2"},
    {{al, r11, r11, LSR, r13},
     false,
     al,
     "al r11 r11 LSR r13",
     "al_r11_r11_LSR_r13"},
    {{al, r4, r9, ASR, r9}, false, al, "al r4 r9 ASR r9", "al_r4_r9_ASR_r9"},
    {{al, r1, r13, LSL, r12},
     false,
     al,
     "al r1 r13 LSL r12",
     "al_r1_r13_LSL_r12"},
    {{al, r7, r7, ROR, r4}, false, al, "al r7 r7 ROR r4", "al_r7_r7_ROR_r4"},
    {{al, r7, r6, LSL, r3}, false, al, "al r7 r6 LSL r3", "al_r7_r6_LSL_r3"},
    {{al, r12, r12, ASR, r7},
     false,
     al,
     "al r12 r12 ASR r7",
     "al_r12_r12_ASR_r7"},
    {{al, r0, r13, LSR, r8}, false, al, "al r0 r13 LSR r8", "al_r0_r13_LSR_r8"},
    {{al, r6, r3, ROR, r6}, false, al, "al r6 r3 ROR r6", "al_r6_r3_ROR_r6"},
    {{al, r0, r7, ROR, r9}, false, al, "al r0 r7 ROR r9", "al_r0_r7_ROR_r9"},
    {{al, r9, r3, ROR, r13}, false, al, "al r9 r3 ROR r13", "al_r9_r3_ROR_r13"},
    {{al, r3, r8, LSR, r4}, false, al, "al r3 r8 LSR r4", "al_r3_r8_LSR_r4"},
    {{al, r5, r10, ROR, r4},
     false,
     al,
     "al r5 r10 ROR r4",
     "al_r5_r10_ROR_"
     "r4"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-mov-t32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-movs-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    ShiftType shift = kTests[i].operands.shift;
    Register rs = kTests[i].operands.rs;
    Operand op(rn, shift, rs);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_OPERAND_RN_SHIFT_RS_" #mnemonic "_T32",    \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
