/* importerhelper.c generated by valac, the Vala compiler
 * generated from importerhelper.vala, do not modify */

/* importhelper.vala
 *
 * Copyright (C) 2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *  Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

 G_GNUC_INTERNAL gchar* valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree,
                                                        ValadocApiNode* element,
                                                        const gchar* parameter_name,
                                                        gchar** param_name,
                                                        gchar** param_array_name,
                                                        gboolean* is_return_type_len);
 G_GNUC_INTERNAL gchar** valadoc_importer_helper_split_type_name (const gchar* id,
                                                 gint* result_length1);
 G_GNUC_INTERNAL const gchar* valadoc_api_parameter_get_implicit_array_length_cparameter_name (ValadocApiParameter* self);
 G_GNUC_INTERNAL const gchar* valadoc_api_callable_get_implicit_array_length_cparameter_name (ValadocApiCallable* self);
 G_GNUC_INTERNAL void valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment,
                                                 ValadocContentContentFactory* factory);
 G_GNUC_INTERNAL ValadocContentParagraph* valadoc_importer_helper_split_paragraph (ValadocContentParagraph* p,
                                                                  ValadocContentContentFactory* factory);
 G_GNUC_INTERNAL ValadocContentText* valadoc_importer_helper_split_text (ValadocContentText* text,
                                                        ValadocContentContentFactory* factory);
 G_GNUC_INTERNAL ValadocContentRun* valadoc_importer_helper_split_run (ValadocContentRun* run,
                                                      ValadocContentContentFactory* factory);
 G_GNUC_INTERNAL ValadocContentInline* valadoc_importer_helper_split_inline (ValadocContentInline* item,
                                                            ValadocContentContentFactory* factory);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

 G_GNUC_INTERNAL gchar*
valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree,
                                                 ValadocApiNode* element,
                                                 const gchar* parameter_name,
                                                 gchar** param_name,
                                                 gchar** param_array_name,
                                                 gboolean* is_return_type_len)
{
	gchar* _vala_param_name = NULL;
	gchar* _vala_param_array_name = NULL;
	gboolean _vala_is_return_type_len = FALSE;
	gchar** parts = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	ValadocApiParameter* param = NULL;
	gboolean _tmp26_ = FALSE;
	gchar** _tmp31_;
	gint _tmp31__length1;
	ValadocApiItem* inner = NULL;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_;
	ValadocApiItem* _tmp57_;
	gchar* cname = NULL;
	ValadocApiItem* _tmp59_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* result;
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (parameter_name != NULL, NULL);
	_tmp1_ = valadoc_importer_helper_split_type_name (parameter_name, &_tmp0_);
	parts = _tmp1_;
	parts_length1 = _tmp0_;
	_parts_size_ = parts_length1;
	_vala_is_return_type_len = FALSE;
	_g_free0 (_vala_param_array_name);
	_vala_param_array_name = NULL;
	param = NULL;
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp2_;
		gint _node_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _node_index = 0;
		_tmp2_ = valadoc_api_node_get_children_by_type (element, VALADOC_API_NODE_TYPE_FORMAL_PARAMETER, FALSE);
		_node_list = _tmp2_;
		_tmp3_ = _node_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_node_size = _tmp5_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValadocApiNode* node = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValadocApiNode* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			ValadocApiNode* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			_node_index = _node_index + 1;
			_tmp6_ = _node_index;
			_tmp7_ = _node_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _node_list;
			_tmp9_ = vala_list_get (_tmp8_, _node_index);
			node = (ValadocApiNode*) _tmp9_;
			_tmp10_ = node;
			_tmp11_ = valadoc_api_node_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = parts;
			_tmp13__length1 = parts_length1;
			_tmp14_ = _tmp13_[0];
			if (g_strcmp0 (_tmp12_, _tmp14_) == 0) {
				ValadocApiNode* _tmp15_;
				ValadocApiParameter* _tmp16_;
				_tmp15_ = node;
				_tmp16_ = _g_object_ref0 (VALADOC_API_IS_PARAMETER (_tmp15_) ? ((ValadocApiParameter*) _tmp15_) : NULL);
				_g_object_unref0 (param);
				param = _tmp16_;
				_g_object_unref0 (node);
				break;
			}
			_tmp17_ = node;
			_tmp18_ = valadoc_api_parameter_get_implicit_array_length_cparameter_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALADOC_API_TYPE_PARAMETER, ValadocApiParameter));
			_tmp19_ = _tmp18_;
			_tmp20_ = parts;
			_tmp20__length1 = parts_length1;
			_tmp21_ = _tmp20_[0];
			if (g_strcmp0 (_tmp19_, _tmp21_) == 0) {
				ValadocApiNode* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp22_ = node;
				_tmp23_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALADOC_API_TYPE_PARAMETER, ValadocApiParameter));
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (_vala_param_array_name);
				_vala_param_array_name = _tmp25_;
				_g_object_unref0 (node);
				break;
			}
			_g_object_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	if (VALADOC_API_IS_CALLABLE (element)) {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		const gchar* _tmp30_;
		_tmp27_ = valadoc_api_callable_get_implicit_array_length_cparameter_name (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_CALLABLE, ValadocApiCallable));
		_tmp28_ = _tmp27_;
		_tmp29_ = parts;
		_tmp29__length1 = parts_length1;
		_tmp30_ = _tmp29_[0];
		_tmp26_ = g_strcmp0 (_tmp28_, _tmp30_) == 0;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		_vala_is_return_type_len = TRUE;
	}
	_tmp31_ = parts;
	_tmp31__length1 = parts_length1;
	if (_tmp31__length1 == 1) {
		gchar* _tmp32_;
		_tmp32_ = g_strdup (parameter_name);
		_g_free0 (_vala_param_name);
		_vala_param_name = _tmp32_;
		result = NULL;
		_g_object_unref0 (param);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (param_name) {
			*param_name = _vala_param_name;
		} else {
			_g_free0 (_vala_param_name);
		}
		if (param_array_name) {
			*param_array_name = _vala_param_array_name;
		} else {
			_g_free0 (_vala_param_array_name);
		}
		if (is_return_type_len) {
			*is_return_type_len = _vala_is_return_type_len;
		}
		return result;
	}
	inner = NULL;
	_tmp34_ = _vala_param_array_name;
	if (_tmp34_ != NULL) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = _vala_is_return_type_len;
	}
	if (_tmp33_) {
		ValadocApiNode* _tmp35_;
		_tmp35_ = valadoc_api_tree_search_symbol_str (tree, NULL, "int");
		_g_object_unref0 (inner);
		inner = (ValadocApiItem*) _tmp35_;
	} else {
		ValadocApiParameter* _tmp36_;
		_tmp36_ = param;
		if (_tmp36_ != NULL) {
			ValadocApiParameter* _tmp37_;
			ValadocApiTypeReference* _tmp38_;
			ValadocApiTypeReference* _tmp39_;
			ValadocApiItem* _tmp40_;
			_tmp37_ = param;
			_tmp38_ = valadoc_api_parameter_get_parameter_type (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = _g_object_ref0 ((ValadocApiItem*) _tmp39_);
			_g_object_unref0 (inner);
			inner = _tmp40_;
		}
	}
	while (TRUE) {
		ValadocApiItem* _tmp41_;
		ValadocApiItem* _tmp42_;
		_tmp41_ = inner;
		if (!(_tmp41_ != NULL)) {
			break;
		}
		_tmp42_ = inner;
		if (VALADOC_API_IS_TYPEREFERENCE (_tmp42_)) {
			ValadocApiItem* _tmp43_;
			ValadocApiItem* _tmp44_;
			ValadocApiItem* _tmp45_;
			ValadocApiItem* _tmp46_;
			_tmp43_ = inner;
			_tmp44_ = valadoc_api_typereference_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference));
			_tmp45_ = _tmp44_;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (inner);
			inner = _tmp46_;
		} else {
			ValadocApiItem* _tmp47_;
			_tmp47_ = inner;
			if (VALADOC_API_IS_POINTER (_tmp47_)) {
				ValadocApiItem* _tmp48_;
				ValadocApiItem* _tmp49_;
				ValadocApiItem* _tmp50_;
				ValadocApiItem* _tmp51_;
				_tmp48_ = inner;
				_tmp49_ = valadoc_api_pointer_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALADOC_API_TYPE_POINTER, ValadocApiPointer));
				_tmp50_ = _tmp49_;
				_tmp51_ = _g_object_ref0 (_tmp50_);
				_g_object_unref0 (inner);
				inner = _tmp51_;
			} else {
				ValadocApiItem* _tmp52_;
				_tmp52_ = inner;
				if (VALADOC_API_IS_ARRAY (_tmp52_)) {
					ValadocApiItem* _tmp53_;
					ValadocApiItem* _tmp54_;
					ValadocApiItem* _tmp55_;
					ValadocApiItem* _tmp56_;
					_tmp53_ = inner;
					_tmp54_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
					_tmp55_ = _tmp54_;
					_tmp56_ = _g_object_ref0 (_tmp55_);
					_g_object_unref0 (inner);
					inner = _tmp56_;
				} else {
					break;
				}
			}
		}
	}
	_tmp57_ = inner;
	if (_tmp57_ == NULL) {
		gchar* _tmp58_;
		_tmp58_ = g_strdup (parameter_name);
		_g_free0 (_vala_param_name);
		_vala_param_name = _tmp58_;
		result = NULL;
		_g_object_unref0 (inner);
		_g_object_unref0 (param);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (param_name) {
			*param_name = _vala_param_name;
		} else {
			_g_free0 (_vala_param_name);
		}
		if (param_array_name) {
			*param_array_name = _vala_param_array_name;
		} else {
			_g_free0 (_vala_param_array_name);
		}
		if (is_return_type_len) {
			*is_return_type_len = _vala_is_return_type_len;
		}
		return result;
	}
	cname = NULL;
	_tmp59_ = inner;
	if (VALADOC_API_IS_ERROR_DOMAIN (_tmp59_)) {
		ValadocApiItem* _tmp60_;
		gchar* _tmp61_;
		_tmp60_ = inner;
		_tmp61_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
		_g_free0 (cname);
		cname = _tmp61_;
	} else {
		ValadocApiItem* _tmp62_;
		_tmp62_ = inner;
		if (VALADOC_API_IS_STRUCT (_tmp62_)) {
			ValadocApiItem* _tmp63_;
			gchar* _tmp64_;
			_tmp63_ = inner;
			_tmp64_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
			_g_free0 (cname);
			cname = _tmp64_;
		} else {
			ValadocApiItem* _tmp65_;
			_tmp65_ = inner;
			if (VALADOC_API_IS_CLASS (_tmp65_)) {
				ValadocApiItem* _tmp66_;
				gchar* _tmp67_;
				_tmp66_ = inner;
				_tmp67_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
				_g_free0 (cname);
				cname = _tmp67_;
			} else {
				ValadocApiItem* _tmp68_;
				_tmp68_ = inner;
				if (VALADOC_API_IS_ENUM (_tmp68_)) {
					ValadocApiItem* _tmp69_;
					gchar* _tmp70_;
					_tmp69_ = inner;
					_tmp70_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
					_g_free0 (cname);
					cname = _tmp70_;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp71_ = parts;
	_tmp71__length1 = parts_length1;
	_tmp72_ = _tmp71_[0];
	_tmp71_[0] = NULL;
	_g_free0 (_vala_param_name);
	_vala_param_name = _tmp72_;
	_tmp73_ = cname;
	_tmp74_ = g_strconcat ("c::", _tmp73_, NULL);
	_tmp75_ = _tmp74_;
	_tmp76_ = parts;
	_tmp76__length1 = parts_length1;
	_tmp77_ = _tmp76_[1];
	_tmp78_ = g_strconcat (_tmp75_, _tmp77_, NULL);
	_tmp79_ = _tmp78_;
	_tmp80_ = parts;
	_tmp80__length1 = parts_length1;
	_tmp81_ = _tmp80_[2];
	_tmp82_ = g_strconcat (_tmp79_, _tmp81_, NULL);
	_tmp83_ = _tmp82_;
	_g_free0 (_tmp79_);
	_g_free0 (_tmp75_);
	result = _tmp83_;
	_g_free0 (cname);
	_g_object_unref0 (inner);
	_g_object_unref0 (param);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (param_name) {
		*param_name = _vala_param_name;
	} else {
		_g_free0 (_vala_param_name);
	}
	if (param_array_name) {
		*param_array_name = _vala_param_array_name;
	} else {
		_g_free0 (_vala_param_array_name);
	}
	if (is_return_type_len) {
		*is_return_type_len = _vala_is_return_type_len;
	}
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

 G_GNUC_INTERNAL gchar**
valadoc_importer_helper_split_type_name (const gchar* id,
                                         gint* result_length1)
{
	gunichar c = 0U;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar** result;
	g_return_val_if_fail (id != NULL, NULL);
	{
		const gchar* pos = NULL;
		pos = id;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp3_;
				if (!_tmp0_) {
					const gchar* _tmp1_;
					const gchar* _tmp2_;
					_tmp1_ = pos;
					_tmp2_ = g_utf8_next_char (_tmp1_);
					pos = _tmp2_;
				}
				_tmp0_ = FALSE;
				_tmp3_ = pos;
				c = string_get_char (_tmp3_, (glong) 0);
				if (!(c != ((gunichar) '\0'))) {
					break;
				}
				switch (c) {
					case '-':
					{
						const gchar* _tmp4_;
						gchar* _tmp5_;
						gchar* _tmp6_;
						const gchar* _tmp7_;
						gchar* _tmp8_;
						gchar** _tmp9_;
						gchar** _tmp10_;
						gint _tmp10__length1;
						_tmp4_ = pos;
						_tmp5_ = string_substring (id, (glong) 0, (glong) (((gchar*) _tmp4_) - ((gchar*) id)));
						_tmp6_ = g_strdup ("->");
						_tmp7_ = pos;
						_tmp8_ = g_strdup ((const gchar*) (((gchar*) _tmp7_) + 2));
						_tmp9_ = g_new0 (gchar*, 3 + 1);
						_tmp9_[0] = _tmp5_;
						_tmp9_[1] = _tmp6_;
						_tmp9_[2] = _tmp8_;
						_tmp10_ = _tmp9_;
						_tmp10__length1 = 3;
						if (result_length1) {
							*result_length1 = _tmp10__length1;
						}
						result = _tmp10_;
						return result;
					}
					case ':':
					{
						const gchar* _tmp11_ = NULL;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* sep = NULL;
						gchar* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						gint _tmp21_;
						gint _tmp22_;
						gchar* _tmp23_;
						gchar** _tmp24_;
						gchar** _tmp25_;
						gint _tmp25__length1;
						_tmp12_ = pos;
						_tmp13_ = g_utf8_next_char (_tmp12_);
						if (string_get_char (_tmp13_, (glong) 0) == ((gunichar) ':')) {
							_tmp11_ = "::";
						} else {
							_tmp11_ = ":";
						}
						_tmp14_ = g_strdup (_tmp11_);
						sep = _tmp14_;
						_tmp15_ = pos;
						_tmp16_ = string_substring (id, (glong) 0, (glong) (((gchar*) _tmp15_) - ((gchar*) id)));
						_tmp17_ = sep;
						_tmp18_ = g_strdup (_tmp17_);
						_tmp19_ = pos;
						_tmp20_ = sep;
						_tmp21_ = strlen (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = g_strdup ((const gchar*) (((gchar*) _tmp19_) + _tmp22_));
						_tmp24_ = g_new0 (gchar*, 3 + 1);
						_tmp24_[0] = _tmp16_;
						_tmp24_[1] = _tmp18_;
						_tmp24_[2] = _tmp23_;
						_tmp25_ = _tmp24_;
						_tmp25__length1 = 3;
						if (result_length1) {
							*result_length1 = _tmp25__length1;
						}
						result = _tmp25_;
						_g_free0 (sep);
						return result;
					}
					case '.':
					{
						const gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						gchar** _tmp31_;
						gchar** _tmp32_;
						gint _tmp32__length1;
						_tmp26_ = pos;
						_tmp27_ = string_substring (id, (glong) 0, (glong) (((gchar*) _tmp26_) - ((gchar*) id)));
						_tmp28_ = g_strdup (".");
						_tmp29_ = pos;
						_tmp30_ = g_strdup ((const gchar*) (((gchar*) _tmp29_) + 1));
						_tmp31_ = g_new0 (gchar*, 3 + 1);
						_tmp31_[0] = _tmp27_;
						_tmp31_[1] = _tmp28_;
						_tmp31_[2] = _tmp30_;
						_tmp32_ = _tmp31_;
						_tmp32__length1 = 3;
						if (result_length1) {
							*result_length1 = _tmp32__length1;
						}
						result = _tmp32_;
						return result;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp33_ = g_strdup (id);
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	return result;
}

 G_GNUC_INTERNAL void
valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment,
                                            ValadocContentContentFactory* factory)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocContentParagraph* first_paragraph = NULL;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	gpointer _tmp6_;
	ValadocContentBlock* _tmp7_;
	ValadocContentParagraph* _tmp8_;
	ValadocContentParagraph* _tmp9_;
	ValadocContentParagraph* _tmp14_;
	ValadocContentParagraph* _tmp15_;
	ValadocContentParagraph* _tmp16_;
	ValadocContentParagraph* second_paragraph = NULL;
	ValadocContentParagraph* _tmp17_;
	ValadocContentParagraph* _tmp18_;
	ValadocContentParagraph* _tmp19_;
	ValadocContentParagraph* _tmp20_;
	g_return_if_fail (comment != NULL);
	g_return_if_fail (factory != NULL);
	_tmp0_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) comment);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		return;
	}
	_tmp4_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) comment);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_get (_tmp5_, 0);
	_tmp7_ = (ValadocContentBlock*) _tmp6_;
	_tmp8_ = VALADOC_CONTENT_IS_PARAGRAPH (_tmp7_) ? ((ValadocContentParagraph*) _tmp7_) : NULL;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (_tmp7_);
	}
	first_paragraph = _tmp8_;
	_tmp9_ = first_paragraph;
	if (_tmp9_ == NULL) {
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		ValadocContentParagraph* _tmp12_;
		ValadocContentParagraph* _tmp13_;
		_tmp10_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) comment);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_content_content_factory_create_paragraph (factory);
		_tmp13_ = _tmp12_;
		vala_list_insert (_tmp11_, 1, (ValadocContentBlock*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (first_paragraph);
		return;
	}
	_tmp14_ = first_paragraph;
	valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp14_, VALADOC_CONTENT_HORIZONTAL_ALIGN_NONE);
	_tmp15_ = first_paragraph;
	valadoc_content_style_attributes_set_vertical_align ((ValadocContentStyleAttributes*) _tmp15_, VALADOC_CONTENT_VERTICAL_ALIGN_NONE);
	_tmp16_ = first_paragraph;
	valadoc_content_style_attributes_set_style ((ValadocContentStyleAttributes*) _tmp16_, NULL);
	_tmp17_ = first_paragraph;
	_tmp18_ = valadoc_importer_helper_split_paragraph (_tmp17_, factory);
	second_paragraph = _tmp18_;
	_tmp19_ = second_paragraph;
	if (_tmp19_ == NULL) {
		_g_object_unref0 (second_paragraph);
		_g_object_unref0 (first_paragraph);
		return;
	}
	_tmp20_ = second_paragraph;
	if (valadoc_content_content_element_is_empty ((ValadocContentContentElement*) _tmp20_) == FALSE) {
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		ValadocContentParagraph* _tmp23_;
		_tmp21_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) comment);
		_tmp22_ = _tmp21_;
		_tmp23_ = second_paragraph;
		vala_list_insert (_tmp22_, 1, (ValadocContentBlock*) _tmp23_);
	}
	_g_object_unref0 (second_paragraph);
	_g_object_unref0 (first_paragraph);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

 G_GNUC_INTERNAL inline ValadocContentText*
valadoc_importer_helper_split_text (ValadocContentText* text,
                                    ValadocContentContentFactory* factory)
{
	gint offset = 0;
	ValadocContentText* result;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	offset = 0;
	while (TRUE) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* cmp0 = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValadocContentText* sec = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValadocContentText* _tmp18_;
		ValadocContentText* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp0_ = valadoc_content_text_get_content (text);
		_tmp1_ = _tmp0_;
		offset = string_index_of_char (_tmp1_, (gunichar) '.', offset);
		if (!(offset >= 0)) {
			break;
		}
		if (offset >= 2) {
			const gchar* cmp4 = NULL;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp5_;
			gboolean _tmp7_ = FALSE;
			const gchar* _tmp8_;
			_tmp2_ = valadoc_content_text_get_content (text);
			_tmp3_ = _tmp2_;
			cmp4 = (const gchar*) ((((gchar*) _tmp3_) + offset) - 2);
			_tmp5_ = cmp4;
			if (g_str_has_prefix (_tmp5_, " e.g.")) {
				_tmp4_ = TRUE;
			} else {
				const gchar* _tmp6_;
				_tmp6_ = cmp4;
				_tmp4_ = g_str_has_prefix (_tmp6_, "(e.g.");
			}
			if (_tmp4_) {
				offset = offset + 3;
				continue;
			}
			_tmp8_ = cmp4;
			if (g_str_has_prefix (_tmp8_, " i.e.")) {
				_tmp7_ = TRUE;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = cmp4;
				_tmp7_ = g_str_has_prefix (_tmp9_, "(i.e.");
			}
			if (_tmp7_) {
				offset = offset + 3;
				continue;
			}
		}
		_tmp10_ = valadoc_content_text_get_content (text);
		_tmp11_ = _tmp10_;
		cmp0 = (const gchar*) (((gchar*) _tmp11_) + offset);
		_tmp12_ = cmp0;
		if (g_str_has_prefix (_tmp12_, "...")) {
			offset = offset + 3;
			continue;
		}
		_tmp13_ = cmp0;
		if (g_ascii_isdigit (string_get (_tmp13_, (glong) 1))) {
			offset = offset + 2;
			continue;
		}
		_tmp14_ = valadoc_content_text_get_content (text);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_substring (_tmp15_, (glong) (offset + 1), (glong) -1);
		_tmp17_ = _tmp16_;
		_tmp18_ = valadoc_content_content_factory_create_text (factory, _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		sec = _tmp19_;
		_tmp20_ = valadoc_content_text_get_content (text);
		_tmp21_ = _tmp20_;
		_tmp22_ = string_substring (_tmp21_, (glong) 0, (glong) (offset + 1));
		_tmp23_ = _tmp22_;
		valadoc_content_text_set_content (text, _tmp23_);
		_g_free0 (_tmp23_);
		result = sec;
		return result;
	}
	result = NULL;
	return result;
}

 G_GNUC_INTERNAL inline ValadocContentRun*
valadoc_importer_helper_split_run (ValadocContentRun* run,
                                   ValadocContentContentFactory* factory)
{
	ValadocContentRunStyle _tmp0_;
	ValadocContentRunStyle _tmp1_;
	ValadocContentRun* sec = NULL;
	ValaIterator* iter = NULL;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValaIterator* _tmp4_;
	ValadocContentRun* result;
	g_return_val_if_fail (run != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	_tmp0_ = valadoc_content_run_get_style (run);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALADOC_CONTENT_RUN_STYLE_NONE) {
		result = NULL;
		return result;
	}
	sec = NULL;
	_tmp2_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) run);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_iterable_iterator ((ValaIterable*) _tmp3_);
	iter = _tmp4_;
	{
		gboolean has_next = FALSE;
		ValaIterator* _tmp5_;
		_tmp5_ = iter;
		has_next = vala_iterator_next (_tmp5_);
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				ValadocContentInline* item = NULL;
				ValaIterator* _tmp8_;
				gpointer _tmp9_;
				ValadocContentRun* _tmp10_;
				if (!_tmp6_) {
					ValaIterator* _tmp7_;
					_tmp7_ = iter;
					has_next = vala_iterator_next (_tmp7_);
				}
				_tmp6_ = FALSE;
				if (!has_next) {
					break;
				}
				_tmp8_ = iter;
				_tmp9_ = vala_iterator_get (_tmp8_);
				item = (ValadocContentInline*) _tmp9_;
				_tmp10_ = sec;
				if (_tmp10_ == NULL) {
					ValadocContentInline* tmp = NULL;
					ValadocContentInline* _tmp11_;
					ValadocContentInline* _tmp12_;
					ValadocContentInline* _tmp13_;
					_tmp11_ = item;
					_tmp12_ = valadoc_importer_helper_split_inline (_tmp11_, factory);
					tmp = _tmp12_;
					_tmp13_ = tmp;
					if (_tmp13_ != NULL) {
						ValadocContentRunStyle _tmp14_;
						ValadocContentRunStyle _tmp15_;
						ValadocContentRun* _tmp16_;
						ValadocContentRun* _tmp17_;
						ValaList* _tmp18_;
						ValaList* _tmp19_;
						ValadocContentInline* _tmp20_;
						_tmp14_ = valadoc_content_run_get_style (run);
						_tmp15_ = _tmp14_;
						_tmp16_ = valadoc_content_content_factory_create_run (factory, _tmp15_);
						_g_object_unref0 (sec);
						sec = _tmp16_;
						_tmp17_ = sec;
						_tmp18_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp17_);
						_tmp19_ = _tmp18_;
						_tmp20_ = tmp;
						vala_collection_add ((ValaCollection*) _tmp19_, _tmp20_);
					}
					_g_object_unref0 (tmp);
				} else {
					ValadocContentRun* _tmp21_;
					ValaList* _tmp22_;
					ValaList* _tmp23_;
					ValadocContentInline* _tmp24_;
					ValaIterator* _tmp25_;
					_tmp21_ = sec;
					_tmp22_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = item;
					vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
					_tmp25_ = iter;
					vala_iterator_remove (_tmp25_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = sec;
	_vala_iterator_unref0 (iter);
	return result;
}

 G_GNUC_INTERNAL inline ValadocContentInline*
valadoc_importer_helper_split_inline (ValadocContentInline* item,
                                      ValadocContentContentFactory* factory)
{
	ValadocContentInline* result;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	if (VALADOC_CONTENT_IS_TEXT (item)) {
		ValadocContentText* _tmp0_;
		_tmp0_ = valadoc_importer_helper_split_text (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_CONTENT_TYPE_TEXT, ValadocContentText), factory);
		result = (ValadocContentInline*) _tmp0_;
		return result;
	} else {
		if (VALADOC_CONTENT_IS_RUN (item)) {
			ValadocContentRun* _tmp1_;
			_tmp1_ = valadoc_importer_helper_split_run (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_CONTENT_TYPE_RUN, ValadocContentRun), factory);
			result = (ValadocContentInline*) _tmp1_;
			return result;
		}
	}
	result = NULL;
	return result;
}

 G_GNUC_INTERNAL inline ValadocContentParagraph*
valadoc_importer_helper_split_paragraph (ValadocContentParagraph* p,
                                         ValadocContentContentFactory* factory)
{
	ValadocContentParagraph* sec = NULL;
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaIterator* _tmp2_;
	ValadocContentParagraph* result;
	g_return_val_if_fail (p != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	sec = NULL;
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) p);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
	iter = _tmp2_;
	{
		gboolean has_next = FALSE;
		ValaIterator* _tmp3_;
		_tmp3_ = iter;
		has_next = vala_iterator_next (_tmp3_);
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				ValadocContentInline* item = NULL;
				ValaIterator* _tmp6_;
				gpointer _tmp7_;
				ValadocContentParagraph* _tmp8_;
				if (!_tmp4_) {
					ValaIterator* _tmp5_;
					_tmp5_ = iter;
					has_next = vala_iterator_next (_tmp5_);
				}
				_tmp4_ = FALSE;
				if (!has_next) {
					break;
				}
				_tmp6_ = iter;
				_tmp7_ = vala_iterator_get (_tmp6_);
				item = (ValadocContentInline*) _tmp7_;
				_tmp8_ = sec;
				if (_tmp8_ == NULL) {
					ValadocContentInline* tmp = NULL;
					ValadocContentInline* _tmp9_;
					ValadocContentInline* _tmp10_;
					ValadocContentInline* _tmp11_;
					_tmp9_ = item;
					_tmp10_ = valadoc_importer_helper_split_inline (_tmp9_, factory);
					tmp = _tmp10_;
					_tmp11_ = tmp;
					if (_tmp11_ != NULL) {
						ValadocContentParagraph* _tmp12_;
						ValadocContentParagraph* _tmp13_;
						ValadocContentHorizontalAlign _tmp14_;
						ValadocContentHorizontalAlign _tmp15_;
						ValadocContentParagraph* _tmp16_;
						ValadocContentVerticalAlign _tmp17_;
						ValadocContentVerticalAlign _tmp18_;
						ValadocContentParagraph* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						ValadocContentParagraph* _tmp22_;
						ValaList* _tmp23_;
						ValaList* _tmp24_;
						ValadocContentInline* _tmp25_;
						_tmp12_ = valadoc_content_content_factory_create_paragraph (factory);
						_g_object_unref0 (sec);
						sec = _tmp12_;
						_tmp13_ = sec;
						_tmp14_ = valadoc_content_style_attributes_get_horizontal_align ((ValadocContentStyleAttributes*) p);
						_tmp15_ = _tmp14_;
						valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp13_, _tmp15_);
						_tmp16_ = sec;
						_tmp17_ = valadoc_content_style_attributes_get_vertical_align ((ValadocContentStyleAttributes*) p);
						_tmp18_ = _tmp17_;
						valadoc_content_style_attributes_set_vertical_align ((ValadocContentStyleAttributes*) _tmp16_, _tmp18_);
						_tmp19_ = sec;
						_tmp20_ = valadoc_content_style_attributes_get_style ((ValadocContentStyleAttributes*) p);
						_tmp21_ = _tmp20_;
						valadoc_content_style_attributes_set_style ((ValadocContentStyleAttributes*) _tmp19_, _tmp21_);
						_tmp22_ = sec;
						_tmp23_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = tmp;
						vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
					}
					_g_object_unref0 (tmp);
				} else {
					ValadocContentParagraph* _tmp26_;
					ValaList* _tmp27_;
					ValaList* _tmp28_;
					ValadocContentInline* _tmp29_;
					ValaIterator* _tmp30_;
					_tmp26_ = sec;
					_tmp27_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = item;
					vala_collection_add ((ValaCollection*) _tmp28_, _tmp29_);
					_tmp30_ = iter;
					vala_iterator_remove (_tmp30_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = sec;
	_vala_iterator_unref0 (iter);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

