import ConfigParser

class gdmConfigParser(ConfigParser.RawConfigParser):

    def write(self, fp):
        """Write an .ini-format representation of the configuration state."""
        if self._defaults:
            fp.write("[%s]\n" % DEFAULTSECT)
            for (key, value) in self._defaults.items():
                fp.write("%s=%s\n" % (key, str(value).replace('\n', '\n\t')))
            fp.write("\n")
        for section in self._sections:
            fp.write("[%s]\n" % section)
            for (key, value) in self._sections[section].items():
                if key != "__name__":
                    fp.write("%s=%s\n" %
                             (key, str(value).replace('\n', '\n\t')))
            fp.write("\n")

    def optionxform(self, optionstr):
        return optionstr.capitalize()
