/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       PTHICommand.h
//
//  Contents:   header file of PTHICommand class
//
//----------------------------------------------------------------------------
#ifndef __PTHI_COMMAND_H__
#define __PTHI_COMMAND_H__
#include "HECILinux.h"

#define VOID void
#define CERT_HASH_MAX_LENGTH                    64
#define CERT_HASH_MAX_NUMBER                    23
#define NET_TLS_CERT_PKI_MAX_SERIAL_NUMS        3
#define NET_TLS_CERT_PKI_MAX_SERIAL_NUM_LENGTH  16
/*
* Type definitions
*/
typedef char    CHAR;
typedef unsigned char   UINT8;
typedef unsigned short  UINT16;
typedef unsigned int    UINT32;
typedef unsigned long   ULONG;

typedef UINT32 AMT_BOOLEAN;
typedef UINT32 AMT_STATUS;
typedef UINT32 CFG_PROVISIONING_MODE;

typedef CHAR  *PCHAR;
typedef ULONG *PULONG;
typedef UINT32 PT_BOOLEAN;
typedef UINT32 CFG_TIMESTAMP;
typedef UINT16 CFG_TCPIP_PORT;
typedef UINT32 CFG_IPv4_ADDRESS;
typedef UINT32 CFG_PROVISIONING_MODE;

/*
* Constatnts
*/

static const PT_BOOLEAN PT_TRUE = 1;
static const PT_BOOLEAN PT_FALSE = 0;
static const UINT32 BIOS_VERSION_LEN = 65;
static const UINT32 VERSIONS_NUMBER  = 50;/////////
static const UINT32 UNICODE_STRING_LEN = 20;////////
static const UINT32 IDER_LOG_ENTRIES = 16;

const UINT8 MAJOR_VERSION = 1;
const UINT8 MINOR_VERSION = 1;
const UINT8 AMT_MAJOR_VERSION = 1;
const UINT8 AMT_MINOR_VERSION = 1;

typedef enum _AMT_PROVISIONING_TLS_MODE
{
	NOT_READY = 0,
    PSK  = 1,
    PKI  = 2,
} AMT_PROVISIONING_TLS_MODE;

typedef enum _AMT_PROVISIONING_STATE
{
	PROVISIONING_STATE_PRE  = 0,
	PROVISIONING_STATE_IN   = 1,
	PROVISIONING_STATE_POST = 2
} AMT_PROVISIONING_STATE;
typedef enum _AMT_RNG_STATUS
{
	RNG_STATUS_EXIST  = 0,
	RNG_STATUS_IN_PROGRESS = 1,
	RNG_STATUS_NOT_EXIST = 2
} AMT_RNG_STATUS;

#pragma pack (1)
typedef struct _PT_UNICODE_STRING
{
    UINT16  Length;
    UINT8   String[UNICODE_STRING_LEN];
} PT_UNICODE_STRING;

typedef struct _PT_VERSION_TYPE
{
    PT_UNICODE_STRING   Description;
    PT_UNICODE_STRING   Version;
}PT_VERSION_TYPE;

typedef struct _PTHI_VERSION
{
    UINT8   MajorNumber;
    UINT8   MinorNumber;
} PTHI_VERSION;

typedef struct _CODE_VERSIONS
{
    UINT8   BiosVersion[BIOS_VERSION_LEN];
    UINT32  VersionsCount;
    PT_VERSION_TYPE Versions[VERSIONS_NUMBER];
} CODE_VERSIONS;

typedef struct _COMMAND_FMT
{
	union
	{
		UINT32  val;
		struct
		{
			UINT32   Operation   : 23;
			UINT32   IsResponse  : 1;
			UINT32   Class       : 8;
		} fields;
	} cmd;

} COMMAND_FMT;
typedef struct _AMT_HASH_HANDLES
{
	UINT32	Length;
    UINT32	Handles[CERT_HASH_MAX_NUMBER];
}AMT_HASH_HANDLES;

typedef struct _AMT_ANSI_STRING
{
	UINT16	Length;
	CHAR*	Buffer;
}AMT_ANSI_STRING;

typedef struct _CERTHASH_ENTRY
{
    AMT_BOOLEAN     IsDefault;
    AMT_BOOLEAN     IsActive;
    UINT8           CertificateHash[CERT_HASH_MAX_LENGTH];
	UINT8           HashAlgorithm;
    AMT_ANSI_STRING Name;
}CERTHASH_ENTRY;


typedef struct _PTHI_MESSAGE_HEADER
{
	PTHI_VERSION Version;
	UINT16       Reserved;
	COMMAND_FMT  Command;
	UINT32       Length;

} PTHI_MESSAGE_HEADER;
typedef enum
{
   CERT_HASH_ALGORITHM_MD5 = 0,  // 16 bytes
   CERT_HASH_ALGORITHM_SHA1,     // 20 bytes
   CERT_HASH_ALGORITHM_SHA256,   // 32 bytes
   CERT_HASH_ALGORITHM_SHA512,   // 64 bytes
} CERT_HASH_ALGORITHM;
typedef struct
{
      UINT16      Year;
      UINT16      Month;
      UINT16      DayOfWeek;
      UINT16      Day;
      UINT16      Hour;
      UINT16      Minute;
      UINT16      Second;
} TIME_DATE;
typedef struct _AMT_PROV_AUDIT_RECORD
{
   UINT8                ProvisioningTLSMode;
   AMT_BOOLEAN          SecureDNS;
   AMT_BOOLEAN          HostInitiated;
   CERT_HASH_ALGORITHM  SelectedHashType;
   UINT8                SelectedHashData[CERT_HASH_MAX_LENGTH];
   UINT8                CaCertificateSerials[NET_TLS_CERT_PKI_MAX_SERIAL_NUMS*NET_TLS_CERT_PKI_MAX_SERIAL_NUM_LENGTH];
   AMT_BOOLEAN          AdditionalCaSerialNums;
   AMT_BOOLEAN          IsOemDefault;
   AMT_BOOLEAN          IsTimeValid;
   UINT32               ProvServerIP;
   TIME_DATE            TlsStartTime;
   AMT_ANSI_STRING      ProvServerFQDN;
}AMT_PROV_AUDIT_RECORD;

typedef struct _CFG_GET_CODE_VERSIONS_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
	CODE_VERSIONS CodeVersions;
} CFG_GET_CODE_VERSIONS_RESPONSE;
typedef struct _CFG_GET_PROVISIONING_MODE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
	CFG_PROVISIONING_MODE	ProvisioningMode;
    AMT_BOOLEAN	LegacyMode;
} CFG_GET_PROVISIONING_MODE_RESPONSE;

typedef struct _CFG_GET_PROVISIONING_STATE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
    AMT_PROVISIONING_STATE	ProvisioningState;
} CFG_GET_PROVISIONING_STATE_RESPONSE;

typedef struct _CFG_GENERATE_RNG_SEED_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_GENERATE_RNG_SEED_RESPONSE;

typedef struct _CFG_GET_RNG_SEED_STATUS_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
	AMT_RNG_STATUS RngStatus;
} CFG_GET_RNG_SEED_STATUS_RESPONSE;


const UINT32 ENDOFPOST_STATE_REQUEST    = 0x04000020;
const UINT32 ENDOFPOST_STATE_RESPONSE   = 0x04800020;

const PTHI_MESSAGE_HEADER GET_ENDOFPOST_STATE_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{ENDOFPOST_STATE_REQUEST},0
};


typedef struct _CFG_GET_ZERO_TOUCH_ENABLED_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
    AMT_BOOLEAN	ZeroTouchEnabled;
} CFG_GET_ZERO_TOUCH_ENABLED_RESPONSE;

typedef struct _CFG_GET_PROVISIONING_TLS_MODE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_STATUS	Status;
	AMT_PROVISIONING_TLS_MODE	ProvisioningTlsMode;
} CFG_GET_PROVISIONING_TLS_MODE_RESPONSE;

typedef struct _CFG_START_CONFIGURATION_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_START_CONFIGURATION_RESPONSE;

typedef struct _CFG_SET_PROVISIONING_SERVER_OTP_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_SET_PROVISIONING_SERVER_OTP_RESPONSE;

typedef struct _CFG_SET_DNS_SUFFIX_RESPONSE
{
	PTHI_MESSAGE_HEADER Header;
	AMT_STATUS   Status;
} CFG_SET_DNS_SUFFIX_RESPONSE;

typedef struct _CFG_GET_HASH_HANDLES_RESPONSE
{
    PTHI_MESSAGE_HEADER Header;
    AMT_STATUS          Status;
    AMT_HASH_HANDLES    HashHandles;
} CFG_GET_HASH_HANDLES_RESPONSE;

typedef struct _CFG_GET_CERTHASH_ENTRY_RESPONSE
{
    PTHI_MESSAGE_HEADER         Header;
    AMT_STATUS                  Status;
    CERTHASH_ENTRY              Hash;
} CFG_GET_CERTHASH_ENTRY_RESPONSE;
typedef struct _CFG_GET_PKI_FQDN_SUFFIX_RESPONSE
{
    PTHI_MESSAGE_HEADER      Header;
    AMT_STATUS               Status;
    AMT_ANSI_STRING          Suffix;
} CFG_GET_PKI_FQDN_SUFFIX_RESPONSE;
typedef struct _CFG_GET_AUDIT_RECORD_RESPONSE
{
    PTHI_MESSAGE_HEADER         Header;
    AMT_STATUS                  Status;
    AMT_PROV_AUDIT_RECORD       AuditRecord;
} CFG_GET_AUDIT_RECORD_RESPONSE;

typedef struct _CFG_GET_PID_RESPONSE
{
	PTHI_MESSAGE_HEADER		Header;
	AMT_STATUS		        Status;
    UINT8		            PID[8];
} CFG_GET_PID_RESPONSE;




#pragma pack ( )

class PTHICommand
{
public:
    PTHICommand(bool verbose = false);
    ~PTHICommand();
	UINT32 DiscoveryTest(PTHICommand *command, bool isActivate);

    AMT_STATUS GetCodeVersions(CODE_VERSIONS *CodeVersions,HECI_VERSION *hecversion);
    VOID DisplayCodeVersions(const CODE_VERSIONS *versions);

	AMT_STATUS GetProvisioningMode(AMT_BOOLEAN *legacy);
	VOID DisplayAMTMode(const AMT_BOOLEAN *legacy);

	AMT_STATUS GetProvisioningState(AMT_PROVISIONING_STATE *state);
	VOID DisplayProvisioningState(const AMT_PROVISIONING_STATE *state);

	AMT_STATUS GetEndOfPostState(UINT8 *BiosModeState);

	AMT_STATUS GenerateRngKey();

	AMT_STATUS GetRngSeedStatus(AMT_RNG_STATUS *rngStatus);
    VOID DisplayRngSeedStatus(const AMT_RNG_STATUS *rngStatus);
	AMT_STATUS GetZeroTouchEnabled(AMT_BOOLEAN *zeroTouchEnabled);
    VOID DisplayZTCEnabled(const AMT_BOOLEAN *ztcEnabled);

	AMT_STATUS GetProvisioningTlsMode(AMT_PROVISIONING_TLS_MODE *provisioningTlsMode);
    VOID DisplayProvisioningTlsMode(const AMT_PROVISIONING_TLS_MODE *provisioningTlsMode);
	AMT_STATUS StartConfiguration();

	AMT_STATUS SetProvisioningServerOTP(AMT_ANSI_STRING passwordOTP);

	AMT_STATUS SetDnsSuffix(AMT_ANSI_STRING dnsSuffix);

    AMT_STATUS EnumerateHashHandles(AMT_HASH_HANDLES *hashHandles);
    AMT_STATUS GetCertificateHashEntry(UINT32 hashHandle, CERTHASH_ENTRY *hashEntry);
    AMT_STATUS GetDnsSuffix(AMT_ANSI_STRING *dnsSuffix);
    AMT_STATUS GetAMTSetupAuditRecord(AMT_PROV_AUDIT_RECORD *auditRecord);
	VOID DisplayHashEntry(CERTHASH_ENTRY hashEntry);
    AMT_STATUS GetPID(UINT8 *pid);
	HECILinux PTHIClient;
private:
    AMT_STATUS _verifyResponseHeader(const UINT32 command,const PTHI_MESSAGE_HEADER *response_header,UINT32 response_size);
	AMT_STATUS _verifyProvisioningState(const CFG_GET_PROVISIONING_STATE_RESPONSE *response);
	AMT_STATUS _verifyProvisioningMode(const CFG_GET_PROVISIONING_MODE_RESPONSE *response);
	AMT_STATUS _verifyCodeVersions(const CFG_GET_CODE_VERSIONS_RESPONSE *response);
	AMT_STATUS _verifyGenerateRngKey(const CFG_GENERATE_RNG_SEED_RESPONSE *response);
	AMT_STATUS _verifyGetRngSeedStatus(const CFG_GET_RNG_SEED_STATUS_RESPONSE *response);
	AMT_STATUS _verifyGetZeroTouchEnabled(const CFG_GET_ZERO_TOUCH_ENABLED_RESPONSE *response);
	AMT_STATUS _verifyGetProvisioningTlsMode(const CFG_GET_PROVISIONING_TLS_MODE_RESPONSE *response);
	AMT_STATUS _verifyStartConfiguration(const CFG_START_CONFIGURATION_RESPONSE *response);
	AMT_STATUS _verifySetProvisioningServerOTP(const CFG_SET_PROVISIONING_SERVER_OTP_RESPONSE *response);
	AMT_STATUS _verifySetDnsSuffix(const CFG_SET_DNS_SUFFIX_RESPONSE *response);
    AMT_STATUS _verifyHashHandles(const CFG_GET_HASH_HANDLES_RESPONSE *response);
    AMT_STATUS _verifyGetCertificateHashEntry(const CFG_GET_CERTHASH_ENTRY_RESPONSE *response);
    AMT_STATUS _verifyGetDnsSuffix(const CFG_GET_PKI_FQDN_SUFFIX_RESPONSE *response);
    AMT_STATUS _verifyGetAMTSetupAuditRecord(const CFG_GET_AUDIT_RECORD_RESPONSE *response);
    AMT_STATUS _verifyGetPID(const CFG_GET_PID_RESPONSE *response);
};

/*
 * Constants
 */


const UINT32 CODE_VERSIONS_REQUEST     = 0x0400001A;
const UINT32 CODE_VERSIONS_RESPONSE    = 0x0480001A;

const PTHI_MESSAGE_HEADER GET_CODE_VERSION_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{CODE_VERSIONS_REQUEST},0
};

const UINT32 PROVISIONING_MODE_REQUEST     = 0x04000008;
const UINT32 PROVISIONING_MODE_RESPONSE    = 0x04800008;

const PTHI_MESSAGE_HEADER GET_PROVISIONING_MODE_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{PROVISIONING_MODE_REQUEST},0
};

const UINT32 PROVISIONING_STATE_REQUEST    = 0x04000011;
const UINT32 PROVISIONING_STATE_RESPONSE   = 0x04800011;

const PTHI_MESSAGE_HEADER GET_PROVISIONING_STATE_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{PROVISIONING_STATE_REQUEST},0
};

const UINT32 GENERATE_RNG_SEED_REQUEST    = 0x04000028;
const UINT32 GENERATE_RNG_SEED_RESPONSE   = 0x04800028;

const PTHI_MESSAGE_HEADER GENERATE_RNG_SEED_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GENERATE_RNG_SEED_REQUEST},0
};

const UINT32 GET_RNG_SEED_STATUS_REQUEST    = 0x0400002E;
const UINT32 GET_RNG_SEED_STATUS_RESPONSE   = 0x0480002E;

const PTHI_MESSAGE_HEADER GET_RNG_SEED_STATUS_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GET_RNG_SEED_STATUS_REQUEST},0
};


const UINT32 GET_ZERO_TOUCH_ENABLED_REQUEST    = 0x04000030;
const UINT32 GET_ZERO_TOUCH_ENABLED_RESPONSE   = 0x04800030;

const PTHI_MESSAGE_HEADER GET_ZERO_TOUCH_ENABLED_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GET_ZERO_TOUCH_ENABLED_REQUEST},0
};

const UINT32 GET_PROVISIONING_TLS_MODE_REQUEST     = 0x0400002B;
const UINT32 GET_PROVISIONING_TLS_MODE_RESPONSE    = 0x0480002B;

const PTHI_MESSAGE_HEADER GET_PROVISIONING_TLS_MODE_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GET_PROVISIONING_TLS_MODE_REQUEST},0
};

const UINT32 START_CONFIGURATION_REQUEST     = 0x04000029;
const UINT32 START_CONFIGURATION_RESPONSE    = 0x04800029;

const PTHI_MESSAGE_HEADER START_CONFIGURATION_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{START_CONFIGURATION_REQUEST},0
};

const UINT32 SET_PROVISIONING_SERVER_OTP_REQUEST     = 0x0400002A;
const UINT32 SET_PROVISIONING_SERVER_OTP_RESPONSE    = 0x0480002A;

const UINT32 SET_DNS_SUFFIX_REQUEST     = 0x0400002F;
const UINT32 SET_DNS_SUFFIX_RESPONSE    = 0x0480002F;

const UINT32 ENUMERATE_HASH_HANDLES_REQUEST     = 0x0400002C;
const UINT32 ENUMERATE_HASH_HANDLES_RESPONSE    = 0x0480002C;

const PTHI_MESSAGE_HEADER ENUMERATE_HASH_HANDLES_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{ENUMERATE_HASH_HANDLES_REQUEST},0
};

const UINT32 GET_CERTHASH_ENTRY_REQUEST     = 0x0400002D;
const UINT32 GET_CERTHASH_ENTRY_RESPONSE    = 0x0480002D;

const UINT32 GET_PKI_FQDN_SUFFIX_REQUEST    = 0x04000036;
const UINT32 GET_PKI_FQDN_SUFFIX_RESPONSE   = 0x04800036;
const PTHI_MESSAGE_HEADER GET_PKI_FQDN_SUFFIX_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GET_PKI_FQDN_SUFFIX_REQUEST},0
};
const UINT32  GET_AUDIT_RECORD_REQUEST      = 0x04000027;
const UINT32  GET_AUDIT_RECORD_RESPONSE     = 0x04800027;
const PTHI_MESSAGE_HEADER GET_AUDIT_RECORD_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GET_AUDIT_RECORD_REQUEST},0
};

const UINT32  GET_PID_REQUEST      = 0x0400003B;
const UINT32  GET_PID_RESPONSE     = 0x0480003B;
const PTHI_MESSAGE_HEADER GET_PID_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{GET_PID_REQUEST},0
};

#endif
