/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "doubleclicklineedit.h"
#include <QDebug>

DoubleClickLineEdit::DoubleClickLineEdit(QList<KeyEntry> *customEntries,QWidget *parent):
    QLineEdit(parent),
    customEntryList(customEntries){
    //this->setStyleSheet("QLineEdit {background-color : palette(base);}");
    this->setContextMenuPolicy(Qt::NoContextMenu);
    defaultQss = this->styleSheet();


    connect(this, &DoubleClickLineEdit::textChanged, this, [=](){
        changeName();
        if (false == strIsAvailable) {
            this->setStyleSheet("border:2px solid red;border-radius:6px;padding:3px 4px");
        } else {
           this->setStyleSheet(defaultQss);
        }
    });
}

DoubleClickLineEdit::~DoubleClickLineEdit() {

}

void DoubleClickLineEdit::mouseDoubleClickEvent(QMouseEvent *e) {
    Q_UNUSED(e);
    return;
}

void DoubleClickLineEdit::focusOutEvent(QFocusEvent *e) {
    Q_UNUSED(e);
    //this->setStyleSheet("QLineEdit {background-color : palette(base);}");

    QString str;
    if (strIsAvailable) {
        str = this->text();
    } else {
        str = validStr;
    }
    this->blockSignals(true);
    this->setText(str);
    this->blockSignals(false);
    if (strIsAvailable) {
        Q_EMIT strChanged();
    }
    this->setStyleSheet(defaultQss);
    Q_EMIT focusOut();
}

void DoubleClickLineEdit::setText(const QString &str) {
    validStr = str;
    QLineEdit::setText(str);
}

void DoubleClickLineEdit::changeName() {
    QStringList customName;
    QString text = this->text();
    if (text.isEmpty()) {
         strIsAvailable = false;
         return;
    }
    if (customEntryList->isEmpty()) {
        strIsAvailable = true;
    } else {
        for (KeyEntry ckeyEntry : *customEntryList) {
            customName << ckeyEntry.nameStr;
            if (customName.contains(text) && text != validStr) {
                strIsAvailable = false;
            } else {
                strIsAvailable = true;
            }
        }
    }
}

/*-----------------------------------------DoubleClickShortCut-----------------------------------------------*/

DoubleClickShortCut::DoubleClickShortCut(QList<KeyEntry> *generalEntries, QList<KeyEntry> *customEntries,
                                         QWidget *parent) :
    ShortcutLine(generalEntries, customEntries, parent){
    this->customEntryList = customEntries;
    this->setContextMenuPolicy(Qt::NoContextMenu);
    defaultQss = this->styleSheet();


    connect(this, &DoubleClickShortCut::textChanged, this, [=](){
        if (this->text().isEmpty()) {
            shortcutIsAvailable = false;
            this->setStyleSheet("border:2px solid red;border-radius:6px;padding:3px 4px");
        }
    });

    connect(this, &DoubleClickShortCut::shortCutAvailable, this, [=](int flag) {

        shortcutSymbol = flag;
        if (0 == flag) {
            shortcutIsAvailable = true;
            this->setStyleSheet(defaultQss);
        } else if (-1 == flag) {
            Q_EMIT shortcutOccupy();
            shortcutIsAvailable = false;
            this->setStyleSheet("border:2px solid red;border-radius:6px;padding:3px 4px");
        } else if (-2 == flag) {
            Q_EMIT shortcutConflict();
            shortcutIsAvailable = false;
            this->setStyleSheet("border:2px solid red;border-radius:6px;padding:3px 4px");
        }
    });
}

DoubleClickShortCut::~DoubleClickShortCut() {

}

void DoubleClickShortCut::mouseDoubleClickEvent(QMouseEvent *e) {
    Q_UNUSED(e);
    return;
}

void DoubleClickShortCut::focusInEvent(QFocusEvent *e) {
    setShortcutIsAvailable(false);
    ShortcutLine::focusInEvent(e);
}
void DoubleClickShortCut::focusOutEvent(QFocusEvent *e) {
    //this->setStyleSheet("QLineEdit {background-color : palette(base);}");

    QString str;
    if (shortcutIsAvailable) {
        str = this->text();
    } else {
        str = validShortcut;
    }
    this->blockSignals(true);
    this->setText(str);
    this->blockSignals(false);
    if (shortcutIsAvailable) {
        Q_EMIT shortcutChanged();
    }

    this->setStyleSheet(defaultQss);
    ShortcutLine::focusOutEvent(e);
    Q_EMIT focusOut();
}

void DoubleClickShortCut::setText(const QString &str) {
    validShortcut = str;
    QLineEdit::setText(str);
}

void DoubleClickShortCut::setShortcutIsAvailable(bool value)
{
    this->shortcutIsAvailable = value;
}
