from _typeshed import Incomplete
from collections.abc import ItemsView, Iterable, Iterator, KeysView, Mapping, ValuesView
from typing_extensions import Self

__all__ = ["Config", "config"]

class Config(Mapping[str, Incomplete]):
    def __init_subclass__(cls, strict: bool = True) -> None: ...
    def __new__(cls, **kwargs) -> Self: ...
    def __dir__(self) -> Iterable[str]: ...
    def __setattr__(self, name: str, value) -> None: ...
    def __delattr__(self, name: str) -> None: ...
    def __contains__(self, key: object) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    def __reversed__(self) -> Iterator[str]: ...
    def __getitem__(self, key: str): ...
    def __setitem__(self, key: str, value) -> None: ...
    def __delitem__(self, key: str) -> None: ...
    def get(self, key: str, default: Incomplete | None = None): ...
    def items(self) -> ItemsView[str, Incomplete]: ...
    def keys(self) -> KeysView[str]: ...
    def values(self) -> ValuesView[Incomplete]: ...

class NetworkXConfig(Config):
    backend_priority: list[str]
    backends: Config
    cache_converted_graphs: bool
    fallback_to_nx: bool
    warnings_to_ignore: set[str]
    def __init__(
        self,
        *,
        backend_priority: list[str],
        backends: Config,
        cache_converted_graphs: bool,
        fallback_to_nx: bool,
        warnings_to_ignore: set[str],
    ) -> None: ...
    def __new__(
        cls,
        *,
        backend_priority: list[str],
        backends: Config,
        cache_converted_graphs: bool,
        fallback_to_nx: bool,
        warnings_to_ignore: set[str],
    ) -> Self: ...

config: NetworkXConfig
