[comment {-*- tcl -*- doctools manpage}]
[manpage_begin widget_validator n 0.1]
[keywords invalid]
[keywords {state management}]
[keywords ttk::combobox]
[keywords ttk::entry]
[keywords validation]
[keywords {widget validation}]
[moddesc   {widget::validator behaviour}]
[titledesc {widget::validator behaviour}]
[require Tcl 8.5]
[require Tk 8.5]
[require widget::validator [opt 0.1]]
[description]

This package provides a unified validation API
for [package ttk]'s entry and combobox widgets.

[para] Please note that the validation behaviour
defined in this package will not reject invalid
edits. It will only highlight the entry containing
invalid data and set the proper state flag.

[para] It is the responsibility of the using package
or application to decide how and when to actually
reject such invalid content.

[para]

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widget::validator] [method attach] \
     [arg w] \
     [arg color] \
     [arg cmdprefix]]

This method adds a validating behaviour to the widget [arg w].

[para] Whenever the content of the widget's entry field changes
the specified [arg cmdprefix] is invoked and has to return a
boolean value, where [const true] means that content is ok, and
[const false] that the content is invalid. For more information
on the command prefix see section [sectref Validation].

In case of the latter the background color of the entry field
is changed to [arg color] to indicate the invalidity.

[para] The system does not support nesting of validators on a
widget, nor the attachment of multiple validators. To change
validating conditions [method detach] the current validator first
before attaching the new.

[para] An error is thrown if the widget has already
validating behaviour attached to it.

[para] The result of the method is the empty string.

[para] To achieve its aims the package overrides various
configuration options of the widget the behaviour is
attached to. These options are restored to their previous
values on [method detach].

[para] If other behaviours are attached the validator
may be rendered temporarily (partially) non-functional.
Similarly, if the validator is detached while a different
behaviour is also attached its restoration of configuration
settings may render the other non-functional

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widget::validator] [method detach] [arg w]]

This method removes the validating behaviour from
the widget [arg w] and restores it to its original
state.

[para] An error is thrown if the widget has no
validating behaviour attached to it.

[para] The result of the method is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widget::validator] [method validate] [arg w]]

Invoking this method forces a validation of the
widget [arg w], assuming that it has a validator
behaviour attached to it.

[para] The result of the method is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[list_end]

[section Validation]

The command prefix for used for validation has to
have the following signature:

[list_begin definitions]
[def "{*}[arg cmdprefix] [arg text]"]

The argument is the text to validate.

[para] The result of the callback has to be a boolean value
where [const true] means that [arg text] is ok, and
[const false] that [arg text] is invalid.

[list_end]

[section Example]

[example {
package require Tk 8.5
package require widget::validator

set TE {}
set TC {}

ttk::entry    .e -textvariable TE
ttk::combobox .c -textvariable TC -values {fruit vegetable corn}
ttk::combobox .n -values {fruit vegetable corn}
ttk::button   .x -command ::exit -text Exit

pack .e -expand 1 -fill both -side top
pack .c -expand 1 -fill both -side top
pack .n -expand 1 -fill both -side top
pack .x -expand 1 -fill both -side top

widget::validator attach .e lightblue {apply {text {
    expr {$text ne {}}
}}}

widget::validator attach .c yellow {apply {text {
    expr {$text ni {{} hello world}}
}}}

widget::validator attach .n pink {apply {text {
    expr {$text ni {{} blub}}
}}}
}]
[vset CATEGORY widget::validator]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
