/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraLogging;
import com.github.arara.utils.AraraUtils;
import com.github.arara.utils.ConfigurationLoader;
import com.github.arara.utils.LanguageController;
import java.io.File;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineAnalyzer {
    private String theFile;
    private String[] theArgs;
    private Options commandLineOptions;
    private boolean showVerboseOutput;
    private long executionTimeout;
    private ConfigurationLoader configuration;
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public CommandLineAnalyzer(String[] theArgs, ConfigurationLoader configuration) {
        this.theArgs = theArgs;
        this.configuration = configuration;
        this.commandLineOptions = new Options();
        this.showVerboseOutput = false;
    }

    public boolean parse() {
        Option optVersion = new Option("V", "version", false, localization.getMessage("Help_Version"));
        Option optHelp = new Option("h", "help", false, localization.getMessage("Help_Help"));
        Option optLog = new Option("l", "log", false, localization.getMessage("Help_Log"));
        Option optVerbose = new Option("v", "verbose", false, localization.getMessage("Help_Verbose"));
        Option optTimeout = new Option("t", "timeout", true, localization.getMessage("Help_Timeout"));
        Option optLanguage = new Option("L", "language", true, localization.getMessage("Help_Language"));
        this.commandLineOptions.addOption(optVersion);
        this.commandLineOptions.addOption(optHelp);
        this.commandLineOptions.addOption(optLog);
        this.commandLineOptions.addOption(optVerbose);
        this.commandLineOptions.addOption(optTimeout);
        this.commandLineOptions.addOption(optLanguage);
        BasicParser parser = new BasicParser();
        try {
            String[] files;
            CommandLine line;
            block11: {
                line = parser.parse(this.commandLineOptions, this.theArgs);
                if (line.hasOption("language")) {
                    LanguageController language = new LanguageController();
                    if (!language.setLanguage(line.getOptionValue("language"))) {
                        language.printLanguageHelp();
                        this.printUsage();
                        return false;
                    }
                    optVersion.setDescription(localization.getMessage("Help_Version"));
                    optHelp.setDescription(localization.getMessage("Help_Help"));
                    optLog.setDescription(localization.getMessage("Help_Log"));
                    optVerbose.setDescription(localization.getMessage("Help_Verbose"));
                    optTimeout.setDescription(localization.getMessage("Help_Timeout"));
                    optLanguage.setDescription(localization.getMessage("Help_Language"));
                }
                if (line.hasOption("help")) {
                    this.printVersion();
                    this.printUsage();
                    return false;
                }
                if (line.hasOption("version")) {
                    this.printVersion();
                    this.printSpecialThanks();
                    return false;
                }
                files = line.getArgs();
                if (files.length != 1) {
                    this.printVersion();
                    this.printUsage();
                    return false;
                }
                if (line.hasOption("timeout")) {
                    try {
                        this.executionTimeout = Long.parseLong(line.getOptionValue("timeout"));
                        if (this.executionTimeout <= 0L) {
                            this.printVersion();
                            this.printUsage();
                            return false;
                        }
                        break block11;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printVersion();
                        this.printUsage();
                        return false;
                    }
                }
                this.executionTimeout = 0L;
            }
            AraraLogging.enableLogging(line.hasOption("log"));
            this.showVerboseOutput = line.hasOption("verbose");
            this.theFile = files[0];
            return this.checkFile(this.theFile, this.configuration.getValidExtensions());
        }
        catch (ParseException parseException) {
            this.printVersion();
            this.printUsage();
            return false;
        }
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("arara [file [--log] [--verbose] [--timeout N] [--language L] | --help | --version]", this.commandLineOptions);
    }

    private void printVersion() {
        System.out.println("arara ".concat("3.0a").concat(" - ").concat(localization.getMessage("Header_Slogan")));
        System.out.println("Copyright (c) ".concat("2012").concat(", Paulo Roberto Massa Cereda"));
        System.out.println(localization.getMessage("Header_AllRightsReserved").concat("\n"));
    }

    public String getFile() {
        return this.theFile;
    }

    private boolean checkFile(String filename, String[] extensions) {
        boolean foundFile = false;
        for (String currentExtension : extensions) {
            if (!filename.toLowerCase().endsWith(currentExtension)) continue;
            foundFile = true;
            this.configuration.setChosenFilePattern(currentExtension);
            break;
        }
        File fileStatus = null;
        if (foundFile) {
            fileStatus = new File(filename);
            if (fileStatus.exists()) {
                this.theFile = filename;
                return true;
            }
            System.out.println(localization.getMessage("Error_FileDoesNotExist", filename));
            return false;
        }
        for (String currentExtension : extensions) {
            fileStatus = new File(filename + currentExtension);
            if (!fileStatus.exists()) continue;
            this.theFile = filename + currentExtension;
            this.configuration.setChosenFilePattern(currentExtension);
            return true;
        }
        System.out.println(AraraUtils.wrap(localization.getMessage("Error_FileDoesNotExistWithExtensionsList", filename, this.getExtensionsList(extensions))));
        return false;
    }

    private String getExtensionsList(String[] extensions) {
        if (extensions.length == 0) {
            return "";
        }
        String result = "[".concat(extensions[0]);
        for (int i = 1; i < extensions.length; ++i) {
            result = result.concat(", ").concat(extensions[i]);
        }
        result = result.concat("]");
        return result;
    }

    public boolean isVerbose() {
        return this.showVerboseOutput;
    }

    public long getExecutionTimeout() {
        return this.executionTimeout;
    }

    private void printSpecialThanks() {
        System.out.println(AraraUtils.wrap(localization.getMessage("Msg_SpecialThanks")));
    }
}

