from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


Map = _Mock()

contextmanager = _Mock()

decorator = _Mock()

getname = _Mock()

imp = _Mock()

iteritems = _Mock()

parallel = _Mock()

pickleutil = _Mock()

print_function = _Mock()

remote = _Mock()

save_ids = _Mock()

skip_doctest = _Mock()

spin_after = _Mock()

string_types = _Mock()

sync_results = _Mock()

sys = _Mock()

util = _Mock()

warnings = _Mock()

zmq = _Mock()

PY3 = _Mock()

class Any(_Mock):
  pass
  info_text = 'any value'

class AsyncMapResult(_Mock):
  pass
  _single_result = False

class AsyncResult(_Mock):
  pass
  _single_result = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CFloat(_Mock):
  pass
  default_value = 0.0
  info_text = 'a float'

class Dependency(_Mock):
  pass
  all = True
  failure = True
  success = True

class Dict(_Mock):
  pass
  info_text = 'any value'

class DirectView(_Mock):
  pass
  skip_doctest = True

class HasTraits(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class List(_Mock):
  pass
  info_text = 'any value'

class LoadBalancedView(_Mock):
  pass
  skip_doctest = True

class ModuleType(_Mock):
  pass


class ParallelFunction(_Mock):
  pass
  _mapping = False

class Set(_Mock):
  pass
  info_text = 'any value'

class View(_Mock):
  pass
  skip_doctest = True

class dependent(_Mock):
  pass


