C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=NVECTO,SSI=0
                        SUBROUTINE NVECTO
C                       *****************
C
C      -----------------------------------------
     * (NDMATS,NELEMS,NODES,NREFAC,NBFACE,NREFE)
C      -----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             RENUMEROTATION DE LA TABLE DES ELEMENTS EN VUE           *
C             DE FORCER LA VECTORISATION DANS LES BOUCLES              *
C             D'ASSEMBLAGE.                                            *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NODES    ! TE ! M  ! CONNECTIVITE DU MAILLAGE                     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "divct.h"
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
      INTEGER ILVECM
      PARAMETER (ILVECM=1024)
C
C.. Variables externes
      INTEGER NELEMS,NDMATS,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFAC(NELEMS,NBFACE),NREFE(NELEMS)
C
C.. Variables internes
      INTEGER N,I,J,M,ITAB(10,ILVECM),ILVEC,IR
      INTEGER NRES,NEL,IECHE,NB,NBBLOC,NROT,NGOTO
      LOGICAL LOK,LFINI,LBIS,LRATE
C
      INTEGER INOK,INOKR,INOKG,IRESOK
      DOUBLE PRECISION TVEC1,TVEC2
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      CALL CPUSYR(TVEC1)
      ILVEC=1024

1111  CONTINUE
      NBBLOC = NELEMS / ILVEC
      IF (NBBLOC .LE. 5) THEN
         ILVEC=128
         NBBLOC = NELEMS / ILVEC
         IF (NBBLOC .EQ. 0) THEN
             LRATE=.TRUE.
             GOTO 4999
         ENDIF
      ENDIF
C
      LFINI = .TRUE.
      LRATE = .FALSE.
      NGOTO = 0
      IRESOK = 1
C
      WRITE(NFECRA,1000)
C
C
C     Statistique sur le maillage initial
C     -----------------------------------
      INOKG =0
      DO NB = 1,NBBLOC
C
        INOK = 0
        DO J=1,NDMATS
          DO I=1,ILVEC
             ITAB(J,I) = 0
          ENDDO
        ENDDO
C     Traitement du bloc
C     -----------------------------------
        DO N=1,ILVEC
C
          NEL = (NB-1)*ILVEC + N
          NROT = 0
C
          DO I=1,NDMATS
            ITAB(I,N) = NODES(NEL,I)
          ENDDO
C
C         L'element est-il compatible avec les precedents ?
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
          DO I=1,NDMATS
            DO M=1,N-1
              IF (ITAB(I,M).EQ.ITAB(I,N))  INOK = INOK +1
            ENDDO
          ENDDO
        ENDDO
        IF(NBLBLA.GE.8) THEN
          PRINT*,' nvecto : verif initiale bloc : ',NB,' pb = ',INOK
        ENDIF
        IF (INOK .GE.1) INOKG = INOKG+1
      ENDDO
C
C     Statistique sur le residu
C     --------------------------
      NRES = NELEMS - (NBBLOC*ILVEC)
      INOKR = 0
      DO N=1,NRES
C
        NEL = NBBLOC*ILVEC + N
C
        DO I=1,NDMATS
          ITAB(I,N) = NODES(NEL,I)
        ENDDO
C
        DO I=1,NDMATS
          DO M=1,N-1
            IF (ITAB(I,M).EQ.ITAB(I,N))  INOKR = INOKR+1
          ENDDO
        ENDDO
      ENDDO
      IF(NBLBLA.GE.8) THEN
        PRINT*,' nvecto : verif initiale residu :  pb = ',INOKR      
      ENDIF

      IF (INOKG.EQ.0 .AND. INOKR.EQ.0) THEN
         IVECTO = ILVEC
         WRITE(NFECRA,1100) ILVEC
         CALL CPUSYR(TVEC2)
         TVEC2=TVEC2-TVEC1
         WRITE(NFECRA,5017) TVEC2
         RETURN
      ELSE IF(INOKG.EQ.0 .AND. INOKR.NE.0) THEN
         IVECTO = -ILVEC
         WRITE(NFECRA,1101) -ILVEC
         WRITE(NFECRA,1102) NRES,INOKR
         CALL CPUSYR(TVEC2)
         TVEC2=TVEC2-TVEC1
         WRITE(NFECRA,5017) TVEC2
         RETURN
      ENDIF
C
C
C     1- MELANGE DE LA TABLE DES ELEMENTS
C     ===================================
C
        DO 100 N=1,NELEMS/2,2
           CALL PERMUT(N,NELEMS-N+1,NODES,NELEMS,NDMATS)
           IF (LCFACE) CALL PERMUT(N,NELEMS-N+1,NREFAC,NELEMS,NBFACE)
           IR=NREFE(N)
           NREFE(N)=NREFE(NELEMS-N+1)
           NREFE(NELEMS-N+1)=IR
  100   CONTINUE
C
C
C     2- TRI DES ELEMENTS
C     ===================
C
    1 CONTINUE
C
      NGOTO = NGOTO + 1
C
      IF (NBLBLA.GE.3) WRITE(NFECRA,2000) NGOTO
C
C
C     2.0 Pour les nbbloc vecteurs independants a creer 
C     -------------------------------------------------
      DO 200 NB = 1,NBBLOC
C
        DO J=1,NDMATS
          DO I=1,ILVEC
             ITAB(J,I) = 0
          ENDDO
        ENDDO
C
C
        IECHE = NB * ILVEC 
C
C
C       2.1 Traitement du bloc 
C       ----------------------
        DO 210 N=1,ILVEC
C
          NEL = (NB-1)*ILVEC + N
          NROT = 0
C
          LBIS = .FALSE.
C
 2119     CONTINUE
C
          DO 211 I=1,NDMATS
            ITAB(I,N) = NODES(NEL,I)
  211     CONTINUE
C
C         2.1.1 L'element est-il compatible avec les precedents ?
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
          LOK = .TRUE.
          DO 212 I=1,NDMATS
            DO 213 M=1,N-1
              IF (ITAB(I,M).EQ.ITAB(I,N))  LOK = .FALSE.
  213       CONTINUE
  212     CONTINUE
C
C
C         2.1.2 Traitement d'un element incompatible
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
          IF (.NOT. LOK) THEN
C
             IF (IECHE.LT.NELEMS) THEN
               IECHE = IECHE + 1
             ELSEIF (LBIS) THEN
               LRATE = .TRUE.
               GOTO 4999
             ELSE
               IECHE = 1
               LBIS = .TRUE.
               LFINI = .FALSE.
             ENDIF
             CALL PERMUT(NEL,IECHE,NODES,NELEMS,NDMATS)
            IF (LCFACE) CALL PERMUT(NEL,IECHE,NREFAC,NELEMS,NBFACE)
            IR=NREFE(NEL)
            NREFE(NEL)=NREFE(IECHE)
            NREFE(IECHE)=IR
C
             GOTO 2119
C
          ENDIF
C
  210   CONTINUE
C
  200 CONTINUE
C
C
C     3- ELEMENTS RESIDUELS DU DERNIER BLOC INCOMPLET
C     ===============================================
C
      NRES = NELEMS - (NBBLOC*ILVEC)
C
      DO 300 N=1,NRES
C
        LBIS = .FALSE.
        NROT = 0
C
        NEL = NBBLOC*ILVEC + N
 3119   CONTINUE
C
        DO I=1,NDMATS
          ITAB(I,N) = NODES(NEL,I)
        ENDDO
C
C       3.1.1 L'element est-il compatible avec les precedents ?
C       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        LOK = .TRUE.
        DO 311 I=1,NDMATS
          DO 312 M=1,N-1
            IF (ITAB(I,M).EQ.ITAB(I,N))  LOK = .FALSE.
  312     CONTINUE
  311   CONTINUE
C
C       3.1.2 L'element est incompatible
C       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        IF (.NOT. LOK .AND. NGOTO.LE.5) THEN
              IF (IECHE.LT.NELEMS) THEN
                IECHE = IECHE + 1
              ELSEIF (LBIS) THEN
                LRATE = .TRUE.
                GOTO 4999
              ELSE
                IECHE = 1
                LBIS  = .TRUE.
                LFINI = .FALSE.
              ENDIF
              CALL PERMUT(NEL,IECHE,NODES,NELEMS,NDMATS)
              IF (LCFACE) CALL PERMUT(NEL,IECHE,NREFAC,NELEMS,NBFACE)
              IR=NREFE(NEL)
              NREFE(NEL)=NREFE(IECHE)
              NREFE(IECHE)=IR
              GOTO 3119
        ELSEIF (.NOT. LOK) THEN
              IRESOK=0
              GOTO 301
        ENDIF
C
  300 CONTINUE
C
  301 CONTINUE
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(NBLBLA.GE.9) THEN
C     Statistique sur le maillage iteration NGOTO
C     -----------------------------------
      DO NB = 1,NBBLOC
C
        INOK = 0
        DO J=1,NDMATS
          DO I=1,ILVEC
             ITAB(J,I) = 0
          ENDDO
        ENDDO
C     Traitement du bloc
C     -----------------------------------
        DO N=1,ILVEC
C
          NEL = (NB-1)*ILVEC + N
          NROT = 0
C
          DO I=1,NDMATS
            ITAB(I,N) = NODES(NEL,I)
          ENDDO
C
C         L'element est-il compatible avec les precedents ?
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
          DO I=1,NDMATS
            DO M=1,N-1
              IF (ITAB(I,M).EQ.ITAB(I,N))  INOK = INOK +1
            ENDDO
          ENDDO
        ENDDO
        PRINT*,' verif iter',NGOTO,' bloc : ',NB,' pb = ',INOK
      ENDDO
C
C     Statistique sur le residu
C     --------------------------
      NRES = NELEMS - (NBBLOC*ILVEC)
      INOKR = 0
      DO N=1,NRES
C
        NEL = NBBLOC*ILVEC + N
C
        DO I=1,NDMATS
          ITAB(I,N) = NODES(NEL,I)
        ENDDO
C
        DO I=1,NDMATS
          DO M=1,N-1
            IF (ITAB(I,M).EQ.ITAB(I,N))  INOKR = INOKR+1
          ENDDO
        ENDDO
      ENDDO
        PRINT*,' verif iter',NGOTO,' residu :  pb = ',INOKR  
      ENDIF    
CCCCCCCCCCCCCCCCCCCCCCCCCCCCC

C
C     4- ON BOUCLE SI CE N'EST PAS BON
C     ================================
C
      IF (.NOT. LFINI .AND. NGOTO.LE.10) THEN
        LFINI = .TRUE.
        GOTO 1
      ELSEIF (.NOT. LFINI .AND. NGOTO.GT.10) THEN
        LRATE = .TRUE.
      ENDIF
C
C
 4999 CONTINUE
C
      IF (LRATE .AND. ILVEC.EQ.1024) THEN
          ILVEC=128
          GOTO 1111
      ENDIF
C
      CALL CPUSYR(TVEC2)
      TVEC2=TVEC2-TVEC1
      WRITE(NFECRA,5017) TVEC2
      
C     5- IMPRESSIONS
C     ==============
      IF (LRATE) THEN
         WRITE(NFECRA,5100) 
         IVECTO = 0
      ELSE IF (IRESOK.EQ.0) THEN
         WRITE(NFECRA,5200) NGOTO,-ILVEC
         IVECTO = -ILVEC
      ELSE
         WRITE(NFECRA,5200) NGOTO,ILVEC
         IVECTO = ILVEC
      ENDIF
C
C--------
C FORMATS
C--------
C
 1000 FORMAT(/,' *** NVECTO : RENUMEROTATION DES ELEMENTS POUR',
     & ' LA VECTORISATION')
         
 1100 FORMAT(' *** NVECTO : Maillage initial vectorisable :
     &         taille du vecteur = ',I6)
 1101 FORMAT(' *** NVECTO : Maillage initial partiellement 
     & vectorisable : taille du vecteur = ',I6)
 1102 FORMAT(' *** NVECTO : Traitement scalaire des ',I4,' derniers
     &  elements.  Nombre de conflis detectes : ',I7)
 2000 FORMAT('                   - iteration : ',I3)
 5017 FORMAT(' *** NVECTO : temps CPU necessaire :',E15.5,' s')
 5100 FORMAT(14X,'L''algorithme de renumerotation n''a pas converge',/,
     &       14X,' --> l''assemblage sera scalaire')
 5200 FORMAT(14X,'Convergence de l''algorithme de renumerotation en ',I3
     &      ,' iteration(s)',/,
     &  14X,' --> vectorisation de l''assemblage des vecteurs ',
     &       'et matrices sur des vecteurs de ',I5)
C
      END
