/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ConfigValue.h"

// qt
#include <QtCore/QString>


ConfigValue::ConfigValue( const sc::String& key, const sc::String& value )
: _key(key), _value(value)
{
}

ConfigValue::ConfigValue( const sc::String& key, unsigned long value )
: _key(key)
{
  setOptionValue(value);
}

ConfigValue::ConfigValue( const sc::String& key, long value )
: _key(key)
{
  setNumericValue(value);
}

ConfigValue::ConfigValue( const sc::String& key, bool value )
: _key(key)
{
  setBoolValue(value);
}

ConfigValue::ConfigValue( const ConfigValue& src )
: _key(src._key), _value(src._value)
{
}

const sc::String& ConfigValue::getKey() const
{
  return _key;
}

const sc::String& ConfigValue::getStringValue() const
{
  return _value;
}

unsigned long ConfigValue::getOptionValue() const
{
  bool b = false;
  return QString(_value.getStr()).toULong(&b,16);
}

long ConfigValue::getNumericValue() const
{
  return QString(_value.getStr()).toLong();
}

bool ConfigValue::getBoolValue() const
{
  if( _value == sc::String("true") )
  {
    return true;
  }
  else
  {
    return false;
  }
}

void ConfigValue::setStringValue( const sc::String& v )
{
  _value = v;
}

void ConfigValue::setOptionValue( unsigned long v )
{
  _value = sc::String(QString("%1").arg(v,0,16).toUtf8());
}

void ConfigValue::setNumericValue( long v )
{
  _value = sc::String(QString("%1").arg(v).toUtf8());
}

void ConfigValue::setBoolValue( bool b )
{
  if( b )
  {
    _value = "true";
  }
  else
  {
    _value = "false";
  }
}

bool ConfigValue::isNull()
{
  return _key.getCharCnt() == 0;
}
