/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFCMD_H
#define _SC_DIFFCMD_H

// sc
#include "ScCmd.h"
class DiffParam;
class CmdResultCallback;


/**
 * Command for diffing files or dirs.
 */
class DiffCmd : public ScCmd
{
public:
  /**
   * Construct a DiffCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  DiffCmd( DiffParam* param, CmdResultCallback* cb );
  ~DiffCmd();

  void run();

private:
  // in
  DiffParam*         _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_DIFFCMD_H
