/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "LockDialog.h"
#include "WcModel.h"
#include "ScModel.h"
#include "TextEdit.h"
#include "Settings.h"
#include "settings/FontSettings.h"
#include "sublib/Gui.h"
#include "sublib/settings/LayoutSettings.h"
#include "util/String.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QCheckBox>
#include <QtGui/QTextEdit>
#include <Qt3Support/Q3VBox>
#include <Qt3Support/Q3GroupBox>



LockDialog::LockDialog( ScModel* model, QWidget *parent )
: super( parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _model(model)
{
  setName( "LockDialog" );
  setCaption( _q("subcommander:lock") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("lock options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QFont font = _model->getFontSettings()->getEditorFont();
    QFontMetrics m(font);

    _edit = new TextEdit(this);
    _edit->setFont( font );
    _edit->setUndoRedoEnabled(true);
    _edit->setTabChangesFocus(true);
    _edit->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );
    _edit->setMinimumWidth( 500 );
    _edit->setWordWrapMode( QTextOption::NoWrap );
    vbl->addWidget(_edit);

    _pos = new QLabel(this);
    vbl->addWidget(_pos);

    connect( _edit, SIGNAL(cursorChanged(int,int)), SLOT(cursorChanged(int,int)) );


    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _steal = new QCheckBox(_q("&steal locks"),this);
      _steal->setChecked(model->getOptionCommandForce());
      h1->addWidget(_steal);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(true);
      _ok->setText( _q("&Lock") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);

      hu->addSpacing(getSizeGripSpacing());
      
      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  Settings s;
  resize( s.layout().getSize( name(), QSize(350,300) ) );
}

LockDialog::~LockDialog()
{
  Settings s;
  s.layout().setSize( name(), geometry().size() );
}

QString LockDialog::getLogMessage() const
{
  return _edit->text();
}

bool LockDialog::isStealLock() const
{
  return _steal->isChecked();
}

void LockDialog::cursorChanged( int x, int y )
{
  _pos->setText( QString(_q("Line: %1  Column: %2")).arg(y+1,3).arg(x+1,3) );
}
