/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *                SCANNER FOR TPTP SYNTAX                 * */
/* *                                                        * */
/* *  $Module:   TPTP                                       * */ 
/* *                                                        * */
/* *  Copyright (C) 1997, 1998, 1999, 2000, 2001            * */
/* *  MPI fuer Informatik                                   * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the FreeBSD    * */
/* *  Licence.                                              * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the LICENCE file       * */ 
/* *  for more details.                                     * */
/* *                                                        * */
/* *                                                        * */
/* $Revision: 1.4 $                                         * */
/* $State: Exp $                                            * */
/* $Date: 2011-05-25 13:08:09 $                             * */
/* $Author: weidenb $                                       * */
/* *                                                        * */
/* *             Contact:                                   * */
/* *             Christoph Weidenbach                       * */
/* *             MPI fuer Informatik                        * */
/* *             Stuhlsatzenhausweg 85                      * */
/* *             66123 Saarbruecken                         * */
/* *             Email: spass@mpi-inf.mpg.de                * */
/* *             Germany                                    * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/

%{
/*-----------------------------------------------------------------------------*/

#include "tptp.h"
#include "memory.h"
#include "symbol.h"
#include "term.h"
#include "misc.h"

#include "tptpparser.h" /*generated by bison - only include it as the last thing*/

/*faster than string copy, because we already know the length.*/
 char* tptp_StringCopy(void)
{ 
  char *copy;
  copy = (char*) memory_Malloc(yyleng+1);
  strcpy(copy, yytext);
  return copy;
}

/*-----------------------------------------------------------------------------*/
%}

/* No wrapping - only one file read */
%option noyywrap

/* Omit unused functions yyunput, yyinput */
%option nounput
%option noinput

/* maintain linenumbering internally - TODO: this might degrade the performance */
%option yylineno

/* Mainly set to get rid of a warning (otherwise, flex uses non-standard function "fileno" to decide whether to go interactive or not). Moreover, this should be a bit faster. */
%option never-interactive

/*  comment               {comment_line}|{comment_block} */
comment_line          [%]{printable_char}*
comment_block         [/][*]{not_star_slash}[*][*]*[/]
not_star_slash        ([^*]*[*][*]*[^/*])*[^*]*
single_quoted         [']{sq_char}{sq_char}*[']
sq_char               ([\40-\46\50-\133\135-\176]|[\\]['\\])
distinct_object       ["]{do_char}{do_char}*["]
do_char               ([\40-\41\43-\133\135-\176]|[\\]["\\])
dollar_word           {dollar}{lower_word}
dollar_dollar_word    {dollar}{dollar}{lower_word}
upper_word            {upper_alpha}{alpha_numeric}*
lower_word            {lower_alpha}{alpha_numeric}*
star                  [*]
plus                  [+]
arrow                 [>]
real                  ({decimal_fraction}|{decimal_exponent})
signed_integer        {sign}{unsigned_integer}
unsigned_integer      {decimal_natural}
decimal_exponent      ({decimal}|{decimal_fraction}){exponent}{decimal}
decimal_fraction      {decimal}{dot_decimal}
decimal               ({signed_decimal}|{decimal_natural})
signed_decimal        {sign}{decimal_natural}
decimal_natural       ([0]|{non_zero_numeric}{numeric}*)
dot_decimal           [.]{numeric}{numeric}*
sign                  [+-]
exponent              [Ee]
alpha_numeric         ({lower_alpha}|{upper_alpha}|{numeric}|[_])
numeric               [0-9]
non_zero_numeric      [1-9]
lower_alpha           [a-z]
upper_alpha           [A-Z]
dollar                [$]
printable_char        [^\n\r]
viewable_char         [.\n]

%s INSIDE

%%
"&"    return(AMPERSAND);
":"    return(COLON);
","    return(COMMA);
"="    return(EQUALS);
"=>"   return(EQUALS_GREATER);
"!"    return(EXCLAMATION);
"!="   return(EXCLAMATION_EQUALS);
"["    return(LBRKT);
"<="   return(LESS_EQUALS);
"<=>"  return(LESS_EQUALS_GREATER);
"<~>"  return(LESS_TILDE_GREATER);
"("    return(LPAREN);
"."    {
         BEGIN(INITIAL);
         return(PERIOD);
       }
"?"    return(QUESTION);
"]"    return(RBRKT);
")"    return(RPAREN);
"~"    return(TILDE);
"~&"   return(TILDE_AMPERSAND);
"~|"   return(TILDE_VLINE);
"|"    return(VLINE);
"$cnf" return(_DLR_cnf);
"$fof" return(_DLR_fof);
"$fot" return(_DLR_fot);

<INITIAL>"cnf"      {
                   BEGIN(INSIDE);
                   return(_LIT_cnf);
                }
<INITIAL>"fof"      {
                   BEGIN(INSIDE);
                   return(_LIT_fof);
                }
<INITIAL>"include"  {
                   BEGIN(INSIDE);
                   return(_LIT_include);
                }

{single_quoted} {
    tptp_lval.string = tptp_StringCopy();
    return(single_quoted);
}

{distinct_object} {
    tptp_lval.string = tptp_StringCopy();
    return(distinct_object);
}

{dollar_word} {
    tptp_lval.string = tptp_StringCopy();
    return(dollar_word);
}

{dollar_dollar_word} {
    tptp_lval.string = tptp_StringCopy();
    return(dollar_dollar_word);
}

{upper_word} {
    tptp_lval.string = tptp_StringCopy();
    return(upper_word);
}

{lower_word} {
    tptp_lval.string = tptp_StringCopy();
    return(lower_word);
}

{real} {
    tptp_lval.string = tptp_StringCopy();
    return(real);
}

{signed_integer} {
    tptp_lval.string = tptp_StringCopy();
    return(signed_integer);
}

{unsigned_integer} {
    tptp_lval.string = tptp_StringCopy();
    return(unsigned_integer);
}

<INITIAL>{comment_line} {
    tptp_lval.string = tptp_StringCopy();
    return(comment_line);
}
{comment_line}                      ;
{comment_block}                     ;
[ \t\n]                             ;
[\000-\040]|[\177]                  ;
[\041-\176]     return(unrecognized);

%%

