7.3 Gleitende Parameter

# Gleitende Parameter

Vielleicht ist Dir beim Erforschen der Synth- und FX-Argumente
aufgefallen, dass manche Parameter mit `_slide` enden. 
Vielleicht hast Du sie sogar ausprobiert und keine Auswirkung bemerkt. 
Das liegt daran, dass dies keine normalen Parameter sind. Diese
besonderen Parameter funktionieren nur dann, wenn Du Synths wie im
letzten Kapitel beschrieben steuerst.

Schau Dir das folgende Beispiel an:

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Hier kannst Du hören, wie sich die Tonhöhe unmittelbar bei jedem Aufruf 
von `control` ändert. Vielleicht möchtest Du aber, dass die Tonhöhe 
sich gleitend zwischen den Aufrufen verändert. Um dort, wo wir den 
Parameter `note:` verwenden, gleitende Übergänge hinzuzufügen, nutzen 
wir den `note_slide:`-Parameter des Synth:

```
s = play 60, release: 5, note_slide: 1
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Jetzt hören wir, wie die Noten zwischen den `control`-Aufrufen "gezogen" 
werden. Hört sich gut an, oder? Mit einer kürzeren Dauer wie
beispielsweise `note_slide: 0,2` kannst Du den Übergang beschleunigen.
Oder ihn mit einer längeren Slide-Dauer verlangsamen.

Jeder steuerbare Parameter hat einen entsprechenden `_slide`-Parameter,
mit dem Du spielen kannst.

## Gleiten ist klebrig

Nachdem Du einmal einen `_slide` Parameter auf einem laufenden Synth 
angegeben hast, bleibt er bestehen und wird jedesmal genutzt, wenn Du 
den entsprechenden Parameter steuerst. Um das Gleiten auszuschalten, 
musst Du den `_slide` Wert vor dem nächsten `control`-Aufruf auf 0 
setzen.

## Gleitende Effekt-Parameter

Genauso ist es möglich, Effekt-Parameter gleiten zu lassen:

```
with_fx :wobble, phase: 1, phase_slide: 5 do |e|
  use_synth :dsaw
  play 50, release: 5
  control e, phase: 0.025
end
```

Und jetzt lass die Dinge ein wenig gleiten. Viel Spaß mit den
weichen Übergängen...
