/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_COMPONENT_CONSTRAINT_UNCOUPLEDCONSTRAINTCORRECTION_H
#define SOFA_COMPONENT_CONSTRAINT_UNCOUPLEDCONSTRAINTCORRECTION_H

#include <sofa/core/componentmodel/behavior/BaseConstraintCorrection.h>
#include <sofa/core/componentmodel/behavior/MechanicalState.h>


namespace sofa
{

namespace component
{

namespace constraint
{

using namespace sofa::core;
using namespace sofa::core::componentmodel;
/**
 *  \brief Component computing contact forces within a simulated body using the compliance method.
 */
template<class TDataTypes>
class UncoupledConstraintCorrection : public componentmodel::behavior::BaseConstraintCorrection
{
public:
    typedef TDataTypes DataTypes;
    typedef typename DataTypes::VecCoord VecCoord;
    typedef typename DataTypes::VecDeriv VecDeriv;
    typedef typename DataTypes::VecConst VecConst;
    typedef typename DataTypes::Coord Coord;
    typedef typename DataTypes::Deriv Deriv;
    typedef typename std::map<unsigned int, Deriv>::const_iterator ConstraintIterator;
    typedef typename Coord::value_type Real;
    typedef helper::vector<Real> VecReal;

	UncoupledConstraintCorrection(behavior::MechanicalState<DataTypes> *mm = NULL);

    virtual ~UncoupledConstraintCorrection();

    virtual void init();



    /// Retrieve the associated MechanicalState
    behavior::MechanicalState<DataTypes>* getMState() { return mstate; }

    virtual void getCompliance(defaulttype::BaseMatrix *W);

    virtual void applyContactForce(const defaulttype::BaseVector *f);

	virtual void resetContactForce();
	
	
	// new API for non building the constraint system during solving process //
	
	virtual bool hasConstraintNumber(int index) ;  // virtual ???
	
	virtual void resetForUnbuiltResolution(double * f, std::list<int>& /*renumbering*/)  ;
	
	virtual void addConstraintDisplacement(double *d, int begin,int end) ;
	
	virtual void setConstraintDForce(double *df, int begin, int end, bool update) ;

	virtual void getBlockDiagonalCompliance(defaulttype::BaseMatrix* W, int begin, int end) ;
	/////////////////////////////////////////////////////////////////////////////////	
	

    /// Pre-construction check method called by ObjectFactory.
    /// Check that DataTypes matches the MechanicalState.
    template<class T>
    static bool canCreate(T*& obj, objectmodel::BaseContext* context, objectmodel::BaseObjectDescription* arg)
    {
        if (dynamic_cast<behavior::MechanicalState<DataTypes>*>(context->getMechanicalState()) == NULL)
            return false;
        return BaseObject::canCreate(obj, context, arg);
    }

    virtual std::string getTemplateName() const
    {
        return templateName(this);
    }

    static std::string templateName(const UncoupledConstraintCorrection<DataTypes>* = NULL)
    {
        return DataTypes::Name();
    }
		
protected:
    behavior::MechanicalState<DataTypes> *mstate;
	
public:
	Data< VecReal > compliance;	
	

private:
	// new :  for non building the constraint system during solving process //
	VecDeriv constraint_disp, constraint_force;	
	std::list<int> constraint_dofs;		// list of indices of each point which is involve with constraint
	std::vector<int> id_to_localIndex;	// table that gives the local index of a constraint given its id
	
	//std::vector< std::vector<int> >  dof_constraint_table;   // table of indices of each point involved with each constraint 


};

} // namespace collision

} // namespace component

} // namespace sofa

#endif
