/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGFLOWLAYOUT_H
#define SKGFLOWLAYOUT_H
/** @file
* This file defines classes SKGFlowLayout.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include <QLayout>
#include <QStyle>

#include "skgbasegui_export.h"

/**
 * This file is a flow layout
 */
class SKGBASEGUI_EXPORT SKGFlowLayout : public QLayout
{
    Q_OBJECT

public:
    /**
     * Constructor
     * @param iParent the parent
     * @param iMargin margin
     * @param hSpacing horizontal spacing
     * @param vSpacing vertical spacing
     */
    explicit SKGFlowLayout(QWidget* iParent, int iMargin = -1, int hSpacing = -1, int vSpacing = -1);

    /**
     * Constructor
     * @param iMargin margin
     * @param hSpacing horizontal spacing
     * @param vSpacing vertical spacing
     */
    explicit SKGFlowLayout(int iMargin = -1, int hSpacing = -1, int vSpacing = -1);

    /**
     * Default Destructor
     */
    virtual ~SKGFlowLayout();

    /**
     * Add an item
     * @param item the item to add
     */
    virtual void addItem(QLayoutItem* item);

    /**
     * Set horizontal and vertical spacing
     * @param space the space
     */
    virtual void setSpacing(int space);

    /**
     * Get horizontal spacing
     * @return horizontal spacing
     */
    virtual int horizontalSpacing() const;

    /**
     * Get vertical spacing
     * @return vertical spacing
     */
    virtual int verticalSpacing() const;

    /**
     * Get expanding directions
     * @return expanding directions
     */
    virtual Qt::Orientations expandingDirections() const;

    /**
     * Returns true if this layout's preferred height depends on its width; otherwise returns false.
     * The default implementation returns false.
     * Reimplement this function in layout managers that support height for width.
     * @return true of false
     */
    virtual bool hasHeightForWidth() const;

    /**
     * Returns the preferred height for this layout item, given the width w.
     * The default implementation returns -1, indicating that the preferred height is independent of the width of the item. Using the function hasHeightForWidth() will typically be much faster than calling this function and testing for -1.
     * Reimplement this function in layout managers that support height for width
     * @return height
     */
    virtual int heightForWidth(int) const;

    /**
     * Returns the number of items
     * @return number of items
     */
    virtual int count() const;

    /**
     * Returns the item for an index
     * @param index the index
     * @return the item
     */
    virtual QLayoutItem* itemAt(int index) const;

    /**
     * Returns the minimum size
     * @return the minimum size
     */
    virtual QSize minimumSize() const;

    /**
     * Set the geometry
     * @param rect the geometry
     */
    virtual void setGeometry(const QRect& rect);

    /**
     * Returns the preferred size
     * @return the preferred size
     */
    virtual QSize sizeHint() const;

    /**
     * Takes the item for an index
     * @param index the index
     * @return the item
     */
    virtual QLayoutItem* takeAt(int index);


private:
    int doLayout(const QRect& rect, bool testOnly) const;
    int smartSpacing(QStyle::PixelMetric pm) const;

    QList<QLayoutItem*> m_itemList;
    int m_hSpace;
    int m_vSpace;
};

#endif
