#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:29:48 
# _sync-clocks.sh

### P A R A M S

MYSERVER="$1"

### S T A R T

# this doesn't seem to work properly
function setnettime0()
{
net time set $1 > /dev/null
}

function setnettime()
{
if ! net time system $1 > /dev/null; then
	return 1
fi
t=`net time system $1`
date $t > /dev/null
}

echo "--------------------------------------------------------------------------------"
echo "SYNCHRONIZING CLOCKS WITH ${MYSERVER}"
echo "--------------------------------------------------------------------------------"

serveropt=""
if [ "${MYSERVER}" != "" ]; then
	serveropt="-S ${MYSERVER}"
fi
echo "+synchronizing clocks"
if setnettime "${serveropt}" > /dev/null; then
nettime=`net time ${serveropt} | sed 's/\n//g'`
echo -n "net time is now:	"
date -d "${nettime}" "+%Y-%m-%d %H:%M.%S"
fi

echo -n "local time is now:	"
date "+%Y-%m-%d %H:%M.%S"
