Visibility is restricted to a module which isn't an ancestor of the current
item.

Erroneous code example:

```compile_fail,E0742,edition2018
pub mod sea {}

pub (in crate::sea) struct Shark; // error!

fn main() {}
```

To fix this error, we need to move the `Shark` struct inside the `sea` module:

```edition2018
pub mod sea {
    pub (in crate::sea) struct Shark; // ok!
}

fn main() {}
```

Of course, you can do it as long as the module you're referring to is an
ancestor:

```edition2018
pub mod earth {
    pub mod sea {
        pub (in crate::earth) struct Shark; // ok!
    }
}

fn main() {}
```
