;; Test all the f64 comparison operators on major boundary values and all
;; special values.

(module
  (func (export "eq") (param $x f64) (param $y f64) (result i32) (f64.eq (local.get $x) (local.get $y)))
  (func (export "ne") (param $x f64) (param $y f64) (result i32) (f64.ne (local.get $x) (local.get $y)))
  (func (export "lt") (param $x f64) (param $y f64) (result i32) (f64.lt (local.get $x) (local.get $y)))
  (func (export "le") (param $x f64) (param $y f64) (result i32) (f64.le (local.get $x) (local.get $y)))
  (func (export "gt") (param $x f64) (param $y f64) (result i32) (f64.gt (local.get $x) (local.get $y)))
  (func (export "ge") (param $x f64) (param $y f64) (result i32) (f64.ge (local.get $x) (local.get $y)))
)

(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -inf) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const inf)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -inf) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -inf) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const inf) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f64.const inf) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const inf) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const inf)) (i32.const 1))
(assert_return (invoke "le" (f64.const -inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f64.const inf) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const inf) (f64.const inf)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const inf) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const -nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const nan:0x4000000000000)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan:0x4000000000000) (f64.const nan:0x4000000000000)) (i32.const 0))
