// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#[cfg(feature = "v1_1")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
use crate::SymbolEvent;
use crate::{Compass, Layer, License, Map, MapSource, Scale, Viewport};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumateSimpleMap")]
    pub struct SimpleMap(Object<ffi::ShumateSimpleMap, ffi::ShumateSimpleMapClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_simple_map_get_type(),
    }
}

impl SimpleMap {
    #[doc(alias = "shumate_simple_map_new")]
    pub fn new() -> SimpleMap {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_simple_map_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SimpleMap`] objects.
    ///
    /// This method returns an instance of [`SimpleMapBuilder`](crate::builders::SimpleMapBuilder) which can be used to create [`SimpleMap`] objects.
    pub fn builder() -> SimpleMapBuilder {
        SimpleMapBuilder::new()
    }

    #[doc(alias = "shumate_simple_map_add_overlay_layer")]
    pub fn add_overlay_layer(&self, layer: &impl IsA<Layer>) {
        unsafe {
            ffi::shumate_simple_map_add_overlay_layer(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_simple_map_get_compass")]
    #[doc(alias = "get_compass")]
    pub fn compass(&self) -> Option<Compass> {
        unsafe { from_glib_none(ffi::shumate_simple_map_get_compass(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_simple_map_get_license")]
    #[doc(alias = "get_license")]
    pub fn license(&self) -> Option<License> {
        unsafe { from_glib_none(ffi::shumate_simple_map_get_license(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_simple_map_get_map")]
    #[doc(alias = "get_map")]
    pub fn map(&self) -> Option<Map> {
        unsafe { from_glib_none(ffi::shumate_simple_map_get_map(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_simple_map_get_map_source")]
    #[doc(alias = "get_map_source")]
    pub fn map_source(&self) -> Option<MapSource> {
        unsafe {
            from_glib_none(ffi::shumate_simple_map_get_map_source(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_simple_map_get_scale")]
    #[doc(alias = "get_scale")]
    pub fn scale(&self) -> Option<Scale> {
        unsafe { from_glib_none(ffi::shumate_simple_map_get_scale(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_simple_map_get_show_zoom_buttons")]
    #[doc(alias = "get_show_zoom_buttons")]
    pub fn shows_zoom_buttons(&self) -> bool {
        unsafe {
            from_glib(ffi::shumate_simple_map_get_show_zoom_buttons(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_simple_map_get_viewport")]
    #[doc(alias = "get_viewport")]
    pub fn viewport(&self) -> Option<Viewport> {
        unsafe { from_glib_none(ffi::shumate_simple_map_get_viewport(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_simple_map_insert_overlay_layer")]
    pub fn insert_overlay_layer(&self, layer: &impl IsA<Layer>, idx: u32) {
        unsafe {
            ffi::shumate_simple_map_insert_overlay_layer(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
                idx,
            );
        }
    }

    #[doc(alias = "shumate_simple_map_remove_overlay_layer")]
    pub fn remove_overlay_layer(&self, layer: &impl IsA<Layer>) {
        unsafe {
            ffi::shumate_simple_map_remove_overlay_layer(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_simple_map_set_map_source")]
    pub fn set_map_source(&self, map_source: Option<&impl IsA<MapSource>>) {
        unsafe {
            ffi::shumate_simple_map_set_map_source(
                self.to_glib_none().0,
                map_source.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_simple_map_set_show_zoom_buttons")]
    pub fn set_show_zoom_buttons(&self, show_zoom_buttons: bool) {
        unsafe {
            ffi::shumate_simple_map_set_show_zoom_buttons(
                self.to_glib_none().0,
                show_zoom_buttons.into_glib(),
            );
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "symbol-clicked")]
    pub fn connect_symbol_clicked<F: Fn(&Self, &SymbolEvent) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn symbol_clicked_trampoline<
            F: Fn(&SimpleMap, &SymbolEvent) + 'static,
        >(
            this: *mut ffi::ShumateSimpleMap,
            event: *mut ffi::ShumateSymbolEvent,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(event))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"symbol-clicked\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    symbol_clicked_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "compass")]
    pub fn connect_compass_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_compass_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::compass\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_compass_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "license")]
    pub fn connect_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_license_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "map")]
    pub fn connect_map_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_map_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::map\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_map_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "map-source")]
    pub fn connect_map_source_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_map_source_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::map-source\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_map_source_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scale")]
    pub fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-zoom-buttons")]
    pub fn connect_show_zoom_buttons_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_zoom_buttons_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-zoom-buttons\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_show_zoom_buttons_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "viewport")]
    pub fn connect_viewport_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_viewport_trampoline<F: Fn(&SimpleMap) + 'static>(
            this: *mut ffi::ShumateSimpleMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::viewport\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_viewport_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for SimpleMap {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SimpleMap`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SimpleMapBuilder {
    builder: glib::object::ObjectBuilder<'static, SimpleMap>,
}

impl SimpleMapBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn map_source(self, map_source: &impl IsA<MapSource>) -> Self {
        Self {
            builder: self
                .builder
                .property("map-source", map_source.clone().upcast()),
        }
    }

    pub fn show_zoom_buttons(self, show_zoom_buttons: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-zoom-buttons", show_zoom_buttons),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SimpleMap`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SimpleMap {
        self.builder.build()
    }
}
