
#line 1 "ragel/i18n/pl.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/pl.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 23, 24, 25, 47, 48, 49, 
	51, 53, 58, 63, 68, 73, 77, 81, 
	83, 84, 85, 86, 87, 88, 89, 90, 
	91, 92, 93, 94, 95, 96, 97, 98, 
	99, 101, 103, 108, 115, 120, 122, 123, 
	124, 125, 126, 127, 128, 129, 130, 143, 
	145, 147, 149, 151, 153, 155, 157, 159, 
	161, 163, 165, 167, 169, 171, 173, 175, 
	177, 179, 181, 183, 205, 206, 207, 208, 
	209, 210, 211, 212, 213, 214, 215, 217, 
	218, 219, 220, 221, 222, 223, 224, 225, 
	226, 227, 228, 229, 230, 232, 233, 234, 
	235, 236, 237, 238, 239, 240, 241, 242, 
	243, 244, 245, 246, 247, 248, 249, 250, 
	251, 252, 253, 254, 255, 256, 257, 258, 
	268, 270, 272, 274, 276, 278, 280, 282, 
	284, 286, 288, 290, 292, 294, 296, 298, 
	300, 302, 304, 306, 308, 310, 312, 314, 
	316, 318, 320, 322, 324, 326, 328, 330, 
	332, 334, 336, 338, 340, 342, 344, 346, 
	348, 350, 352, 353, 354, 355, 356, 357, 
	358, 359, 360, 361, 362, 363, 383, 385, 
	387, 389, 391, 393, 395, 397, 399, 401, 
	403, 405, 407, 409, 411, 413, 416, 418, 
	420, 422, 424, 426, 428, 430, 432, 434, 
	436, 438, 440, 442, 444, 446, 448, 451, 
	453, 455, 457, 459, 461, 463, 465, 467, 
	469, 471, 473, 475, 477, 479, 481, 483, 
	485, 487, 489, 491, 493, 495, 497, 499, 
	501, 503, 505, 507, 509, 512, 514, 516, 
	518, 520, 522, 524, 526, 528, 530, 532, 
	534, 536, 538, 540, 542, 544, 546, 548, 
	550, 552, 554, 556, 558, 560, 563, 565, 
	567, 569, 571, 573, 575, 577, 579, 581, 
	583, 585, 587, 589, 592, 594, 596, 598, 
	600, 602, 604, 606, 608, 610, 612, 614, 
	615, 616, 617, 618, 619, 620, 621, 622, 
	623, 624, 625, 626, 627, 628, 629, 630, 
	631, 632, 633, 634, 654, 656, 658, 660, 
	662, 664, 666, 668, 670, 672, 674, 676, 
	678, 680, 682, 684, 687, 689, 691, 693, 
	695, 697, 699, 701, 703, 705, 707, 709, 
	711, 713, 715, 717, 719, 722, 724, 726, 
	728, 730, 732, 734, 736, 738, 740, 742, 
	744, 746, 748, 750, 752, 754, 756, 758, 
	760, 762, 764, 766, 768, 770, 772, 774, 
	776, 778, 780, 782, 784, 786, 788, 790, 
	792, 794, 796, 798, 801, 803, 805, 807, 
	809, 811, 813, 815, 817, 819, 821, 823, 
	825, 827, 829, 831, 833, 835, 837, 839, 
	840, 841, 842, 843, 844, 845, 846, 847, 
	848, 849, 850, 851, 852, 854, 855, 856, 
	857, 858, 859, 860, 861, 862, 863, 864, 
	865, 885, 887, 889, 891, 893, 895, 897, 
	899, 901, 903, 905, 907, 909, 911, 913, 
	915, 918, 920, 922, 924, 926, 928, 930, 
	932, 934, 936, 938, 940, 942, 944, 946, 
	948, 950, 953, 955, 957, 959, 961, 963, 
	965, 967, 969, 971, 973, 975, 977, 979, 
	981, 983, 985, 987, 989, 991, 993, 995, 
	997, 999, 1001, 1003, 1005, 1007, 1009, 1011, 
	1014, 1016, 1018, 1020, 1022, 1024, 1026, 1028, 
	1030, 1032, 1034, 1036, 1038, 1040, 1042, 1044, 
	1046, 1048, 1050, 1052, 1054, 1056, 1058, 1060, 
	1062, 1065, 1067, 1069, 1071, 1073, 1075, 1077, 
	1079, 1081, 1083, 1085, 1087, 1089, 1091, 1093, 
	1095, 1097, 1099, 1101, 1102, 1103, 1104, 1105, 
	1109, 1115, 1118, 1120, 1126, 1148, 1150, 1152, 
	1154, 1156, 1158, 1160, 1163, 1165, 1167, 1169, 
	1171, 1173, 1175, 1177, 1179, 1181, 1183, 1185, 
	1187, 1189, 1191, 1193, 1195, 1197, 1199, 1201, 
	1203, 1205, 1207, 1209, 1212, 1214, 1216, 1218, 
	1220, 1222, 1224, 1226, 1228, 1230, 1232, 1234, 
	1236, 1238, 1240, 1242, 1244, 1246, 1248, 1250, 
	1252, 1254, 1256, 1258, 1260, 1262, 1264, 1266, 
	1268, 1270, 1272, 1274, 1276, 1278, 1280, 1282, 
	1284, 1286, 1288, 1290, 1292, 1294, 1296, 1298, 
	1300, 1302, 1304
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 71, 73, 74, 75, 77, 79, 
	80, 83, 87, 90, 124, 9, 13, -69, 
	-65, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 71, 73, 74, 75, 77, 79, 
	80, 83, 87, 90, 124, 9, 13, 34, 
	34, 10, 13, 10, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 9, 13, 10, 32, 9, 
	13, 10, 13, 10, 95, 70, 69, 65, 
	84, 85, 82, 69, 95, 69, 78, 68, 
	95, 37, 32, 10, 13, 10, 13, 13, 
	32, 64, 9, 10, 9, 10, 13, 32, 
	64, 11, 12, 10, 32, 64, 9, 13, 
	108, 115, 101, 112, 101, 107, 116, 58, 
	10, 10, 10, 32, 35, 37, 64, 65, 
	70, 80, 83, 87, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 115, 10, 112, 10, 
	101, 10, 107, 10, 116, 10, 58, 10, 
	32, 34, 35, 37, 42, 64, 65, 70, 
	71, 73, 74, 75, 77, 79, 80, 83, 
	87, 90, 124, 9, 13, 117, 110, 107, 
	99, 106, 97, 100, 121, 101, -59, -101, 
	-68, 108, 105, 101, 105, 101, 97, 106, 
	-60, -123, 99, 114, 97, 122, 111, 114, 
	116, 114, 122, 101, 98, 97, 32, 98, 
	105, 122, 110, 101, 115, 111, 119, 122, 
	121, 107, -59, -126, 97, 100, 121, 58, 
	10, 10, 10, 32, 35, 65, 70, 80, 
	87, 124, 9, 13, 10, 115, 10, 112, 
	10, 101, 10, 107, 10, 116, 10, 58, 
	10, 117, 10, 110, 10, 107, 10, 99, 
	10, 106, 10, 97, 10, 111, 10, 116, 
	10, 114, 10, 122, 10, 101, 10, 98, 
	10, 97, 10, 32, 10, 98, 10, 105, 
	10, 122, 10, 110, 10, 101, 10, 115, 
	10, 111, 10, 119, -59, 10, -126, 10, 
	10, 97, -59, 10, -101, 10, 10, 99, 
	10, 105, 10, 119, 10, 111, -59, 10, 
	-101, 10, -60, 10, -121, 10, 99, 122, 
	101, 110, 97, 114, 105, 117, 115, 122, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 65, 70, 71, 73, 74, 75, 77, 
	79, 80, 83, 87, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 108, 115, 
	10, 101, 10, 112, 10, 101, 10, 107, 
	10, 116, 10, 58, 10, 117, 10, 110, 
	10, 107, 10, 99, 10, 106, 10, 97, 
	10, 100, 10, 121, 10, 101, -59, 10, 
	-101, -68, 10, 10, 108, 10, 105, 10, 
	101, 10, 105, 10, 101, 10, 97, 10, 
	106, -60, 10, -123, 10, 10, 99, 10, 
	114, 10, 97, 10, 122, 10, 111, 10, 
	116, 10, 114, 10, 122, 10, 101, 10, 
	98, 10, 97, 10, 32, 10, 98, 10, 
	105, 10, 122, 10, 110, 10, 101, 10, 
	115, 10, 111, 10, 119, 10, 99, 122, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 117, 10, 115, 10, 122, 
	10, 97, 10, 98, 10, 108, 10, 111, 
	10, 110, 10, 32, 10, 115, 10, 99, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 117, 10, 115, 10, 122, 
	-59, 10, 116, -126, 10, 10, 97, -59, 
	10, -101, 10, 10, 99, 10, 105, 10, 
	119, 10, 111, -59, 10, -101, 10, -60, 
	10, -121, 10, 10, 97, -59, 10, 107, 
	-126, 10, 10, 111, -59, 10, -68, 10, 
	10, 101, 10, 110, 10, 105, -59, 10, 
	-126, 10, 10, 97, 10, 100, 97, 98, 
	108, 111, 110, 32, 115, 99, 101, 110, 
	97, 114, 105, 117, 115, 122, 97, 58, 
	10, 10, 10, 32, 35, 37, 42, 64, 
	65, 70, 71, 73, 74, 75, 77, 79, 
	80, 83, 87, 90, 9, 13, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 32, 10, 108, 115, 10, 
	101, 10, 112, 10, 101, 10, 107, 10, 
	116, 10, 58, 10, 117, 10, 110, 10, 
	107, 10, 99, 10, 106, 10, 97, 10, 
	100, 10, 121, 10, 101, -59, 10, -101, 
	-68, 10, 10, 108, 10, 105, 10, 101, 
	10, 105, 10, 101, 10, 97, 10, 106, 
	-60, 10, -123, 10, 10, 99, 10, 114, 
	10, 97, 10, 122, 10, 111, 10, 116, 
	10, 114, 10, 122, 10, 101, 10, 98, 
	10, 97, 10, 32, 10, 98, 10, 105, 
	10, 122, 10, 110, 10, 101, 10, 115, 
	10, 111, 10, 119, 10, 99, 10, 101, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 117, 10, 115, 10, 122, -59, 10, 
	116, -126, 10, 10, 97, -59, 10, -101, 
	10, 10, 99, 10, 105, 10, 119, 10, 
	111, -59, 10, -101, 10, -60, 10, -121, 
	10, 10, 97, 10, 107, -59, 10, -126, 
	10, 10, 97, 10, 100, -59, 116, -126, 
	97, -59, -101, 99, 105, 119, 111, -59, 
	-101, -60, -121, 97, -59, 107, -126, 111, 
	-59, -68, 101, 110, 105, 97, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	70, 71, 73, 74, 75, 77, 79, 80, 
	83, 87, 90, 9, 13, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, 10, 32, 10, 108, 115, 10, 101, 
	10, 112, 10, 101, 10, 107, 10, 116, 
	10, 58, 10, 117, 10, 110, 10, 107, 
	10, 99, 10, 106, 10, 97, 10, 100, 
	10, 121, 10, 101, -59, 10, -101, -68, 
	10, 10, 108, 10, 105, 10, 101, 10, 
	105, 10, 101, 10, 97, 10, 106, -60, 
	10, -123, 10, 10, 99, 10, 114, 10, 
	97, 10, 122, 10, 111, 10, 116, 10, 
	114, 10, 122, 10, 101, 10, 98, 10, 
	97, 10, 32, 10, 98, 10, 105, 10, 
	122, 10, 110, 10, 101, 10, 115, 10, 
	111, 10, 119, 10, 99, 122, 10, 101, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 117, 10, 115, 10, 122, 10, 97, 
	10, 98, 10, 108, 10, 111, 10, 110, 
	10, 32, 10, 115, 10, 99, 10, 101, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 117, 10, 115, 10, 122, -59, 10, 
	116, -126, 10, 10, 97, -59, 10, -101, 
	10, 10, 99, 10, 105, 10, 119, 10, 
	111, -59, 10, -101, 10, -60, 10, -121, 
	10, 10, 97, 10, 107, -59, 10, -126, 
	10, 10, 97, 10, 100, -59, -126, 97, 
	100, 32, 124, 9, 13, 10, 32, 92, 
	124, 9, 13, 10, 92, 124, 10, 92, 
	10, 32, 92, 124, 9, 13, 10, 32, 
	34, 35, 37, 42, 64, 65, 70, 71, 
	73, 74, 75, 77, 79, 80, 83, 87, 
	90, 124, 9, 13, 10, 117, 10, 110, 
	10, 107, 10, 99, 10, 106, 10, 97, 
	10, 111, 114, 10, 116, 10, 114, 10, 
	122, 10, 101, 10, 98, 10, 97, 10, 
	32, 10, 98, 10, 105, 10, 122, 10, 
	110, 10, 101, 10, 115, 10, 111, 10, 
	119, 10, 122, 10, 121, 10, 107, -59, 
	10, -126, 10, 10, 97, 10, 100, 10, 
	121, 10, 99, 122, 10, 101, 10, 110, 
	10, 97, 10, 114, 10, 105, 10, 117, 
	10, 115, 10, 122, 10, 97, 10, 98, 
	10, 108, 10, 111, 10, 110, 10, 32, 
	10, 115, 10, 99, 10, 101, 10, 110, 
	10, 97, 10, 114, 10, 105, 10, 117, 
	10, 115, 10, 122, -59, 10, -126, 10, 
	10, 97, -59, 10, -101, 10, 10, 99, 
	10, 105, 10, 119, 10, 111, -59, 10, 
	-101, 10, -60, 10, -121, 10, 10, 97, 
	-59, 10, -126, 10, 10, 111, -59, 10, 
	-68, 10, 10, 101, 10, 110, 10, 105, 
	0
};

static const char _lexer_single_lengths[] = {
	0, 21, 1, 1, 20, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 11, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 20, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 8, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 18, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 18, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	18, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 2, 
	4, 3, 2, 4, 20, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 23, 25, 27, 49, 51, 53, 
	56, 59, 64, 69, 74, 79, 83, 87, 
	90, 92, 94, 96, 98, 100, 102, 104, 
	106, 108, 110, 112, 114, 116, 118, 120, 
	122, 125, 128, 133, 140, 145, 148, 150, 
	152, 154, 156, 158, 160, 162, 164, 177, 
	180, 183, 186, 189, 192, 195, 198, 201, 
	204, 207, 210, 213, 216, 219, 222, 225, 
	228, 231, 234, 237, 259, 261, 263, 265, 
	267, 269, 271, 273, 275, 277, 279, 282, 
	284, 286, 288, 290, 292, 294, 296, 298, 
	300, 302, 304, 306, 308, 311, 313, 315, 
	317, 319, 321, 323, 325, 327, 329, 331, 
	333, 335, 337, 339, 341, 343, 345, 347, 
	349, 351, 353, 355, 357, 359, 361, 363, 
	373, 376, 379, 382, 385, 388, 391, 394, 
	397, 400, 403, 406, 409, 412, 415, 418, 
	421, 424, 427, 430, 433, 436, 439, 442, 
	445, 448, 451, 454, 457, 460, 463, 466, 
	469, 472, 475, 478, 481, 484, 487, 490, 
	493, 496, 499, 501, 503, 505, 507, 509, 
	511, 513, 515, 517, 519, 521, 541, 544, 
	547, 550, 553, 556, 559, 562, 565, 568, 
	571, 574, 577, 580, 583, 586, 590, 593, 
	596, 599, 602, 605, 608, 611, 614, 617, 
	620, 623, 626, 629, 632, 635, 638, 642, 
	645, 648, 651, 654, 657, 660, 663, 666, 
	669, 672, 675, 678, 681, 684, 687, 690, 
	693, 696, 699, 702, 705, 708, 711, 714, 
	717, 720, 723, 726, 729, 733, 736, 739, 
	742, 745, 748, 751, 754, 757, 760, 763, 
	766, 769, 772, 775, 778, 781, 784, 787, 
	790, 793, 796, 799, 802, 805, 809, 812, 
	815, 818, 821, 824, 827, 830, 833, 836, 
	839, 842, 845, 848, 852, 855, 858, 861, 
	864, 867, 870, 873, 876, 879, 882, 885, 
	887, 889, 891, 893, 895, 897, 899, 901, 
	903, 905, 907, 909, 911, 913, 915, 917, 
	919, 921, 923, 925, 945, 948, 951, 954, 
	957, 960, 963, 966, 969, 972, 975, 978, 
	981, 984, 987, 990, 994, 997, 1000, 1003, 
	1006, 1009, 1012, 1015, 1018, 1021, 1024, 1027, 
	1030, 1033, 1036, 1039, 1042, 1046, 1049, 1052, 
	1055, 1058, 1061, 1064, 1067, 1070, 1073, 1076, 
	1079, 1082, 1085, 1088, 1091, 1094, 1097, 1100, 
	1103, 1106, 1109, 1112, 1115, 1118, 1121, 1124, 
	1127, 1130, 1133, 1136, 1139, 1142, 1145, 1148, 
	1151, 1154, 1157, 1160, 1164, 1167, 1170, 1173, 
	1176, 1179, 1182, 1185, 1188, 1191, 1194, 1197, 
	1200, 1203, 1206, 1209, 1212, 1215, 1218, 1221, 
	1223, 1225, 1227, 1229, 1231, 1233, 1235, 1237, 
	1239, 1241, 1243, 1245, 1247, 1250, 1252, 1254, 
	1256, 1258, 1260, 1262, 1264, 1266, 1268, 1270, 
	1272, 1292, 1295, 1298, 1301, 1304, 1307, 1310, 
	1313, 1316, 1319, 1322, 1325, 1328, 1331, 1334, 
	1337, 1341, 1344, 1347, 1350, 1353, 1356, 1359, 
	1362, 1365, 1368, 1371, 1374, 1377, 1380, 1383, 
	1386, 1389, 1393, 1396, 1399, 1402, 1405, 1408, 
	1411, 1414, 1417, 1420, 1423, 1426, 1429, 1432, 
	1435, 1438, 1441, 1444, 1447, 1450, 1453, 1456, 
	1459, 1462, 1465, 1468, 1471, 1474, 1477, 1480, 
	1484, 1487, 1490, 1493, 1496, 1499, 1502, 1505, 
	1508, 1511, 1514, 1517, 1520, 1523, 1526, 1529, 
	1532, 1535, 1538, 1541, 1544, 1547, 1550, 1553, 
	1556, 1560, 1563, 1566, 1569, 1572, 1575, 1578, 
	1581, 1584, 1587, 1590, 1593, 1596, 1599, 1602, 
	1605, 1608, 1611, 1614, 1616, 1618, 1620, 1622, 
	1626, 1632, 1636, 1639, 1645, 1667, 1670, 1673, 
	1676, 1679, 1682, 1685, 1689, 1692, 1695, 1698, 
	1701, 1704, 1707, 1710, 1713, 1716, 1719, 1722, 
	1725, 1728, 1731, 1734, 1737, 1740, 1743, 1746, 
	1749, 1752, 1755, 1758, 1762, 1765, 1768, 1771, 
	1774, 1777, 1780, 1783, 1786, 1789, 1792, 1795, 
	1798, 1801, 1804, 1807, 1810, 1813, 1816, 1819, 
	1822, 1825, 1828, 1831, 1834, 1837, 1840, 1843, 
	1846, 1849, 1852, 1855, 1858, 1861, 1864, 1867, 
	1870, 1873, 1876, 1879, 1882, 1885, 1888, 1891, 
	1894, 1897, 1900
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 68, 74, 31, 76, 82, 84, 89, 
	92, 161, 398, 411, 535, 4, 0, 3, 
	0, 4, 0, 4, 4, 5, 15, 17, 
	31, 34, 37, 68, 74, 31, 76, 82, 
	84, 89, 92, 161, 398, 411, 535, 4, 
	0, 6, 0, 7, 0, 9, 8, 8, 
	9, 8, 8, 10, 10, 11, 10, 10, 
	10, 10, 11, 10, 10, 10, 10, 12, 
	10, 10, 10, 10, 13, 10, 10, 4, 
	14, 14, 0, 4, 14, 14, 0, 4, 
	16, 15, 4, 0, 18, 0, 19, 0, 
	20, 0, 21, 0, 22, 0, 23, 0, 
	24, 0, 25, 0, 26, 0, 27, 0, 
	28, 0, 29, 0, 30, 0, 618, 0, 
	32, 0, 4, 16, 33, 4, 16, 33, 
	0, 0, 0, 0, 35, 36, 4, 36, 
	36, 34, 35, 35, 4, 36, 34, 36, 
	0, 38, 39, 0, 31, 0, 40, 0, 
	41, 0, 42, 0, 43, 0, 44, 0, 
	46, 45, 46, 45, 46, 46, 4, 47, 
	4, 61, 541, 547, 571, 596, 609, 46, 
	45, 46, 48, 45, 46, 49, 45, 46, 
	50, 45, 46, 51, 45, 46, 52, 45, 
	46, 53, 45, 46, 54, 45, 46, 55, 
	45, 46, 56, 45, 46, 57, 45, 46, 
	58, 45, 46, 59, 45, 46, 60, 45, 
	46, 4, 45, 46, 62, 45, 46, 63, 
	45, 46, 64, 45, 46, 65, 45, 46, 
	66, 45, 46, 67, 45, 4, 4, 5, 
	15, 17, 31, 34, 37, 68, 74, 31, 
	76, 82, 84, 89, 92, 161, 398, 411, 
	535, 4, 0, 69, 0, 70, 0, 71, 
	0, 72, 0, 73, 0, 43, 0, 75, 
	0, 31, 0, 77, 0, 78, 0, 79, 
	81, 0, 80, 0, 31, 0, 79, 0, 
	83, 0, 74, 0, 85, 0, 86, 0, 
	87, 0, 88, 0, 31, 0, 90, 0, 
	91, 0, 31, 0, 93, 108, 0, 94, 
	0, 95, 0, 96, 0, 97, 0, 98, 
	0, 99, 0, 100, 0, 101, 0, 102, 
	0, 103, 0, 104, 0, 105, 0, 106, 
	0, 107, 0, 73, 0, 109, 0, 110, 
	0, 111, 0, 112, 0, 113, 0, 114, 
	0, 115, 0, 116, 0, 117, 0, 119, 
	118, 119, 118, 119, 119, 4, 120, 126, 
	132, 148, 4, 119, 118, 119, 121, 118, 
	119, 122, 118, 119, 123, 118, 119, 124, 
	118, 119, 125, 118, 119, 67, 118, 119, 
	127, 118, 119, 128, 118, 119, 129, 118, 
	119, 130, 118, 119, 131, 118, 119, 125, 
	118, 119, 133, 118, 119, 134, 118, 119, 
	135, 118, 119, 136, 118, 119, 137, 118, 
	119, 138, 118, 119, 139, 118, 119, 140, 
	118, 119, 141, 118, 119, 142, 118, 119, 
	143, 118, 119, 144, 118, 119, 145, 118, 
	119, 146, 118, 119, 147, 118, 119, 131, 
	118, 149, 119, 118, 150, 119, 118, 119, 
	151, 118, 152, 119, 118, 153, 119, 118, 
	119, 154, 118, 119, 155, 118, 119, 156, 
	118, 119, 157, 118, 158, 119, 118, 159, 
	119, 118, 160, 119, 118, 125, 119, 118, 
	162, 287, 0, 163, 0, 164, 0, 165, 
	0, 166, 0, 167, 0, 168, 0, 169, 
	0, 170, 0, 171, 0, 173, 172, 173, 
	172, 173, 173, 4, 174, 188, 4, 189, 
	196, 202, 188, 204, 210, 212, 217, 220, 
	236, 261, 274, 173, 172, 173, 175, 172, 
	173, 176, 172, 173, 177, 172, 173, 178, 
	172, 173, 179, 172, 173, 180, 172, 173, 
	181, 172, 173, 182, 172, 173, 183, 172, 
	173, 184, 172, 173, 185, 172, 173, 186, 
	172, 173, 187, 172, 173, 4, 172, 173, 
	67, 172, 173, 190, 191, 172, 173, 188, 
	172, 173, 192, 172, 173, 193, 172, 173, 
	194, 172, 173, 195, 172, 173, 67, 172, 
	173, 197, 172, 173, 198, 172, 173, 199, 
	172, 173, 200, 172, 173, 201, 172, 173, 
	195, 172, 173, 203, 172, 173, 188, 172, 
	173, 205, 172, 206, 173, 172, 207, 209, 
	173, 172, 173, 208, 172, 173, 188, 172, 
	173, 207, 172, 173, 211, 172, 173, 202, 
	172, 173, 213, 172, 173, 214, 172, 215, 
	173, 172, 216, 173, 172, 173, 188, 172, 
	173, 218, 172, 173, 219, 172, 173, 188, 
	172, 173, 221, 172, 173, 222, 172, 173, 
	223, 172, 173, 224, 172, 173, 225, 172, 
	173, 226, 172, 173, 227, 172, 173, 228, 
	172, 173, 229, 172, 173, 230, 172, 173, 
	231, 172, 173, 232, 172, 173, 233, 172, 
	173, 234, 172, 173, 235, 172, 173, 201, 
	172, 173, 237, 245, 172, 173, 238, 172, 
	173, 239, 172, 173, 240, 172, 173, 241, 
	172, 173, 242, 172, 173, 243, 172, 173, 
	244, 172, 173, 195, 172, 173, 246, 172, 
	173, 247, 172, 173, 248, 172, 173, 249, 
	172, 173, 250, 172, 173, 251, 172, 173, 
	252, 172, 173, 253, 172, 173, 254, 172, 
	173, 255, 172, 173, 256, 172, 173, 257, 
	172, 173, 258, 172, 173, 259, 172, 173, 
	260, 172, 173, 201, 172, 262, 173, 211, 
	172, 263, 173, 172, 173, 264, 172, 265, 
	173, 172, 266, 173, 172, 173, 267, 172, 
	173, 268, 172, 173, 269, 172, 173, 270, 
	172, 271, 173, 172, 272, 173, 172, 273, 
	173, 172, 195, 173, 172, 173, 275, 172, 
	276, 173, 283, 172, 277, 173, 172, 173, 
	278, 172, 279, 173, 172, 280, 173, 172, 
	173, 281, 172, 173, 282, 172, 173, 201, 
	172, 284, 173, 172, 285, 173, 172, 173, 
	286, 172, 173, 212, 172, 288, 0, 289, 
	0, 290, 0, 291, 0, 292, 0, 293, 
	0, 294, 0, 295, 0, 296, 0, 297, 
	0, 298, 0, 299, 0, 300, 0, 301, 
	0, 302, 0, 303, 0, 304, 0, 305, 
	0, 307, 306, 307, 306, 307, 307, 4, 
	308, 322, 4, 323, 330, 336, 322, 338, 
	344, 346, 351, 354, 370, 379, 392, 307, 
	306, 307, 309, 306, 307, 310, 306, 307, 
	311, 306, 307, 312, 306, 307, 313, 306, 
	307, 314, 306, 307, 315, 306, 307, 316, 
	306, 307, 317, 306, 307, 318, 306, 307, 
	319, 306, 307, 320, 306, 307, 321, 306, 
	307, 4, 306, 307, 67, 306, 307, 324, 
	325, 306, 307, 322, 306, 307, 326, 306, 
	307, 327, 306, 307, 328, 306, 307, 329, 
	306, 307, 67, 306, 307, 331, 306, 307, 
	332, 306, 307, 333, 306, 307, 334, 306, 
	307, 335, 306, 307, 329, 306, 307, 337, 
	306, 307, 322, 306, 307, 339, 306, 340, 
	307, 306, 341, 343, 307, 306, 307, 342, 
	306, 307, 322, 306, 307, 341, 306, 307, 
	345, 306, 307, 336, 306, 307, 347, 306, 
	307, 348, 306, 349, 307, 306, 350, 307, 
	306, 307, 322, 306, 307, 352, 306, 307, 
	353, 306, 307, 322, 306, 307, 355, 306, 
	307, 356, 306, 307, 357, 306, 307, 358, 
	306, 307, 359, 306, 307, 360, 306, 307, 
	361, 306, 307, 362, 306, 307, 363, 306, 
	307, 364, 306, 307, 365, 306, 307, 366, 
	306, 307, 367, 306, 307, 368, 306, 307, 
	369, 306, 307, 335, 306, 307, 371, 306, 
	307, 372, 306, 307, 373, 306, 307, 374, 
	306, 307, 375, 306, 307, 376, 306, 307, 
	377, 306, 307, 378, 306, 307, 329, 306, 
	380, 307, 345, 306, 381, 307, 306, 307, 
	382, 306, 383, 307, 306, 384, 307, 306, 
	307, 385, 306, 307, 386, 306, 307, 387, 
	306, 307, 388, 306, 389, 307, 306, 390, 
	307, 306, 391, 307, 306, 329, 307, 306, 
	307, 393, 306, 307, 394, 306, 395, 307, 
	306, 396, 307, 306, 307, 397, 306, 307, 
	346, 306, 399, 83, 0, 400, 0, 401, 
	0, 402, 0, 403, 0, 404, 0, 405, 
	0, 406, 0, 407, 0, 408, 0, 409, 
	0, 410, 0, 43, 0, 412, 0, 413, 
	531, 0, 414, 0, 415, 0, 416, 0, 
	417, 0, 418, 0, 419, 0, 420, 0, 
	421, 0, 422, 0, 424, 423, 424, 423, 
	424, 424, 4, 425, 439, 4, 440, 447, 
	453, 439, 455, 461, 463, 468, 471, 487, 
	512, 525, 424, 423, 424, 426, 423, 424, 
	427, 423, 424, 428, 423, 424, 429, 423, 
	424, 430, 423, 424, 431, 423, 424, 432, 
	423, 424, 433, 423, 424, 434, 423, 424, 
	435, 423, 424, 436, 423, 424, 437, 423, 
	424, 438, 423, 424, 4, 423, 424, 67, 
	423, 424, 441, 442, 423, 424, 439, 423, 
	424, 443, 423, 424, 444, 423, 424, 445, 
	423, 424, 446, 423, 424, 67, 423, 424, 
	448, 423, 424, 449, 423, 424, 450, 423, 
	424, 451, 423, 424, 452, 423, 424, 446, 
	423, 424, 454, 423, 424, 439, 423, 424, 
	456, 423, 457, 424, 423, 458, 460, 424, 
	423, 424, 459, 423, 424, 439, 423, 424, 
	458, 423, 424, 462, 423, 424, 453, 423, 
	424, 464, 423, 424, 465, 423, 466, 424, 
	423, 467, 424, 423, 424, 439, 423, 424, 
	469, 423, 424, 470, 423, 424, 439, 423, 
	424, 472, 423, 424, 473, 423, 424, 474, 
	423, 424, 475, 423, 424, 476, 423, 424, 
	477, 423, 424, 478, 423, 424, 479, 423, 
	424, 480, 423, 424, 481, 423, 424, 482, 
	423, 424, 483, 423, 424, 484, 423, 424, 
	485, 423, 424, 486, 423, 424, 452, 423, 
	424, 488, 496, 423, 424, 489, 423, 424, 
	490, 423, 424, 491, 423, 424, 492, 423, 
	424, 493, 423, 424, 494, 423, 424, 495, 
	423, 424, 446, 423, 424, 497, 423, 424, 
	498, 423, 424, 499, 423, 424, 500, 423, 
	424, 501, 423, 424, 502, 423, 424, 503, 
	423, 424, 504, 423, 424, 505, 423, 424, 
	506, 423, 424, 507, 423, 424, 508, 423, 
	424, 509, 423, 424, 510, 423, 424, 511, 
	423, 424, 452, 423, 513, 424, 462, 423, 
	514, 424, 423, 424, 515, 423, 516, 424, 
	423, 517, 424, 423, 424, 518, 423, 424, 
	519, 423, 424, 520, 423, 424, 521, 423, 
	522, 424, 423, 523, 424, 423, 524, 424, 
	423, 446, 424, 423, 424, 526, 423, 424, 
	527, 423, 528, 424, 423, 529, 424, 423, 
	424, 530, 423, 424, 463, 423, 532, 0, 
	533, 0, 534, 0, 84, 0, 535, 536, 
	535, 0, 540, 539, 538, 536, 539, 537, 
	0, 538, 536, 537, 0, 538, 537, 540, 
	539, 538, 536, 539, 537, 540, 540, 5, 
	15, 17, 31, 34, 37, 68, 74, 31, 
	76, 82, 84, 89, 92, 161, 398, 411, 
	535, 540, 0, 46, 542, 45, 46, 543, 
	45, 46, 544, 45, 46, 545, 45, 46, 
	546, 45, 46, 66, 45, 46, 548, 563, 
	45, 46, 549, 45, 46, 550, 45, 46, 
	551, 45, 46, 552, 45, 46, 553, 45, 
	46, 554, 45, 46, 555, 45, 46, 556, 
	45, 46, 557, 45, 46, 558, 45, 46, 
	559, 45, 46, 560, 45, 46, 561, 45, 
	46, 562, 45, 46, 546, 45, 46, 564, 
	45, 46, 565, 45, 46, 566, 45, 567, 
	46, 45, 568, 46, 45, 46, 569, 45, 
	46, 570, 45, 46, 66, 45, 46, 572, 
	580, 45, 46, 573, 45, 46, 574, 45, 
	46, 575, 45, 46, 576, 45, 46, 577, 
	45, 46, 578, 45, 46, 579, 45, 46, 
	66, 45, 46, 581, 45, 46, 582, 45, 
	46, 583, 45, 46, 584, 45, 46, 585, 
	45, 46, 586, 45, 46, 587, 45, 46, 
	588, 45, 46, 589, 45, 46, 590, 45, 
	46, 591, 45, 46, 592, 45, 46, 593, 
	45, 46, 594, 45, 46, 595, 45, 46, 
	546, 45, 597, 46, 45, 598, 46, 45, 
	46, 599, 45, 600, 46, 45, 601, 46, 
	45, 46, 602, 45, 46, 603, 45, 46, 
	604, 45, 46, 605, 45, 606, 46, 45, 
	607, 46, 45, 608, 46, 45, 66, 46, 
	45, 46, 610, 45, 611, 46, 45, 612, 
	46, 45, 46, 613, 45, 614, 46, 45, 
	615, 46, 45, 46, 616, 45, 46, 617, 
	45, 46, 546, 45, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 35, 0, 43, 0, 
	43, 0, 43, 54, 0, 5, 1, 0, 
	29, 1, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 35, 0, 
	43, 0, 43, 0, 43, 139, 48, 9, 
	106, 11, 0, 134, 45, 45, 45, 3, 
	122, 33, 33, 33, 0, 122, 33, 33, 
	33, 0, 122, 33, 0, 33, 0, 102, 
	7, 7, 43, 54, 0, 0, 43, 114, 
	25, 0, 54, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 149, 126, 57, 110, 23, 0, 
	43, 43, 43, 43, 0, 27, 118, 27, 
	27, 51, 27, 0, 54, 0, 1, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 54, 0, 69, 33, 
	69, 84, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 13, 0, 130, 31, 60, 
	57, 31, 63, 57, 63, 63, 63, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	66, 31, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 81, 84, 84, 
	84, 84, 81, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 21, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 54, 0, 75, 33, 84, 75, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 17, 0, 54, 
	17, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 78, 
	33, 84, 78, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 19, 0, 54, 19, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	54, 0, 72, 33, 84, 72, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 15, 0, 54, 15, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 15, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	0, 43, 54, 37, 37, 87, 37, 37, 
	43, 0, 39, 0, 43, 0, 0, 54, 
	0, 0, 39, 0, 0, 54, 0, 93, 
	90, 41, 96, 90, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	99, 0, 43, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 618;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/pl.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1342 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/pl.c.rl"
    
#line 1349 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/pl.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/pl.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/pl.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/pl.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/pl.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/pl.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/pl.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/pl.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/pl.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/pl.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/pl.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/pl.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/pl.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/pl.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/pl.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/pl.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/pl.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/pl.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/pl.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/pl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1639 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/pl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1702 "ext/gherkin_lexer_pl/gherkin_lexer_pl.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/pl.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_pl()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Pl", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

