#include "../macro.S"
#include "constants.S"

SECTION_TEXT

GLOBAL_HIDDEN_FN_EXT blake2b_blocks_x86, 4, 8
pushq %rbx
pushq %rbp
pushq %r12
pushq %r13
pushq %r14
pushq %r15
movq %rsp, %r9
subq $320, %rsp
andq $~63, %rsp
cmpq $128, %rdx
movq %rdx, %rax
jb blake2b_blocks_x86_usebytesinc
movq $128, %rax
blake2b_blocks_x86_usebytesinc:
movq %rdx, 136(%rsp)
movq %rcx, 144(%rsp)
movq %rax, 152(%rsp)
movq %rdi, 160(%rsp)
movq %r9, 168(%rsp)
movq 80(%rdi), %rcx
andq %rcx, %rcx
jz blake2b_blocks_x86_not_final_call
cmpq $128, %rdx
je blake2b_blocks_x86_not_final_call
leaq 0(%rsp), %rcx
pxor %xmm0, %xmm0
movdqa %xmm0, 0(%rcx)
movdqa %xmm0, 16(%rcx)
movdqa %xmm0, 32(%rcx)
movdqa %xmm0, 48(%rcx)
movdqa %xmm0, 64(%rcx)
movdqa %xmm0, 80(%rcx)
movdqa %xmm0, 96(%rcx)
movdqa %xmm0, 112(%rcx)
testq $0x40, %rdx
jz blake2b_blocks_x86_skip64
movdqu 0(%rsi), %xmm0
movdqu 16(%rsi), %xmm1
movdqu 32(%rsi), %xmm2
movdqu 48(%rsi), %xmm3
movdqa %xmm0, 0(%rcx)
movdqa %xmm1, 16(%rcx)
movdqa %xmm2, 32(%rcx)
movdqa %xmm3, 48(%rcx)
addq $64, %rsi
addq $64, %rcx
blake2b_blocks_x86_skip64:
testq $0x20, %rdx
jz blake2b_blocks_x86_skip32
movdqu 0(%rsi), %xmm0
movdqu 16(%rsi), %xmm1
movdqa %xmm0, 0(%rcx)
movdqa %xmm1, 16(%rcx)
addq $32, %rsi
addq $32, %rcx
blake2b_blocks_x86_skip32:
testq $0x10, %rdx
jz blake2b_blocks_x86_skip16
movdqu 0(%rsi), %xmm0
movdqa %xmm0, 0(%rcx)
addq $16, %rsi
addq $16, %rcx
blake2b_blocks_x86_skip16:
testq $0x8, %rdx
jz blake2b_blocks_x86_skip8
movq 0(%rsi), %rax
movq %rax, 0(%rcx)
addq $8, %rsi
addq $8, %rcx
blake2b_blocks_x86_skip8:
testq $0x4, %rdx
jz blake2b_blocks_x86_skip4
movl 0(%rsi), %eax
movl %eax, 0(%rcx)
addq $4, %rsi
addq $4, %rcx
blake2b_blocks_x86_skip4:
testq $0x2, %rdx
jz blake2b_blocks_x86_skip2
movw 0(%rsi), %ax
movw %ax, 0(%rcx)
addq $2, %rsi
addq $2, %rcx
blake2b_blocks_x86_skip2:
testq $0x1, %rdx
jz blake2b_blocks_x86_skip1
movb 0(%rsi), %al
movb %al, 0(%rcx)
blake2b_blocks_x86_skip1:
leaq 0(%rsp), %rsi
blake2b_blocks_x86_not_final_call:
movq %rsi, 128(%rsp)
movq 64(%rdi), %r12
movq 72(%rdi), %r13
movq 80(%rdi), %r14
movq 88(%rdi), %r15
movabsq $0x1f83d9abfb41bd6b, %rax
movabsq $0x5be0cd19137e2179, %rbx
xorq %rax, %r14
xorq %rbx, %r15
movq %r12, 256(%rsp)
movq %r13, 264(%rsp)
movq %r14, 272(%rsp)
movq %r15, 280(%rsp)
movq 0(%rdi), %rax
movq 8(%rdi), %rdx
movq 16(%rdi), %r8
movq 24(%rdi), %r12
movq 32(%rdi), %rbx
movq 40(%rdi), %rsi
movq 48(%rdi), %r9
movq 56(%rdi), %r13
.p2align 6,,63
blake2b_blocks_x86_mainloop:
movq 128(%rsp), %r10
cmpq %r10, %rsp
je blake2b_blocks_x86_nocopy
movdqu 0(%r10), %xmm0
movdqu 16(%r10), %xmm1
movdqu 32(%r10), %xmm2
movdqu 48(%r10), %xmm3
movdqu 64(%r10), %xmm4
movdqu 80(%r10), %xmm5
movdqu 96(%r10), %xmm6
movdqu 112(%r10), %xmm7
movdqa %xmm0, 0(%rsp)
movdqa %xmm1, 16(%rsp)
movdqa %xmm2, 32(%rsp)
movdqa %xmm3, 48(%rsp)
movdqa %xmm4, 64(%rsp)
movdqa %xmm5, 80(%rsp)
movdqa %xmm6, 96(%rsp)
movdqa %xmm7, 112(%rsp)
blake2b_blocks_x86_nocopy:
movq 152(%rsp), %r10
movq 256(%rsp), %rcx
movq 264(%rsp), %rbp
movabsq $0x510e527fade682d1, %r11
movabsq $0x9b05688c2b3e6c1f, %r15
addq %r10, %rcx
cmpq %r10, %rcx
jae blake2b_blocks_x86_nocountercarry
addq $1, %rbp
blake2b_blocks_x86_nocountercarry:
movq %rcx, 256(%rsp)
movq %rbp, 264(%rsp)
xorq %r11, %rcx
xorq %r15, %rbp
movabsq $0x6a09e667f3bcc908, %r11
movabsq $0xbb67ae8584caa73b, %rdi
movabsq $0x3c6ef372fe94f82b, %r10
movabsq $0xa54ff53a5f1d36f1, %r14
movq %r11, 296(%rsp)
movq 272(%rsp), %r11
movq 280(%rsp), %r15
movq %rax, 192(%rsp)
movq %rdx, 200(%rsp)
movq %r8, 208(%rsp)
movq %r12, 216(%rsp)
movq %rbx, 224(%rsp)
movq %rsi, 232(%rsp)
movq %r9, 240(%rsp)
movq %r13, 248(%rsp)
addq 0(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 16(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 32(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 48(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 8(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 24(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 40(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 56(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 64(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 80(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 96(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 112(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 72(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 88(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 104(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 120(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 112(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 32(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 72(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 104(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 80(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 64(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 120(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 48(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 8(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 0(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 88(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 40(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 96(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 16(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 56(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 24(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 88(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 96(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 40(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 120(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 64(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 0(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 16(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 104(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 80(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 24(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 56(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 72(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 112(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 48(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 8(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 32(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 56(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 24(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 104(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 88(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 72(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 8(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 96(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 112(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 16(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 40(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 32(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 120(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 48(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 80(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 0(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 64(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 72(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 40(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 16(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 80(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 0(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 56(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 32(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 120(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 112(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 88(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 48(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 24(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 8(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 96(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 64(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 104(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 16(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 48(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 0(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 64(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 96(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 80(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 88(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 24(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 32(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 56(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 120(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 8(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 104(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 40(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 112(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 72(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 96(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 8(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 112(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 32(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 40(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 120(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 104(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 80(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 0(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 48(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 72(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 64(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 56(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 24(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 16(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 88(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 104(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 56(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 96(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 24(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 88(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 112(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 8(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 72(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 40(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 120(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 64(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 16(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 0(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 32(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 48(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 80(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 48(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 112(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 88(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 0(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 120(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 72(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 24(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 64(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 96(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 104(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 8(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 80(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 16(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 56(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 32(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 40(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 80(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 64(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 56(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 8(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 16(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 32(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 48(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 40(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 120(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 72(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 24(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 104(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 88(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 112(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 96(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 0(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 0(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 16(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 32(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 48(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 8(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 24(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 40(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 56(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 64(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 80(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 96(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 112(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 72(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 88(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 104(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 120(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
addq 112(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $32, %rcx
addq 32(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $32, %rbp
addq 72(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $32, %r11
addq 104(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $32, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $40, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $40, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $40, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $40, %r13
addq 80(%rsp), %rax
addq %rbx, %rax
xorq %rax, %rcx
rolq $48, %rcx
addq 64(%rsp), %rdx
addq %rsi, %rdx
xorq %rdx, %rbp
rolq $48, %rbp
addq 120(%rsp), %r8
addq %r9, %r8
movq %rax, 288(%rsp)
xorq %r8, %r11
rolq $48, %r11
addq 48(%rsp), %r12
addq %r13, %r12
xorq %r12, %r15
rolq $48, %r15
movq 296(%rsp), %rax
addq %rcx, %rax
xorq %rax, %rbx
movq %rax, 296(%rsp)
rolq $1, %rbx
addq %rbp, %rdi
xorq %rdi, %rsi
rolq $1, %rsi
addq %r11, %r10
xorq %r10, %r9
rolq $1, %r9
movq 288(%rsp), %rax
addq %r15, %r14
xorq %r14, %r13
rolq $1, %r13
addq 8(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $32, %r15
addq 0(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $32, %rcx
addq 88(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $32, %rbp
addq 40(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $32, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $40, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $40, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $40, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $40, %rbx
addq 96(%rsp), %rax
addq %rsi, %rax
xorq %rax, %r15
rolq $48, %r15
addq 16(%rsp), %rdx
addq %r9, %rdx
xorq %rdx, %rcx
rolq $48, %rcx
addq 56(%rsp), %r8
addq %r13, %r8
movq %rax, 288(%rsp)
xorq %r8, %rbp
rolq $48, %rbp
addq 24(%rsp), %r12
addq %rbx, %r12
xorq %r12, %r11
rolq $48, %r11
addq %r15, %r10
xorq %r10, %rsi
rolq $1, %rsi
addq %rcx, %r14
xorq %r14, %r9
rolq $1, %r9
movq 296(%rsp), %rax
addq %rbp, %rax
xorq %rax, %r13
movq %rax, 296(%rsp)
rolq $1, %r13
movq 288(%rsp), %rax
addq %r11, %rdi
xorq %rdi, %rbx
rolq $1, %rbx
xorq 296(%rsp), %rax
xorq %rdi, %rdx
xorq %r10, %r8
xorq %r14, %r12
xorq %rcx, %rbx
xorq %rbp, %rsi
xorq %r11, %r9
xorq %r15, %r13
xorq 192(%rsp), %rax
xorq 200(%rsp), %rdx
xorq 208(%rsp), %r8
xorq 216(%rsp), %r12
xorq 224(%rsp), %rbx
xorq 232(%rsp), %rsi
xorq 240(%rsp), %r9
xorq 248(%rsp), %r13
movq 128(%rsp), %rcx
movq 136(%rsp), %rbp
movq 144(%rsp), %r11
cmpq $128, %rbp
jbe blake2b_blocks_x86_done
addq %r11, %rcx
subq $128, %rbp
movq %rcx, 128(%rsp)
movq %rbp, 136(%rsp)
jmp blake2b_blocks_x86_mainloop
blake2b_blocks_x86_done:
movq 160(%rsp), %rcx
movq 256(%rsp), %rbp
movq 264(%rsp), %r11
movq %rax, 0(%rcx)
movq %rdx, 8(%rcx)
movq %r8, 16(%rcx)
movq %r12, 24(%rcx)
movq %rbx, 32(%rcx)
movq %rsi, 40(%rcx)
movq %r9, 48(%rcx)
movq %r13, 56(%rcx)
movq %rbp, 64(%rcx)
movq %r11, 72(%rcx)
movq 168(%rsp), %rsp
popq %r15
popq %r14
popq %r13
popq %r12
popq %rbp
popq %rbx
ret
FN_END blake2b_blocks_x86
