% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{page_content}
\alias{page_content}
\title{Retrieves MediaWiki page content}
\usage{
page_content(language = NULL, project = NULL, domain = NULL, page_name,
  page_id = NULL, as_wikitext = FALSE, clean_response = FALSE, ...)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{page_name}{The title of the page you want to retrieve}

\item{page_id}{the pageID of the page you want to retrieve. Set to NULL by default,
and an alternative to page_name; if both are provided, page_id will be used.}

\item{as_wikitext}{whether to retrieve the wikimarkup (TRUE) or the HTML (FALSE).
Set to FALSE by default.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
wiki_page retrieves the DOM of a particular MediaWiki page,
as a HTML blob inside a JSON object.
}
\examples{
#Content from a Wikimedia project
wp_content <- page_content("en","wikipedia", page_name = "Aaron Halfaker")

#Content by ID
wp_content <- page_content("en", "wikipedia", page_id = 12)

#Content from a non-Wikimedia project
rw_content <- page_content(domain = "rationalwiki.org", page_name = "New Age")
}
\seealso{
\code{\link{revision_diff}} for retrieving 'diffs' between revisions,
\code{\link{revision_content}} for retrieving the text of specified revisions.
}

