% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VIM-package.R
\docType{data}
\name{bcancer}
\alias{bcancer}
\title{Breast cancer Wisconsin data set}
\format{
A data frame with 699 observations on the following 11 variables.
\describe{
\item{ID}{Sample ID}
\item{clump_thickness}{as integer from 1 - 10}
\item{uniformity_cellsize}{as integer from 1 - 10}
\item{uniformity_cellshape}{as integer from 1 - 10}
\item{adhesion}{as integer from 1 - 10}
\item{epithelial_cellsize}{as integer from 1 - 10}
\item{bare_nuclei}{as integer from 1 - 10, includes 16 missings}
\item{chromatin}{as integer from 1 - 10}
\item{normal_nucleoli}{as integer from 1 - 10}
\item{mitoses}{as integer from 1 - 10}
\item{class}{benign or malignant}
}
}
\description{
Dataset containing the original Wisconsin breast cancer data.
}
\examples{

data(bcancer)
aggr(bcancer)

}
\references{
The data downloaded and conditioned for R from the UCI machine learning repository,
see https://archive.ics.uci.edu/ml/datasets/Breast+Cancer+Wisconsin+(Original)
This breast cancer databases was obtained from the University of Wisconsin Hospitals,
Madison from Dr. William H. Wolberg. If you publish results when using this database,
then please include this information in your acknowledgements.
Also, please cite one or more of:
O. L. Mangasarian and W. H. Wolberg: "Cancer diagnosis via linear programming",
SIAM News, Volume 23, Number 5, September 1990, pp 1 & 18.
William H. Wolberg and O.L. Mangasarian:
"Multisurface method of pattern separation for medical diagnosis applied to breast cytology",
Proceedings of the National Academy of Sciences, U.S.A., Volume 87, December 1990, pp 9193-9196.
O. L. Mangasarian, R. Setiono, and W.H. Wolberg:
"Pattern recognition via linear programming: Theory and application to medical diagnosis",
in: "Large-scale numerical optimization", Thomas F. Coleman and Yuying Li, editors,
SIAM Publications, Philadelphia 1990, pp 22-30.
K. P. Bennett & O. L. Mangasarian:
"Robust linear programming discrimination of two linearly inseparable sets",
Optimization Methods and Software 1, 1992, 23-34 (Gordon & Breach Science Publishers).
}
\keyword{datasets}
