% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assay.R, R/assay5.R,
%   R/dimreduc.R, R/seurat.R
\name{Key}
\alias{Key}
\alias{Keys}
\alias{Key<-}
\alias{Key.Assay}
\alias{Key<-.Assay}
\alias{Key.Assay5}
\alias{Key<-.Assay5}
\alias{Key.DimReduc}
\alias{Key<-.DimReduc}
\alias{Key.Seurat}
\alias{Keys.Seurat}
\title{Get and set object keys}
\usage{
Key(object, ...)

Keys(object, ...)

Key(object, ...) <- value

\method{Key}{Assay}(object, ...)

\method{Key}{Assay}(object, ...) <- value

\method{Key}{Assay5}(object, ...)

\method{Key}{Assay5}(object, ...) <- value

\method{Key}{DimReduc}(object, ...)

\method{Key}{DimReduc}(object, ...) <- value

\method{Key}{Seurat}(object, ...)

\method{Keys}{Seurat}(object, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{value}{Key value}
}
\value{
\code{Key}: the object key

\code{Keys}: a named vector of keys of sub-objects

\code{Key<-}: \code{object} with an updated key
}
\description{
Get and set object keys
}
\examples{
# Get an Assay key
Key(pbmc_small[["RNA"]])

# Set the key for an Assay
Key(pbmc_small[["RNA"]]) <- "newkey_"
Key(pbmc_small[["RNA"]])

# Get a DimReduc key
Key(object = pbmc_small[["pca"]])

# Set the key for DimReduc
Key(object = pbmc_small[["pca"]]) <- "newkey2_"
Key(object = pbmc_small[["pca"]])

# Show all keys associated with a Seurat object
Key(object = pbmc_small)
Keys(object = pbmc_small)

}
\concept{data-access}
