% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_vcovG.R
\name{vcovSCC}
\alias{vcovSCC}
\alias{vcovSCC.plm}
\alias{vcovSCC.pcce}
\title{\insertCite{DRIS:KRAA:98;textual}{plm} Robust Covariance Matrix
Estimator}
\usage{
vcovSCC(x, ...)

\method{vcovSCC}{plm}(
  x,
  type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  cluster = "time",
  maxlag = NULL,
  inner = c("cluster", "white", "diagavg"),
  wj = function(j, maxlag) 1 - j/(maxlag + 1),
  ...
)

\method{vcovSCC}{pcce}(
  x,
  type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  cluster = "time",
  maxlag = NULL,
  inner = c("cluster", "white", "diagavg"),
  wj = function(j, maxlag) 1 - j/(maxlag + 1),
  ...
)
}
\arguments{
\item{x}{an object of class \code{"plm"} or \code{"pcce"}}

\item{\dots}{further arguments}

\item{type}{the weighting scheme used, one of \code{"HC0"}, \code{"sss"},
\code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, see Details,}

\item{cluster}{switch for vcovG; set at \code{"time"} here,}

\item{maxlag}{either \code{NULL} or a positive integer specifying the
maximum lag order before truncation}

\item{inner}{the function to be applied to the residuals inside the
sandwich: \code{"cluster"} for SCC, \code{"white"} for Newey-West,
(\code{"diagavg"} for compatibility reasons)}

\item{wj}{weighting function to be applied to lagged terms,}
}
\value{
An object of class \code{"matrix"} containing the estimate of
the covariance matrix of coefficients.
}
\description{
Nonparametric robust covariance matrix estimators \emph{a la
Driscoll and Kraay} for panel models with cross-sectional
\emph{and} serial correlation.
}
\details{
\code{vcovSCC} is a function for estimating a robust covariance matrix
of parameters for a panel model according to the
\insertCite{DRIS:KRAA:98;textual}{plm} method, which is consistent
with cross--sectional and serial correlation in a T-asymptotic
setting and irrespective of the N dimension. The use with random
effects models is undocumented.

Weighting schemes specified by \code{type} are analogous to those in
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} in package \CRANpkg{sandwich} and are
justified theoretically (although in the context of the standard
linear model) by \insertCite{MACK:WHIT:85;textual}{plm} and
\insertCite{CRIB:04;textual}{plm} \insertCite{@see @ZEIL:04}{plm}).

The main use of \code{vcovSCC} is to be an argument to other functions,
e.g.  for Wald--type testing: argument \code{vcov.} to \code{coeftest()},
argument \code{vcov} to \code{waldtest()} and other methods in the
\CRANpkg{lmtest} package; and argument \code{vcov.} to
\code{linearHypothesis()} in the \CRANpkg{car} package (see the
examples). Notice that the \code{vcov} and \code{vcov.} arguments allow to
supply a function (which is the safest) or a matrix
\insertCite{@see @ZEIL:04, 4.1-2 and examples below}{plm}.
}
\examples{

library(lmtest)
library(car)
data("Produc", package="plm")
zz <- plm(log(gsp)~log(pcap)+log(pc)+log(emp)+unemp, data=Produc, model="pooling")
## standard coefficient significance test
coeftest(zz)
## SCC robust significance test, default
coeftest(zz, vcov.=vcovSCC)
## idem with parameters, pass vcov as a function argument
coeftest(zz, vcov.=function(x) vcovSCC(x, type="HC1", maxlag=4))
## joint restriction test
waldtest(zz, update(zz, .~.-log(emp)-unemp), vcov=vcovSCC)
## test of hyp.: 2*log(pc)=log(emp)
linearHypothesis(zz, "2*log(pc)=log(emp)", vcov.=vcovSCC)

}
\references{
\insertRef{CRIB:04}{plm}

\insertRef{DRIS:KRAA:98}{plm}

\insertRef{HOEC:07}{plm}

\insertRef{MACK:WHIT:85}{plm}

\insertRef{ZEIL:04}{plm}
}
\seealso{
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} from the \CRANpkg{sandwich}
package for weighting schemes (\code{type} argument).
}
\author{
Giovanni Millo, partially ported from Daniel Hoechle's
(2007) Stata code
}
\keyword{regression}
