% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkParamSet.R
\name{checkParamSet}
\alias{checkParamSet}
\title{Sanity check expressions of a parameter set.}
\usage{
checkParamSet(par.set, dict = NULL)
}
\arguments{
\item{par.set}{\link{ParamSet}\cr
Parameter set.}

\item{dict}{(\code{environment} | \link{list} | \code{NULL})\cr
Environment or list which will be used for evaluating the variables of
expressions within a parameter, parameter set or list of parameters. The
default is \code{NULL}.}
}
\value{
\code{\link{TRUE}} on success. An exception is raised otherwise.
}
\description{
Checks whether the default values of the numerical parameters are located
within the corresponding boundaries. In case of discrete parameters it
checks whether the values are a subset of the parameter's possible values.
}
\examples{
ps = makeParamSet(
  makeNumericParam("u", lower = expression(p)),
  makeIntegerParam("v", lower = 1, upper = expression(3 * p)),
  makeDiscreteParam("w", default = expression(z), values = c("a", "b")),
  makeDiscreteParam("x", default = "a", values = c("a", "b")),
  keys = c("p", "z")
)
checkParamSet(ps, dict = list(p = 3, z = "b"))
}
