% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_api-11.MulticoreFutureBackend-class.R
\name{requestCore}
\alias{requestCore}
\title{Request a core for multicore processing}
\usage{
requestCore(
  await,
  workers = availableCores(constraints = "multicore"),
  timeout,
  delta,
  alpha
)
}
\arguments{
\item{await}{A function used to try to "collect"
finished multicore subprocesses.}

\item{workers}{Total number of workers available.}

\item{timeout}{Maximum waiting time (in seconds) allowed
before a timeout error is generated.}

\item{delta}{Then base interval (in seconds) to wait
between each try.}

\item{alpha}{A multiplicative factor used to increase
the wait interval after each try.}
}
\value{
Invisible TRUE. If no cores are available after
extensive waiting, then a timeout error is thrown.
}
\description{
If no cores are available, the current process
blocks until a core is available.
}
\keyword{internal}
