##'
##' This package provides functions to construct evolutionary
##' multiobjective optimization algorithms (EMOA). The long term goal
##' is to also provide standard implementations of the most common
##' EMOA in use today.
##'
##' Without the hard work of many researchers who have published their
##' source code under a liberal license, this package would not have
##' been possible. In alphabetical order they are
##'
##' \itemize{
##'   \item Michael H. Buselli
##'   \item Wessel Dankers
##'   \item Carlos Fonseca
##'   \item Joshua Knowles
##'   \item Huang Ling
##'   \item Wudong Liu
##'   \item Manuel Lopez-Ibanez
##'   \item Luis Paquete
##'   \item Ponnuthurai Nagaratnam Suganthany
##'   \item Santosh Tiwar
##'   \item Qingfu Zhang
##'   \item Aimin Zhou
##'   \item Shizheng Zhaoy
##' }
##' 
##' @docType package
##' @name emoa-package
##' @title The EMOA package
##' @author Olaf Mersmann \email{olafm@@statistik.tu-dortmund.de}
##' @keywords package
##' @useDynLib emoa do_which_points_on_edge
##' @useDynLib emoa do_hv_contrib
##' @useDynLib emoa do_dominated_hypervolume
##' @useDynLib emoa do_crowding_distance
##' @useDynLib emoa do_is_dominated
##' @useDynLib emoa nondominated_order
##' @useDynLib emoa do_eps_ind
##' @useDynLib emoa do_r_ind
##' @useDynLib emoa do_unary_r2_ind
##' @useDynLib emoa do_pm
##' @useDynLib emoa do_sbx
##' @useDynLib emoa do_sympart
##' @useDynLib emoa do_dominance_matrix
##'
##' @importFrom graphics par
##' @importFrom stats runif
NA
