#' Dimensionality Reduction via Regression.
#'
#' DRR implements the Dimensionality Reduction via Regression using
#' Kernel Ridge Regression. It also adds a faster implementation of
#' Kernel Ridge regression that can be used with the CVST package.
#'
#' Thanks to the Max Planck Institute for Biogeochemistry in Jena for
#' the funding.
#'
#' @references
#' Laparra, V., Malo, J., Camps-Valls, G., 2015. Dimensionality
#'     Reduction via Regression in Hyperspectral Imagery. IEEE Journal
#'     of Selected Topics in Signal Processing 9,
#'     1026-1036. doi:10.1109/JSTSP.2015.2417833
#' Zhang, Y., Duchi, J.C., Wainwright, M.J., 2013. Divide and Conquer
#'     Kernel Ridge Regression: A Distributed Algorithm with Minimax
#'     Optimal Rates. arXiv:1305.5029 [cs, math, stat].
#'
#' @docType package
"_PACKAGE"

