% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doby_utilities.R
\name{renameCol}
\alias{renameCol}
\title{Rename columns in a matrix or a dataframe.}
\usage{
renameCol(indata, src, tgt)
}
\arguments{
\item{indata}{A dataframe or a matrix}

\item{src}{Source: Vector of names of columns in \code{indata} to be
renamed. Can also be a vector of column numbers.}

\item{tgt}{Target: Vector with corresponding new names in the
output.}
}
\value{
A dataframe if \code{indata} is a dataframe; a matrix in
\code{indata} is a matrix.
}
\description{
Rename columns in a matrix or a dataframe.
}
\examples{
renameCol(CO2, 1:2, c("kk", "ll"))
renameCol(CO2, c("Plant", "Type"), c("kk", "ll"))

# These fail - as they should:
# renameCol(CO2, c("Plant", "Type", "conc"), c("kk", "ll"))
# renameCol(CO2, c("Plant", "Type", "Plant"), c("kk", "ll"))

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utitlities}
